/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.bpmn.deployer;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.bpmn.model.UserTask;
import org.activiti.bpmn.model.ValuedDataObject;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.impl.persistence.deploy.ProcessDefinitionCacheEntry;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.Job;
import org.activiti5.engine.ActivitiException;
import org.activiti5.engine.DynamicBpmnService;
import org.activiti5.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti5.engine.impl.bpmn.parser.BpmnParse;
import org.activiti5.engine.impl.bpmn.parser.BpmnParser;
import org.activiti5.engine.impl.bpmn.parser.EventSubscriptionDeclaration;
import org.activiti5.engine.impl.cfg.IdGenerator;
import org.activiti5.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti5.engine.impl.cmd.CancelJobsCmd;
import org.activiti5.engine.impl.context.Context;
import org.activiti5.engine.impl.db.DbSqlSession;
import org.activiti5.engine.impl.el.ExpressionManager;
import org.activiti5.engine.impl.interceptor.CommandContext;
import org.activiti5.engine.impl.jobexecutor.TimerDeclarationImpl;
import org.activiti5.engine.impl.persistence.deploy.Deployer;
import org.activiti5.engine.impl.persistence.deploy.DeploymentManager;
import org.activiti5.engine.impl.persistence.deploy.ProcessDefinitionInfoCacheObject;
import org.activiti5.engine.impl.persistence.entity.DeploymentEntity;
import org.activiti5.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.activiti5.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti5.engine.impl.persistence.entity.MessageEventSubscriptionEntity;
import org.activiti5.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti5.engine.impl.persistence.entity.ProcessDefinitionEntityManager;
import org.activiti5.engine.impl.persistence.entity.ProcessDefinitionInfoEntity;
import org.activiti5.engine.impl.persistence.entity.ProcessDefinitionInfoEntityManager;
import org.activiti5.engine.impl.persistence.entity.ResourceEntity;
import org.activiti5.engine.impl.persistence.entity.SignalEventSubscriptionEntity;
import org.activiti5.engine.impl.persistence.entity.TimerJobEntity;
import org.activiti5.engine.impl.util.IoUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BpmnDeployer
implements Deployer {
    private static final Logger log = LoggerFactory.getLogger(BpmnDeployer.class);
    public static final String[] BPMN_RESOURCE_SUFFIXES = new String[]{"bpmn20.xml", "bpmn"};
    public static final String[] DIAGRAM_SUFFIXES = new String[]{"png", "jpg", "gif", "svg"};
    protected ExpressionManager expressionManager;
    protected BpmnParser bpmnParser;
    protected IdGenerator idGenerator;

    @Override
    public void deploy(DeploymentEntity deployment, Map<String, Object> deploymentSettings) {
        log.debug("Processing deployment {}", (Object)deployment.getName());
        ArrayList<ProcessDefinitionEntity> processDefinitions = new ArrayList<ProcessDefinitionEntity>();
        Map<String, ResourceEntity> resources = deployment.getResources();
        HashMap<String, BpmnModel> bpmnModelMap = new HashMap<String, BpmnModel>();
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        for (String resourceName : resources.keySet()) {
            log.info("Processing resource {}", (Object)resourceName);
            if (!this.isBpmnResource(resourceName)) continue;
            ResourceEntity resource = resources.get(resourceName);
            byte[] bytes = resource.getBytes();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
            BpmnParse bpmnParse = this.bpmnParser.createParse().sourceInputStream(inputStream).setSourceSystemId(resourceName).deployment(deployment).name(resourceName);
            if (deploymentSettings != null) {
                if (deploymentSettings.containsKey("isBpmn20XsdValidationEnabled")) {
                    bpmnParse.setValidateSchema((Boolean)deploymentSettings.get("isBpmn20XsdValidationEnabled"));
                }
                if (deploymentSettings.containsKey("isProcessValidationEnabled")) {
                    bpmnParse.setValidateProcess((Boolean)deploymentSettings.get("isProcessValidationEnabled"));
                }
            } else {
                bpmnParse.setValidateSchema(false);
                bpmnParse.setValidateProcess(false);
            }
            bpmnParse.execute();
            for (ProcessDefinitionEntity processDefinition : bpmnParse.getProcessDefinitions()) {
                processDefinition.setResourceName(resourceName);
                if (deployment.getTenantId() != null) {
                    processDefinition.setTenantId(deployment.getTenantId());
                }
                String diagramResourceName = this.getDiagramResourceForProcess(resourceName, processDefinition.getKey(), resources);
                if (deployment.isNew() && processEngineConfiguration.isCreateDiagramOnDeploy() && diagramResourceName == null && processDefinition.isGraphicalNotationDefined()) {
                    try {
                        byte[] diagramBytes = IoUtil.readInputStream(processEngineConfiguration.getProcessDiagramGenerator().generateDiagram(bpmnParse.getBpmnModel(), "png", processEngineConfiguration.getActivityFontName(), processEngineConfiguration.getLabelFontName(), processEngineConfiguration.getAnnotationFontName(), processEngineConfiguration.getClassLoader()), null);
                        diagramResourceName = this.getProcessImageResourceName(resourceName, processDefinition.getKey(), "png");
                        this.createResource(diagramResourceName, diagramBytes, deployment);
                    }
                    catch (Throwable t) {
                        log.warn("Error while generating process diagram, image will not be stored in repository", t);
                    }
                }
                processDefinition.setDiagramResourceName(diagramResourceName);
                processDefinition.setEngineVersion("activiti-5");
                processDefinitions.add(processDefinition);
                bpmnModelMap.put(processDefinition.getKey(), bpmnParse.getBpmnModel());
            }
        }
        ArrayList<String> keyList = new ArrayList<String>();
        for (ProcessDefinitionEntity processDefinition : processDefinitions) {
            if (keyList.contains(processDefinition.getKey())) {
                throw new ActivitiException("The deployment contains process definitions with the same key '" + processDefinition.getKey() + "' (process id atrribute), this is not allowed");
            }
            keyList.add(processDefinition.getKey());
        }
        CommandContext commandContext = Context.getCommandContext();
        ProcessDefinitionEntityManager processDefinitionManager = commandContext.getProcessDefinitionEntityManager();
        DbSqlSession dbSqlSession = commandContext.getSession(DbSqlSession.class);
        for (ProcessDefinitionEntity processDefinition : processDefinitions) {
            ArrayList<TimerJobEntity> timers = new ArrayList<TimerJobEntity>();
            if (deployment.isNew()) {
                ProcessDefinitionEntity latestProcessDefinition = null;
                latestProcessDefinition = processDefinition.getTenantId() != null && !"".equals(processDefinition.getTenantId()) ? processDefinitionManager.findLatestProcessDefinitionByKeyAndTenantId(processDefinition.getKey(), processDefinition.getTenantId()) : processDefinitionManager.findLatestProcessDefinitionByKey(processDefinition.getKey());
                int processDefinitionVersion = latestProcessDefinition != null ? latestProcessDefinition.getVersion() + 1 : 1;
                processDefinition.setVersion(processDefinitionVersion);
                processDefinition.setDeploymentId(deployment.getId());
                String nextId = this.idGenerator.getNextId();
                String processDefinitionId = processDefinition.getKey() + ":" + processDefinition.getVersion() + ":" + nextId;
                if (processDefinitionId.length() > 64) {
                    processDefinitionId = nextId;
                }
                processDefinition.setId(processDefinitionId);
                this.addProcessDefinitionToCache(processDefinition, bpmnModelMap, processEngineConfiguration, commandContext);
                if (commandContext.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
                    commandContext.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_CREATED, processDefinition));
                }
                this.removeObsoleteTimers(processDefinition);
                this.addTimerDeclarations(processDefinition, timers);
                this.removeExistingMessageEventSubscriptions(processDefinition, latestProcessDefinition);
                this.addMessageEventSubscriptions(processDefinition);
                this.removeExistingSignalEventSubScription(processDefinition, latestProcessDefinition);
                this.addSignalEventSubscriptions(processDefinition);
                dbSqlSession.insert(processDefinition);
                this.addAuthorizations(processDefinition);
                if (commandContext.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
                    commandContext.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_INITIALIZED, processDefinition));
                }
                this.scheduleTimers(timers);
            } else {
                String deploymentId = deployment.getId();
                processDefinition.setDeploymentId(deploymentId);
                ProcessDefinitionEntity persistedProcessDefinition = null;
                persistedProcessDefinition = processDefinition.getTenantId() == null || "".equals(processDefinition.getTenantId()) ? processDefinitionManager.findProcessDefinitionByDeploymentAndKey(deploymentId, processDefinition.getKey()) : processDefinitionManager.findProcessDefinitionByDeploymentAndKeyAndTenantId(deploymentId, processDefinition.getKey(), processDefinition.getTenantId());
                if (persistedProcessDefinition != null) {
                    processDefinition.setId(persistedProcessDefinition.getId());
                    processDefinition.setVersion(persistedProcessDefinition.getVersion());
                    processDefinition.setSuspensionState(persistedProcessDefinition.getSuspensionState());
                }
                this.addProcessDefinitionToCache(processDefinition, bpmnModelMap, processEngineConfiguration, commandContext);
            }
            deployment.addDeployedArtifact(processDefinition);
            this.createLocalizationValues(processDefinition.getId(), ((BpmnModel)bpmnModelMap.get(processDefinition.getKey())).getProcessById(processDefinition.getKey()));
        }
    }

    protected void addProcessDefinitionToCache(ProcessDefinitionEntity processDefinition, Map<String, BpmnModel> bpmnModelMap, ProcessEngineConfigurationImpl processEngineConfiguration, CommandContext commandContext) {
        DeploymentManager deploymentManager = processEngineConfiguration.getDeploymentManager();
        BpmnModel bpmnModel = bpmnModelMap.get(processDefinition.getKey());
        ProcessDefinitionCacheEntry cacheEntry = new ProcessDefinitionCacheEntry((ProcessDefinition)processDefinition, bpmnModel, bpmnModel.getProcessById(processDefinition.getKey()));
        deploymentManager.getProcessDefinitionCache().add(processDefinition.getId(), (Object)cacheEntry);
        this.addDefinitionInfoToCache(processDefinition, processEngineConfiguration, commandContext);
    }

    protected void addDefinitionInfoToCache(ProcessDefinitionEntity processDefinition, ProcessEngineConfigurationImpl processEngineConfiguration, CommandContext commandContext) {
        byte[] infoBytes;
        if (!processEngineConfiguration.isEnableProcessDefinitionInfoCache()) {
            return;
        }
        DeploymentManager deploymentManager = processEngineConfiguration.getDeploymentManager();
        ProcessDefinitionInfoEntityManager definitionInfoEntityManager = commandContext.getProcessDefinitionInfoEntityManager();
        ObjectMapper objectMapper = commandContext.getProcessEngineConfiguration().getObjectMapper();
        ProcessDefinitionInfoEntity definitionInfoEntity = definitionInfoEntityManager.findProcessDefinitionInfoByProcessDefinitionId(processDefinition.getId());
        ObjectNode infoNode = null;
        if (definitionInfoEntity != null && definitionInfoEntity.getInfoJsonId() != null && (infoBytes = definitionInfoEntityManager.findInfoJsonById(definitionInfoEntity.getInfoJsonId())) != null) {
            try {
                infoNode = (ObjectNode)objectMapper.readTree(infoBytes);
            }
            catch (Exception e) {
                throw new ActivitiException("Error deserializing json info for process definition " + processDefinition.getId());
            }
        }
        ProcessDefinitionInfoCacheObject definitionCacheObject = new ProcessDefinitionInfoCacheObject();
        if (definitionInfoEntity == null) {
            definitionCacheObject.setRevision(0);
        } else {
            definitionCacheObject.setId(definitionInfoEntity.getId());
            definitionCacheObject.setRevision(definitionInfoEntity.getRevision());
        }
        if (infoNode == null) {
            infoNode = objectMapper.createObjectNode();
        }
        definitionCacheObject.setInfoNode(infoNode);
        deploymentManager.getProcessDefinitionInfoCache().add(processDefinition.getId(), definitionCacheObject);
    }

    private void scheduleTimers(List<TimerJobEntity> timers) {
        for (TimerJobEntity timer : timers) {
            Context.getCommandContext().getJobEntityManager().schedule(timer);
        }
    }

    protected void addTimerDeclarations(ProcessDefinitionEntity processDefinition, List<TimerJobEntity> timers) {
        List timerDeclarations = (List)processDefinition.getProperty("timerStart");
        if (timerDeclarations != null) {
            for (TimerDeclarationImpl timerDeclaration : timerDeclarations) {
                TimerJobEntity timer = timerDeclaration.prepareTimerEntity(null);
                if (timer == null) continue;
                timer.setProcessDefinitionId(processDefinition.getId());
                if (processDefinition.getTenantId() != null) {
                    timer.setTenantId(processDefinition.getTenantId());
                }
                timers.add(timer);
            }
        }
    }

    protected void removeObsoleteTimers(ProcessDefinitionEntity processDefinition) {
        List<Job> jobsToDelete = null;
        jobsToDelete = processDefinition.getTenantId() != null && !"".equals(processDefinition.getTenantId()) ? Context.getCommandContext().getTimerJobEntityManager().findTimerJobsByTypeAndProcessDefinitionKeyAndTenantId("timer-start-event", processDefinition.getKey(), processDefinition.getTenantId()) : Context.getCommandContext().getTimerJobEntityManager().findTimerJobsByTypeAndProcessDefinitionKeyNoTenantId("timer-start-event", processDefinition.getKey());
        if (jobsToDelete != null) {
            for (Job job : jobsToDelete) {
                new CancelJobsCmd(job.getId()).execute(Context.getCommandContext());
            }
        }
    }

    protected void removeExistingMessageEventSubscriptions(ProcessDefinitionEntity processDefinition, ProcessDefinitionEntity latestProcessDefinition) {
        if (latestProcessDefinition != null) {
            CommandContext commandContext = Context.getCommandContext();
            List<EventSubscriptionEntity> subscriptionsToDelete = commandContext.getEventSubscriptionEntityManager().findEventSubscriptionsByTypeAndProcessDefinitionId("message", latestProcessDefinition.getId(), latestProcessDefinition.getTenantId());
            for (EventSubscriptionEntity eventSubscriptionEntity : subscriptionsToDelete) {
                eventSubscriptionEntity.delete();
            }
        }
    }

    protected void addMessageEventSubscriptions(ProcessDefinitionEntity processDefinition) {
        CommandContext commandContext = Context.getCommandContext();
        List eventDefinitions = (List)processDefinition.getProperty("eventDefinitions");
        if (eventDefinitions != null) {
            HashSet<String> messageNames = new HashSet<String>();
            for (EventSubscriptionDeclaration eventDefinition : eventDefinitions) {
                if (!eventDefinition.getEventType().equals("message") || !eventDefinition.isStartEvent()) continue;
                if (messageNames.contains(eventDefinition.getEventName())) {
                    throw new ActivitiException("Cannot deploy process definition '" + processDefinition.getResourceName() + "': there multiple message event subscriptions for the message with name '" + eventDefinition.getEventName() + "'.");
                }
                messageNames.add(eventDefinition.getEventName());
                List<EventSubscriptionEntity> subscriptionsForSameMessageName = commandContext.getEventSubscriptionEntityManager().findEventSubscriptionsByName("message", eventDefinition.getEventName(), processDefinition.getTenantId());
                List<MessageEventSubscriptionEntity> cachedSubscriptions = commandContext.getDbSqlSession().findInCache(MessageEventSubscriptionEntity.class);
                for (MessageEventSubscriptionEntity cachedSubscription : cachedSubscriptions) {
                    if (!eventDefinition.getEventName().equals(cachedSubscription.getEventName()) || subscriptionsForSameMessageName.contains(cachedSubscription)) continue;
                    subscriptionsForSameMessageName.add(cachedSubscription);
                }
                subscriptionsForSameMessageName = commandContext.getDbSqlSession().pruneDeletedEntities(subscriptionsForSameMessageName);
                for (EventSubscriptionEntity eventSubscriptionEntity : subscriptionsForSameMessageName) {
                    if (eventSubscriptionEntity.getProcessInstanceId() != null && !eventSubscriptionEntity.getProcessInstanceId().isEmpty()) continue;
                    throw new ActivitiException("Cannot deploy process definition '" + processDefinition.getResourceName() + "': there already is a message event subscription for the message with name '" + eventDefinition.getEventName() + "'.");
                }
                MessageEventSubscriptionEntity newSubscription = new MessageEventSubscriptionEntity();
                newSubscription.setEventName(eventDefinition.getEventName());
                newSubscription.setActivityId(eventDefinition.getActivityId());
                newSubscription.setConfiguration(processDefinition.getId());
                newSubscription.setProcessDefinitionId(processDefinition.getId());
                if (processDefinition.getTenantId() != null) {
                    newSubscription.setTenantId(processDefinition.getTenantId());
                }
                newSubscription.insert();
            }
        }
    }

    protected void removeExistingSignalEventSubScription(ProcessDefinitionEntity processDefinition, ProcessDefinitionEntity latestProcessDefinition) {
        if (latestProcessDefinition != null) {
            CommandContext commandContext = Context.getCommandContext();
            List<EventSubscriptionEntity> subscriptionsToDelete = commandContext.getEventSubscriptionEntityManager().findEventSubscriptionsByTypeAndProcessDefinitionId("signal", latestProcessDefinition.getId(), latestProcessDefinition.getTenantId());
            for (EventSubscriptionEntity eventSubscriptionEntity : subscriptionsToDelete) {
                eventSubscriptionEntity.delete();
            }
        }
    }

    protected void addSignalEventSubscriptions(ProcessDefinitionEntity processDefinition) {
        List eventDefinitions = (List)processDefinition.getProperty("eventDefinitions");
        if (eventDefinitions != null) {
            for (EventSubscriptionDeclaration eventDefinition : eventDefinitions) {
                if (!eventDefinition.getEventType().equals("signal") || !eventDefinition.isStartEvent()) continue;
                SignalEventSubscriptionEntity subscriptionEntity = new SignalEventSubscriptionEntity();
                subscriptionEntity.setEventName(eventDefinition.getEventName());
                subscriptionEntity.setActivityId(eventDefinition.getActivityId());
                subscriptionEntity.setProcessDefinitionId(processDefinition.getId());
                if (processDefinition.getTenantId() != null) {
                    subscriptionEntity.setTenantId(processDefinition.getTenantId());
                }
                subscriptionEntity.insert();
            }
        }
    }

    protected void createLocalizationValues(String processDefinitionId, Process process) {
        if (process == null) {
            return;
        }
        CommandContext commandContext = Context.getCommandContext();
        DynamicBpmnService dynamicBpmnService = commandContext.getProcessEngineConfiguration().getDynamicBpmnService();
        ObjectNode infoNode = dynamicBpmnService.getProcessDefinitionInfo(processDefinitionId);
        boolean localizationValuesChanged = false;
        List localizationElements = (List)process.getExtensionElements().get("localization");
        if (localizationElements != null) {
            for (ExtensionElement localizationElement : localizationElements) {
                String processId;
                Iterator i$;
                if (!"activiti".equals(localizationElement.getNamespacePrefix())) continue;
                String locale = localizationElement.getAttributeValue(null, "locale");
                String name = localizationElement.getAttributeValue(null, "name");
                String documentation = null;
                List documentationElements = (List)localizationElement.getChildElements().get("documentation");
                if (documentationElements != null && (i$ = documentationElements.iterator()).hasNext()) {
                    ExtensionElement documentationElement = (ExtensionElement)i$.next();
                    documentation = StringUtils.trimToNull((String)documentationElement.getElementText());
                }
                if (!this.isEqualToCurrentLocalizationValue(locale, processId = process.getId(), "name", name, infoNode)) {
                    dynamicBpmnService.changeLocalizationName(locale, processId, name, infoNode);
                    localizationValuesChanged = true;
                }
                if (documentation == null || this.isEqualToCurrentLocalizationValue(locale, processId, "description", documentation, infoNode)) break;
                dynamicBpmnService.changeLocalizationDescription(locale, processId, documentation, infoNode);
                localizationValuesChanged = true;
                break;
            }
        }
        boolean isFlowElementLocalizationChanged = this.localizeFlowElements(process.getFlowElements(), infoNode);
        boolean isDataObjectLocalizationChanged = this.localizeDataObjectElements(process.getDataObjects(), infoNode);
        if (isFlowElementLocalizationChanged || isDataObjectLocalizationChanged) {
            localizationValuesChanged = true;
        }
        if (localizationValuesChanged) {
            dynamicBpmnService.saveProcessDefinitionInfo(processDefinitionId, infoNode);
        }
    }

    protected boolean localizeFlowElements(Collection<FlowElement> flowElements, ObjectNode infoNode) {
        boolean localizationValuesChanged = false;
        if (flowElements == null) {
            return localizationValuesChanged;
        }
        CommandContext commandContext = Context.getCommandContext();
        DynamicBpmnService dynamicBpmnService = commandContext.getProcessEngineConfiguration().getDynamicBpmnService();
        for (FlowElement flowElement : flowElements) {
            if (!(flowElement instanceof UserTask) && !(flowElement instanceof SubProcess)) continue;
            List localizationElements = (List)flowElement.getExtensionElements().get("localization");
            if (localizationElements != null) {
                for (ExtensionElement localizationElement : localizationElements) {
                    String flowElementId;
                    Iterator i$;
                    if (!"activiti".equals(localizationElement.getNamespacePrefix())) continue;
                    String locale = localizationElement.getAttributeValue(null, "locale");
                    String name = localizationElement.getAttributeValue(null, "name");
                    String documentation = null;
                    List documentationElements = (List)localizationElement.getChildElements().get("documentation");
                    if (documentationElements != null && (i$ = documentationElements.iterator()).hasNext()) {
                        ExtensionElement documentationElement = (ExtensionElement)i$.next();
                        documentation = StringUtils.trimToNull((String)documentationElement.getElementText());
                    }
                    if (!this.isEqualToCurrentLocalizationValue(locale, flowElementId = flowElement.getId(), "name", name, infoNode)) {
                        dynamicBpmnService.changeLocalizationName(locale, flowElementId, name, infoNode);
                        localizationValuesChanged = true;
                    }
                    if (documentation == null || this.isEqualToCurrentLocalizationValue(locale, flowElementId, "description", documentation, infoNode)) break;
                    dynamicBpmnService.changeLocalizationDescription(locale, flowElementId, documentation, infoNode);
                    localizationValuesChanged = true;
                    break;
                }
            }
            if (!(flowElement instanceof SubProcess)) continue;
            SubProcess subprocess = (SubProcess)flowElement;
            boolean isFlowElementLocalizationChanged = this.localizeFlowElements(subprocess.getFlowElements(), infoNode);
            boolean isDataObjectLocalizationChanged = this.localizeDataObjectElements(subprocess.getDataObjects(), infoNode);
            if (!isFlowElementLocalizationChanged && !isDataObjectLocalizationChanged) continue;
            localizationValuesChanged = true;
        }
        return localizationValuesChanged;
    }

    protected boolean isEqualToCurrentLocalizationValue(String language, String id, String propertyName, String propertyValue, ObjectNode infoNode) {
        boolean isEqual = false;
        JsonNode localizationNode = infoNode.path("localization").path(language).path(id).path(propertyName);
        if (!localizationNode.isMissingNode() && !localizationNode.isNull() && localizationNode.asText().equals(propertyValue)) {
            isEqual = true;
        }
        return isEqual;
    }

    protected boolean localizeDataObjectElements(List<ValuedDataObject> dataObjects, ObjectNode infoNode) {
        boolean localizationValuesChanged = false;
        CommandContext commandContext = Context.getCommandContext();
        DynamicBpmnService dynamicBpmnService = commandContext.getProcessEngineConfiguration().getDynamicBpmnService();
        for (ValuedDataObject dataObject : dataObjects) {
            List localizationElements = (List)dataObject.getExtensionElements().get("localization");
            if (localizationElements == null) continue;
            for (ExtensionElement localizationElement : localizationElements) {
                Iterator i$;
                if (!"activiti".equals(localizationElement.getNamespacePrefix())) continue;
                String locale = localizationElement.getAttributeValue(null, "locale");
                String name = localizationElement.getAttributeValue(null, "name");
                String documentation = null;
                List documentationElements = (List)localizationElement.getChildElements().get("documentation");
                if (documentationElements != null && (i$ = documentationElements.iterator()).hasNext()) {
                    ExtensionElement documentationElement = (ExtensionElement)i$.next();
                    documentation = StringUtils.trimToNull((String)documentationElement.getElementText());
                }
                if (name != null && !this.isEqualToCurrentLocalizationValue(locale, dataObject.getName(), "name", name, infoNode)) {
                    dynamicBpmnService.changeLocalizationName(locale, dataObject.getName(), name, infoNode);
                    localizationValuesChanged = true;
                }
                if (documentation == null || this.isEqualToCurrentLocalizationValue(locale, dataObject.getName(), "description", documentation, infoNode)) continue;
                dynamicBpmnService.changeLocalizationDescription(locale, dataObject.getName(), documentation, infoNode);
                localizationValuesChanged = true;
            }
        }
        return localizationValuesChanged;
    }

    private void addAuthorizationsFromIterator(Set<Expression> exprSet, ProcessDefinitionEntity processDefinition, ExprType exprType) {
        if (exprSet != null) {
            for (Expression expr : exprSet) {
                IdentityLinkEntity identityLink = new IdentityLinkEntity();
                identityLink.setProcessDef(processDefinition);
                if (exprType.equals((Object)ExprType.USER)) {
                    identityLink.setUserId(expr.toString());
                } else if (exprType.equals((Object)ExprType.GROUP)) {
                    identityLink.setGroupId(expr.toString());
                }
                identityLink.setType("candidate");
                identityLink.insert();
            }
        }
    }

    protected void addAuthorizations(ProcessDefinitionEntity processDefinition) {
        this.addAuthorizationsFromIterator(processDefinition.getCandidateStarterUserIdExpressions(), processDefinition, ExprType.USER);
        this.addAuthorizationsFromIterator(processDefinition.getCandidateStarterGroupIdExpressions(), processDefinition, ExprType.GROUP);
    }

    protected String getDiagramResourceForProcess(String bpmnFileResource, String processKey, Map<String, ResourceEntity> resources) {
        for (String diagramSuffix : DIAGRAM_SUFFIXES) {
            String diagramForBpmnFileResource = this.getBpmnFileImageResourceName(bpmnFileResource, diagramSuffix);
            String processDiagramResource = this.getProcessImageResourceName(bpmnFileResource, processKey, diagramSuffix);
            if (resources.containsKey(processDiagramResource)) {
                return processDiagramResource;
            }
            if (!resources.containsKey(diagramForBpmnFileResource)) continue;
            return diagramForBpmnFileResource;
        }
        return null;
    }

    protected String getBpmnFileImageResourceName(String bpmnFileResource, String diagramSuffix) {
        String bpmnFileResourceBase = this.stripBpmnFileSuffix(bpmnFileResource);
        return bpmnFileResourceBase + diagramSuffix;
    }

    protected String getProcessImageResourceName(String bpmnFileResource, String processKey, String diagramSuffix) {
        String bpmnFileResourceBase = this.stripBpmnFileSuffix(bpmnFileResource);
        return bpmnFileResourceBase + processKey + "." + diagramSuffix;
    }

    protected String stripBpmnFileSuffix(String bpmnFileResource) {
        for (String suffix : BPMN_RESOURCE_SUFFIXES) {
            if (!bpmnFileResource.endsWith(suffix)) continue;
            return bpmnFileResource.substring(0, bpmnFileResource.length() - suffix.length());
        }
        return bpmnFileResource;
    }

    protected void createResource(String name, byte[] bytes, DeploymentEntity deploymentEntity) {
        ResourceEntity resource = new ResourceEntity();
        resource.setName(name);
        resource.setBytes(bytes);
        resource.setDeploymentId(deploymentEntity.getId());
        resource.setGenerated(true);
        Context.getCommandContext().getDbSqlSession().insert(resource);
    }

    protected boolean isBpmnResource(String resourceName) {
        for (String suffix : BPMN_RESOURCE_SUFFIXES) {
            if (!resourceName.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    public ExpressionManager getExpressionManager() {
        return this.expressionManager;
    }

    public void setExpressionManager(ExpressionManager expressionManager) {
        this.expressionManager = expressionManager;
    }

    public BpmnParser getBpmnParser() {
        return this.bpmnParser;
    }

    public void setBpmnParser(BpmnParser bpmnParser) {
        this.bpmnParser = bpmnParser;
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public void setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    static enum ExprType {
        USER,
        GROUP;

    }
}

