/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl;

import java.util.List;
import org.activiti5.engine.ActivitiIllegalArgumentException;
import org.activiti5.engine.identity.Group;
import org.activiti5.engine.identity.GroupQuery;
import org.activiti5.engine.impl.AbstractQuery;
import org.activiti5.engine.impl.GroupQueryProperty;
import org.activiti5.engine.impl.Page;
import org.activiti5.engine.impl.interceptor.CommandContext;
import org.activiti5.engine.impl.interceptor.CommandExecutor;

public class GroupQueryImpl
extends AbstractQuery<GroupQuery, Group>
implements GroupQuery {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String name;
    protected String nameLike;
    protected String type;
    protected String userId;
    protected String procDefId;

    public GroupQueryImpl() {
    }

    public GroupQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public GroupQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public GroupQuery groupId(String id) {
        if (id == null) {
            throw new ActivitiIllegalArgumentException("Provided id is null");
        }
        this.id = id;
        return this;
    }

    @Override
    public GroupQuery groupName(String name) {
        if (name == null) {
            throw new ActivitiIllegalArgumentException("Provided name is null");
        }
        this.name = name;
        return this;
    }

    @Override
    public GroupQuery groupNameLike(String nameLike) {
        if (nameLike == null) {
            throw new ActivitiIllegalArgumentException("Provided nameLike is null");
        }
        this.nameLike = nameLike;
        return this;
    }

    @Override
    public GroupQuery groupType(String type) {
        if (type == null) {
            throw new ActivitiIllegalArgumentException("Provided type is null");
        }
        this.type = type;
        return this;
    }

    @Override
    public GroupQuery groupMember(String userId) {
        if (userId == null) {
            throw new ActivitiIllegalArgumentException("Provided userId is null");
        }
        this.userId = userId;
        return this;
    }

    @Override
    public GroupQuery potentialStarter(String procDefId) {
        if (procDefId == null) {
            throw new ActivitiIllegalArgumentException("Provided processDefinitionId is null or empty");
        }
        this.procDefId = procDefId;
        return this;
    }

    @Override
    public GroupQuery orderByGroupId() {
        return (GroupQuery)this.orderBy(GroupQueryProperty.GROUP_ID);
    }

    @Override
    public GroupQuery orderByGroupName() {
        return (GroupQuery)this.orderBy(GroupQueryProperty.NAME);
    }

    @Override
    public GroupQuery orderByGroupType() {
        return (GroupQuery)this.orderBy(GroupQueryProperty.TYPE);
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getGroupIdentityManager().findGroupCountByQueryCriteria(this);
    }

    @Override
    public List<Group> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        return commandContext.getGroupIdentityManager().findGroupByQueryCriteria(this, page);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getNameLike() {
        return this.nameLike;
    }

    public String getType() {
        return this.type;
    }

    public String getUserId() {
        return this.userId;
    }
}

