/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti5.engine.ActivitiIllegalArgumentException;
import org.activiti5.engine.impl.AbstractVariableQueryImpl;
import org.activiti5.engine.impl.EventSubscriptionQueryValue;
import org.activiti5.engine.impl.ExecutionQueryProperty;
import org.activiti5.engine.impl.Page;
import org.activiti5.engine.impl.context.Context;
import org.activiti5.engine.impl.interceptor.CommandContext;
import org.activiti5.engine.impl.interceptor.CommandExecutor;
import org.activiti5.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti5.engine.impl.persistence.entity.SuspensionState;
import org.activiti5.engine.runtime.Execution;
import org.activiti5.engine.runtime.ExecutionQuery;

public class ExecutionQueryImpl
extends AbstractVariableQueryImpl<ExecutionQuery, Execution>
implements ExecutionQuery {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected String processDefinitionCategory;
    protected String processDefinitionName;
    protected Integer processDefinitionVersion;
    protected String activityId;
    protected String executionId;
    protected String parentId;
    protected String processInstanceId;
    protected List<EventSubscriptionQueryValue> eventSubscriptions;
    protected String tenantId;
    protected String tenantIdLike;
    protected boolean withoutTenantId;
    protected String locale;
    protected boolean withLocalizationFallback;
    protected String superProcessInstanceId;
    protected String subProcessInstanceId;
    protected boolean excludeSubprocesses;
    protected SuspensionState suspensionState;
    protected String businessKey;
    protected boolean includeChildExecutionsWithBusinessKeyQuery;
    protected boolean isActive;
    protected String involvedUser;
    protected Set<String> processDefinitionKeys;
    protected Set<String> processDefinitionIds;
    protected String name;
    protected String nameLike;
    protected String nameLikeIgnoreCase;
    protected String deploymentId;
    protected List<String> deploymentIds;
    protected List<ExecutionQueryImpl> orQueryObjects = new ArrayList<ExecutionQueryImpl>();

    public ExecutionQueryImpl() {
    }

    public ExecutionQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public ExecutionQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    public boolean isProcessInstancesOnly() {
        return false;
    }

    @Override
    public ExecutionQueryImpl processDefinitionId(String processDefinitionId) {
        if (processDefinitionId == null) {
            throw new ActivitiIllegalArgumentException("Process definition id is null");
        }
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Override
    public ExecutionQueryImpl processDefinitionKey(String processDefinitionKey) {
        if (processDefinitionKey == null) {
            throw new ActivitiIllegalArgumentException("Process definition key is null");
        }
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Override
    public ExecutionQuery processDefinitionCategory(String processDefinitionCategory) {
        if (processDefinitionCategory == null) {
            throw new ActivitiIllegalArgumentException("Process definition category is null");
        }
        this.processDefinitionCategory = processDefinitionCategory;
        return this;
    }

    @Override
    public ExecutionQuery processDefinitionName(String processDefinitionName) {
        if (processDefinitionName == null) {
            throw new ActivitiIllegalArgumentException("Process definition name is null");
        }
        this.processDefinitionName = processDefinitionName;
        return this;
    }

    @Override
    public ExecutionQuery processDefinitionVersion(Integer processDefinitionVersion) {
        if (processDefinitionVersion == null) {
            throw new ActivitiIllegalArgumentException("Process definition version is null");
        }
        this.processDefinitionVersion = processDefinitionVersion;
        return this;
    }

    @Override
    public ExecutionQueryImpl processInstanceId(String processInstanceId) {
        if (processInstanceId == null) {
            throw new ActivitiIllegalArgumentException("Process instance id is null");
        }
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Override
    public ExecutionQuery processInstanceBusinessKey(String businessKey) {
        if (businessKey == null) {
            throw new ActivitiIllegalArgumentException("Business key is null");
        }
        this.businessKey = businessKey;
        return this;
    }

    @Override
    public ExecutionQuery processInstanceBusinessKey(String processInstanceBusinessKey, boolean includeChildExecutions) {
        if (!includeChildExecutions) {
            return this.processInstanceBusinessKey(processInstanceBusinessKey);
        }
        if (processInstanceBusinessKey == null) {
            throw new ActivitiIllegalArgumentException("Business key is null");
        }
        this.businessKey = processInstanceBusinessKey;
        this.includeChildExecutionsWithBusinessKeyQuery = includeChildExecutions;
        return this;
    }

    @Override
    public ExecutionQuery processDefinitionKeys(Set<String> processDefinitionKeys) {
        if (processDefinitionKeys == null) {
            throw new ActivitiIllegalArgumentException("Process definition keys is null");
        }
        this.processDefinitionKeys = processDefinitionKeys;
        return this;
    }

    @Override
    public ExecutionQueryImpl executionId(String executionId) {
        if (executionId == null) {
            throw new ActivitiIllegalArgumentException("Execution id is null");
        }
        this.executionId = executionId;
        return this;
    }

    @Override
    public ExecutionQueryImpl activityId(String activityId) {
        this.activityId = activityId;
        if (activityId != null) {
            this.isActive = true;
        }
        return this;
    }

    @Override
    public ExecutionQueryImpl parentId(String parentId) {
        if (parentId == null) {
            throw new ActivitiIllegalArgumentException("Parent id is null");
        }
        this.parentId = parentId;
        return this;
    }

    @Override
    public ExecutionQueryImpl executionTenantId(String tenantId) {
        if (tenantId == null) {
            throw new ActivitiIllegalArgumentException("execution tenant id is null");
        }
        this.tenantId = tenantId;
        return this;
    }

    @Override
    public ExecutionQueryImpl executionTenantIdLike(String tenantIdLike) {
        if (tenantIdLike == null) {
            throw new ActivitiIllegalArgumentException("execution tenant id is null");
        }
        this.tenantIdLike = tenantIdLike;
        return this;
    }

    @Override
    public ExecutionQueryImpl executionWithoutTenantId() {
        this.withoutTenantId = true;
        return this;
    }

    @Override
    public ExecutionQuery signalEventSubscription(String signalName) {
        return this.eventSubscription("signal", signalName);
    }

    @Override
    public ExecutionQuery signalEventSubscriptionName(String signalName) {
        return this.eventSubscription("signal", signalName);
    }

    @Override
    public ExecutionQuery messageEventSubscriptionName(String messageName) {
        return this.eventSubscription("message", messageName);
    }

    public ExecutionQuery eventSubscription(String eventType, String eventName) {
        if (eventName == null) {
            throw new ActivitiIllegalArgumentException("event name is null");
        }
        if (eventType == null) {
            throw new ActivitiIllegalArgumentException("event type is null");
        }
        if (this.eventSubscriptions == null) {
            this.eventSubscriptions = new ArrayList<EventSubscriptionQueryValue>();
        }
        this.eventSubscriptions.add(new EventSubscriptionQueryValue(eventName, eventType));
        return this;
    }

    @Override
    public ExecutionQuery processVariableValueEquals(String variableName, Object variableValue) {
        return (ExecutionQuery)this.variableValueEquals(variableName, variableValue, false);
    }

    @Override
    public ExecutionQuery processVariableValueEquals(Object variableValue) {
        return (ExecutionQuery)this.variableValueEquals(variableValue, false);
    }

    @Override
    public ExecutionQuery processVariableValueNotEquals(String variableName, Object variableValue) {
        return (ExecutionQuery)this.variableValueNotEquals(variableName, variableValue, false);
    }

    @Override
    public ExecutionQuery processVariableValueEqualsIgnoreCase(String name, String value) {
        return (ExecutionQuery)this.variableValueEqualsIgnoreCase(name, value, false);
    }

    @Override
    public ExecutionQuery processVariableValueNotEqualsIgnoreCase(String name, String value) {
        return (ExecutionQuery)this.variableValueNotEqualsIgnoreCase(name, value, false);
    }

    @Override
    public ExecutionQuery processVariableValueLike(String name, String value) {
        return (ExecutionQuery)this.variableValueLike(name, value, false);
    }

    @Override
    public ExecutionQuery processVariableValueLikeIgnoreCase(String name, String value) {
        return (ExecutionQuery)this.variableValueLikeIgnoreCase(name, value, false);
    }

    @Override
    public ExecutionQuery locale(String locale) {
        this.locale = locale;
        return this;
    }

    @Override
    public ExecutionQuery withLocalizationFallback() {
        this.withLocalizationFallback = true;
        return this;
    }

    @Override
    public ExecutionQueryImpl orderByProcessInstanceId() {
        this.orderProperty = ExecutionQueryProperty.PROCESS_INSTANCE_ID;
        return this;
    }

    @Override
    public ExecutionQueryImpl orderByProcessDefinitionId() {
        this.orderProperty = ExecutionQueryProperty.PROCESS_DEFINITION_ID;
        return this;
    }

    @Override
    public ExecutionQueryImpl orderByProcessDefinitionKey() {
        this.orderProperty = ExecutionQueryProperty.PROCESS_DEFINITION_KEY;
        return this;
    }

    @Override
    public ExecutionQueryImpl orderByTenantId() {
        this.orderProperty = ExecutionQueryProperty.TENANT_ID;
        return this;
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        this.ensureVariablesInitialized();
        return commandContext.getExecutionEntityManager().findExecutionCountByQueryCriteria(this);
    }

    @Override
    public List<Execution> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        this.ensureVariablesInitialized();
        List<Execution> executions = commandContext.getExecutionEntityManager().findExecutionsByQueryCriteria(this, page);
        for (ExecutionEntity executionEntity : executions) {
            String activityId = null;
            if (executionEntity.getId().equals(executionEntity.getProcessInstanceId())) {
                if (executionEntity.getProcessDefinitionId() != null) {
                    ProcessDefinition processDefinition = commandContext.getProcessEngineConfiguration().getDeploymentManager().findDeployedProcessDefinitionById(executionEntity.getProcessDefinitionId());
                    activityId = processDefinition.getKey();
                }
            } else {
                activityId = executionEntity.getActivityId();
            }
            if (activityId == null) continue;
            this.localize(executionEntity, activityId);
        }
        return executions;
    }

    protected void localize(Execution execution, String activityId) {
        ObjectNode languageNode;
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        executionEntity.setLocalizedName(null);
        executionEntity.setLocalizedDescription(null);
        String processDefinitionId = executionEntity.getProcessDefinitionId();
        if (this.locale != null && processDefinitionId != null && (languageNode = Context.getLocalizationElementProperties(this.locale, activityId, processDefinitionId, this.withLocalizationFallback)) != null) {
            JsonNode languageDescriptionNode;
            JsonNode languageNameNode = languageNode.get("name");
            if (languageNameNode != null && !languageNameNode.isNull()) {
                executionEntity.setLocalizedName(languageNameNode.asText());
            }
            if ((languageDescriptionNode = languageNode.get("description")) != null && !languageDescriptionNode.isNull()) {
                executionEntity.setLocalizedDescription(languageDescriptionNode.asText());
            }
        }
    }

    public boolean getOnlyProcessInstances() {
        return false;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getProcessDefinitionCategory() {
        return this.processDefinitionCategory;
    }

    public String getProcessDefinitionName() {
        return this.processDefinitionName;
    }

    public Integer getProcessDefinitionVersion() {
        return this.processDefinitionVersion;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getProcessInstanceIds() {
        return null;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String getSuperProcessInstanceId() {
        return this.superProcessInstanceId;
    }

    public String getSubProcessInstanceId() {
        return this.subProcessInstanceId;
    }

    public boolean isExcludeSubprocesses() {
        return this.excludeSubprocesses;
    }

    public SuspensionState getSuspensionState() {
        return this.suspensionState;
    }

    public void setSuspensionState(SuspensionState suspensionState) {
        this.suspensionState = suspensionState;
    }

    public List<EventSubscriptionQueryValue> getEventSubscriptions() {
        return this.eventSubscriptions;
    }

    public boolean isIncludeChildExecutionsWithBusinessKeyQuery() {
        return this.includeChildExecutionsWithBusinessKeyQuery;
    }

    public void setEventSubscriptions(List<EventSubscriptionQueryValue> eventSubscriptions) {
        this.eventSubscriptions = eventSubscriptions;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public String getInvolvedUser() {
        return this.involvedUser;
    }

    public void setInvolvedUser(String involvedUser) {
        this.involvedUser = involvedUser;
    }

    public Set<String> getProcessDefinitionIds() {
        return this.processDefinitionIds;
    }

    public Set<String> getProcessDefinitionKeys() {
        return this.processDefinitionKeys;
    }

    public String getParentId() {
        return this.parentId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getTenantIdLike() {
        return this.tenantIdLike;
    }

    public boolean isWithoutTenantId() {
        return this.withoutTenantId;
    }

    public String getName() {
        return this.name;
    }

    public String getNameLike() {
        return this.nameLike;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNameLike(String nameLike) {
        this.nameLike = nameLike;
    }

    public String getNameLikeIgnoreCase() {
        return this.nameLikeIgnoreCase;
    }

    public void setNameLikeIgnoreCase(String nameLikeIgnoreCase) {
        this.nameLikeIgnoreCase = nameLikeIgnoreCase;
    }
}

