/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.resgen;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public abstract class ShadowResourceBundle
extends ResourceBundle {
    private PropertyResourceBundle bundle;
    private static final ThreadLocal mapThreadToLocale = new ThreadLocal();
    protected static final Object[] emptyObjectArray = new Object[0];

    protected ShadowResourceBundle() throws IOException {
        Class<?> clazz = this.getClass();
        InputStream stream = ShadowResourceBundle.openPropertiesFile(clazz);
        if (stream == null) {
            throw new IOException("could not open properties file for " + this.getClass());
        }
        MyPropertyResourceBundle previousBundle = new MyPropertyResourceBundle(stream);
        this.bundle = previousBundle;
        stream.close();
        while ((clazz = clazz.getSuperclass()) != null && clazz != ShadowResourceBundle.class && ResourceBundle.class.isAssignableFrom(clazz)) {
            stream = ShadowResourceBundle.openPropertiesFile(clazz);
            if (stream == null) continue;
            MyPropertyResourceBundle newBundle = new MyPropertyResourceBundle(stream);
            stream.close();
            if (previousBundle != null) {
                previousBundle.setParentTrojan(newBundle);
            } else {
                this.bundle = newBundle;
            }
            previousBundle = newBundle;
        }
    }

    private static InputStream openPropertiesFile(Class clazz) {
        final ClassLoader loader = clazz.getClassLoader();
        final String resName = clazz.getName().replace('.', '/') + ".properties";
        return (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (loader != null) {
                    return loader.getResourceAsStream(resName);
                }
                return ClassLoader.getSystemResourceAsStream(resName);
            }
        });
    }

    public Enumeration getKeys() {
        return this.bundle.getKeys();
    }

    protected Object handleGetObject(String key) throws MissingResourceException {
        return this.bundle.getObject(key);
    }

    protected static ResourceBundle instance(String baseName) {
        return ShadowResourceBundle.instance(baseName, ShadowResourceBundle.getThreadLocale());
    }

    protected static ShadowResourceBundle instance(String baseName, Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        ResourceBundle bundle = ResourceBundle.getBundle(baseName, locale);
        return ShadowResourceBundle.instance(baseName, locale, bundle);
    }

    protected static ShadowResourceBundle instance(String baseName, Locale locale, ResourceBundle bundle) {
        if (bundle instanceof PropertyResourceBundle) {
            throw new ClassCastException("ShadowResourceBundle.instance('" + baseName + "','" + locale + "') found " + baseName + "_" + locale + ".properties but not " + baseName + "_" + locale + ".class");
        }
        return (ShadowResourceBundle)bundle;
    }

    protected static Locale getThreadOrDefaultLocale() {
        Locale locale = ShadowResourceBundle.getThreadLocale();
        if (locale == null) {
            return Locale.getDefault();
        }
        return locale;
    }

    public static void setThreadLocale(Locale locale) {
        mapThreadToLocale.set(locale);
    }

    public static Locale getThreadLocale() {
        return (Locale)mapThreadToLocale.get();
    }

    static class MyPropertyResourceBundle
    extends PropertyResourceBundle {
        public MyPropertyResourceBundle(InputStream stream) throws IOException {
            super(stream);
        }

        void setParentTrojan(ResourceBundle parent) {
            super.setParent(parent);
        }
    }
}

