/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.netty.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.group.ChannelGroup;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.transport.http.netty.server.NettyHttpContextHandler;
import org.apache.cxf.transport.http.netty.server.NettyHttpServletPipelineFactory;
import org.apache.cxf.transport.http.netty.server.interceptor.NettyInterceptor;
import org.apache.cxf.transport.http.netty.server.servlet.NettyHttpServletRequest;
import org.apache.cxf.transport.http.netty.server.servlet.NettyServletResponse;

public class NettyHttpServletHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LogUtils.getL7dLogger(NettyHttpServletHandler.class);
    private final ChannelGroup allChannels;
    private final NettyHttpServletPipelineFactory pipelineFactory;
    private List<NettyInterceptor> interceptors;

    public NettyHttpServletHandler(NettyHttpServletPipelineFactory pipelineFactory) {
        this.allChannels = pipelineFactory.getAllChannels();
        this.pipelineFactory = pipelineFactory;
    }

    public NettyHttpServletHandler addInterceptor(NettyInterceptor interceptor) {
        if (this.interceptors == null) {
            this.interceptors = new ArrayList<NettyInterceptor>();
        }
        this.interceptors.add(interceptor);
        return this;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        LOG.log(Level.FINE, "Opening new channel: {}", ctx.channel());
        this.allChannels.add((Object)ctx.channel());
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        IdleStateEvent e;
        if (evt instanceof IdleStateEvent && ((e = (IdleStateEvent)evt).state() == IdleState.READER_IDLE || e.state() == IdleState.WRITER_IDLE)) {
            LOG.log(Level.FINE, "Closing idle channel: {}", e.state());
            ctx.close();
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        NettyHttpContextHandler nettyHttpContextHandler;
        HttpRequest request = (HttpRequest)msg;
        if (HttpHeaders.is100ContinueExpected((HttpMessage)request)) {
            ctx.write((Object)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
        }
        if ((nettyHttpContextHandler = this.pipelineFactory.getNettyHttpHandler(request.getUri())) == null) {
            throw new RuntimeException((Throwable)new Fault(new Message("NO_NETTY_SERVLET_HANDLER_FOUND", LOG, new Object[]{request.getUri()})));
        }
        this.handleHttpServletRequest(ctx, request, nettyHttpContextHandler);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    protected void handleHttpServletRequest(ChannelHandlerContext ctx, HttpRequest request, NettyHttpContextHandler nettyHttpContextHandler) throws Exception {
        this.interceptOnRequestReceived(ctx, request);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        NettyServletResponse nettyServletResponse = this.buildHttpServletResponse((HttpResponse)response);
        NettyHttpServletRequest nettyServletRequest = this.buildHttpServletRequest(request, nettyHttpContextHandler.getContextPath(), ctx);
        nettyHttpContextHandler.handle(nettyServletRequest.getRequestURI(), nettyServletRequest, nettyServletResponse);
        this.interceptOnRequestSuccessed(ctx, (HttpResponse)response);
        nettyServletResponse.getWriter().flush();
        boolean keepAlive = HttpHeaders.isKeepAlive((HttpMessage)request);
        if (keepAlive) {
            response.headers().set("Content-Length", (Object)response.content().readableBytes());
            response.headers().set("Connection", (Object)"keep-alive");
        }
        ChannelFuture future = ctx.write((Object)response);
        if (!keepAlive) {
            future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOG.log(Level.SEVERE, "UNEXPECTED_EXCEPCTION_IN_NETTY_SERVLET_HANDLER", cause);
        this.interceptOnRequestFailed(ctx, cause);
        Channel ch = ctx.channel();
        if (cause instanceof IllegalArgumentException) {
            ch.close();
        } else {
            if (cause instanceof TooLongFrameException) {
                this.sendError(ctx, HttpResponseStatus.BAD_REQUEST);
                return;
            }
            if (ch.isActive()) {
                this.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR);
            }
        }
        ctx.close();
    }

    private void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
        ByteBuf content = Unpooled.copiedBuffer((CharSequence)("Failure: " + status.toString() + "\r\n"), (Charset)CharsetUtil.UTF_8);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, content);
        response.headers().set("Content-Type", (Object)"text/plain; charset=UTF-8");
        ctx.write((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private void interceptOnRequestReceived(ChannelHandlerContext ctx, HttpRequest request) {
        if (this.interceptors != null) {
            for (NettyInterceptor interceptor : this.interceptors) {
                interceptor.onRequestReceived(ctx, request);
            }
        }
    }

    private void interceptOnRequestSuccessed(ChannelHandlerContext ctx, HttpResponse response) {
        if (this.interceptors != null) {
            for (NettyInterceptor interceptor : this.interceptors) {
                interceptor.onRequestSuccessed(ctx, response);
            }
        }
    }

    private void interceptOnRequestFailed(ChannelHandlerContext ctx, Throwable e) {
        if (this.interceptors != null) {
            for (NettyInterceptor interceptor : this.interceptors) {
                interceptor.onRequestFailed(ctx, e);
            }
        }
    }

    protected NettyServletResponse buildHttpServletResponse(HttpResponse response) {
        return new NettyServletResponse(response);
    }

    protected NettyHttpServletRequest buildHttpServletRequest(HttpRequest request, String contextPath, ChannelHandlerContext ctx) {
        return new NettyHttpServletRequest(request, contextPath, ctx);
    }
}

