/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.variable;

import org.activiti5.engine.impl.variable.SerializableType;

public class LongStringType
extends SerializableType {
    private final int minLength;

    public LongStringType(int minLength) {
        this.minLength = minLength;
    }

    @Override
    public String getTypeName() {
        return "longString";
    }

    @Override
    public boolean isAbleToStore(Object value) {
        if (value == null) {
            return false;
        }
        if (String.class.isAssignableFrom(value.getClass())) {
            String stringValue = (String)value;
            return stringValue.length() >= this.minLength;
        }
        return false;
    }
}

