/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.bpmn.parser.handler;

import java.util.ArrayList;
import java.util.Collections;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BoundaryEvent;
import org.activiti.bpmn.model.StartEvent;
import org.activiti5.engine.impl.bpmn.parser.BpmnParse;
import org.activiti5.engine.impl.bpmn.parser.ErrorEventDefinition;
import org.activiti5.engine.impl.bpmn.parser.handler.AbstractBpmnParseHandler;
import org.activiti5.engine.impl.pvm.process.ActivityImpl;
import org.activiti5.engine.impl.pvm.process.ScopeImpl;
import org.apache.commons.lang3.StringUtils;

public class ErrorEventDefinitionParseHandler
extends AbstractBpmnParseHandler<org.activiti.bpmn.model.ErrorEventDefinition> {
    public static final String PROPERTYNAME_INITIAL = "initial";

    @Override
    public Class<? extends BaseElement> getHandledType() {
        return org.activiti.bpmn.model.ErrorEventDefinition.class;
    }

    @Override
    protected void executeParse(BpmnParse bpmnParse, org.activiti.bpmn.model.ErrorEventDefinition eventDefinition) {
        org.activiti.bpmn.model.ErrorEventDefinition modelErrorEvent = eventDefinition;
        if (bpmnParse.getBpmnModel().containsErrorRef(modelErrorEvent.getErrorCode())) {
            String errorCode = (String)bpmnParse.getBpmnModel().getErrors().get(modelErrorEvent.getErrorCode());
            modelErrorEvent.setErrorCode(errorCode);
        }
        ScopeImpl scope = bpmnParse.getCurrentScope();
        ActivityImpl activity = bpmnParse.getCurrentActivity();
        if (bpmnParse.getCurrentFlowElement() instanceof StartEvent) {
            if (scope.getProperty(PROPERTYNAME_INITIAL) == null) {
                scope.setProperty(PROPERTYNAME_INITIAL, activity);
                ScopeImpl catchingScope = ((ActivityImpl)scope).getParent();
                this.createErrorStartEventDefinition(modelErrorEvent, activity, catchingScope);
            }
        } else if (bpmnParse.getCurrentFlowElement() instanceof BoundaryEvent) {
            BoundaryEvent boundaryEvent = (BoundaryEvent)bpmnParse.getCurrentFlowElement();
            boolean interrupting = true;
            activity.setActivityBehavior(bpmnParse.getActivityBehaviorFactory().createBoundaryEventActivityBehavior(boundaryEvent, interrupting, activity));
            ActivityImpl parentActivity = scope.findActivity(boundaryEvent.getAttachedToRefId());
            this.createBoundaryErrorEventDefinition(modelErrorEvent, interrupting, parentActivity, activity);
        }
    }

    protected void createErrorStartEventDefinition(org.activiti.bpmn.model.ErrorEventDefinition errorEventDefinition, ActivityImpl startEventActivity, ScopeImpl scope) {
        ErrorEventDefinition definition = new ErrorEventDefinition(startEventActivity.getId());
        if (StringUtils.isNotEmpty((CharSequence)errorEventDefinition.getErrorCode())) {
            definition.setErrorCode(errorEventDefinition.getErrorCode());
        }
        definition.setPrecedence(10);
        this.addErrorEventDefinition(definition, scope);
    }

    public void createBoundaryErrorEventDefinition(org.activiti.bpmn.model.ErrorEventDefinition errorEventDefinition, boolean interrupting, ActivityImpl activity, ActivityImpl nestedErrorEventActivity) {
        nestedErrorEventActivity.setProperty("type", "boundaryError");
        ScopeImpl catchingScope = nestedErrorEventActivity.getParent();
        ((ActivityImpl)catchingScope).setScope(true);
        ErrorEventDefinition definition = new ErrorEventDefinition(nestedErrorEventActivity.getId());
        definition.setErrorCode(errorEventDefinition.getErrorCode());
        this.addErrorEventDefinition(definition, catchingScope);
    }

    protected void addErrorEventDefinition(ErrorEventDefinition errorEventDefinition, ScopeImpl catchingScope) {
        ArrayList<ErrorEventDefinition> errorEventDefinitions = (ArrayList<ErrorEventDefinition>)catchingScope.getProperty("errorEventDefinitions");
        if (errorEventDefinitions == null) {
            errorEventDefinitions = new ArrayList<ErrorEventDefinition>();
            catchingScope.setProperty("errorEventDefinitions", errorEventDefinitions);
        }
        errorEventDefinitions.add(errorEventDefinition);
        Collections.sort(errorEventDefinitions, ErrorEventDefinition.comparator);
    }
}

