/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl;

import java.util.ArrayList;
import java.util.List;
import org.activiti.engine.impl.variable.VariableTypes;
import org.activiti5.engine.ActivitiIllegalArgumentException;
import org.activiti5.engine.impl.AbstractQuery;
import org.activiti5.engine.impl.Page;
import org.activiti5.engine.impl.QueryOperator;
import org.activiti5.engine.impl.QueryVariableValue;
import org.activiti5.engine.impl.context.Context;
import org.activiti5.engine.impl.interceptor.CommandContext;
import org.activiti5.engine.impl.interceptor.CommandExecutor;
import org.activiti5.engine.query.Query;

public abstract class AbstractVariableQueryImpl<T extends Query<?, ?>, U>
extends AbstractQuery<T, U> {
    private static final long serialVersionUID = 1L;
    protected List<QueryVariableValue> queryVariableValues = new ArrayList<QueryVariableValue>();

    public AbstractVariableQueryImpl() {
    }

    public AbstractVariableQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public AbstractVariableQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public abstract long executeCount(CommandContext var1);

    @Override
    public abstract List<U> executeList(CommandContext var1, Page var2);

    public T variableValueEquals(String name, Object value) {
        return this.variableValueEquals(name, value, true);
    }

    public T variableValueEquals(String name, Object value, boolean localScope) {
        this.addVariable(name, value, QueryOperator.EQUALS, localScope);
        return (T)this;
    }

    public T variableValueEquals(Object value) {
        return this.variableValueEquals(value, true);
    }

    public T variableValueEquals(Object value, boolean localScope) {
        this.queryVariableValues.add(new QueryVariableValue(null, value, QueryOperator.EQUALS, localScope));
        return (T)this;
    }

    public T variableValueEqualsIgnoreCase(String name, String value) {
        return this.variableValueEqualsIgnoreCase(name, value, true);
    }

    public T variableValueEqualsIgnoreCase(String name, String value, boolean localScope) {
        if (value == null) {
            throw new ActivitiIllegalArgumentException("value is null");
        }
        this.addVariable(name, value.toLowerCase(), QueryOperator.EQUALS_IGNORE_CASE, localScope);
        return (T)this;
    }

    public T variableValueNotEqualsIgnoreCase(String name, String value) {
        return this.variableValueNotEqualsIgnoreCase(name, value, true);
    }

    public T variableValueNotEqualsIgnoreCase(String name, String value, boolean localScope) {
        if (value == null) {
            throw new ActivitiIllegalArgumentException("value is null");
        }
        this.addVariable(name, value.toLowerCase(), QueryOperator.NOT_EQUALS_IGNORE_CASE, localScope);
        return (T)this;
    }

    public T variableValueNotEquals(String name, Object value) {
        return this.variableValueNotEquals(name, value, true);
    }

    public T variableValueNotEquals(String name, Object value, boolean localScope) {
        this.addVariable(name, value, QueryOperator.NOT_EQUALS, localScope);
        return (T)this;
    }

    public T variableValueGreaterThan(String name, Object value) {
        return this.variableValueGreaterThan(name, value, true);
    }

    public T variableValueGreaterThan(String name, Object value, boolean localScope) {
        this.addVariable(name, value, QueryOperator.GREATER_THAN, localScope);
        return (T)this;
    }

    public T variableValueGreaterThanOrEqual(String name, Object value) {
        return this.variableValueGreaterThanOrEqual(name, value, true);
    }

    public T variableValueGreaterThanOrEqual(String name, Object value, boolean localScope) {
        this.addVariable(name, value, QueryOperator.GREATER_THAN_OR_EQUAL, localScope);
        return (T)this;
    }

    public T variableValueLessThan(String name, Object value) {
        return this.variableValueLessThan(name, value, true);
    }

    public T variableValueLessThan(String name, Object value, boolean localScope) {
        this.addVariable(name, value, QueryOperator.LESS_THAN, localScope);
        return (T)this;
    }

    public T variableValueLessThanOrEqual(String name, Object value) {
        return this.variableValueLessThanOrEqual(name, value, true);
    }

    public T variableValueLessThanOrEqual(String name, Object value, boolean localScope) {
        this.addVariable(name, value, QueryOperator.LESS_THAN_OR_EQUAL, localScope);
        return (T)this;
    }

    public T variableValueLike(String name, String value) {
        return this.variableValueLike(name, value, true);
    }

    public T variableValueLikeIgnoreCase(String name, String value) {
        return this.variableValueLikeIgnoreCase(name, value, true);
    }

    public T variableValueLike(String name, String value, boolean localScope) {
        this.addVariable(name, value, QueryOperator.LIKE, localScope);
        return (T)this;
    }

    public T variableValueLikeIgnoreCase(String name, String value, boolean localScope) {
        this.addVariable(name, value, QueryOperator.LIKE_IGNORE_CASE, localScope);
        return (T)this;
    }

    private void addVariable(String name, Object value, QueryOperator operator, boolean localScope) {
        if (name == null) {
            throw new ActivitiIllegalArgumentException("name is null");
        }
        if (value == null || this.isBoolean(value)) {
            switch (operator) {
                case GREATER_THAN: {
                    throw new ActivitiIllegalArgumentException("Booleans and null cannot be used in 'greater than' condition");
                }
                case LESS_THAN: {
                    throw new ActivitiIllegalArgumentException("Booleans and null cannot be used in 'less than' condition");
                }
                case GREATER_THAN_OR_EQUAL: {
                    throw new ActivitiIllegalArgumentException("Booleans and null cannot be used in 'greater than or equal' condition");
                }
                case LESS_THAN_OR_EQUAL: {
                    throw new ActivitiIllegalArgumentException("Booleans and null cannot be used in 'less than or equal' condition");
                }
            }
            if (operator == QueryOperator.EQUALS_IGNORE_CASE && !(value instanceof String)) {
                throw new ActivitiIllegalArgumentException("Only string values can be used with 'equals ignore case' condition");
            }
            if (operator == QueryOperator.NOT_EQUALS_IGNORE_CASE && !(value instanceof String)) {
                throw new ActivitiIllegalArgumentException("Only string values can be used with 'not equals ignore case' condition");
            }
            if (!(operator != QueryOperator.LIKE && operator != QueryOperator.LIKE_IGNORE_CASE || value instanceof String)) {
                throw new ActivitiIllegalArgumentException("Only string values can be used with 'like' condition");
            }
        }
        this.queryVariableValues.add(new QueryVariableValue(name, value, operator, localScope));
    }

    private boolean isBoolean(Object value) {
        if (value == null) {
            return false;
        }
        return Boolean.class.isAssignableFrom(value.getClass()) || Boolean.TYPE.isAssignableFrom(value.getClass());
    }

    protected void ensureVariablesInitialized() {
        if (!this.queryVariableValues.isEmpty()) {
            VariableTypes variableTypes = Context.getProcessEngineConfiguration().getVariableTypes();
            for (QueryVariableValue queryVariableValue : this.queryVariableValues) {
                queryVariableValue.initialize(variableTypes);
            }
        }
    }

    public List<QueryVariableValue> getQueryVariableValues() {
        return this.queryVariableValues;
    }
}

