/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import junit.framework.Assert;
import junit.framework.ComparisonFailure;
import junit.framework.TestSuite;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbcp.DelegatingStatement;
import org.olap4j.CellSet;
import org.olap4j.CellSetFormatterTest;
import org.olap4j.ConnectionTest;
import org.olap4j.MetadataTest;
import org.olap4j.OlapTest;
import org.olap4j.OlapTreeTest;
import org.olap4j.OlapWrapper;
import org.olap4j.XmlaConnectionTest;
import org.olap4j.driver.xmla.cache.XmlaShaEncoderTest;
import org.olap4j.driver.xmla.proxy.XmlaCachedProxyTest;
import org.olap4j.driver.xmla.proxy.XmlaCookieManagerTest;
import org.olap4j.impl.Base64Test;
import org.olap4j.impl.ConnectStringParserTest;
import org.olap4j.impl.Olap4jUtil;
import org.olap4j.impl.Olap4jUtilTest;
import org.olap4j.layout.TraditionalCellSetFormatter;
import org.olap4j.mdx.IdentifierNode;
import org.olap4j.mdx.IdentifierSegment;
import org.olap4j.mdx.MdxTest;
import org.olap4j.mdx.ParseTreeNode;
import org.olap4j.mdx.ParseTreeWriter;
import org.olap4j.test.ArrayMapTest;
import org.olap4j.test.ParserTest;
import org.olap4j.transform.TransformTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestContext {
    public static final String NL = System.getProperty("line.separator");
    private static final String indent = "                ";
    private static final String lineBreak2 = "\\\\n\"" + NL + "                " + "+ \"";
    private static final String lineBreak3 = "\\n\"" + NL + "                " + "+ \"";
    private static final Pattern LineBreakPattern = Pattern.compile("\r\n|\r|\n");
    private static final Pattern TabPattern = Pattern.compile("\t");
    private static Properties testProperties;
    private static final ThreadLocal<TestContext> THREAD_INSTANCE;
    public static final Class<?>[] TCK_CLASSES;
    public static final Class<?>[] NON_TCK_CLASSES;
    private final Tester tester;
    private final Properties properties;

    private TestContext() {
        this(TestContext.getStaticTestProperties());
    }

    private TestContext(Properties properties) {
        assert (properties != null);
        this.properties = properties;
        this.tester = TestContext.createTester(this, properties);
    }

    private static void addTck(TestSuite suite) {
        for (Class<?> tckClass : TCK_CLASSES) {
            suite.addTestSuite(tckClass);
        }
    }

    public static SafeString fold(String string) {
        if (!NL.equals("\n")) {
            string = Olap4jUtil.replace((String)string, (String)"\n", (String)NL);
        }
        if (string == null) {
            return null;
        }
        return new SafeString(string);
    }

    public static String unfold(String string) {
        if (!NL.equals("\n")) {
            string = Olap4jUtil.replace((String)string, (String)NL, (String)"\n");
        }
        if (string == null) {
            return null;
        }
        return string;
    }

    public static String toString(ParseTreeNode node) {
        StringWriter sw = new StringWriter();
        ParseTreeWriter parseTreeWriter = new ParseTreeWriter((Writer)sw);
        node.unparse(parseTreeWriter);
        return sw.toString();
    }

    public static String toString(CellSet cellSet) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        new TraditionalCellSetFormatter().format(cellSet, pw);
        pw.flush();
        return sw.toString();
    }

    public static TestContext instance() {
        return THREAD_INSTANCE.get();
    }

    public static void assertEqualsVerbose(String expected, String actual) {
        TestContext.assertEqualsVerbose(expected, actual, true, null);
    }

    public static void assertEqualsVerbose(String expected, String actual, boolean java, String message) {
        TestContext.assertEqualsVerbose(TestContext.fold(expected), actual, java, message);
    }

    public static void assertEqualsVerbose(SafeString safeExpected, String actual, boolean java, String message) {
        String expected;
        String string = expected = safeExpected == null ? null : safeExpected.s;
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null && expected.equals(actual)) {
            return;
        }
        message = message == null ? "" : message + NL;
        message = message + "Expected:" + NL + expected + NL + "Actual:" + NL + actual + NL;
        if (java) {
            message = message + "Actual java:" + NL + TestContext.toJavaString(actual) + NL;
        }
        throw new ComparisonFailure(message, expected, actual);
    }

    static String toJavaString(String s) {
        String spurious;
        s = Olap4jUtil.replace((String)s, (String)"\\", (String)"\\\\");
        s = Olap4jUtil.replace((String)s, (String)"\"", (String)"\\\"");
        s = LineBreakPattern.matcher(s).replaceAll(lineBreak2);
        s = TabPattern.matcher(s).replaceAll("\\\\t");
        s = "\"" + s + "\"";
        if (s.endsWith(spurious = NL + indent + "+ \"\"")) {
            s = s.substring(0, s.length() - spurious.length());
        }
        if (s.indexOf(lineBreak3) >= 0) {
            s = "fold(" + NL + indent + s + ")";
        }
        return s;
    }

    public static String quotePattern(String s) {
        s = s.replaceAll("\\\\", "\\\\");
        s = s.replaceAll("\\.", "\\\\.");
        s = s.replaceAll("\\+", "\\\\+");
        s = s.replaceAll("\\{", "\\\\{");
        s = s.replaceAll("\\}", "\\\\}");
        s = s.replaceAll("\\|", "\\\\||");
        s = s.replaceAll("[$]", "\\\\\\$");
        s = s.replaceAll("\\?", "\\\\?");
        s = s.replaceAll("\\*", "\\\\*");
        s = s.replaceAll("\\(", "\\\\(");
        s = s.replaceAll("\\)", "\\\\)");
        s = s.replaceAll("\\[", "\\\\[");
        s = s.replaceAll("\\]", "\\\\]");
        return s;
    }

    private static Tester createTester(TestContext testContext, Properties testProperties) {
        Wrapper wrapper;
        Tester tester;
        String helperClassName = testProperties.getProperty(Property.HELPER_CLASS_NAME.path);
        if (helperClassName == null) {
            helperClassName = "org.olap4j.XmlaTester";
            if (!testProperties.containsKey(Property.XMLA_CATALOG_URL.path)) {
                testProperties.setProperty(Property.XMLA_CATALOG_URL.path, "dummy_xmla_catalog_url");
            }
        }
        try {
            Class<?> clazz = Class.forName(helperClassName);
            Constructor<?> constructor = clazz.getConstructor(TestContext.class);
            tester = (Tester)constructor.newInstance(testContext);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        String wrapperName = testProperties.getProperty(Property.WRAPPER.path);
        if (wrapperName == null || wrapperName.equals("")) {
            wrapper = Wrapper.NONE;
        } else {
            try {
                wrapper = Enum.valueOf(Wrapper.class, wrapperName);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Unknown wrapper value '" + wrapperName + "'");
            }
        }
        switch (wrapper) {
            case NONE: {
                break;
            }
            case DBCP: {
                final BasicDataSource dataSource = new BasicDataSource();
                dataSource.setDriverClassName(tester.getDriverClassName());
                dataSource.setUrl(tester.getURL());
                dataSource.setAccessToUnderlyingConnectionAllowed(true);
                tester = new DelegatingTester(tester){

                    public Connection createConnection() throws SQLException {
                        return dataSource.getConnection();
                    }

                    public Wrapper getWrapper() {
                        return Wrapper.DBCP;
                    }
                };
            }
        }
        return tester;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TestSuite createTckSuite(Properties properties, String name) {
        TestContext testContext = new TestContext(properties);
        THREAD_INSTANCE.set(testContext);
        try {
            TestSuite suite = new TestSuite();
            suite.setName(name);
            TestContext.addTck(suite);
            TestSuite testSuite = suite;
            return testSuite;
        }
        finally {
            THREAD_INSTANCE.remove();
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    private static synchronized Properties getStaticTestProperties() {
        if (testProperties == null) {
            testProperties = new Properties(System.getProperties());
            for (File dir = new File(System.getProperty("user.dir")); dir != null; dir = dir.getParentFile()) {
                File file = new File(dir, "test.properties");
                if (file.exists()) {
                    try {
                        testProperties.load(new FileInputStream(file));
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (!(file = new File(new File(dir, "olap4j"), "test.properties")).exists()) continue;
                try {
                    testProperties.load(new FileInputStream(file));
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return testProperties;
    }

    public static String getStackTrace(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    public static List<IdentifierSegment> nameList(String ... names) {
        return IdentifierNode.ofNames((String[])names).getSegmentList();
    }

    public static void checkThrowable(Throwable throwable, String pattern) {
        String stackTrace;
        if (throwable == null) {
            Assert.fail((String)"query did not yield an exception");
        }
        if ((stackTrace = TestContext.getStackTrace(throwable)).indexOf(pattern) < 0) {
            Assert.fail((String)("error does not match pattern '" + pattern + "'; error is [" + stackTrace + "]"));
        }
    }

    public Tester getTester() {
        return this.tester;
    }

    static {
        THREAD_INSTANCE = new ThreadLocal<TestContext>(){

            @Override
            protected TestContext initialValue() {
                return new TestContext();
            }
        };
        TCK_CLASSES = new Class[]{ConnectionTest.class, CellSetFormatterTest.class, MetadataTest.class, MdxTest.class, TransformTest.class, XmlaConnectionTest.class, OlapTreeTest.class, OlapTest.class};
        NON_TCK_CLASSES = new Class[]{ConnectStringParserTest.class, Olap4jUtilTest.class, Base64Test.class, ParserTest.class, ArrayMapTest.class, XmlaShaEncoderTest.class, XmlaCookieManagerTest.class, XmlaCachedProxyTest.class};
    }

    public static class SafeString {
        public final String s;

        private SafeString(String s) {
            this.s = s;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        HELPER_CLASS_NAME("org.olap4j.test.helperClassName"),
        CONNECT_URL("org.olap4j.test.connectUrl"),
        XMLA_CATALOG_URL("org.olap4j.XmlaTester.CatalogUrl"),
        REMOTE_XMLA_URL("org.olap4j.RemoteXmlaTester.JdbcUrl"),
        REMOTE_XMLA_USERNAME("org.olap4j.RemoteXmlaTester.Username"),
        REMOTE_XMLA_PASSWORD("org.olap4j.RemoteXmlaTester.Password"),
        WRAPPER("org.olap4j.test.wrapper");

        public final String path;

        private Property(String path) {
            this.path = path;
        }
    }

    public static abstract class DelegatingTester
    implements Tester {
        protected final Tester tester;

        protected DelegatingTester(Tester tester) {
            this.tester = tester;
        }

        public TestContext getTestContext() {
            return this.tester.getTestContext();
        }

        public Connection createConnection() throws SQLException {
            return this.tester.createConnection();
        }

        public String getDriverUrlPrefix() {
            return this.tester.getDriverUrlPrefix();
        }

        public String getDriverClassName() {
            return this.tester.getDriverClassName();
        }

        public Connection createConnectionWithUserPassword() throws SQLException {
            return this.tester.createConnectionWithUserPassword();
        }

        public String getURL() {
            return this.tester.getURL();
        }

        public Tester.Flavor getFlavor() {
            return this.tester.getFlavor();
        }

        public Wrapper getWrapper() {
            return this.tester.getWrapper();
        }
    }

    public static interface Tester {
        public TestContext getTestContext();

        public Connection createConnection() throws SQLException;

        public String getDriverUrlPrefix();

        public String getDriverClassName();

        public Connection createConnectionWithUserPassword() throws SQLException;

        public String getURL();

        public Flavor getFlavor();

        public Wrapper getWrapper();

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Flavor {
            MONDRIAN,
            XMLA,
            REMOTE_XMLA;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Wrapper {
        NONE{

            @Override
            public <T extends Statement> T unwrap(Statement statement, Class<T> clazz) throws SQLException {
                return (T)((Statement)((OlapWrapper)statement).unwrap(clazz));
            }

            @Override
            public <T extends Connection> T unwrap(Connection connection, Class<T> clazz) throws SQLException {
                return (T)((Connection)((OlapWrapper)connection).unwrap(clazz));
            }
        }
        ,
        DBCP{

            @Override
            public <T extends Statement> T unwrap(Statement statement, Class<T> clazz) throws SQLException {
                return (T)((Statement)clazz.cast(((DelegatingStatement)statement).getInnermostDelegate()));
            }

            @Override
            public <T extends Connection> T unwrap(Connection connection, Class<T> clazz) throws SQLException {
                return (T)((Connection)clazz.cast(((DelegatingConnection)connection).getInnermostDelegate()));
            }
        };


        public abstract <T extends Statement> T unwrap(Statement var1, Class<T> var2) throws SQLException;

        public abstract <T extends Connection> T unwrap(Connection var1, Class<T> var2) throws SQLException;
    }
}

