/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.test;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.olap4j.Axis;
import org.olap4j.OlapConnection;
import org.olap4j.impl.Olap4jUtil;
import org.olap4j.mdx.AxisNode;
import org.olap4j.mdx.CallNode;
import org.olap4j.mdx.IdentifierNode;
import org.olap4j.mdx.IdentifierSegment;
import org.olap4j.mdx.KeySegment;
import org.olap4j.mdx.NameSegment;
import org.olap4j.mdx.ParseRegion;
import org.olap4j.mdx.ParseTreeNode;
import org.olap4j.mdx.Quoting;
import org.olap4j.mdx.SelectNode;
import org.olap4j.mdx.Syntax;
import org.olap4j.mdx.WithMemberNode;
import org.olap4j.mdx.parser.MdxParseException;
import org.olap4j.mdx.parser.MdxParser;
import org.olap4j.test.TestContext;

public class ParserTest
extends TestCase {
    private static final Pattern lineColPattern = Pattern.compile("At line ([0-9]+), column ([0-9]+)");
    private static final Pattern lineColTwicePattern = Pattern.compile("(?s)From line ([0-9]+), column ([0-9]+) to line ([0-9]+), column ([0-9]+): (.*)");
    private TestContext testContext = TestContext.instance();
    private Connection connection;

    public ParserTest(String name) {
        super(name);
    }

    protected OlapConnection getOlapConnection() throws SQLException {
        if (this.connection == null) {
            this.connection = this.testContext.getTester().createConnection();
        }
        return this.testContext.getTester().getWrapper().unwrap(this.connection, OlapConnection.class);
    }

    protected void tearDown() throws Exception {
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.close();
            this.connection = null;
        }
        this.testContext = null;
    }

    private MdxParser createParser() {
        try {
            OlapConnection olapConnection = this.getOlapConnection();
            return olapConnection.getParserFactory().createMdxParser(olapConnection);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void assertParseExpr(String expr, String expected, boolean old) {
        if (old) {
            return;
        }
        this.assertParseExpr(expr, expected);
    }

    public void testAddCarets() {
        ParserTest.assertEquals((String)"values (^foo^)", (String)new ParseRegion(1, 9, 1, 11).annotate("values (foo)"));
        ParserTest.assertEquals((String)"abc^def", (String)new ParseRegion(1, 4, 1, 4).annotate("abcdef"));
        ParserTest.assertEquals((String)"abcdef^", (String)new ParseRegion(1, 7, 1, 7).annotate("abcdef"));
        ParserTest.assertEquals((String)"[1:9, 1:11]", (String)ParseRegion.findPos((String)"values (^foo^)").region.toString());
        ParserTest.assertEquals((String)"[1:4]", (String)ParseRegion.findPos((String)"abc^def").region.toString());
        ParserTest.assertEquals((String)"[1:7]", (String)ParseRegion.findPos((String)"abcdef^").region.toString());
        ParserTest.assertNull((Object)ParseRegion.findPos((String)"abc").region);
    }

    public void testAxisParsing() throws Exception {
        this.checkAxisAllWays(0, "COLUMNS");
        this.checkAxisAllWays(1, "ROWS");
        this.checkAxisAllWays(2, "PAGES");
        this.checkAxisAllWays(3, "CHAPTERS");
        this.checkAxisAllWays(4, "SECTIONS");
    }

    private void checkAxisAllWays(int axisOrdinal, String axisName) {
        this.checkAxis(axisOrdinal + "", axisName);
        this.checkAxis("AXIS(" + axisOrdinal + ")", axisName);
        this.checkAxis(axisName, axisName);
    }

    private void checkAxis(String s, String expectedName) {
        MdxParser p = this.createParser();
        String q = "select [member] on " + s + " from [cube]";
        SelectNode selectNode = p.parseSelect(q);
        List axes = selectNode.getAxisList();
        ParserTest.assertEquals((String)"Number of axes must be 1", (int)1, (int)axes.size());
        ParserTest.assertEquals((String)"Axis index name must be correct", (String)expectedName, (String)((AxisNode)axes.get(0)).getAxis().name());
    }

    public void testNegativeCases() throws Exception {
        this.assertParseQueryFails("^s^ from sales", "Syntax error at line 1, column 1, token 's'");
        this.assertParseQueryFails("^seleg^ from sales", "Syntax error at line 1, column 1, token 'seleg'");
        this.assertParseQueryFails("^seleg^   from sales", "Syntax error at line 1, column 1, token 'seleg'");
        this.assertParseQueryFails("select [member] on ^axis(1.7)^ from sales", "(?s).*The axis number must be a non-negative integer, but it was 1.7.");
        this.assertParseQueryFails("select [member] on ^foobar^ from sales", "Syntax error at line 1, column 20, token 'foobar'");
        this.assertParseQueryFails("select [member] on axis(^-^ 1) from sales", "Syntax error at line 1, column 25, token '-'");
        this.assertParseQueryFails("select [member] on axis(^-^1) from sales", "Syntax error at line 1, column 25, token '-'");
        this.assertParseQuery("select [member] on axis(5) from sales", "SELECT\n[member] ON AXIS(5)\nFROM sales");
        this.assertParseQueryFails("select [member] on ^axes^(0) from sales", "Syntax error at line 1, column 20, token 'axes'");
        this.assertParseQueryFails("select [member] on ^0.5^ from sales", "Invalid axis specification\\. The axis number must be a non-negative integer, but it was 0\\.5\\.");
        this.assertParseQuery("select [member] on 555 from sales", "SELECT\n[member] ON AXIS(555)\nFROM sales");
    }

    public void testScannerPunc() {
        this.assertParseQuery("with member [Measures].__Foo as 1 + 2\nselect __Foo on 0\nfrom _Bar_Baz", "WITH\nMEMBER [Measures].__Foo AS\n    (1 + 2)\nSELECT\n__Foo ON COLUMNS\nFROM _Bar_Baz");
        this.assertParseQueryFails("with member [Measures].^#_Foo as 1 + 2\nselect __Foo on 0\nfrom _Bar#Baz", "Lexical error at line 1, column 24.  Encountered: \"#\" \\(35\\), after : \"\"");
        this.assertParseQueryFails("with member [Measures].Foo as 1 + 2\nselect Foo on 0\nfrom Bar^#Baz", "Lexical error at line 3, column 9\\.  Encountered: \"#\" \\(35\\), after : \"\"");
        this.assertParseQuery("with member [Measures].$Foo as 1 + 2\nselect $Foo on 0\nfrom Bar$Baz", "WITH\nMEMBER [Measures].$Foo AS\n    (1 + 2)\nSELECT\n$Foo ON COLUMNS\nFROM Bar$Baz");
        this.assertParseQuery("select [measures].[$foo] on columns from sales", "SELECT\n[measures].[$foo] ON COLUMNS\nFROM sales");
        this.assertParseQueryFails("select { Customers^]^.Children } on columns from [Sales]", "Lexical error at line 1, column 19\\.  Encountered: \"\\]\" \\(93\\), after : \"\"");
    }

    public void testUnparse() {
        this.checkUnparse("with member [Measures].[Foo] as ' 123 '\nselect {[Measures].members} on columns,\n CrossJoin([Product].members, {[Gender].Children}) on rows\nfrom [Sales]\nwhere [Marital Status].[S]", "WITH\nMEMBER [Measures].[Foo] AS\n    123\nSELECT\n{[Measures].members} ON COLUMNS,\nCrossJoin([Product].members, {[Gender].Children}) ON ROWS\nFROM [Sales]\nWHERE [Marital Status].[S]");
    }

    private void checkUnparse(String queryString, String expected) {
        try {
            OlapConnection olapConnection = this.getOlapConnection();
            MdxParser mdxParser = olapConnection.getParserFactory().createMdxParser(olapConnection);
            SelectNode query = mdxParser.parseSelect(queryString);
            String unparsedQueryString = TestContext.toString((ParseTreeNode)query);
            TestContext.assertEqualsVerbose(expected, unparsedQueryString);
        }
        catch (SQLException e) {
            throw new RuntimeException("error during parse");
        }
    }

    private void assertParseQueryFails(String query, String expected) {
        this.checkFails(this.createParser(), query, ParserTest.regexpChecker(expected));
    }

    private void assertParseExprFails(String expr, String expected) {
        this.checkFails(this.createParser(), this.wrapExpr(expr), ParserTest.regexpChecker(expected));
    }

    private void checkFails(MdxParser p, String query, Checker checker) {
        ParseRegion.RegionAndSource ras = ParseRegion.findPos((String)query);
        try {
            SelectNode selectNode = p.parseSelect(ras.source);
            ParserTest.fail((String)("Must return an error, got " + selectNode));
        }
        catch (Exception e) {
            ParserTest.checkEx(e, checker, ras);
        }
    }

    public static void checkEx(Throwable ex, Checker expectedMsgPattern, ParseRegion.RegionAndSource ras) {
        String NL = TestContext.NL;
        if (null == ex) {
            if (expectedMsgPattern == null) {
                return;
            }
            throw new AssertionFailedError("Expected query to throw exception, but it did not; query [" + ras.source + "]; expected [" + expectedMsgPattern + "]");
        }
        Throwable actualException = ex;
        String actualMessage = actualException.getMessage();
        int actualLine = -1;
        int actualColumn = -1;
        int actualEndLine = 100;
        int actualEndColumn = 99;
        MdxParseException mpe = null;
        for (Throwable x = ex; x != null; x = x.getCause()) {
            if (x instanceof MdxParseException && ((MdxParseException)x).getRegion() != null) {
                mpe = (MdxParseException)x;
                break;
            }
            if (x.getCause() == x) break;
        }
        if (mpe != null) {
            ParseRegion region = mpe.getRegion();
            actualLine = region.getStartLine();
            actualColumn = region.getStartColumn();
            actualEndLine = region.getEndLine();
            actualEndColumn = region.getEndColumn();
            actualException = mpe;
            actualMessage = actualException.getMessage();
        } else {
            String message = ex.getMessage();
            if (message != null) {
                Matcher matcher = lineColTwicePattern.matcher(message);
                if (matcher.matches()) {
                    actualLine = Integer.parseInt(matcher.group(1));
                    actualColumn = Integer.parseInt(matcher.group(2));
                    actualEndLine = Integer.parseInt(matcher.group(3));
                    actualEndColumn = Integer.parseInt(matcher.group(4));
                    actualMessage = matcher.group(5);
                } else {
                    matcher = lineColPattern.matcher(message);
                    if (matcher.matches()) {
                        actualLine = Integer.parseInt(matcher.group(1));
                        actualColumn = Integer.parseInt(matcher.group(2));
                    }
                }
            }
        }
        if (null == expectedMsgPattern) {
            if (null != actualException) {
                actualException.printStackTrace();
                ParserTest.fail((String)("Validator threw unexpected exception; query [" + ras.source + "]; exception [" + actualMessage + "]; pos [line " + actualLine + " col " + actualColumn + " thru line " + actualLine + " col " + actualColumn + "]"));
            }
        } else if (null != expectedMsgPattern) {
            if (null == actualException) {
                ParserTest.fail((String)("Expected validator to throw exception, but it did not; query [" + ras.source + "]; expected [" + expectedMsgPattern + "]"));
            } else {
                if (actualColumn <= 0 || actualLine <= 0 || actualEndColumn <= 0 || actualEndLine <= 0) {
                    throw new AssertionFailedError("Error did not have position:  actual pos [line " + actualLine + " col " + actualColumn + " thru line " + actualEndLine + " col " + actualEndColumn + "]");
                }
                String sqlWithCarets = new ParseRegion(actualLine, actualColumn, actualEndLine, actualEndColumn).annotate(ras.source);
                if (ras.region == null) {
                    throw new AssertionFailedError("todo: add carets to sql: " + sqlWithCarets);
                }
                if (!expectedMsgPattern.apply(actualException)) {
                    actualException.printStackTrace();
                    String actualJavaRegexp = actualMessage == null ? "null" : TestContext.toJavaString(TestContext.quotePattern(actualMessage));
                    ParserTest.fail((String)("Validator threw different exception than expected; query [" + ras.source + "];" + NL + " expected pattern [" + expectedMsgPattern + "];" + NL + " actual [" + actualMessage + "];" + NL + " actual as java regexp [" + actualJavaRegexp + "]; pos [" + actualLine + " col " + actualColumn + " thru line " + actualEndLine + " col " + actualEndColumn + "]; sql [" + sqlWithCarets + "]"));
                } else if (ras.region != null && (actualLine != ras.region.getStartLine() || actualColumn != ras.region.getStartColumn() || actualEndLine != ras.region.getEndLine() || actualEndColumn != ras.region.getEndColumn())) {
                    ParserTest.fail((String)("Validator threw expected exception [" + actualMessage + "]; but at pos [line " + actualLine + " col " + actualColumn + " thru line " + actualEndLine + " col " + actualEndColumn + "]; sql [" + sqlWithCarets + "]"));
                }
            }
        }
    }

    public void testMultipleAxes() throws Exception {
        MdxParser p = this.createParser();
        String query = "select {[axis0mbr]} on axis(0), {[axis1mbr]} on axis(1) from cube";
        SelectNode select = p.parseSelect(query);
        ParserTest.assertNotNull((Object)select);
        List axes = select.getAxisList();
        ParserTest.assertEquals((String)"Number of axes", (int)2, (int)axes.size());
        ParserTest.assertEquals((String)"Axis index name must be correct", (Object)Axis.Factory.forOrdinal((int)0), (Object)((AxisNode)axes.get(0)).getAxis());
        ParserTest.assertEquals((String)"Axis index name must be correct", (Object)Axis.Factory.forOrdinal((int)1), (Object)((AxisNode)axes.get(1)).getAxis());
        query = "select {[axis1mbr]} on aXiS(1), {[axis0mbr]} on AxIs(0) from cube";
        select = p.parseSelect(query);
        axes = select.getAxisList();
        ParserTest.assertEquals((String)"Number of axes", (int)2, (int)axes.size());
        ParserTest.assertEquals((String)"Axis index name must be correct", (Object)Axis.Factory.forOrdinal((int)0), (Object)((AxisNode)axes.get(0)).getAxis());
        ParserTest.assertEquals((String)"Axis index name must be correct", (Object)Axis.Factory.forOrdinal((int)1), (Object)((AxisNode)axes.get(1)).getAxis());
        ParseTreeNode colsSetExpr = ((AxisNode)axes.get(0)).getExpression();
        ParserTest.assertNotNull((String)"Column tuples", (Object)colsSetExpr);
        CallNode fun = (CallNode)colsSetExpr;
        IdentifierNode identifier = (IdentifierNode)fun.getArgList().get(0);
        ParserTest.assertEquals((int)1, (int)identifier.getSegmentList().size());
        ParserTest.assertEquals((String)"Correct member on axis", (String)"axis0mbr", (String)((IdentifierSegment)identifier.getSegmentList().get(0)).getName());
        ParseTreeNode rowsSetExpr = ((AxisNode)axes.get(1)).getExpression();
        ParserTest.assertNotNull((String)"Row tuples", (Object)rowsSetExpr);
        fun = (CallNode)rowsSetExpr;
        identifier = (IdentifierNode)fun.getArgList().get(0);
        ParserTest.assertEquals((int)1, (int)identifier.getSegmentList().size());
        ParserTest.assertEquals((String)"Correct member on axis", (String)"axis1mbr", (String)((IdentifierSegment)identifier.getSegmentList().get(0)).getName());
    }

    public void testMemberOnAxis() {
        this.assertParseQuery("select [Measures].[Sales Count] on 0, non empty [Store].[Store State].members on 1 from [Sales]", "SELECT\n[Measures].[Sales Count] ON COLUMNS,\nNON EMPTY [Store].[Store State].members ON ROWS\nFROM [Sales]");
    }

    public void testCaseTest() {
        this.assertParseQuery("with member [Measures].[Foo] as  ' case when x = y then \"eq\" when x < y then \"lt\" else \"gt\" end 'select {[foo]} on axis(0) from cube", "WITH\nMEMBER [Measures].[Foo] AS\n    CASE WHEN (x = y) THEN \"eq\" WHEN (x < y) THEN \"lt\" ELSE \"gt\" END\nSELECT\n{[foo]} ON COLUMNS\nFROM cube");
    }

    public void testCaseSwitch() {
        this.assertParseQuery("with member [Measures].[Foo] as  ' case x when 1 then 2 when 3 then 4 else 5 end 'select {[foo]} on axis(0) from cube", "WITH\nMEMBER [Measures].[Foo] AS\n    CASE x WHEN 1 THEN 2 WHEN 3 THEN 4 ELSE 5 END\nSELECT\n{[foo]} ON COLUMNS\nFROM cube");
    }

    public void testSetExpr() {
        this.assertParseQuery("with set [Set1] as '[Product].[Drink]:[Product].[Food]' \nselect [Set1] on columns, {[Measures].defaultMember} on rows \nfrom Sales", "WITH\nSET [Set1] AS\n    ([Product].[Drink] : [Product].[Food])\nSELECT\n[Set1] ON COLUMNS,\n{[Measures].defaultMember} ON ROWS\nFROM Sales");
        this.assertParseQuery("select [Product].[Drink]:[Product].[Food] on columns,\n {[Measures].defaultMember} on rows \nfrom Sales", "SELECT\n([Product].[Drink] : [Product].[Food]) ON COLUMNS,\n{[Measures].defaultMember} ON ROWS\nFROM Sales");
    }

    public void testDimensionProperties() {
        this.assertParseQuery("select {[foo]} properties p1,   p2 on columns from [cube]", "SELECT\n{[foo]} DIMENSION PROPERTIES p1, p2 ON COLUMNS\nFROM [cube]");
    }

    public void testCellProperties() {
        this.assertParseQuery("select {[foo]} on columns from [cube] CELL PROPERTIES FORMATTED_VALUE", "SELECT\n{[foo]} ON COLUMNS\nFROM [cube]\nCELL PROPERTIES FORMATTED_VALUE");
    }

    public void testIsEmpty() {
        this.assertParseExpr("[Measures].[Unit Sales] IS EMPTY", "([Measures].[Unit Sales] IS EMPTY)");
        this.assertParseExpr("[Measures].[Unit Sales] IS EMPTY AND 1 IS NULL", "(([Measures].[Unit Sales] IS EMPTY) AND (1 IS NULL))");
        this.assertParseExpr("- x * 5 is empty is empty is null + 56", "(((((- x) * 5) IS EMPTY) IS EMPTY) IS (NULL + 56))", true);
    }

    public void testIs() {
        this.assertParseExpr("[Measures].[Unit Sales] IS [Measures].[Unit Sales] AND [Measures].[Unit Sales] IS NULL", "(([Measures].[Unit Sales] IS [Measures].[Unit Sales]) AND ([Measures].[Unit Sales] IS NULL))");
    }

    public void testIsNull() {
        this.assertParseExpr("[Measures].[Unit Sales] IS NULL", "([Measures].[Unit Sales] IS NULL)");
        this.assertParseExpr("[Measures].[Unit Sales] IS NULL AND 1 <> 2", "(([Measures].[Unit Sales] IS NULL) AND (1 <> 2))");
        this.assertParseExpr("x is null or y is null and z = 5", "((x IS NULL) OR ((y IS NULL) AND (z = 5)))");
        this.assertParseExpr("(x is null) + 56 > 6", "(((x IS NULL) + 56) > 6)");
        this.assertParseExpr("x is null and a = b or c = d + 5 is null + 5", "(((x IS NULL) AND (a = b)) OR ((c = (d + 5)) IS (NULL + 5)))", true);
    }

    public void testNull() {
        this.assertParseExpr("Filter({[Measures].[Foo]}, Iif(1 = 2, NULL, 'X'))", "Filter({[Measures].[Foo]}, Iif((1 = 2), NULL, \"X\"))");
    }

    public void testCast() {
        this.assertParseExpr("Cast([Measures].[Unit Sales] AS Numeric)", "CAST([Measures].[Unit Sales] AS Numeric)");
        this.assertParseExpr("Cast(1 + 2 AS String)", "CAST((1 + 2) AS String)");
    }

    public void testMultiplication() {
        MdxParser p = this.createParser();
        String mdx = this.wrapExpr("([Measures].[Unit Sales] * [Measures].[Store Cost] * [Measures].[Store Sales])");
        this.assertParseQuery(mdx, "WITH\nMEMBER [Measures].[Foo] AS\n    (([Measures].[Unit Sales] * [Measures].[Store Cost]) * [Measures].[Store Sales])\nSELECT\nFROM [Sales]");
    }

    public void testBangFunction() {
        this.assertParseExpr("foo!bar!Exp(2.0)", "Exp(2.0)");
        this.assertParseExpr("1 + VBA!Exp(2.0 + 3)", "(1 + Exp((2.0 + 3)))");
    }

    public void testId() {
        this.assertParseExpr("foo", "foo");
        this.assertParseExpr("fOo", "fOo");
        this.assertParseExpr("[Foo].[Bar Baz]", "[Foo].[Bar Baz]");
        this.assertParseExpr("[Foo].&[Bar]", "[Foo].&[Bar]");
    }

    public void testIdWithKey() {
        String mdx = "[Foo].&Key1&Key2.&[Key3]&Key4&[5]";
        this.assertParseExpr("[Foo].&Key1&Key2.&[Key3]&Key4&[5]", "[Foo].&Key1&Key2.&[Key3]&Key4&[5]");
        MdxParser p = this.createParser();
        String mdxQuery = this.wrapExpr("[Foo].&Key1&Key2.&[Key3]&Key4&[5]");
        SelectNode selectNode = p.parseSelect(mdxQuery);
        ParserTest.assertEquals((int)1, (int)selectNode.getWithList().size());
        WithMemberNode withMember = (WithMemberNode)selectNode.getWithList().get(0);
        ParseTreeNode expr = withMember.getExpression();
        IdentifierNode id = (IdentifierNode)expr;
        ParserTest.assertNotNull((Object)id.getRegion());
        ParserTest.assertEquals((int)3, (int)id.getSegmentList().size());
        IdentifierSegment seg0 = (IdentifierSegment)id.getSegmentList().get(0);
        ParserTest.assertNotNull((Object)seg0.getRegion());
        ParserTest.assertEquals((String)"Foo", (String)seg0.getName());
        ParserTest.assertEquals((Object)Quoting.QUOTED, (Object)seg0.getQuoting());
        IdentifierSegment seg1 = (IdentifierSegment)id.getSegmentList().get(1);
        ParserTest.assertEquals((Object)Quoting.KEY, (Object)seg1.getQuoting());
        ParserTest.assertNull((Object)seg1.getName());
        List keyParts = seg1.getKeyParts();
        ParserTest.assertNotNull((Object)keyParts);
        ParserTest.assertEquals((int)2, (int)keyParts.size());
        ParserTest.assertEquals((String)"Key1", (String)((NameSegment)keyParts.get(0)).getName());
        ParserTest.assertEquals((Object)Quoting.UNQUOTED, (Object)((NameSegment)keyParts.get(0)).getQuoting());
        ParserTest.assertEquals((String)"Key2", (String)((NameSegment)keyParts.get(1)).getName());
        ParserTest.assertEquals((Object)Quoting.UNQUOTED, (Object)((NameSegment)keyParts.get(1)).getQuoting());
        IdentifierSegment seg2 = (IdentifierSegment)id.getSegmentList().get(2);
        ParserTest.assertNotNull((Object)seg2.getRegion());
        ParserTest.assertEquals((Object)Quoting.KEY, (Object)seg2.getQuoting());
        List keyParts2 = seg2.getKeyParts();
        ParserTest.assertNotNull((Object)keyParts2);
        ParserTest.assertEquals((int)3, (int)keyParts2.size());
        ParserTest.assertEquals((Object)Quoting.QUOTED, (Object)((NameSegment)keyParts2.get(0)).getQuoting());
        ParserTest.assertEquals((Object)Quoting.UNQUOTED, (Object)((NameSegment)keyParts2.get(1)).getQuoting());
        ParserTest.assertEquals((Object)Quoting.QUOTED, (Object)((NameSegment)keyParts2.get(2)).getQuoting());
        ParserTest.assertEquals((String)"5", (String)((NameSegment)keyParts2.get(2)).getName());
        ParserTest.assertNotNull((Object)((NameSegment)keyParts2.get(2)).getRegion());
        String actual = TestContext.toString(expr);
        TestContext.assertEqualsVerbose("[Foo].&Key1&Key2.&[Key3]&Key4&[5]", actual);
    }

    public void testIdComplex() {
        this.assertParseExpr("[Foo].&[Key1]&[Key2].[Bar]", "[Foo].&[Key1]&[Key2].[Bar]");
        this.assertParseExpr("[Foo].&[1]&[Key 2]&[3].[Bar]", "[Foo].&[1]&[Key 2]&[3].[Bar]");
        this.assertParseExpr("[Foo].&Key1&Key2 + 4", "([Foo].&Key1&Key2 + 4)");
        this.assertParseExprFails("[Foo].&[1]&[Key2]&^3.[Bar]", "Lexical error at line 1, column 51\\.  Encountered: \"3\" \\(51\\), after : \"&\"");
        this.assertParseExprFails("[Foo].&^ [Key2].[Bar]", "Lexical error at line 1, column 40\\.  Encountered: \" \" \\(32\\), after : \"&\"");
        this.assertParseExprFails("[Foo].&^_Key2.[Bar]", "Lexical error at line 1, column 40\\.  Encountered: \"_\" \\(95\\), after : \"&\"");
        this.assertParseExpr("[Foo].&[_Key2].[Bar]", "[Foo].&[_Key2].[Bar]");
    }

    public void _testCloneQuery() throws SQLException {
        OlapConnection olapConnection = this.getOlapConnection();
        MdxParser mdxParser = olapConnection.getParserFactory().createMdxParser(olapConnection);
        SelectNode query = mdxParser.parseSelect("select {[Measures].Members} on columns,\n {[Store].Members} on rows\nfrom [Sales]\nwhere ([Gender].[M])");
        ParseTreeNode selectClone = null;
        ParserTest.assertTrue((boolean)(selectClone instanceof SelectNode));
        ParserTest.assertEquals((String)TestContext.toString(selectClone), (String)TestContext.toString((ParseTreeNode)query));
    }

    public void testNumbers() {
        this.assertParseExpr("2", "2");
        this.assertParseExpr("-3", "(- 3)");
        this.assertParseExpr("+45", "45");
        this.assertParseExprFails("4 ^5^", "Syntax error at line 1, column 35, token '5'");
        this.assertParseExpr("3.14", "3.14");
        this.assertParseExpr(".12345", "0.12345");
        this.assertParseExpr("31415926535.89793", "31415926535.89793");
        this.assertParseExpr("31415926535897.9314159265358979", "31415926535897.9314159265358979");
        this.assertParseExpr("3.141592653589793", "3.141592653589793");
        this.assertParseExpr("-3141592653589793.14159265358979", "(- 3141592653589793.14159265358979)");
        this.assertParseExpr("1e2", "100", true);
        this.assertParseExpr("1e2", Olap4jUtil.PreJdk15 ? "100" : "1E+2", false);
        this.assertParseExprFails("1e2^e3^", "Syntax error at .* token 'e3'");
        this.assertParseExpr("1.2e3", "1200", true);
        this.assertParseExpr("1.2e3", Olap4jUtil.PreJdk15 ? "1200" : "1.2E+3", false);
        this.assertParseExpr("-1.2345e3", "(- 1234.5)");
        this.assertParseExprFails("1.2e3^.4^", "Syntax error at .* token '\\.4'");
        this.assertParseExpr(".00234e0003", "2.34");
        this.assertParseExpr(".00234e-0067", Olap4jUtil.PreJdk15 ? "0.000000000000000000000000000000000000000000000000000000000000000000000234" : "2.34E-70");
    }

    public void testLargePrecision() {
        this.assertParseQuery("with member [Measures].[Small Number] as '[Measures].[Store Sales] / 9000'\nselect\n{[Measures].[Small Number]} on columns,\n{Filter([Product].[Product Department].members, [Measures].[Small Number] >= 0.3\nand [Measures].[Small Number] <= 0.5000001234)} on rows\nfrom Sales\nwhere ([Time].[1997].[Q2].[4])", "WITH\nMEMBER [Measures].[Small Number] AS\n    ([Measures].[Store Sales] / 9000)\nSELECT\n{[Measures].[Small Number]} ON COLUMNS,\n{Filter([Product].[Product Department].members, (([Measures].[Small Number] >= 0.3) AND ([Measures].[Small Number] <= 0.5000001234)))} ON ROWS\nFROM Sales\nWHERE ([Time].[1997].[Q2].[4])");
    }

    public void testIdentifier() {
        IdentifierNode id;
        try {
            id = new IdentifierNode(new IdentifierSegment[0]);
            ParserTest.fail((String)("expected exception, got " + id));
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        id = new IdentifierNode(new IdentifierSegment[]{new NameSegment("foo")});
        ParserTest.assertEquals((String)"[foo]", (String)id.toString());
        IdentifierNode id2 = id.append((IdentifierSegment)new KeySegment(new NameSegment[]{new NameSegment(null, "bar", Quoting.QUOTED)}));
        ParserTest.assertTrue((id != id2 ? 1 : 0) != 0);
        ParserTest.assertEquals((String)"[foo]", (String)id.toString());
        ParserTest.assertEquals((String)"[foo].&[bar]", (String)id2.toString());
        List segments = id.getSegmentList();
        try {
            segments.remove(0);
            ParserTest.fail((String)"expected exception");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            segments.clear();
            ParserTest.fail((String)"expected exception");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            segments.add(new NameSegment("baz"));
            ParserTest.fail((String)"expected exception");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
    }

    public void testEmptyExpr() {
        this.assertParseQuery("select NON EMPTY HIERARCHIZE(\n  {DrillDownLevelTop(\n     {[Product].[All Products]},3,,[Measures].[Unit Sales])}  ) ON COLUMNS\nfrom [Sales]\n", "SELECT\nNON EMPTY HIERARCHIZE({DrillDownLevelTop({[Product].[All Products]}, 3, , [Measures].[Unit Sales])}) ON COLUMNS\nFROM [Sales]");
        this.assertParseQuery("SELECT {[Measures].[NetSales]} DIMENSION PROPERTIES PARENT_UNIQUE_NAME ON COLUMNS , NON EMPTY HIERARCHIZE(AddCalculatedMembers({DrillDownLevelTop({[ProductDim].[Name].[All]}, 10, , [Measures].[NetSales])})) DIMENSION PROPERTIES PARENT_UNIQUE_NAME ON ROWS FROM [cube]", "SELECT\n{[Measures].[NetSales]} DIMENSION PROPERTIES PARENT_UNIQUE_NAME ON COLUMNS,\nNON EMPTY HIERARCHIZE(AddCalculatedMembers({DrillDownLevelTop({[ProductDim].[Name].[All]}, 10, , [Measures].[NetSales])})) DIMENSION PROPERTIES PARENT_UNIQUE_NAME ON ROWS\nFROM [cube]");
    }

    public void testInnerSelect() {
        this.assertParseQuery("SELECT FROM (SELECT ({[ProductDim].[Product Group].&[Mobile Phones]}) ON COLUMNS FROM [cube]) CELL PROPERTIES VALUE", "SELECT\nFROM (\n    SELECT\n    {[ProductDim].[Product Group].&[Mobile Phones]} ON COLUMNS\n    FROM [cube])\nCELL PROPERTIES VALUE");
    }

    public void testWithAdd() {
        SelectNode selectNode = new SelectNode();
        IdentifierNode startDate = new IdentifierNode(new IdentifierSegment[]{new NameSegment("Date"), new NameSegment("2010-01-03")});
        IdentifierNode endDate = new IdentifierNode(new IdentifierSegment[]{new NameSegment("Date"), new NameSegment("2010-10-03")});
        IdentifierNode name = new IdentifierNode(new IdentifierSegment[]{new NameSegment("Date"), new NameSegment("Date Range")});
        CallNode cn = new CallNode(null, ":", Syntax.Infix, new ParseTreeNode[]{startDate, endDate});
        CallNode exp = new CallNode(null, "Aggregate", Syntax.Function, new ParseTreeNode[]{new CallNode(null, "{}", Syntax.Braces, new ParseTreeNode[]{cn})});
        WithMemberNode withMemberNode = new WithMemberNode(null, name, (ParseTreeNode)exp, Collections.emptyList());
        selectNode.setFrom((ParseTreeNode)IdentifierNode.parseIdentifier((String)"Sales"));
        selectNode.getWithList().add(withMemberNode);
        String queryString = selectNode.toString();
        TestContext.assertEqualsVerbose("WITH\nMEMBER [Date].[Date Range] AS\n    Aggregate({([Date].[2010-01-03] : [Date].[2010-10-03])})\nSELECT\nFROM Sales", queryString);
        this.assertParseQuery(queryString, TestContext.unfold(queryString));
    }

    public void testChildren() {
        MdxParser p = this.createParser();
        ParseTreeNode node = p.parseExpression("[Store].[USA].CHILDREN");
        this.checkChildren(node, "CHILDREN");
        ParseTreeNode node2 = p.parseExpression("[Store].[USA].Children");
        this.checkChildren(node2, "Children");
        ParseTreeNode node3 = p.parseExpression("[Store].[USA].children");
        this.checkChildren(node3, "children");
    }

    private void checkChildren(ParseTreeNode node, String name) {
        ParserTest.assertTrue((boolean)(node instanceof CallNode));
        CallNode call = (CallNode)node;
        ParserTest.assertEquals((String)name, (String)call.getOperatorName());
        ParserTest.assertTrue((boolean)(call.getArgList().get(0) instanceof IdentifierNode));
        ParserTest.assertEquals((String)"[Store].[USA]", (String)((ParseTreeNode)call.getArgList().get(0)).toString());
        ParserTest.assertEquals((int)1, (int)call.getArgList().size());
    }

    private void assertParseQuery(String mdx, String expected) {
        MdxParser p = this.createParser();
        SelectNode selectNode = p.parseSelect(mdx);
        String actual = TestContext.toString((ParseTreeNode)selectNode);
        TestContext.assertEqualsVerbose(expected, actual);
    }

    private void assertParseExpr(String expr, String expected) {
        MdxParser p = this.createParser();
        String mdx = this.wrapExpr(expr);
        SelectNode selectNode = p.parseSelect(mdx);
        ParserTest.assertEquals((int)1, (int)selectNode.getWithList().size());
        WithMemberNode withMember = (WithMemberNode)selectNode.getWithList().get(0);
        String actual = TestContext.toString(withMember.getExpression());
        TestContext.assertEqualsVerbose(expected, actual);
    }

    private String wrapExpr(String expr) {
        return "with member [Measures].[Foo] as " + expr + "\n select from [Sales]";
    }

    static Checker regexpChecker(String pattern) {
        return new RegexpChecker(pattern);
    }

    static class RegexpChecker
    implements Checker {
        private final String pattern;

        public RegexpChecker(String pattern) {
            this.pattern = pattern;
        }

        public String toString() {
            return "regex(" + this.pattern + ")";
        }

        public boolean apply(Throwable e) {
            return e.getMessage() != null && e.getMessage().matches(this.pattern);
        }
    }

    static interface Checker {
        public boolean apply(Throwable var1);
    }
}

