/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.olap4j.impl.ArrayMap;
import org.olap4j.impl.UnmodifiableArrayMap;

public class ArrayMapTest
extends TestCase {
    public void testArrayMap() {
        ArrayMap map = new ArrayMap();
        map.clear();
        ArrayMapTest.assertEquals((int)0, (int)map.size());
        ArrayMapTest.assertTrue((boolean)map.isEmpty());
        map.put((Object)"Paul", (Object)4);
        ArrayMapTest.assertEquals((int)1, (int)map.size());
        ArrayMapTest.assertFalse((boolean)map.isEmpty());
        ArrayMapTest.assertTrue((boolean)map.containsKey((Object)"Paul"));
        ArrayMapTest.assertFalse((boolean)map.containsKey((Object)"Keith"));
        Integer value = (Integer)map.put((Object)"Paul", (Object)5);
        ArrayMapTest.assertEquals((int)1, (int)map.size());
        ArrayMapTest.assertEquals((int)4, (int)value);
        ArrayMapTest.assertEquals((int)5, (int)((Integer)map.get((Object)"Paul")));
        map.put((Object)"Paul", null);
        ArrayMapTest.assertNull((Object)map.get((Object)"Paul"));
        ArrayMapTest.assertTrue((boolean)map.containsKey((Object)"Paul"));
        map.put(null, (Object)-99);
        ArrayMapTest.assertEquals((int)-99, (int)((Integer)map.get(null)));
        ArrayMapTest.assertTrue((boolean)map.containsKey(null));
        ArrayMapTest.assertEquals((int)-99, (int)((Integer)map.remove(null)));
        ArrayMap beatles = new ArrayMap();
        beatles.put("John", 4);
        beatles.put("Paul", 4);
        beatles.put("George", 6);
        beatles.put("Ringo", 5);
        map.putAll((Map)beatles);
        ArrayMapTest.assertEquals((int)4, (int)map.size());
        ArrayMapTest.assertEquals(new HashSet<String>(Arrays.asList("John", "Paul", "George", "Ringo")), (Object)map.keySet());
        ArrayMapTest.assertEquals(Arrays.asList(4, 4, 6, 5), (Object)map.values());
        String keys = "";
        int valueTotal = 0;
        for (Map.Entry entry : map.entrySet()) {
            valueTotal += ((Integer)entry.getValue()).intValue();
            keys = keys + (String)entry.getKey();
        }
        ArrayMapTest.assertEquals((int)19, (int)valueTotal);
        ArrayMapTest.assertEquals((String)"PaulJohnGeorgeRingo", (String)keys);
        value = (Integer)map.remove((Object)"Mick");
        ArrayMapTest.assertNull((Object)value);
        ArrayMapTest.assertEquals((int)4, (int)map.size());
        value = (Integer)map.remove((Object)"Ringo");
        ArrayMapTest.assertEquals((int)5, (int)value);
        ArrayMapTest.assertEquals((int)3, (int)map.size());
        value = (Integer)map.remove((Object)"Paul");
        ArrayMapTest.assertEquals((int)4, (int)value);
        ArrayMapTest.assertEquals((int)2, (int)map.size());
        map.put((Object)"Paul", (Object)27);
        ArrayMapTest.assertEquals(Arrays.asList(4, 6, 27), (Object)map.values());
        map.remove((Object)"George");
        ArrayMapTest.assertEquals((int)2, (int)map.size());
    }

    public void testArrayMap2() {
        ArrayMap map = new ArrayMap();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        ArrayMapTest.assertEquals((int)0, (int)map.size());
        ArrayMapTest.assertEquals((Object)map, hashMap);
        ArrayMapTest.assertEquals((int)map.hashCode(), (int)hashMap.hashCode());
        map.put((Object)"foo", (Object)0);
        ArrayMapTest.assertEquals((int)1, (int)map.size());
        ArrayMapTest.assertEquals((int)1, (int)map.keySet().size());
        ArrayMapTest.assertEquals((int)1, (int)map.values().size());
        hashMap.put("foo", 0);
        ArrayMapTest.assertEquals((Object)map, hashMap);
        ArrayMapTest.assertEquals(hashMap, (Object)map);
        ArrayMapTest.assertEquals((int)map.hashCode(), (int)hashMap.hashCode());
        ArrayMapTest.assertTrue((boolean)map.containsKey((Object)"foo"));
        ArrayMapTest.assertFalse((boolean)map.containsKey((Object)"bar"));
        ArrayMapTest.assertEquals((Object)0, (Object)map.get((Object)"foo"));
        ArrayMapTest.assertNull((Object)map.get((Object)"baz"));
        HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
        hashMap2.put("bar", 1);
        hashMap2.put("foo", 2);
        hashMap2.put("baz", 0);
        map.putAll(hashMap2);
        hashMap.putAll(hashMap2);
        ArrayMapTest.assertEquals((int)3, (int)map.size());
        ArrayMapTest.assertEquals((Object)map, hashMap);
        ArrayMapTest.assertEquals(hashMap, (Object)map);
        ArrayMapTest.assertEquals((int)map.hashCode(), (int)hashMap.hashCode());
        ArrayMapTest.assertEquals((Object)map.keySet(), hashMap.keySet());
        ArrayMapTest.assertEquals(new HashSet(map.values()), new HashSet(hashMap.values()));
        map.put((Object)"foo", (Object)-5);
        hashMap.put("foo", -5);
        ArrayMapTest.assertEquals((int)3, (int)map.size());
        ArrayMapTest.assertEquals((Object)-5, (Object)map.get((Object)"foo"));
        ArrayMapTest.assertEquals((Object)map, hashMap);
        ArrayMapTest.assertEquals(hashMap, (Object)map);
        ArrayMapTest.assertFalse((boolean)map.containsKey(null));
        map.put(null, (Object)75);
        ArrayMapTest.assertEquals((Object)75, (Object)map.get(null));
        ArrayMapTest.assertTrue((boolean)map.containsKey(null));
        map.put((Object)"zzzz", null);
        ArrayMapTest.assertTrue((boolean)map.containsKey((Object)"zzzz"));
        ArrayMapTest.assertNull((Object)map.get((Object)"zzzz"));
        hashMap.put(null, 75);
        hashMap.put("zzzz", null);
        ArrayMapTest.assertEquals((Object)map, hashMap);
        ArrayMapTest.assertEquals(hashMap, (Object)map);
        ArrayMapTest.assertFalse((boolean)map.isEmpty());
        map.clear();
        ArrayMapTest.assertTrue((boolean)map.isEmpty());
        ArrayMapTest.assertEquals((int)0, (int)map.size());
        ArrayMap map2 = new ArrayMap();
        map2.putAll(hashMap);
        ArrayMapTest.assertEquals((Object)map2, hashMap);
        ArrayMap map3 = new ArrayMap(hashMap);
        ArrayMapTest.assertEquals((Object)map3, hashMap);
        Map map4 = ArrayMap.of((Object)"foo", (Object)-5, (Object[])new Object[]{"bar", 1, "baz", 0, null, 75, "zzzz", null});
        ArrayMapTest.assertEquals((Object)map4, hashMap);
        ArrayMapTest.assertEquals((String)"{foo=-5, bar=1, baz=0, null=75, zzzz=null}", (String)map4.toString());
        ArrayMapTest.assertEquals((String)"{}", (String)new ArrayMap().toString());
    }

    public void testUnmodifiableArrayMap() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        UnmodifiableArrayMap map = new UnmodifiableArrayMap(hashMap);
        ArrayMapTest.assertEquals((int)0, (int)map.size());
        ArrayMapTest.assertEquals((Object)map, hashMap);
        ArrayMapTest.assertEquals((int)map.hashCode(), (int)hashMap.hashCode());
        try {
            int x = map.put("foo", 0);
            ArrayMapTest.fail((String)("expected fail, got " + x));
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        hashMap.put("foo", 0);
        map = new UnmodifiableArrayMap(hashMap);
        ArrayMapTest.assertEquals((int)1, (int)map.size());
        ArrayMapTest.assertEquals((int)1, (int)map.keySet().size());
        ArrayMapTest.assertEquals((int)1, (int)map.values().size());
        ArrayMapTest.assertEquals((Object)map, hashMap);
        ArrayMapTest.assertEquals(hashMap, (Object)map);
        ArrayMapTest.assertEquals((int)map.hashCode(), (int)hashMap.hashCode());
        ArrayMapTest.assertTrue((boolean)map.containsKey("foo"));
        ArrayMapTest.assertFalse((boolean)map.containsKey("bar"));
        ArrayMapTest.assertEquals((Object)0, map.get("foo"));
        ArrayMapTest.assertNull(map.get("baz"));
        HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
        hashMap2.put("bar", 1);
        hashMap2.put("foo", 2);
        hashMap2.put("baz", 0);
        try {
            map.putAll(hashMap2);
            ArrayMapTest.fail((String)"expected fail");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        hashMap.putAll(hashMap2);
        map = new UnmodifiableArrayMap(hashMap);
        ArrayMapTest.assertEquals((int)3, (int)map.size());
        ArrayMapTest.assertEquals((Object)map, hashMap);
        ArrayMapTest.assertEquals(hashMap, (Object)map);
        ArrayMapTest.assertEquals((int)map.hashCode(), (int)hashMap.hashCode());
        ArrayMapTest.assertEquals(map.keySet(), hashMap.keySet());
        ArrayMapTest.assertEquals(new HashSet(map.values()), new HashSet(hashMap.values()));
        try {
            int x = map.put("foo", -5);
            ArrayMapTest.fail((String)("expected fail, got " + x));
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        hashMap.put("foo", -5);
        map = new UnmodifiableArrayMap(hashMap);
        ArrayMapTest.assertEquals((int)3, (int)map.size());
        ArrayMapTest.assertEquals((Object)-5, map.get("foo"));
        ArrayMapTest.assertEquals((Object)map, hashMap);
        ArrayMapTest.assertEquals(hashMap, (Object)map);
        ArrayMapTest.assertFalse((boolean)map.containsKey(null));
        hashMap.put(null, 75);
        map = new UnmodifiableArrayMap(hashMap);
        ArrayMapTest.assertEquals((Object)75, map.get(null));
        ArrayMapTest.assertTrue((boolean)map.containsKey(null));
        hashMap.put("zzzz", null);
        map = new UnmodifiableArrayMap(hashMap);
        ArrayMapTest.assertTrue((boolean)map.containsKey("zzzz"));
        ArrayMapTest.assertNull(map.get("zzzz"));
        ArrayMapTest.assertEquals((Object)map, hashMap);
        ArrayMapTest.assertEquals(hashMap, (Object)map);
        ArrayMapTest.assertFalse((boolean)map.isEmpty());
        try {
            map.clear();
            ArrayMapTest.fail((String)"expected fail");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        ArrayMapTest.assertTrue((boolean)new UnmodifiableArrayMap(Collections.emptyMap()).isEmpty());
        UnmodifiableArrayMap map3 = new UnmodifiableArrayMap(hashMap);
        ArrayMapTest.assertEquals((Object)map3, hashMap);
        Map map4 = UnmodifiableArrayMap.of((Object)"foo", (Object)-5, (Object[])new Object[]{"bar", 1, "baz", 0, null, 75, "zzzz", null});
        ArrayMapTest.assertEquals((Object)map4, hashMap);
        List<String> keyList = Arrays.asList("foo", "bar", "baz", null, "zzzz");
        ArrayMapTest.assertEquals(new ArrayList(map4.keySet()), keyList);
        List<Integer> valueList = Arrays.asList(-5, 1, 0, 75, null);
        ArrayMapTest.assertEquals(new ArrayList(map4.values()), valueList);
        Iterator<Integer> valueIter = valueList.iterator();
        Iterator<String> keyIter = keyList.iterator();
        for (Map.Entry entry : map4.entrySet()) {
            ArrayMapTest.assertEquals((String)((String)entry.getKey()), (String)keyIter.next());
            ArrayMapTest.assertEquals(entry.getValue(), (Object)valueIter.next());
        }
        ArrayMapTest.assertFalse((boolean)keyIter.hasNext());
        ArrayMapTest.assertFalse((boolean)valueIter.hasNext());
        hashMap.clear();
        Map map5 = UnmodifiableArrayMap.of(hashMap);
        ArrayMapTest.assertTrue((map5 == Collections.emptyMap() ? 1 : 0) != 0);
        hashMap.put("foo", -5);
        Map map6 = UnmodifiableArrayMap.of(hashMap);
        ArrayMapTest.assertTrue((map6.getClass() == Collections.singletonMap("7", "y").getClass() ? 1 : 0) != 0);
        hashMap.put("bar", 1);
        hashMap.put("baz", 0);
        Map map7 = UnmodifiableArrayMap.of(hashMap);
        ArrayMapTest.assertEquals((Object)map7, hashMap);
        ArrayMapTest.assertEquals((String)"{foo=-5, bar=1, baz=0, null=75, zzzz=null}", (String)map4.toString());
        ArrayMapTest.assertEquals((String)"{}", (String)map5.toString());
    }
}

