/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.mdx;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.olap4j.mdx.IdentifierNode;
import org.olap4j.mdx.IdentifierSegment;
import org.olap4j.mdx.NameSegment;
import org.olap4j.mdx.Quoting;
import org.olap4j.mdx.SelectNode;
import org.olap4j.mdx.parser.impl.DefaultMdxParserImpl;
import org.olap4j.test.TestContext;

public class MdxTest
extends TestCase {
    public void testQuoteMdxIdentifier() {
        MdxTest.assertEquals((String)"[San Francisco]", (String)IdentifierNode.quoteMdxIdentifier((String)"San Francisco"));
        MdxTest.assertEquals((String)"[a [bracketed]] string]", (String)IdentifierNode.quoteMdxIdentifier((String)"a [bracketed] string"));
        MdxTest.assertEquals((String)"[Store].[USA].[California]", (String)IdentifierNode.unparseIdentifierList(Arrays.asList(new NameSegment(null, "Store", Quoting.QUOTED), new NameSegment(null, "USA", Quoting.QUOTED), new NameSegment(null, "California", Quoting.QUOTED))));
    }

    public void testImplode() {
        List<IdentifierSegment> fooBar = Arrays.asList(new NameSegment(null, "foo", Quoting.UNQUOTED), new NameSegment(null, "bar", Quoting.QUOTED));
        MdxTest.assertEquals((String)"foo.[bar]", (String)IdentifierNode.unparseIdentifierList(fooBar));
        List empty = Collections.emptyList();
        MdxTest.assertEquals((String)"", (String)IdentifierNode.unparseIdentifierList(empty));
        List<IdentifierSegment> nasty = Arrays.asList(new NameSegment(null, "string", Quoting.QUOTED), new NameSegment(null, "with", Quoting.QUOTED), new NameSegment(null, "a [bracket] in it", Quoting.QUOTED));
        MdxTest.assertEquals((String)"[string].[with].[a [bracket]] in it]", (String)IdentifierNode.unparseIdentifierList(nasty));
    }

    public void testParseIdentifier() {
        List segments = IdentifierNode.parseIdentifier((String)"[string].[with].[a [bracket]] in it]").getSegmentList();
        MdxTest.assertEquals((int)3, (int)segments.size());
        MdxTest.assertEquals((String)"a [bracket] in it", (String)((IdentifierSegment)segments.get(2)).getName());
        MdxTest.assertEquals((Object)Quoting.QUOTED, (Object)((IdentifierSegment)segments.get(2)).getQuoting());
        segments = IdentifierNode.parseIdentifier((String)"[Worklog].[All].[calendar-[LANGUAGE]].js]").getSegmentList();
        MdxTest.assertEquals((int)3, (int)segments.size());
        MdxTest.assertEquals((String)"calendar-[LANGUAGE].js", (String)((IdentifierSegment)segments.get(2)).getName());
        segments = IdentifierNode.parseIdentifier((String)"[foo].bar").getSegmentList();
        MdxTest.assertEquals((int)2, (int)segments.size());
        MdxTest.assertEquals((Object)Quoting.QUOTED, (Object)((IdentifierSegment)segments.get(0)).getQuoting());
        MdxTest.assertEquals((Object)Quoting.UNQUOTED, (Object)((IdentifierSegment)segments.get(1)).getQuoting());
        try {
            segments = IdentifierNode.parseIdentifier((String)"[foo].[bar").getSegmentList();
            MdxTest.fail((String)("expected exception, got " + segments));
        }
        catch (RuntimeException e) {
            MdxTest.assertEquals((String)"Expected ']', in member identifier '[foo].[bar'", (String)e.getMessage());
        }
    }

    public void testIdentifierOfNames() {
        IdentifierNode identifierNode = IdentifierNode.ofNames((String[])new String[]{"string", "with", "a [bracket] in it"});
        List segments = identifierNode.getSegmentList();
        MdxTest.assertEquals((int)3, (int)segments.size());
        MdxTest.assertEquals((String)"a [bracket] in it", (String)((IdentifierSegment)segments.get(2)).getName());
        MdxTest.assertEquals((Object)Quoting.QUOTED, (Object)((IdentifierSegment)segments.get(2)).getQuoting());
        MdxTest.assertEquals((String)"[string].[with].[a [bracket]] in it]", (String)identifierNode.toString());
        try {
            identifierNode = IdentifierNode.ofNames((String[])new String[0]);
            MdxTest.fail((String)("expected error, got " + identifierNode));
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            identifierNode = IdentifierNode.ofNames((String[])new String[]{"foo", null, "bar"});
            MdxTest.fail((String)("expected error, got " + identifierNode));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testQuoteEscaping() {
        String query = "WITH\nMEMBER [CustomerDim].[CustomerName].[XL_QZX] AS 'Aggregate({[CustomerDim].[CustomerName].&[ABC INT''L], [CustomerDim].[CustomerName].&[XYZ]})'\nSELECT\n{[Measures].[Sales]} ON COLUMNS\nFROM [cube]\nWHERE ([CustomerDim].[CustomerName].[XL_QZX])";
        DefaultMdxParserImpl parser = new DefaultMdxParserImpl();
        SelectNode rootNode = parser.parseSelect(query);
        TestContext.assertEqualsVerbose("WITH\nMEMBER [CustomerDim].[CustomerName].[XL_QZX] AS\n    Aggregate({[CustomerDim].[CustomerName].&[ABC INT'L], [CustomerDim].[CustomerName].&[XYZ]})\nSELECT\n{[Measures].[Sales]} ON COLUMNS\nFROM [cube]\nWHERE ([CustomerDim].[CustomerName].[XL_QZX])", rootNode.toString());
        query = "WITH SET Foo as Filter(Bar.Members, Instr(Name, \"'\") > 0)\nSELECT FROM [Cube]";
        rootNode = parser.parseSelect(query);
        TestContext.assertEqualsVerbose("WITH\nSET Foo AS\n    Filter(Bar.Members, (Instr(Name, \"'\") > 0))\nSELECT\nFROM [Cube]", rootNode.toString());
    }
}

