/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.olap4j.test.TestContext;

public class RemoteXmlaTester
implements TestContext.Tester {
    public static final String DRIVER_URL_PREFIX = "jdbc:xmla:";
    public static final String DRIVER_CLASS_NAME = "org.olap4j.driver.xmla.XmlaOlap4jDriver";
    private String url = null;
    private String user = null;
    private String password = null;
    private final TestContext testContext;

    public RemoteXmlaTester(TestContext testContext) {
        this.testContext = testContext;
        Properties properties = testContext.getProperties();
        this.url = properties.getProperty(TestContext.Property.REMOTE_XMLA_URL.path);
        if (this.url == null) {
            throw new RuntimeException("Property " + (Object)((Object)TestContext.Property.REMOTE_XMLA_URL) + " must be specified");
        }
        this.user = properties.getProperty(TestContext.Property.REMOTE_XMLA_USERNAME.path);
        this.password = properties.getProperty(TestContext.Property.REMOTE_XMLA_PASSWORD.path);
    }

    public TestContext getTestContext() {
        return this.testContext;
    }

    public Connection createConnection() throws SQLException {
        return this.createConnection(this.url, null, null);
    }

    public Connection createConnectionWithUserPassword() throws SQLException {
        return this.createConnection(this.url, this.user, this.password);
    }

    private Connection createConnection(String url, String user, String password) {
        try {
            Class.forName(DRIVER_CLASS_NAME);
            return DriverManager.getConnection(url, user, password);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getDriverClassName() {
        return DRIVER_CLASS_NAME;
    }

    public String getDriverUrlPrefix() {
        return DRIVER_URL_PREFIX;
    }

    public TestContext.Tester.Flavor getFlavor() {
        return TestContext.Tester.Flavor.REMOTE_XMLA;
    }

    public String getURL() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public TestContext.Wrapper getWrapper() {
        return TestContext.Wrapper.NONE;
    }
}

