/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j;

import java.sql.Connection;
import java.util.HashMap;
import junit.framework.TestCase;
import org.olap4j.OlapConnection;
import org.olap4j.metadata.Cube;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.Hierarchy;
import org.olap4j.metadata.Schema;
import org.olap4j.test.TestContext;

public class OlapTreeTest
extends TestCase {
    private TestContext.Tester tester = TestContext.instance().getTester();
    private Connection connection;

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.close();
            this.connection = null;
        }
        this.tester = null;
    }

    public void testHashCompatibility() throws Exception {
        this.connection = this.tester.createConnection();
        OlapConnection olapConnection = this.tester.getWrapper().unwrap(this.connection, OlapConnection.class);
        Schema schema = olapConnection.getOlapSchema();
        Cube cube = (Cube)schema.getCubes().get("Sales");
        HashMap<Dimension, String> dimensionMap = new HashMap<Dimension, String>();
        Dimension dim1 = (Dimension)cube.getDimensions().get("Promotion Media");
        dimensionMap.put(dim1, "Test1");
        OlapTreeTest.assertTrue((boolean)dimensionMap.containsKey(dim1));
        OlapTreeTest.assertEquals((String)"Test1", (String)((String)dimensionMap.get(dim1)));
        HashMap<Hierarchy, String> hierarchyMap = new HashMap<Hierarchy, String>();
        Hierarchy hchy1 = dim1.getDefaultHierarchy();
        hierarchyMap.put(hchy1, "Test2");
        OlapTreeTest.assertTrue((boolean)hierarchyMap.containsKey(hchy1));
        OlapTreeTest.assertEquals((String)"Test2", (String)((String)hierarchyMap.get(hchy1)));
        OlapTreeTest.assertTrue((boolean)dimensionMap.containsKey(hchy1.getDimension()));
    }
}

