/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import junit.framework.TestCase;
import org.olap4j.OlapConnection;
import org.olap4j.OlapDatabaseMetaData;
import org.olap4j.OlapException;
import org.olap4j.OlapStatement;
import org.olap4j.OlapWrapper;
import org.olap4j.metadata.Catalog;
import org.olap4j.metadata.Database;
import org.olap4j.metadata.Schema;
import org.olap4j.test.TestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataTest
extends TestCase {
    private TestContext testContext = TestContext.instance();
    private TestContext.Tester tester = this.testContext.getTester();
    private static final String NL = System.getProperty("line.separator");
    private Connection connection;
    private String catalogName;
    private OlapConnection olapConnection;
    private OlapDatabaseMetaData olapDatabaseMetaData;
    private final String propertyNamePattern;
    private final String dataSourceName = "xx";
    private static final List<String> CUBE_COLUMN_NAMES = Arrays.asList("CATALOG_NAME", "SCHEMA_NAME", "CUBE_NAME", "CUBE_TYPE", "CUBE_GUID", "CREATED_ON", "LAST_SCHEMA_UPDATE", "SCHEMA_UPDATED_BY", "LAST_DATA_UPDATE", "DATA_UPDATED_BY", "IS_DRILLTHROUGH_ENABLED", "IS_WRITE_ENABLED", "IS_LINKABLE", "IS_SQL_ENABLED", "DESCRIPTION");
    private static final List<String> LITERALS_COLUMN_NAMES = Arrays.asList("LITERAL_NAME", "LITERAL_VALUE", "LITERAL_INVALID_CHARS", "LITERAL_INVALID_STARTING_CHARS", "LITERAL_MAX_LENGTH");
    private static final List<String> SETS_COLUMN_NAMES = Arrays.asList("CATALOG_NAME", "SCHEMA_NAME", "CUBE_NAME", "SET_NAME", "SCOPE");
    private static final List<String> PROPERTIES_COLUMN_NAMES = Arrays.asList("CATALOG_NAME", "SCHEMA_NAME", "CUBE_NAME", "DIMENSION_UNIQUE_NAME", "HIERARCHY_UNIQUE_NAME", "LEVEL_UNIQUE_NAME", "MEMBER_UNIQUE_NAME", "PROPERTY_NAME", "PROPERTY_CAPTION", "PROPERTY_TYPE", "DATA_TYPE", "PROPERTY_CONTENT_TYPE", "DESCRIPTION");
    private static final List<String> MEMBERS_COLUMN_NAMES = Arrays.asList("CATALOG_NAME", "SCHEMA_NAME", "CUBE_NAME", "DIMENSION_UNIQUE_NAME", "HIERARCHY_UNIQUE_NAME", "LEVEL_UNIQUE_NAME", "LEVEL_NUMBER", "MEMBER_ORDINAL", "MEMBER_NAME", "MEMBER_UNIQUE_NAME", "MEMBER_TYPE", "MEMBER_GUID", "MEMBER_CAPTION", "CHILDREN_CARDINALITY", "PARENT_LEVEL", "PARENT_UNIQUE_NAME", "PARENT_COUNT", "TREE_OP", "DEPTH");
    private static final List<String> MEASURES_COLUMN_NAMES = Arrays.asList("CATALOG_NAME", "SCHEMA_NAME", "CUBE_NAME", "MEASURE_NAME", "MEASURE_UNIQUE_NAME", "MEASURE_CAPTION", "MEASURE_GUID", "MEASURE_AGGREGATOR", "DATA_TYPE", "MEASURE_IS_VISIBLE", "LEVELS_LIST", "DESCRIPTION");
    private static final List<String> LEVELS_COLUMN_NAMES = Arrays.asList("CATALOG_NAME", "SCHEMA_NAME", "CUBE_NAME", "DIMENSION_UNIQUE_NAME", "HIERARCHY_UNIQUE_NAME", "LEVEL_NAME", "LEVEL_UNIQUE_NAME", "LEVEL_GUID", "LEVEL_CAPTION", "LEVEL_NUMBER", "LEVEL_CARDINALITY", "LEVEL_TYPE", "CUSTOM_ROLLUP_SETTINGS", "LEVEL_UNIQUE_SETTINGS", "LEVEL_IS_VISIBLE", "DESCRIPTION");
    private static final List<String> HIERARCHIES_COLUMN_NAMES = Arrays.asList("CATALOG_NAME", "SCHEMA_NAME", "CUBE_NAME", "DIMENSION_UNIQUE_NAME", "HIERARCHY_NAME", "HIERARCHY_UNIQUE_NAME", "HIERARCHY_GUID", "HIERARCHY_CAPTION", "DIMENSION_TYPE", "HIERARCHY_CARDINALITY", "DEFAULT_MEMBER", "ALL_MEMBER", "DESCRIPTION", "STRUCTURE", "IS_VIRTUAL", "IS_READWRITE", "DIMENSION_UNIQUE_SETTINGS", "DIMENSION_IS_VISIBLE", "HIERARCHY_IS_VISIBLE", "HIERARCHY_ORDINAL", "DIMENSION_IS_SHARED", "PARENT_CHILD");
    private static final List<String> FUNCTIONS_COLUMN_NAMES = Arrays.asList("FUNCTION_NAME", "DESCRIPTION", "PARAMETER_LIST", "RETURN_TYPE", "ORIGIN", "INTERFACE_NAME", "LIBRARY_NAME", "CAPTION");
    private static final List<String> DIMENSIONS_COLUMN_NAMES = Arrays.asList("CATALOG_NAME", "SCHEMA_NAME", "CUBE_NAME", "DIMENSION_NAME", "DIMENSION_UNIQUE_NAME", "DIMENSION_GUID", "DIMENSION_CAPTION", "DIMENSION_ORDINAL", "DIMENSION_TYPE", "DIMENSION_CARDINALITY", "DEFAULT_HIERARCHY", "DESCRIPTION", "IS_VIRTUAL", "IS_READWRITE", "DIMENSION_UNIQUE_SETTINGS", "DIMENSION_MASTER_UNIQUE_NAME", "DIMENSION_IS_VISIBLE");
    private static final List<String> DATABASE_PROPERTIES_COLUMN_NAMES = Arrays.asList("PROPERTY_NAME", "PROPERTY_DESCRIPTION", "PROPERTY_TYPE", "PROPERTY_ACCESS_TYPE", "IS_REQUIRED", "PROPERTY_VALUE");
    private static final List<String> DATASOURCES_COLUMN_NAMES = Arrays.asList("DATA_SOURCE_NAME", "DATA_SOURCE_DESCRIPTION", "URL", "DATA_SOURCE_INFO", "PROVIDER_NAME", "PROVIDER_TYPE", "AUTHENTICATION_MODE");
    private static final List<String> CATALOGS_COLUMN_NAMES = Arrays.asList("TABLE_CAT");
    private static final List<String> SCHEMAS_COLUMN_NAMES = Arrays.asList("TABLE_SCHEM", "TABLE_CAT");
    private static final List<String> ACTIONS_COLUMN_NAMES = Arrays.asList("CATALOG_NAME", "SCHEMA_NAME", "CUBE_NAME", "ACTION_NAME", "COORDINATE", "COORDINATE_TYPE");

    public MetadataTest() throws SQLException {
        this.propertyNamePattern = null;
    }

    protected void setUp() throws SQLException {
        this.connection = this.tester.createConnection();
        this.catalogName = this.connection.getCatalog();
        this.olapConnection = this.tester.getWrapper().unwrap(this.connection, OlapConnection.class);
        this.olapDatabaseMetaData = this.olapConnection.getMetaData();
    }

    protected void tearDown() throws Exception {
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.close();
            this.connection = null;
        }
        this.connection = null;
        this.olapConnection = null;
        this.olapDatabaseMetaData = null;
        this.testContext = null;
        this.tester = null;
    }

    private void assertContains(String seek, String s) {
        if (s.indexOf(seek) < 0) {
            MetadataTest.fail((String)("expected to find '" + seek + "' in '" + s + "'"));
        }
    }

    private void assertContainsLine(String partial, String seek, String s) {
        int end;
        int start;
        int i;
        if (partial == null) {
            partial = seek;
        }
        if ((i = s.indexOf(partial)) < 0) {
            MetadataTest.fail((String)("expected to find '" + seek + "' in '" + s + "'"));
        }
        for (start = i; start > 0 && s.charAt(start - 1) != '\r' && s.charAt(start - 1) != '\n'; --start) {
        }
        for (end = i; end < s.length() && s.charAt(end) != '\r' && s.charAt(end) != '\n'; ++end) {
        }
        String line = s.substring(start, end);
        MetadataTest.assertEquals((String)seek, (String)line);
    }

    private void assertNotContains(String seek, String s) {
        if (s.indexOf(seek) >= 0) {
            MetadataTest.fail((String)("expected not to find '" + seek + "' in '" + s + "'"));
        }
    }

    private int linecount(String s) {
        int nl;
        int i = 0;
        int count = 0;
        while (i < s.length() && (nl = s.indexOf(10, i)) >= 0) {
            i = nl + 1;
            ++count;
        }
        return count;
    }

    public void testDatabaseMetaData() throws SQLException {
        MetadataTest.assertEquals((String)("" + this.catalogName + ""), (String)this.catalogName);
        DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        switch (this.tester.getFlavor()) {
            case XMLA: 
            case REMOTE_XMLA: {
                break;
            }
            default: {
                MetadataTest.assertTrue((databaseMetaData.getDatabaseMajorVersion() > 0 ? 1 : 0) != 0);
                MetadataTest.assertTrue((databaseMetaData.getDatabaseMinorVersion() >= 0 ? 1 : 0) != 0);
                MetadataTest.assertTrue((databaseMetaData.getDatabaseProductVersion() != null ? 1 : 0) != 0);
            }
        }
        MetadataTest.assertTrue((databaseMetaData.getDriverName() != null ? 1 : 0) != 0);
        MetadataTest.assertTrue((databaseMetaData.getDriverVersion() != null ? 1 : 0) != 0);
        switch (this.tester.getFlavor()) {
            case MONDRIAN: {
                MetadataTest.assertTrue((boolean)databaseMetaData.isReadOnly());
                MetadataTest.assertNull((Object)databaseMetaData.getUserName());
                MetadataTest.assertNotNull((Object)databaseMetaData.getURL());
            }
        }
        MetadataTest.assertTrue((boolean)((OlapWrapper)databaseMetaData).isWrapperFor(OlapDatabaseMetaData.class));
        MetadataTest.assertFalse((boolean)((OlapWrapper)databaseMetaData).isWrapperFor(OlapStatement.class));
        OlapDatabaseMetaData olapDatabaseMetaData1 = (OlapDatabaseMetaData)((OlapWrapper)databaseMetaData).unwrap(OlapDatabaseMetaData.class);
        MetadataTest.assertTrue((boolean)olapDatabaseMetaData1.getDriverName().equals(this.olapDatabaseMetaData.getDriverName()));
        switch (this.tester.getFlavor()) {
            case XMLA: 
            case REMOTE_XMLA: {
                break;
            }
            default: {
                MetadataTest.assertTrue((boolean)olapDatabaseMetaData1.getDatabaseProductVersion().equals(this.olapDatabaseMetaData.getDatabaseProductVersion()));
            }
        }
    }

    public void testSchemas() throws OlapException {
        Schema schema1 = this.olapConnection.getOlapSchema();
        MetadataTest.assertEquals((String)"Failed to auto detect the schema.", (String)schema1.getName(), (String)"FoodMart");
        switch (this.tester.getFlavor()) {
            case MONDRIAN: {
                this.olapConnection.setSchema("FoodMart");
                this.olapConnection.setSchema(null);
                this.olapConnection.setSchema("Chunky Bacon");
                break;
            }
            case XMLA: 
            case REMOTE_XMLA: {
                this.olapConnection.setSchema(this.catalogName);
                try {
                    this.olapConnection.setSchema(null);
                    MetadataTest.fail();
                }
                catch (OlapException e) {
                    // empty catch block
                }
                try {
                    this.olapConnection.setSchema("Chunky Bacon");
                    MetadataTest.fail();
                }
                catch (OlapException olapException) {}
                break;
            }
            default: {
                MetadataTest.fail((String)"Unknown tester flavor.");
            }
        }
    }

    public void testCatalogs() throws SQLException {
        Catalog catalog = this.olapConnection.getOlapCatalog();
        MetadataTest.assertEquals((String)"Failed to auto detect the catalog.", (String)catalog.getName(), (String)"FoodMart");
        switch (this.tester.getFlavor()) {
            case MONDRIAN: {
                this.olapConnection.setCatalog("FoodMart");
                this.olapConnection.setCatalog(null);
                this.olapConnection.setCatalog("Chunky Bacon");
                break;
            }
            case XMLA: 
            case REMOTE_XMLA: {
                this.olapConnection.setCatalog(this.catalogName);
                try {
                    this.olapConnection.setCatalog(null);
                    MetadataTest.fail();
                }
                catch (OlapException e) {
                    // empty catch block
                }
                try {
                    this.olapConnection.setCatalog("Chunky Bacon");
                    MetadataTest.fail();
                }
                catch (OlapException olapException) {}
                break;
            }
            default: {
                MetadataTest.fail((String)"Unknown tester flavor.");
            }
        }
    }

    public void testDatabases() throws SQLException {
        Database database = this.olapConnection.getOlapDatabase();
        MetadataTest.assertTrue((String)"Failed to auto detect the database.", (database.getName().equals("Provider=Mondrian;DataSource=MondrianFoodMart;") || database.getName().equals("FoodMart") ? 1 : 0) != 0);
        switch (this.tester.getFlavor()) {
            case MONDRIAN: {
                this.olapConnection.setDatabase("FoodMart");
                this.olapConnection.setDatabase(null);
                this.olapConnection.setDatabase("Chunky Bacon");
                break;
            }
            case XMLA: {
                this.olapConnection.setDatabase("FoodMart");
                try {
                    this.olapConnection.setDatabase(null);
                    MetadataTest.fail();
                }
                catch (OlapException e) {
                    // empty catch block
                }
                try {
                    this.olapConnection.setDatabase("Chunky Bacon");
                    MetadataTest.fail();
                }
                catch (OlapException e) {}
                break;
            }
            case REMOTE_XMLA: {
                this.olapConnection.setDatabase("Provider=Mondrian;DataSource=MondrianFoodMart;");
                try {
                    this.olapConnection.setDatabase(null);
                    MetadataTest.fail();
                }
                catch (OlapException e) {
                    // empty catch block
                }
                try {
                    this.olapConnection.setDatabase("Chunky Bacon");
                    MetadataTest.fail();
                }
                catch (OlapException olapException) {}
                break;
            }
            default: {
                MetadataTest.fail((String)"Unknown tester flavor.");
            }
        }
    }

    public void testDatabaseMetaDataGetActions() throws SQLException {
        String s = this.checkResultSet(this.olapDatabaseMetaData.getActions(this.catalogName, null, null, null), ACTIONS_COLUMN_NAMES);
        MetadataTest.assertEquals((String)"", (String)s);
    }

    public void testDatabaseMetaDataGetDatasources() throws SQLException {
        String s = this.checkResultSet(this.olapDatabaseMetaData.getDatabases(), DATASOURCES_COLUMN_NAMES);
        switch (this.tester.getFlavor()) {
            case MONDRIAN: {
                TestContext.assertEqualsVerbose("DATA_SOURCE_NAME=FoodMart, DATA_SOURCE_DESCRIPTION=null, URL=null, DATA_SOURCE_INFO=FoodMart, PROVIDER_NAME=Mondrian, PROVIDER_TYPE=MDP, AUTHENTICATION_MODE=Unauthenticated\n", s);
                break;
            }
            case REMOTE_XMLA: {
                break;
            }
            case XMLA: {
                TestContext.assertEqualsVerbose("DATA_SOURCE_NAME=FoodMart, DATA_SOURCE_DESCRIPTION=Mondrian FoodMart data source, URL=http://localhost:8080/mondrian/xmla, DATA_SOURCE_INFO=FoodMart, PROVIDER_NAME=Mondrian, PROVIDER_TYPE=MDP, AUTHENTICATION_MODE=Unauthenticated\n", s);
            }
        }
    }

    public void testDatabaseMetaDataGetCatalogs() throws SQLException {
        String expected;
        String s = this.checkResultSet(this.olapDatabaseMetaData.getCatalogs(), CATALOGS_COLUMN_NAMES);
        switch (this.tester.getFlavor()) {
            case XMLA: {
                expected = "TABLE_CAT=" + this.catalogName + "\n" + "TABLE_CAT=" + this.catalogName + "2\n";
                break;
            }
            default: {
                expected = "TABLE_CAT=" + this.catalogName + "\n";
            }
        }
        TestContext.assertEqualsVerbose(expected, s);
    }

    public void testDatabaseMetaDataGetSchemas() throws SQLException {
        String expected;
        String s = this.checkResultSet(this.olapDatabaseMetaData.getSchemas(), SCHEMAS_COLUMN_NAMES);
        switch (this.tester.getFlavor()) {
            case XMLA: {
                expected = "TABLE_SCHEM=FoodMart, TABLE_CAT=" + this.catalogName + "\n" + "TABLE_SCHEM=FoodMart, TABLE_CAT=" + this.catalogName + "2\n";
                break;
            }
            default: {
                expected = "TABLE_SCHEM=FoodMart, TABLE_CAT=" + this.catalogName + "\n";
            }
        }
        TestContext.assertEqualsVerbose(expected, s);
    }

    public void testDatabaseMetaDataGetLiterals() throws SQLException {
        String s = this.checkResultSet(this.olapDatabaseMetaData.getLiterals(), LITERALS_COLUMN_NAMES);
        this.assertContains("LITERAL_NAME=DBLITERAL_QUOTE, LITERAL_VALUE=[, ", s);
    }

    public void testDatabaseMetaDataGetDatabaseProperties() throws SQLException {
        String s = this.checkResultSet(this.olapDatabaseMetaData.getDatabaseProperties("xx", this.propertyNamePattern), DATABASE_PROPERTIES_COLUMN_NAMES);
        this.assertContains("PROPERTY_NAME=ProviderName, ", s);
    }

    public void testDatabaseMetaDataGetProperties() throws SQLException {
        String s = this.checkResultSet(this.olapDatabaseMetaData.getProperties(this.catalogName, null, null, null, null, null, null, null), PROPERTIES_COLUMN_NAMES);
        this.assertContains("CATALOG_NAME=" + this.catalogName + ", SCHEMA_NAME=FoodMart, CUBE_NAME=Warehouse and Sales, DIMENSION_UNIQUE_NAME=[Store], HIERARCHY_UNIQUE_NAME=[Store].[Store], LEVEL_UNIQUE_NAME=[Store].[Store].[Store Name], MEMBER_UNIQUE_NAME=null, PROPERTY_NAME=Frozen Sqft, PROPERTY_CAPTION=Frozen Sqft, PROPERTY_TYPE=1, DATA_TYPE=5, PROPERTY_CONTENT_TYPE=0, DESCRIPTION=Warehouse and Sales Cube - Store Hierarchy - Store Name Level - Frozen Sqft Property", s);
        MetadataTest.assertEquals((String)s, (int)66, (int)this.linecount(s));
        s = this.checkResultSet(this.olapDatabaseMetaData.getProperties(this.catalogName, "FoodMart", "Sales", null, null, "[Store].[Store].[Store Name]", null, null), PROPERTIES_COLUMN_NAMES);
        this.assertContains("CATALOG_NAME=" + this.catalogName + ", SCHEMA_NAME=FoodMart, CUBE_NAME=Sales, DIMENSION_UNIQUE_NAME=[Store], HIERARCHY_UNIQUE_NAME=[Store].[Store], LEVEL_UNIQUE_NAME=[Store].[Store].[Store Name], MEMBER_UNIQUE_NAME=null, PROPERTY_NAME=Has coffee bar, PROPERTY_CAPTION=Has coffee bar, PROPERTY_TYPE=1, DATA_TYPE=130, PROPERTY_CONTENT_TYPE=0, DESCRIPTION=Sales Cube - Store Hierarchy - Store Name Level - Has coffee bar Property", s);
        this.assertNotContains("CATALOG_NAME=" + this.catalogName + ", SCHEMA_NAME=FoodMart, CUBE_NAME=Warehouse and Sales, ", s);
        MetadataTest.assertEquals((int)8, (int)this.linecount(s));
    }

    public void testDatabaseMetaDataGetMdxKeywords() throws SQLException {
        String keywords = this.olapDatabaseMetaData.getMdxKeywords();
        MetadataTest.assertNotNull((Object)keywords);
        this.assertContains(",From,", keywords);
    }

    public void testDatabaseMetaDataGetCubes() throws SQLException {
        String s = this.checkResultSet(this.olapDatabaseMetaData.getCubes(this.catalogName, null, null), CUBE_COLUMN_NAMES);
        this.assertContains("CATALOG_NAME=" + this.catalogName + ", SCHEMA_NAME=FoodMart, CUBE_NAME=Sales, ", s);
        int lineCount = this.linecount(s);
        this.olapDatabaseMetaData.getConnection().setCatalog(this.catalogName);
        s = this.checkResultSet(this.olapDatabaseMetaData.getCubes(null, null, null), CUBE_COLUMN_NAMES);
        this.assertContains("CATALOG_NAME=" + this.catalogName + ", SCHEMA_NAME=FoodMart, CUBE_NAME=Sales, ", s);
        int lineCount3 = this.linecount(s);
        if (this.tester.getFlavor() == TestContext.Tester.Flavor.XMLA) {
            MetadataTest.assertEquals((int)(lineCount * 2), (int)lineCount3);
        }
        s = this.checkResultSet(this.olapDatabaseMetaData.getCubes("FoodMart", "FoodMart", "Sales"), CUBE_COLUMN_NAMES);
        switch (this.testContext.getTester().getFlavor()) {
            case MONDRIAN: {
                MetadataTest.assertTrue((boolean)s.contains(", IS_DRILLTHROUGH_ENABLED=true"));
                break;
            }
            case XMLA: 
            case REMOTE_XMLA: {
                MetadataTest.assertTrue((boolean)s.contains(", IS_DRILLTHROUGH_ENABLED=false"));
                MetadataTest.assertFalse((boolean)s.contains(", IS_DRILLTHROUGH_ENABLED=true"));
                break;
            }
            default: {
                throw new RuntimeException("Unknown tester type.");
            }
        }
        s = this.checkResultSet(this.olapDatabaseMetaData.getCubes(this.catalogName, null, "Warehouse and Sales"), CUBE_COLUMN_NAMES);
        this.assertContains(", CUBE_NAME=Warehouse and Sales,", s);
        this.assertNotContains(", CUBE_NAME=Warehouse,", s);
        s = this.checkResultSet(this.olapDatabaseMetaData.getCubes(this.catalogName, null, "Warehouse%"), CUBE_COLUMN_NAMES);
        MetadataTest.assertTrue((boolean)s.contains(", CUBE_NAME=Warehouse and Sales"));
        MetadataTest.assertTrue((boolean)s.contains(", CUBE_NAME=Warehouse"));
        MetadataTest.assertFalse((boolean)s.contains(", CUBE_NAME=Sales"));
    }

    public void testDatabaseMetaDataGetDimensions() throws SQLException {
        String s = this.checkResultSet(this.olapDatabaseMetaData.getDimensions(this.catalogName, null, null, null), DIMENSIONS_COLUMN_NAMES);
        this.assertContains("CATALOG_NAME=" + this.catalogName + ", SCHEMA_NAME=FoodMart, CUBE_NAME=Sales, DIMENSION_NAME=Education Level, DIMENSION_UNIQUE_NAME=[Education Level], DIMENSION_GUID=null, DIMENSION_CAPTION=Education Level, DIMENSION_ORDINAL=9, DIMENSION_TYPE=3, DIMENSION_CARDINALITY=6, DEFAULT_HIERARCHY=[Education Level], DESCRIPTION=Sales Cube - Education Level Dimension, IS_VIRTUAL=false, IS_READWRITE=false, DIMENSION_UNIQUE_SETTINGS=0, DIMENSION_MASTER_UNIQUE_NAME=null, DIMENSION_IS_VISIBLE=true", s);
        MetadataTest.assertEquals((int)68, (int)this.linecount(s));
    }

    public void testDatabaseMetaDataGetFunctions() throws SQLException {
        String s = this.checkResultSet(this.olapDatabaseMetaData.getOlapFunctions(null), FUNCTIONS_COLUMN_NAMES);
        this.assertContains("FUNCTION_NAME=Name, DESCRIPTION=Returns the name of a member., PARAMETER_LIST=Member, RETURN_TYPE=8, ORIGIN=1, INTERFACE_NAME=, LIBRARY_NAME=null, CAPTION=Name", s);
        int functionCount = this.linecount(s);
        MetadataTest.assertTrue((String)(functionCount + " functions"), (functionCount > 360 ? 1 : 0) != 0);
        s = this.checkResultSet(this.olapDatabaseMetaData.getOlapFunctions("%scendants"), FUNCTIONS_COLUMN_NAMES);
        MetadataTest.assertEquals((String)s, (int)13, (int)this.linecount(s));
    }

    public void testDatabaseMetaDataGetHierarchies() throws SQLException {
        String s = this.checkResultSet(this.olapDatabaseMetaData.getHierarchies(this.catalogName, null, null, null, null), HIERARCHIES_COLUMN_NAMES);
        this.assertContains("CATALOG_NAME=" + this.catalogName + ", SCHEMA_NAME=FoodMart, CUBE_NAME=HR, DIMENSION_UNIQUE_NAME=[Employees], HIERARCHY_NAME=Employees, HIERARCHY_UNIQUE_NAME=[Employees].[Employees], HIERARCHY_GUID=null, HIERARCHY_CAPTION=Employees, DIMENSION_TYPE=3, HIERARCHY_CARDINALITY=1156, DEFAULT_MEMBER=[Employees].[Employees].[All Employees], ALL_MEMBER=[Employees].[Employees].[All Employees], DESCRIPTION=HR Cube - Employees Hierarchy, STRUCTURE=0, IS_VIRTUAL=false, IS_READWRITE=false, DIMENSION_UNIQUE_SETTINGS=0, DIMENSION_IS_VISIBLE=true, HIERARCHY_IS_VISIBLE=true, HIERARCHY_ORDINAL=7, DIMENSION_IS_SHARED=true, PARENT_CHILD=true", s);
        s = this.checkResultSet(this.olapDatabaseMetaData.getHierarchies(this.catalogName, null, "Sales", null, "Store"), HIERARCHIES_COLUMN_NAMES);
        TestContext.assertEqualsVerbose("CATALOG_NAME=" + this.catalogName + ", SCHEMA_NAME=FoodMart, CUBE_NAME=Sales, DIMENSION_UNIQUE_NAME=[Store], HIERARCHY_NAME=Store, HIERARCHY_UNIQUE_NAME=[Store].[Store], HIERARCHY_GUID=null, HIERARCHY_CAPTION=Store, DIMENSION_TYPE=3, HIERARCHY_CARDINALITY=63, DEFAULT_MEMBER=[Store].[Store].[All Stores], ALL_MEMBER=[Store].[Store].[All Stores], DESCRIPTION=Sales Cube - Store Hierarchy, STRUCTURE=0, IS_VIRTUAL=false, IS_READWRITE=false, DIMENSION_UNIQUE_SETTINGS=0, DIMENSION_IS_VISIBLE=true, HIERARCHY_IS_VISIBLE=true, HIERARCHY_ORDINAL=1, DIMENSION_IS_SHARED=true, PARENT_CHILD=false\n", s);
        s = this.checkResultSet(this.olapDatabaseMetaData.getHierarchies(this.catalogName, null, "Sales", "[Store]", null), HIERARCHIES_COLUMN_NAMES);
        TestContext.assertEqualsVerbose("CATALOG_NAME=" + this.catalogName + ", SCHEMA_NAME=FoodMart, CUBE_NAME=Sales, DIMENSION_UNIQUE_NAME=[Store], HIERARCHY_NAME=Store, HIERARCHY_UNIQUE_NAME=[Store].[Store], HIERARCHY_GUID=null, HIERARCHY_CAPTION=Store, DIMENSION_TYPE=3, HIERARCHY_CARDINALITY=63, DEFAULT_MEMBER=[Store].[Store].[All Stores], ALL_MEMBER=[Store].[Store].[All Stores], DESCRIPTION=Sales Cube - Store Hierarchy, STRUCTURE=0, IS_VIRTUAL=false, IS_READWRITE=false, DIMENSION_UNIQUE_SETTINGS=0, DIMENSION_IS_VISIBLE=true, HIERARCHY_IS_VISIBLE=true, HIERARCHY_ORDINAL=1, DIMENSION_IS_SHARED=true, PARENT_CHILD=false\n", s);
    }

    public void testDatabaseMetaDataGetLevels() throws SQLException {
        String s = this.checkResultSet(this.olapDatabaseMetaData.getLevels(this.catalogName, null, null, null, null, null), LEVELS_COLUMN_NAMES);
        this.assertContains("CATALOG_NAME=FoodMart, SCHEMA_NAME=FoodMart, CUBE_NAME=Sales, DIMENSION_UNIQUE_NAME=[Measures], HIERARCHY_UNIQUE_NAME=[Measures], LEVEL_NAME=MeasuresLevel, LEVEL_UNIQUE_NAME=[Measures].[MeasuresLevel], LEVEL_GUID=null, LEVEL_CAPTION=MeasuresLevel, LEVEL_NUMBER=0, LEVEL_CARDINALITY=9, LEVEL_TYPE=0, CUSTOM_ROLLUP_SETTINGS=0, LEVEL_UNIQUE_SETTINGS=1, LEVEL_IS_VISIBLE=true, DESCRIPTION=Sales Cube - Measures Hierarchy - MeasuresLevel Level", s);
        s = this.checkResultSet(this.olapDatabaseMetaData.getLevels(this.catalogName, null, "Sales", null, "[Store].[Store]", null), LEVELS_COLUMN_NAMES);
        MetadataTest.assertEquals((String)s, (int)5, (int)this.linecount(s));
    }

    public void testDatabaseMetaDataGetLiterals2() throws SQLException {
        String s = this.checkResultSet(this.olapDatabaseMetaData.getLiterals(), LITERALS_COLUMN_NAMES);
        this.assertContains("LITERAL_NAME=DBLITERAL_QUOTE, LITERAL_VALUE=[, LITERAL_INVALID_CHARS=null, LITERAL_INVALID_STARTING_CHARS=null, LITERAL_MAX_LENGTH=-1", s);
        MetadataTest.assertEquals((int)17, (int)this.linecount(s));
    }

    public void testDatabaseMetaDataGetMeasures() throws SQLException {
        String s = this.checkResultSet(this.olapDatabaseMetaData.getMeasures(this.catalogName, null, null, null, null), MEASURES_COLUMN_NAMES);
        this.assertContains("CATALOG_NAME=" + this.catalogName + ", SCHEMA_NAME=FoodMart, CUBE_NAME=Sales, MEASURE_NAME=Profit, MEASURE_UNIQUE_NAME=[Measures].[Profit], MEASURE_CAPTION=Profit, MEASURE_GUID=null, MEASURE_AGGREGATOR=127, DATA_TYPE=130, MEASURE_IS_VISIBLE=true, LEVELS_LIST=null, DESCRIPTION=Sales Cube - Profit Member", s);
        s = this.checkResultSet(this.olapDatabaseMetaData.getMeasures(this.catalogName, null, "Sales", "%Sales", null), MEASURES_COLUMN_NAMES);
        MetadataTest.assertEquals((String)s, (int)3, (int)this.linecount(s));
        s = this.checkResultSet(this.olapDatabaseMetaData.getMeasures(this.catalogName, null, "Sales", null, "[Measures].[Unit Sales]"), MEASURES_COLUMN_NAMES);
        MetadataTest.assertEquals((String)s, (int)1, (int)this.linecount(s));
    }

    public void testDatabaseMetaDataGetMembers() throws SQLException {
    }

    public void testDatabaseMetaDataGetSets() throws SQLException {
        String s = this.checkResultSet(this.olapDatabaseMetaData.getSets(this.catalogName, null, null, null), SETS_COLUMN_NAMES);
        TestContext.assertEqualsVerbose("CATALOG_NAME=" + this.catalogName + ", SCHEMA_NAME=FoodMart, CUBE_NAME=Warehouse, SET_NAME=[Top Sellers], SCOPE=1\n", s);
        s = this.checkResultSet(this.olapDatabaseMetaData.getSets(this.catalogName, null, null, "non existent set"), SETS_COLUMN_NAMES);
        TestContext.assertEqualsVerbose("", s);
    }

    private String checkResultSet(ResultSet resultSet, List<String> columnNames) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int columnCount = resultSetMetaData.getColumnCount();
        ArrayList<String> rsColumnNames = new ArrayList<String>();
        if (columnNames != null) {
            for (int k = 0; k < columnCount; ++k) {
                rsColumnNames.add(resultSetMetaData.getColumnName(k + 1));
            }
            HashSet<String> set = new HashSet<String>(columnNames);
            set.removeAll(rsColumnNames);
            MetadataTest.assertTrue((String)("Expected columns not found: " + set), (boolean)set.isEmpty());
        }
        MetadataTest.assertNotNull((Object)resultSet);
        int k = 0;
        StringBuilder buf = new StringBuilder();
        while (resultSet.next()) {
            ++k;
            for (int i = 0; i < columnCount; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                String s = resultSet.getString(i + 1);
                buf.append(resultSetMetaData.getColumnName(i + 1)).append('=').append(s);
            }
            buf.append(NL);
        }
        MetadataTest.assertTrue((k >= 0 ? 1 : 0) != 0);
        MetadataTest.assertTrue((boolean)resultSet.isAfterLast());
        return buf.toString();
    }
}

