/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.dmn.engine.impl.cmd;

import org.activiti.dmn.engine.ActivitiDmnIllegalArgumentException;
import org.activiti.dmn.engine.ActivitiDmnObjectNotFoundException;
import org.activiti.dmn.engine.impl.interceptor.Command;
import org.activiti.dmn.engine.impl.interceptor.CommandContext;
import org.activiti.dmn.engine.impl.persistence.entity.DmnDeploymentEntity;

public class SetDeploymentCategoryCmd
implements Command<Void> {
    protected String deploymentId;
    protected String category;

    public SetDeploymentCategoryCmd(String deploymentId, String category) {
        this.deploymentId = deploymentId;
        this.category = category;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.deploymentId == null) {
            throw new ActivitiDmnIllegalArgumentException("Deployment id is null");
        }
        DmnDeploymentEntity deployment = (DmnDeploymentEntity)commandContext.getDeploymentEntityManager().findById(this.deploymentId);
        if (deployment == null) {
            throw new ActivitiDmnObjectNotFoundException("No deployment found for id = '" + this.deploymentId + "'");
        }
        deployment.setCategory(this.category);
        commandContext.getDeploymentEntityManager().update(deployment);
        return null;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }
}

