/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb.disk.journal;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.Adler32;
import org.apache.activemq.store.kahadb.disk.journal.CallerBufferingDataFileAppender;
import org.apache.activemq.store.kahadb.disk.journal.DataFile;
import org.apache.activemq.store.kahadb.disk.journal.DataFileAccessor;
import org.apache.activemq.store.kahadb.disk.journal.DataFileAccessorPool;
import org.apache.activemq.store.kahadb.disk.journal.DataFileAppender;
import org.apache.activemq.store.kahadb.disk.journal.FileAppender;
import org.apache.activemq.store.kahadb.disk.journal.Location;
import org.apache.activemq.store.kahadb.disk.journal.ReplicationTarget;
import org.apache.activemq.store.kahadb.disk.util.LinkedNode;
import org.apache.activemq.store.kahadb.disk.util.LinkedNodeList;
import org.apache.activemq.store.kahadb.disk.util.SchedulerTimerTask;
import org.apache.activemq.store.kahadb.disk.util.Sequence;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.DataByteArrayInputStream;
import org.apache.activemq.util.DataByteArrayOutputStream;
import org.apache.activemq.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Journal {
    public static final String CALLER_BUFFER_APPENDER = "org.apache.kahadb.journal.CALLER_BUFFER_APPENDER";
    public static final boolean callerBufferAppender = Boolean.parseBoolean(System.getProperty("org.apache.kahadb.journal.CALLER_BUFFER_APPENDER", "false"));
    private static final int MAX_BATCH_SIZE = 0x2000000;
    public static final int RECORD_HEAD_SPACE = 5;
    public static final byte USER_RECORD_TYPE = 1;
    public static final byte BATCH_CONTROL_RECORD_TYPE = 2;
    public static final byte[] BATCH_CONTROL_RECORD_MAGIC = Journal.bytes("WRITE BATCH");
    public static final int BATCH_CONTROL_RECORD_SIZE = 5 + BATCH_CONTROL_RECORD_MAGIC.length + 4 + 8;
    public static final byte[] BATCH_CONTROL_RECORD_HEADER = Journal.createBatchControlRecordHeader();
    public static final String DEFAULT_DIRECTORY = ".";
    public static final String DEFAULT_ARCHIVE_DIRECTORY = "data-archive";
    public static final String DEFAULT_FILE_PREFIX = "db-";
    public static final String DEFAULT_FILE_SUFFIX = ".log";
    public static final int DEFAULT_MAX_FILE_LENGTH = 0x2000000;
    public static final int DEFAULT_CLEANUP_INTERVAL = 30000;
    public static final int PREFERED_DIFF = 524288;
    public static final int DEFAULT_MAX_WRITE_BATCH_SIZE = 0x400000;
    private static final Logger LOG = LoggerFactory.getLogger(Journal.class);
    protected final Map<WriteKey, WriteCommand> inflightWrites = new ConcurrentHashMap<WriteKey, WriteCommand>();
    protected File directory = new File(".");
    protected File directoryArchive;
    private boolean directoryArchiveOverridden = false;
    protected String filePrefix = "db-";
    protected String fileSuffix = ".log";
    protected boolean started;
    protected int maxFileLength = 0x2000000;
    protected int preferedFileLength = 33030144;
    protected int writeBatchSize = 0x400000;
    protected FileAppender appender;
    protected DataFileAccessorPool accessorPool;
    protected Map<Integer, DataFile> fileMap = new HashMap<Integer, DataFile>();
    protected Map<File, DataFile> fileByFileMap = new LinkedHashMap<File, DataFile>();
    protected LinkedNodeList<DataFile> dataFiles = new LinkedNodeList();
    protected final AtomicReference<Location> lastAppendLocation = new AtomicReference();
    protected Runnable cleanupTask;
    protected AtomicLong totalLength = new AtomicLong();
    protected boolean archiveDataLogs;
    private ReplicationTarget replicationTarget;
    protected boolean checksum;
    protected boolean checkForCorruptionOnStartup;
    protected boolean enableAsyncDiskSync = true;
    private Timer timer;
    private DataFileRemovedListener dataFileRemovedListener;

    private static byte[] createBatchControlRecordHeader() {
        try {
            DataByteArrayOutputStream os = new DataByteArrayOutputStream();
            os.writeInt(BATCH_CONTROL_RECORD_SIZE);
            os.writeByte(2);
            os.write(BATCH_CONTROL_RECORD_MAGIC);
            ByteSequence sequence = os.toByteSequence();
            sequence.compact();
            return sequence.getData();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create batch control record header.", e);
        }
    }

    public synchronized void start() throws IOException {
        if (this.started) {
            return;
        }
        long start2 = System.currentTimeMillis();
        this.accessorPool = new DataFileAccessorPool(this);
        this.started = true;
        this.preferedFileLength = Math.max(524288, this.getMaxFileLength() - 524288);
        this.appender = callerBufferAppender ? new CallerBufferingDataFileAppender(this) : new DataFileAppender(this);
        File[] files = this.directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String n) {
                return dir.equals(Journal.this.directory) && n.startsWith(Journal.this.filePrefix) && n.endsWith(Journal.this.fileSuffix);
            }
        });
        if (files != null) {
            for (File file : files) {
                try {
                    String n = file.getName();
                    String numStr = n.substring(this.filePrefix.length(), n.length() - this.fileSuffix.length());
                    int num = Integer.parseInt(numStr);
                    DataFile dataFile = new DataFile(file, num, this.preferedFileLength);
                    this.fileMap.put(dataFile.getDataFileId(), dataFile);
                    this.totalLength.addAndGet(dataFile.getLength());
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            ArrayList<DataFile> l = new ArrayList<DataFile>(this.fileMap.values());
            Collections.sort(l);
            for (DataFile df : l) {
                if (df.getLength() == 0) {
                    LOG.info("ignoring zero length, partially initialised journal data file: " + df);
                    continue;
                }
                this.dataFiles.addLast(df);
                this.fileByFileMap.put(df.getFile(), df);
                if (!this.isCheckForCorruptionOnStartup()) continue;
                this.lastAppendLocation.set(this.recoveryCheck(df));
            }
        }
        this.getCurrentWriteFile();
        if (this.lastAppendLocation.get() == null) {
            DataFile df = this.dataFiles.getTail();
            this.lastAppendLocation.set(this.recoveryCheck(df));
        }
        this.cleanupTask = new Runnable(){

            @Override
            public void run() {
                Journal.this.cleanup();
            }
        };
        this.timer = new Timer("KahaDB Scheduler", true);
        SchedulerTimerTask task = new SchedulerTimerTask(this.cleanupTask);
        this.timer.scheduleAtFixedRate((TimerTask)task, 30000L, 30000L);
        long end = System.currentTimeMillis();
        LOG.trace("Startup took: " + (end - start2) + " ms");
    }

    private static byte[] bytes(String string) {
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Location recoveryCheck(DataFile dataFile) throws IOException {
        Location location = new Location();
        location.setDataFileId(dataFile.getDataFileId());
        location.setOffset(0);
        DataFileAccessor reader = this.accessorPool.openDataFileAccessor(dataFile);
        try {
            while (true) {
                int size2;
                if ((size2 = this.checkBatchRecord(reader, location.getOffset())) >= 0) {
                    location.setOffset(location.getOffset() + BATCH_CONTROL_RECORD_SIZE + size2);
                    continue;
                }
                int nextOffset = this.findNextBatchRecord(reader, location.getOffset() + 1);
                if (nextOffset >= 0) {
                    Sequence sequence = new Sequence(location.getOffset(), nextOffset - 1);
                    LOG.info("Corrupt journal records found in '" + dataFile.getFile() + "' between offsets: " + sequence);
                    dataFile.corruptedBlocks.add(sequence);
                    location.setOffset(nextOffset);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
        }
        finally {
            this.accessorPool.closeDataFileAccessor(reader);
        }
        int existingLen = dataFile.getLength();
        dataFile.setLength(location.getOffset());
        if (existingLen > dataFile.getLength()) {
            this.totalLength.addAndGet(dataFile.getLength() - existingLen);
        }
        if (!dataFile.corruptedBlocks.isEmpty() && ((Sequence)dataFile.corruptedBlocks.getTail()).getLast() + 1L == (long)location.getOffset()) {
            dataFile.setLength((int)dataFile.corruptedBlocks.removeLastSequence().getFirst());
        }
        return location;
    }

    private int findNextBatchRecord(DataFileAccessor reader, int offset) throws IOException {
        ByteSequence header = new ByteSequence(BATCH_CONTROL_RECORD_HEADER);
        byte[] data = new byte[4096];
        ByteSequence bs = new ByteSequence(data, 0, reader.read(offset, data));
        int pos = 0;
        while ((pos = bs.indexOf(header, pos)) < 0) {
            if (bs.length != data.length) {
                return -1;
            }
            bs = new ByteSequence(data, 0, reader.read(offset += bs.length - BATCH_CONTROL_RECORD_HEADER.length, data));
            pos = 0;
        }
        return offset + pos;
    }

    public int checkBatchRecord(DataFileAccessor reader, int offset) throws IOException {
        byte[] controlRecord = new byte[BATCH_CONTROL_RECORD_SIZE];
        DataByteArrayInputStream controlIs = new DataByteArrayInputStream(controlRecord);
        reader.readFully(offset, controlRecord);
        for (int i = 0; i < BATCH_CONTROL_RECORD_HEADER.length; ++i) {
            if (controlIs.readByte() == BATCH_CONTROL_RECORD_HEADER[i]) continue;
            return -1;
        }
        int size2 = controlIs.readInt();
        if (size2 > 0x2000000) {
            return -1;
        }
        if (this.isChecksum()) {
            long expectedChecksum = controlIs.readLong();
            if (expectedChecksum == 0L) {
                return size2;
            }
            byte[] data = new byte[size2];
            reader.readFully(offset + BATCH_CONTROL_RECORD_SIZE, data);
            Adler32 checksum = new Adler32();
            checksum.update(data, 0, data.length);
            if (expectedChecksum != checksum.getValue()) {
                return -1;
            }
        }
        return size2;
    }

    void addToTotalLength(int size2) {
        this.totalLength.addAndGet(size2);
    }

    public long length() {
        return this.totalLength.get();
    }

    synchronized DataFile getCurrentWriteFile() throws IOException {
        if (this.dataFiles.isEmpty()) {
            this.rotateWriteFile();
        }
        return this.dataFiles.getTail();
    }

    synchronized DataFile rotateWriteFile() {
        int nextNum = !this.dataFiles.isEmpty() ? this.dataFiles.getTail().getDataFileId() + 1 : 1;
        File file = this.getFile(nextNum);
        DataFile nextWriteFile = new DataFile(file, nextNum, this.preferedFileLength);
        this.fileMap.put(nextWriteFile.getDataFileId(), nextWriteFile);
        this.fileByFileMap.put(file, nextWriteFile);
        this.dataFiles.addLast(nextWriteFile);
        return nextWriteFile;
    }

    public File getFile(int nextNum) {
        String fileName = this.filePrefix + nextNum + this.fileSuffix;
        File file = new File(this.directory, fileName);
        return file;
    }

    synchronized DataFile getDataFile(Location item) throws IOException {
        Integer key = item.getDataFileId();
        DataFile dataFile = this.fileMap.get(key);
        if (dataFile == null) {
            LOG.error("Looking for key " + key + " but not found in fileMap: " + this.fileMap);
            throw new IOException("Could not locate data file " + this.getFile(item.getDataFileId()));
        }
        return dataFile;
    }

    synchronized File getFile(Location item) throws IOException {
        Integer key = item.getDataFileId();
        DataFile dataFile = this.fileMap.get(key);
        if (dataFile == null) {
            LOG.error("Looking for key " + key + " but not found in fileMap: " + this.fileMap);
            throw new IOException("Could not locate data file " + this.getFile(item.getDataFileId()));
        }
        return dataFile.getFile();
    }

    private DataFile getNextDataFile(DataFile dataFile) {
        return (DataFile)dataFile.getNext();
    }

    public synchronized void close() throws IOException {
        if (!this.started) {
            return;
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.accessorPool.close();
        this.appender.close();
        this.fileMap.clear();
        this.fileByFileMap.clear();
        this.dataFiles.clear();
        this.lastAppendLocation.set(null);
        this.started = false;
    }

    protected synchronized void cleanup() {
        if (this.accessorPool != null) {
            this.accessorPool.disposeUnused();
        }
    }

    public synchronized boolean delete() throws IOException {
        this.appender.close();
        this.accessorPool.close();
        boolean result = true;
        for (DataFile dataFile : this.fileMap.values()) {
            this.totalLength.addAndGet(-dataFile.getLength());
            result &= dataFile.delete();
        }
        this.fileMap.clear();
        this.fileByFileMap.clear();
        this.lastAppendLocation.set(null);
        this.dataFiles = new LinkedNodeList();
        this.accessorPool = new DataFileAccessorPool(this);
        this.appender = new DataFileAppender(this);
        return result;
    }

    public synchronized void removeDataFiles(Set<Integer> files) throws IOException {
        for (Integer key : files) {
            DataFile dataFile;
            if (key >= this.lastAppendLocation.get().getDataFileId() || (dataFile = this.fileMap.get(key)) == null) continue;
            this.forceRemoveDataFile(dataFile);
        }
    }

    private synchronized void forceRemoveDataFile(DataFile dataFile) throws IOException {
        this.accessorPool.disposeDataFileAccessors(dataFile);
        this.fileByFileMap.remove(dataFile.getFile());
        this.fileMap.remove(dataFile.getDataFileId());
        this.totalLength.addAndGet(-dataFile.getLength());
        dataFile.unlink();
        if (this.archiveDataLogs) {
            File directoryArchive = this.getDirectoryArchive();
            if (directoryArchive.exists()) {
                LOG.debug("Archive directory exists: {}", (Object)directoryArchive);
            } else {
                if (directoryArchive.isAbsolute() && LOG.isDebugEnabled()) {
                    LOG.debug("Archive directory [{}] does not exist - creating it now", (Object)directoryArchive.getAbsolutePath());
                }
                IOHelper.mkdirs(directoryArchive);
            }
            LOG.debug("Moving data file {} to {} ", (Object)dataFile, (Object)directoryArchive.getCanonicalPath());
            dataFile.move(directoryArchive);
            LOG.debug("Successfully moved data file");
        } else {
            LOG.debug("Deleting data file: {}", (Object)dataFile);
            if (dataFile.delete()) {
                LOG.debug("Discarded data file: {}", (Object)dataFile);
            } else {
                LOG.warn("Failed to discard data file : {}", (Object)dataFile.getFile());
            }
        }
        if (this.dataFileRemovedListener != null) {
            this.dataFileRemovedListener.fileRemoved(dataFile);
        }
    }

    public int getMaxFileLength() {
        return this.maxFileLength;
    }

    public void setMaxFileLength(int maxFileLength) {
        this.maxFileLength = maxFileLength;
    }

    public String toString() {
        return this.directory.toString();
    }

    public synchronized void appendedExternally(Location loc, int length) throws IOException {
        DataFile dataFile = null;
        if (this.dataFiles.getTail().getDataFileId().intValue() == loc.getDataFileId()) {
            dataFile = this.dataFiles.getTail();
            dataFile.incrementLength(length);
        } else if (this.dataFiles.getTail().getDataFileId() + 1 == loc.getDataFileId()) {
            int nextNum = loc.getDataFileId();
            File file = this.getFile(nextNum);
            dataFile = new DataFile(file, nextNum, this.preferedFileLength);
            this.fileMap.put(dataFile.getDataFileId(), dataFile);
            this.fileByFileMap.put(file, dataFile);
            this.dataFiles.addLast(dataFile);
        } else {
            throw new IOException("Invalid external append.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Location getNextLocation(Location location) throws IOException, IllegalStateException {
        Location cur = null;
        do {
            if (cur == null) {
                if (location == null) {
                    DataFile head = this.dataFiles.getHead();
                    if (head == null) {
                        return null;
                    }
                    cur = new Location();
                    cur.setDataFileId(head.getDataFileId());
                    cur.setOffset(0);
                } else if (location.getSize() == -1) {
                    cur = new Location(location);
                } else {
                    cur = new Location(location);
                    cur.setOffset(location.getOffset() + location.getSize());
                }
            } else {
                cur.setOffset(cur.getOffset() + cur.getSize());
            }
            DataFile dataFile = this.getDataFile(cur);
            if (dataFile.getLength() <= cur.getOffset()) {
                if ((dataFile = this.getNextDataFile(dataFile)) == null) {
                    return null;
                }
                cur.setDataFileId(dataFile.getDataFileId());
                cur.setOffset(0);
            }
            DataFileAccessor reader = this.accessorPool.openDataFileAccessor(dataFile);
            try {
                reader.readLocationDetails(cur);
            }
            finally {
                this.accessorPool.closeDataFileAccessor(reader);
            }
            if (cur.getType() != 0) continue;
            return null;
        } while (cur.getType() != 1);
        return cur;
    }

    public synchronized Location getNextLocation(File file, Location lastLocation, boolean thisFileOnly) throws IllegalStateException, IOException {
        DataFile df = this.fileByFileMap.get(file);
        return this.getNextLocation(df, lastLocation, thisFileOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Location getNextLocation(DataFile dataFile, Location lastLocation, boolean thisFileOnly) throws IOException, IllegalStateException {
        Location cur = null;
        do {
            if (cur == null) {
                if (lastLocation == null) {
                    DataFile head = (DataFile)dataFile.getHeadNode();
                    cur = new Location();
                    cur.setDataFileId(head.getDataFileId());
                    cur.setOffset(0);
                } else {
                    cur = new Location(lastLocation);
                    cur.setOffset(cur.getOffset() + cur.getSize());
                }
            } else {
                cur.setOffset(cur.getOffset() + cur.getSize());
            }
            if (dataFile.getLength() <= cur.getOffset()) {
                if (thisFileOnly) {
                    return null;
                }
                if ((dataFile = this.getNextDataFile(dataFile)) == null) {
                    return null;
                }
                cur.setDataFileId(dataFile.getDataFileId());
                cur.setOffset(0);
            }
            DataFileAccessor reader = this.accessorPool.openDataFileAccessor(dataFile);
            try {
                reader.readLocationDetails(cur);
            }
            finally {
                this.accessorPool.closeDataFileAccessor(reader);
            }
            if (cur.getType() != 0) continue;
            return null;
        } while (cur.getType() <= 0);
        return cur;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ByteSequence read(Location location) throws IOException, IllegalStateException {
        DataFile dataFile = this.getDataFile(location);
        DataFileAccessor reader = this.accessorPool.openDataFileAccessor(dataFile);
        ByteSequence rc = null;
        try {
            rc = reader.readRecord(location);
        }
        finally {
            this.accessorPool.closeDataFileAccessor(reader);
        }
        return rc;
    }

    public Location write(ByteSequence data, boolean sync) throws IOException, IllegalStateException {
        Location loc = this.appender.storeItem(data, (byte)1, sync);
        return loc;
    }

    public Location write(ByteSequence data, Runnable onComplete) throws IOException, IllegalStateException {
        Location loc = this.appender.storeItem(data, (byte)1, onComplete);
        return loc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Location location, ByteSequence data, boolean sync) throws IOException {
        DataFile dataFile = this.getDataFile(location);
        DataFileAccessor updater = this.accessorPool.openDataFileAccessor(dataFile);
        try {
            updater.updateRecord(location, data, sync);
        }
        finally {
            this.accessorPool.closeDataFileAccessor(updater);
        }
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public String getFilePrefix() {
        return this.filePrefix;
    }

    public void setFilePrefix(String filePrefix) {
        this.filePrefix = filePrefix;
    }

    public Map<WriteKey, WriteCommand> getInflightWrites() {
        return this.inflightWrites;
    }

    public Location getLastAppendLocation() {
        return this.lastAppendLocation.get();
    }

    public void setLastAppendLocation(Location lastSyncedLocation) {
        this.lastAppendLocation.set(lastSyncedLocation);
    }

    public File getDirectoryArchive() {
        if (!this.directoryArchiveOverridden && this.directoryArchive == null) {
            this.directoryArchive = new File(this.directory.getAbsolutePath() + File.separator + DEFAULT_ARCHIVE_DIRECTORY);
        }
        return this.directoryArchive;
    }

    public void setDirectoryArchive(File directoryArchive) {
        this.directoryArchiveOverridden = true;
        this.directoryArchive = directoryArchive;
    }

    public boolean isArchiveDataLogs() {
        return this.archiveDataLogs;
    }

    public void setArchiveDataLogs(boolean archiveDataLogs) {
        this.archiveDataLogs = archiveDataLogs;
    }

    public synchronized Integer getCurrentDataFileId() {
        if (this.dataFiles.isEmpty()) {
            return null;
        }
        return this.dataFiles.getTail().getDataFileId();
    }

    public Set<File> getFiles() {
        return this.fileByFileMap.keySet();
    }

    public synchronized Map<Integer, DataFile> getFileMap() {
        return new TreeMap<Integer, DataFile>(this.fileMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDiskSize() {
        long tailLength = 0L;
        Journal journal = this;
        synchronized (journal) {
            if (!this.dataFiles.isEmpty()) {
                tailLength = this.dataFiles.getTail().getLength();
            }
        }
        long rc = this.totalLength.get();
        if (tailLength < (long)this.preferedFileLength) {
            rc -= tailLength;
            rc += (long)this.preferedFileLength;
        }
        return rc;
    }

    public void setReplicationTarget(ReplicationTarget replicationTarget) {
        this.replicationTarget = replicationTarget;
    }

    public ReplicationTarget getReplicationTarget() {
        return this.replicationTarget;
    }

    public String getFileSuffix() {
        return this.fileSuffix;
    }

    public void setFileSuffix(String fileSuffix) {
        this.fileSuffix = fileSuffix;
    }

    public boolean isChecksum() {
        return this.checksum;
    }

    public void setChecksum(boolean checksumWrites) {
        this.checksum = checksumWrites;
    }

    public boolean isCheckForCorruptionOnStartup() {
        return this.checkForCorruptionOnStartup;
    }

    public void setCheckForCorruptionOnStartup(boolean checkForCorruptionOnStartup) {
        this.checkForCorruptionOnStartup = checkForCorruptionOnStartup;
    }

    public void setWriteBatchSize(int writeBatchSize) {
        this.writeBatchSize = writeBatchSize;
    }

    public int getWriteBatchSize() {
        return this.writeBatchSize;
    }

    public void setSizeAccumulator(AtomicLong storeSizeAccumulator) {
        this.totalLength = storeSizeAccumulator;
    }

    public void setEnableAsyncDiskSync(boolean val) {
        this.enableAsyncDiskSync = val;
    }

    public boolean isEnableAsyncDiskSync() {
        return this.enableAsyncDiskSync;
    }

    public void setDataFileRemovedListener(DataFileRemovedListener dataFileRemovedListener) {
        this.dataFileRemovedListener = dataFileRemovedListener;
    }

    public static class WriteKey {
        private final int file;
        private final long offset;
        private final int hash;

        public WriteKey(Location item) {
            this.file = item.getDataFileId();
            this.offset = item.getOffset();
            this.hash = (int)((long)this.file ^ this.offset);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj instanceof WriteKey) {
                WriteKey di = (WriteKey)obj;
                return di.file == this.file && di.offset == this.offset;
            }
            return false;
        }
    }

    public static class WriteCommand
    extends LinkedNode<WriteCommand> {
        public final Location location;
        public final ByteSequence data;
        final boolean sync;
        public final Runnable onComplete;

        public WriteCommand(Location location, ByteSequence data, boolean sync) {
            this.location = location;
            this.data = data;
            this.sync = sync;
            this.onComplete = null;
        }

        public WriteCommand(Location location, ByteSequence data, Runnable onComplete) {
            this.location = location;
            this.data = data;
            this.onComplete = onComplete;
            this.sync = false;
        }
    }

    public static interface DataFileRemovedListener {
        public void fileRemoved(DataFile var1);
    }
}

