/*
 Copyright 2016 Google Inc. All Rights Reserved.
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
*/

this.workbox = this.workbox || {};
(function (exports) {
'use strict';

class ErrorFactory$1{constructor(a){this._errors=a;}createError(a,b){if(!(a in this._errors))throw new Error(`Unable to generate error '${a}'.`);let c=this._errors[a].replace(/\s+/g,' '),d=null;b&&(c+=` [${b.message}]`,d=b.stack);const e=new Error;return e.name=a,e.message=c,e.stack=d,e}}

const errors={"express-route-invalid-path":`When using ExpressRoute, you must
    provide a path that starts with a '/' character (to match same-origin
    requests) or that starts with 'http' (to match cross-origin requests)`};var ErrorFactory = new ErrorFactory$1(errors);

var commonjsGlobal = typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};





function createCommonjsModule(fn, module) {
	return module = { exports: {} }, fn(module, module.exports), module.exports;
}

var stackframe=createCommonjsModule(function(a){(function(c,d){'use strict';a.exports=d();})(commonjsGlobal,function(){'use strict';function c(t){return!isNaN(parseFloat(t))&&isFinite(t)}function d(t){return t[0].toUpperCase()+t.substring(1)}function e(t){return function(){return this[t]}}function f(t){if(t instanceof Object)for(var u=0;u<o.length;u++)t.hasOwnProperty(o[u])&&void 0!==t[o[u]]&&this['set'+d(o[u])](t[o[u]]);}var g=['isConstructor','isEval','isNative','isToplevel'],h=['columnNumber','lineNumber'],l=['fileName','functionName','source'],o=g.concat(h,l,['args']);f.prototype={getArgs:function(){return this.args},setArgs:function(t){if('[object Array]'!==Object.prototype.toString.call(t))throw new TypeError('Args must be an Array');this.args=t;},getEvalOrigin:function(){return this.evalOrigin},setEvalOrigin:function(t){if(t instanceof f)this.evalOrigin=t;else if(t instanceof Object)this.evalOrigin=new f(t);else throw new TypeError('Eval Origin must be an Object or StackFrame')},toString:function(){var t=this.getFunctionName()||'{anonymous}',u='('+(this.getArgs()||[]).join(',')+')',w=this.getFileName()?'@'+this.getFileName():'',x=c(this.getLineNumber())?':'+this.getLineNumber():'',y=c(this.getColumnNumber())?':'+this.getColumnNumber():'';return t+u+w+x+y}};for(var q=0;q<g.length;q++)f.prototype['get'+d(g[q])]=e(g[q]),f.prototype['set'+d(g[q])]=function(t){return function(u){this[t]=!!u;}}(g[q]);for(var r=0;r<h.length;r++)f.prototype['get'+d(h[r])]=e(h[r]),f.prototype['set'+d(h[r])]=function(t){return function(u){if(!c(u))throw new TypeError(t+' must be a Number');this[t]=+u;}}(h[r]);for(var s=0;s<l.length;s++)f.prototype['get'+d(l[s])]=e(l[s]),f.prototype['set'+d(l[s])]=function(t){return function(u){this[t]=u+'';}}(l[s]);return f});});

var errorStackParser=createCommonjsModule(function(a){(function(c,d){'use strict';a.exports=d(stackframe);})(commonjsGlobal,function(d){'use strict';var f=/(^|@)\S+\:\d+/,g=/^\s*at .*(\S+\:\d+|\(native\))/m,h=/^(eval@)?(\[native code\])?$/;return{parse:function(k){if('undefined'!=typeof k.stacktrace||'undefined'!=typeof k['opera#sourceloc'])return this.parseOpera(k);if(k.stack&&k.stack.match(g))return this.parseV8OrIE(k);if(k.stack)return this.parseFFOrSafari(k);throw new Error('Cannot parse given Error object')},extractLocation:function(k){if(-1===k.indexOf(':'))return[k];var l=/(.+?)(?:\:(\d+))?(?:\:(\d+))?$/,m=l.exec(k.replace(/[\(\)]/g,''));return[m[1],m[2]||void 0,m[3]||void 0]},parseV8OrIE:function(k){var l=k.stack.split('\n').filter(function(m){return!!m.match(g)},this);return l.map(function(m){-1<m.indexOf('(eval ')&&(m=m.replace(/eval code/g,'eval').replace(/(\(eval at [^\()]*)|(\)\,.*$)/g,''));var n=m.replace(/^\s+/,'').replace(/\(eval code/g,'(').split(/\s+/).slice(1),o=this.extractLocation(n.pop()),p=n.join(' ')||void 0,q=-1<['eval','<anonymous>'].indexOf(o[0])?void 0:o[0];return new d({functionName:p,fileName:q,lineNumber:o[1],columnNumber:o[2],source:m})},this)},parseFFOrSafari:function(k){var l=k.stack.split('\n').filter(function(m){return!m.match(h)},this);return l.map(function(m){if(-1<m.indexOf(' > eval')&&(m=m.replace(/ line (\d+)(?: > eval line \d+)* > eval\:\d+\:\d+/g,':$1')),-1===m.indexOf('@')&&-1===m.indexOf(':'))return new d({functionName:m});var n=m.split('@'),o=this.extractLocation(n.pop()),p=n.join('@')||void 0;return new d({functionName:p,fileName:o[0],lineNumber:o[1],columnNumber:o[2],source:m})},this)},parseOpera:function(k){return!k.stacktrace||-1<k.message.indexOf('\n')&&k.message.split('\n').length>k.stacktrace.split('\n').length?this.parseOpera9(k):k.stack?this.parseOpera11(k):this.parseOpera10(k)},parseOpera9:function(k){for(var q,l=/Line (\d+).*script (?:in )?(\S+)/i,m=k.message.split('\n'),n=[],o=2,p=m.length;o<p;o+=2)q=l.exec(m[o]),q&&n.push(new d({fileName:q[2],lineNumber:q[1],source:m[o]}));return n},parseOpera10:function(k){for(var q,l=/Line (\d+).*script (?:in )?(\S+)(?:: In function (\S+))?$/i,m=k.stacktrace.split('\n'),n=[],o=0,p=m.length;o<p;o+=2)q=l.exec(m[o]),q&&n.push(new d({functionName:q[3]||void 0,fileName:q[2],lineNumber:q[1],source:m[o]}));return n},parseOpera11:function(k){var l=k.stack.split('\n').filter(function(m){return!!m.match(f)&&!m.match(/^Error created at/)},this);return l.map(function(m){var n=m.split('@'),o=this.extractLocation(n.pop()),p=n.shift()||'',q=p.replace(/<anonymous function(: (\w+))?>/,'$2').replace(/\([^\)]*\)/g,'')||void 0,r;p.match(/\(([^\)]*)\)/)&&(r=p.replace(/^[^\(]+\(([^\)]*)\)$/,'$1'));var s=r===void 0||'[arguments not available]'===r?void 0:r.split(',');return new d({functionName:q,args:s,fileName:o[0],lineNumber:o[1],columnNumber:o[2],source:m})},this)}}});});

function hasMethod(a,b){const c=Object.keys(a).pop(),d=typeof a[c][b];'function'!=d&&throwError(`The '${c}' parameter must be an object that exposes a
      '${b}' method.`);}function isInstance(a,b){const c=Object.keys(a).pop();a[c]instanceof b||throwError(`The '${c}' parameter must be an instance of
      '${b.name}'`);}function isOneOf(a,b){const c=Object.keys(a).pop();b.includes(a[c])||throwError(`The '${c}' parameter must be set to one of the
      following: ${b}`);}function isType(a,b){const c=Object.keys(a).pop(),d=typeof a[c];d!==b&&throwError(`The '${c}' parameter has the wrong type. (Expected:
      ${b}, actual: ${d})`);}function isArrayOfClass(a,b){const c=Object.keys(a).pop(),d=`The '${c}' parameter should be an array containing
    one or more '${b.name}' instances.`;Array.isArray(a[c])||throwError(d);for(let e of a[c])e instanceof b||throwError(d);}function throwError(a){a=a.replace(/\s+/g,' ');const b=new Error(a);b.name='assertion-failed';const c=errorStackParser.parse(b);throw 3<=c.length&&(b.message=`Invalid call to ${c[2].functionName}() — `+a),b}

function normalizeHandler(a){return'object'==typeof a?(hasMethod({handler:a},'handle'),a):(isType({handler:a},'function'),{handle:a})}

const defaultMethod='GET';const validMethods=['DELETE','GET','HEAD','POST','PUT'];

class Route{constructor({match:a,handler:b,method:c}={}){this.handler=normalizeHandler(b),isType({match:a},'function'),this.match=a,c?(isOneOf({method:c},validMethods),this.method=c):this.method=defaultMethod;}}

var index$1=Array.isArray||function(a){return'[object Array]'==Object.prototype.toString.call(a)};

var index=pathToRegexp; var parse_1=parse; var compile_1=compile; var tokensToFunction_1=tokensToFunction; var tokensToRegExp_1=tokensToRegExp; var PATH_REGEXP=new RegExp(['(\\\\.)','([\\/.])?(?:(?:\\:(\\w+)(?:\\(((?:\\\\.|[^\\\\()])+)\\))?|\\(((?:\\\\.|[^\\\\()])+)\\))([+*?])?|(\\*))'].join('|'),'g');function parse(a,b){for(var k,d=[],e=0,f=0,g='',h=b&&b.delimiter||'/';null!=(k=PATH_REGEXP.exec(a));){var l=k[0],n=k[1],o=k.index;if(g+=a.slice(f,o),f=o+l.length,n){g+=n[1];continue}var p=a[f],q=k[2],r=k[3],s=k[4],t=k[5],u=k[6],v=k[7];g&&(d.push(g),g='');var z=k[2]||h,A=s||t;d.push({name:r||e++,prefix:q||'',delimiter:z,optional:'?'===u||'*'===u,repeat:'+'===u||'*'===u,partial:null!=q&&null!=p&&p!==q,asterisk:!!v,pattern:A?escapeGroup(A):v?'.*':'[^'+escapeString(z)+']+?'});}return f<a.length&&(g+=a.substr(f)),g&&d.push(g),d}function compile(a,b){return tokensToFunction(parse(a,b))}function encodeURIComponentPretty(a){return encodeURI(a).replace(/[\/?#]/g,function(b){return'%'+b.charCodeAt(0).toString(16).toUpperCase()})}function encodeAsterisk(a){return encodeURI(a).replace(/[?#]/g,function(b){return'%'+b.charCodeAt(0).toString(16).toUpperCase()})}function tokensToFunction(a){for(var b=Array(a.length),d=0;d<a.length;d++)'object'==typeof a[d]&&(b[d]=new RegExp('^(?:'+a[d].pattern+')$'));return function(e,f){for(var o,g='',h=e||{},k=f||{},l=k.pretty?encodeURIComponentPretty:encodeURIComponent,n=0;n<a.length;n++){if(o=a[n],'string'==typeof o){g+=o;continue}var q,p=h[o.name];if(null==p)if(o.optional){o.partial&&(g+=o.prefix);continue}else throw new TypeError('Expected "'+o.name+'" to be defined');if(index$1(p)){if(!o.repeat)throw new TypeError('Expected "'+o.name+'" to not repeat, but received `'+JSON.stringify(p)+'`');if(0===p.length)if(o.optional)continue;else throw new TypeError('Expected "'+o.name+'" to not be empty');for(var r=0;r<p.length;r++){if(q=l(p[r]),!b[n].test(q))throw new TypeError('Expected all "'+o.name+'" to match "'+o.pattern+'", but received `'+JSON.stringify(q)+'`');g+=(0===r?o.prefix:o.delimiter)+q;}continue}if(q=o.asterisk?encodeAsterisk(p):l(p),!b[n].test(q))throw new TypeError('Expected "'+o.name+'" to match "'+o.pattern+'", but received "'+q+'"');g+=o.prefix+q;}return g}}function escapeString(a){return a.replace(/([.+*?=^!:${}()[\]|\/\\])/g,'\\$1')}function escapeGroup(a){return a.replace(/([=!:$\/()])/g,'\\$1')}function attachKeys(a,b){return a.keys=b,a}function flags(a){return a.sensitive?'':'i'}function regexpToRegexp(a,b){var d=a.source.match(/\((?!\?)/g);if(d)for(var e=0;e<d.length;e++)b.push({name:e,prefix:null,delimiter:null,optional:!1,repeat:!1,partial:!1,asterisk:!1,pattern:null});return attachKeys(a,b)}function arrayToRegexp(a,b,d){for(var e=[],f=0;f<a.length;f++)e.push(pathToRegexp(a[f],b,d).source);var g=new RegExp('(?:'+e.join('|')+')',flags(d));return attachKeys(g,b)}function stringToRegexp(a,b,d){return tokensToRegExp(parse(a,d),b,d)}function tokensToRegExp(a,b,d){index$1(b)||(d=b||d,b=[]),d=d||{};for(var k,e=d.strict,f=!1!==d.end,g='',h=0;h<a.length;h++)if(k=a[h],'string'==typeof k)g+=escapeString(k);else{var l=escapeString(k.prefix),n='(?:'+k.pattern+')';b.push(k),k.repeat&&(n+='(?:'+l+n+')*'),n=k.optional?k.partial?l+'('+n+')?':'(?:'+l+'('+n+'))?':l+'('+n+')',g+=n;}var o=escapeString(d.delimiter||'/'),p=g.slice(-o.length)===o;return e||(g=(p?g.slice(0,-o.length):g)+'(?:'+o+'(?=$))?'),g+=f?'$':e&&p?'':'(?='+o+'|$)',attachKeys(new RegExp('^'+g,flags(d)),b)}function pathToRegexp(a,b,d){return index$1(b)||(d=b||d,b=[]),d=d||{},a instanceof RegExp?regexpToRegexp(a,b):index$1(a)?arrayToRegexp(a,b,d):stringToRegexp(a,b,d)}index.parse=parse_1,index.compile=compile_1,index.tokensToFunction=tokensToFunction_1,index.tokensToRegExp=tokensToRegExp_1;

class ExpressRoute extends Route{constructor({path:a,handler:b,method:c}){if(!(a.startsWith('/')||a.startsWith('http')))throw ErrorFactory.createError('express-route-invalid-path');let d=[];const e=index(a,d);super({match:({url:g})=>{if(a.startsWith('/')&&g.origin!==location.origin)return null;const h=a.startsWith('/')?g.pathname:g.href,i=h.match(e);if(!i)return null;const j={};return d.forEach((k,l)=>{j[k.name]=i[l+1];}),j},handler:b,method:c});}}

class LogGroup{constructor(){this._logs=[],this._childGroups=[],this._isFallbackMode=!1;const a=/Firefox\/(\d*)\.\d*/.exec(navigator.userAgent);if(a)try{const b=parseInt(a[1],10);55>b&&(this._isFallbackMode=!0);}catch(b){this._isFallbackMode=!0;}/Edge\/\d*\.\d*/.exec(navigator.userAgent)&&(this._isFallbackMode=!0);}addPrimaryLog(a){this._primaryLog=a;}addLog(a){this._logs.push(a);}addChildGroup(a){0===a._logs.length||this._childGroups.push(a);}print(){return 0===this._logs.length&&0===this._childGroups.length?void this._printLogDetails(this._primaryLog):void(this._primaryLog&&(this._isFallbackMode?this._printLogDetails(this._primaryLog):console.groupCollapsed(...this._getLogContent(this._primaryLog))),this._logs.forEach((a)=>{this._printLogDetails(a);}),this._childGroups.forEach((a)=>{a.print();}),this._primaryLog&&!this._isFallbackMode&&console.groupEnd())}_printLogDetails(a){const b=a.logFunc?a.logFunc:console.log;b(...this._getLogContent(a));}_getLogContent(a){let b=a.message;this._isFallbackMode&&'string'==typeof b&&(b=b.replace(/%c/g,''));let c=[b];return!this._isFallbackMode&&a.colors&&(c=c.concat(a.colors)),a.args&&(c=c.concat(a.args)),c}}

function isDevBuild(){return`dev`==`dev`}

self.workbox=self.workbox||{},self.workbox.LOG_LEVEL=self.workbox.LOG_LEVEL||{none:-1,verbose:0,debug:1,warn:2,error:3};const LIGHT_GREY=`#bdc3c7`; const DARK_GREY=`#7f8c8d`; const LIGHT_GREEN=`#2ecc71`; const LIGHT_YELLOW=`#f1c40f`; const LIGHT_RED=`#e74c3c`; const LIGHT_BLUE=`#3498db`;class LogHelper{constructor(){this._defaultLogLevel=isDevBuild()?self.workbox.LOG_LEVEL.debug:self.workbox.LOG_LEVEL.warn;}log(a){this._printMessage(self.workbox.LOG_LEVEL.verbose,a);}debug(a){this._printMessage(self.workbox.LOG_LEVEL.debug,a);}warn(a){this._printMessage(self.workbox.LOG_LEVEL.warn,a);}error(a){this._printMessage(self.workbox.LOG_LEVEL.error,a);}_printMessage(a,b){if(this._shouldLogMessage(a,b)){const c=this._getAllLogGroups(a,b);c.print();}}_getAllLogGroups(a,b){const c=new LogGroup,d=this._getPrimaryMessageDetails(a,b);if(c.addPrimaryLog(d),b.error){const f={message:b.error,logFunc:console.error};c.addLog(f);}const e=new LogGroup;if(b.that&&b.that.constructor&&b.that.constructor.name){const f=b.that.constructor.name;e.addLog(this._getKeyValueDetails('class',f));}return b.data&&('object'!=typeof b.data||b.data instanceof Array?e.addLog(this._getKeyValueDetails('additionalData',b.data)):Object.keys(b.data).forEach((f)=>{e.addLog(this._getKeyValueDetails(f,b.data[f]));})),c.addChildGroup(e),c}_getKeyValueDetails(a,b){return{message:`%c${a}: `,colors:[`color: ${LIGHT_BLUE}`],args:b}}_getPrimaryMessageDetails(a,b){let c,d;a===self.workbox.LOG_LEVEL.verbose?(c='Info',d=LIGHT_GREY):a===self.workbox.LOG_LEVEL.debug?(c='Debug',d=LIGHT_GREEN):a===self.workbox.LOG_LEVEL.warn?(c='Warn',d=LIGHT_YELLOW):a===self.workbox.LOG_LEVEL.error?(c='Error',d=LIGHT_RED):void 0;let e=`%c🔧 %c[${c}]`;const f=[`color: ${LIGHT_GREY}`,`color: ${d}`];let g;return'string'==typeof b?g=b:b.message&&(g=b.message),g&&(g=g.replace(/\s+/g,' '),e+=`%c ${g}`,f.push(`color: ${DARK_GREY}; font-weight: normal`)),{message:e,colors:f}}_shouldLogMessage(a,b){if(!b)return!1;let c=this._defaultLogLevel;return self&&self.workbox&&'number'==typeof self.workbox.logLevel&&(c=self.workbox.logLevel),c===self.workbox.LOG_LEVEL.none||a<c?!1:!0}}var logHelper = new LogHelper;

class NavigationRoute extends Route{constructor({whitelist:a,blacklist:b,handler:c}={}){isArrayOfClass({whitelist:a},RegExp),b?isArrayOfClass({blacklist:b},RegExp):b=[];super({match:({event:e,url:f})=>{let g=!1,h;if('navigate'===e.request.mode){const i=f.pathname+f.search;a.some((j)=>j.test(i))?b.some((j)=>j.test(i))?h=`The navigation route is not being used, since the `+`request URL matches both the whitelist and blacklist.`:(h=`The navigation route is being used.`,g=!0):h=`The navigation route is not being used, since the `+`URL being navigated to doesn't match the whitelist.`,logHelper.debug({that:this,message:h,data:{"request-url":f.href,whitelist:a,blacklist:b,handler:c}});}return g},handler:c,method:'GET'});}}

class RegExpRoute extends Route{constructor({regExp:a,handler:b,method:c}){isInstance({regExp:a},RegExp);super({match:({url:e})=>{const f=a.exec(e.href);return f?e.origin!==location.origin&&0!==f.index?(logHelper.debug({that:this,message:`Skipping route, because the RegExp match didn't occur `+`at the start of the URL.`,data:{url:e.href,regExp:a}}),null):f.slice(1):null},handler:b,method:c});}}

class Router{constructor(){this._routes=new Map,this._isListenerRegistered=!1;}addFetchListener(){return this._isListenerRegistered?(logHelper.warn({that:this,message:`addFetchListener() has already been called for this Router.`}),!1):(this._isListenerRegistered=!0,self.addEventListener('fetch',(a)=>{const b=this.handleRequest({event:a});b&&a.respondWith(b);}),!0)}handleRequest({event:a}){isInstance({event:a},FetchEvent);const b=new URL(a.request.url);if(!b.protocol.startsWith('http'))return void logHelper.log({that:this,message:`The URL does not start with HTTP, so it can't be handled.`,data:{request:a.request}});let{handler:c,params:d}=this._findHandlerAndParams({event:a,url:b});if(!c&&this.defaultHandler&&(c=this.defaultHandler),c){let e=c.handle({url:b,event:a,params:d});return this.catchHandler&&(e=e.catch((f)=>{return this.catchHandler.handle({url:b,event:a,error:f})})),e}}_findHandlerAndParams({event:a,url:b}){const c=this._routes.get(a.request.method)||[];for(const d of c){let e=d.match({url:b,event:a});if(e)return logHelper.log({that:this,message:'The router found a matching route.',data:{route:d,request:a.request}}),Array.isArray(e)&&0===e.length?e=void 0:e.constructor===Object&&0===Object.keys(e).length&&(e=void 0),{params:e,handler:d.handler}}return{handler:void 0,params:void 0}}setDefaultHandler({handler:a}={}){this.defaultHandler=normalizeHandler(a);}setCatchHandler({handler:a}={}){this.catchHandler=normalizeHandler(a);}registerRoutes({routes:a}={}){isArrayOfClass({routes:a},Route);for(let b of a)this._routes.has(b.method)||this._routes.set(b.method,[]),this._routes.get(b.method).unshift(b);}registerRoute({route:a}={}){isInstance({route:a},Route),this.registerRoutes({routes:[a]});}unregisterRoutes({routes:a}={}){isArrayOfClass({routes:a},Route);for(let b of a){this._routes.has(b.method)||logHelper.error({that:this,message:`Can't unregister route; there are no ${b.method}
            routes registered.`,data:{route:b}});const c=this._routes.get(b.method).indexOf(b);-1<c?this._routes.get(b.method).splice(c,1):logHelper.error({that:this,message:`Can't unregister route; the route wasn't previously
            registered.`,data:{route:b}});}}unregisterRoute({route:a}={}){isInstance({route:a},Route),this.unregisterRoutes({routes:[a]});}}

exports.ExpressRoute = ExpressRoute;
exports.NavigationRoute = NavigationRoute;
exports.RegExpRoute = RegExpRoute;
exports.Route = Route;
exports.Router = Router;

}((this.workbox.routing = this.workbox.routing || {})));
//# sourceMappingURL=workbox-routing.dev.v2.0.0.js.map
