'use strict';

var tick = 0;
var interval = null;
var THIRTY_MINUTES = 7200; //改为2h提醒

function start() {
  if (interval) {
    tick = 0;
    clearInterval(interval);
  }
  interval = setInterval(function () {
    tick++;
    if (tick > THIRTY_MINUTES) {
      tick = 0;
      postMessage('TIMEOUT');
      clearInterval(interval);
    }
  }, 1000);
}

self.onmessage = function (trackEvent) {
  var data = trackEvent.data;
  var action = data.action;

  if (action === 'CLICK') {
    tick = 0;
  } else if (action === 'START') {
    start();
  } else if (action === 'RESET') {
    if (interval) {
      clearInterval(interval);
    }
  }
};