var kNumCameraShakePoints = 10;
var kParticleSize = 16;
var smokeImage = new Image();
smokeImage.src = "data:image/png;base64,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";
var speckImage = new Image();
speckImage.src = "data:image/png;base64,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";
var flameImage = new Image();
flameImage.src = "data:image/png;base64,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";
var KNWebGLParticleSystem = Class.create({
  initialize: function (i, e, d, h, c, b, f, j) {
    this.renderer = i;
    this.program = e;
    var g = this.gl = this.renderer.gl;
    var k = this.uniforms = e.uniforms;
    var a = this.attribs = e.attribs;
    KNWebGLUtil.enableAttribs(g, e);
    this.texture = j;
    this.objectSize = d;
    this.slideSize = h;
    this.duration = c;
    this.particleSize = f;
    this.particleSystemSize = b;
    this.particleCount = b.width * b.height;
    this.particlesWide = b.width;
    this.particlesHigh = b.height;
    this.percentfinished = 0
  }, animationWillBeginWithContext: function () {
    var u = this.gl;
    var A = this.uniforms;
    var r = this.attribs;
    if (A.SpeedMax !== undefined) {
      this._speedMax = this.speedMax();
      u.uniform1f(A.SpeedMax, this._speedMax)
    }
    if (A.RotationMax !== undefined) {
      this._rotationMax = this.rotationMax();
      u.uniform1f(A.RotationMax, this._rotationMax)
    }
    if (A.Duration !== undefined) {
      this._duration = this.duration / 1000;
      u.uniform1f(A.Duration, this._duration)
    }
    u.useProgram(this.program.shaderProgram);
    var j = this.attributeBuffers = {};
    j.Position = [];
    j.Center = [];
    j.TexCoord = [];
    j.ParticleTexCoord = [];
    j.Speed = [];
    j.Rotation = [];
    j.Scale = [];
    j.LifeSpan = [];
    var e = this.numberOfVerticesPerParticle;
    for (var k = 0, z = this.particlesHigh; k < z; k++) {
      for (var m = 0, b = this.particlesWide; m < b; m++) {
        var f = this.particleSize;
        var B = this.objectSize;
        var p = WebGraphics.makePoint(m, k);
        var h = this.particlesWide * p.y + p.x;
        var d = h * e;
        var w = WebGraphics.makeRect(m * f.width, k * f.height, f.width, f.height);
        if (this.willOverrideStartingPoints) {
          w = WebGraphics.setOrigin(w, this.startingPointAtIndexPoint(p))
        }
        var g = [];
        g[0] = WebGraphics.makePoint(w.x, w.y);
        if (e > 1) {
          g[1] = WebGraphics.makePoint(w.x + w.width, w.y);
          g[2] = WebGraphics.makePoint(w.x + w.width, w.y + w.height);
          g[3] = WebGraphics.makePoint(w.x, w.y + w.height)
        }
        for (var v = 0; v < e; v++) {
          KNWebGLUtil.setPoint2DAtIndexForAttribute(g[v], d + v, j.Position)
        }
        if (r.Center !== undefined) {
          var o = w.x + (w.width / 2);
          var n = w.y + (w.height / 2);
          KNWebGLUtil.setPoint2DAtIndexForAttribute(WebGraphics.makePoint(o, n), d, j.Center);
          KNWebGLUtil.setPoint2DAtIndexForAttribute(WebGraphics.makePoint(o, n), d + 1, j.Center);
          KNWebGLUtil.setPoint2DAtIndexForAttribute(WebGraphics.makePoint(o, n), d + 2, j.Center);
          KNWebGLUtil.setPoint2DAtIndexForAttribute(WebGraphics.makePoint(o, n), d + 3, j.Center)
        }
        if (r.TexCoord !== undefined) {
          for (var v = 0; v < e; v++) {
            var c = WebGraphics.makePoint(g[v].x / B.width, g[v].y / B.height);
            KNWebGLUtil.setPoint2DAtIndexForAttribute(c, d + v, j.TexCoord)
          }
        }
        if (r.ParticleTexCoord !== undefined) {
          KNWebGLUtil.setPoint2DAtIndexForAttribute(WebGraphics.makePoint(0, 0), d, j.ParticleTexCoord);
          KNWebGLUtil.setPoint2DAtIndexForAttribute(WebGraphics.makePoint(1, 0), d + 1, j.ParticleTexCoord);
          KNWebGLUtil.setPoint2DAtIndexForAttribute(WebGraphics.makePoint(1, 1), d + 2, j.ParticleTexCoord);
          KNWebGLUtil.setPoint2DAtIndexForAttribute(WebGraphics.makePoint(0, 1), d + 3, j.ParticleTexCoord)
        }
        if (r.Speed !== undefined) {
          var t = this.speedAtIndexPoint(p);
          KNWebGLUtil.setPoint3DAtIndexForAttribute(t, d, j.Speed);
          KNWebGLUtil.setPoint3DAtIndexForAttribute(t, d + 1, j.Speed);
          KNWebGLUtil.setPoint3DAtIndexForAttribute(t, d + 2, j.Speed);
          KNWebGLUtil.setPoint3DAtIndexForAttribute(t, d + 3, j.Speed)
        }
        if (r.Rotation !== undefined) {
          var s = this.rotationAtIndexPoint(p);
          KNWebGLUtil.setPoint3DAtIndexForAttribute(s, d, j.Rotation);
          KNWebGLUtil.setPoint3DAtIndexForAttribute(s, d + 1, j.Rotation);
          KNWebGLUtil.setPoint3DAtIndexForAttribute(s, d + 2, j.Rotation);
          KNWebGLUtil.setPoint3DAtIndexForAttribute(s, d + 3, j.Rotation)
        }
        if (r.Scale !== undefined) {
          var C = this.scaleAtIndexPoint(p);
          KNWebGLUtil.setFloatAtIndexForAttribute(C, d, j.Scale);
          KNWebGLUtil.setFloatAtIndexForAttribute(C, d + 1, j.Scale);
          KNWebGLUtil.setFloatAtIndexForAttribute(C, d + 2, j.Scale);
          KNWebGLUtil.setFloatAtIndexForAttribute(C, d + 3, j.Scale)
        }
        if (r.LifeSpan !== undefined) {
          var l = this.lifeSpanAtIndexPoint(p);
          KNWebGLUtil.setPoint2DAtIndexForAttribute(l, d, j.LifeSpan);
          KNWebGLUtil.setPoint2DAtIndexForAttribute(l, d + 1, j.LifeSpan);
          KNWebGLUtil.setPoint2DAtIndexForAttribute(l, d + 2, j.LifeSpan);
          KNWebGLUtil.setPoint2DAtIndexForAttribute(l, d + 3, j.LifeSpan)
        }
      }
    }
    var a = 0;
    var q = this.elementArray = [];
    for (var v = 0; v < this.particleCount; v++) {
      q[a++] = 4 * v + 0;
      q[a++] = 4 * v + 1;
      q[a++] = 4 * v + 2;
      q[a++] = 4 * v + 0;
      q[a++] = 4 * v + 2;
      q[a++] = 4 * v + 3
    }
    this.buffer = {};
    KNWebGLUtil.bindAllAvailableAttributesToBuffers(u, r, j, {
      LifeSpan: 2,
      Scale: 1,
      Rotation: 3,
      Speed: 3,
      ParticleTexCoord: 2,
      TexCoord: 2,
      Center: 2,
      Position: 2
    }, this.buffer);
    this.elementArrayBuffer = u.createBuffer();
    u.bindBuffer(u.ELEMENT_ARRAY_BUFFER, this.elementArrayBuffer);
    u.bufferData(u.ELEMENT_ARRAY_BUFFER, new Uint16Array(q), u.DYNAMIC_DRAW);
    u.uniform1i(this.uniforms.ParticleTexture, 0)
  }, drawFrame: function (d, c) {
    var e = this.gl;
    var b = this.program;
    var a = this.uniforms;
    this.percentfinished = d;
    e.useProgram(b.shaderProgram);
    e.bindTexture(e.TEXTURE_2D, this.texture);
    e.uniform1f(a.Percent, d);
    e.uniform1f(a.Opacity, c);
    KNWebGLUtil.bindAllAvailableAttributesToBuffers(e, this.attribs, this.attributeBuffers, {
      LifeSpan: 2,
      Scale: 1,
      Rotation: 3,
      Speed: 3,
      ParticleTexCoord: 2,
      TexCoord: 2,
      Center: 2,
      Position: 2
    }, this.buffer);
    e.bufferData(e.ELEMENT_ARRAY_BUFFER, new Uint16Array(this.elementArray), e.DYNAMIC_DRAW);
    this.draw()
  }, draw: function () {
    var a = this.gl;
    a.drawElements(a.TRIANGLES, this.elementArray.length, a.UNSIGNED_SHORT, 0)
  }, setMVPMatrix: function (b) {
    var a = this.gl;
    a.useProgram(this.program.shaderProgram);
    a.uniformMatrix4fv(this.uniforms.MVPMatrix, false, b)
  }, indexFromPoint: function (a) {
    return this.particlesWide * a.y + a.x
  }, particleSystemSizeWithRequestedNumber: function (d, b) {
    var f = 65535 / this.numberOfVerticesPerParticle;
    d = Math.min(d, f);
    if ((b.width === 0 && b.height === 0) || this.willOverrideStartingPoints || d === 1) {
      return WebGraphics.makeSize(d, 1)
    }
    if (d >= b.width * b.height) {
      return b
    }
    if (d < 1) {
      d = 1;
      return WebGraphics.makeSize(d, 1)
    }
    var c = 0, e = 0;
    var a = Math.round(Math.sqrt(b.width * b.height));
    c = Math.ceil(b.width / a) * Math.ceil(b.height / a);
    if (c === d) {
      return WebGraphics.makeSize(a, a)
    }
    if (c < d) {
      do {
        e = c;
        a--;
        c = Math.ceil(b.width / a) * Math.ceil(b.height / a)
      } while (c < d && a > 2);
      if (a <= 2) {
        return WebGraphics.makeSize(Math.ceil(b.width / 2), Math.ceil(b.height / 2))
      }
      if (Math.abs(c - d) < Math.abs(e - d)) {
        return WebGraphics.makeSize(Math.ceil(b.width / a), Math.ceil(b.height / a))
      } else {
        return WebGraphics.makeSize(Math.ceil(b.width / (a + 1)), Math.ceil(b.height / (a + 1)))
      }
    } else {
      do {
        e = c;
        a++;
        c = Math.ceil(b.width / a) * Math.ceil(b.height / a)
      } while (c > d && a > 2);
      if (a <= 2) {
        return WebGraphics.makeSize(Math.ceil(b.width / 2), Math.ceil(b.height / 2))
      }
      if (Math.abs(c - d) < Math.abs(e - d)) {
        return WebGraphics.makeSize(Math.ceil(b.width / a), Math.ceil(b.height / a))
      } else {
        return WebGraphics.makeSize(Math.ceil(b.width / (a + 1)), Math.ceil(b.height / (a + 1)))
      }
    }
  }
});
var KNWebGLBuildAnvilSmokeSystem = Class.create(KNWebGLParticleSystem, {
  initialize: function ($super, h, d, c, f, b, a, e, g) {
    this.willOverrideStartingPoints = true;
    this.numberOfVerticesPerParticle = 4;
    $super(h, d, c, f, b, a, e, g);
    this.setupWithTexture()
  }, setupWithTexture: function () {
    this.animationWillBeginWithContext()
  }, startingPointAtIndexPoint: function (b) {
    var a = this.indexFromPoint(b);
    return WebGraphics.makePoint(a / this.particleCount * this.objectSize.width - kParticleSize / 2, kParticleSize / 2)
  }, speedAtIndexPoint: function (a) {
    var c = (2 * this.indexFromPoint(a)) / (this.particleCount) - 1;
    c = (c < 0 ? -1 : 1) * Math.sqrt(Math.abs(c));
    var d = (Math.abs(c) + 0.25) * WebGraphics.randomBetween(-1, 0.1);
    c *= WebGraphics.randomBetween(0.25, 1);
    var b = WebGraphics.makePoint3D(this.p_anvilGlobalScale() * 5.6 * c, this.p_anvilGlobalScale() * 5 * -d, 0);
    return b
  }, rotationAtIndexPoint: function (a) {
    var c = (2 * this.indexFromPoint(a)) / (this.particleCount) - 1;
    var b = c * WebGraphics.randomBetween(0.5, 1) * Math.PI;
    b *= this.duration / 1000;
    return WebGraphics.makePoint3D(0, 0, b)
  }, scaleAtIndexPoint: function (a) {
    var c = Math.abs(((2 * this.indexFromPoint(a)) / this.particleCount) - 1);
    c += 1.25;
    var b = WebGraphics.randomBetween(0, 1);
    b *= b * b;
    c *= WebGraphics.mix(1, 2.5, b);
    c *= (this.p_anvilGlobalScale() / kParticleSize);
    return c
  }, lifeSpanAtIndexPoint: function (a) {
    return WebGraphics.makePoint(0, (this.duration / 1000) * WebGraphics.randomBetween(0.15, 1))
  }, p_anvilGlobalScale: function () {
    return WebGraphics.mix(1.25, 0.75, this.objectSize.width / this.slideSize.width) * (this.objectSize.width / 7)
  }
});
var KNWebGLBuildAnvilSpeckSystem = Class.create(KNWebGLParticleSystem, {
  initialize: function ($super, h, d, c, f, b, a, e, g) {
    this.willOverrideStartingPoints = true;
    this.numberOfVerticesPerParticle = 4;
    $super(h, d, c, f, b, a, e, g);
    this.setupWithTexture()
  }, setupWithTexture: function () {
    this.animationWillBeginWithContext()
  }, startingPointAtIndexPoint: function (b) {
    var a = this.indexFromPoint(b);
    return WebGraphics.makePoint(a / this.particleCount * this.objectSize.width - kParticleSize / 2, kParticleSize / 2)
  }, speedAtIndexPoint: function (a) {
    var c = WebGraphics.makePoint3D(0, 0, 0);
    var b = this.indexFromPoint(a);
    c.x = 2 * b / this.particleCount - 1;
    c.y = WebGraphics.randomBetween(0.2, 1);
    if (b % 3 != 1) {
      c.z = 0.2;
      c.y *= 0.025 * (WebGraphics.randomBetween(0, 1) < 0.5 ? -1 : 1);
      c.x *= 10;
      c.y *= 10
    } else {
      c.z = 1
    }
    c.x *= this.p_anvilGlobalScale() * 5.25;
    c.y *= this.p_anvilGlobalScale() * 4;
    return c
  }, rotationAtIndexPoint: function (a) {
    var c = (2 * this.indexFromPoint(a)) / (this.particleCount) - 1;
    var b = c * WebGraphics.randomBetween(0.5, 1) * Math.PI;
    b *= this.duration / 1000;
    return WebGraphics.makePoint3D(0, 0, b)
  }, scaleAtIndexPoint: function (b) {
    var a = this.indexFromPoint(b);
    var c = WebGraphics.randomBetween(3, 5);
    if (a % 3 != 1) {
      c *= 3
    }
    c *= (this.p_anvilGlobalScale() / kParticleSize);
    return c
  }, lifeSpanAtIndexPoint: function (b) {
    var a = this.indexFromPoint(b);
    var c = WebGraphics.makePoint(0, Math.min(1, this.duration / 1000) * WebGraphics.randomBetween(0.2, 0.5));
    if (a % 3 != 1) {
      c.y *= 10
    }
    return c
  }, p_anvilGlobalScale: function () {
    return WebGraphics.mix(1.25, 0.75, this.objectSize.width / this.slideSize.width) * (this.objectSize.width / 7)
  }
});
var KNWebGLBuildFlameSystem = Class.create(KNWebGLParticleSystem, {
  initialize: function ($super, i, f, d, h, c, g, j) {
    this.willOverrideStartingPoints = true;
    this.numberOfVerticesPerParticle = 4;
    var b = d.width;
    var k = d.height;
    var a = this.particleSystemSizeWithRequestedNumber(g, WebGraphics.makeSize(b, k));
    var e = WebGraphics.makeSize(Math.ceil(b / a.width), Math.ceil(k / a.height));
    $super(i, f, d, h, c, a, e, j)
  }, p_setupParticleDataWithTexture: function (p) {
    var A = this.gl;
    var v = p.width;
    var r = p.height;
    var u = A.createFramebuffer();
    var t = new Uint8Array(v * r * 4);
    A.bindFramebuffer(A.FRAMEBUFFER, u);
    A.framebufferTexture2D(A.FRAMEBUFFER, A.COLOR_ATTACHMENT0, A.TEXTURE_2D, p.texture, 0);
    if (A.checkFramebufferStatus(A.FRAMEBUFFER) == A.FRAMEBUFFER_COMPLETE) {
      A.readPixels(0, 0, v, r, A.RGBA, A.UNSIGNED_BYTE, t)
    }
    var s = {x: v, y: r};
    var E = {x: 0, y: 0};
    var c = [];
    var C = v;
    var m = {};
    for (var B = 0; B < v * 4; B += 4) {
      var l = B / 4;
      var F = Number.MAX_VALUE;
      var D = 0;
      var e = false;
      var a = {x: l / v, y: -1};
      for (var z = r - 1; z >= 0; z--) {
        var g = l * 4 + z * (v) * 4 + 3;
        var k = r - z;
        if (t[g] / 255 > 0.1) {
          F = Math.min(k, F);
          D = Math.max(k, D);
          e = true
        }
      }
      if (e) {
        a.y = D / r;
        s.x = Math.min(s.x, l);
        E.x = Math.max(E.x, l);
        s.y = Math.min(s.y, F);
        E.y = Math.max(E.y, D)
      }
      c[l] = a
    }
    m = {width: E.x - s.x, height: E.y - s.y};
    this._actualSize = m;
    this._bottomRow = c;
    this._bottomRowCount = C;
    A.bindFramebuffer(A.FRAMEBUFFER, null);
    this.animationWillBeginWithContext();
    var w = this.attributeBuffers.Position;
    var q = this.attributeBuffers.Center;
    var o = this._actualSize.height / 2;
    var f = this.numberOfVerticesPerParticle;
    for (var h = 0, d = this.particleCount; h < d; h++) {
      var b = h * f;
      var H = {x: w[b * 2], y: w[b * 2 + 1]};
      H.x -= o / 2;
      H.y -= o / 2;
      var n = WebGraphics.makeRect(H.x, H.y, o, o);
      var G = WebGraphics.makePoint(H.x + o / 2, H.y + o / 2);
      KNWebGLUtil.setPoint2DAtIndexForAttribute(WebGraphics.makePoint(n.x, n.y), b, w);
      KNWebGLUtil.setPoint2DAtIndexForAttribute(WebGraphics.makePoint(n.x + n.width, n.y), b + 1, w);
      KNWebGLUtil.setPoint2DAtIndexForAttribute(WebGraphics.makePoint(n.x + n.width, n.y + n.height), b + 2, w);
      KNWebGLUtil.setPoint2DAtIndexForAttribute(WebGraphics.makePoint(n.x, n.y + n.height), b + 3, w);
      for (var B = 0; B < 4; B++) {
        KNWebGLUtil.setPoint2DAtIndexForAttribute(G, b + B, q)
      }
    }
  }, startingPointAtIndexPoint: function (d) {
    var a = 0;
    var e = 0;
    if (this._bottomRow) {
      do {
        var c = WebGraphics.randomBetween(0, this._bottomRowCount - 1);
        c = Math.round(c);
        a = this._bottomRow[c].x;
        e = this._bottomRow[c].y
      } while (e === -1)
    }
    var b = {x: a * this.objectSize.width, y: e * this.objectSize.height};
    return b
  }, speedAtIndexPoint: function (c) {
    var b = this.indexFromPoint(c) * 4;
    var e = this.attributeBuffers.Position[b * 2 + 1];
    e = Math.min(e, this._actualSize.height);
    var d = (this._actualSize.height * 0.2 + 0.9 * e) * (1 + WebGraphics.randomBetween(0, 0.1));
    var a = WebGraphics.makePoint3D(0, d, 0);
    a = WebGraphics.multiplyPoint3DByScalar(a, 1 / this.speedMax());
    return a
  }, speedMax: function () {
    return this._actualSize.height * 1.1 * 1.1
  }, lifeSpanAtIndexPoint: function (a) {
    var e = Math.min(1, 1 / Math.max(2, this._duration));
    var c = e * WebGraphics.randomBetween(0.8, 1);
    var d = this.indexFromPoint(a) / this.particleCount;
    d = d * d * 0.25 + d * 0.75;
    d *= 1 - c;
    var b = WebGraphics.makePoint(d, c);
    return b
  }, rotationAtIndexPoint: function (b) {
    var a = WebGraphics.makePoint3D(WebGraphics.randomBetween(-1, 1), 0, WebGraphics.randomBetween(-1, 1));
    return a
  }, rotationMax: function () {
    return Math.PI * 2
  }
});
var KNWebGLBuildConfettiSystem = Class.create(KNWebGLParticleSystem, {
  initialize: function ($super, i, f, d, h, c, g, j) {
    this.willOverrideStartingPoints = false;
    this.numberOfVerticesPerParticle = 4;
    var b = d.width;
    var k = d.height;
    var a = this.particleSystemSizeWithRequestedNumber(g, WebGraphics.makeSize(b, k));
    var e = WebGraphics.makeSize(Math.ceil(b / a.width), Math.ceil(k / a.height));
    $super(i, f, d, h, c, a, e, j);
    this.setupWithTexture()
  }, setupWithTexture: function () {
    this.animationWillBeginWithContext()
  }, startingPointAtIndexPoint: function (b) {
    var a = this.indexFromPoint(b);
    return WebGraphics.makePoint(a / this.particleCount * this.objectSize.width - kParticleSize / 2, kParticleSize / 2)
  }, speedAtIndexPoint: function (l) {
    var b = 0.025;
    var a = b * 20;
    var i = this.objectSize.width / this.slideSize.width * this.objectSize.height / this.slideSize.height;
    i = Math.sqrt(i);
    i = 1 - i * 0.75;
    b *= i;
    a *= i;
    var k = Math.min(this.objectSize.height, this.objectSize.width);
    var g = k * a;
    var h = k * b;
    var c = (this.particleSystemSize.width * this.particleSystemSize.width + this.particleSystemSize.height * this.particleSystemSize.height) / 4;
    var f = WebGraphics.makePoint3D(WebGraphics.randomBetween(-1, 1), WebGraphics.randomBetween(-1, 1), WebGraphics.randomBetween(-1, 1));
    f.z = -Math.abs(f.z);
    f = WebGraphics.multiplyPoint3DByScalar(f, g);
    var d = WebGraphics.makePoint3D(l.x - this.particlesWide / 2, l.y - this.particlesHigh / 2, 0);
    var j = (d.x * d.x + d.y * d.y);
    d.z = Math.sqrt(c - j);
    var e = WebGraphics.multiplyPoint3DByScalar(d, h);
    e = WebGraphics.addPoint3DToPoint3D(e, f);
    return e
  }, rotationAtIndexPoint: function (a) {
    var c = 8 * Math.PI;
    var b = WebGraphics.makePoint3D(WebGraphics.randomBetween(-1, 1), WebGraphics.randomBetween(-1, 1), WebGraphics.randomBetween(-1, 1));
    return WebGraphics.multiplyPoint3DByScalar(b, c)
  }, scaleAtIndexPoint: function (a) {
    return 1
  }
});
var KNWebGLBuildDiffuseSystem = Class.create(KNWebGLParticleSystem, {
  initialize: function ($super, j, g, e, i, d, h, k, c) {
    this.willOverrideStartingPoints = false;
    this.numberOfVerticesPerParticle = 4;
    this.l2r = c;
    var b = e.width;
    var l = e.height;
    var a = this.particleSystemSizeWithRequestedNumber(h, WebGraphics.makeSize(b, l));
    var f = WebGraphics.makeSize(Math.ceil(b / a.width), Math.ceil(l / a.height));
    $super(j, g, e, i, d, a, f, k);
    this.setupWithTexture()
  }, setupWithTexture: function () {
    this.animationWillBeginWithContext()
  }, speedAtIndexPoint: function (e) {
    var d = this.l2r;
    var f = WebGraphics.makePoint3D(WebGraphics.randomBetween(-1, 1), WebGraphics.randomBetween(-1, 1), WebGraphics.randomBetween(-1, 1));
    var c = 2 * e.y / this.particleSystemSize.height - 1;
    f = WebGraphics.multiplyPoint3DByScalar(f, (1.1 - c * c) * 8);
    var b = WebGraphics.makePoint3D((2 - Math.abs(c)) * (d ? -1 : 1), c * 2, 0);
    b = WebGraphics.multiplyPoint3DByScalar(b, 5);
    var a = WebGraphics.addPoint3DToPoint3D(b, f);
    a = WebGraphics.point3DNormalize(a);
    return a
  }, speedMax: function () {
    var a = this.objectSize.height * 1.5 / Math.sqrt(this.duration / 1000);
    return a
  }, rotationAtIndexPoint: function (b) {
    var a = WebGraphics.makePoint3D(WebGraphics.randomBetween(-1, 1), WebGraphics.randomBetween(-1, 1), 0);
    return a
  }, rotationMax: function () {
    var a = 8 * Math.PI;
    return a
  }, lifeSpanAtIndexPoint: function (b) {
    var a = this.l2r;
    var d = this.particleSystemSize.width;
    var f = WebGraphics.clamp(0.8 / (this.duration / 1000), 0.1, 0.9);
    var e = (a ? (d - b.x) : b.x) / d;
    e *= (1 - f);
    var c = WebGraphics.makePoint(e, f);
    return c
  }
});