bl_info = {
    "name": "Auto Eye BETA",
    "description": "Customizable procedural eye for Cycles and Eevee",
    "author": "Lucas Falcao",
    "version": (0, 3),
    "blender": (2, 80, 0),
    "location": "View3D > Add",
    "wiki_url":"https://www.blendermarket.com/products/auto-eye/docs",
    "category": "Add Mesh",
}

import bpy
from os import path


my_dir = path.dirname(path.realpath(__file__))
blend_file = path.join(my_dir, "auto_eye.blend")
print(blend_file)

class AutoEyeAdd(bpy.types.Operator):
    bl_idname = "add.auto_eye"
    bl_label = "Auto Eye"
    bl_description = ("Adds a new Auto Eye to your scene")
    bl_options = {'REGISTER', 'UNDO'}

    #adds all objects starting with the name auto_eye to the scene
    def execute(self, context):
        with bpy.data.libraries.load(blend_file) as (data_from, data_to):
            data_to.objects = [name for name in data_from.objects if "auto_eye" in name]
        for obj in data_to.objects:
            context.collection.objects.link(obj)
        return{'FINISHED'}

def draw(self, context):
    layout = self.layout
    layout.operator("add.auto_eye", text="Auto Eye", icon="PROP_CON")


def register():
    bpy.utils.register_class(AutoEyeAdd)
    bpy.types.VIEW3D_MT_add.append(draw)


def unregister():
    bpy.utils.unregister_class(AutoEyeAdd)
    bpy.types.VIEW3D_MT_add.remove(draw)

if __name__ == "__main__":
    register()
