var topic = "<!DOCTYPE html>\r\n\n<!-- saved from url=(0024)http://docs.autodesk.com -->\r\n<html>\n   <head>\n      <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n      <meta name=\"product\" content=\"VAULT\">\n      <meta name=\"release\" content=\"2021\">\n      <meta name=\"book\" content=\"GeneralUser\">\n      <meta name=\"created\" content=\"2020-03-20\">\n      <meta name=\"topicid\" content=\"GUID-F37FCEBB-BE65-4591-874E-3DA7691B6023\">\n      <meta name=\"description\" content=\"Binding is an essential concept to establish a connection between the Data Standard UI and the underlying business logic. This topic contains a list of available Data Standard properties and functions that can be used in bindings.\">\n      <meta name=\"topic-type\" content=\"concept\">\n      <meta name=\"audience\" content=\"administrator\">\n      <meta name=\"experiencelevel\" content=\"general\">\n      <title>Data Standard XAML Bindings</title><script language=\"javascript\">var index = \'index.html\';</script></head>\n   <body height=\"100%\">\n      <div class=\"body_content\" id=\"body-content\" dir=\"ltr\"><a name=\"GUID-F37FCEBB-BE65-4591-874E-3DA7691B6023\"></a><div class=\"head\">\n            <h1>Data Standard XAML Bindings</h1>\n         </div>\n         <p class=\"blurb\"> Binding is an essential concept to establish a connection between the Data Standard\n            UI and the underlying business logic. This topic contains a list of available Data\n            Standard properties and functions that can be used in bindings. \n            \n         </p>\n         <p> The availability indicates in which XAML files the objects can be used. \n            	 \n         </p><a name=\"TABLE_7F71BD6F9DA746D8B387D5EEF6E7E273\"></a><div class=\"table-not-ruled\">\n            <table cellpadding=\"0\" cellspacing=\"0\" class=\"not-ruled\">\n               <colgroup>\n                  <col>\n                  <col>\n                  <col>\n               </colgroup>\n               <tr class=\"not-ruled-heading\">\n                  <th class=\"table-heading\"> \n                     <p class=\"table-heading\">Object \n                        				  \n                     </p> \n                  </th>\n                  <th class=\"table-heading\"> \n                     <p class=\"table-heading\">Availability \n                        				  \n                     </p> \n                  </th>\n                  <th class=\"table-heading\"> \n                     <p class=\"table-heading\">Description \n                        				  \n                     </p> \n                  </th>\n               </tr>\n               <tr class=\"not-ruled-odd-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"code\">CancelWindowCommand</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"> Vault dialogs; CAD \n                        				  \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"> Used as \"Command\" binding for Cancel buttons in all dialogs. This function closes\n                        the dialog and cancels the current function. \n                        				  \n                     </p> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-even-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"code\">CloseWindowCommand</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"> Vault dialogs; CAD \n                        				  \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"> Used as \"Command\" binding for\"OK buttons in all dialogs. This function closes the\n                        dialog and continues with the function. For example, save or create new files by using\n                        the data specified in the dialog. \n                        				  \n                     </p> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-odd-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"code\">CopyMode</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">CAD \n                        				  \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"> Is set to \"True\" when the Data Standard window is in copy mode. For example, when\n                        running a copy function. Is used to control the appearance of the dialog (e.g., enable/disable,\n                        hide controls). \n                        				  \n                     </p> \n                     <p class=\"table-body\"> When \n                        					 <span class=\"code\">CopyMode</span> is True, \n                        					 <span class=\"code\">CreateMode</span> is also set True. \n                        				  \n                     </p> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-even-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"code\">CreateMode</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">CAD, Vault \n                        				  \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"> Is set to \"True\" when the Data Standard window is in create mode. For example, when\n                        the file gets saved for the first time. \n                        				  \n                     </p> \n                     <p class=\"table-body\">Is used to control the appearance of the dialog (e.g., enable/disable, hide controls).\n                        \n                        				  \n                     </p> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-odd-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"code\">DynamicProperties</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"> Vault dialogs, tabs; CAD \n                        				  \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"> Returns a list of properties for a the Vault category defined by \n                        					 <span class=\"code\">DynamicPropertiesCategory</span>. See \n                        					 <span class=\"char_link\"><a href=\"GUID-32319A9D-ADBD-429E-A41D-FEC2511F9798.htm\">Dynamic Properties</a></span> for more details. \n                        				  \n                     </p> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-even-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"code\">DynamicPropertiesCategory</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"> Vault dialogs, tabs; CAD \n                        				  \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"> Sets the Vault category that should be used for \n                        					 <span class=\"code\">DynamicProperties</span>. See \n                        					 <span class=\"char_link\"><a href=\"GUID-32319A9D-ADBD-429E-A41D-FEC2511F9798.htm\">Dynamic Properties</a></span> for more details. \n                        				  \n                     </p> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-odd-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"code\">EditMode</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">CAD, Vault \n                        				  \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"> Is set to \"True\" when the Data Standard window is in create mode. Is used to control\n                        the appearance of the dialog (e.g., enable/disable, hide controls). \n                        				  \n                     </p> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-even-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"code\">PathAndFileNameHandler</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">CAD \n                        				  \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"> Provides access to the internal \n                        					 <span class=\"code\">PathAndFileNameHandler</span> object. Can be used in \"Text\" bindings to show the filename, path, or original filename\n                        in the dialog. \n                        				  \n                     </p> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-odd-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"code\">IsCadFile, IsNonCadFile</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">Vault dialogs \n                        				  \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"> Returns \"True\" if the context file is a CAD file (see \n                        					 <span class=\"char_link\"><a href=\"GUID-C62F38C5-428E-4272-9947-1DE3FAAE4D7D.htm\">$IsCADFile, $IsNotCADFile</a></span>). Is used to control the appearance of the dialog (e.g., enable/disable, hide controls).\n                        \n                        				  \n                     </p> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-even-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"code\">IsEditDialog</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">Vault dialogs \n                        				  \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">Equivalent to \n                        					 <span class=\"code\">EditMode</span> for CAD. \n                        				  \n                     </p> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-odd-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"code\">IsNewEntryDialog</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">Vault dialogs \n                        				  \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">Equivalent to \n                        					 <span class=\"code\">CreateMode</span> for CAD. \n                        				  \n                     </p> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-even-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"code\">IsOfficeClient, IsNotOfficeClient</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"> Vault dialogs, tabs \n                        				  \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"> Returns \"True\" if running in a Vault Office client (see \n                        					 <span class=\"char_link\"><a href=\"GUID-AEDBD5B6-9301-4D16-BD24-E7E619013E99.htm\">$IsOfficeClient, $IsNotOfficeClient</a></span> ). Is used to control the appearance of the dialog (e.g., enable/disable, hide controls).\n                        \n                        				  \n                     </p> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-odd-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"code\">IsValid, IsInvalid</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">CAD \n                        				  \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"> Can be used in \n                        					 <span class=\"code\">IsEnabled</span> bindings for OK button to disable the button if not all entered property values are\n                        valid. \n                        				  \n                     </p> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-even-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"code\">Prop[]</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">Vault dialogs, tabs; CAD \n                        				  \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"> Used to access Vault properties or file properties for CAD. For more details about\n                        this object, see \n                        					 <span class=\"char_link\"><a href=\"GUID-9851FE4D-6788-467F-B79D-EF78F385BD2C.htm\">$Prop[]</a></span>. \n                        				  \n                     </p> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-odd-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"code\">PsCmd[]</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">Vault dialogs, tabs; CAD \n                        				  \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"> Can be used to execute a PowerShell function. The function name has to be specified\n                        in the square brackets. \n                        				  \n                     </p> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-even-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"code\">PsList[]</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">Vault dialogs, tabs; CAD \n                        				  \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"> Can be used to execute a PowerShell function. The function name has to be specified\n                        in the square brackets. The function returns a string which can be used for example\n                        in a \n                        					 <span class=\"code\">Text</span> binding. \n                        				  \n                     </p> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-odd-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"code\">PsVal[]</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">Vault dialogs, tabs; CAD \n                        				  \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"> Can be used to execute a PowerShell function. The function name has to be specified\n                        in the square brackets. The function returns a list of objects which can be used for\n                        example in a \n                        					 <span class=\"code\">ItemsSource</span> binding for ComboBox controls. \n                        				  \n                     </p> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-even-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"code\">UiString[]</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">Vault dialogs, tabs; CAD \n                        				  \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"> Returns localized text strings identified by an ID. See \n                        					 <span class=\"char_link\"><a href=\"GUID-244DFF1D-7473-41D8-AA7D-43A3FB25D17F.htm\">Localization</a></span> for more information. \n                        				  \n                     </p> \n                     <p class=\"table-body\"> Can be used for example in \n                        					 <span class=\"code\">Content</span> bindings for Label controls. \n                        				  \n                     </p> \n                  </td>\n               </tr>\n            </table>\n         </div>\n         <p> Here is a list of special properties that can be used in bindings for Inventor functional\n            documents dialogs: \n            	 \n         </p><a name=\"TABLE_BAB01DDB31164C9AA0F15126801EB5EC\"></a><div class=\"table-not-ruled\">\n            <table cellpadding=\"0\" cellspacing=\"0\" class=\"not-ruled\">\n               <colgroup>\n                  <col>\n                  <col>\n               </colgroup>\n               <tr class=\"not-ruled-heading\">\n                  <th class=\"table-heading\"> \n                     <p class=\"table-heading\">Object \n                        				  \n                     </p> \n                  </th>\n                  <th class=\"table-heading\"> \n                     <p class=\"table-heading\">Availability \n                        				  \n                     </p> \n                  </th>\n               </tr>\n               <tr class=\"not-ruled-odd-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"charspan-emphasis\"> ActiveSelectionIsDesignAcceleratorAssemblies</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"filePath\"> DesignAccelerator.xaml</span> \n                     </p> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-even-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"charspan-emphasis\"> ActiveSelectionIsDesignAcceleratorParts</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"filePath\"> DesignAccelerator.xaml</span> \n                     </p> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-odd-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"charspan-emphasis\"> DesignAcceleratorAssemblies</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"filePath\"> DesignAccelerator.xaml</span> \n                     </p> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-even-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"charspan-emphasis\"> DesignAcceleratorParts</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"filePath\"> DesignAccelerator.xaml</span> \n                     </p> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-odd-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"charspan-emphasis\"> ActiveSelectionIsFrameDocuments</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"filePath\"> FrameGenerator.xaml</span> \n                     </p> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-even-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"charspan-emphasis\"> ActiveSelectionIsFrameMemberDocuments</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"filePath\"> FrameGenerator.xaml</span> \n                     </p> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-odd-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"charspan-emphasis\"> ActiveSelectionIsSkeletonDocuments</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"filePath\"> FrameGenerator.xaml</span> \n                     </p> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-even-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"charspan-emphasis\"> FrameDocuments</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"filePath\"> FrameGenerator.xaml</span> \n                     </p> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-odd-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"charspan-emphasis\"> FrameMemberDocuments</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"filePath\"> FrameGenerator.xaml</span> \n                     </p> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-even-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"charspan-emphasis\"> SkeletonDocuments</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"filePath\"> FrameGenerator.xaml</span> \n                     </p> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-odd-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"charspan-emphasis\"> ActiveSelectionIsHarnessAssemblies</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"filePath\"> CableAndHarness.xaml</span> \n                     </p> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-even-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"charspan-emphasis\"> ActiveSelectionIsHarnessParts</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"filePath\"> CableAndHarness.xaml</span> \n                     </p> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-odd-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"charspan-emphasis\"> HarnessAssemblies</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"filePath\"> CableAndHarness.xaml</span> \n                     </p> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-even-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"charspan-emphasis\"> HarnessParts</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"filePath\"> CableAndHarness.xaml</span> \n                     </p> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-odd-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"charspan-emphasis\"> ActiveSelectionIsRunAssemblies</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"filePath\"> TubeAndPipe.xaml</span> \n                     </p> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-even-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"charspan-emphasis\"> ActiveSelectionIsRouteParts</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"filePath\"> TubeAndPipe.xaml</span> \n                     </p> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-odd-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"charspan-emphasis\"> ActiveSelectionIsRunComponents</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"filePath\"> TubeAndPipe.xaml</span> \n                     </p> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-even-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"charspan-emphasis\"> RouteParts</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"filePath\"> TubeAndPipe.xaml</span> \n                     </p> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-odd-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"charspan-emphasis\"> RunAssemblies</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"filePath\"> TubeAndPipe.xaml</span> \n                     </p> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-even-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"charspan-emphasis\"> RunComponents</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"filePath\"> TubeAndPipe.xaml</span> \n                     </p> \n                  </td>\n               </tr>\n            </table>\n         </div>\n         <div class=\"footer-block\"><a href=\"..\" class=\"comments-anchor\" target=\"_blank\"><span class=\"comments-link\">Please send us your comment about this page</span></a></div><br><p class=\"footer-license-block\"><a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\"><img alt=\"Creative Commons License\" style=\"border-width: 0;\" src=\"../images/ccLink.png\"></a>&nbsp;<em>Except where otherwise noted, this work is licensed under a <a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\">Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License</a>. Please see the <a href=\"http://autodesk.com/creativecommons\" target=\"_blank\">Autodesk Creative Commons FAQ</a> for more information.</em></p><br></div>\n   </body>\n</html>";
// SIG // Begin signature block
// SIG // MIIbRQYJKoZIhvcNAQcCoIIbNjCCGzICAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // SgyLI/LBCe+f1F5DXhf6D9xII3yTbybmS72yIXe6dH6g
// SIG // ggoaMIIEyzCCA7OgAwIBAgIQCQja65wGHi65un4mqmKH
// SIG // ijANBgkqhkiG9w0BAQsFADCBhDELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTUw
// SIG // MwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
// SIG // b2RlIFNpZ25pbmcgQ0EgLSBHMjAeFw0xOTA1MTQwMDAw
// SIG // MDBaFw0yMDA1MTMyMzU5NTlaMHwxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIDApDYWxpZm9ybmlhMRMwEQYDVQQHDApT
// SIG // YW4gUmFmYWVsMRcwFQYDVQQKDA5BdXRvZGVzaywgSW5j
// SIG // LjERMA8GA1UECwwIU2VjdXJpdHkxFzAVBgNVBAMMDkF1
// SIG // dG9kZXNrLCBJbmMuMIIBIjANBgkqhkiG9w0BAQEFAAOC
// SIG // AQ8AMIIBCgKCAQEAkVKRoPYsoxPdlabspcuG8HYDfcWQ
// SIG // 9qyPOT2punwpVdjt2slktcpSTlydrGy8ijcbl5/k8AOJ
// SIG // afKMQvow0fNjIoNB5nsb8j2xFJPbBhHl8GT4P6DZ1OWK
// SIG // ioiUXgGHKjctUws49J4elntqvBYhKCbuPqG772QCoYFU
// SIG // P7qcFbh3PbyNB6cnKMn2vNGRqiEtV2aGg+/MiL3QPsvT
// SIG // kTWhVuTLIvwZ4kK5C5ACiQzlGOlE+C7gWuFoxtvy6gUa
// SIG // A8JAq/xLjYKwFevQwGncg3s1cuiGhx0P7Rvn6oCd2cem
// SIG // FmbK3I3rMRt+jc9wzAj3oHxvCo4f5Lfva+OpC1dETUVV
// SIG // sk0VGwIDAQABo4IBPjCCATowCQYDVR0TBAIwADAOBgNV
// SIG // HQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMw
// SIG // YQYDVR0gBFowWDBWBgZngQwBBAEwTDAjBggrBgEFBQcC
// SIG // ARYXaHR0cHM6Ly9kLnN5bWNiLmNvbS9jcHMwJQYIKwYB
// SIG // BQUHAgIwGQwXaHR0cHM6Ly9kLnN5bWNiLmNvbS9ycGEw
// SIG // HwYDVR0jBBgwFoAU1MAGIknrOUvdk+JcobhHdglyA1gw
// SIG // KwYDVR0fBCQwIjAgoB6gHIYaaHR0cDovL3JiLnN5bWNi
// SIG // LmNvbS9yYi5jcmwwVwYIKwYBBQUHAQEESzBJMB8GCCsG
// SIG // AQUFBzABhhNodHRwOi8vcmIuc3ltY2QuY29tMCYGCCsG
// SIG // AQUFBzAChhpodHRwOi8vcmIuc3ltY2IuY29tL3JiLmNy
// SIG // dDANBgkqhkiG9w0BAQsFAAOCAQEA0Q2+iVSEfT4xGq3A
// SIG // OADVb0rT5Z8E+PPb1x6hKknSzuaZKk/acDz9mdnFajaU
// SIG // WgIKiFJlsqJnuAM1w4lqKaEWsz3DoxvGIEwexj71Ud6a
// SIG // KlBJNcR9DdkXUZwMhbw9d78rjJAIX6tOwfSludZfdq8b
// SIG // YEkuIzQi9uYW9vHVPSCzhnUBKjwc9qTo9yBc7Fcn4FAT
// SIG // 90DzWM2hS9oc3p0pprYI2I/O4th90BEmwWkVqVgfaR0z
// SIG // VyIEmBbqB/IWLfjUBZJ/8sbkwWuWlYVRrfPxsj1e9qvb
// SIG // wE3Y28jWyGbqoUG39GhXk3uT8R8i3+T6M0c4rMfdifBC
// SIG // pceCaFTJzSye7LoeVzCCBUcwggQvoAMCAQICEHwbNTVK
// SIG // 59t050FfEWnKa6gwDQYJKoZIhvcNAQELBQAwgb0xCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjEfMB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29y
// SIG // azE6MDgGA1UECxMxKGMpIDIwMDggVmVyaVNpZ24sIElu
// SIG // Yy4gLSBGb3IgYXV0aG9yaXplZCB1c2Ugb25seTE4MDYG
// SIG // A1UEAxMvVmVyaVNpZ24gVW5pdmVyc2FsIFJvb3QgQ2Vy
// SIG // dGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMTQwNzIyMDAw
// SIG // MDAwWhcNMjQwNzIxMjM1OTU5WjCBhDELMAkGA1UEBhMC
// SIG // VVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9u
// SIG // MR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3Jr
// SIG // MTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1
// SIG // NiBDb2RlIFNpZ25pbmcgQ0EgLSBHMjCCASIwDQYJKoZI
// SIG // hvcNAQEBBQADggEPADCCAQoCggEBANeVQ9Tc32euOftS
// SIG // pLYmMQRw6beOWyq6N2k1lY+7wDDnhthzu9/r0XY/ilaO
// SIG // 6y1L8FcYTrGNpTPTC3Uj1Wp5J92j0/cOh2W13q0c8fU1
// SIG // tCJRryKhwV1LkH/AWU6rnXmpAtceSbE7TYf+wnirv+9S
// SIG // rpyvCNk55ZpRPmlfMBBOcWNsWOHwIDMbD3S+W8sS4duM
// SIG // xICUcrv2RZqewSUL+6McntimCXBx7MBHTI99w94Zzj7u
// SIG // BHKOF9P/8LIFMhlM07Acn/6leCBCcEGwJoxvAMg6ABFB
// SIG // ekGwp4qRBKCZePR3tPNgKuZsUAS3FGD/DVH0qIuE/iHa
// SIG // XF599Sl5T7BEdG9tcv8CAwEAAaOCAXgwggF0MC4GCCsG
// SIG // AQUFBwEBBCIwIDAeBggrBgEFBQcwAYYSaHR0cDovL3Mu
// SIG // c3ltY2QuY29tMBIGA1UdEwEB/wQIMAYBAf8CAQAwZgYD
// SIG // VR0gBF8wXTBbBgtghkgBhvhFAQcXAzBMMCMGCCsGAQUF
// SIG // BwIBFhdodHRwczovL2Quc3ltY2IuY29tL2NwczAlBggr
// SIG // BgEFBQcCAjAZGhdodHRwczovL2Quc3ltY2IuY29tL3Jw
// SIG // YTA2BgNVHR8ELzAtMCugKaAnhiVodHRwOi8vcy5zeW1j
// SIG // Yi5jb20vdW5pdmVyc2FsLXJvb3QuY3JsMBMGA1UdJQQM
// SIG // MAoGCCsGAQUFBwMDMA4GA1UdDwEB/wQEAwIBBjApBgNV
// SIG // HREEIjAgpB4wHDEaMBgGA1UEAxMRU3ltYW50ZWNQS0kt
// SIG // MS03MjQwHQYDVR0OBBYEFNTABiJJ6zlL3ZPiXKG4R3YJ
// SIG // cgNYMB8GA1UdIwQYMBaAFLZ3+mlIR59TEtXC6gcydgfR
// SIG // lwcZMA0GCSqGSIb3DQEBCwUAA4IBAQB/68qn6ot2Qus+
// SIG // jiBUMOO3udz6SD4Wxw9FlRDNJ4ajZvMC7XH4qsJVl5Fw
// SIG // g/lSflJpPMnx4JRGgBi7odSkVqbzHQCR1YbzSIfgy8Q0
// SIG // aCBetMv5Be2cr3BTJ7noPn5RoGlxi9xR7YA6JTKfRK9u
// SIG // QyjTIXW7l9iLi4z+qQRGBIX3FZxLEY3ELBf+1W5/muJW
// SIG // kvGWs60t+fTf2omZzrI4RMD3R3vKJbn6Kmgzm1By3qif
// SIG // 1M0sCzS9izB4QOCNjicbkG8avggVgV3rL+JR51EeyXgp
// SIG // 5x5lvzjvAUoBCSQOFsQUecFBNzTQPZFSlJ3haO8I8OJp
// SIG // nGdukAsak3HUJgLDwFojMYIQgzCCEH8CAQEwgZkwgYQx
// SIG // CzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRlYyBD
// SIG // b3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1
// SIG // c3QgTmV0d29yazE1MDMGA1UEAxMsU3ltYW50ZWMgQ2xh
// SIG // c3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENBIC0gRzIC
// SIG // EAkI2uucBh4uubp+Jqpih4owDQYJYIZIAWUDBAIBBQCg
// SIG // fDAQBgorBgEEAYI3AgEMMQIwADAZBgkqhkiG9w0BCQMx
// SIG // DAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4wDAYK
// SIG // KwYBBAGCNwIBFTAvBgkqhkiG9w0BCQQxIgQg/kLv5j4+
// SIG // M6I9zUunrhVDMmYoErSk9QGs1s2f3okjiX8wDQYJKoZI
// SIG // hvcNAQEBBQAEggEAVSYYUxJo8S3/70QSaQOg+O3pO95+
// SIG // E3W1cYoZPlKi5S64BLEdv7STnap2vPV1iuEtmEIK0NUJ
// SIG // p48U0NE3oz3VCJVEoFaalrP7KRaigU1Dx1altp4VqkNk
// SIG // fMY0p/65kQGAsE4m5inEZxO+zIWFnyDq8VDP29/f2Xzi
// SIG // LGmh4u1NSgmbS/8VqKPsOrWTssug1T8B3/ScQ2nXU/4b
// SIG // faneTE0zc/mSVLPYFkBn9RgBfeiIKVDSjXBloS2Ux35n
// SIG // 69Tw3CO69TJIDqY1mTJ/s2bgK+A4t7ZXo2KmWkPVmWnr
// SIG // O7oj7E2q8OmAV7MOa51RgEWiQO4DQ153g+3JozUXKQm8
// SIG // ftoBcqGCDjwwgg44BgorBgEEAYI3AwMBMYIOKDCCDiQG
// SIG // CSqGSIb3DQEHAqCCDhUwgg4RAgEDMQ0wCwYJYIZIAWUD
// SIG // BAIBMIIBDgYLKoZIhvcNAQkQAQSggf4EgfswgfgCAQEG
// SIG // C2CGSAGG+EUBBxcDMDEwDQYJYIZIAWUDBAIBBQAEICUI
// SIG // GcynVJ88OAjVgWuIupd0eKENozuvEK7QjEjarb4kAhRx
// SIG // GO6Qs+dmsrgHUG4ICR1+XOaVAhgPMjAyMDAzMjMxNDAz
// SIG // MjlaMAMCAR6ggYakgYMwgYAxCzAJBgNVBAYTAlVTMR0w
// SIG // GwYDVQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlvbjEfMB0G
// SIG // A1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazExMC8G
// SIG // A1UEAxMoU3ltYW50ZWMgU0hBMjU2IFRpbWVTdGFtcGlu
// SIG // ZyBTaWduZXIgLSBHM6CCCoswggU4MIIEIKADAgECAhB7
// SIG // BbHUSWhRRPfJidKcGZ0SMA0GCSqGSIb3DQEBCwUAMIG9
// SIG // MQswCQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24s
// SIG // IEluYy4xHzAdBgNVBAsTFlZlcmlTaWduIFRydXN0IE5l
// SIG // dHdvcmsxOjA4BgNVBAsTMShjKSAyMDA4IFZlcmlTaWdu
// SIG // LCBJbmMuIC0gRm9yIGF1dGhvcml6ZWQgdXNlIG9ubHkx
// SIG // ODA2BgNVBAMTL1ZlcmlTaWduIFVuaXZlcnNhbCBSb290
// SIG // IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTE2MDEx
// SIG // MjAwMDAwMFoXDTMxMDExMTIzNTk1OVowdzELMAkGA1UE
// SIG // BhMCVVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0
// SIG // aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3
// SIG // b3JrMSgwJgYDVQQDEx9TeW1hbnRlYyBTSEEyNTYgVGlt
// SIG // ZVN0YW1waW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOC
// SIG // AQ8AMIIBCgKCAQEAu1mdWVVPnYxyXRqBoutV87ABrTxx
// SIG // rDKPBWuGmicAMpdqTclkFEspu8LZKbku7GOz4c8/C1aQ
// SIG // +GIbfuumB+Lef15tQDjUkQbnQXx5HMvLrRu/2JWR8/Du
// SIG // bPitljkuf8EnuHg5xYSl7e2vh47Ojcdt6tKYtTofHjmd
// SIG // w/SaqPSE4cTRfHHGBim0P+SDDSbDewg+TfkKtzNJ/8o7
// SIG // 1PWym0vhiJka9cDpMxTW38eA25Hu/rySV3J39M2ozP4J
// SIG // 9ZM3vpWIasXc9LFL1M7oCZFftYR5NYp4rBkyjyPBMkEb
// SIG // WQ6pPrHM+dYr77fY5NUdbRE6kvaTyZzjSO67Uw7UNpeG
// SIG // eMWhNwIDAQABo4IBdzCCAXMwDgYDVR0PAQH/BAQDAgEG
// SIG // MBIGA1UdEwEB/wQIMAYBAf8CAQAwZgYDVR0gBF8wXTBb
// SIG // BgtghkgBhvhFAQcXAzBMMCMGCCsGAQUFBwIBFhdodHRw
// SIG // czovL2Quc3ltY2IuY29tL2NwczAlBggrBgEFBQcCAjAZ
// SIG // GhdodHRwczovL2Quc3ltY2IuY29tL3JwYTAuBggrBgEF
// SIG // BQcBAQQiMCAwHgYIKwYBBQUHMAGGEmh0dHA6Ly9zLnN5
// SIG // bWNkLmNvbTA2BgNVHR8ELzAtMCugKaAnhiVodHRwOi8v
// SIG // cy5zeW1jYi5jb20vdW5pdmVyc2FsLXJvb3QuY3JsMBMG
// SIG // A1UdJQQMMAoGCCsGAQUFBwMIMCgGA1UdEQQhMB+kHTAb
// SIG // MRkwFwYDVQQDExBUaW1lU3RhbXAtMjA0OC0zMB0GA1Ud
// SIG // DgQWBBSvY9bKo06FcuCnvEHzKaI4f4B1YjAfBgNVHSME
// SIG // GDAWgBS2d/ppSEefUxLVwuoHMnYH0ZcHGTANBgkqhkiG
// SIG // 9w0BAQsFAAOCAQEAdeqwLdU0GVwyRf4O4dRPpnjBb9fq
// SIG // 3dxP86HIgYj3p48V5kApreZd9KLZVmSEcTAq3R5hF2Yg
// SIG // VgaYGY1dcfL4l7wJ/RyRR8ni6I0D+8yQL9YKbE4z7Na0
// SIG // k8hMkGNIOUAhxN3WbomYPLWYl+ipBrcJyY9TV0GQL+Ee
// SIG // TU7cyhB4bEJu8LbF+GFcUvVO9muN90p6vvPN/QPX2fYD
// SIG // qA/jU/cKdezGdS6qZoUEmbf4Blfhxg726K/a7JsYH6q5
// SIG // 4zoAv86KlMsB257HOLsPUqvR45QDYApNoP4nbRQy/D+X
// SIG // QOG/mYnb5DkUvdrk08PqK1qzlVhVBH3HmuwjA42FKtL/
// SIG // rqlhgTCCBUswggQzoAMCAQICEHvU5a+6zAc/oQEjBCJB
// SIG // TRIwDQYJKoZIhvcNAQELBQAwdzELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMSgw
// SIG // JgYDVQQDEx9TeW1hbnRlYyBTSEEyNTYgVGltZVN0YW1w
// SIG // aW5nIENBMB4XDTE3MTIyMzAwMDAwMFoXDTI5MDMyMjIz
// SIG // NTk1OVowgYAxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRT
// SIG // eW1hbnRlYyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3lt
// SIG // YW50ZWMgVHJ1c3QgTmV0d29yazExMC8GA1UEAxMoU3lt
// SIG // YW50ZWMgU0hBMjU2IFRpbWVTdGFtcGluZyBTaWduZXIg
// SIG // LSBHMzCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoC
// SIG // ggEBAK8Oiqr43L9pe1QXcUcJvY08gfh0FXdnkJz93k4C
// SIG // nkt29uU2PmXVJCBtMPndHYPpPydKM05tForkjUCNIqq+
// SIG // pwsb0ge2PLUaJCj4G3JRPcgJiCYIOvn6QyN1R3AMs19b
// SIG // jwgdckhXZU2vAjxA9/TdMjiTP+UspvNZI8uA3hNN+RDJ
// SIG // qgoYbFVhV9HxAizEtavybCPSnw0PGWythWJp/U6FwYpS
// SIG // Matb2Ml0UuNXbCK/VX9vygarP0q3InZl7Ow28paVgSYs
// SIG // /buYqgE4068lQJsJU/ApV4VYXuqFSEEhh+XetNMmsntA
// SIG // U1h5jlIxBk2UA0XEzjwD7LcA8joixbRv5e+wipsCAwEA
// SIG // AaOCAccwggHDMAwGA1UdEwEB/wQCMAAwZgYDVR0gBF8w
// SIG // XTBbBgtghkgBhvhFAQcXAzBMMCMGCCsGAQUFBwIBFhdo
// SIG // dHRwczovL2Quc3ltY2IuY29tL2NwczAlBggrBgEFBQcC
// SIG // AjAZGhdodHRwczovL2Quc3ltY2IuY29tL3JwYTBABgNV
// SIG // HR8EOTA3MDWgM6Axhi9odHRwOi8vdHMtY3JsLndzLnN5
// SIG // bWFudGVjLmNvbS9zaGEyNTYtdHNzLWNhLmNybDAWBgNV
// SIG // HSUBAf8EDDAKBggrBgEFBQcDCDAOBgNVHQ8BAf8EBAMC
// SIG // B4AwdwYIKwYBBQUHAQEEazBpMCoGCCsGAQUFBzABhh5o
// SIG // dHRwOi8vdHMtb2NzcC53cy5zeW1hbnRlYy5jb20wOwYI
// SIG // KwYBBQUHMAKGL2h0dHA6Ly90cy1haWEud3Muc3ltYW50
// SIG // ZWMuY29tL3NoYTI1Ni10c3MtY2EuY2VyMCgGA1UdEQQh
// SIG // MB+kHTAbMRkwFwYDVQQDExBUaW1lU3RhbXAtMjA0OC02
// SIG // MB0GA1UdDgQWBBSlEwGpn4XMG24WHl87Map5NgB7HTAf
// SIG // BgNVHSMEGDAWgBSvY9bKo06FcuCnvEHzKaI4f4B1YjAN
// SIG // BgkqhkiG9w0BAQsFAAOCAQEARp6v8LiiX6KZSM+oJ0sh
// SIG // zbK5pnJwYy/jVSl7OUZO535lBliLvFeKkg0I2BC6NiT6
// SIG // Cnv7O9Niv0qUFeaC24pUbf8o/mfPcT/mMwnZolkQ9B5K
// SIG // /mXM3tRr41IpdQBKK6XMy5voqU33tBdZkkHDtz+G5vbA
// SIG // f0Q8RlwXWuOkO9VpJtUhfeGAZ35irLdOLhWa5Zwjr1sR
// SIG // 6nGpQfkNeTipoQ3PtLHaPpp6xyLFdM3fRwmGxPyRJbIb
// SIG // lumFCOjd6nRgbmClVnoNyERY3Ob5SBSe5b/eAL13sZgU
// SIG // chQk38cRLB8AP8NLFMZnHMweBqOQX1xUiz7jM1uCD8W3
// SIG // hgJOcZ/pZkU/djGCAlowggJWAgEBMIGLMHcxCzAJBgNV
// SIG // BAYTAlVTMR0wGwYDVQQKExRTeW1hbnRlYyBDb3Jwb3Jh
// SIG // dGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0
// SIG // d29yazEoMCYGA1UEAxMfU3ltYW50ZWMgU0hBMjU2IFRp
// SIG // bWVTdGFtcGluZyBDQQIQe9Tlr7rMBz+hASMEIkFNEjAL
// SIG // BglghkgBZQMEAgGggaQwGgYJKoZIhvcNAQkDMQ0GCyqG
// SIG // SIb3DQEJEAEEMBwGCSqGSIb3DQEJBTEPFw0yMDAzMjMx
// SIG // NDAzMjlaMC8GCSqGSIb3DQEJBDEiBCASUg9fKg8NeitF
// SIG // 380y7hWVeoZU3mDnB3oH5/BrgLvrtzA3BgsqhkiG9w0B
// SIG // CRACLzEoMCYwJDAiBCDEdM52AH0COU4NpeTefBTGgPni
// SIG // ggE8/vZT7123H99h+DALBgkqhkiG9w0BAQEEggEAXTYK
// SIG // 73hax4Si1rekl+0G+c5D32HJyrdLvqe0eW6cGkErUpNk
// SIG // FOXz03Hu0Z7NV+TkZoNCi4Bgct+uMSf9flRlcok2iS7H
// SIG // e5weiANqoLPdei7P24Z53F8TkbNA67chWw9U8rPgIX3Q
// SIG // hdtWqmMe5KWxKSu7m80dpMqh3UDhsylkrTZXdkuc5Yg6
// SIG // QNvZ8DlgFTsaoiepXnGsOlk9I1au9i3kfv7AujQJyIdC
// SIG // CHyE2tTQRnNi6ABJ2zYReZn8wpsjMWdzvMtxr7RgSU6d
// SIG // hnZAQzQOwduLkE7OFJfxEx4nHxExVX61kU9YiDq7O3gl
// SIG // QwOVfZn0eS4RoPVV6tEIOtfamTZAqQ==
// SIG // End signature block
