var topic = "<!DOCTYPE html>\r\n\n<!-- saved from url=(0024)http://docs.autodesk.com -->\r\n<html>\n   <head>\n      <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n      <meta name=\"product\" content=\"VAULT\">\n      <meta name=\"release\" content=\"2021\">\n      <meta name=\"book\" content=\"GeneralUser\">\n      <meta name=\"created\" content=\"2020-03-20\">\n      <meta name=\"topicid\" content=\"GUID-E853B96F-4B6C-425A-BA32-DE858E1AA6DF\">\n      <meta name=\"description\" content=\"Configure creation dialogs and tabs to display custom object data.\">\n      <meta name=\"topic-type\" content=\"concept\">\n      <meta name=\"audience\" content=\"administrator\">\n      <meta name=\"experiencelevel\" content=\"general\">\n      <title>Data Standard Custom Objects Administration</title><script language=\"javascript\">var index = \'index.html\';</script><script type=\"text/javascript\" src=\"../scripts/prettify/prettify.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-yaml.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-xq.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-wiki.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-vhdl.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-vb.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-tex.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-sql.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-scala.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-proto.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-n.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-ml.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-lua.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-lisp.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-hs.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-go.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-css.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-clj.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-apollo.js\"></script></head>\n   <body height=\"100%\" onLoad=\"javascript:prettyPrint();\">\n      <div class=\"body_content\" id=\"body-content\" dir=\"ltr\"><a name=\"GUID-E853B96F-4B6C-425A-BA32-DE858E1AA6DF\"></a><div class=\"head\">\n            <h1>Data Standard Custom Objects Administration</h1>\n         </div>\n         <p class=\"blurb\">Configure creation dialogs and tabs to display custom object data. \n            \n         </p><a name=\"UL_94767EF7A0694E54B17AEF270CE859DB\"></a><p class=\"list-intro\">Requirements</p>\n         <p>Three components are required for custom object support: \n            	 \n         </p>\n         <ul>\n            <li>Menu entries for the create and edit dialog. \n               \n            </li>\n            <li>Dialog files (.xaml) for the dialogs and tabs. \n               \n            </li>\n            <li>Scripting files (PowerShell) for the dialog logic. \n               \n            </li>\n         </ul>\n         <div class=\"section\"><a name=\"SECTION_4CC033357C3D4026AA6108F2180ACF1E\"></a> \n            <h2><a name=\"GUID-C3B20B54-65CB-4204-9128-4DEF09A2A01E\"></a>Use Pre-Configured Custom Object \"Task\"\n            </h2> \n            <p> By default, all three components are provided with Data Standard. These components\n               are pre-configured to work with a custom object in Vault called Task. \n               	 \n            </p> \n            <div><a name=\"GUID-76714CAF-FFB0-40AE-912D-6A6562A05B4C\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span> Context menu support for custom objects is only available if a custom object exists.\n                  \n                  	 \n               </div>\n            </div> <a name=\"OL_CD453B3C167F46C0B1DE767520B1F08B\"></a><ol type=\"1\" start=\"1\">\n               <li>Through the Vault configuration, create a custom object definition and call it Task.\n                  \n                  		  \n                  <div><a name=\"GUID-B49400F5-117A-43F7-B8B0-C93EFE0C72B9\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span>See \n                        			 <span class=\"char_link\"><a href=\"GUID-E1BA9E4A-443F-43EA-B8BF-3CAA382C25A3.htm\">Custom Objects Administration</a></span> for more information. \n                        		  \n                     </div>\n                  </div> \n               </li>\n               <li>Assign the Title and Description properties to the Base category. \n                  		\n               </li>\n               <li>Restart Vault Explorer and log into Vault two times: \n                  		  <a name=\"UL_4CD7FC0606FC4401BF669641C0A43980\"></a><ul>\n                     <li>The first time you log in, check that the Tasks object type is available in the Vault\n                        Client. \n                        			 \n                     </li>\n                     <li>Log out and log in a second time to initialize the Datasheet tab and the menu items\n                        to create and edit Tasks. \n                        			 \n                     </li>\n                  </ul>\n                  <p>The new custom object Task is fully initialized and ready to use. \n                     		  \n                  </p> \n               </li>\n               <li>Create a new custom object using the New command and name it anything you want. \n                  		\n               </li>\n               <li>Right-click on the new custom object. The context menu now shows New Task and Edit\n                  Task as menu options. \n                  		\n               </li>\n            </ol> \n            <div><a name=\"GUID-7C1F15FF-3C09-451E-8623-2B4A58A07BD6\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span> When logging-in the first time after a new custom object has been defined, the file\n                  \n                  		<span class=\"filePath\">CustomEntityDefinitions.json</span> (<span class=\"filePath\">%programdata%\\Autodesk\\&lt;Vault edition&gt;\\Extensions\\DataStandard\\Vault)</span> is created. The definition in the file is used to initialize the tab and the menu\n                  items for the custom objects. The file should not be modified manually. To avoid users\n                  having to login several times, the file can be deployed. If you cannot initialize\n                  custom objects, the file can be deleted. It is created the next time you log into\n                  a vault. \n                  	 \n               </div>\n            </div> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_6385D396D85D4E3DB23D0E8E6E0DA1D3\"></a> \n            <h2><a name=\"GUID-5D11DD6E-B74E-476E-9A21-5DA2B916CAC0\"></a>Configure Additional Custom Objects\n            </h2> \n            <p>To define your own custom object, copy the three components from the Task sample and\n               modify as needed. \n               	 \n            </p> \n            <p>Following are examples of a custom object called Person. \n               	 \n            </p> <a name=\"OL_BDA99C8BB8784BBE94015C5FCB719855\"></a><p class=\"list-intro\">Menu Entries</p>\n            <p>The context menu entries to create and edit a dialog are defined here: \n               	 \n            </p>\n            <p><span class=\"filePath\"> %programdata%\\Autodesk\\&lt;Vault version&gt;\\Extensions\\DataStandard\\Vault\\MenuDefinitions.xml</span> \n            </p>\n            <p>The menu entry definitions must be created: \n               	 \n            </p>\n            <ol type=\"1\" start=\"1\">\n               <li>Copy the definitions (<em class=\"mild\">MenuItem NewTask, MenuItem EditTask</em>) from the Task sample. \n                  	 \n               </li>\n               <li>Replace Task with Person in all variables. \n                  	 \n               </li>\n               <li>Modify Description, Hint, Label and Navigation Types. \n                  		\n                  <div><a name=\"GUID-8FA2E6E9-D12A-446B-A1C4-7CB34BF41E1A\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span>For these variables, the UIString syntax in the original sample can be used. See \n                        		  <span class=\"char_link\"><a href=\"GUID-244DFF1D-7473-41D8-AA7D-43A3FB25D17F.htm\">Localization</a></span> for more information. \n                        		\n                     </div>\n                  </div> \n               </li>\n            </ol>\n            <p> \n               <div class=\"codeBlock\"><pre class=\"prettyprint\">\n	&lt;NewTask Label=\"CreatePerson...\" \n			 Description=\"New Person\"\n    Hint=\"Create a new person object\" \n    PSFile=\"CreateCustomObject.ps1\"\n    Image=\"NewCustomObject.ico\"\n    ToolbarPaintStyle=\"TextAndGlyph\"\n    NavigationTypes=\"Person\"\n    MultiSelectEnabled=\"false\"/&gt;\n\n   &lt;EditTaskLabel=\"Edit Person...\" \n    Description=\"Edit Person\"\n    Hint=\"Edit a person object\"\n    PSFile=\"EditCustomObject.ps1\"\n    Image=\"EditCustomObject.ico\"\n    ToolbarPaintStyle=\"TextandGlyph\"\n    NavigationTypes=\"Task\"\n    MultiSelectEnabled=\"False\"/&gt;\n  </pre></div> \n            </p>\n            <p> <a name=\"OL_F90B1EF8A1BC4755B7ED6A1AD123441D\"></a><p>Next, create a menu site for the new custom object. \n                  	 \n               </p>\n               <ol type=\"1\" start=\"1\">\n                  <li>Copy the site (<em class=\"mild\">CommandSite Task</em>) from the Task sample. \n                     	 \n                  </li>\n                  <li>Replace Task with Person in all variables. \n                     	 \n                  </li>\n               </ol>\n               <p> \n                  <div class=\"codeBlock\"><pre class=\"prettyprint\">&lt;TaskLabel=\"Person\"\n         DeployAsPullDown=\"False\"\n         Location=\"Person\"&gt;\n         &lt;ItemName=\"NewPerson\"&gt;\n									&lt;/Item&gt;\n         &lt;ItemName=\"EditPerson\"&gt;\n          &lt;/Item&gt;</pre></div> \n               </p>\n               <p>See \n                  		<span class=\"char_link\"><a href=\"GUID-02BAAA7C-330F-4B21-8D9D-8D4BB27AC428.htm\">Customize the Data Standard MenuDefiniftions.xml File</a></span> for more details about the menu syntax. \n                  	 \n               </p> \n            </p> <a name=\"OL_76578CC1A2B34004AE4D1D4A52D20B34\"></a><p class=\"list-intro\">Scripting Files</p>\n            <p><a name=\"LI_10A13DCF2F9446B986037C6AADAD4B88\"></a> The menu definitions in the \n               		<span class=\"filePath\">MenuDefinitions.xml</span> file point to PowerShell files. These files are located at \n               		<span class=\"filePath\">%programdata%\\Autodesk\\&lt;Vault version&gt;\\Extensions\\DataStandard\\Vault\\addinVault\\Menus</span>. \n               	 \n            </p>\n            <p>The default CreateCustomObject.ps1 and EditCustomObject.ps1 PowerShell file work for\n               every custom object. There is no need to create additional PowerShell files. However,\n               it is still possible to customize and create PowerShell files for the new custom object\n               by performing these tasks:\n               	 \n            </p>\n            <ol type=\"1\" start=\"1\">\n               <li>Copy the \n                  		<em class=\"mild\">CreateCustomObject.ps1</em> and \n                  		<em class=\"mild\">EditCustomObject.ps1</em> menu definition files and rename them as \n                  		<em class=\"mild\">CreatePerson.ps1</em> and \n                  		<em class=\"mild\">EditPerson.ps1</em>. \n                  	 \n               </li>\n               <li>Similar to other scripts, the create and edit custom object scripts point to a related\n                  XAML file. \n                  		\n                  <p> Modify the XAML filename that defines the Data Standard dialog by replacing Task\n                     with Person. \n                     		\n                  </p> \n                  <p> \n                     <div class=\"codeBlock\"><pre class=\"prettyprint\">...\n$xamlFile = New-Object CreateObject.WPF.XamlFile \"PersonXaml\", \"%ProgramData%\\Autodesk\\Vault 2016\\Extensions\\DataStandard\\Vault\\Configuration\\Person.xaml\"\n$dialog.XamlFile = $xamlFile\n...</pre></div> \n                  </p> \n               </li>\n            </ol> <a name=\"OL_01AA137AD9F340E88B3B1E13BA86F7B0\"></a><p class=\"list-intro\">Dialogs and Tab</p>\n            <p> The XAML file for the custom object create and edit dialog is specified in the PowerShell\n               files (see above). By default, the XAML files for the create and edit dialogs as well\n               as the tabs are located here: \n               	 \n            </p>\n            <p><span class=\"filePath\"> %programdata%\\Autodesk\\&lt;Vault version&gt;\\Extensions\\DataStandard\\Vault\\Configuration</span> \n            </p>\n            <p>The default CustomObject.xaml works without any changes. However, you must use the\n               CustomObject.xaml file as a template to create a XAML file for the new custom object.\n               	 \n            </p>\n            <ol type=\"1\" start=\"1\">\n               <li>Copy \n                  		<span class=\"filePath\">CustomObject.xaml</span> file and name it \n                  		<span class=\"filePath\">Person.xaml</span>. \n                  	 \n               </li>\n               <li>Modify the new XAML file with these steps: \n                  		<a name=\"UL_053833CF4F954D82867AA1B18CB28EA2\"></a><ul>\n                     <li>Replace all occurrences of \n                        			 <span class=\"code\">TaskWindow</span> with \n                        			 <span class=\"code\">PersonWindow</span>. \n                        		  \n                     </li>\n                     <li>Correct the dialog title by adding \n                        			 <em class=\"mild\">New Person</em> and \n                        			 <em class=\"mild\">Edit Person Datasheet</em> to the \n                        			 <span class=\"filePath\">UiStrings.xml</span> and replacing the IDs with the IDs for the new text strings \n                        			 <span class=\"code\">UIString[LBL61]</span> and \n                        			 <span class=\"code\">UIString[LBL62]</span>. \n                        		  \n                     </li>\n                     <li>Add or remove property controls as needed. \n                        		  \n                     </li>\n                  </ul> \n               </li>\n               <li>Change the following functions in \n                  		<span class=\"filePath\">%programdata%\\Autodesk\\&lt;Vault version&gt;\\Extensions\\DataStandard\\Vault\\addinVault\\Default.ps1</span> by configuring: \n                  		<a name=\"UL_39BB908A36F84F079B9B3076DF08D9E2\"></a><ul>\n                     <li><span class=\"code\">InitializeWindow</span> to control the size of the dialog. \n                        		  \n                     </li>\n                     <li><span class=\"code\">GetCategories</span> to support dynamic properties based on categories. \n                        		  \n                     </li>\n                     <li><span class=\"code\">Validate</span> to implement validation rules. \n                        		  \n                     </li>\n                  </ul> \n               </li>\n            </ol> <a name=\"OL_2CC665380DA34071BDEEAFB143C4AE4F\"></a><p class=\"list-intro\">Get a Datasheet tab for the new custom object</p>\n            <ol type=\"1\" start=\"1\">\n               <li>Copy the Task folder and name it Person. \n                  		\n               </li>\n               <li>If needed, update the \n                  		  <span class=\"filePath\">Datasheet.xaml</span> in the Person folder (e.g., add or remove properties). \n                  		\n               </li>\n            </ol> \n         </div>\n         <div class=\"footer-block\"><a href=\"..\" class=\"comments-anchor\" target=\"_blank\"><span class=\"comments-link\">Please send us your comment about this page</span></a></div><br><p class=\"footer-license-block\"><a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\"><img alt=\"Creative Commons License\" style=\"border-width: 0;\" src=\"../images/ccLink.png\"></a>&nbsp;<em>Except where otherwise noted, this work is licensed under a <a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\">Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License</a>. Please see the <a href=\"http://autodesk.com/creativecommons\" target=\"_blank\">Autodesk Creative Commons FAQ</a> for more information.</em></p><br></div>\n   </body>\n</html>";
// SIG // Begin signature block
// SIG // MIIbRQYJKoZIhvcNAQcCoIIbNjCCGzICAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // t9Hkry+tV5CzVCLtnouH5eXkjOhS73CcWGA+DGkVxNyg
// SIG // ggoaMIIEyzCCA7OgAwIBAgIQCQja65wGHi65un4mqmKH
// SIG // ijANBgkqhkiG9w0BAQsFADCBhDELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTUw
// SIG // MwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
// SIG // b2RlIFNpZ25pbmcgQ0EgLSBHMjAeFw0xOTA1MTQwMDAw
// SIG // MDBaFw0yMDA1MTMyMzU5NTlaMHwxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIDApDYWxpZm9ybmlhMRMwEQYDVQQHDApT
// SIG // YW4gUmFmYWVsMRcwFQYDVQQKDA5BdXRvZGVzaywgSW5j
// SIG // LjERMA8GA1UECwwIU2VjdXJpdHkxFzAVBgNVBAMMDkF1
// SIG // dG9kZXNrLCBJbmMuMIIBIjANBgkqhkiG9w0BAQEFAAOC
// SIG // AQ8AMIIBCgKCAQEAkVKRoPYsoxPdlabspcuG8HYDfcWQ
// SIG // 9qyPOT2punwpVdjt2slktcpSTlydrGy8ijcbl5/k8AOJ
// SIG // afKMQvow0fNjIoNB5nsb8j2xFJPbBhHl8GT4P6DZ1OWK
// SIG // ioiUXgGHKjctUws49J4elntqvBYhKCbuPqG772QCoYFU
// SIG // P7qcFbh3PbyNB6cnKMn2vNGRqiEtV2aGg+/MiL3QPsvT
// SIG // kTWhVuTLIvwZ4kK5C5ACiQzlGOlE+C7gWuFoxtvy6gUa
// SIG // A8JAq/xLjYKwFevQwGncg3s1cuiGhx0P7Rvn6oCd2cem
// SIG // FmbK3I3rMRt+jc9wzAj3oHxvCo4f5Lfva+OpC1dETUVV
// SIG // sk0VGwIDAQABo4IBPjCCATowCQYDVR0TBAIwADAOBgNV
// SIG // HQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMw
// SIG // YQYDVR0gBFowWDBWBgZngQwBBAEwTDAjBggrBgEFBQcC
// SIG // ARYXaHR0cHM6Ly9kLnN5bWNiLmNvbS9jcHMwJQYIKwYB
// SIG // BQUHAgIwGQwXaHR0cHM6Ly9kLnN5bWNiLmNvbS9ycGEw
// SIG // HwYDVR0jBBgwFoAU1MAGIknrOUvdk+JcobhHdglyA1gw
// SIG // KwYDVR0fBCQwIjAgoB6gHIYaaHR0cDovL3JiLnN5bWNi
// SIG // LmNvbS9yYi5jcmwwVwYIKwYBBQUHAQEESzBJMB8GCCsG
// SIG // AQUFBzABhhNodHRwOi8vcmIuc3ltY2QuY29tMCYGCCsG
// SIG // AQUFBzAChhpodHRwOi8vcmIuc3ltY2IuY29tL3JiLmNy
// SIG // dDANBgkqhkiG9w0BAQsFAAOCAQEA0Q2+iVSEfT4xGq3A
// SIG // OADVb0rT5Z8E+PPb1x6hKknSzuaZKk/acDz9mdnFajaU
// SIG // WgIKiFJlsqJnuAM1w4lqKaEWsz3DoxvGIEwexj71Ud6a
// SIG // KlBJNcR9DdkXUZwMhbw9d78rjJAIX6tOwfSludZfdq8b
// SIG // YEkuIzQi9uYW9vHVPSCzhnUBKjwc9qTo9yBc7Fcn4FAT
// SIG // 90DzWM2hS9oc3p0pprYI2I/O4th90BEmwWkVqVgfaR0z
// SIG // VyIEmBbqB/IWLfjUBZJ/8sbkwWuWlYVRrfPxsj1e9qvb
// SIG // wE3Y28jWyGbqoUG39GhXk3uT8R8i3+T6M0c4rMfdifBC
// SIG // pceCaFTJzSye7LoeVzCCBUcwggQvoAMCAQICEHwbNTVK
// SIG // 59t050FfEWnKa6gwDQYJKoZIhvcNAQELBQAwgb0xCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjEfMB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29y
// SIG // azE6MDgGA1UECxMxKGMpIDIwMDggVmVyaVNpZ24sIElu
// SIG // Yy4gLSBGb3IgYXV0aG9yaXplZCB1c2Ugb25seTE4MDYG
// SIG // A1UEAxMvVmVyaVNpZ24gVW5pdmVyc2FsIFJvb3QgQ2Vy
// SIG // dGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMTQwNzIyMDAw
// SIG // MDAwWhcNMjQwNzIxMjM1OTU5WjCBhDELMAkGA1UEBhMC
// SIG // VVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9u
// SIG // MR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3Jr
// SIG // MTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1
// SIG // NiBDb2RlIFNpZ25pbmcgQ0EgLSBHMjCCASIwDQYJKoZI
// SIG // hvcNAQEBBQADggEPADCCAQoCggEBANeVQ9Tc32euOftS
// SIG // pLYmMQRw6beOWyq6N2k1lY+7wDDnhthzu9/r0XY/ilaO
// SIG // 6y1L8FcYTrGNpTPTC3Uj1Wp5J92j0/cOh2W13q0c8fU1
// SIG // tCJRryKhwV1LkH/AWU6rnXmpAtceSbE7TYf+wnirv+9S
// SIG // rpyvCNk55ZpRPmlfMBBOcWNsWOHwIDMbD3S+W8sS4duM
// SIG // xICUcrv2RZqewSUL+6McntimCXBx7MBHTI99w94Zzj7u
// SIG // BHKOF9P/8LIFMhlM07Acn/6leCBCcEGwJoxvAMg6ABFB
// SIG // ekGwp4qRBKCZePR3tPNgKuZsUAS3FGD/DVH0qIuE/iHa
// SIG // XF599Sl5T7BEdG9tcv8CAwEAAaOCAXgwggF0MC4GCCsG
// SIG // AQUFBwEBBCIwIDAeBggrBgEFBQcwAYYSaHR0cDovL3Mu
// SIG // c3ltY2QuY29tMBIGA1UdEwEB/wQIMAYBAf8CAQAwZgYD
// SIG // VR0gBF8wXTBbBgtghkgBhvhFAQcXAzBMMCMGCCsGAQUF
// SIG // BwIBFhdodHRwczovL2Quc3ltY2IuY29tL2NwczAlBggr
// SIG // BgEFBQcCAjAZGhdodHRwczovL2Quc3ltY2IuY29tL3Jw
// SIG // YTA2BgNVHR8ELzAtMCugKaAnhiVodHRwOi8vcy5zeW1j
// SIG // Yi5jb20vdW5pdmVyc2FsLXJvb3QuY3JsMBMGA1UdJQQM
// SIG // MAoGCCsGAQUFBwMDMA4GA1UdDwEB/wQEAwIBBjApBgNV
// SIG // HREEIjAgpB4wHDEaMBgGA1UEAxMRU3ltYW50ZWNQS0kt
// SIG // MS03MjQwHQYDVR0OBBYEFNTABiJJ6zlL3ZPiXKG4R3YJ
// SIG // cgNYMB8GA1UdIwQYMBaAFLZ3+mlIR59TEtXC6gcydgfR
// SIG // lwcZMA0GCSqGSIb3DQEBCwUAA4IBAQB/68qn6ot2Qus+
// SIG // jiBUMOO3udz6SD4Wxw9FlRDNJ4ajZvMC7XH4qsJVl5Fw
// SIG // g/lSflJpPMnx4JRGgBi7odSkVqbzHQCR1YbzSIfgy8Q0
// SIG // aCBetMv5Be2cr3BTJ7noPn5RoGlxi9xR7YA6JTKfRK9u
// SIG // QyjTIXW7l9iLi4z+qQRGBIX3FZxLEY3ELBf+1W5/muJW
// SIG // kvGWs60t+fTf2omZzrI4RMD3R3vKJbn6Kmgzm1By3qif
// SIG // 1M0sCzS9izB4QOCNjicbkG8avggVgV3rL+JR51EeyXgp
// SIG // 5x5lvzjvAUoBCSQOFsQUecFBNzTQPZFSlJ3haO8I8OJp
// SIG // nGdukAsak3HUJgLDwFojMYIQgzCCEH8CAQEwgZkwgYQx
// SIG // CzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRlYyBD
// SIG // b3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1
// SIG // c3QgTmV0d29yazE1MDMGA1UEAxMsU3ltYW50ZWMgQ2xh
// SIG // c3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENBIC0gRzIC
// SIG // EAkI2uucBh4uubp+Jqpih4owDQYJYIZIAWUDBAIBBQCg
// SIG // fDAQBgorBgEEAYI3AgEMMQIwADAZBgkqhkiG9w0BCQMx
// SIG // DAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4wDAYK
// SIG // KwYBBAGCNwIBFTAvBgkqhkiG9w0BCQQxIgQgUhHTU10+
// SIG // qmroprKfIXBWxbX3pDy2sQxEJqQlQn5KEx4wDQYJKoZI
// SIG // hvcNAQEBBQAEggEABoutVf2LJk4+ZG24VaxdLd6OfG6f
// SIG // cMWcf1M73FmB3a80s5NN+KAd0lk7SOWLZegX+4MAyV5o
// SIG // 45T4Oxzy41NKoHaRxcKDEG8d5iaJGvDfvg3PdATdFBdj
// SIG // h6X2Qy7GZFhRGmtXQM9+/EVxOqlxDb8iNATRlhyiJMKj
// SIG // 3Py/AH/eYp3XjDiv7QqzZFE2ZEyUu4WPGfA29qvtD26E
// SIG // 8EI3N34aWu+Bw8oBJMEx5dDSklSgyZzOllMZQSowWVaW
// SIG // uHHUTHaGmlEXm0jBMbgy/uCK/r7muhIyevwEmcZ9IK2K
// SIG // yi7Gekydx3aWKnDneOrqynpuSMofbxilO4GCWa5UvDhy
// SIG // ARWEeKGCDjwwgg44BgorBgEEAYI3AwMBMYIOKDCCDiQG
// SIG // CSqGSIb3DQEHAqCCDhUwgg4RAgEDMQ0wCwYJYIZIAWUD
// SIG // BAIBMIIBDgYLKoZIhvcNAQkQAQSggf4EgfswgfgCAQEG
// SIG // C2CGSAGG+EUBBxcDMDEwDQYJYIZIAWUDBAIBBQAEIKfz
// SIG // 3nP2PJr6T8bnvt4K/fpOBp4S6OjxuRInOtfbUFY8AhQv
// SIG // hZGStYHkkVY/3UYM3S8arPL1/xgPMjAyMDAzMjMxNDA1
// SIG // MzBaMAMCAR6ggYakgYMwgYAxCzAJBgNVBAYTAlVTMR0w
// SIG // GwYDVQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlvbjEfMB0G
// SIG // A1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazExMC8G
// SIG // A1UEAxMoU3ltYW50ZWMgU0hBMjU2IFRpbWVTdGFtcGlu
// SIG // ZyBTaWduZXIgLSBHM6CCCoswggU4MIIEIKADAgECAhB7
// SIG // BbHUSWhRRPfJidKcGZ0SMA0GCSqGSIb3DQEBCwUAMIG9
// SIG // MQswCQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24s
// SIG // IEluYy4xHzAdBgNVBAsTFlZlcmlTaWduIFRydXN0IE5l
// SIG // dHdvcmsxOjA4BgNVBAsTMShjKSAyMDA4IFZlcmlTaWdu
// SIG // LCBJbmMuIC0gRm9yIGF1dGhvcml6ZWQgdXNlIG9ubHkx
// SIG // ODA2BgNVBAMTL1ZlcmlTaWduIFVuaXZlcnNhbCBSb290
// SIG // IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTE2MDEx
// SIG // MjAwMDAwMFoXDTMxMDExMTIzNTk1OVowdzELMAkGA1UE
// SIG // BhMCVVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0
// SIG // aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3
// SIG // b3JrMSgwJgYDVQQDEx9TeW1hbnRlYyBTSEEyNTYgVGlt
// SIG // ZVN0YW1waW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOC
// SIG // AQ8AMIIBCgKCAQEAu1mdWVVPnYxyXRqBoutV87ABrTxx
// SIG // rDKPBWuGmicAMpdqTclkFEspu8LZKbku7GOz4c8/C1aQ
// SIG // +GIbfuumB+Lef15tQDjUkQbnQXx5HMvLrRu/2JWR8/Du
// SIG // bPitljkuf8EnuHg5xYSl7e2vh47Ojcdt6tKYtTofHjmd
// SIG // w/SaqPSE4cTRfHHGBim0P+SDDSbDewg+TfkKtzNJ/8o7
// SIG // 1PWym0vhiJka9cDpMxTW38eA25Hu/rySV3J39M2ozP4J
// SIG // 9ZM3vpWIasXc9LFL1M7oCZFftYR5NYp4rBkyjyPBMkEb
// SIG // WQ6pPrHM+dYr77fY5NUdbRE6kvaTyZzjSO67Uw7UNpeG
// SIG // eMWhNwIDAQABo4IBdzCCAXMwDgYDVR0PAQH/BAQDAgEG
// SIG // MBIGA1UdEwEB/wQIMAYBAf8CAQAwZgYDVR0gBF8wXTBb
// SIG // BgtghkgBhvhFAQcXAzBMMCMGCCsGAQUFBwIBFhdodHRw
// SIG // czovL2Quc3ltY2IuY29tL2NwczAlBggrBgEFBQcCAjAZ
// SIG // GhdodHRwczovL2Quc3ltY2IuY29tL3JwYTAuBggrBgEF
// SIG // BQcBAQQiMCAwHgYIKwYBBQUHMAGGEmh0dHA6Ly9zLnN5
// SIG // bWNkLmNvbTA2BgNVHR8ELzAtMCugKaAnhiVodHRwOi8v
// SIG // cy5zeW1jYi5jb20vdW5pdmVyc2FsLXJvb3QuY3JsMBMG
// SIG // A1UdJQQMMAoGCCsGAQUFBwMIMCgGA1UdEQQhMB+kHTAb
// SIG // MRkwFwYDVQQDExBUaW1lU3RhbXAtMjA0OC0zMB0GA1Ud
// SIG // DgQWBBSvY9bKo06FcuCnvEHzKaI4f4B1YjAfBgNVHSME
// SIG // GDAWgBS2d/ppSEefUxLVwuoHMnYH0ZcHGTANBgkqhkiG
// SIG // 9w0BAQsFAAOCAQEAdeqwLdU0GVwyRf4O4dRPpnjBb9fq
// SIG // 3dxP86HIgYj3p48V5kApreZd9KLZVmSEcTAq3R5hF2Yg
// SIG // VgaYGY1dcfL4l7wJ/RyRR8ni6I0D+8yQL9YKbE4z7Na0
// SIG // k8hMkGNIOUAhxN3WbomYPLWYl+ipBrcJyY9TV0GQL+Ee
// SIG // TU7cyhB4bEJu8LbF+GFcUvVO9muN90p6vvPN/QPX2fYD
// SIG // qA/jU/cKdezGdS6qZoUEmbf4Blfhxg726K/a7JsYH6q5
// SIG // 4zoAv86KlMsB257HOLsPUqvR45QDYApNoP4nbRQy/D+X
// SIG // QOG/mYnb5DkUvdrk08PqK1qzlVhVBH3HmuwjA42FKtL/
// SIG // rqlhgTCCBUswggQzoAMCAQICEHvU5a+6zAc/oQEjBCJB
// SIG // TRIwDQYJKoZIhvcNAQELBQAwdzELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMSgw
// SIG // JgYDVQQDEx9TeW1hbnRlYyBTSEEyNTYgVGltZVN0YW1w
// SIG // aW5nIENBMB4XDTE3MTIyMzAwMDAwMFoXDTI5MDMyMjIz
// SIG // NTk1OVowgYAxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRT
// SIG // eW1hbnRlYyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3lt
// SIG // YW50ZWMgVHJ1c3QgTmV0d29yazExMC8GA1UEAxMoU3lt
// SIG // YW50ZWMgU0hBMjU2IFRpbWVTdGFtcGluZyBTaWduZXIg
// SIG // LSBHMzCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoC
// SIG // ggEBAK8Oiqr43L9pe1QXcUcJvY08gfh0FXdnkJz93k4C
// SIG // nkt29uU2PmXVJCBtMPndHYPpPydKM05tForkjUCNIqq+
// SIG // pwsb0ge2PLUaJCj4G3JRPcgJiCYIOvn6QyN1R3AMs19b
// SIG // jwgdckhXZU2vAjxA9/TdMjiTP+UspvNZI8uA3hNN+RDJ
// SIG // qgoYbFVhV9HxAizEtavybCPSnw0PGWythWJp/U6FwYpS
// SIG // Matb2Ml0UuNXbCK/VX9vygarP0q3InZl7Ow28paVgSYs
// SIG // /buYqgE4068lQJsJU/ApV4VYXuqFSEEhh+XetNMmsntA
// SIG // U1h5jlIxBk2UA0XEzjwD7LcA8joixbRv5e+wipsCAwEA
// SIG // AaOCAccwggHDMAwGA1UdEwEB/wQCMAAwZgYDVR0gBF8w
// SIG // XTBbBgtghkgBhvhFAQcXAzBMMCMGCCsGAQUFBwIBFhdo
// SIG // dHRwczovL2Quc3ltY2IuY29tL2NwczAlBggrBgEFBQcC
// SIG // AjAZGhdodHRwczovL2Quc3ltY2IuY29tL3JwYTBABgNV
// SIG // HR8EOTA3MDWgM6Axhi9odHRwOi8vdHMtY3JsLndzLnN5
// SIG // bWFudGVjLmNvbS9zaGEyNTYtdHNzLWNhLmNybDAWBgNV
// SIG // HSUBAf8EDDAKBggrBgEFBQcDCDAOBgNVHQ8BAf8EBAMC
// SIG // B4AwdwYIKwYBBQUHAQEEazBpMCoGCCsGAQUFBzABhh5o
// SIG // dHRwOi8vdHMtb2NzcC53cy5zeW1hbnRlYy5jb20wOwYI
// SIG // KwYBBQUHMAKGL2h0dHA6Ly90cy1haWEud3Muc3ltYW50
// SIG // ZWMuY29tL3NoYTI1Ni10c3MtY2EuY2VyMCgGA1UdEQQh
// SIG // MB+kHTAbMRkwFwYDVQQDExBUaW1lU3RhbXAtMjA0OC02
// SIG // MB0GA1UdDgQWBBSlEwGpn4XMG24WHl87Map5NgB7HTAf
// SIG // BgNVHSMEGDAWgBSvY9bKo06FcuCnvEHzKaI4f4B1YjAN
// SIG // BgkqhkiG9w0BAQsFAAOCAQEARp6v8LiiX6KZSM+oJ0sh
// SIG // zbK5pnJwYy/jVSl7OUZO535lBliLvFeKkg0I2BC6NiT6
// SIG // Cnv7O9Niv0qUFeaC24pUbf8o/mfPcT/mMwnZolkQ9B5K
// SIG // /mXM3tRr41IpdQBKK6XMy5voqU33tBdZkkHDtz+G5vbA
// SIG // f0Q8RlwXWuOkO9VpJtUhfeGAZ35irLdOLhWa5Zwjr1sR
// SIG // 6nGpQfkNeTipoQ3PtLHaPpp6xyLFdM3fRwmGxPyRJbIb
// SIG // lumFCOjd6nRgbmClVnoNyERY3Ob5SBSe5b/eAL13sZgU
// SIG // chQk38cRLB8AP8NLFMZnHMweBqOQX1xUiz7jM1uCD8W3
// SIG // hgJOcZ/pZkU/djGCAlowggJWAgEBMIGLMHcxCzAJBgNV
// SIG // BAYTAlVTMR0wGwYDVQQKExRTeW1hbnRlYyBDb3Jwb3Jh
// SIG // dGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0
// SIG // d29yazEoMCYGA1UEAxMfU3ltYW50ZWMgU0hBMjU2IFRp
// SIG // bWVTdGFtcGluZyBDQQIQe9Tlr7rMBz+hASMEIkFNEjAL
// SIG // BglghkgBZQMEAgGggaQwGgYJKoZIhvcNAQkDMQ0GCyqG
// SIG // SIb3DQEJEAEEMBwGCSqGSIb3DQEJBTEPFw0yMDAzMjMx
// SIG // NDA1MzBaMC8GCSqGSIb3DQEJBDEiBCAhfhWdBreSGI92
// SIG // VS0JT0/7hR4eg3Mt1CFbYG/Ht1JmoTA3BgsqhkiG9w0B
// SIG // CRACLzEoMCYwJDAiBCDEdM52AH0COU4NpeTefBTGgPni
// SIG // ggE8/vZT7123H99h+DALBgkqhkiG9w0BAQEEggEAFoGC
// SIG // PBQzk14YcWM4JhWY6IuakaKJVBceYsRDhboNkGtQ7Mo4
// SIG // nd4I+kfJ/gJH5T2Xgrn0SzYm8A5P2TQlCN+o6NuShg7p
// SIG // /Ux1pvLeTDYKtbK44B5XLGx0km/NZ7hrQFkB3bnhkAnU
// SIG // A2kCnw+Rh1Q8LT8O9BAnsEorvFL4fFhoaQhUMdo9XGrJ
// SIG // v8qmng5YX3oDirFgJ/pbDYCx6gVqQcUneK1HleeHqIGs
// SIG // pErd8X7rEOo80vE7lb77Ax9Uaphq/ze1PBGZZRCM8dqj
// SIG // hcFhGvRFG553aycu/EfAYneUB9ksufftCUjCXa9Tgzgo
// SIG // 4OlN9ql1nJ4rd8QahC+YNDRgi7YiTw==
// SIG // End signature block
