var topic = "<!DOCTYPE html>\r\n\n<!-- saved from url=(0024)http://docs.autodesk.com -->\r\n<html>\n   <head>\n      <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n      <meta name=\"product\" content=\"VAULT\">\n      <meta name=\"release\" content=\"2021\">\n      <meta name=\"book\" content=\"GeneralUser\">\n      <meta name=\"created\" content=\"2020-03-20\">\n      <meta name=\"topicid\" content=\"GUID-D890DCFE-0F1F-4735-A3F9-BC35BEF7368C\">\n      <meta name=\"description\" content=\"Every dialog in Data Standard is based on a file with the extension .XAML (Extensible Application Markup Language ). Customize the Data Standard dialog by modifying the XAML file.\">\n      <meta name=\"topic-type\" content=\"concept\">\n      <meta name=\"audience\" content=\"administrator\">\n      <meta name=\"experiencelevel\" content=\"general\">\n      <title>Data Standard XAML Files</title><script language=\"javascript\">var index = \'index.html\';</script></head>\n   <body height=\"100%\">\n      <div class=\"body_content\" id=\"body-content\" dir=\"ltr\"><a name=\"GUID-D890DCFE-0F1F-4735-A3F9-BC35BEF7368C\"></a><div class=\"head\">\n            <h1>Data Standard XAML Files</h1>\n         </div>\n         <p class=\"blurb\"> Every dialog in Data Standard is based on a file with the extension .XAML (Extensible\n            Application Markup Language ). Customize the Data Standard dialog by modifying the\n            XAML file. \n            \n         </p>\n         <div class=\"section\"><a name=\"SECTION_63E6DBC691E04C31AD1174BE683FA899\"></a> \n            <h2><a name=\"GUID-F482D515-A95A-4EDB-B561-D0B635B60701\"></a>Overview\n            </h2> \n            <p>XAML files describe the layout of the Data Standard dialog, including which controls\n               (label, text-box, combo-box, etc.) are used, and to which CAD or Vault properties\n               the controls are bound. \n               		\n            </p> \n            <p> XAML files are XML files, and can be edited with any text/XML editor. A good choice\n               for a free XML editor is the \n               		  <a href=\"https://www.microsoft.com/en-us/download/details.aspx?id=7973GUID-D890DCFE-0F1F-4735-A3F9-BC35BEF7368C\" target=\"_blank\">Microsoft XML Notepad</a> or any other editor that can format XML. Autodesk recommends Visual Studio (Express\n               or higher) for the best editing experience. Since the XAML syntax is case sensitive,\n               it is best to use an editor that will support capitalization and catch typos. \n               		\n            </p> \n            <p>Edit the XAML file if a Data Standard dialog needs to show more, less, or different\n               information. The PS1 files located in the Configuration folder control dialog behavior.\n               \n               		\n            </p> \n            <p> This topic provides a brief description of the most used controls. More information\n               on these controls as well as other controls can be found on the Microsoft help pages.\n               \n               		\n            </p> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_C1D4B192C0104B118D5D29DF6A11C2AB\"></a> \n            <h2><a name=\"GUID-EEA0AC5C-21C6-4436-82FE-4BA86F43653D\"></a>Anatomy of a XAML File\n            </h2> \n            <p> Each XAML file has different sections: the Resource, Style, and controls sections\n               are most used. \n               		\n            </p> \n            <p> In the Resource section, there are definitions that are reused in the controls sections.\n               For instance, if your company color is green, you can define that all text displayed\n               on the controls is green. \n               		\n            </p> \n            <p>Triggers are located in the Style section. Triggers define how a control looks or\n               behaves, depending on the given situation (e.g., creating a new record or editing\n               an existing one). However, more complex behaviors are defined in the PS1 files. \n               		\n            </p> \n            <p> The controls section, or layout area, usually starts with the control \n               		  <span class=\"code\">&lt;Grid&gt;</span>. The grid splits the dialog into rows and columns, like an Excel table. Combine and\n               split cells as required by your design. In each cell, you can place one or more controls,\n               such as labels, for simple text or text-boxes for text input. \n               		\n            </p> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_1864DB75D67D466587995B3417E54B3F\"></a> \n            <h2><a name=\"GUID-55997B82-1C2E-48E5-A4AA-D6DAD924135D\"></a>Layout\n            </h2> \n            <p> The layout of a XAML file is similar to a table, with rows and columns. This makes\n               the dialog and its controls dynamic, which means that if you resize the window with\n               the mouse, the controls automatically resize too. You can also work with fixed coordinates,\n               but in this case, when the dialog is resized by the user, or some users have a larger\n               windows font configured, the controls in the dialog remain at their coordinates and\n               potentially overlap or do not consume the available space in the dialog. For this\n               reason, Autodesk recommends using the table approach and letting every control expand\n               inside the defined cell. \n               		\n            </p> \n            <p> Since your dialog is like a table, when you design the dialog, think of how many\n               columns and rows you need. Usually two columns are fine: one left with a fixed width\n               for the labels and one right with a dynamic width for the controls. This is also how\n               the default dialogs are made. Depending on how many rows you need, according row definitions\n               are defined in the grid. Every control inside the Grid has a reference to the row\n               and column (always starting with 0), so that the control is shown accordingly. \n               		\n            </p> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_54C1731C9BD74B9181694FFE4AE71BDA\"></a> \n            <h2><a name=\"GUID-63EE52D5-07EF-4D13-90B6-BB7787685744\"></a>Syntax\n            </h2> \n            <p> In XML and XAML, every keyword is embedded in age brackets (&lt;keyword&gt;). Usually a\n               definition block starts with a keyword, such as &lt;Grid&gt;, and ends with the same keyword\n               prefixed with a slash, like &lt;/Grid&gt;. In the case of a single line statement, you may\n               also see this syntax: &lt;Label ... /&gt;. Further attributes of the keyword, or further\n               keywords nested inside, define the structure of the dialog. XAML is case-sensitive,\n               so pay attention on the upper/lower cases. \n               		\n            </p> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_40CE3E37254E46C6A091F35CD116FED7\"></a> \n            <h2><a name=\"GUID-0A01046C-4ED3-4BEC-8505-D929363EFF52\"></a>Most Used Controls\n            </h2> <a name=\"UL_915809A1F41A4550955C22B5FB966D5B\"></a><p class=\"list-intro\">Grid</p>\n            <p> The Grid is a layout panel that controls everything in a tabular structure of rows\n               and columns. All cells (a cell is unique by its combination of a row and a column)\n               can contain multiple controls, like labels and text boxes. \n               		\n            </p>\n            <p> </p>\n            <p> <a name=\"FIG_C92C56E550C042849AAA37ABBF6FF322\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-EF6DFA23-3746-4331-B539-81983723BAF8-low.png\"></div> \n            </p>\n            <p> This is the basic structure of a grid. The grid requires rows, which you define in\n               the Grid.RowDefinition part. Height 30 defines a fixed value for the height and cannot\n               be changed afterwards. The value \"auto\" gives the row a dynamic height, so it can\n               be thicker or thinner, depending on the controls. The same values apply to the Column\n               width. \n               		\n            </p>\n            <p> After defining your rows and columns, you can add controls, such as labels and text\n               boxes. Controls must be attached at the two properties: Grid.Column and Grid.Row.\n               These properties define the location of the control in the grid. The first row is\n               0, so the second row is 1, etc. \n               		\n            </p> <a name=\"UL_D0800B6E1A304E2D85B03C82CCEC1512\"></a><p class=\"list-intro\">Label</p>\n            <p> Labels are field names that the user cannot edit. They contain text indicating what\n               the label is for, so the user knows which type of value has to be inserted in the\n               corresponding text box or combobox. For example, a label called Comments might be\n               located beside an empty text box. The user would know to provide any comments in that\n               text box. \n               		\n            </p>\n            <p> The Label has a Content property. This property is the text that is displayed for\n               the label. \n               		\n            </p>\n            <p><span class=\"code\">&lt;Label Content=\"sample\" Grid.Row =\"0\" Grid.Colum=\"0\"/&gt; \n                  		  </span> \n            </p>\n            <p> In the default dialogs are code strings like this &lt;Label Content=\"{Binding UIString[LBL2]}\"\n               ....&gt; , where the Content is bound to a localized text. This syntax is used when the\n               dialog shows text in different languages. If your project needs only one language,\n               then set the text that you want to show. If the dialog needs to be localized, use\n               the localization syntax. See \n               		  <span class=\"char_link\"><a href=\"GUID-244DFF1D-7473-41D8-AA7D-43A3FB25D17F.htm\">Localization</a></span> for more information. \n               		\n            </p> <a name=\"UL_7E4C6B46C8BD4514AB3A5C858BD8BBFC\"></a><p class=\"list-intro\">TextBox</p>\n            <p> Text boxes are fields that the user can edit. Data Standard can read the entered\n               value and use it for other operations. \n               		\n            </p>\n            <p> The text box needs the following properties: \n               		<a name=\"UL_C40E377DCA58407693DF7A6852E85F28\"></a><ul>\n                  <li><em class=\"mild\">Text</em>–The initial text that you want to display in your text box as a sample. If you write\n                     \n                     			 <span class=\"code\">content=\"Enter Comments Here\"</span>, the text box shows Enter Comments Here when the dialog opens. \n                     		  \n                  </li>\n                  <li><em class=\"mild\">Name</em>–Sets the identifying name of the element. The name provides a reference so that code,\n                     such as event handler code, can refer to it. \n                     		  \n                  </li>\n               </ul> \n            </p>\n            <p><span class=\"code\"> &lt;ComboBox Name=\"MaterialCombo\" Text=\"{Binding Prop[Cost].Value}\" Grid.Column=\"3\"\n                  Grid.Row=\"6\" ItemsSource=\"{Binding Prop[Cost].ListValues}\"/&gt;</span> \n            </p> <a name=\"UL_F682D721A492425BA024903024807B7A\"></a><p class=\"list-intro\">Button</p>\n            <p>A button is a user interface element that provides the user a simple way to trigger\n               an event, such as Search or Save. The button needs the Command property. This Command\n               property identifies which action gets executed when the button is clicked. \n               		\n            </p>\n            <p><span class=\"code\"> &lt;Button Command=\"{Binding PsCmd[MyCommand]}\" Grid.Column=\"1\" Margin=\"0,5,0,5\" Width=\"80\"&gt;Click&lt;/Button&gt;</span> \n            </p>\n            <p>The Command is bound to the \n               		  <span class=\"code\">PsCmd</span> keyword which helps link the command action with the given PowerShell function. It\n               is possible to pass arguments to the function using the \n               		  <span class=\"code\">CommandParameter=\"my args\"</span> attribute. The argument will then be available within the function as \n               		  <span class=\"code\">$dsParam</span> variable. \n               		\n            </p> <a name=\"UL_D81314E25E094F71B0AE20B4957696E7\"></a><p class=\"list-intro\">Binding</p>\n            <p> To use one of these components to control or change a Vault file property, you need\n               to understand \n               		  <span class=\"code\">\"{Binding Prop[myProp ].Value}\"</span>. \n               		\n            </p>\n            <p> Binding lets you map values to certain CAD or Vault properties. For example, you\n               can bind the text of a Text Box to the Title property so that every time something\n               is entered in this particular text box, the Title property is automatically updated.\n               Binding is a great way to automate property changes, leaving less work for the end\n               user \n               		\n            </p>\n            <p><span class=\"code\">Prop[ ]</span> is an essential function for binding. With it, you can access the properties of a\n               file (CAD and Vault) or according object (folder, item, custom object, etc.). If you\n               want to map a text box to the property Engineer, write \n               		  <span class=\"code\">&lt;TextBox text=\"{Binding Prop[Engineer].Value}\"/&gt;</span>. When the text box is created, \n               		  <span class=\"code\">Prop[ ]</span> returns the value of that property. Every time the text box gets updated, it notifies\n               the \n               		  <span class=\"code\">Prop[ ]</span> function which writes the new value to the mapped file property. \n               		\n            </p> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_499BE99969CA44508E725D2E0907FB9B\"></a> \n            <h2><a name=\"GUID-279F85A8-1987-4CFA-BF75-4779C0721A68\"></a>Editing XAML Files with Visual Studio\n            </h2> \n            <p> You can use Visual Studio to edit the .xaml file. Visual Studio helps you place your\n               elements and helps you avoid spelling mistakes. \n               		\n            </p> \n            <div><a name=\"GUID-566596FF-9D26-43AC-A44C-BF46EB18A7C5\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span> Visual Studio Express for Windows or better is required for the instructions in this\n                  topic. If you don\'t already have Visual Studio, you can download it from Microsoft.\n                  \n                  		\n               </div>\n            </div> \n            <p>Example of setting up Visual Studio: \n               		<a name=\"OL_F150F8D7F4044AA3A685C9D30B8AEBCF\"></a><ol type=\"1\" start=\"1\">\n                  <li>After Visual Studio is installed, launch the application and click the New Project\n                     field. \n                     		  \n                  </li>\n                  <li> Select the WPF Application and give the new project your desired name and location.\n                     You should also set the default path, so if you want to change the Data Standard dialog\n                     more than one time you can always use that project again. \n                     		  \n                  </li>\n               </ol> \n            </p> \n            <p> Now that you are in your new project, you should see a MainWindow.xaml tab, MainWindow.xam.cs\n               tab, and others. You do not need the tabs, just the environment provided to edit the\n               .xaml file. For the purposes of editing the .xaml, you want to link to the .xaml file.\n               There is no need to bring the .xaml into the project. \n               		\n            </p> <a name=\"OL_AC4BD032CD4643CF974C1C5E661B45EB\"></a><ol type=\"1\" start=\"1\">\n               <li>Right click on the project in Solution Explorer and move it to Add&gt;Existing Item.\n                  \n                  		  \n               </li>\n               <li>Browse to the .xaml file in Solution Explorer and select Add as Link. \n                  			 \n                  <div><a name=\"GUID-2D65CFD9-A2E1-4911-8C3D-D2C731AA8DD1\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span> If you do not see the .xaml file, change the file type above the Add button. \n                        			 \n                     </div>\n                  </div> \n               </li>\n               <li> Once you see the .xaml file in Solution Explorer, double-click on it. \n                  			 \n                  <p> An Error called Problem Loading displays. \n                     			 \n                  </p> \n               </li>\n               <li>In the error list at the bottom of your Visual Studio window, locate the error that\n                  says that assemblies and properties or resources aren\'t found. \n                  		  \n               </li>\n               <li>Go to Solution Explorer and right-click on References. \n                  		  \n               </li>\n               <li> Select Add References. \n                  		  \n               </li>\n               <li>Select the Browse tab and search for: \n                  			 <a name=\"UL_DA2F48F5D5F7440EB5475F72CAB325D3\"></a><ul>\n                     <li>dataStandard.UI.DLL at this path: \n                        				  <span class=\"filePath\">C:\\ProgramData\\Autodesk\\Inventor 2018\\Addins\\Data Standard</span>. Select it and click OK. \n                        				\n                     </li>\n                     <li>CreateObject.DLL at this path: \n                        				  <span class=\"filePath\">C:\\ProgramData\\Autodesk\\Vault 2018\\Extensions\\Data Standard</span>. Select it and click OK. \n                        				\n                     </li>\n                     <li>Autodesk.Connectivity.Webservices.DLL at this path: \n                        				  <span class=\"filePath\">C:\\Program Files\\Autodesk\\Vault 2018\\</span> . Select it and click OK. \n                        				\n                     </li>\n                  </ul> \n               </li>\n               <li> If changes are for CAD, select the .cfg file that you want to modify in the Solution\n                  Explorer. \n                  		  \n               </li>\n            </ol> \n            <p>The dialog displays in the design window. You can select an area in the dialog and\n               Visual Studio jumps to that part in your xaml file. Begin inserting or modifying fields.\n               See \n               		  <span class=\"char_link\"><a href=\"GUID-D810F003-0EAC-4C22-841A-5FB014E4ADE7.htm\">Data Standard Dialogs</a></span> for more information. \n               		\n            </p> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_70702F615308467DAF3E0A5B36B173DA\"></a> \n            <h2><a name=\"GUID-4A917DBF-9C5E-4DB6-99D4-4885A66279CB\"></a>Add a Field to the Dialog\n            </h2> <a name=\"OL_9E0CCE256C434D2A80E8C5E0498CDA79\"></a><ol type=\"1\" start=\"1\">\n               <li>Decide where to add the new field. In which row and column should the new property\n                  show up? \n                  		  \n               </li>\n               <li>Add a new row in the grid so that the control can be placed at that position. If a\n                  new column is needed, add a column. Go in the XAML file at the Grid control which\n                  contains the new control. For that Grid you will find<span class=\"code\"> &lt;Grid.RowDefinitions&gt;</span> and \n                  			 <span class=\"code\">&lt;RowDefinition .../&gt;</span>. Add an additional \n                  			 <span class=\"code\">&lt;RowDefinition/&gt;</span> where you want the new row displayed. Set the property Height to the according value,\n                  either a fixed value or auto (for minimal space) or * (for maximal space). \n                  		  \n               </li>\n               <li>Add the control, such as a Label and TextBox, inside the &lt;Grid&gt; area near the other\n                  controls. With the attributes \n                  			 <span class=\"code\">Grid.Row</span> and \n                  			 <span class=\"code\">Grid.Column</span> you can define at which row and column the control is placed. Also define the bindings\n                  for the control, so that data can flow between the control and the property. If changes\n                  are intended for CAD, you must also configure the property in the according \n                  			 <span class=\"char_link\"><a href=\"GUID-35BE7DEF-C918-4298-9606-F999F4CC4D02.htm\">CFG file</a></span>. \n                  		  \n               </li>\n               <li>When adding a new row, all controls that were on the same row number and below must\n                  be moved down by incrementing their \n                  			 <span class=\"code\">Grid.Row</span> attribute. \n                  		  \n               </li>\n            </ol> \n         </div>\n         <div class=\"footer-block\"><a href=\"..\" class=\"comments-anchor\" target=\"_blank\"><span class=\"comments-link\">Please send us your comment about this page</span></a></div><br><p class=\"footer-license-block\"><a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\"><img alt=\"Creative Commons License\" style=\"border-width: 0;\" src=\"../images/ccLink.png\"></a>&nbsp;<em>Except where otherwise noted, this work is licensed under a <a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\">Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License</a>. Please see the <a href=\"http://autodesk.com/creativecommons\" target=\"_blank\">Autodesk Creative Commons FAQ</a> for more information.</em></p><br></div>\n   </body>\n</html>";
// SIG // Begin signature block
// SIG // MIIZfQYJKoZIhvcNAQcCoIIZbjCCGWoCAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // BgBkuJp1SoFlOnyxCJaCJL0/o8EJf3YVWGTT86U/c36g
// SIG // ggoaMIIEyzCCA7OgAwIBAgIQCQja65wGHi65un4mqmKH
// SIG // ijANBgkqhkiG9w0BAQsFADCBhDELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTUw
// SIG // MwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
// SIG // b2RlIFNpZ25pbmcgQ0EgLSBHMjAeFw0xOTA1MTQwMDAw
// SIG // MDBaFw0yMDA1MTMyMzU5NTlaMHwxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIDApDYWxpZm9ybmlhMRMwEQYDVQQHDApT
// SIG // YW4gUmFmYWVsMRcwFQYDVQQKDA5BdXRvZGVzaywgSW5j
// SIG // LjERMA8GA1UECwwIU2VjdXJpdHkxFzAVBgNVBAMMDkF1
// SIG // dG9kZXNrLCBJbmMuMIIBIjANBgkqhkiG9w0BAQEFAAOC
// SIG // AQ8AMIIBCgKCAQEAkVKRoPYsoxPdlabspcuG8HYDfcWQ
// SIG // 9qyPOT2punwpVdjt2slktcpSTlydrGy8ijcbl5/k8AOJ
// SIG // afKMQvow0fNjIoNB5nsb8j2xFJPbBhHl8GT4P6DZ1OWK
// SIG // ioiUXgGHKjctUws49J4elntqvBYhKCbuPqG772QCoYFU
// SIG // P7qcFbh3PbyNB6cnKMn2vNGRqiEtV2aGg+/MiL3QPsvT
// SIG // kTWhVuTLIvwZ4kK5C5ACiQzlGOlE+C7gWuFoxtvy6gUa
// SIG // A8JAq/xLjYKwFevQwGncg3s1cuiGhx0P7Rvn6oCd2cem
// SIG // FmbK3I3rMRt+jc9wzAj3oHxvCo4f5Lfva+OpC1dETUVV
// SIG // sk0VGwIDAQABo4IBPjCCATowCQYDVR0TBAIwADAOBgNV
// SIG // HQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMw
// SIG // YQYDVR0gBFowWDBWBgZngQwBBAEwTDAjBggrBgEFBQcC
// SIG // ARYXaHR0cHM6Ly9kLnN5bWNiLmNvbS9jcHMwJQYIKwYB
// SIG // BQUHAgIwGQwXaHR0cHM6Ly9kLnN5bWNiLmNvbS9ycGEw
// SIG // HwYDVR0jBBgwFoAU1MAGIknrOUvdk+JcobhHdglyA1gw
// SIG // KwYDVR0fBCQwIjAgoB6gHIYaaHR0cDovL3JiLnN5bWNi
// SIG // LmNvbS9yYi5jcmwwVwYIKwYBBQUHAQEESzBJMB8GCCsG
// SIG // AQUFBzABhhNodHRwOi8vcmIuc3ltY2QuY29tMCYGCCsG
// SIG // AQUFBzAChhpodHRwOi8vcmIuc3ltY2IuY29tL3JiLmNy
// SIG // dDANBgkqhkiG9w0BAQsFAAOCAQEA0Q2+iVSEfT4xGq3A
// SIG // OADVb0rT5Z8E+PPb1x6hKknSzuaZKk/acDz9mdnFajaU
// SIG // WgIKiFJlsqJnuAM1w4lqKaEWsz3DoxvGIEwexj71Ud6a
// SIG // KlBJNcR9DdkXUZwMhbw9d78rjJAIX6tOwfSludZfdq8b
// SIG // YEkuIzQi9uYW9vHVPSCzhnUBKjwc9qTo9yBc7Fcn4FAT
// SIG // 90DzWM2hS9oc3p0pprYI2I/O4th90BEmwWkVqVgfaR0z
// SIG // VyIEmBbqB/IWLfjUBZJ/8sbkwWuWlYVRrfPxsj1e9qvb
// SIG // wE3Y28jWyGbqoUG39GhXk3uT8R8i3+T6M0c4rMfdifBC
// SIG // pceCaFTJzSye7LoeVzCCBUcwggQvoAMCAQICEHwbNTVK
// SIG // 59t050FfEWnKa6gwDQYJKoZIhvcNAQELBQAwgb0xCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjEfMB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29y
// SIG // azE6MDgGA1UECxMxKGMpIDIwMDggVmVyaVNpZ24sIElu
// SIG // Yy4gLSBGb3IgYXV0aG9yaXplZCB1c2Ugb25seTE4MDYG
// SIG // A1UEAxMvVmVyaVNpZ24gVW5pdmVyc2FsIFJvb3QgQ2Vy
// SIG // dGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMTQwNzIyMDAw
// SIG // MDAwWhcNMjQwNzIxMjM1OTU5WjCBhDELMAkGA1UEBhMC
// SIG // VVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9u
// SIG // MR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3Jr
// SIG // MTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1
// SIG // NiBDb2RlIFNpZ25pbmcgQ0EgLSBHMjCCASIwDQYJKoZI
// SIG // hvcNAQEBBQADggEPADCCAQoCggEBANeVQ9Tc32euOftS
// SIG // pLYmMQRw6beOWyq6N2k1lY+7wDDnhthzu9/r0XY/ilaO
// SIG // 6y1L8FcYTrGNpTPTC3Uj1Wp5J92j0/cOh2W13q0c8fU1
// SIG // tCJRryKhwV1LkH/AWU6rnXmpAtceSbE7TYf+wnirv+9S
// SIG // rpyvCNk55ZpRPmlfMBBOcWNsWOHwIDMbD3S+W8sS4duM
// SIG // xICUcrv2RZqewSUL+6McntimCXBx7MBHTI99w94Zzj7u
// SIG // BHKOF9P/8LIFMhlM07Acn/6leCBCcEGwJoxvAMg6ABFB
// SIG // ekGwp4qRBKCZePR3tPNgKuZsUAS3FGD/DVH0qIuE/iHa
// SIG // XF599Sl5T7BEdG9tcv8CAwEAAaOCAXgwggF0MC4GCCsG
// SIG // AQUFBwEBBCIwIDAeBggrBgEFBQcwAYYSaHR0cDovL3Mu
// SIG // c3ltY2QuY29tMBIGA1UdEwEB/wQIMAYBAf8CAQAwZgYD
// SIG // VR0gBF8wXTBbBgtghkgBhvhFAQcXAzBMMCMGCCsGAQUF
// SIG // BwIBFhdodHRwczovL2Quc3ltY2IuY29tL2NwczAlBggr
// SIG // BgEFBQcCAjAZGhdodHRwczovL2Quc3ltY2IuY29tL3Jw
// SIG // YTA2BgNVHR8ELzAtMCugKaAnhiVodHRwOi8vcy5zeW1j
// SIG // Yi5jb20vdW5pdmVyc2FsLXJvb3QuY3JsMBMGA1UdJQQM
// SIG // MAoGCCsGAQUFBwMDMA4GA1UdDwEB/wQEAwIBBjApBgNV
// SIG // HREEIjAgpB4wHDEaMBgGA1UEAxMRU3ltYW50ZWNQS0kt
// SIG // MS03MjQwHQYDVR0OBBYEFNTABiJJ6zlL3ZPiXKG4R3YJ
// SIG // cgNYMB8GA1UdIwQYMBaAFLZ3+mlIR59TEtXC6gcydgfR
// SIG // lwcZMA0GCSqGSIb3DQEBCwUAA4IBAQB/68qn6ot2Qus+
// SIG // jiBUMOO3udz6SD4Wxw9FlRDNJ4ajZvMC7XH4qsJVl5Fw
// SIG // g/lSflJpPMnx4JRGgBi7odSkVqbzHQCR1YbzSIfgy8Q0
// SIG // aCBetMv5Be2cr3BTJ7noPn5RoGlxi9xR7YA6JTKfRK9u
// SIG // QyjTIXW7l9iLi4z+qQRGBIX3FZxLEY3ELBf+1W5/muJW
// SIG // kvGWs60t+fTf2omZzrI4RMD3R3vKJbn6Kmgzm1By3qif
// SIG // 1M0sCzS9izB4QOCNjicbkG8avggVgV3rL+JR51EeyXgp
// SIG // 5x5lvzjvAUoBCSQOFsQUecFBNzTQPZFSlJ3haO8I8OJp
// SIG // nGdukAsak3HUJgLDwFojMYIOuzCCDrcCAQEwgZkwgYQx
// SIG // CzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRlYyBD
// SIG // b3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1
// SIG // c3QgTmV0d29yazE1MDMGA1UEAxMsU3ltYW50ZWMgQ2xh
// SIG // c3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENBIC0gRzIC
// SIG // EAkI2uucBh4uubp+Jqpih4owDQYJYIZIAWUDBAIBBQCg
// SIG // fDAQBgorBgEEAYI3AgEMMQIwADAZBgkqhkiG9w0BCQMx
// SIG // DAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4wDAYK
// SIG // KwYBBAGCNwIBFTAvBgkqhkiG9w0BCQQxIgQgFOGYvbZs
// SIG // XZlUmVRw0Vyic9/1Bq+HQucBqL80YWWjQ9cwDQYJKoZI
// SIG // hvcNAQEBBQAEggEAdO0t6KS+TfXRotL91coEEd3mfXn8
// SIG // I8iXxk39GtqXp5sptcM4Fami3JVuRN33kUuqhq5jEk11
// SIG // 9RpNi+F6piv0DASjJh3pThlU2yL1VSeqB3i+p91lB8eF
// SIG // cH6I07CAHl0//uhNYBf5FjaVPCmTfL6HvhkLMa4qODQb
// SIG // Lefdl+NLUxhb41uJ+CQ+B6VipViLQj6bi9tuygSXuHLr
// SIG // UJGjzWb8tqUCSEfbg0LMbCmIsYyRKYbJlG4TOcR9wr1t
// SIG // Nf7ace3gyFH230EBmQIzF9rDgmmbunJcHbdrOCVaRAmW
// SIG // yRHR9lEswL5osKiZlFbJosvYELyQMj2VuBkujZCZspwk
// SIG // iZCtX6GCDHQwggxwBgorBgEEAYI3AwMBMYIMYDCCDFwG
// SIG // CSqGSIb3DQEHAqCCDE0wggxJAgEDMQ8wDQYJYIZIAWUD
// SIG // BAIBBQAwga8GCyqGSIb3DQEJEAEEoIGfBIGcMIGZAgEB
// SIG // BgkrBgEEAaAyAgMwMTANBglghkgBZQMEAgEFAAQg9hwI
// SIG // ww+pVUGkYTN/Bkty0bzRgGT4xiRTZ8OciKriOtACFFUX
// SIG // GXf2uF3lFAVnYzqE6bWJFbbUGA8yMDIwMDMyMzE0MDMz
// SIG // N1qgL6QtMCsxKTAnBgNVBAMMIEdsb2JhbFNpZ24gVFNB
// SIG // IGZvciBBZHZhbmNlZCAtIEcyoIII0zCCBLYwggOeoAMC
// SIG // AQICDAynz10HBySsieeaOjANBgkqhkiG9w0BAQsFADBb
// SIG // MQswCQYDVQQGEwJCRTEZMBcGA1UEChMQR2xvYmFsU2ln
// SIG // biBudi1zYTExMC8GA1UEAxMoR2xvYmFsU2lnbiBUaW1l
// SIG // c3RhbXBpbmcgQ0EgLSBTSEEyNTYgLSBHMjAeFw0xODAy
// SIG // MTkwMDAwMDBaFw0yOTAzMTgxMDAwMDBaMCsxKTAnBgNV
// SIG // BAMMIEdsb2JhbFNpZ24gVFNBIGZvciBBZHZhbmNlZCAt
// SIG // IEcyMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKC
// SIG // AQEAt8eSiijY85HLUA1d6ylEwYJZpcpkzr2DtVHllMxu
// SIG // gJoXbNz/YuY2Q14Bwgxkjcp3nvZdd0W5Xsgk60E3EWY3
// SIG // rMjNdJvMs+9M4n8bznO+yZadNR5891T3bOygEtaumZ1j
// SIG // xHhfWakuIvXDJ9iyW0VjJ5D/jLE9qbTzDsDxIGUGiZ0D
// SIG // HKOwUkGFNOu8y85U9hL+swGJSqb6VMUf+9McwOO/l+M/
// SIG // 0Bv5QMcb1esmfEMwx3DyeBGqhU6lDg0ASjoRd6PKIwGA
// SIG // nsiTVl1GzIrY0qoKhIWyiVvVMs5BexhOVMqr0VJeEtMk
// SIG // nlbzDI/dvZKOedVBicOjoOWR/MdnnYczznEycwIDAQAB
// SIG // o4IBqDCCAaQwDgYDVR0PAQH/BAQDAgeAMEwGA1UdIARF
// SIG // MEMwQQYJKwYBBAGgMgEeMDQwMgYIKwYBBQUHAgEWJmh0
// SIG // dHBzOi8vd3d3Lmdsb2JhbHNpZ24uY29tL3JlcG9zaXRv
// SIG // cnkvMAkGA1UdEwQCMAAwFgYDVR0lAQH/BAwwCgYIKwYB
// SIG // BQUHAwgwRgYDVR0fBD8wPTA7oDmgN4Y1aHR0cDovL2Ny
// SIG // bC5nbG9iYWxzaWduLmNvbS9ncy9nc3RpbWVzdGFtcGlu
// SIG // Z3NoYTJnMi5jcmwwgZgGCCsGAQUFBwEBBIGLMIGIMEgG
// SIG // CCsGAQUFBzAChjxodHRwOi8vc2VjdXJlLmdsb2JhbHNp
// SIG // Z24uY29tL2NhY2VydC9nc3RpbWVzdGFtcGluZ3NoYTJn
// SIG // Mi5jcnQwPAYIKwYBBQUHMAGGMGh0dHA6Ly9vY3NwMi5n
// SIG // bG9iYWxzaWduLmNvbS9nc3RpbWVzdGFtcGluZ3NoYTJn
// SIG // MjAdBgNVHQ4EFgQULW5u0Y3lA4Du52Ppp9naCzxXIj0w
// SIG // HwYDVR0jBBgwFoAUkiGnSpVdZLCbtB7mADdH5p1BK0ww
// SIG // DQYJKoZIhvcNAQELBQADggEBAI39HR+PiNNl+LVcRumn
// SIG // 07Y/SstDBcIHDcNeA4QjN6h6jJcj/yechH1h61xLVz6b
// SIG // 9ETbgFj3tmXejxIKX6eHdLfaFECHUeyfSkdV8BfoGD5x
// SIG // IDHmKCKrTvaunGvC50T7aA0gf1M/lBuhhoJOMhYQWj+J
// SIG // WMHQtNu2kPuNMumhS0ZQN7bDOukpJBKSWk4rubYKejaM
// SIG // l8DviXwz3jHhoZfk50WtYVL9WonTVH6KTVuJew6Wd9Hy
// SIG // PDgb2vmlYSBlArzFrdcMYhAoLN2246hhAKwIJqONhdBk
// SIG // yTaQHopSyYeNNaVdSJH8k6alZfHs+TrcpSyeBG1iM/7e
// SIG // +p/Fzq+V81Go8s4wggQVMIIC/aADAgECAgsEAAAAAAEx
// SIG // icZQBDANBgkqhkiG9w0BAQsFADBMMSAwHgYDVQQLExdH
// SIG // bG9iYWxTaWduIFJvb3QgQ0EgLSBSMzETMBEGA1UEChMK
// SIG // R2xvYmFsU2lnbjETMBEGA1UEAxMKR2xvYmFsU2lnbjAe
// SIG // Fw0xMTA4MDIxMDAwMDBaFw0yOTAzMjkxMDAwMDBaMFsx
// SIG // CzAJBgNVBAYTAkJFMRkwFwYDVQQKExBHbG9iYWxTaWdu
// SIG // IG52LXNhMTEwLwYDVQQDEyhHbG9iYWxTaWduIFRpbWVz
// SIG // dGFtcGluZyBDQSAtIFNIQTI1NiAtIEcyMIIBIjANBgkq
// SIG // hkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqpuOw6sRUSUB
// SIG // tpaU4k/YwQj2RiPZRcWVl1urGr/SbFfJMwYfoA/GPH5T
// SIG // SHq/nYeer+7DjEfhQuzj46FKbAwXxKbBuc1b8R5EiY7+
// SIG // C94hWBPuTcjFZwscsrPxNHaRossHbTfFoEcmAhWkkJGp
// SIG // eZ7X61edK3wi2BTX8QceeCI2a3d5r6/5f45O4bUIMf3q
// SIG // 7UtxYowj8QM5j0R5tnYDV56tLwhG3NKMvPSOdM7IaGlR
// SIG // dhGLD10kWxlUPSbMQI2CJxtZIH1Z9pOAjvgqOP1roEBl
// SIG // H1d2zFuOBE8sqNuEUBNPxtyLufjdaUyI65x7MCb8eli7
// SIG // WbwUcpKBV7d2ydiACoBuCQIDAQABo4HoMIHlMA4GA1Ud
// SIG // DwEB/wQEAwIBBjASBgNVHRMBAf8ECDAGAQH/AgEAMB0G
// SIG // A1UdDgQWBBSSIadKlV1ksJu0HuYAN0fmnUErTDBHBgNV
// SIG // HSAEQDA+MDwGBFUdIAAwNDAyBggrBgEFBQcCARYmaHR0
// SIG // cHM6Ly93d3cuZ2xvYmFsc2lnbi5jb20vcmVwb3NpdG9y
// SIG // eS8wNgYDVR0fBC8wLTAroCmgJ4YlaHR0cDovL2NybC5n
// SIG // bG9iYWxzaWduLm5ldC9yb290LXIzLmNybDAfBgNVHSME
// SIG // GDAWgBSP8Et/qC5FJK5NUPpjmove4t0bvDANBgkqhkiG
// SIG // 9w0BAQsFAAOCAQEABFaCSnzQzsm/NmbRvjWek2yX6AbO
// SIG // MRhZ+WxBX4AuwEIluBjH/NSxN8RooM8oagN0S2OXhXdh
// SIG // O9cv4/W9M6KSfREfnops7yyw9GKNNnPRFjbxvF7stICY
// SIG // ePzSdnno4SGU4B/EouGqZ9uznHPlQCLPOc7b5neVp7uy
// SIG // y/YZhp2fyNSYBbJxb051rvE9ZGo7Xk5GpipdCJLxo/Md
// SIG // dL9iDSOMXCo4ldLA1c3PiNofKLW6gWlkKrWmotVzr9xG
// SIG // 2wSukdduxZi61EfEVnSAR3hYjL7vK/3sbL/RlPe/UOB7
// SIG // 4JD9IBh4GCJdCC6MHKCX8x2ZfaOdkdMGRE4EbnocIOM2
// SIG // 8LZQuTGCAqgwggKkAgEBMGswWzELMAkGA1UEBhMCQkUx
// SIG // GTAXBgNVBAoTEEdsb2JhbFNpZ24gbnYtc2ExMTAvBgNV
// SIG // BAMTKEdsb2JhbFNpZ24gVGltZXN0YW1waW5nIENBIC0g
// SIG // U0hBMjU2IC0gRzICDAynz10HBySsieeaOjANBglghkgB
// SIG // ZQMEAgEFAKCCAQ4wGgYJKoZIhvcNAQkDMQ0GCyqGSIb3
// SIG // DQEJEAEEMBwGCSqGSIb3DQEJBTEPFw0yMDAzMjMxNDAz
// SIG // MzdaMC8GCSqGSIb3DQEJBDEiBCA2M8GjjJVPUmUnUCtH
// SIG // ivY34Y6/Mr9Z7z7qZzvpakqH1TCBoAYLKoZIhvcNAQkQ
// SIG // AgwxgZAwgY0wgYowgYcEFJsSBXrnKq/21jdytJ9qI28m
// SIG // Sc2pMG8wX6RdMFsxCzAJBgNVBAYTAkJFMRkwFwYDVQQK
// SIG // ExBHbG9iYWxTaWduIG52LXNhMTEwLwYDVQQDEyhHbG9i
// SIG // YWxTaWduIFRpbWVzdGFtcGluZyBDQSAtIFNIQTI1NiAt
// SIG // IEcyAgwMp89dBwckrInnmjowDQYJKoZIhvcNAQEBBQAE
// SIG // ggEAeN3BB7cS0pNspTz0/gG1LI9YbuqE/AW1rKNaojUO
// SIG // zsth0GfGDPZpGSBIVRcMWmMkUdrLeTS32d6z5u0bDDqp
// SIG // Epo6J+DPy4Ignwm/17dFxLwirJKWv4HJBNDyGAEHL7G+
// SIG // RdW3Nb9azY+bEzQ+8Ne4a8x/p/ZiXHq4MqhAlfNL7XXR
// SIG // WGnR3SPtOxYMfKa/93rrFAqCkCBekVJRvGZmtGe1g3KV
// SIG // BqgIT4yAptCa/Vl6blkLJwMLR9b/1Uf+PNnrSLfuuM0f
// SIG // f2EZBb40P8bzfRf07Wge2R2x0xTu3i7ZElFoUEcEAqHx
// SIG // O4SxMucvQvhn11VExDJyxNqDhkgrtmuNqQhFrw==
// SIG // End signature block
