var topic = "<!DOCTYPE html>\r\n\n<!-- saved from url=(0024)http://docs.autodesk.com -->\r\n<html>\n   <head>\n      <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n      <meta name=\"product\" content=\"VAULT\">\n      <meta name=\"release\" content=\"2021\">\n      <meta name=\"book\" content=\"GeneralUser\">\n      <meta name=\"created\" content=\"2020-03-20\">\n      <meta name=\"topicid\" content=\"GUID-CDD7E780-3322-4560-AA31-43025A845824\">\n      <meta name=\"topic-type\" content=\"concept\">\n      <title>Troubleshooting Job Processor</title><script language=\"javascript\">var index = \'index.html\';</script><script type=\"text/javascript\" src=\"../scripts/prettify/prettify.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-yaml.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-xq.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-wiki.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-vhdl.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-vb.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-tex.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-sql.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-scala.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-proto.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-n.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-ml.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-lua.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-lisp.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-hs.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-go.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-css.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-clj.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-apollo.js\"></script></head>\n   <body height=\"100%\" onLoad=\"javascript:prettyPrint();\">\n      <div class=\"revit-legend\">\n         <ul></ul>\n      </div>\n      <div class=\"body_content\" id=\"body-content\" dir=\"ltr\"><a name=\"GUID-CDD7E780-3322-4560-AA31-43025A845824\"></a><div class=\"head\">\n            <h1>Troubleshooting Job Processor</h1>\n         </div>\n         <p class=\"blurb\">  </p>\n         <p> Before troubleshooting, see the \n            		<span class=\"char_link\"><a href=\"GUID-DAE28A42-45C3-4501-9BF2-78EE2F42808D.htm\">Job Processor overview</a></span>: \n            	 \n         </p>\n         <div class=\"section\"><a name=\"SECTION_81B40639D5A8413FBA03EC18A07ED6A3\"></a> \n            <h2><a name=\"GUID-31D23EFF-E766-437E-BFE0-D731ADDE446D\"></a>Job Processor Components\n            </h2> \n            <p>Job Processor has three main components. \n               		\n            </p> \n            <dl><a name=\"GUID-9466D7FA-F3BB-48EF-AF50-B12E433B4600\"></a><dt><span class=\"term\">Jobs \n                     			 </span></dt>\n               <dd>\n                  <div class=\"definition\">Tasks submitted to the job queue and completed by Job Processor; these are typically\n                     repetitive tasks like property updates or DWF creation. \n                     			 \n                  </div>\n               </dd><a name=\"GUID-4C50BFC4-EA37-4856-9027-EBEB88B7135E\"></a><dt><span class=\"term\"> Job Queue \n                     			 </span></dt>\n               <dd>\n                  <div class=\"definition\">The server-side utility that accepts jobs from Vault Clients and records job execution\n                     details. \n                     			 \n                  </div>\n               </dd><a name=\"GUID-406056D2-6071-4862-9BF0-F3C195C6C09F\"></a><dt><span class=\"term\"> Job Processor \n                     			 </span></dt>\n               <dd>\n                  <div class=\"definition\">The client side component that polls the job queue for tasks and executes them using\n                     the appropriate components. \n                     			 \n                  </div>\n               </dd>\n            </dl> <a name=\"FIG_AC0F64B06FC14DFD98C3B64A167A135A\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-F6DBE073-B816-4258-9B5A-4EDD109850B9-low.png\"></div> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_D2D0F7E5240F4CCEBC6D10DF42F787B7\"></a> \n            <h2><a name=\"GUID-7888F3F2-A401-4926-A713-47E9B6E844E5\"></a>Job Processor Process\n            </h2> <a name=\"OL_9457290675F64FFCA8E4ABB5FBC43A46\"></a><ol type=\"1\" start=\"1\">\n               <li>Once Job Processor is started, checks the job queue every 10 minutes (this is configurable).\n                  \n                  		  \n               </li>\n               <li>If there is an item in the queue, reserves the next queued jobs, taking priority into\n                  account. \n                  		  \n               </li>\n               <li>Downloads the files to the local computer. \n                  		  \n               </li>\n               <li>Opens the files, usually in a “headless” (no user interface) version of the associated\n                  product. \n                  		  \n               </li>\n               <li>If necessary, updates the file properties and saves the file as a new version. \n                  		  \n               </li>\n               <li>If a DWF update is needed, Job Processor creates the DWF and uploads to Vault, attaching\n                  the DWF to the source file; this does not create a new version. \n                  		  \n               </li>\n               <li>Moves to the next job. \n                  		  \n               </li>\n            </ol> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_41729D9B6E674B809185DBF6F7244505\"></a> \n            <h2><a name=\"GUID-5BCDE7EC-E10E-47AB-8A82-541A3891D47D\"></a>Job Processor Frequently Asked Questions\n            </h2> <a name=\"UL_3F4F10F594E0405AB4D1859937EDBC09\"></a><p class=\"list-intro\"> Does Job Processor need to be installed on a server? </p>\n            <p>No. Job Processor is a client application. Ideally it should be installed on a workstation\n               with similar specifications to a CAD workstation. \n               		\n            </p> <a name=\"UL_9ADE7EC127BA4CE9A57758B5A81FFECE\"></a><p class=\"list-intro\">What are the system requirements for Job Processor?</p>\n            <p>See the system requirements for Vault Client in the Autodesk Knowledge Base: \n               		  <a href=\"https://knowledge.autodesk.com/support/vault-products/troubleshooting/caas/sfdcarticles/sfdcarticles/System-requirements-for-Autodesk-Vault-products.html\" target=\"_blank\"> https://knowledge.autodesk.com/support/vault-products/troubleshooting/caas/sfdcarticles/sfdcarticles/System-requirements-for-Autodesk-Vault-products.html</a>. \n               		\n            </p>\n            <p>Also check requirements for each application required to run jobs on the processor.\n               \n               		<a name=\"UL_FEB00E17A1AA4C8EAA2A1ECADCB42484\"></a><ul>\n                  <li>Inventor: \n                     			 <a href=\"https://knowledge.autodesk.com/support/inventor-products/troubleshooting/caas/sfdcarticles/sfdcarticles/System-requirements-for-Autodesk-Inventor-Products.html\" target=\"_blank\">https://knowledge.autodesk.com/support/inventor-products/troubleshooting/caas/sfdcarticles/sfdcarticles/System-requirements-for-Autodesk-Inventor-Products.html</a> \n                  </li>\n                  <li>Revit: \n                     			 <a href=\"https://knowledge.autodesk.com/support/revit-products/troubleshooting/caas/sfdcarticles/sfdcarticles/System-requirements-for-Autodesk-Revit-products.html\" target=\"_blank\">https://knowledge.autodesk.com/support/revit-products/troubleshooting/caas/sfdcarticles/sfdcarticles/System-requirements-for-Autodesk-Revit-products.html</a> \n                  </li>\n               </ul> \n            </p> <a name=\"UL_0A2E312849E14D08AADD33C6CE99D7C7\"></a><p class=\"list-intro\">Can I install Job Processor on an end-user computer?</p>\n            <p>Yes, but Autodesk does not recommend this. Job Processor is a Vault Client installation\n               option and can be installed and run on any computer. But as Job Processor runs it\n               will open applications and use system resources. In the case of Inventor, it will\n               create and use temporary project files. For this reason Autodesk recommends installing\n               Job Processor on a dedicated computer. \n               		\n            </p> <a name=\"UL_961D7FCD93BE4F36AC19B8B57130E4CF\"></a><p class=\"list-intro\">Does Job processor use a license?</p>\n            <p>No, Job Processor doesn\'t require an Inventor license. \n               		\n            </p>\n            <p>For example, if the Job Processor performs Inventor DWF Publishing (InventorDwfPublishCount),\n               it will start Inventor and perform this type of job a set number of times before it\n               closes Inventor and restarts it. This way it does not start and stop Inventor each\n               time it performs one of these jobs. \n               		\n            </p>\n            <p>See: \n               		  <span class=\"char_link\"><a href=\"GUID-41C135C2-C437-45D3-9134-FD94CBDD6781.htm\">Configure Job Processor Use Limits for CAD Services</a></span>. \n               		\n            </p> <a name=\"UL_19D77EBFF22D40F5A08E342AFF9608FF\"></a><p class=\"list-intro\">How often does a Job Processor look for jobs?</p>\n            <p>This is configurable, but by default Job Processor checks for jobs every ten minutes.\n               \n               		\n            </p> <a name=\"UL_706074EB160A4BCF884344B7008894CA\"></a><p class=\"list-intro\">What sort of Jobs does Job Processor execute?</p>\n            <p> Job Processor is configured by default to create visualization files (DWF) and synchronize\n               properties. It can be configured to update revision tables and sync files with a supported\n               Autodesk cloud drive using Project Sync. It can also be extended to execute any number\n               of custom tasks. \n               		\n            </p> <a name=\"UL_50C1E6DDACBE4C56B31A1155039D04CA\"></a><p class=\"list-intro\">What sort of Monitoring is recommended?</p>\n            <p>Job Processor is intended to run silently in the background. Under normal conditions,\n               administrators should review the queue on a daily basis to look for specific failed\n               tasks to be resubmitted, or for poorly performing processors. \n               		\n            </p>\n            <p>See \n               		  <a href=\"http://underthehood-autodesk.typepad.com/blog/2015/09/monitor-your-job-processor.html\" target=\"_blank\">http://underthehood-autodesk.typepad.com/blog/2015/09/monitor-your-job-processor.html</a>. \n               		\n            </p> <a name=\"UL_4BB4D2444BEF4DC2B3BCF93774282181\"></a><p class=\"list-intro\">What software does Job Processor use?</p>\n            <ul>\n               <li>Inventor Server: For DWF creation of Inventor formats \n                  		  \n               </li>\n               <li>TrueView: For AutoCAD DWF creation \n                  		  \n               </li>\n               <li>Revit: For Revit file DWF creation \n                  		  \n               </li>\n               <li>MS Office 2013: For older Office file formats \n                  		  \n               </li>\n            </ul>\n            <p>Custom jobs may need additional applications. See the online help for complete job\n               type requirements. \n               		\n            </p> <a name=\"UL_000B2449862A4632BE5201111DA310B4\"></a><p class=\"list-intro\">How do I rerun a failed job?</p>\n            <p>Jobs that have failed can be resubmitted through the job queue. \n               		\n            </p> <a name=\"UL_0304B26FA7994EA5BFEEAD9F4A9CA072\"></a><p class=\"list-intro\">How do I automate Job Processor?</p>\n            <p>Job Processor can be set to start automatically as soon as your computer starts. This\n               is done in the Job Processor Settings dialog box. Some administrators set up Job Processor\n               so that it runs jobs at off-peak hours when there are additional licenses available.\n               This is usually done using scheduled tasks and batch files. \n               		\n            </p> <a name=\"UL_B5DF68B339284BE699A24B058ECD42EB\"></a><p class=\"list-intro\">Who should be logged into Job Processor?</p>\n            <p>The Windows user who has the credentials to run CAD applications on the computer.\n               \n               		\n            </p>\n            <p>A separate Vault user should be created where possible for running jobs with elevated\n               file permissions, because the Job processor user may need to edit released or locked\n               files to update properties. \n               		\n            </p> <a name=\"UL_A9478C5F0CA248F594D7A7185EBFCB9E\"></a><p class=\"list-intro\">Whose name appears on a new file version?</p>\n            <p>When Job Processor creates a new file version, the Vault user logged into Job Processor\n               at the time is added as the creator. \n               		\n            </p>\n            <p>With revision tables, you can choose to display the file details of the first released\n               version rather than the most recent. \n               		\n            </p> <a name=\"UL_93B8417ADC424A00BB3E4CDBDDB3B02C\"></a><p class=\"list-intro\">How long does the software take to process jobs?</p>\n            <p>This can vary greatly but individual jobs are usually completed in under a minute\n               depending on computer resources, file size and job type; overall time depends on the\n               number of jobs. \n               		\n            </p>\n            <p>To optimize performance, CAD applications are restarted after a set number of jobs.\n               This is configurable. \n               		\n            </p> <a name=\"UL_9350427F45FE42448E69669463465F5B\"></a><p class=\"list-intro\">Will Job Processor migrate a file to the latest software version?</p>\n            <p>Yes, if you create a new version of the file, it will be migrated to the software\n               version executing the job. \n               		\n            </p> <a name=\"UL_C310CC7778C5453B85CB0A2AA5D19ED2\"></a><p class=\"list-intro\">What happens if Job Processor does not have the right software? </p>\n            <p>The job type is disabled, and will not run on that computer. Jobs can be manually\n               disabled or configured using the \n               		  <span class=\"filePath\">JobProcessor.exe.config</span> file found at \n               		  <span class=\"filePath\">C:\\Program Files\\Autodesk\\Vault XXXX\\Explorer\\</span>. \n               		\n            </p> <a name=\"UL_2BF79CE4C9C84948965D6304318E976F\"></a><p class=\"list-intro\">What happens if Job Processor does not have the right software version?</p>\n            <p>The job fails if the file cannot be opened (for example an Inventor 2017 file in Inventor\n               2016). \n               		\n            </p> <a name=\"UL_2F611FAECB194BD392F5A96E2339951E\"></a><p class=\"list-intro\">What Should I do if processing is slow?</p>\n            <p>If you are running a high volume of jobs and are experiencing reduced performance,\n               try the following: \n               		\n            </p>\n            <ul>\n               <li> Use more than one Job Processor. \n                  		\n               </li>\n               <li>Set up one computer to process sync properties and another to create DWF files. \n                  		\n               </li>\n            </ul> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_057106CC407D4252BE2B135916F5A79F\"></a> \n            <h2><a name=\"GUID-B2A62943-8AC8-4DC7-A884-3AC24FD44DF7\"></a>Troubleshooting Job Processor\n            </h2> <a name=\"UL_003D7CFEA0304AE79D853E6B4EAC0593\"></a><p class=\"list-intro\">Corrupt installation</p>\n            <p>From Windows Control Panel, repair or uninstall and reinstall the software. \n               		\n            </p> <a name=\"UL_F3C532EA37494DF2A0CC191D04D7A87F\"></a><p class=\"list-intro\">Make sure proper licensing is configured</p>\n            <p>If the processing software requires a license, make sure that it can obtain one. \n               		\n            </p> <a name=\"UL_68054E0EA6B7423E97A3FFA551A70E30\"></a><p class=\"list-intro\">Unable to process a file type</p>\n            <p>Make sure you have the appropriate software for the file format you need to work with.\n               \n               		\n            </p>\n            <ul>\n               <li>Creo process PTC files. \n                  		\n               </li>\n               <li>Other applications process their native formats; these include Revit and SOLIDWORKS.\n                  \n                  		\n               </li>\n               <li>The Vault Enterprise Add-In can be configured to process formats such as CATV5Product,\n                  IGES, JT, PDF, STEP, Flat Pattern DXF using Publish Jobs. \n                  		\n               </li>\n            </ul> <a name=\"UL_69088ADFF20647E8932D6B9604A19651\"></a><p class=\"list-intro\">Install the latest service packs</p>\n            <p>Some errors can be fixed by installing the latest service packs for both the Processing\n               Software and the Vault Client. \n               		\n            </p> <a name=\"UL_B6B99037D3634EBC9958F2E9E2D9BB23\"></a><p class=\"list-intro\">Job Processor does not respond</p>\n            <p>Restart Job Processor. If necessary, stop the process in Task Manager, or restart\n               Windows. If a DWF publish is not working, try opening the same file on Job Processor,\n               and export the DWF to the local disk manually. If problems persist, reinstall or repair\n               the installation. \n               		\n            </p> <a name=\"UL_1DF5C542BA124B4DBCD4CA0B104081D4\"></a><p class=\"list-intro\">Software not registered with Windows </p>\n            <p>Log into the Job Processor computer, start the software, then close it. Check for\n               any error message displayed and troubleshoot them by searching the internet for more\n               information. \n               		\n            </p> <a name=\"UL_44C5D7826A8F4F56BD7FC8F099F96C5A\"></a><p class=\"list-intro\">Insufficient user privileges</p>\n            <p>The user account used by Job Processor needs to have sufficient privileges to perform\n               the action required of it. For example, if file properties need updating when a file\n               is moved from “Work in Progress” to “Released,” the account must have the privileges\n               needed to edit file properties. Check the lifecycle definitions for that category\n               and the account being used by Job Processor. \n               		\n            </p> <a name=\"UL_DE464A58D06B45CA9B3E6836002E9FBB\"></a><p class=\"list-intro\">Corrupt file errors </p>\n            <ul>\n               <li>There may be a problem with the file itself. \n                  		  \n               </li>\n               <li>Check that the file can be published manually from the application that originally\n                  generated it. The problem could be due to a setting used when publishing. \n                  		  \n               </li>\n            </ul> <a name=\"UL_6FDB49F35D944EE78D31E3084BC5D145\"></a><p class=\"list-intro\"> Job types not processed</p>\n            <p>Occasionally, Job Type parameters in Job Processor can be deselected; this might have\n               happened if the processing software became unregistered from the operating system.\n               To check, go to Job Processor &gt; Administration &gt; Job Types and see if the jobs you\n               are expecting to be processed on that computer are selected. \n               		\n            </p> <a name=\"UL_87F09C0F24CD4A249B33EB07D6F48FA4\"></a><p class=\"list-intro\">Removing job types</p>\n            <p>If you have been adding or modifying custom job types using the Lifecycle Event Editor,\n               you might want to check and remove any bad job handlers or unwanted actions. See this\n               article: \n               		  <a href=\"https://knowledge.autodesk.com/community/screencast/33b04381-421c-4fa9-a37c-11f05ee2a4fc\" target=\"_blank\">https://knowledge.autodesk.com/community/screencast/33b04381-421c-4fa9-a37c-11f05ee2a4fc</a>. \n               		\n            </p>\n            <p>For more details on adjusting DWF output, see \n               		  <a href=\"http://crackingthevault.typepad.com/crackingthevault/2009/11/dwf-creation-fine-tuning.html\" target=\"_blank\">DWF Creation - Fine Tuning</a>. \n               		\n            </p> <a name=\"UL_898F9C1DC53A40F69D21267C0563D071\"></a><p class=\"list-intro\">Steps to take when jobs are not being processed or are receiving errors</p>\n            <ul>\n               <li>Log into Vault Client and make sure that Job Processor is enabled for the server you\n                  are logged into. \n                  		  \n               </li>\n               <li>Log into Vault Client and make sure that you can see jobs in the queue. \n                  		  \n               </li>\n               <li>Look through the queue for jobs with failed results and identify specific error messages\n                  and processors failing. \n                  		  \n               </li>\n            </ul> <a name=\"UL_6CBE979595F24F31ABD7AB0FE4383AB9\"></a><p class=\"list-intro\">Steps to troubleshoot Job Processor</p>\n            <ul>\n               <li>Log into Job Processor, stop the processor and restart, then see if jobs resume correctly.\n                  \n                  		  \n               </li>\n               <li>Make sure that there are licenses available for Job Processor by manually logging\n                  out and into the Job Processor utility. \n                  		  \n               </li>\n               <li>Use Task Manager to manually stop Job Processor processes: JobProcessor.exe and Connectivity.JobProcessor.Delegate.Host.exe.\n                  Restart Job Processor. \n                  		  \n               </li>\n               <li>Use Task Manager to manually stop any CAD applications being run silently on Job Processor,\n                  then resubmit the job. \n                  		  \n               </li>\n               <li>Run all CAD applications on Job Processor to make sure there are no problems with\n                  the installations. \n                  		  \n               </li>\n               <li>Manually complete “create DWF” tasks in Inventor, TrueView or Revit to make sure they\n                  complete correctly. \n                  		  \n               </li>\n               <li>In Vault Client on the Job Processor computer, try to manually update the view to\n                  see if it can create a DWF. (This process bypasses Job Processor.) \n                  		  \n               </li>\n               <li>Restart Job Processor to resolve issues with updates, background processes, or crashes.\n                  \n                  		  \n               </li>\n               <li>Make sure the operating system and any relevant software on the Job Processor computer\n                  is up to date with latest service packs and fixes. \n                  		  \n               </li>\n               <li>Empty the temporary folder on Job Processor (%temp%). \n                  		  \n               </li>\n               <li>Temporarily disable virus and firewall controls to see if the error persists. \n                  		  \n               </li>\n               <li>Enable Job Processor on another computer and see if errors continue. \n                  		  \n               </li>\n               <li>Log onto the Job Processor computer as a different Windows user to see if Windows-based\n                  permissions or user profile corruption is the problem. \n                  		  \n               </li>\n               <li>Log onto Job Processor as a different Vault user to see if this relates to Vault user\n                  permissions or access. \n                  		  \n               </li>\n               <li>Run a software repair on components used to run failed jobs (such as Inventor, TrueView,\n                  Revit and so on.) \n                  		  \n               </li>\n               <li>Run a software repair on Vault Client. \n                  		  \n               </li>\n               <li>If you find that Job Processor stops responding when working with large files, try\n                  changing time-out settings in the configuration file. \n                  		  \n               </li>\n            </ul> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_4058AAC51AE64D98B0822B1278D465A9\"></a> \n            <h2><a name=\"GUID-314F1AC8-C83E-40DC-8A2C-3B3CDD9E2928\"></a>View Job Processor Logs\n            </h2> \n            <p>If errors persist despite troubleshooting, refer to this information on error logging\n               and potential fixes. \n               		\n            </p> <a name=\"UL_82AE547E5216478C815481F31B88C8B9\"></a><p class=\"list-intro\">Access error details</p>\n            <ul>\n               <li>AVFS logs: The File Server logs any failed tasks here. \n                  		  \n               </li>\n               <li>Job Queue: From any Vault Client connected to AVFS, select Tools &gt; Job Queue to see\n                  job details. \n                  		  \n               </li>\n               <li>Event Viewer: Job Processor logs all jobs in the Event viewer Application log on the\n                  computer. This can be useful when troubleshooting failed or incomplete jobs. \n                  		  \n               </li>\n               <li>Process logs: \n                  			 <span class=\"filePath\">C:\\%appdata%\\Autodesk\\Autodesk Vault Job Processor\\JobProcessor.log</span>. \n                  		  \n               </li>\n            </ul> <a name=\"UL_0FA0B07F7012481B94E88AB5AD1F3A59\"></a><p class=\"list-intro\">Enable Verbose Logging</p>\n            <p>Locate the \n               		  <span class=\"filePath\">JobProcessor.exe.config</span> file. For example, for Vault Professional 2021, by default this is in \n               		  <span class=\"filePath\">C:\\Program Files\\Autodesk\\Vault Professional 2021\\Explorer</span>. This location will be different if you are using Vault Workgroup, or a different\n               release of Vault client. \n               		\n            </p>\n            <ul>\n               <li>Copy JobProcessor.exe.config before editing it. \n                  		\n               </li>\n               <li>Open JobProcessor.exe.config in Notepad. \n                  		\n               </li>\n               <li>Find the following section and the text &lt;add key=\"LogLevel\" value=\"0\" /&gt;. \n                  		\n               </li>\n               <li>Change the log level from 0 to 1. \n                  		\n               </li>\n            </ul>\n            <p> \n               <div class=\"codeBlock\"><pre class=\"prettyprint\">     &lt;!--\n    0 This is generally something that might be meaningful to a user if they saw it in log file. It can help the user to know every jobs status.\n    1 This is generally something that might be meaningful to a developer if they saw it in the log file. It can help the developer to diagnose the detailed issues.\n    Default is 0\n    --&gt;\n    &lt;add key=\"LogLevel\" value=\"0\" /&gt;\n    &lt;!--The minimum of InventorUpdateRevBlockReleasePeriodInMinutes value is 5 minutes--&gt;\n    &lt;add key=\"InventorUpdateRevBlockReleasePeriodInMinutes\" value=\"10\" /&gt;\n    &lt;!--The minimum of InventorDwfPublishReleasePeriodInMinutes value is 5 minutes--&gt;\n    &lt;add key=\"InventorDwfPublishReleasePeriodInMinutes\" value=\"10\" /&gt;\n    &lt;!--The minimum of TrueViewDwfPublishReleasePeriodInMinutes value is 5 minutes--&gt;\n    &lt;add key=\"TrueViewDwfPublishReleasePeriodInMinutes\" value=\"10\" /&gt;\n    &lt;add key=\"DataManagement.Common.Logging.ApplicationName\" value=\"JobProcessor\" /&gt;\n    &lt;add key=\"DataManagement.Common.Logging.Enabled\" value=\"True\" /&gt;\n    &lt;add key=\"DataManagement.Common.Logging.ServiceMachine\" value=\".\" /&gt;\n    &lt;add key=\"DataManagement.Common.Logging.LogFile\" value=\"\" /&gt;\n    &lt;add key=\"DataManagement.Common.Logging.SerializeProperties\" value=\"False\" /&gt;\n    &lt;add key=\"DataManagement.Common.Logging.Viewer.Path\" value=\"H:\\Common\\Logging\\LoggingBin\\MessageViewer\\DataManagement.Common.Messaging.Viewer.exe\" /&gt;\n    &lt;add key=\"DataManagement.Common.Logging.Viewer.AcceptLocalMessageOnly\" value=\"True\" /&gt;\n    &lt;add key=\"DataManagement.Common.Logging.Viewer.Port\" value=\"8080\" /&gt;\n    &lt;add key=\"DataManagement.Common.Logging.Viewer.AutoLaunch\" value=\"False\" /&gt; \n</pre></div> \n            </p>\n            <p>Once the value has been changed to 1, save the JobProcessor.exe.config file and then\n               restart Job Processor. \n               		\n            </p>\n            <p>When Job Processor processes a new job, information will be inserted in the JobProcessor.log\n               file. \n               		\n            </p>\n            <p>Also, more verbose information will be posted into JobProcessorJobActivity.log. \n               		\n            </p>\n            <p>Review the new information in both new files. \n               		\n            </p> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_8DA01F08D8A14A7A8E3D31ED62EDD7CA\"></a> \n            <h2><a name=\"GUID-ACE10093-5AF3-42FE-BA21-F98A68F23EDE\"></a>Error Reference\n            </h2> <a name=\"UL_F83F0FA3378D4D1A8215D7CD76C98F64\"></a><p class=\"list-intro\">\"Unknown Error During Publish\"</p>\n            <p>This can have a number of causes. When this happens with specific files, open the\n               affected file manually and try to save to a new file and recreate the failed task\n               (for example, create DWF). \n               		\n            </p>\n            <p>Possible causes: \n               		\n            </p>\n            <ul>\n               <li>Missing references \n                  		\n               </li>\n               <li>Model corruption \n                  		\n               </li>\n               <li>Data not migrated \n                  		\n               </li>\n               <li>Missing links or applications on Job Processor \n                  		\n               </li>\n            </ul> <a name=\"UL_B81D855A9C224A0F93C586BFD510B2BB\"></a><p class=\"list-intro\">\"Unable to retrieve File version for id xxxxxxx\" or “An error occurred while attempting\n               to retrieve a file.”\n            </p>\n            <p>This happens when a job is created for a certain file, but the file is removed from\n               Vault (for example, deleted) before the job could be executed. \n               		\n            </p> <a name=\"UL_BC79B29B3FCB4133B802E73224091B2F\"></a><p class=\"list-intro\">\"Index (zero based) must be greater than or equal to zero and less than the size of\n               the argument list.\"\n            </p>\n            <p>This can be a result of the DWF attached to the file being updated being locked (for\n               example, checked out or in use). To resolve, try the following: \n               		\n            </p>\n            <ul>\n               <li>Contact the user and tell them to check the file back in, then resubmit the job. \n                  		\n               </li>\n               <li>Log in as Administrator, remove the reservation on the file, then resubmit the job.\n                  \n                  		\n               </li>\n               <li>Delete the DWF from the Vault, then resubmit the job (this will lose version history).\n                  \n                  		\n               </li>\n            </ul> <a name=\"UL_0CC8B42409264D8A9F17F0DDEF0E96F7\"></a><p class=\"list-intro\">\"The new Job Processor service is not responding.\"</p>\n            <p>This error occurs if \n               		  <span class=\"filePath\">JobProcessor.exe</span> or \n               		  <span class=\"filePath\">Connectivity.JobProcessor.Delegate.Host.exe</span> stops responding. You will need to log into the computer and do one of the following:\n               \n               		\n            </p>\n            <ul>\n               <li> Exit Job Processor and restart it; or, \n                  		\n               </li>\n               <li>Kill both processes in Task Manager and restart Job Processor. \n                  		\n               </li>\n            </ul> <a name=\"UL_A7B27B7B248547C3A525122E98196993\"></a><p class=\"list-intro\">\"This file is only available from the following sites which are not accessible at\n               this time:\"\n            </p>\n            <p>This can be caused by an interruption in network connectivity between the ADMS and\n               AVFS servers. \n               		\n            </p>\n            <p>This could also occur if the AVFS computer was restarted or suffered a power outage.\n               \n               		\n            </p>\n            <p>Resubmitting the Job once communication between ADMS and AVFS is restored should resolve\n               the issue. \n               		\n            </p> <a name=\"UL_4E671ADBB2564DDEB7CDEBE03E53D99B\"></a><p class=\"list-intro\">\"File Locked;\"</p>\n            <p>This Job Processor error can occur if a user tries to execute a task on a file, such\n               as Synchronize Property, but the file is locked to the Job Processor user account.\n               \n               		\n            </p> <a name=\"UL_541D5248531B4377AC03165C43DC4196\"></a><p class=\"list-intro\">\"Sync properties not allowed on non-tip versions\"</p>\n            <p>This error indicates that a new version of this file was created before the job could\n               be completed. This can happen if a user changes the state on a file, for example from\n               “work in progress” to “in review.” Administrators can ignore, delete, or filter out\n               this type of error. \n               		\n            </p> <a name=\"UL_18D556E8A206453C8AB77FCCC8885777\"></a><p class=\"list-intro\">Lack of adequate permissions</p>\n            <p>There are a number of permission issues that can prevent access to edit a file (object-\n               and state-based security). Recheck user access to specific CAD or visualization files,\n               or log into Job Processor as a user with elevated privileges. Note that Job Processor\n               cannot update locked visualization files. \n               		\n            </p> <a name=\"UL_E921EA653CEF4EB6B405055182E05C8E\"></a><p class=\"list-intro\">Non-Unique Visualization files</p>\n            <p>If you have “enforce unique file names” enabled and there are existing duplicate visualization\n               files in Vault, Job Processor will not be allowed to check in updated visualization\n               files. \n               		\n            </p> <a name=\"UL_D064A9BECA4848F5806C08C47C19C69C\"></a><p class=\"list-intro\">Login Failed</p>\n            <p>This can happen if Job Processor cannot access a Vault license (all licenses might\n               be use). In this case users will need to make sure licenses are available and manually\n               log in through the Job Processor client again. \n               		\n            </p> <a name=\"UL_D98ED06BB9AB4BEB91F3AFFF2DBAC842\"></a><p class=\"list-intro\">\"User is not of the correct Auth type\"</p>\n            <p>The Job Processor does not have the correct permissions to execute a specific job.\n               \n               		\n            </p> <a name=\"UL_377B349CF874462D9C99481BF2D1E870\"></a><p class=\"list-intro\">\"A visualization file cannot be generated for a non cad file”</p>\n            <p>This might occur when a virus scanner is running on the Job Processor computer. Test\n               with the virus scanner disabled, and add Autodesk products to the exceptions list.\n               \n               		\n            </p> <a name=\"UL_03D8CDB0E7DA41128B58B7E3AAC3BC47\"></a><p class=\"list-intro\">\"Retrieving the COM class factory for component with CLSID {C343ED84-A129-11D3-B799-0060B0F159EF}\n               failed due to the following error: 8007045a A dynamic link library (DLL) initialization\n               routine failed. (Exception from HRESULT: 0x8007045A).\"\n            </p>\n            <p>This can occur when checking in an IPT file linked to a DWG. It occurs when the process\n               \n               		  <span class=\"filePath\">Connectivity.WindowsService.JobDispath.exe</span> is started before the process \n               		  <span class=\"filePath\">Connectivity.JobProcessor.Delegate.Host.exe</span>. \n               		\n            </p>\n            <p>To resolve this, start Vault Client as the first process, update the file view with\n               Job Processor, and add one or more jobs to the Job Queue. Start Job Processor. \n               		\n            </p> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_A12C5254228241B49AD64A9891C7B8B3\"></a> \n            <h2><a name=\"GUID-97E6B600-2CFD-47D3-A7EF-E81784C1E820\"></a>Appendix\n            </h2> <a name=\"UL_842015A3C6E447DEBE0E3CDC9D2E4DAE\"></a><p class=\"list-intro\">Batch file to start Job Processor from the command line:</p>\n            <p>See: \n               		  <span class=\"char_link\"><a href=\"GUID-2D6ACAFC-7B43-4D0D-8A03-1D2B06F056DA.htm\">Job Processor Command Line</a></span> \n               <div class=\"codeBlock\"><pre class=\"prettyprint\">REM start Job Processor\nstart JobProcessor.exe\nREM prevents Job Processor from processing any more jobs on its queue after finishing its current job\nJobProcessor.exe /pause\nREM allows Job Processor to continue processing jobs on its queue from a paused state\nJobProcessor.exe /resume\nREM stops and exits Job Processor after finishing its current job\nJobProcessor.exe /stop\n</pre></div> \n            </p>\n            <p>You can also use command line arguments, in combination with a scheduled task and\n               powershell, to restart JobProcessor.exe every few hours on the VM. \n               		  \n               <div class=\"codeBlock\"><pre class=\"prettyprint\"># === powershell.ps1 script ===\n&amp; \"C:\\Program Files\\Autodesk\\Vault Professional 2021\\Explorer\\JobProcessor.exe\" /stop\nWait-Process JobProcessor\n&amp; \"C:\\Program Files\\Autodesk\\Vault Professional 2021\\Explorer\\JobProcessor.exe\"\n# === powershell.ps1 script ===\n</pre></div> \n            </p>\n            <p>The \n               		  <span class=\"code\">/stop</span> command will finish the current job then exit Job Processor (releasing Inventor\'s\n               resources). \n               		\n            </p>\n            <p>See this article on how to do this with Vault 2013 Professional: \n               		  <a href=\"http://justonesandzeros.typepad.com/blog/2012/10/job-processor-command-line-tricks.html\" target=\"_blank\">http://justonesandzeros.typepad.com/blog/2012/10/job-processor-command-line-tricks.html</a>. \n               		\n            </p> <a name=\"UL_1CA359FD8DEB489CB8D38BBA2CFD130F\"></a><p class=\"list-intro\">Job Processor configuration file time out settings</p>\n            <p><span class=\"filePath\">C:\\Program Files\\autodesk\\autodesk vault xxxx\\explorer\\JobProcessor.exe.config</span> \n               <div class=\"codeBlock\"><pre class=\"prettyprint\">&lt;add key=\"PeriodInMinutes\" value=\"10\" /&gt;\n    &lt;!-- WebService timeout (in milliseconds)--&gt;\n    &lt;add key=\"WebServiceTimeout\" value=\"1000000\" /&gt;\n    &lt;!-- 1000 secs = 1000000 milli --&gt;\n    &lt;!-- RequestSendTimeout (in minutes)--&gt;\n    &lt;add key=\"RequestSendTimeout\" value=\"90\" /&gt;\n    &lt;!-- RequestReceiveTimeout (in minutes)--&gt;\n    &lt;add key=\"RequestReceiveTimeout\" value=\"90\" /&gt;\n    &lt;!-- HostServiceSendTimeout (in minutes)--&gt;\n    &lt;add key=\"HostServiceSendTimeout\" value=\"10\" /&gt;\n    &lt;!-- HostServiceReceiveTimeout timeout (in minutes)--&gt;\n    &lt;add key=\"HostServiceReceiveTimeout\" value=\"90\" /&gt;\n    &lt;!-- PingTimeout timeout (in seconds)--&gt;\n    &lt;add key=\"PingTimeout\" value=\"30\" /&gt;\n</pre></div> \n            </p> <a name=\"UL_8989F37E754C458DA51AE89B717D9B75\"></a><p class=\"list-intro\">Job Processor configuration application cycles</p>\n            <p> \n               <div class=\"codeBlock\"><pre class=\"prettyprint\">    &lt;add key=\"UpdateRevBlockMigrateLatestINV\" value=\"0\" /&gt;\n    &lt;add key=\"InventorUpdateRevBlockCount\" value=\"100\" /&gt;\n    &lt;add key=\"InventorDwfPublishCount\" value=\"100\" /&gt;\n    &lt;add key=\"TrueViewDwfPublishCount\" value=\"500\" /&gt;\n</pre></div> \n            </p> \n         </div>\n         <div class=\"footer-block\"><a href=\"..\" class=\"comments-anchor\" target=\"_blank\"><span class=\"comments-link\">Please send us your comment about this page</span></a></div><br><p class=\"footer-license-block\"><a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\"><img alt=\"Creative Commons License\" style=\"border-width: 0;\" src=\"../images/ccLink.png\"></a>&nbsp;<em>Except where otherwise noted, this work is licensed under a <a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\">Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License</a>. Please see the <a href=\"http://autodesk.com/creativecommons\" target=\"_blank\">Autodesk Creative Commons FAQ</a> for more information.</em></p><br></div>\n   </body>\n</html>";
// SIG // Begin signature block
// SIG // MIIbRQYJKoZIhvcNAQcCoIIbNjCCGzICAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // BPL/1YOTaQ7DMpqtGHD5XhuZ3xLdsyFdOlowPmQW9geg
// SIG // ggoaMIIEyzCCA7OgAwIBAgIQCQja65wGHi65un4mqmKH
// SIG // ijANBgkqhkiG9w0BAQsFADCBhDELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTUw
// SIG // MwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
// SIG // b2RlIFNpZ25pbmcgQ0EgLSBHMjAeFw0xOTA1MTQwMDAw
// SIG // MDBaFw0yMDA1MTMyMzU5NTlaMHwxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIDApDYWxpZm9ybmlhMRMwEQYDVQQHDApT
// SIG // YW4gUmFmYWVsMRcwFQYDVQQKDA5BdXRvZGVzaywgSW5j
// SIG // LjERMA8GA1UECwwIU2VjdXJpdHkxFzAVBgNVBAMMDkF1
// SIG // dG9kZXNrLCBJbmMuMIIBIjANBgkqhkiG9w0BAQEFAAOC
// SIG // AQ8AMIIBCgKCAQEAkVKRoPYsoxPdlabspcuG8HYDfcWQ
// SIG // 9qyPOT2punwpVdjt2slktcpSTlydrGy8ijcbl5/k8AOJ
// SIG // afKMQvow0fNjIoNB5nsb8j2xFJPbBhHl8GT4P6DZ1OWK
// SIG // ioiUXgGHKjctUws49J4elntqvBYhKCbuPqG772QCoYFU
// SIG // P7qcFbh3PbyNB6cnKMn2vNGRqiEtV2aGg+/MiL3QPsvT
// SIG // kTWhVuTLIvwZ4kK5C5ACiQzlGOlE+C7gWuFoxtvy6gUa
// SIG // A8JAq/xLjYKwFevQwGncg3s1cuiGhx0P7Rvn6oCd2cem
// SIG // FmbK3I3rMRt+jc9wzAj3oHxvCo4f5Lfva+OpC1dETUVV
// SIG // sk0VGwIDAQABo4IBPjCCATowCQYDVR0TBAIwADAOBgNV
// SIG // HQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMw
// SIG // YQYDVR0gBFowWDBWBgZngQwBBAEwTDAjBggrBgEFBQcC
// SIG // ARYXaHR0cHM6Ly9kLnN5bWNiLmNvbS9jcHMwJQYIKwYB
// SIG // BQUHAgIwGQwXaHR0cHM6Ly9kLnN5bWNiLmNvbS9ycGEw
// SIG // HwYDVR0jBBgwFoAU1MAGIknrOUvdk+JcobhHdglyA1gw
// SIG // KwYDVR0fBCQwIjAgoB6gHIYaaHR0cDovL3JiLnN5bWNi
// SIG // LmNvbS9yYi5jcmwwVwYIKwYBBQUHAQEESzBJMB8GCCsG
// SIG // AQUFBzABhhNodHRwOi8vcmIuc3ltY2QuY29tMCYGCCsG
// SIG // AQUFBzAChhpodHRwOi8vcmIuc3ltY2IuY29tL3JiLmNy
// SIG // dDANBgkqhkiG9w0BAQsFAAOCAQEA0Q2+iVSEfT4xGq3A
// SIG // OADVb0rT5Z8E+PPb1x6hKknSzuaZKk/acDz9mdnFajaU
// SIG // WgIKiFJlsqJnuAM1w4lqKaEWsz3DoxvGIEwexj71Ud6a
// SIG // KlBJNcR9DdkXUZwMhbw9d78rjJAIX6tOwfSludZfdq8b
// SIG // YEkuIzQi9uYW9vHVPSCzhnUBKjwc9qTo9yBc7Fcn4FAT
// SIG // 90DzWM2hS9oc3p0pprYI2I/O4th90BEmwWkVqVgfaR0z
// SIG // VyIEmBbqB/IWLfjUBZJ/8sbkwWuWlYVRrfPxsj1e9qvb
// SIG // wE3Y28jWyGbqoUG39GhXk3uT8R8i3+T6M0c4rMfdifBC
// SIG // pceCaFTJzSye7LoeVzCCBUcwggQvoAMCAQICEHwbNTVK
// SIG // 59t050FfEWnKa6gwDQYJKoZIhvcNAQELBQAwgb0xCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjEfMB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29y
// SIG // azE6MDgGA1UECxMxKGMpIDIwMDggVmVyaVNpZ24sIElu
// SIG // Yy4gLSBGb3IgYXV0aG9yaXplZCB1c2Ugb25seTE4MDYG
// SIG // A1UEAxMvVmVyaVNpZ24gVW5pdmVyc2FsIFJvb3QgQ2Vy
// SIG // dGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMTQwNzIyMDAw
// SIG // MDAwWhcNMjQwNzIxMjM1OTU5WjCBhDELMAkGA1UEBhMC
// SIG // VVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9u
// SIG // MR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3Jr
// SIG // MTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1
// SIG // NiBDb2RlIFNpZ25pbmcgQ0EgLSBHMjCCASIwDQYJKoZI
// SIG // hvcNAQEBBQADggEPADCCAQoCggEBANeVQ9Tc32euOftS
// SIG // pLYmMQRw6beOWyq6N2k1lY+7wDDnhthzu9/r0XY/ilaO
// SIG // 6y1L8FcYTrGNpTPTC3Uj1Wp5J92j0/cOh2W13q0c8fU1
// SIG // tCJRryKhwV1LkH/AWU6rnXmpAtceSbE7TYf+wnirv+9S
// SIG // rpyvCNk55ZpRPmlfMBBOcWNsWOHwIDMbD3S+W8sS4duM
// SIG // xICUcrv2RZqewSUL+6McntimCXBx7MBHTI99w94Zzj7u
// SIG // BHKOF9P/8LIFMhlM07Acn/6leCBCcEGwJoxvAMg6ABFB
// SIG // ekGwp4qRBKCZePR3tPNgKuZsUAS3FGD/DVH0qIuE/iHa
// SIG // XF599Sl5T7BEdG9tcv8CAwEAAaOCAXgwggF0MC4GCCsG
// SIG // AQUFBwEBBCIwIDAeBggrBgEFBQcwAYYSaHR0cDovL3Mu
// SIG // c3ltY2QuY29tMBIGA1UdEwEB/wQIMAYBAf8CAQAwZgYD
// SIG // VR0gBF8wXTBbBgtghkgBhvhFAQcXAzBMMCMGCCsGAQUF
// SIG // BwIBFhdodHRwczovL2Quc3ltY2IuY29tL2NwczAlBggr
// SIG // BgEFBQcCAjAZGhdodHRwczovL2Quc3ltY2IuY29tL3Jw
// SIG // YTA2BgNVHR8ELzAtMCugKaAnhiVodHRwOi8vcy5zeW1j
// SIG // Yi5jb20vdW5pdmVyc2FsLXJvb3QuY3JsMBMGA1UdJQQM
// SIG // MAoGCCsGAQUFBwMDMA4GA1UdDwEB/wQEAwIBBjApBgNV
// SIG // HREEIjAgpB4wHDEaMBgGA1UEAxMRU3ltYW50ZWNQS0kt
// SIG // MS03MjQwHQYDVR0OBBYEFNTABiJJ6zlL3ZPiXKG4R3YJ
// SIG // cgNYMB8GA1UdIwQYMBaAFLZ3+mlIR59TEtXC6gcydgfR
// SIG // lwcZMA0GCSqGSIb3DQEBCwUAA4IBAQB/68qn6ot2Qus+
// SIG // jiBUMOO3udz6SD4Wxw9FlRDNJ4ajZvMC7XH4qsJVl5Fw
// SIG // g/lSflJpPMnx4JRGgBi7odSkVqbzHQCR1YbzSIfgy8Q0
// SIG // aCBetMv5Be2cr3BTJ7noPn5RoGlxi9xR7YA6JTKfRK9u
// SIG // QyjTIXW7l9iLi4z+qQRGBIX3FZxLEY3ELBf+1W5/muJW
// SIG // kvGWs60t+fTf2omZzrI4RMD3R3vKJbn6Kmgzm1By3qif
// SIG // 1M0sCzS9izB4QOCNjicbkG8avggVgV3rL+JR51EeyXgp
// SIG // 5x5lvzjvAUoBCSQOFsQUecFBNzTQPZFSlJ3haO8I8OJp
// SIG // nGdukAsak3HUJgLDwFojMYIQgzCCEH8CAQEwgZkwgYQx
// SIG // CzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRlYyBD
// SIG // b3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1
// SIG // c3QgTmV0d29yazE1MDMGA1UEAxMsU3ltYW50ZWMgQ2xh
// SIG // c3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENBIC0gRzIC
// SIG // EAkI2uucBh4uubp+Jqpih4owDQYJYIZIAWUDBAIBBQCg
// SIG // fDAQBgorBgEEAYI3AgEMMQIwADAZBgkqhkiG9w0BCQMx
// SIG // DAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4wDAYK
// SIG // KwYBBAGCNwIBFTAvBgkqhkiG9w0BCQQxIgQg1UMPtueq
// SIG // yWDbzU+BS6tz0ZC2UzDtm2bkpw8+JLdf7kAwDQYJKoZI
// SIG // hvcNAQEBBQAEggEAJWT5uNwkPdcdcGxFO8/5NvmZWAtj
// SIG // BBPMZKl3Vq5fh8u8tOZYZ+zCxMhY+EDiOeCwxL7qI3ZV
// SIG // TWvOcsJ0zJdDSPuoL7Q/WIHg/jGvQ3RuLZbScoOrmO55
// SIG // iDORdRpano1Zh9fGVW92MQYw4Qu3X81ASVV8rEsgFhLX
// SIG // 9IAyNLfvgDxp8UthU+PixQrLN/J6FMLNF1bQEmSj2l5j
// SIG // 2hz6FCBd1hG8etrXydjkA4PkSrjdMJPknWHTwdPoqbHD
// SIG // zPqWg0guhbFrstWcqOCr76fl+fSYd8A50mLCF9b5P5fI
// SIG // lxTDTUyguPZ4AS1KT+nwhmScCmDyb84+R3tKE0xSSKWu
// SIG // eFryEqGCDjwwgg44BgorBgEEAYI3AwMBMYIOKDCCDiQG
// SIG // CSqGSIb3DQEHAqCCDhUwgg4RAgEDMQ0wCwYJYIZIAWUD
// SIG // BAIBMIIBDgYLKoZIhvcNAQkQAQSggf4EgfswgfgCAQEG
// SIG // C2CGSAGG+EUBBxcDMDEwDQYJYIZIAWUDBAIBBQAEICYZ
// SIG // MlbymvpXlAibqqceTBqHZZucFw1RtJq2CFDB3EDKAhQY
// SIG // IxlpwkYnwN47Qh3Uapvg1jczJRgPMjAyMDAzMjMxNDA2
// SIG // NTZaMAMCAR6ggYakgYMwgYAxCzAJBgNVBAYTAlVTMR0w
// SIG // GwYDVQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlvbjEfMB0G
// SIG // A1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazExMC8G
// SIG // A1UEAxMoU3ltYW50ZWMgU0hBMjU2IFRpbWVTdGFtcGlu
// SIG // ZyBTaWduZXIgLSBHM6CCCoswggU4MIIEIKADAgECAhB7
// SIG // BbHUSWhRRPfJidKcGZ0SMA0GCSqGSIb3DQEBCwUAMIG9
// SIG // MQswCQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24s
// SIG // IEluYy4xHzAdBgNVBAsTFlZlcmlTaWduIFRydXN0IE5l
// SIG // dHdvcmsxOjA4BgNVBAsTMShjKSAyMDA4IFZlcmlTaWdu
// SIG // LCBJbmMuIC0gRm9yIGF1dGhvcml6ZWQgdXNlIG9ubHkx
// SIG // ODA2BgNVBAMTL1ZlcmlTaWduIFVuaXZlcnNhbCBSb290
// SIG // IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTE2MDEx
// SIG // MjAwMDAwMFoXDTMxMDExMTIzNTk1OVowdzELMAkGA1UE
// SIG // BhMCVVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0
// SIG // aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3
// SIG // b3JrMSgwJgYDVQQDEx9TeW1hbnRlYyBTSEEyNTYgVGlt
// SIG // ZVN0YW1waW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOC
// SIG // AQ8AMIIBCgKCAQEAu1mdWVVPnYxyXRqBoutV87ABrTxx
// SIG // rDKPBWuGmicAMpdqTclkFEspu8LZKbku7GOz4c8/C1aQ
// SIG // +GIbfuumB+Lef15tQDjUkQbnQXx5HMvLrRu/2JWR8/Du
// SIG // bPitljkuf8EnuHg5xYSl7e2vh47Ojcdt6tKYtTofHjmd
// SIG // w/SaqPSE4cTRfHHGBim0P+SDDSbDewg+TfkKtzNJ/8o7
// SIG // 1PWym0vhiJka9cDpMxTW38eA25Hu/rySV3J39M2ozP4J
// SIG // 9ZM3vpWIasXc9LFL1M7oCZFftYR5NYp4rBkyjyPBMkEb
// SIG // WQ6pPrHM+dYr77fY5NUdbRE6kvaTyZzjSO67Uw7UNpeG
// SIG // eMWhNwIDAQABo4IBdzCCAXMwDgYDVR0PAQH/BAQDAgEG
// SIG // MBIGA1UdEwEB/wQIMAYBAf8CAQAwZgYDVR0gBF8wXTBb
// SIG // BgtghkgBhvhFAQcXAzBMMCMGCCsGAQUFBwIBFhdodHRw
// SIG // czovL2Quc3ltY2IuY29tL2NwczAlBggrBgEFBQcCAjAZ
// SIG // GhdodHRwczovL2Quc3ltY2IuY29tL3JwYTAuBggrBgEF
// SIG // BQcBAQQiMCAwHgYIKwYBBQUHMAGGEmh0dHA6Ly9zLnN5
// SIG // bWNkLmNvbTA2BgNVHR8ELzAtMCugKaAnhiVodHRwOi8v
// SIG // cy5zeW1jYi5jb20vdW5pdmVyc2FsLXJvb3QuY3JsMBMG
// SIG // A1UdJQQMMAoGCCsGAQUFBwMIMCgGA1UdEQQhMB+kHTAb
// SIG // MRkwFwYDVQQDExBUaW1lU3RhbXAtMjA0OC0zMB0GA1Ud
// SIG // DgQWBBSvY9bKo06FcuCnvEHzKaI4f4B1YjAfBgNVHSME
// SIG // GDAWgBS2d/ppSEefUxLVwuoHMnYH0ZcHGTANBgkqhkiG
// SIG // 9w0BAQsFAAOCAQEAdeqwLdU0GVwyRf4O4dRPpnjBb9fq
// SIG // 3dxP86HIgYj3p48V5kApreZd9KLZVmSEcTAq3R5hF2Yg
// SIG // VgaYGY1dcfL4l7wJ/RyRR8ni6I0D+8yQL9YKbE4z7Na0
// SIG // k8hMkGNIOUAhxN3WbomYPLWYl+ipBrcJyY9TV0GQL+Ee
// SIG // TU7cyhB4bEJu8LbF+GFcUvVO9muN90p6vvPN/QPX2fYD
// SIG // qA/jU/cKdezGdS6qZoUEmbf4Blfhxg726K/a7JsYH6q5
// SIG // 4zoAv86KlMsB257HOLsPUqvR45QDYApNoP4nbRQy/D+X
// SIG // QOG/mYnb5DkUvdrk08PqK1qzlVhVBH3HmuwjA42FKtL/
// SIG // rqlhgTCCBUswggQzoAMCAQICEHvU5a+6zAc/oQEjBCJB
// SIG // TRIwDQYJKoZIhvcNAQELBQAwdzELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMSgw
// SIG // JgYDVQQDEx9TeW1hbnRlYyBTSEEyNTYgVGltZVN0YW1w
// SIG // aW5nIENBMB4XDTE3MTIyMzAwMDAwMFoXDTI5MDMyMjIz
// SIG // NTk1OVowgYAxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRT
// SIG // eW1hbnRlYyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3lt
// SIG // YW50ZWMgVHJ1c3QgTmV0d29yazExMC8GA1UEAxMoU3lt
// SIG // YW50ZWMgU0hBMjU2IFRpbWVTdGFtcGluZyBTaWduZXIg
// SIG // LSBHMzCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoC
// SIG // ggEBAK8Oiqr43L9pe1QXcUcJvY08gfh0FXdnkJz93k4C
// SIG // nkt29uU2PmXVJCBtMPndHYPpPydKM05tForkjUCNIqq+
// SIG // pwsb0ge2PLUaJCj4G3JRPcgJiCYIOvn6QyN1R3AMs19b
// SIG // jwgdckhXZU2vAjxA9/TdMjiTP+UspvNZI8uA3hNN+RDJ
// SIG // qgoYbFVhV9HxAizEtavybCPSnw0PGWythWJp/U6FwYpS
// SIG // Matb2Ml0UuNXbCK/VX9vygarP0q3InZl7Ow28paVgSYs
// SIG // /buYqgE4068lQJsJU/ApV4VYXuqFSEEhh+XetNMmsntA
// SIG // U1h5jlIxBk2UA0XEzjwD7LcA8joixbRv5e+wipsCAwEA
// SIG // AaOCAccwggHDMAwGA1UdEwEB/wQCMAAwZgYDVR0gBF8w
// SIG // XTBbBgtghkgBhvhFAQcXAzBMMCMGCCsGAQUFBwIBFhdo
// SIG // dHRwczovL2Quc3ltY2IuY29tL2NwczAlBggrBgEFBQcC
// SIG // AjAZGhdodHRwczovL2Quc3ltY2IuY29tL3JwYTBABgNV
// SIG // HR8EOTA3MDWgM6Axhi9odHRwOi8vdHMtY3JsLndzLnN5
// SIG // bWFudGVjLmNvbS9zaGEyNTYtdHNzLWNhLmNybDAWBgNV
// SIG // HSUBAf8EDDAKBggrBgEFBQcDCDAOBgNVHQ8BAf8EBAMC
// SIG // B4AwdwYIKwYBBQUHAQEEazBpMCoGCCsGAQUFBzABhh5o
// SIG // dHRwOi8vdHMtb2NzcC53cy5zeW1hbnRlYy5jb20wOwYI
// SIG // KwYBBQUHMAKGL2h0dHA6Ly90cy1haWEud3Muc3ltYW50
// SIG // ZWMuY29tL3NoYTI1Ni10c3MtY2EuY2VyMCgGA1UdEQQh
// SIG // MB+kHTAbMRkwFwYDVQQDExBUaW1lU3RhbXAtMjA0OC02
// SIG // MB0GA1UdDgQWBBSlEwGpn4XMG24WHl87Map5NgB7HTAf
// SIG // BgNVHSMEGDAWgBSvY9bKo06FcuCnvEHzKaI4f4B1YjAN
// SIG // BgkqhkiG9w0BAQsFAAOCAQEARp6v8LiiX6KZSM+oJ0sh
// SIG // zbK5pnJwYy/jVSl7OUZO535lBliLvFeKkg0I2BC6NiT6
// SIG // Cnv7O9Niv0qUFeaC24pUbf8o/mfPcT/mMwnZolkQ9B5K
// SIG // /mXM3tRr41IpdQBKK6XMy5voqU33tBdZkkHDtz+G5vbA
// SIG // f0Q8RlwXWuOkO9VpJtUhfeGAZ35irLdOLhWa5Zwjr1sR
// SIG // 6nGpQfkNeTipoQ3PtLHaPpp6xyLFdM3fRwmGxPyRJbIb
// SIG // lumFCOjd6nRgbmClVnoNyERY3Ob5SBSe5b/eAL13sZgU
// SIG // chQk38cRLB8AP8NLFMZnHMweBqOQX1xUiz7jM1uCD8W3
// SIG // hgJOcZ/pZkU/djGCAlowggJWAgEBMIGLMHcxCzAJBgNV
// SIG // BAYTAlVTMR0wGwYDVQQKExRTeW1hbnRlYyBDb3Jwb3Jh
// SIG // dGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0
// SIG // d29yazEoMCYGA1UEAxMfU3ltYW50ZWMgU0hBMjU2IFRp
// SIG // bWVTdGFtcGluZyBDQQIQe9Tlr7rMBz+hASMEIkFNEjAL
// SIG // BglghkgBZQMEAgGggaQwGgYJKoZIhvcNAQkDMQ0GCyqG
// SIG // SIb3DQEJEAEEMBwGCSqGSIb3DQEJBTEPFw0yMDAzMjMx
// SIG // NDA2NTZaMC8GCSqGSIb3DQEJBDEiBCCEUDbP/Aj6LBne
// SIG // fyeiyM1z2RCzNvgyou4rUN6hdLYF4TA3BgsqhkiG9w0B
// SIG // CRACLzEoMCYwJDAiBCDEdM52AH0COU4NpeTefBTGgPni
// SIG // ggE8/vZT7123H99h+DALBgkqhkiG9w0BAQEEggEADwoT
// SIG // kZpx5nGcI5ZD6gXhfZCSpWdtnMEW9fbdCCcEIOPvcAqX
// SIG // 0x5fMzefchaqSEZIzgX4yR9cNtaaTjYhC2zK3CygpmE9
// SIG // pzjTrT5sx5qOieKx+kc5XETPLt/XwTujo1eu0ihi5g1F
// SIG // NVNdtYoumqB3TBZav4I6wXnSrSfhEXB0278E/QrVkodM
// SIG // yH/w03e9AwjOjXdvDt6cxiEgjWtCR+S6Ifiat1niSWvd
// SIG // UsPppDb50W8SmUrY4sgJuqCA9nlLanC1rZepUCrqxIqJ
// SIG // Jr2rQFblWXS4gY+yzixUaSM9ycYU3YgSIn/tRDBHGIY3
// SIG // m2IkzA5R2vjT+vEHlF8wSHVdmBXl4g==
// SIG // End signature block
