var topic = "<!DOCTYPE html>\r\n\n<!-- saved from url=(0024)http://docs.autodesk.com -->\r\n<html>\n   <head>\n      <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n      <meta name=\"product\" content=\"VAULT\">\n      <meta name=\"release\" content=\"2021\">\n      <meta name=\"book\" content=\"GeneralUser\">\n      <meta name=\"created\" content=\"2020-03-20\">\n      <meta name=\"topicid\" content=\"GUID-B535E117-86AE-4EC5-A7B6-523840FC4062\">\n      <meta name=\"description\" content=\"Learn about re-indexing properties in a vault.\">\n      <meta name=\"topic-type\" content=\"concept\">\n      <meta name=\"audience\" content=\"administrator\">\n      <meta name=\"experiencelevel\" content=\"general\">\n      <title>Re-Indexing Properties</title><script language=\"javascript\">var index = \'index.html\';</script></head>\n   <body height=\"100%\">\n      <div class=\"body_content\" id=\"body-content\" dir=\"ltr\"><a name=\"GUID-B535E117-86AE-4EC5-A7B6-523840FC4062\"></a><div class=\"head\">\n            <h1>Re-Indexing Properties</h1>\n         </div>\n         <p class=\"blurb\">Learn about re-indexing properties in a vault. </p>\n         <p><a name=\"GUID-0B213EF7-A075-4FA1-BB63-02A0F215B479\"></a> Re-indexing scans the selected vault database and extracts and indexes properties\n            from the files in the vault database. The extraction and indexing process uses the\n            latest available iFilters/Content Source Property Providers for the files. Only properties\n            currently set to Enabled and properties that have read-mappings are re-indexed. During\n            re-indexing, existing property (e.g., user-defined property) values are updated. \n         </p>\n         <p><a name=\"GUID-91333A30-85C6-47C2-896C-A90C06F6D381\"></a>Reasons for re-indexing: \n         </p><a name=\"UL_496238DCCD32488CB80848E0226D92FE\"></a><ul>\n            <li> New iFilters or Content Source Property Providers have been added that extract more\n               relevant information. \n            </li>\n            <li> Property definitions have been set to Enabled. </li>\n            <li> Read-mappings have been modified. </li>\n         </ul><a name=\"UL_256EDA37357F45EEB98FAEEDA8EC37C2\"></a><p class=\"list-intro\"><a name=\"GUID-C495FBDC-8314-4570-8BBA-A200034301E8\"></a>Which Properties Get Indexed\n         </p>\n         <p><a name=\"GUID-4BE1E676-72F8-40D2-9C10-D9D3556A55EE\"></a> When files are added to a vault, any file properties that are defined as Enabled\n            in the <a href=\"https://help.autodesk.com/view/VAULT/2019/ENU/?guid=GUID-5F0C9F22-0288-471E-8D64-D5F57FBE300A\" target=\"_blank\">Properties Management</a> dialog in Vault are indexed. The following are some of the property definitions that\n            are automatically created and set to Enabled when Autodesk Data Management Server\n            is installed: \n         </p>\n         <ul>\n            <li>Author </li>\n            <li>Comments </li>\n            <li>Keywords </li>\n            <li>Thumbnail </li>\n            <li>Material </li>\n            <li>Part Number </li>\n            <li>DWG Creator Name </li>\n            <li>DWG Creator Version </li>\n         </ul>\n         <p><a name=\"GUID-E50E0612-B6F0-40C3-A617-FD2F94ADFD5F\"></a> Additional property definitions can be created by the administrator. \n         </p>\n         <div><a name=\"GUID-3385E2B2-8A8C-4616-8D5A-EB64BE2AB0BD\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span>For more information and complete instructions for managing file properties, see <a href=\"https://help.autodesk.com/view/VAULT/2019/ENU/?guid=GUID-26645DD0-AC27-4CFB-BC15-41719B5DE609\" target=\"_blank\">Properties Administration</a>. \n            </div>\n         </div><a name=\"OL_9730D71602C044278B285528377357F2\"></a><p class=\"list-intro\"><a name=\"GUID-B937871A-2AAC-49B9-BC42-6F969ABB4601\"></a>Filters\n         </p>\n         <p><a name=\"GUID-B5BBB334-4071-4CDC-A02C-C0CCB33C387F\"></a> You can use filters to limit the number of files that are re-indexed. Following is\n            a list filters that can be used to refine the re-indexing process: \n         </p>\n         <ul>\n            <li><em class=\"strong\">File Extension–</em>use to re-index files of a particular type. \n               <p><a name=\"GUID-BACE9750-2AB0-435F-8D2F-550566E7F4BF\"></a> Usage: Input file extensions with or without leading dots. Separate each extension\n                  by a comma or a semi-colon (with or without spaces). \n               </p> \n            </li>\n            <li><em class=\"strong\">Provider–</em> use to re-index files based on the iFilter or Content Source Property Provider. \n               <p><a name=\"GUID-A608AE9C-418A-45B8-A818-0A5730BE4A31\"></a> Usage: Select provider(s) from the pre-defined list of providers. \n               </p> \n            </li>\n            <li><em class=\"strong\">Date–</em> use to re-index files that are checked in within a specified time period. \n               <p><a name=\"GUID-9DFC6565-B882-4C3B-AC91-0D4D2DFED9D1\"></a> Usage: Select the start and end dates to define the date range. The reindexing process\n                  will only index files that were checked in during this time frame. \n               </p> \n            </li>\n         </ul>\n         <div><a name=\"GUID-847C432F-4C81-4A6D-ACDE-4CC2FCB76B1D\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span> All three filters can be used in combination with each other. Use the OR operator\n               between File Extension and Provider filters. Use AND between Date and other filters.\n               \n            </div>\n         </div><a name=\"UL_0C78FF252605472AB21DCE936398667F\"></a><p class=\"list-intro\"><a name=\"GUID-CBE04FA0-F08B-4977-A96F-B91AACFF197B\"></a>Indexing and Server Performance\n         </p>\n         <p><a name=\"GUID-65A8DC88-3E3C-4C3A-90B8-D4DDFD5D08F5\"></a>The re-indexing process is assigned \"Below Normal\" priority on the server, allowing\n            users to continue accessing the Autodesk Data Management Server even while files are\n            being re-indexed. If the vault is backed up during the re-indexing process, the re-indexing\n            is paused for the duration of the backup and then automatically restarted once the\n            backup has finished. If a vault is being re-indexed and the same vault is restored,\n            the re-indexing operation stops and all properties re-indexed to that point are replaced\n            by the properties from the restored version. \n         </p>\n         <div><a name=\"GUID-E64B1122-3183-49F0-9EE6-F7840A6D3F59\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span>To run the re-indexing process at a higher priority on the server, use the <span class=\"char_link\"><a href=\"GUID-7FD9DAD8-0104-46FA-BCE7-11259FAB4235.htm\">command line</a></span>. While running the re-indexing process as a high priority is faster, the priority\n               cannot be changed once the process begins. \n            </div>\n         </div>\n         <p><a name=\"GUID-FD0D6C8A-E213-49B0-8C81-D6CB026839E7\"></a>When migrating a vault, all property definitions that are set to Enabled remain Enabled.\n            Once migrated, the administrator can disable those property definitions which are\n            no longer needed. Any new property definition added to the vault following migration\n            is set to Enabled by default. Re-indexing processes files from newest to oldest. In\n            the event that the server is suddenly re-booted or loses power, re-indexing automatically\n            starts on the last file processed when the server is brought back on line. \n         </p>\n         <p><a name=\"GUID-FF7E2ACD-7DC0-41EA-8291-FAEB1CE91BF1\"></a>When re-indexing properties in a replicated environment, the re-index operation processes\n            files located on the server from which it was started. \n         </p>\n         <div class=\"footer-block\"><a href=\"..\" class=\"comments-anchor\" target=\"_blank\"><span class=\"comments-link\">Please send us your comment about this page</span></a></div><br><p class=\"footer-license-block\"><a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\"><img alt=\"Creative Commons License\" style=\"border-width: 0;\" src=\"../images/ccLink.png\"></a>&nbsp;<em>Except where otherwise noted, this work is licensed under a <a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\">Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License</a>. Please see the <a href=\"http://autodesk.com/creativecommons\" target=\"_blank\">Autodesk Creative Commons FAQ</a> for more information.</em></p><br></div>\n   </body>\n</html>";
// SIG // Begin signature block
// SIG // MIIbRgYJKoZIhvcNAQcCoIIbNzCCGzMCAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // il7B0E/ynqq5xKYlw2Z91Zdy1/8cb/bwcM9DSrX2kmug
// SIG // ggoaMIIEyzCCA7OgAwIBAgIQCQja65wGHi65un4mqmKH
// SIG // ijANBgkqhkiG9w0BAQsFADCBhDELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTUw
// SIG // MwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
// SIG // b2RlIFNpZ25pbmcgQ0EgLSBHMjAeFw0xOTA1MTQwMDAw
// SIG // MDBaFw0yMDA1MTMyMzU5NTlaMHwxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIDApDYWxpZm9ybmlhMRMwEQYDVQQHDApT
// SIG // YW4gUmFmYWVsMRcwFQYDVQQKDA5BdXRvZGVzaywgSW5j
// SIG // LjERMA8GA1UECwwIU2VjdXJpdHkxFzAVBgNVBAMMDkF1
// SIG // dG9kZXNrLCBJbmMuMIIBIjANBgkqhkiG9w0BAQEFAAOC
// SIG // AQ8AMIIBCgKCAQEAkVKRoPYsoxPdlabspcuG8HYDfcWQ
// SIG // 9qyPOT2punwpVdjt2slktcpSTlydrGy8ijcbl5/k8AOJ
// SIG // afKMQvow0fNjIoNB5nsb8j2xFJPbBhHl8GT4P6DZ1OWK
// SIG // ioiUXgGHKjctUws49J4elntqvBYhKCbuPqG772QCoYFU
// SIG // P7qcFbh3PbyNB6cnKMn2vNGRqiEtV2aGg+/MiL3QPsvT
// SIG // kTWhVuTLIvwZ4kK5C5ACiQzlGOlE+C7gWuFoxtvy6gUa
// SIG // A8JAq/xLjYKwFevQwGncg3s1cuiGhx0P7Rvn6oCd2cem
// SIG // FmbK3I3rMRt+jc9wzAj3oHxvCo4f5Lfva+OpC1dETUVV
// SIG // sk0VGwIDAQABo4IBPjCCATowCQYDVR0TBAIwADAOBgNV
// SIG // HQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMw
// SIG // YQYDVR0gBFowWDBWBgZngQwBBAEwTDAjBggrBgEFBQcC
// SIG // ARYXaHR0cHM6Ly9kLnN5bWNiLmNvbS9jcHMwJQYIKwYB
// SIG // BQUHAgIwGQwXaHR0cHM6Ly9kLnN5bWNiLmNvbS9ycGEw
// SIG // HwYDVR0jBBgwFoAU1MAGIknrOUvdk+JcobhHdglyA1gw
// SIG // KwYDVR0fBCQwIjAgoB6gHIYaaHR0cDovL3JiLnN5bWNi
// SIG // LmNvbS9yYi5jcmwwVwYIKwYBBQUHAQEESzBJMB8GCCsG
// SIG // AQUFBzABhhNodHRwOi8vcmIuc3ltY2QuY29tMCYGCCsG
// SIG // AQUFBzAChhpodHRwOi8vcmIuc3ltY2IuY29tL3JiLmNy
// SIG // dDANBgkqhkiG9w0BAQsFAAOCAQEA0Q2+iVSEfT4xGq3A
// SIG // OADVb0rT5Z8E+PPb1x6hKknSzuaZKk/acDz9mdnFajaU
// SIG // WgIKiFJlsqJnuAM1w4lqKaEWsz3DoxvGIEwexj71Ud6a
// SIG // KlBJNcR9DdkXUZwMhbw9d78rjJAIX6tOwfSludZfdq8b
// SIG // YEkuIzQi9uYW9vHVPSCzhnUBKjwc9qTo9yBc7Fcn4FAT
// SIG // 90DzWM2hS9oc3p0pprYI2I/O4th90BEmwWkVqVgfaR0z
// SIG // VyIEmBbqB/IWLfjUBZJ/8sbkwWuWlYVRrfPxsj1e9qvb
// SIG // wE3Y28jWyGbqoUG39GhXk3uT8R8i3+T6M0c4rMfdifBC
// SIG // pceCaFTJzSye7LoeVzCCBUcwggQvoAMCAQICEHwbNTVK
// SIG // 59t050FfEWnKa6gwDQYJKoZIhvcNAQELBQAwgb0xCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjEfMB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29y
// SIG // azE6MDgGA1UECxMxKGMpIDIwMDggVmVyaVNpZ24sIElu
// SIG // Yy4gLSBGb3IgYXV0aG9yaXplZCB1c2Ugb25seTE4MDYG
// SIG // A1UEAxMvVmVyaVNpZ24gVW5pdmVyc2FsIFJvb3QgQ2Vy
// SIG // dGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMTQwNzIyMDAw
// SIG // MDAwWhcNMjQwNzIxMjM1OTU5WjCBhDELMAkGA1UEBhMC
// SIG // VVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9u
// SIG // MR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3Jr
// SIG // MTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1
// SIG // NiBDb2RlIFNpZ25pbmcgQ0EgLSBHMjCCASIwDQYJKoZI
// SIG // hvcNAQEBBQADggEPADCCAQoCggEBANeVQ9Tc32euOftS
// SIG // pLYmMQRw6beOWyq6N2k1lY+7wDDnhthzu9/r0XY/ilaO
// SIG // 6y1L8FcYTrGNpTPTC3Uj1Wp5J92j0/cOh2W13q0c8fU1
// SIG // tCJRryKhwV1LkH/AWU6rnXmpAtceSbE7TYf+wnirv+9S
// SIG // rpyvCNk55ZpRPmlfMBBOcWNsWOHwIDMbD3S+W8sS4duM
// SIG // xICUcrv2RZqewSUL+6McntimCXBx7MBHTI99w94Zzj7u
// SIG // BHKOF9P/8LIFMhlM07Acn/6leCBCcEGwJoxvAMg6ABFB
// SIG // ekGwp4qRBKCZePR3tPNgKuZsUAS3FGD/DVH0qIuE/iHa
// SIG // XF599Sl5T7BEdG9tcv8CAwEAAaOCAXgwggF0MC4GCCsG
// SIG // AQUFBwEBBCIwIDAeBggrBgEFBQcwAYYSaHR0cDovL3Mu
// SIG // c3ltY2QuY29tMBIGA1UdEwEB/wQIMAYBAf8CAQAwZgYD
// SIG // VR0gBF8wXTBbBgtghkgBhvhFAQcXAzBMMCMGCCsGAQUF
// SIG // BwIBFhdodHRwczovL2Quc3ltY2IuY29tL2NwczAlBggr
// SIG // BgEFBQcCAjAZGhdodHRwczovL2Quc3ltY2IuY29tL3Jw
// SIG // YTA2BgNVHR8ELzAtMCugKaAnhiVodHRwOi8vcy5zeW1j
// SIG // Yi5jb20vdW5pdmVyc2FsLXJvb3QuY3JsMBMGA1UdJQQM
// SIG // MAoGCCsGAQUFBwMDMA4GA1UdDwEB/wQEAwIBBjApBgNV
// SIG // HREEIjAgpB4wHDEaMBgGA1UEAxMRU3ltYW50ZWNQS0kt
// SIG // MS03MjQwHQYDVR0OBBYEFNTABiJJ6zlL3ZPiXKG4R3YJ
// SIG // cgNYMB8GA1UdIwQYMBaAFLZ3+mlIR59TEtXC6gcydgfR
// SIG // lwcZMA0GCSqGSIb3DQEBCwUAA4IBAQB/68qn6ot2Qus+
// SIG // jiBUMOO3udz6SD4Wxw9FlRDNJ4ajZvMC7XH4qsJVl5Fw
// SIG // g/lSflJpPMnx4JRGgBi7odSkVqbzHQCR1YbzSIfgy8Q0
// SIG // aCBetMv5Be2cr3BTJ7noPn5RoGlxi9xR7YA6JTKfRK9u
// SIG // QyjTIXW7l9iLi4z+qQRGBIX3FZxLEY3ELBf+1W5/muJW
// SIG // kvGWs60t+fTf2omZzrI4RMD3R3vKJbn6Kmgzm1By3qif
// SIG // 1M0sCzS9izB4QOCNjicbkG8avggVgV3rL+JR51EeyXgp
// SIG // 5x5lvzjvAUoBCSQOFsQUecFBNzTQPZFSlJ3haO8I8OJp
// SIG // nGdukAsak3HUJgLDwFojMYIQhDCCEIACAQEwgZkwgYQx
// SIG // CzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRlYyBD
// SIG // b3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1
// SIG // c3QgTmV0d29yazE1MDMGA1UEAxMsU3ltYW50ZWMgQ2xh
// SIG // c3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENBIC0gRzIC
// SIG // EAkI2uucBh4uubp+Jqpih4owDQYJYIZIAWUDBAIBBQCg
// SIG // fDAQBgorBgEEAYI3AgEMMQIwADAZBgkqhkiG9w0BCQMx
// SIG // DAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4wDAYK
// SIG // KwYBBAGCNwIBFTAvBgkqhkiG9w0BCQQxIgQg10C99smo
// SIG // Z0EMUw//r2reyhc1IO0WwoLPLy9yUs1ZzS4wDQYJKoZI
// SIG // hvcNAQEBBQAEggEAgZIm5skC+xL+NRGRHMO1HyQQxt+S
// SIG // l2bM/JXhn+G1jzkdqRyZ756nFf359SBnG7cGMZ1vcAf6
// SIG // gPV/s/sxnR2q0rY2h/vbaD9lozq9C5usBkuVEv0ZnXzC
// SIG // Qf1muEkyHKfLF8eJp/xdQgAmTBHEXdK913Xx7y6cJAWB
// SIG // juoizYDzuAhSJwE5Qf7Nad4SWbJRqxg/moJmb4mgP0KJ
// SIG // TI7bWpTqvXSXdQYbRAJkiRjzjQ7MGmLRoLjaT3xYJx39
// SIG // lKHuFN42j84cIZEcwEMnlQXqB4kHjQr8BXs9fExYJ94Z
// SIG // V4jxhSBUeMeplEUUIumRNvu8ffU99ZdIrVtA4ezBDPqF
// SIG // 5XI89KGCDj0wgg45BgorBgEEAYI3AwMBMYIOKTCCDiUG
// SIG // CSqGSIb3DQEHAqCCDhYwgg4SAgEDMQ0wCwYJYIZIAWUD
// SIG // BAIBMIIBDwYLKoZIhvcNAQkQAQSggf8EgfwwgfkCAQEG
// SIG // C2CGSAGG+EUBBxcDMDEwDQYJYIZIAWUDBAIBBQAEIGV0
// SIG // ZLPu8NiZm1owvy/z++4ZoIsOq9sYyFyRFC2Pr4D/AhUA
// SIG // 7Sz5bauxmoMYWWeOn8q+VBnsrnIYDzIwMjAwMzIzMTQw
// SIG // MzM0WjADAgEeoIGGpIGDMIGAMQswCQYDVQQGEwJVUzEd
// SIG // MBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xHzAd
// SIG // BgNVBAsTFlN5bWFudGVjIFRydXN0IE5ldHdvcmsxMTAv
// SIG // BgNVBAMTKFN5bWFudGVjIFNIQTI1NiBUaW1lU3RhbXBp
// SIG // bmcgU2lnbmVyIC0gRzOgggqLMIIFODCCBCCgAwIBAgIQ
// SIG // ewWx1EloUUT3yYnSnBmdEjANBgkqhkiG9w0BAQsFADCB
// SIG // vTELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWdu
// SIG // LCBJbmMuMR8wHQYDVQQLExZWZXJpU2lnbiBUcnVzdCBO
// SIG // ZXR3b3JrMTowOAYDVQQLEzEoYykgMjAwOCBWZXJpU2ln
// SIG // biwgSW5jLiAtIEZvciBhdXRob3JpemVkIHVzZSBvbmx5
// SIG // MTgwNgYDVQQDEy9WZXJpU2lnbiBVbml2ZXJzYWwgUm9v
// SIG // dCBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAeFw0xNjAx
// SIG // MTIwMDAwMDBaFw0zMTAxMTEyMzU5NTlaMHcxCzAJBgNV
// SIG // BAYTAlVTMR0wGwYDVQQKExRTeW1hbnRlYyBDb3Jwb3Jh
// SIG // dGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0
// SIG // d29yazEoMCYGA1UEAxMfU3ltYW50ZWMgU0hBMjU2IFRp
// SIG // bWVTdGFtcGluZyBDQTCCASIwDQYJKoZIhvcNAQEBBQAD
// SIG // ggEPADCCAQoCggEBALtZnVlVT52Mcl0agaLrVfOwAa08
// SIG // cawyjwVrhponADKXak3JZBRLKbvC2Sm5Luxjs+HPPwtW
// SIG // kPhiG37rpgfi3n9ebUA41JEG50F8eRzLy60bv9iVkfPw
// SIG // 7mz4rZY5Ln/BJ7h4OcWEpe3tr4eOzo3HberSmLU6Hx45
// SIG // ncP0mqj0hOHE0XxxxgYptD/kgw0mw3sIPk35CrczSf/K
// SIG // O9T1sptL4YiZGvXA6TMU1t/HgNuR7v68kldyd/TNqMz+
// SIG // CfWTN76ViGrF3PSxS9TO6AmRX7WEeTWKeKwZMo8jwTJB
// SIG // G1kOqT6xzPnWK++32OTVHW0ROpL2k8mc40juu1MO1DaX
// SIG // hnjFoTcCAwEAAaOCAXcwggFzMA4GA1UdDwEB/wQEAwIB
// SIG // BjASBgNVHRMBAf8ECDAGAQH/AgEAMGYGA1UdIARfMF0w
// SIG // WwYLYIZIAYb4RQEHFwMwTDAjBggrBgEFBQcCARYXaHR0
// SIG // cHM6Ly9kLnN5bWNiLmNvbS9jcHMwJQYIKwYBBQUHAgIw
// SIG // GRoXaHR0cHM6Ly9kLnN5bWNiLmNvbS9ycGEwLgYIKwYB
// SIG // BQUHAQEEIjAgMB4GCCsGAQUFBzABhhJodHRwOi8vcy5z
// SIG // eW1jZC5jb20wNgYDVR0fBC8wLTAroCmgJ4YlaHR0cDov
// SIG // L3Muc3ltY2IuY29tL3VuaXZlcnNhbC1yb290LmNybDAT
// SIG // BgNVHSUEDDAKBggrBgEFBQcDCDAoBgNVHREEITAfpB0w
// SIG // GzEZMBcGA1UEAxMQVGltZVN0YW1wLTIwNDgtMzAdBgNV
// SIG // HQ4EFgQUr2PWyqNOhXLgp7xB8ymiOH+AdWIwHwYDVR0j
// SIG // BBgwFoAUtnf6aUhHn1MS1cLqBzJ2B9GXBxkwDQYJKoZI
// SIG // hvcNAQELBQADggEBAHXqsC3VNBlcMkX+DuHUT6Z4wW/X
// SIG // 6t3cT/OhyIGI96ePFeZAKa3mXfSi2VZkhHEwKt0eYRdm
// SIG // IFYGmBmNXXHy+Je8Cf0ckUfJ4uiNA/vMkC/WCmxOM+zW
// SIG // tJPITJBjSDlAIcTd1m6JmDy1mJfoqQa3CcmPU1dBkC/h
// SIG // Hk1O3MoQeGxCbvC2xfhhXFL1TvZrjfdKer7zzf0D19n2
// SIG // A6gP41P3CnXsxnUuqmaFBJm3+AZX4cYO9uiv2uybGB+q
// SIG // ueM6AL/OipTLAduexzi7D1Kr0eOUA2AKTaD+J20UMvw/
// SIG // l0Dhv5mJ2+Q5FL3a5NPD6itas5VYVQR9x5rsIwONhSrS
// SIG // /66pYYEwggVLMIIEM6ADAgECAhB71OWvuswHP6EBIwQi
// SIG // QU0SMA0GCSqGSIb3DQEBCwUAMHcxCzAJBgNVBAYTAlVT
// SIG // MR0wGwYDVQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlvbjEf
// SIG // MB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazEo
// SIG // MCYGA1UEAxMfU3ltYW50ZWMgU0hBMjU2IFRpbWVTdGFt
// SIG // cGluZyBDQTAeFw0xNzEyMjMwMDAwMDBaFw0yOTAzMjIy
// SIG // MzU5NTlaMIGAMQswCQYDVQQGEwJVUzEdMBsGA1UEChMU
// SIG // U3ltYW50ZWMgQ29ycG9yYXRpb24xHzAdBgNVBAsTFlN5
// SIG // bWFudGVjIFRydXN0IE5ldHdvcmsxMTAvBgNVBAMTKFN5
// SIG // bWFudGVjIFNIQTI1NiBUaW1lU3RhbXBpbmcgU2lnbmVy
// SIG // IC0gRzMwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEK
// SIG // AoIBAQCvDoqq+Ny/aXtUF3FHCb2NPIH4dBV3Z5Cc/d5O
// SIG // Ap5LdvblNj5l1SQgbTD53R2D6T8nSjNObRaK5I1AjSKq
// SIG // vqcLG9IHtjy1GiQo+BtyUT3ICYgmCDr5+kMjdUdwDLNf
// SIG // W48IHXJIV2VNrwI8QPf03TI4kz/lLKbzWSPLgN4TTfkQ
// SIG // yaoKGGxVYVfR8QIsxLWr8mwj0p8NDxlsrYViaf1OhcGK
// SIG // UjGrW9jJdFLjV2wiv1V/b8oGqz9KtyJ2ZezsNvKWlYEm
// SIG // LP27mKoBONOvJUCbCVPwKVeFWF7qhUhBIYfl3rTTJrJ7
// SIG // QFNYeY5SMQZNlANFxM48A+y3API6IsW0b+XvsIqbAgMB
// SIG // AAGjggHHMIIBwzAMBgNVHRMBAf8EAjAAMGYGA1UdIARf
// SIG // MF0wWwYLYIZIAYb4RQEHFwMwTDAjBggrBgEFBQcCARYX
// SIG // aHR0cHM6Ly9kLnN5bWNiLmNvbS9jcHMwJQYIKwYBBQUH
// SIG // AgIwGRoXaHR0cHM6Ly9kLnN5bWNiLmNvbS9ycGEwQAYD
// SIG // VR0fBDkwNzA1oDOgMYYvaHR0cDovL3RzLWNybC53cy5z
// SIG // eW1hbnRlYy5jb20vc2hhMjU2LXRzcy1jYS5jcmwwFgYD
// SIG // VR0lAQH/BAwwCgYIKwYBBQUHAwgwDgYDVR0PAQH/BAQD
// SIG // AgeAMHcGCCsGAQUFBwEBBGswaTAqBggrBgEFBQcwAYYe
// SIG // aHR0cDovL3RzLW9jc3Aud3Muc3ltYW50ZWMuY29tMDsG
// SIG // CCsGAQUFBzAChi9odHRwOi8vdHMtYWlhLndzLnN5bWFu
// SIG // dGVjLmNvbS9zaGEyNTYtdHNzLWNhLmNlcjAoBgNVHREE
// SIG // ITAfpB0wGzEZMBcGA1UEAxMQVGltZVN0YW1wLTIwNDgt
// SIG // NjAdBgNVHQ4EFgQUpRMBqZ+FzBtuFh5fOzGqeTYAex0w
// SIG // HwYDVR0jBBgwFoAUr2PWyqNOhXLgp7xB8ymiOH+AdWIw
// SIG // DQYJKoZIhvcNAQELBQADggEBAEaer/C4ol+imUjPqCdL
// SIG // Ic2yuaZycGMv41UpezlGTud+ZQZYi7xXipINCNgQujYk
// SIG // +gp7+zvTYr9KlBXmgtuKVG3/KP5nz3E/5jMJ2aJZEPQe
// SIG // Sv5lzN7Ua+NSKXUASiulzMub6KlN97QXWZJBw7c/hub2
// SIG // wH9EPEZcF1rjpDvVaSbVIX3hgGd+Yqy3Ti4VmuWcI69b
// SIG // EepxqUH5DXk4qaENz7Sx2j6aescixXTN30cJhsT8kSWy
// SIG // G5bphQjo3ep0YG5gpVZ6DchEWNzm+UgUnuW/3gC9d7GY
// SIG // FHIUJN/HESwfAD/DSxTGZxzMHgajkF9cVIs+4zNbgg/F
// SIG // t4YCTnGf6WZFP3YxggJaMIICVgIBATCBizB3MQswCQYD
// SIG // VQQGEwJVUzEdMBsGA1UEChMUU3ltYW50ZWMgQ29ycG9y
// SIG // YXRpb24xHzAdBgNVBAsTFlN5bWFudGVjIFRydXN0IE5l
// SIG // dHdvcmsxKDAmBgNVBAMTH1N5bWFudGVjIFNIQTI1NiBU
// SIG // aW1lU3RhbXBpbmcgQ0ECEHvU5a+6zAc/oQEjBCJBTRIw
// SIG // CwYJYIZIAWUDBAIBoIGkMBoGCSqGSIb3DQEJAzENBgsq
// SIG // hkiG9w0BCRABBDAcBgkqhkiG9w0BCQUxDxcNMjAwMzIz
// SIG // MTQwMzM0WjAvBgkqhkiG9w0BCQQxIgQgBU+y5mezt85k
// SIG // OQFYMFeow/VQwxf53jNUQ4RRJo0F13YwNwYLKoZIhvcN
// SIG // AQkQAi8xKDAmMCQwIgQgxHTOdgB9AjlODaXk3nwUxoD5
// SIG // 4oIBPP72U+9dtx/fYfgwCwYJKoZIhvcNAQEBBIIBACC8
// SIG // CcYbI3h3d3sVQG6kGPaz6cg5RuYA0wfDpuEUWeeCILSf
// SIG // 6n0P7B7m/mJ+lZnVyGUO7Sn5as0ZfoJEuT/3X/d5j+mb
// SIG // McT9rR1Kpm7Xh+CgA0aCkn2A0CTwtx5jqgyJFD6LaM3d
// SIG // 4LIDmOLpP9SUO6fsg8W3vrtdvfxRZ+J+BGh0t9ddFOp1
// SIG // X38H0gX5ygsWv7nHhlwTgDMvNnXRP9tSGvWznvWQoba8
// SIG // jhSLmcMvNuuR5GHsquT6pObn1gWKNRCUMbHsmAu86Tbn
// SIG // q+HfCVPUeS5TEjnumoVTZKNkNVcIsUzh1rrQ2Tm0Xfaz
// SIG // lqkaNDdlHgyhQUhY1ToNMeHx9zMhSQs=
// SIG // End signature block
