var topic = "<!DOCTYPE html>\r\n\n<!-- saved from url=(0024)http://docs.autodesk.com -->\r\n<html>\n   <head>\n      <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n      <meta name=\"product\" content=\"VAULT\">\n      <meta name=\"release\" content=\"2021\">\n      <meta name=\"book\" content=\"GeneralUser\">\n      <meta name=\"created\" content=\"2020-03-20\">\n      <meta name=\"topicid\" content=\"GUID-B4443A39-A621-4E14-8A11-484EFBF3DB90\">\n      <meta name=\"description\" content=\"Configure transition criteria for an object in a certain lifecycle state to move to a new lifecycle state. You can also determine actions that are automatically triggered by the state change.\">\n      <meta name=\"contextid\" content=\"ID_LIFE_EDITLIFECYCLETRANSITION_VE\">\n      <meta name=\"contextid\" content=\"ID_LIFE_EDITLIFECYCLETRANSITION_ITEMLINK_VE\">\n      <meta name=\"topic-type\" content=\"concept\">\n      <meta name=\"audience\" content=\"administrator\">\n      <meta name=\"experiencelevel\" content=\"general\">\n      <title>Edit Lifecycle State Transitions</title><script language=\"javascript\">var index = \'index.html\';</script></head>\n   <body height=\"100%\">\n      <div class=\"revit-legend\">\n         <ul></ul>\n      </div>\n      <div class=\"body_content\" id=\"body-content\" dir=\"ltr\"><a name=\"GUID-B4443A39-A621-4E14-8A11-484EFBF3DB90\"></a><div class=\"head\">\n            <h1>Edit Lifecycle State Transitions</h1>\n         </div>\n         <p class=\"blurb\">Configure transition criteria for an object in a certain lifecycle state to move to\n            a new lifecycle state. You can also determine actions that are automatically triggered\n            by the state change.\n            <!--CPM-ContextId = \'ID_LIFE_EDITLIFECYCLETRANSITION_VE\'--><a name=\"GUID-D38E66EE-7AEF-440E-9161-A6816AD462C6\"></a> \n            <!--CPM-ContextId = \'ID_LIFE_EDITLIFECYCLETRANSITION_ITEMLINK_VE\'--><a name=\"GUID-EEB5301C-C6AD-4168-9021-124B376F1D54\"></a> \n         </p>\n         <div><a name=\"GUID-B5CF0FD9-B4B9-48BE-AA9D-981AC2DD801E\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span>This feature is available in Autodesk Vault Workgroup and Professional. \n               \n            </div>\n         </div>\n         <p><a name=\"GUID-9052DB71-BBEA-4ACD-8A6A-2DD8CB6E7C93\"></a>When an object moves from one lifecycle state to the next, it is called a transition.\n            For example, when a file in Work-in-Progress state is changed to a Released state,\n            that is a state transition. \n            \n         </p>\n         <p><a name=\"GUID-DFE3C332-BCF2-477E-9ED2-DDB4A6917DDF\"></a>For each state transition in a lifecycle, you can configure the: \n            <a name=\"UL_AE8FAA6A369349039C04A10270A87108\"></a><ul>\n               <li><em class=\"strong\">Transition Criteria</em>–Configure the property criteria that determines when a state transition can occur.\n                  For example, administrators can make it so that a file cannot transition to the next\n                  state without the Initial Approver property having a value. \n                  \n               </li>\n               <li><em class=\"strong\">Actions that occur when the transition is made</em>–Configure which events automatically take place when a successful transition occurs.\n                  For example, if a file moves to a new state, an automatic revision bump occurs. \n                  \n               </li>\n               <li><em class=\"strong\">Access control permissions</em>– Determine the groups or users that can execute a transition. \n                  \n               </li>\n               <li><em class=\"strong\">Release Restrictions</em>– From the Transitions tab on the Lifecycle Definition dialog, you can see the available\n                  transitions between each state and edit the settings for each transition. \n                  \n               </li>\n            </ul> \n         </p>\n         <div class=\"section\"><a name=\"SECTION_7EA0E5E287EA4477BADCE7E5B063D692\"></a> \n            <h2><a name=\"GUID-204EA7EE-E748-4C7B-9054-EC6A5906F720\"></a>Access Lifecycle State Transitions\n            </h2> <a name=\"GUID-D7BA2A9F-F233-42DF-89DC-DA049D350910\"></a><ol type=\"1\" start=\"1\">\n               <li>Click \n                  		<em class=\"strong\">Tools&nbsp;<img class=\"adsk-glyph-arrow\" src=\"../images/ac.menuaro.gif\"> Administration <img class=\"adsk-glyph-arrow\" src=\"../images/ac.menuaro.gif\"> Vault Settings.</em> \n               </li>\n               <li>On the Vault Settings dialog box click \n                  		<em class=\"strong\">Behaviors</em> tab&nbsp;<img class=\"adsk-glyph-arrow\" src=\"../images/ac.menuaro.gif\"> Lifecycles. \n                  	 \n               </li>\n               <li>In the Lifecycle Definition dialog box, select the name of the lifecycle definition\n                  for which you want to configure state transitions and click \n                  		<em class=\"strong\">Edit</em>. The selected definition name appears in the title bar. \n                  	 \n               </li>\n               <li>From the Lifecycle States list, select the lifecycle state to edit and click the Transitions\n                  tab. \n                  	 \n               </li>\n               <li>On the Transitions tab, the state transitions are listed in the From State and To\n                  State columns. Select the transition that you want to modify and click \n                  		<em class=\"strong\">Edit.</em> \n                  <p><a name=\"GUID-3FAAEDF4-5BD1-4925-AA25-6EE2A2367825\"></a>There are three options in the Transition dialog: Criteria, Actions, and Security.\n                     \n                     		\n                  </p> \n               </li>\n            </ol> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_D27E5AD8937B48A59358B8BC9D7A323C\"></a> \n            <h2><a name=\"GUID-6B3F034F-4F62-4C3F-84C1-B95C0DE3DD41\"></a>Configure Transition Criteria\n            </h2> \n            <p><a name=\"GUID-8A1B36D3-DD2E-42D0-A8B1-946F0DE905AB\"></a>Use transition criteria to determine when a transition occurs. The transition will\n               not happen until the criteria is met. \n               \n            </p> <a name=\"GUID-723475C2-F346-42D7-B8E2-4D655F71CC9E\"></a><p class=\"list-intro\"><a name=\"GUID-974B2153-A406-4934-946F-C3744634CC1E\"></a>Add Transition Criteria\n            </p>\n            <ol type=\"1\" start=\"1\">\n               <li>In the Transition dialog box, select the \n                  		<em class=\"strong\">Criteria \n                     		</em>tab. On the Criteria tab, define the criteria under which the transition can occur:\n                  \n                  		<a name=\"UL_304C6E603E764AC0BA57E5B01C5177D4\"></a><ol type=\"1\" start=\"1\">\n                     <li> If desired, filter which properties are displayed based on a certain entity class.\n                        For example, configure it so that only File Properties are shown in the Property drop-down.\n                        \n                        		  \n                     </li>\n                     <li>In the Property box, select the property. \n                        		  \n                     </li>\n                     <li>In the Condition box, select the condition. \n                        		  \n                     </li>\n                     <li>When appropriate, select a value from the Value box. Not all criterion definitions\n                        require an entry to the Value box. \n                        		  \n                     </li>\n                  </ol> \n               </li>\n               <li>Click \n                  		<em class=\"strong\">Add. \n                     		</em>The rule is added to the list in the text box below the Add button. \n                  	 \n               </li>\n            </ol>\n            <div><a name=\"GUID-87B4AA0B-5831-4C3B-B2BE-37CC562E7238\"></a><div class=\"note-tip\"><span class=\"label label-target-language\">TIP:</span>Use the Property Compliance property to ensure that all properties are in compliance\n                  before the transition can take place. This is an excellent rule to incorporate when\n                  configuring a transition from non-released state to a released state. \n                  	 \n               </div>\n            </div> <a name=\"GUID-5811589B-1380-45A0-9CF5-740D7BA6505E\"></a><p class=\"list-intro\"><a name=\"GUID-8B3809E5-6290-4DA6-98F2-E0A49F4DAF28\"></a>Remove or Replace Transition Criteria\n            </p>\n            <ol type=\"1\" start=\"1\">\n               <li>On the Transitions tab, select the transition that you want to modify and click \n                  		<em class=\"strong\">Edit.</em> \n               </li>\n               <li>On the Transition dialog box, select the Criteria tab, and then do one of the following:\n                  \n                  		<a name=\"UL_B6A554C986AD47479ED4AB9C0A81A81C\"></a><ul>\n                     <li>Select the defined criterion from the text box, and click \n                        			 <em class=\"strong\">Remove.</em> \n                     </li>\n                     <li>Select the defined criterion from the text box, select new criteria from the Property,\n                        Condition, and Value boxes and click \n                        			 <em class=\"strong\">Replace.</em> \n                     </li>\n                  </ul> \n               </li>\n            </ol> \n            <p><a name=\"GUID-F136DA37-CC27-4FB9-8926-4A24F5A79A4F\"></a> <em class=\"strong\">Boolean Operators (case insensitive)</em> \n            </p> \n            <p>You can use the following boolean operators when defining the transition criteria\n               value.\n               \n            </p> <a name=\"TABLE_795A8C1AA15F49EE9B9D570D94F95CF4\"></a><div class=\"table-not-ruled\">\n               <table cellpadding=\"0\" cellspacing=\"0\" class=\"not-ruled\">\n                  <colgroup>\n                     <col>\n                     <col>\n                  </colgroup>\n                  <tr class=\"not-ruled-odd-row\">\n                     <td class=\"table-body\"> <a name=\"GUID-8A17778B-83B1-4E56-9686-AF76778EB954\"></a><p class=\"table-body\">and \n                           				\n                        </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-A0487A9A-0D10-4F13-B810-B17C0EC788E6\"></a><p class=\"table-body\">Criteria includes x AND y. \n                           				\n                        </p> \n                     </td>\n                  </tr>\n                  <tr class=\"not-ruled-even-row\">\n                     <td class=\"table-body\"> <a name=\"GUID-EF1D590A-4309-4686-B94D-122D5E2FF10F\"></a><p class=\"table-body\">or \n                           				\n                        </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-5DB0FDAD-88B8-48BC-950A-86BC2C2F4D15\"></a><p class=\"table-body\">Criteria includes either x OR y. \n                           				\n                        </p> \n                     </td>\n                  </tr>\n                  <tr class=\"not-ruled-odd-row\">\n                     <td class=\"table-body\"> <a name=\"GUID-0040B235-A19C-43D7-B4A6-D6D1E8D42DE9\"></a><p class=\"table-body\">not \n                           				\n                        </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-40E7416C-C976-4002-9648-8EEF9F9524CC\"></a><p class=\"table-body\">Criteria includes documents that do NOT have x. \n                           				\n                        </p> \n                     </td>\n                  </tr>\n               </table>\n            </div> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_BEE61A22FC3D4B3DA7B39375AE2931E2\"></a> \n            <h2><a name=\"GUID-50F351CC-B080-4442-BB94-32B5C3B6FE44\"></a>Edit Transition Actions\n            </h2> \n            <p><a name=\"GUID-8B9BAF4A-4C38-48F0-A5E2-8AA497DA2103\"></a>Transition actions are events that occur when the transition is successful. If any\n               error occurs during the transition to the next state, the action will not take place.\n               \n               \n            </p> <a name=\"OL_1605D12CDA964ED7AC9AB97A0E0DD4E2\"></a><p class=\"list-intro\"><a name=\"GUID-12ED4733-2F4D-48E0-8FA7-AE473028E56B\"></a>Access the Transitions tab\n            </p>\n            <ol type=\"1\" start=\"1\">\n               <li>In the \n                  		<em class=\"strong\">Transitions</em> dialog box, click the \n                  		<em class=\"strong\">Actions</em> tab. \n                  	 \n               </li>\n               <li>Select an entity class in the Filter drop-down to show only the actions available\n                  for that entity class (e.g., select Folders to only see actions available for folder\n                  state transitions). \n                  	 \n               </li>\n            </ol> <a name=\"GUID-A0FE9E8E-B979-4135-84AD-041C00CFC621\"></a><p class=\"list-intro\"><a name=\"GUID-A43EC117-0718-47D1-AD75-2166762A2580\"></a> Bump Revision\n            </p>\n            <ol type=\"1\" start=\"1\">\n               <li>If you want a revision bump to occur when the transition occurs, select one of these\n                  actions: \n                  		<a name=\"UL_C083B17F722B4BF7880E8D8F37E2B6F1\"></a><ul>\n                     <li>Bump primary revision \n                        		  \n                     </li>\n                     <li>Bump secondary revision \n                        		  \n                     </li>\n                     <li>Bump tertiary revision \n                        		  \n                     </li>\n                  </ul>\n                  <div><a name=\"GUID-374111E8-97F3-4927-A890-7BE457E088CE\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span>Use-the drop-down arrow beside Bump Primary Revision to choose secondary or tertiary\n                        revision levels. \n                        		  \n                     </div>\n                  </div> \n                  <p><a name=\"GUID-050C044D-BB3E-4C50-9CB8-FA78D53C1819\"></a>Or clear the check box to exclude the action for this transition. \n                     		\n                  </p> \n               </li>\n            </ol> <a name=\"OL_3B6E4153C18043DEBA53EA9D85BC15E4\"></a><p class=\"list-intro\"><a name=\"GUID-7582D19D-6B91-4433-AC4E-5AABBD329F98\"></a>Synchronize Properties\n            </p>\n            <ol type=\"1\" start=\"1\">\n               <li>If you want to synchronize properties with the Job Server, select one of these actions:\n                  \n                  		<a name=\"UL_ABBB7C806B554111A089A478534B6C2D\"></a><ul>\n                     <li>Synchronize properties using Job Server \n                        		  \n                     </li>\n                     <li> Synchronize properties and update pdf using Job Server (available when the To State\n                        is Released) \n                        		  \n                     </li>\n                     <li> Synchronize properties and update view and pdf using Job Server (available when the\n                        To State is Released) \n                        		  \n                     </li>\n                     <li>Synchronize properties and update view using Job Server \n                        			 \n                        <div><a name=\"GUID-17E7EC06-7452-41B9-91E8-8AAC2AC37BAC\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span>Select the drop-down arrow beside Synchronize properties using Job Server to see other\n                              options. \n                              			 \n                           </div>\n                        </div> \n                     </li>\n                  </ul> \n                  <p><a name=\"GUID-6A91332B-3C69-4529-A115-5E74BD11FCD4\"></a>Or clear the check box to exclude the action for this transition. \n                     		\n                  </p> \n               </li>\n            </ol> <a name=\"UL_2F1F37438FD54929A9E29F6BAD996077\"></a><p class=\"list-intro\"><a name=\"GUID-CF3A3951-FFAA-4F5C-9BDA-F27F62127B2F\"></a>Release Restrictions\n            </p>\n            <p><a name=\"GUID-BB3F6602-5533-4B36-9EE4-3333C4519BB3\"></a>The administrator can choose to restrict the transition to the release state of Vault\n               objects based on the state of the dependent children, content, and linked data. Any\n               data that is not in a released (consumable) state causes a restriction and prevents\n               the transition of the select object(s). \n               <a name=\"TABLE_4595A6D3A02D4B62B69BF59EB778242B\"></a><div class=\"table-not-ruled\">\n                  <table cellpadding=\"0\" cellspacing=\"0\" class=\"not-ruled\">\n                     <colgroup>\n                        <col>\n                        <col>\n                     </colgroup>\n                     <tr class=\"not-ruled-odd-row\">\n                        <td class=\"table-body\"> <a name=\"GUID-340A507D-EF5B-4063-856A-EFC5386B5142\"></a><p class=\"table-body\">Check that dependent child files are released \n                              				\n                           </p> \n                        </td>\n                        <td class=\"table-body\"> <a name=\"GUID-EA400737-3E71-4EE5-8DAA-317805F57E3F\"></a><p class=\"table-body\">Verifies that state dependent children are in a released state. \n                              				\n                           </p> \n                        </td>\n                     </tr>\n                     <tr class=\"not-ruled-even-row\">\n                        <td class=\"table-body\"> <a name=\"GUID-9C21EDF8-3AE9-4151-9C28-CCD5DC8B85DA\"></a><p class=\"table-body\">Check that dependent child folders are released \n                              				\n                           </p> \n                        </td>\n                        <td class=\"table-body\"> <a name=\"GUID-761A996C-BF7E-4B67-A7DB-C894976E21C3\"></a><p class=\"table-body\">Verifies that the sub-folders of a project folder are in a released state. \n                              				\n                           </p> \n                        </td>\n                     </tr>\n                     <tr class=\"not-ruled-odd-row\">\n                        <td class=\"table-body\"> <a name=\"GUID-DF3023F7-47D1-42B7-850D-47E187F8987D\"></a><p class=\"table-body\">Check that contained files are released \n                              				\n                           </p> \n                        </td>\n                        <td class=\"table-body\"> <a name=\"GUID-C0C28101-EB4C-4043-9AB0-DF59D15B29DD\"></a><p class=\"table-body\">Verifies that all files contained in a project folder are in a released state. \n                              				\n                           </p> \n                        </td>\n                     </tr>\n                     <tr class=\"not-ruled-even-row\">\n                        <td class=\"table-body\"> <a name=\"GUID-1A2FF9F1-F87B-4994-821D-E949FF27CAC1\"></a><p class=\"table-body\">Check that linked files are released \n                              				\n                           </p> \n                        </td>\n                        <td class=\"table-body\"> <a name=\"GUID-2F99CDB5-B380-42F1-97A1-129DE1551D73\"></a><p class=\"table-body\">Verifies that all linked files in a project folder or custom object are in a released\n                              state. \n                              				\n                           </p> \n                        </td>\n                     </tr>\n                     <tr class=\"not-ruled-odd-row\">\n                        <td class=\"table-body\"> <a name=\"GUID-CFE66AEB-FC5A-4860-A922-28F29DC67640\"></a><p class=\"table-body\">Check that linked folders are released \n                              				\n                           </p> \n                        </td>\n                        <td class=\"table-body\"> <a name=\"GUID-43BB093D-D019-4CB3-8C6E-CEC018824EE4\"></a><p class=\"table-body\">Verifies that all linked folders in a project folder or custom object are in a released\n                              state. \n                              				\n                           </p> \n                        </td>\n                     </tr>\n                     <tr class=\"not-ruled-even-row\">\n                        <td class=\"table-body\"> <a name=\"GUID-1FF5CDF9-F094-44BD-8BF8-7561AE926F4B\"></a><p class=\"table-body\">Check that linked custom objects are released \n                              				\n                           </p> \n                        </td>\n                        <td class=\"table-body\"> <a name=\"GUID-5A54EF01-03F3-4F95-A565-0F1F988F83B0\"></a><p class=\"table-body\">Verifies that all linked custom objects in a project or custom object are in a released\n                              state. \n                              				\n                           </p> \n                        </td>\n                     </tr>\n                     <tr class=\"not-ruled-odd-row\">\n                        <td class=\"table-body\"> <a name=\"GUID-64F0D78C-DBE9-4D53-A34F-B1A718E76257\"></a><p class=\"table-body\">Check that linked items are released \n                              				\n                           </p> \n                        </td>\n                        <td class=\"table-body\"> <a name=\"GUID-F64C1FBE-C20B-48FD-9F12-9FB52F090B92\"></a><p class=\"table-body\">Verifies that all linked items in a project folder or custom object are in a released\n                              state. \n                              				\n                           </p> \n                        </td>\n                     </tr>\n                     <tr class=\"not-ruled-even-row\">\n                        <td class=\"table-body\"> <a name=\"GUID-9B511A7D-BEEA-441C-932D-AC2BB1EC1F55\"></a><p class=\"table-body\">Check that children are not obsolete \n                              				\n                           </p> \n                        </td>\n                        <td class=\"table-body\"> <a name=\"GUID-010191D7-F096-4025-84B7-C446DD1822F5\"></a><p class=\"table-body\">Verifies that children objects are not in an obsolete state. The parent will not be\n                              released if any child items are obsolete. \n                              				\n                           </p> \n                        </td>\n                     </tr>\n                     <tr class=\"not-ruled-odd-row\">\n                        <td class=\"table-body\"> <a name=\"GUID-32520C9E-64C5-405E-8F00-16681D9D4F95\"></a><p class=\"table-body\">Check that child items are released \n                              				\n                           </p> \n                        </td>\n                        <td class=\"table-body\"> <a name=\"GUID-6EE5A1FE-FE6A-4468-8707-782D466A151D\"></a><p class=\"table-body\">Verifies that children items are in a released state. \n                              				\n                           </p> \n                        </td>\n                     </tr>\n                     <tr class=\"not-ruled-even-row\">\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">Check that child items have been released \n                              				\n                           </p> \n                        </td>\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">Verify that child items have a historically released revision. \n                              				\n                           </p> \n                        </td>\n                     </tr>\n                     <tr class=\"not-ruled-odd-row\">\n                        <td class=\"table-body\"> <a name=\"GUID-56C183DB-E899-448C-944A-71D01EDCB800\"></a><p class=\"table-body\">Check that associated item file links are up to date \n                              				\n                           </p> \n                        </td>\n                        <td class=\"table-body\"> <a name=\"GUID-BC76FF74-03BD-4FAD-80A5-CC48DDE31F7A\"></a><p class=\"table-body\">Verifies that all associated item file links are current. \n                              				\n                           </p> <a name=\"GUID-BA13AD5B-6A81-480D-882B-8239A10009A7\"></a><p class=\"table-body\">Click the ellipses (...) button to specify only certain item file links: \n                              				<a name=\"UL_038E81AC449947EBBF72CACCE9996E9C\"></a><ul>\n                                 <li>Primary File Links \n                                    				  \n                                 </li>\n                                 <li>Secondary File Links \n                                    				  \n                                 </li>\n                                 <li>Standard Component Links \n                                    				  \n                                 </li>\n                                 <li>Primary Subcomponent File Links \n                                    				  \n                                 </li>\n                                 <li>Secondary Subcomponent File Links \n                                    				  \n                                 </li>\n                                 <li>Design Documents \n                                    				  \n                                 </li>\n                              </ul> \n                           </p> \n                        </td>\n                     </tr>\n                     <tr class=\"not-ruled-even-row\">\n                        <td class=\"table-body\"> <a name=\"GUID-1BB8682A-89EA-40C2-936F-BE346F5152B2\"></a><p class=\"table-body\">Check that associated item file links are released \n                              				\n                           </p> \n                        </td>\n                        <td class=\"table-body\"> <a name=\"GUID-EC364D39-8D25-44EF-B380-0A16BEDD0509\"></a><p class=\"table-body\">Verifies that all associated item file links are in a released state. \n                              				\n                           </p> <a name=\"GUID-5119F952-F54A-40C0-BF16-1DB48C244AED\"></a><p class=\"table-body\">Click the ellipses (...) button to specify only certain item file links: \n                              				<a name=\"UL_B771F42CB8C64C93AC6288BF82D2F9DB\"></a><ul>\n                                 <li>Primary File Links \n                                    				  \n                                 </li>\n                                 <li>Secondary File Links \n                                    				  \n                                 </li>\n                                 <li>Standard Component Links \n                                    				  \n                                 </li>\n                                 <li>Primary Subcomponent File Links \n                                    				  \n                                 </li>\n                                 <li>Secondary Subcomponent File Links \n                                    				  \n                                 </li>\n                                 <li>Design Documents \n                                    				  \n                                 </li>\n                              </ul> \n                           </p> \n                        </td>\n                     </tr>\n                  </table>\n               </div> \n            </p> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_0A889C9E9BF54C80888C4B515851C685\"></a> \n            <h2><a name=\"GUID-DE4ADCF9-95FA-4128-A344-1F9890AD4A5F\"></a>Create a Custom Job\n            </h2> \n            <p>Associate a custom job with a lifecycle transition. Two steps are necessary to create\n               a custom job. First, an administrator adds a custom job to a lifecycle. Second, a\n               programmer creates the job. \n               \n            </p> \n            <p>More information: \n               	 <span class=\"char_link\"><a href=\"GUID-DD071BFB-45AC-4157-9660-2370EFA9B844.htm\">Create a Custom Job</a></span> \n            </p> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_FB6C496C47FF4D30A5FB45C3161F63EA\"></a> \n            <h2><a name=\"GUID-EA938928-D367-4F0E-948F-E0912555B592\"></a>Edit Transition Security\n            </h2> \n            <p><a name=\"GUID-0C406B2B-ECA8-4E7C-9A5C-7CB116BA62E6\"></a>Determine who can make an transition occur by configuring Transition Security. Anyone\n               with Modify access can invoke the Change State command on the object. \n               \n            </p> \n            <div><a name=\"GUID-E788E0E8-ED16-4F61-A199-712F24AE5302\"></a><div class=\"note-tip\"><span class=\"label label-target-language\">TIP:</span> There is currently no command to retire a state. However, you can manually retire\n                  a state by denying everyone permission to perform a transition. This prevents files\n                  in other states from transitioning into that state. However, files can still transition\n                  out of the blocked state into a new one. \n                  \n               </div>\n            </div> <a name=\"GUID-FAEBB64E-3D07-4E87-807A-2BE82DEBA044\"></a><p class=\"list-intro\"><a name=\"GUID-6D09ED19-9F99-4076-9EF6-4635191270C3\"></a>Manage Transition Restrictions\n            </p>\n            <ol type=\"1\" start=\"1\">\n               <li>In the Transitions dialog box, click the \n                  		<em class=\"strong\">Security \n                     		</em>tab. \n                  	 \n               </li>\n               <li>When the \n                  		<em class=\"strong\">No restrictions on the transition \n                     		</em>check box is selected, no security options can be defined for the transition. To add\n                  transition restrictions, clear the No restrictions on the transition check box if\n                  it is selected. Click \n                  		<em class=\"strong\">Add</em>.&nbsp; \n                  	 \n               </li>\n            </ol> <a name=\"GUID-278CFBAE-2351-4EBB-9337-E35447DF438B\"></a><p class=\"list-intro\"><a name=\"GUID-4301DA97-0111-4850-B347-C7C895E7E3F6\"></a>Add Members\n            </p>\n            <p><a name=\"GUID-85DC06C7-C823-4C44-A59A-3239A1582131\"></a>Members or groups must be made available, and then added to the Current Members list\n               to enable transition permission. \n               \n            </p>\n            <ol type=\"1\" start=\"1\">\n               <li>In the Add Members dialog box, select members or groups from the \n                  	 <em class=\"strong\">Select Members From \n                     	 </em>list to be added to the Available Members list. \n                  \n               </li>\n               <li>In the \n                  	 <em class=\"strong\">Available Members \n                     	 </em>list, select members or groups to be added to the Current Members list, and then click\n                  \n                  	 <em class=\"strong\">Add.</em>&nbsp;&nbsp; \n                  \n               </li>\n            </ol> <a name=\"UL_FF7116FF46684CB1BACB6E560C3AC761\"></a><p class=\"list-intro\"><a name=\"GUID-45D01D83-C3AB-4665-897C-CDAD2E0EC8E5\"></a>Remove Members\n            </p>\n            <ul>\n               <li>In the Add Members dialog box, select members or groups in the Current Members list,\n                  and then click \n                  		<em class=\"strong\">Remove.</em> \n               </li>\n            </ul> <a name=\"UL_6B52FF34A60D45DD8A639E781DB60C4B\"></a><p class=\"list-intro\"><a name=\"GUID-C585ABDD-5EE6-4803-94EE-8F690021013A\"></a>Modify Permissions on Existing Members \n            </p>\n            <div><a name=\"GUID-173AB495-170C-454E-A5F5-7FE8AC28DBB2\"></a><div class=\"note-important\"><span class=\"label label-target-language\">IMPORTANT:</span>Users must have Modify permission at the object-based security level to perform a\n                  change state. \n                  	 \n               </div>\n            </div>\n            <ul>\n               <li>In the Add Members dialog, select the permission next to the member for whom you want\n                  to Allow or Deny access and select the new permission from the drop-down list. \n                  	 \n               </li>\n            </ul> \n         </div>\n         <div class=\"footer-block\"><a href=\"..\" class=\"comments-anchor\" target=\"_blank\"><span class=\"comments-link\">Please send us your comment about this page</span></a></div><br><p class=\"footer-license-block\"><a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\"><img alt=\"Creative Commons License\" style=\"border-width: 0;\" src=\"../images/ccLink.png\"></a>&nbsp;<em>Except where otherwise noted, this work is licensed under a <a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\">Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License</a>. Please see the <a href=\"http://autodesk.com/creativecommons\" target=\"_blank\">Autodesk Creative Commons FAQ</a> for more information.</em></p><br></div>\n   </body>\n</html>";
// SIG // Begin signature block
// SIG // MIIZfQYJKoZIhvcNAQcCoIIZbjCCGWoCAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // A8NCXQ/FPuFEpFNL+o6GrxFDW0f3VSHCbUsfsjVOBuCg
// SIG // ggoaMIIEyzCCA7OgAwIBAgIQCQja65wGHi65un4mqmKH
// SIG // ijANBgkqhkiG9w0BAQsFADCBhDELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTUw
// SIG // MwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
// SIG // b2RlIFNpZ25pbmcgQ0EgLSBHMjAeFw0xOTA1MTQwMDAw
// SIG // MDBaFw0yMDA1MTMyMzU5NTlaMHwxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIDApDYWxpZm9ybmlhMRMwEQYDVQQHDApT
// SIG // YW4gUmFmYWVsMRcwFQYDVQQKDA5BdXRvZGVzaywgSW5j
// SIG // LjERMA8GA1UECwwIU2VjdXJpdHkxFzAVBgNVBAMMDkF1
// SIG // dG9kZXNrLCBJbmMuMIIBIjANBgkqhkiG9w0BAQEFAAOC
// SIG // AQ8AMIIBCgKCAQEAkVKRoPYsoxPdlabspcuG8HYDfcWQ
// SIG // 9qyPOT2punwpVdjt2slktcpSTlydrGy8ijcbl5/k8AOJ
// SIG // afKMQvow0fNjIoNB5nsb8j2xFJPbBhHl8GT4P6DZ1OWK
// SIG // ioiUXgGHKjctUws49J4elntqvBYhKCbuPqG772QCoYFU
// SIG // P7qcFbh3PbyNB6cnKMn2vNGRqiEtV2aGg+/MiL3QPsvT
// SIG // kTWhVuTLIvwZ4kK5C5ACiQzlGOlE+C7gWuFoxtvy6gUa
// SIG // A8JAq/xLjYKwFevQwGncg3s1cuiGhx0P7Rvn6oCd2cem
// SIG // FmbK3I3rMRt+jc9wzAj3oHxvCo4f5Lfva+OpC1dETUVV
// SIG // sk0VGwIDAQABo4IBPjCCATowCQYDVR0TBAIwADAOBgNV
// SIG // HQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMw
// SIG // YQYDVR0gBFowWDBWBgZngQwBBAEwTDAjBggrBgEFBQcC
// SIG // ARYXaHR0cHM6Ly9kLnN5bWNiLmNvbS9jcHMwJQYIKwYB
// SIG // BQUHAgIwGQwXaHR0cHM6Ly9kLnN5bWNiLmNvbS9ycGEw
// SIG // HwYDVR0jBBgwFoAU1MAGIknrOUvdk+JcobhHdglyA1gw
// SIG // KwYDVR0fBCQwIjAgoB6gHIYaaHR0cDovL3JiLnN5bWNi
// SIG // LmNvbS9yYi5jcmwwVwYIKwYBBQUHAQEESzBJMB8GCCsG
// SIG // AQUFBzABhhNodHRwOi8vcmIuc3ltY2QuY29tMCYGCCsG
// SIG // AQUFBzAChhpodHRwOi8vcmIuc3ltY2IuY29tL3JiLmNy
// SIG // dDANBgkqhkiG9w0BAQsFAAOCAQEA0Q2+iVSEfT4xGq3A
// SIG // OADVb0rT5Z8E+PPb1x6hKknSzuaZKk/acDz9mdnFajaU
// SIG // WgIKiFJlsqJnuAM1w4lqKaEWsz3DoxvGIEwexj71Ud6a
// SIG // KlBJNcR9DdkXUZwMhbw9d78rjJAIX6tOwfSludZfdq8b
// SIG // YEkuIzQi9uYW9vHVPSCzhnUBKjwc9qTo9yBc7Fcn4FAT
// SIG // 90DzWM2hS9oc3p0pprYI2I/O4th90BEmwWkVqVgfaR0z
// SIG // VyIEmBbqB/IWLfjUBZJ/8sbkwWuWlYVRrfPxsj1e9qvb
// SIG // wE3Y28jWyGbqoUG39GhXk3uT8R8i3+T6M0c4rMfdifBC
// SIG // pceCaFTJzSye7LoeVzCCBUcwggQvoAMCAQICEHwbNTVK
// SIG // 59t050FfEWnKa6gwDQYJKoZIhvcNAQELBQAwgb0xCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjEfMB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29y
// SIG // azE6MDgGA1UECxMxKGMpIDIwMDggVmVyaVNpZ24sIElu
// SIG // Yy4gLSBGb3IgYXV0aG9yaXplZCB1c2Ugb25seTE4MDYG
// SIG // A1UEAxMvVmVyaVNpZ24gVW5pdmVyc2FsIFJvb3QgQ2Vy
// SIG // dGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMTQwNzIyMDAw
// SIG // MDAwWhcNMjQwNzIxMjM1OTU5WjCBhDELMAkGA1UEBhMC
// SIG // VVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9u
// SIG // MR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3Jr
// SIG // MTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1
// SIG // NiBDb2RlIFNpZ25pbmcgQ0EgLSBHMjCCASIwDQYJKoZI
// SIG // hvcNAQEBBQADggEPADCCAQoCggEBANeVQ9Tc32euOftS
// SIG // pLYmMQRw6beOWyq6N2k1lY+7wDDnhthzu9/r0XY/ilaO
// SIG // 6y1L8FcYTrGNpTPTC3Uj1Wp5J92j0/cOh2W13q0c8fU1
// SIG // tCJRryKhwV1LkH/AWU6rnXmpAtceSbE7TYf+wnirv+9S
// SIG // rpyvCNk55ZpRPmlfMBBOcWNsWOHwIDMbD3S+W8sS4duM
// SIG // xICUcrv2RZqewSUL+6McntimCXBx7MBHTI99w94Zzj7u
// SIG // BHKOF9P/8LIFMhlM07Acn/6leCBCcEGwJoxvAMg6ABFB
// SIG // ekGwp4qRBKCZePR3tPNgKuZsUAS3FGD/DVH0qIuE/iHa
// SIG // XF599Sl5T7BEdG9tcv8CAwEAAaOCAXgwggF0MC4GCCsG
// SIG // AQUFBwEBBCIwIDAeBggrBgEFBQcwAYYSaHR0cDovL3Mu
// SIG // c3ltY2QuY29tMBIGA1UdEwEB/wQIMAYBAf8CAQAwZgYD
// SIG // VR0gBF8wXTBbBgtghkgBhvhFAQcXAzBMMCMGCCsGAQUF
// SIG // BwIBFhdodHRwczovL2Quc3ltY2IuY29tL2NwczAlBggr
// SIG // BgEFBQcCAjAZGhdodHRwczovL2Quc3ltY2IuY29tL3Jw
// SIG // YTA2BgNVHR8ELzAtMCugKaAnhiVodHRwOi8vcy5zeW1j
// SIG // Yi5jb20vdW5pdmVyc2FsLXJvb3QuY3JsMBMGA1UdJQQM
// SIG // MAoGCCsGAQUFBwMDMA4GA1UdDwEB/wQEAwIBBjApBgNV
// SIG // HREEIjAgpB4wHDEaMBgGA1UEAxMRU3ltYW50ZWNQS0kt
// SIG // MS03MjQwHQYDVR0OBBYEFNTABiJJ6zlL3ZPiXKG4R3YJ
// SIG // cgNYMB8GA1UdIwQYMBaAFLZ3+mlIR59TEtXC6gcydgfR
// SIG // lwcZMA0GCSqGSIb3DQEBCwUAA4IBAQB/68qn6ot2Qus+
// SIG // jiBUMOO3udz6SD4Wxw9FlRDNJ4ajZvMC7XH4qsJVl5Fw
// SIG // g/lSflJpPMnx4JRGgBi7odSkVqbzHQCR1YbzSIfgy8Q0
// SIG // aCBetMv5Be2cr3BTJ7noPn5RoGlxi9xR7YA6JTKfRK9u
// SIG // QyjTIXW7l9iLi4z+qQRGBIX3FZxLEY3ELBf+1W5/muJW
// SIG // kvGWs60t+fTf2omZzrI4RMD3R3vKJbn6Kmgzm1By3qif
// SIG // 1M0sCzS9izB4QOCNjicbkG8avggVgV3rL+JR51EeyXgp
// SIG // 5x5lvzjvAUoBCSQOFsQUecFBNzTQPZFSlJ3haO8I8OJp
// SIG // nGdukAsak3HUJgLDwFojMYIOuzCCDrcCAQEwgZkwgYQx
// SIG // CzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRlYyBD
// SIG // b3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1
// SIG // c3QgTmV0d29yazE1MDMGA1UEAxMsU3ltYW50ZWMgQ2xh
// SIG // c3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENBIC0gRzIC
// SIG // EAkI2uucBh4uubp+Jqpih4owDQYJYIZIAWUDBAIBBQCg
// SIG // fDAQBgorBgEEAYI3AgEMMQIwADAZBgkqhkiG9w0BCQMx
// SIG // DAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4wDAYK
// SIG // KwYBBAGCNwIBFTAvBgkqhkiG9w0BCQQxIgQgbCXkvo02
// SIG // fCrUmMQbxcVBXAh0XCkjwDO5XF10o0VR8c0wDQYJKoZI
// SIG // hvcNAQEBBQAEggEAhSRAoyc0BbPSNMrxyVoMTpq1g7Dx
// SIG // Dh08QvjFq2lsk5BKvWv/fns9/sY7+sfjSkVzFsxHfa02
// SIG // vnPb0uX5QOKuO34pfbLkGK4FvXJvcwrmvk9SaHPGEntz
// SIG // H1Dyn4xi/HXirdMjhFm3fBaG267hd90FK4stUE757WqL
// SIG // pld6Mu68C24bpyWcGEaU930DKRyVF/WMj2sjgQgkDcrx
// SIG // lR5BhQ6ajJFE3T6/236773f3TjxCfGmmacefK0rTF+Vo
// SIG // yVB9ZlQe/wiPuDYA1MTk+zjprKdpeNFxOGbi/Mu4nqnD
// SIG // QEBopKD/2Cc/ZUXxvQnrF+hDjmA/LcHZWkTD318DBsEN
// SIG // DPS8Z6GCDHQwggxwBgorBgEEAYI3AwMBMYIMYDCCDFwG
// SIG // CSqGSIb3DQEHAqCCDE0wggxJAgEDMQ8wDQYJYIZIAWUD
// SIG // BAIBBQAwga8GCyqGSIb3DQEJEAEEoIGfBIGcMIGZAgEB
// SIG // BgkrBgEEAaAyAgMwMTANBglghkgBZQMEAgEFAAQg0PV3
// SIG // JxDNCT/hWvqhMnWyoNJ1rHwYTEa8ZyHPb/ulOukCFGCQ
// SIG // bQbX8PN/j8/44YB+Zs/JXrc8GA8yMDIwMDMyMzE0MDMy
// SIG // MlqgL6QtMCsxKTAnBgNVBAMMIEdsb2JhbFNpZ24gVFNB
// SIG // IGZvciBBZHZhbmNlZCAtIEcyoIII0zCCBLYwggOeoAMC
// SIG // AQICDAynz10HBySsieeaOjANBgkqhkiG9w0BAQsFADBb
// SIG // MQswCQYDVQQGEwJCRTEZMBcGA1UEChMQR2xvYmFsU2ln
// SIG // biBudi1zYTExMC8GA1UEAxMoR2xvYmFsU2lnbiBUaW1l
// SIG // c3RhbXBpbmcgQ0EgLSBTSEEyNTYgLSBHMjAeFw0xODAy
// SIG // MTkwMDAwMDBaFw0yOTAzMTgxMDAwMDBaMCsxKTAnBgNV
// SIG // BAMMIEdsb2JhbFNpZ24gVFNBIGZvciBBZHZhbmNlZCAt
// SIG // IEcyMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKC
// SIG // AQEAt8eSiijY85HLUA1d6ylEwYJZpcpkzr2DtVHllMxu
// SIG // gJoXbNz/YuY2Q14Bwgxkjcp3nvZdd0W5Xsgk60E3EWY3
// SIG // rMjNdJvMs+9M4n8bznO+yZadNR5891T3bOygEtaumZ1j
// SIG // xHhfWakuIvXDJ9iyW0VjJ5D/jLE9qbTzDsDxIGUGiZ0D
// SIG // HKOwUkGFNOu8y85U9hL+swGJSqb6VMUf+9McwOO/l+M/
// SIG // 0Bv5QMcb1esmfEMwx3DyeBGqhU6lDg0ASjoRd6PKIwGA
// SIG // nsiTVl1GzIrY0qoKhIWyiVvVMs5BexhOVMqr0VJeEtMk
// SIG // nlbzDI/dvZKOedVBicOjoOWR/MdnnYczznEycwIDAQAB
// SIG // o4IBqDCCAaQwDgYDVR0PAQH/BAQDAgeAMEwGA1UdIARF
// SIG // MEMwQQYJKwYBBAGgMgEeMDQwMgYIKwYBBQUHAgEWJmh0
// SIG // dHBzOi8vd3d3Lmdsb2JhbHNpZ24uY29tL3JlcG9zaXRv
// SIG // cnkvMAkGA1UdEwQCMAAwFgYDVR0lAQH/BAwwCgYIKwYB
// SIG // BQUHAwgwRgYDVR0fBD8wPTA7oDmgN4Y1aHR0cDovL2Ny
// SIG // bC5nbG9iYWxzaWduLmNvbS9ncy9nc3RpbWVzdGFtcGlu
// SIG // Z3NoYTJnMi5jcmwwgZgGCCsGAQUFBwEBBIGLMIGIMEgG
// SIG // CCsGAQUFBzAChjxodHRwOi8vc2VjdXJlLmdsb2JhbHNp
// SIG // Z24uY29tL2NhY2VydC9nc3RpbWVzdGFtcGluZ3NoYTJn
// SIG // Mi5jcnQwPAYIKwYBBQUHMAGGMGh0dHA6Ly9vY3NwMi5n
// SIG // bG9iYWxzaWduLmNvbS9nc3RpbWVzdGFtcGluZ3NoYTJn
// SIG // MjAdBgNVHQ4EFgQULW5u0Y3lA4Du52Ppp9naCzxXIj0w
// SIG // HwYDVR0jBBgwFoAUkiGnSpVdZLCbtB7mADdH5p1BK0ww
// SIG // DQYJKoZIhvcNAQELBQADggEBAI39HR+PiNNl+LVcRumn
// SIG // 07Y/SstDBcIHDcNeA4QjN6h6jJcj/yechH1h61xLVz6b
// SIG // 9ETbgFj3tmXejxIKX6eHdLfaFECHUeyfSkdV8BfoGD5x
// SIG // IDHmKCKrTvaunGvC50T7aA0gf1M/lBuhhoJOMhYQWj+J
// SIG // WMHQtNu2kPuNMumhS0ZQN7bDOukpJBKSWk4rubYKejaM
// SIG // l8DviXwz3jHhoZfk50WtYVL9WonTVH6KTVuJew6Wd9Hy
// SIG // PDgb2vmlYSBlArzFrdcMYhAoLN2246hhAKwIJqONhdBk
// SIG // yTaQHopSyYeNNaVdSJH8k6alZfHs+TrcpSyeBG1iM/7e
// SIG // +p/Fzq+V81Go8s4wggQVMIIC/aADAgECAgsEAAAAAAEx
// SIG // icZQBDANBgkqhkiG9w0BAQsFADBMMSAwHgYDVQQLExdH
// SIG // bG9iYWxTaWduIFJvb3QgQ0EgLSBSMzETMBEGA1UEChMK
// SIG // R2xvYmFsU2lnbjETMBEGA1UEAxMKR2xvYmFsU2lnbjAe
// SIG // Fw0xMTA4MDIxMDAwMDBaFw0yOTAzMjkxMDAwMDBaMFsx
// SIG // CzAJBgNVBAYTAkJFMRkwFwYDVQQKExBHbG9iYWxTaWdu
// SIG // IG52LXNhMTEwLwYDVQQDEyhHbG9iYWxTaWduIFRpbWVz
// SIG // dGFtcGluZyBDQSAtIFNIQTI1NiAtIEcyMIIBIjANBgkq
// SIG // hkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqpuOw6sRUSUB
// SIG // tpaU4k/YwQj2RiPZRcWVl1urGr/SbFfJMwYfoA/GPH5T
// SIG // SHq/nYeer+7DjEfhQuzj46FKbAwXxKbBuc1b8R5EiY7+
// SIG // C94hWBPuTcjFZwscsrPxNHaRossHbTfFoEcmAhWkkJGp
// SIG // eZ7X61edK3wi2BTX8QceeCI2a3d5r6/5f45O4bUIMf3q
// SIG // 7UtxYowj8QM5j0R5tnYDV56tLwhG3NKMvPSOdM7IaGlR
// SIG // dhGLD10kWxlUPSbMQI2CJxtZIH1Z9pOAjvgqOP1roEBl
// SIG // H1d2zFuOBE8sqNuEUBNPxtyLufjdaUyI65x7MCb8eli7
// SIG // WbwUcpKBV7d2ydiACoBuCQIDAQABo4HoMIHlMA4GA1Ud
// SIG // DwEB/wQEAwIBBjASBgNVHRMBAf8ECDAGAQH/AgEAMB0G
// SIG // A1UdDgQWBBSSIadKlV1ksJu0HuYAN0fmnUErTDBHBgNV
// SIG // HSAEQDA+MDwGBFUdIAAwNDAyBggrBgEFBQcCARYmaHR0
// SIG // cHM6Ly93d3cuZ2xvYmFsc2lnbi5jb20vcmVwb3NpdG9y
// SIG // eS8wNgYDVR0fBC8wLTAroCmgJ4YlaHR0cDovL2NybC5n
// SIG // bG9iYWxzaWduLm5ldC9yb290LXIzLmNybDAfBgNVHSME
// SIG // GDAWgBSP8Et/qC5FJK5NUPpjmove4t0bvDANBgkqhkiG
// SIG // 9w0BAQsFAAOCAQEABFaCSnzQzsm/NmbRvjWek2yX6AbO
// SIG // MRhZ+WxBX4AuwEIluBjH/NSxN8RooM8oagN0S2OXhXdh
// SIG // O9cv4/W9M6KSfREfnops7yyw9GKNNnPRFjbxvF7stICY
// SIG // ePzSdnno4SGU4B/EouGqZ9uznHPlQCLPOc7b5neVp7uy
// SIG // y/YZhp2fyNSYBbJxb051rvE9ZGo7Xk5GpipdCJLxo/Md
// SIG // dL9iDSOMXCo4ldLA1c3PiNofKLW6gWlkKrWmotVzr9xG
// SIG // 2wSukdduxZi61EfEVnSAR3hYjL7vK/3sbL/RlPe/UOB7
// SIG // 4JD9IBh4GCJdCC6MHKCX8x2ZfaOdkdMGRE4EbnocIOM2
// SIG // 8LZQuTGCAqgwggKkAgEBMGswWzELMAkGA1UEBhMCQkUx
// SIG // GTAXBgNVBAoTEEdsb2JhbFNpZ24gbnYtc2ExMTAvBgNV
// SIG // BAMTKEdsb2JhbFNpZ24gVGltZXN0YW1waW5nIENBIC0g
// SIG // U0hBMjU2IC0gRzICDAynz10HBySsieeaOjANBglghkgB
// SIG // ZQMEAgEFAKCCAQ4wGgYJKoZIhvcNAQkDMQ0GCyqGSIb3
// SIG // DQEJEAEEMBwGCSqGSIb3DQEJBTEPFw0yMDAzMjMxNDAz
// SIG // MjJaMC8GCSqGSIb3DQEJBDEiBCDdDxWR/ziHrSUc5wIy
// SIG // mbc3GQsr1u0MiQUBfc/at90DkjCBoAYLKoZIhvcNAQkQ
// SIG // AgwxgZAwgY0wgYowgYcEFJsSBXrnKq/21jdytJ9qI28m
// SIG // Sc2pMG8wX6RdMFsxCzAJBgNVBAYTAkJFMRkwFwYDVQQK
// SIG // ExBHbG9iYWxTaWduIG52LXNhMTEwLwYDVQQDEyhHbG9i
// SIG // YWxTaWduIFRpbWVzdGFtcGluZyBDQSAtIFNIQTI1NiAt
// SIG // IEcyAgwMp89dBwckrInnmjowDQYJKoZIhvcNAQEBBQAE
// SIG // ggEASrB39CN5QBoR3Xhp3MQt83wB1mEUROOj5VasRWpw
// SIG // o0RUoQY5GU0JsbFHJCUBAaqRAZWcpDVrzO+vrDWJC2Fs
// SIG // SG1qCqfekods/ia4VsJUZl/Ot7tScWYkcbDCuTLYCmaN
// SIG // 2TJMP+4QEyk/d3xmUOr7jsbZrPjdfbeukfovlnIMow3T
// SIG // 9M/zzY/QqNsMMj21JgfN1rmOS0eEs/KIGU8yzFX23Vn0
// SIG // Ry75SZbAngbgEtDvT76oUjxRzGY0MG/PVeepiAvc4yrq
// SIG // t+nCwIK4HuST+WZAhtm1w6sUYxvoMQlDAxkKXHkVd9Bm
// SIG // NxXqVX5r/7btZnRA7SOma1uWa4JuOk+r3odq1g==
// SIG // End signature block
