var topic = "<!DOCTYPE html>\r\n\n<!-- saved from url=(0024)http://docs.autodesk.com -->\r\n<html>\n   <head>\n      <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n      <meta name=\"product\" content=\"VAULT\">\n      <meta name=\"release\" content=\"2021\">\n      <meta name=\"book\" content=\"GeneralUser\">\n      <meta name=\"created\" content=\"2020-03-20\">\n      <meta name=\"topicid\" content=\"GUID-B294A257-8EC3-43E8-BC46-D701594C78FD\">\n      <meta name=\"description\" content=\"Maintenance plans can be used to schedule tasks required to make sure that the database performs well, such as keeping database and transaction log file sizes small and checking the database for inconsistencies.\">\n      <meta name=\"topic-type\" content=\"concept\">\n      <meta name=\"audience\" content=\"administrator\">\n      <meta name=\"experiencelevel\" content=\"general\">\n      <title>Server Maintenance Part 6: Create SQL Maintenance Plan</title><script language=\"javascript\">var index = \'index.html\';</script><script type=\"text/javascript\" src=\"../scripts/prettify/prettify.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-yaml.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-xq.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-wiki.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-vhdl.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-vb.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-tex.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-sql.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-scala.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-proto.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-n.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-ml.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-lua.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-lisp.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-hs.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-go.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-css.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-clj.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-apollo.js\"></script></head>\n   <body height=\"100%\" onLoad=\"javascript:prettyPrint();\">\n      <div class=\"body_content\" id=\"body-content\" dir=\"ltr\"><a name=\"GUID-B294A257-8EC3-43E8-BC46-D701594C78FD\"></a><div class=\"head\">\n            <h1>Server Maintenance Part 6: Create SQL Maintenance Plan</h1>\n         </div>\n         <p class=\"blurb\">Maintenance plans can be used to schedule tasks required to make sure that the database\n            performs well, such as keeping database and transaction log file sizes small and checking\n            the database for inconsistencies. \n            \n         </p>\n         <p><a name=\"GUID-701FB763-B64F-4CA9-82B3-0D31585FC57D\"></a> Autodesk recommends that the plan be run at least once per week, during out of office\n            hours. \n            	 \n         </p>\n         <p><a name=\"GUID-87EF1ADC-E7F7-45BD-93AF-F9A5DAE16F3B\"></a>In a Connected Workgroup Environment, this should be configured on each SQL Server.\n            \n            	 \n         </p>\n         <p><a name=\"GUID-6C338461-1C4A-4604-84B6-B9680D17AC7C\"></a>Part of the Administrators tasks should be to regularly check that the plan ran successfully.\n            \n            	 \n         </p>\n         <p><a name=\"GUID-1AC3BF36-DCA6-4985-BFF9-3323C4664925\"></a>If the plan was configured for an earlier release of Vault Server, ensure that you\n            check and update the plan in accordance with this article. \n            	 \n         </p>\n         <p><a name=\"GUID-D1C8EC4A-6193-4E33-88DC-F2B111385401\"></a>The following steps are universal across all versions of SQL in use with Vault Server\n            (Express and Full SQL). The complete list of supported database engines is located\n            in the product readme file. \n            	 \n         </p>\n         <div><a name=\"GUID-5980F9FA-DC0A-471C-A691-222F6332B141\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span>Please note that if you are running SQL Express and do not have the SQL Management\n               Studio installed, the following steps can be completed through the command prompt\n               through scripts under the section “Creating a Maintenance Script for Microsoft SQL\n               Express,” or you can install the SQL Management Studio for Express, available from\n               Microsoft‟s web site. \n               	 \n            </div>\n         </div><a name=\"OL_9274FA40959B4DDB8804CE79464DD117\"></a><ol type=\"1\" start=\"1\">\n            <li>Login to the SQL Management Studio. \n               		\n            </li>\n            <li> Expand Databases, expand System Databases. \n               		\n            </li>\n            <li>Right Click on tempdb and select properties. \n               		\n            </li>\n            <li>Select the Files page. \n               		\n            </li>\n            <li>If using a multi-core system, additional data files should be configured, using the\n               guidelines below. If using a single-core system, skip to step d below. \n               		  <a name=\"OL_4646D3C1EBF0471280138F668A7907F6\"></a><ol type=\"1\" start=\"1\">\n                  <li> Data file totals should equal half of the available physical processing cores - up\n                     to a maximum of 8 data files. (example; 8 physical cores would equal 4 total data\n                     files, tempdev, tempdev_2, tempdev_3, tempdev_4) \n                     			 \n                  </li>\n                  <li>Click the Add button to add additional data files. \n                     			 \n                  </li>\n                  <li> Name the new file(s) tempdev_2, tempdev_3, … as needed. \n                     			 \n                  </li>\n                  <li>Set initial size of each data file to 1,024 MB. If using a total of 8 datafiles, an\n                     initial size of 512 MB can be used. \n                     			 \n                  </li>\n                  <li>Set Autogrowth to 100 MB, unrestricted growth for each data file. \n                     			 \n                  </li>\n                  <li>Set the LDF log file to combined data file total. (example; if there are 2 data files\n                     total, the resulting LDF should be set to an initial size of 2048 MB) \n                     			 \n                  </li>\n                  <li>The results will appear similar the image below. \n                     				\n                     <p><a name=\"GUID-D40547FE-AB14-4CF2-96C2-B8F572CCA271\"></a>  \n                     </p> <a name=\"FIG_022139ED2ED04E0A8D554F52E9D81F20\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-5441CF40-08AC-4575-8F15-AEEDB9950BDE-low.png\"></div> \n                  </li>\n               </ol> \n            </li>\n            <li>Under the Options page, set the Recovery model to Simple and the Compatibility level\n               to SQL Server 2012 (110). \n               		\n            </li>\n            <li>Select OK. \n               		\n            </li>\n         </ol>\n         <div class=\"section\"><a name=\"SECTION_27C87A73027E49C0ACBB56B021692EFC\"></a> \n            <h2><a name=\"GUID-41E8B08D-968E-434C-8479-341C5629A435\"></a>Create a SQL Maintenance Plan for Full SQL\n            </h2> \n            <p><a name=\"GUID-50A60B5F-71DB-4132-820A-517019D415A3\"></a>Maintenance plans can be used to schedule tasks required to make sure that the database\n               performs well, such as keeping database and transaction log file size small and checking\n               the database for inconsistencies. \n               		\n            </p> \n            <div><a name=\"GUID-0E2B44C6-3A93-41C2-AC6A-05132F6F1592\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span>These settings are recommended by Autodesk and should be configured automatically\n                  for new installations. If migrated from an earlier release of Vault Server, these\n                  settings are not enforced as they may have been changed intentionally by the Administrator.\n                  \n                  		\n               </div>\n            </div> <a name=\"OL_2F09558B268D4522801AD44E2FB6ED65\"></a><p class=\"list-intro\"><a name=\"GUID-E23CF75B-83BB-45AA-BEDC-323A0BCD866D\"></a>SQL Standard/Enterprise 2012\n            </p>\n            <ol type=\"1\" start=\"1\">\n               <li>Verify that the vaults have been backed up with the Autodesk Vault Server Console\n                  before proceeding. \n                  		  \n               </li>\n               <li>Make sure that all users are logged out of the vault server. \n                  		  \n               </li>\n               <li>From the Control Panel, double-click Administrative Tools and then double-click the\n                  Services icon. \n                  		  \n               </li>\n               <li>Locate the SQL Server Agent (AUTODESKVAULT) service \n                  		  \n               </li>\n               <li>Right-click on the SQL Server Agent (AUTODESKVAULT) and select Properties. \n                  		  \n               </li>\n               <li>. Change the Startup Type to Automatic and start the service. \n                  			 <a name=\"FIG_CCDC6847571F4609A8710D4D8646456B\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-BE0AE8B7-147F-4E4A-BE7D-2BC75C532EC4-low.png\"></div> \n               </li>\n               <li>Open the Microsoft SQL Management Studio and connect to the AutodeskVault instance.\n                  Use &lt;ComputerName&gt;\\AUTODESKVAULT as the server name and press Connect. \n                  		  \n               </li>\n               <li>Right-click on the Vault database and select properties. \n                  		  \n               </li>\n               <li>On the Files page set:- \n                  			 <a name=\"UL_76B220CBCE1540A68D8BE955B0F28199\"></a><ul>\n                     <li>the Autogrowth value for all &lt;Vault&gt; databases to by 100MB, unrestricted growth \n                        				\n                     </li>\n                     <li>the Initial Size value of all &lt;Vault&gt;_log files to 500MB \n                        				\n                     </li>\n                     <li>the Autogrowth value for an &lt;Custom_Library&gt; files to 25MB \n                        				\n                     </li>\n                     <li>the Autogrowth values for all _log files to By 10 percent, unrestricted growth \n                        				\n                     </li>\n                  </ul> \n                  <p><a name=\"GUID-7A1C05C6-077A-4B05-B4EC-8F12325A5FAA\"></a>Or, in table form: \n                     			 \n                  </p> <a name=\"TABLE_589ECDC8EDD94B54B8F98106CAE8AD53\"></a><div class=\"table-not-ruled\">\n                     <table cellpadding=\"0\" cellspacing=\"0\" class=\"not-ruled\">\n                        <colgroup>\n                           <col width=\"28.57142857142857%\">\n                           <col width=\"30%\">\n                           <col width=\"41.42857142857142%\">\n                        </colgroup>\n                        <tr class=\"not-ruled-heading\">\n                           <th class=\"table-heading\"> <a name=\"GUID-1BF7003F-A559-4825-BFFD-FB97D6B18A50\"></a><p class=\"table-heading\">Logical Name \n                                 						  \n                              </p> \n                           </th>\n                           <th class=\"table-heading\"> <a name=\"GUID-231BC906-795B-405E-8884-1569544A41F7\"></a><p class=\"table-heading\">Initial Size (MB) \n                                 						  \n                              </p> \n                           </th>\n                           <th class=\"table-heading\"> <a name=\"GUID-BC8C8F75-C7B1-4F73-9635-04F6FBC3A6D2\"></a><p class=\"table-heading\">Autogrowth \n                                 						  \n                              </p> \n                           </th>\n                        </tr>\n                        <tr class=\"not-ruled-odd-row\">\n                           <td class=\"table-body\"> <a name=\"GUID-C243564C-EAAE-420F-8EC5-D26C04511FAB\"></a><p class=\"table-body\">KnowledgeVaultMaster \n                                 						  \n                              </p> \n                           </td>\n                           <td class=\"table-body\">&nbsp; <a name=\"GUID-BB8AB4F5-598F-4BF5-9ECB-048741718130\"></a><p class=\"table-body\">  </p> \n                           </td>\n                           <td class=\"table-body\"> <a name=\"GUID-A3D6331E-A19A-40AD-B6F2-F8EBFC3D1E3D\"></a><p class=\"table-body\">By 10MB, unrestricted growth \n                                 						  \n                              </p> \n                           </td>\n                        </tr>\n                        <tr class=\"not-ruled-even-row\">\n                           <td class=\"table-body\"> <a name=\"GUID-A622DCCB-0C5F-4B42-9005-F9B4F5DA9F9D\"></a><p class=\"table-body\">KnowledgeVaultMaster_log \n                                 						  \n                              </p> \n                           </td>\n                           <td class=\"table-body\">&nbsp; <a name=\"GUID-76BD87FC-D749-4CA8-9629-3B3905C79EAE\"></a><p class=\"table-body\">  </p> \n                           </td>\n                           <td class=\"table-body\"> <a name=\"GUID-A894530E-5D84-4C64-9B54-26E747F7B11D\"></a><p class=\"table-body\">By 10 percent, unrestricted growth \n                                 						  \n                              </p> \n                           </td>\n                        </tr>\n                        <tr class=\"not-ruled-odd-row\">\n                           <td class=\"table-body\"> <a name=\"GUID-D7DCCAF3-6F3F-492A-B4DB-CA007CA6115D\"></a><p class=\"table-body\">&lt;Vault&gt; \n                                 						  \n                              </p> \n                           </td>\n                           <td class=\"table-body\">&nbsp; <a name=\"GUID-26B07E41-F59F-4F49-8425-F51E73BA3338\"></a><p class=\"table-body\">  </p> \n                           </td>\n                           <td class=\"table-body\"> <a name=\"GUID-9A199818-107C-43D9-9BE4-8755DCDC364A\"></a><p class=\"table-body\">By 100MB, unrestricted growth \n                                 						  \n                              </p> \n                           </td>\n                        </tr>\n                        <tr class=\"not-ruled-even-row\">\n                           <td class=\"table-body\"> <a name=\"GUID-5DB9BF0E-F29F-4097-A83C-710380210B78\"></a><p class=\"table-body\">&lt;Vault&gt;_log \n                                 						  \n                              </p> \n                           </td>\n                           <td class=\"table-body\"> <a name=\"GUID-28DA3532-8C96-43AE-8A3D-783C9B20A7B0\"></a><p class=\"table-body\">500 \n                                 						  \n                              </p> \n                           </td>\n                           <td class=\"table-body\"> <a name=\"GUID-92DC092E-D2FE-4B55-AC7A-5DAB3B77DECE\"></a><p class=\"table-body\">By 10 percent, unrestricted growth \n                                 						  \n                              </p> \n                           </td>\n                        </tr>\n                        <tr class=\"not-ruled-odd-row\">\n                           <td class=\"table-body\"> <a name=\"GUID-DEBE2C9D-8448-43E9-8738-83B403DF0480\"></a><p class=\"table-body\">&lt;Custom_Library&gt; \n                                 						  \n                              </p> \n                           </td>\n                           <td class=\"table-body\">&nbsp; <a name=\"GUID-5CBD77D1-F5AF-4EB5-8226-1E9D26F011AF\"></a><p class=\"table-body\">  </p> \n                           </td>\n                           <td class=\"table-body\"> <a name=\"GUID-7F14CAD4-99BE-479D-8D16-73917ECF7244\"></a><p class=\"table-body\">By 25 MB, unrestricted growth \n                                 						  \n                              </p> \n                           </td>\n                        </tr>\n                        <tr class=\"not-ruled-even-row\">\n                           <td class=\"table-body\"> <a name=\"GUID-D8B69779-4668-4A24-BB99-B34ABB7068BD\"></a><p class=\"table-body\">&lt;Custom_Library&gt;_log \n                                 						  \n                              </p> \n                           </td>\n                           <td class=\"table-body\">&nbsp; <a name=\"GUID-CA5DA034-3F54-447F-8314-3730A6ABF2B1\"></a><p class=\"table-body\">  </p> \n                           </td>\n                           <td class=\"table-body\"> <a name=\"GUID-073C1CFA-7AC2-4B52-B5B8-A31035DB13ED\"></a><p class=\"table-body\">By 10 percent, unrestricted growth \n                                 						  \n                              </p> \n                           </td>\n                        </tr>\n                        <tr class=\"not-ruled-odd-row\">\n                           <td class=\"table-body\"> <a name=\"GUID-F878689B-A11E-4FB6-ACB0-E2B7D43058FF\"></a><p class=\"table-body\">&lt;Standard_Library&gt; \n                                 						  \n                              </p> \n                           </td>\n                           <td class=\"table-body\">&nbsp; <a name=\"GUID-4355D925-E435-44B3-94FF-A9550443848B\"></a><p class=\"table-body\">  </p> \n                           </td>\n                           <td class=\"table-body\"> <a name=\"GUID-AA11E133-4BA0-4FBA-AC4D-97B91DB632FC\"></a><p class=\"table-body\">By 25 MB, unrestricted growth \n                                 						  \n                              </p> \n                           </td>\n                        </tr>\n                        <tr class=\"not-ruled-even-row\">\n                           <td class=\"table-body\"> <a name=\"GUID-3EB28DBE-B0BC-4896-B748-3DB5A3806E2F\"></a><p class=\"table-body\">&lt;Standard_Library&gt;_log \n                                 						  \n                              </p> \n                           </td>\n                           <td class=\"table-body\">&nbsp; <a name=\"GUID-0330585C-1017-4584-B88F-9D9E235D6A69\"></a><p class=\"table-body\">  </p> \n                           </td>\n                           <td class=\"table-body\"> <a name=\"GUID-540145D1-42B5-4249-8965-387CF7044FA6\"></a><p class=\"table-body\">By 10 percent, unrestricted growth \n                                 						  \n                              </p> \n                           </td>\n                        </tr>\n                     </table>\n                  </div> \n                  <div><a name=\"GUID-068B7011-787C-48D8-98E0-A5E8E561B93E\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span>A blank cell in the above table indicates that the default setting should not be changed.\n                        \n                        			 \n                     </div>\n                  </div> \n                  <p><a name=\"GUID-4B61FB73-83D8-4DD7-97CA-54118C73E57D\"></a>Grey cells, indicate default values and should be set to the above if they are different.\n                     \n                     				<a name=\"FIG_D8DAD71C59E9434D80124ED1CE66F132\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-1D758802-DF03-4CF9-9033-158BF6DE92BA-low.png\"></div> \n                  </p> \n                  <p><a name=\"GUID-3FA9A1DB-0166-4783-8C44-95098E14C9B9\"></a>  \n                  </p> \n               </li>\n               <li>On the Options page, change the Recovery Model to Simple, Compatibility Level to SQL\n                  Server 2012 (110) and change the Auto Shrink drop-down list to False. \n                  			 \n                  <p><a name=\"GUID-73A7F6E8-8AA3-45CC-9E07-853AECAF1C19\"></a>  \n                  </p> \n               </li>\n               <li>Perform these same steps for all of the KnowledgeVaultMaster, Vault, and Library Vault\n                  databases (steps 8 – 10). \n                  		  \n               </li>\n               <li>Expand the Management folder and select the Maintenance Plan folder. \n                  		  \n               </li>\n               <li>Right-click on the Maintenance Plan folder and select Maintenance Plan Wizard, hit\n                  next if the following dialog appears. \n                  			 \n                  <p><a name=\"GUID-C378CF13-3C03-4E3E-AA34-C1E223A640CD\"></a>  \n                  </p> <a name=\"FIG_5F01B3BAD64A4337AEF2E1B9B4AAB090\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-630FBFC2-1CD5-4962-ADEF-2C3CB19A1C23-low.png\"></div> \n                  <p><a name=\"GUID-B2103BB6-1E6C-4ED7-AF4C-7AE0749C6A8B\"></a>  \n                  </p> \n               </li>\n               <li>In the Select Plan Properties dialog, enter Vault Maintenance Plan for the name and\n                  then click on the Change button to set the schedule. \n                  			 \n                  <p><a name=\"GUID-9B45752C-1F21-467E-A138-B45393328FFE\"></a>  \n                  </p> <a name=\"FIG_9A2522D29FAF4FF6BCFDA2913D95EAE0\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-D9DFF79B-AE16-4ED5-BFD9-044F07C2C40A-low.png\"></div> \n                  <p><a name=\"GUID-00A8DB52-C0A8-4F4E-BFD6-05E6045BEBFC\"></a>  \n                  </p> \n               </li>\n               <li>In the Job Schedule Properties dialog, set the plan to run after an Autodesk Vault\n                  Server Console backup has completed. Depending on the size of your dataset, this schedule\n                  may have to be run on a different day and time of the week. You may want to run this\n                  task on a Saturday to determine the amount of time it will take to complete and then\n                  decide the best day and time to run this job on a regular basis.  <a name=\"FIG_5FA9842EC34B44228AF5A51AA066E01D\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-2279C031-994C-4ADD-90EE-D336D02C7B5C-low.png\"></div> \n                  <p><a name=\"GUID-69E2C6F2-10FF-4C64-9C2C-E3C8B2235A84\"></a>  \n                  </p> \n               </li>\n               <li>In the Select Maintenance Task dialog, check the following options: \n                  			 \n                  <p><a name=\"GUID-E6EB0F91-91BF-4598-922A-A3376F9E739E\"></a>  \n                  </p> <a name=\"FIG_119F8F050EBF4666B14CD5862D080373\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-4744EF88-07E0-4419-9998-7C0E5A4BCDE0-low.png\"></div> \n                  <p><a name=\"GUID-311C14B5-6AD4-4F65-B2EF-58F7AF0F0DD2\"></a>  \n                  </p> \n               </li>\n               <li>In the Select Maintenance Task Order dialog, set the order to the following: \n                  			 \n                  <p><a name=\"GUID-1F873839-B76C-4E90-B4CE-BB36118195DD\"></a>  \n                  </p> <a name=\"FIG_9882F2B0EFBE483A9A5B54246A5DF352\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-4023E2CB-A9B3-49D8-A5A7-3D7203EEB452-low.png\"></div> \n                  <p><a name=\"GUID-3B1B1725-4F6C-411B-88E7-CD3802CA4C2F\"></a>  \n                  </p> \n               </li>\n               <li>In the Define Database Check Integrity Task dialog, select All user databases from\n                  the databases drop-down list and check the box next to Include Indexes. \n                  			 \n                  <p><a name=\"GUID-A3CC03B9-5781-4B67-AF45-284F7CF1E153\"></a>  \n                  </p> <a name=\"FIG_97BD3EAB24174A16A7FD79E3DB6A2186\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-5EE7F044-4B42-49E8-AA17-957BC8A7CFA9-low.png\"></div> \n                  <p><a name=\"GUID-4005E5AA-FCCC-49B3-BA46-2512072B229F\"></a>  \n                  </p> \n               </li>\n               <li>In the Define Rebuild Index Task dialog, select All user databases from the Databases\n                  drop-down list. \n                  			 \n                  <p><a name=\"GUID-A19D3588-9931-4FA8-BA56-C403BF362655\"></a>  \n                  </p> <a name=\"FIG_FE5FA009570D48FEADEAAF7DF158A807\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-E07AD391-7EC7-4F56-AA8A-84A1D1E4E386-low.png\"></div> \n                  <p><a name=\"GUID-2CFC3847-B8AF-45EA-947E-10B953DB7D38\"></a>  \n                  </p> \n               </li>\n               <li>In the Define Update Statistics Task dialog, select the following options. \n                  			 \n                  <p><a name=\"GUID-4FE66894-2501-4478-8B7F-D3E7B42D3D4B\"></a>  \n                  </p> <a name=\"FIG_128EDD57DE864C558BA7AD71DF560CC0\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-CD8BF539-1D9F-4BE7-BF9F-1AF19EAE47E2-low.png\"></div> \n                  <p><a name=\"GUID-CEBC7A2D-8BB1-4564-A854-AFDF74C5C852\"></a>  \n                  </p> \n               </li>\n               <li>In the Define Cleanup History Task dialog, select cleanup options as needed. \n                  			 \n                  <p><a name=\"GUID-B82FCF19-A076-40C5-9337-45AED2FCC284\"></a>  \n                  </p> <a name=\"FIG_2EA8A6E667174F85A76F003F346A6B45\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-0DDA4E7B-1475-4AB0-AF5D-E713EB571763-low.png\"></div> \n                  <p><a name=\"GUID-9CE910F7-0F43-4BE8-9CA0-C46E9E361014\"></a>  \n                  </p> \n               </li>\n               <li>In the Select Report Options dialog, specify the location for the maintenance reports.\n                  \n                  		  \n               </li>\n               <li>Click Next and then Finish. \n                  		  \n               </li>\n            </ol> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_30D430B0C7BA449D8DFEDD94303BD17D\"></a> \n            <h2><a name=\"GUID-E791A35D-B15C-4302-80BB-A28057B1B149\"></a>Create a Maintenance Script for Microsoft SQL Express\n            </h2> \n            <p><a name=\"GUID-859F9E59-B3C0-4EE2-8BA8-417E465340CD\"></a>Microsoft SQL Express does not allow you to create a maintenance plan inside of SQL\n               Server Management Studio Express. \n               		\n            </p> \n            <p><a name=\"GUID-F6476E16-5473-4B4F-9549-DD65711B7F06\"></a>Make sure that the OS (Windows) user that is running the SQL maintenance plan has\n               the sysadmin role inside of SQL. \n               		\n            </p> <a name=\"OL_9E11D0855CFC48139ED550D5E819D405\"></a><p class=\"list-intro\"><a name=\"GUID-5FDFBB9E-E91C-4B67-85F3-210C347B2B49\"></a>Tempdb Modifications through the Command Prompt\n            </p>\n            <p><a name=\"GUID-DD77B1EF-2AEE-4747-BE67-95E11C7B08FA\"></a>As noted earlier in this section, if the SQL Server Management Studio is not installed,\n               the tempdb database changes can be completed through the command prompt by performing\n               the following: \n               		\n            </p>\n            <ol type=\"1\" start=\"1\">\n               <li>Open the Command Prompt as Administrator. \n                  		\n               </li>\n               <li>Copy and Paste each line below into the command prompt and press Enter. \n                  		  \n                  <p><a name=\"GUID-D645602B-5876-40DE-BCE3-81C054035269\"></a>  \n                  </p> \n                  <p><a name=\"GUID-BEE507EB-53EC-40AB-AD61-EBC68F0079F4\"></a> \n                     <div class=\"codeBlock\"><pre class=\"prettyprint\">SQLCMD -E -S\".\\AutodeskVault\" -Q \"ALTER DATABASE [tempdb] SET COMPATIBILITY_LEVEL = 110\"</pre></div> \n                     <div class=\"codeBlock\"><pre class=\"prettyprint\">SQLCMD -E -S \".\\AutodeskVault\" -Q \"ALTER DATABASE [tempdb] MODIFY FILE ( NAME = \nN\'tempdev\', SIZE = 1024MB, FILEGROWTH = 100MB)\"</pre></div> \n                     <div class=\"codeBlock\"><pre class=\"prettyprint\">SQLCMD -E -S \".\\AutodeskVault\" -Q \"ALTER DATABASE [tempdb] MODIFY FILE ( NAME = \nN\'templog\', SIZE = 1024MB )\"</pre></div> <a name=\"FIG_365E72A246ED44D19FF523FBDFB63420\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-93ED25CB-411E-4320-ADE8-0E7B7B496162-low.png\"></div> \n                  </p> \n                  <p><a name=\"GUID-BD90334C-76C4-41EF-B2CE-0CA80946D6C6\"></a>  \n                  </p> \n               </li>\n               <li>If using a multi-core system, additional data files should be configured using the\n                  guidelines below. **Note The file system path used under FILENAME = should be the\n                  same location as the SQL data directory. In the example below, it is \'C:\\Program Files\\Microsoft\n                  SQL Server\\MSSQL10.AUTODESKVAULT\\MSSQL\\DATA. You will want to modify the script to\n                  list your correct path. \n                  		  <a name=\"OL_58C763E9D3C44A1B8C88A68F66223DA4\"></a><ol type=\"1\" start=\"1\">\n                     <li>Data file totals should equal half of the available physical processing cores - up\n                        to a maximum of 8 data files. If using a total of 8 datafiles, an initial size of\n                        512 MB can be used instead of 1024 MB as shown below. (example; 8 physical cores would\n                        equal 4 total data files, tempdev, tempdev_2, tempdev_3, tempdev_4) \n                        				\n                        <p><a name=\"GUID-C7911F47-9F30-4427-91CA-43143629138A\"></a> \n                           <div class=\"codeBlock\"><pre class=\"prettyprint\">SQLCMD -E -S \".\\AutodeskVault\" -Q \" ALTER DATABASE [tempdb] ADD FILE ( NAME = \nN\'tempdev_2\', FILENAME = N\'C:\\Program Files\\Microsoft SQL \nServer\\MSSQL10.AUTODESKVAULT\\MSSQL\\DATA\\tempdev_2.ndf\', SIZE = 1024MB, \nFILEGROWTH = 100MB)\"</pre></div> \n                        </p> \n                        <p><a name=\"GUID-4DD790D9-37B3-4F13-89F3-A94C5F24D349\"></a> <a name=\"FIG_F34D07908FC049B1954D459758841F98\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-277781B3-57D3-42BD-BADA-311A75F7D83A-low.png\"></div> \n                        </p> \n                     </li>\n                     <li>If additional data files need to be created, simply modify the above example to reflect\n                        tempdev_3, etc, for both NAME and FILENAME. \n                        			 \n                     </li>\n                     <li>Set the LDF log file to combined data file total. (example; if there are 2 data files\n                        total, the resulting LDF should be set to an initial size of 2048 MB). \n                        				\n                        <p><a name=\"GUID-8627A678-6B96-4556-8F1D-69F28818E664\"></a> \n                           <div class=\"codeBlock\"><pre class=\"prettyprint\">SQLCMD -E -S \".\\AutodeskVault\" -Q \"ALTER DATABASE [tempdb] MODIFY FILE ( \nNAME = N\'templog\', SIZE = 2048MB )\"</pre></div> \n                        </p> \n                        <p><a name=\"GUID-0B130019-9F4A-42B9-B267-FE106D9691E3\"></a> <a name=\"FIG_49ACC9F6625B41D483E7984213D04DEF\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-70D43304-675B-4FD8-9663-DE4C755144E9-low.png\"></div> \n                        </p> \n                     </li>\n                  </ol> \n               </li>\n            </ol> <a name=\"OL_4A26BFE08F5447D8A6510CF89573F261\"></a><p class=\"list-intro\"><a name=\"GUID-7F09A2F3-F1F3-4956-9398-58506BFC4128\"></a>Maintenance Plan\n            </p>\n            <p><a name=\"GUID-75057280-6545-4A60-8CAA-2A355D9FC04D\"></a>Copy the script below and paste it into a new file saved as VaultMaintenance.bat.\n               \n               		\n            </p>\n            <p><a name=\"GUID-A0F37A13-37D9-4E7B-9691-5FDA2B3306BA\"></a>The following is an example of how to run the batch file from the root of C:\\ against\n               a database named Vault and output the results to a text file. \n               		\n            </p>\n            <p><a name=\"GUID-A19A99B7-4757-4978-9C73-37FA633EA475\"></a> \n               <div class=\"codeBlock\"><pre class=\"prettyprint\">C:\\VaultMaintenance.bat Vault &gt; results.txt</pre></div> \n            </p>\n            <div><a name=\"GUID-BF7FC4F1-2F77-4662-8427-746737F41F35\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span>A direct copy-paste from this document will require the line breaks be repaired. Also\n                  note that the user executing the maintenance plan will need to have permissions to\n                  do so inside of SQL. This can be accomplished during the installation of SQL or after.\n                  \n                  		\n               </div>\n            </div>\n            <p><a name=\"GUID-932EA1B5-9A6E-444B-A9B9-0F21A7478B73\"></a> \n               <div class=\"codeBlock\"><pre class=\"prettyprint\">REM This begins the maintenance plan.\n@echo off\nif \"%1\"==\"\" goto NOPARAM\nset VAULTNAME=[%1]\nset VAULTLOG=[%1_log]\n@echo Setting %VAULTNAME% database compatibility to 110\nsqlcmd -E -S \".\\AutodeskVault\" -Q \"ALTER DATABASE %VAULTNAME% SET \nCOMPATIBILITY_LEVEL = 110\"\n@echo Setting %VAULTNAME% database recovery model to simple...\nsqlcmd -E -S \".\\AutodeskVault\" -Q \"ALTER DATABASE %VAULTNAME% SET RECOVERY \nSIMPLE\"\n@echo Setting %VAULTNAME% database Autogrowth value...\nsqlcmd -E -S \".\\AutodeskVault\" -Q \"ALTER DATABASE %VAULTNAME%  MODIFY FILE \n(NAME=%VAULTNAME%, FILEGROWTH=100MB)\"\n@echo Setting %VAULTNAME% database Log filesize...\nsqlcmd -E -S \".\\AutodeskVault\" -Q \"ALTER DATABASE %VAULTNAME% MODIFY FILE ( NAME = \n%VAULTLOG%, SIZE = 512000KB )\"\n@echo Setting %VAULTNAME% database Autoclose to false...\nsqlcmd -E -S \".\\AutodeskVault\" -Q \"ALTER DATABASE %VAULTNAME% SET AUTO_CLOSE OFF \nWITH NO_WAIT\"\n@echo Reindexing %VAULTNAME% database...\nsqlcmd -E -S \".\\AutodeskVault\" -Q \"USE %VAULTNAME% DECLARE tableCursor CURSOR FOR \nSELECT NAME FROM sysobjects WHERE xtype in(\'U\') DECLARE @tableName nvarchar(128) \nOPEN tableCursor FETCH NEXT FROM tableCursor INTO @tableName WHILE \n@@FETCH_STATUS = 0 BEGIN DBCC DBREINDEX(@tableName, \'\') FETCH NEXT FROM \ntableCursor INTO @tableName END CLOSE tableCursor DEALLOCATE tableCursor\"\n@echo Updating Statistics on %VAULTNAME% database...\nsqlcmd -E -S \".\\AutodeskVault\" -Q \"USE %VAULTNAME% Exec sp_MSForEachTable \'Update \nStatistics ? WITH FULLSCAN\'\"\ngoto EXIT\n:NOPARAM\necho [FAIL] Please indicate Vault database\npause\n:EXIT\nREM This ends the maintenance plan.</pre></div> \n            </p> \n         </div>\n         <div class=\"footer-block\"><a href=\"..\" class=\"comments-anchor\" target=\"_blank\"><span class=\"comments-link\">Please send us your comment about this page</span></a></div><br><p class=\"footer-license-block\"><a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\"><img alt=\"Creative Commons License\" style=\"border-width: 0;\" src=\"../images/ccLink.png\"></a>&nbsp;<em>Except where otherwise noted, this work is licensed under a <a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\">Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License</a>. Please see the <a href=\"http://autodesk.com/creativecommons\" target=\"_blank\">Autodesk Creative Commons FAQ</a> for more information.</em></p><br></div>\n   </body>\n</html>";
// SIG // Begin signature block
// SIG // MIIZfQYJKoZIhvcNAQcCoIIZbjCCGWoCAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // /lecoPeS0NK13NUJyW+NFWvqFB5WqSVTBUsDk9kCqLKg
// SIG // ggoaMIIEyzCCA7OgAwIBAgIQCQja65wGHi65un4mqmKH
// SIG // ijANBgkqhkiG9w0BAQsFADCBhDELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTUw
// SIG // MwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
// SIG // b2RlIFNpZ25pbmcgQ0EgLSBHMjAeFw0xOTA1MTQwMDAw
// SIG // MDBaFw0yMDA1MTMyMzU5NTlaMHwxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIDApDYWxpZm9ybmlhMRMwEQYDVQQHDApT
// SIG // YW4gUmFmYWVsMRcwFQYDVQQKDA5BdXRvZGVzaywgSW5j
// SIG // LjERMA8GA1UECwwIU2VjdXJpdHkxFzAVBgNVBAMMDkF1
// SIG // dG9kZXNrLCBJbmMuMIIBIjANBgkqhkiG9w0BAQEFAAOC
// SIG // AQ8AMIIBCgKCAQEAkVKRoPYsoxPdlabspcuG8HYDfcWQ
// SIG // 9qyPOT2punwpVdjt2slktcpSTlydrGy8ijcbl5/k8AOJ
// SIG // afKMQvow0fNjIoNB5nsb8j2xFJPbBhHl8GT4P6DZ1OWK
// SIG // ioiUXgGHKjctUws49J4elntqvBYhKCbuPqG772QCoYFU
// SIG // P7qcFbh3PbyNB6cnKMn2vNGRqiEtV2aGg+/MiL3QPsvT
// SIG // kTWhVuTLIvwZ4kK5C5ACiQzlGOlE+C7gWuFoxtvy6gUa
// SIG // A8JAq/xLjYKwFevQwGncg3s1cuiGhx0P7Rvn6oCd2cem
// SIG // FmbK3I3rMRt+jc9wzAj3oHxvCo4f5Lfva+OpC1dETUVV
// SIG // sk0VGwIDAQABo4IBPjCCATowCQYDVR0TBAIwADAOBgNV
// SIG // HQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMw
// SIG // YQYDVR0gBFowWDBWBgZngQwBBAEwTDAjBggrBgEFBQcC
// SIG // ARYXaHR0cHM6Ly9kLnN5bWNiLmNvbS9jcHMwJQYIKwYB
// SIG // BQUHAgIwGQwXaHR0cHM6Ly9kLnN5bWNiLmNvbS9ycGEw
// SIG // HwYDVR0jBBgwFoAU1MAGIknrOUvdk+JcobhHdglyA1gw
// SIG // KwYDVR0fBCQwIjAgoB6gHIYaaHR0cDovL3JiLnN5bWNi
// SIG // LmNvbS9yYi5jcmwwVwYIKwYBBQUHAQEESzBJMB8GCCsG
// SIG // AQUFBzABhhNodHRwOi8vcmIuc3ltY2QuY29tMCYGCCsG
// SIG // AQUFBzAChhpodHRwOi8vcmIuc3ltY2IuY29tL3JiLmNy
// SIG // dDANBgkqhkiG9w0BAQsFAAOCAQEA0Q2+iVSEfT4xGq3A
// SIG // OADVb0rT5Z8E+PPb1x6hKknSzuaZKk/acDz9mdnFajaU
// SIG // WgIKiFJlsqJnuAM1w4lqKaEWsz3DoxvGIEwexj71Ud6a
// SIG // KlBJNcR9DdkXUZwMhbw9d78rjJAIX6tOwfSludZfdq8b
// SIG // YEkuIzQi9uYW9vHVPSCzhnUBKjwc9qTo9yBc7Fcn4FAT
// SIG // 90DzWM2hS9oc3p0pprYI2I/O4th90BEmwWkVqVgfaR0z
// SIG // VyIEmBbqB/IWLfjUBZJ/8sbkwWuWlYVRrfPxsj1e9qvb
// SIG // wE3Y28jWyGbqoUG39GhXk3uT8R8i3+T6M0c4rMfdifBC
// SIG // pceCaFTJzSye7LoeVzCCBUcwggQvoAMCAQICEHwbNTVK
// SIG // 59t050FfEWnKa6gwDQYJKoZIhvcNAQELBQAwgb0xCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjEfMB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29y
// SIG // azE6MDgGA1UECxMxKGMpIDIwMDggVmVyaVNpZ24sIElu
// SIG // Yy4gLSBGb3IgYXV0aG9yaXplZCB1c2Ugb25seTE4MDYG
// SIG // A1UEAxMvVmVyaVNpZ24gVW5pdmVyc2FsIFJvb3QgQ2Vy
// SIG // dGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMTQwNzIyMDAw
// SIG // MDAwWhcNMjQwNzIxMjM1OTU5WjCBhDELMAkGA1UEBhMC
// SIG // VVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9u
// SIG // MR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3Jr
// SIG // MTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1
// SIG // NiBDb2RlIFNpZ25pbmcgQ0EgLSBHMjCCASIwDQYJKoZI
// SIG // hvcNAQEBBQADggEPADCCAQoCggEBANeVQ9Tc32euOftS
// SIG // pLYmMQRw6beOWyq6N2k1lY+7wDDnhthzu9/r0XY/ilaO
// SIG // 6y1L8FcYTrGNpTPTC3Uj1Wp5J92j0/cOh2W13q0c8fU1
// SIG // tCJRryKhwV1LkH/AWU6rnXmpAtceSbE7TYf+wnirv+9S
// SIG // rpyvCNk55ZpRPmlfMBBOcWNsWOHwIDMbD3S+W8sS4duM
// SIG // xICUcrv2RZqewSUL+6McntimCXBx7MBHTI99w94Zzj7u
// SIG // BHKOF9P/8LIFMhlM07Acn/6leCBCcEGwJoxvAMg6ABFB
// SIG // ekGwp4qRBKCZePR3tPNgKuZsUAS3FGD/DVH0qIuE/iHa
// SIG // XF599Sl5T7BEdG9tcv8CAwEAAaOCAXgwggF0MC4GCCsG
// SIG // AQUFBwEBBCIwIDAeBggrBgEFBQcwAYYSaHR0cDovL3Mu
// SIG // c3ltY2QuY29tMBIGA1UdEwEB/wQIMAYBAf8CAQAwZgYD
// SIG // VR0gBF8wXTBbBgtghkgBhvhFAQcXAzBMMCMGCCsGAQUF
// SIG // BwIBFhdodHRwczovL2Quc3ltY2IuY29tL2NwczAlBggr
// SIG // BgEFBQcCAjAZGhdodHRwczovL2Quc3ltY2IuY29tL3Jw
// SIG // YTA2BgNVHR8ELzAtMCugKaAnhiVodHRwOi8vcy5zeW1j
// SIG // Yi5jb20vdW5pdmVyc2FsLXJvb3QuY3JsMBMGA1UdJQQM
// SIG // MAoGCCsGAQUFBwMDMA4GA1UdDwEB/wQEAwIBBjApBgNV
// SIG // HREEIjAgpB4wHDEaMBgGA1UEAxMRU3ltYW50ZWNQS0kt
// SIG // MS03MjQwHQYDVR0OBBYEFNTABiJJ6zlL3ZPiXKG4R3YJ
// SIG // cgNYMB8GA1UdIwQYMBaAFLZ3+mlIR59TEtXC6gcydgfR
// SIG // lwcZMA0GCSqGSIb3DQEBCwUAA4IBAQB/68qn6ot2Qus+
// SIG // jiBUMOO3udz6SD4Wxw9FlRDNJ4ajZvMC7XH4qsJVl5Fw
// SIG // g/lSflJpPMnx4JRGgBi7odSkVqbzHQCR1YbzSIfgy8Q0
// SIG // aCBetMv5Be2cr3BTJ7noPn5RoGlxi9xR7YA6JTKfRK9u
// SIG // QyjTIXW7l9iLi4z+qQRGBIX3FZxLEY3ELBf+1W5/muJW
// SIG // kvGWs60t+fTf2omZzrI4RMD3R3vKJbn6Kmgzm1By3qif
// SIG // 1M0sCzS9izB4QOCNjicbkG8avggVgV3rL+JR51EeyXgp
// SIG // 5x5lvzjvAUoBCSQOFsQUecFBNzTQPZFSlJ3haO8I8OJp
// SIG // nGdukAsak3HUJgLDwFojMYIOuzCCDrcCAQEwgZkwgYQx
// SIG // CzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRlYyBD
// SIG // b3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1
// SIG // c3QgTmV0d29yazE1MDMGA1UEAxMsU3ltYW50ZWMgQ2xh
// SIG // c3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENBIC0gRzIC
// SIG // EAkI2uucBh4uubp+Jqpih4owDQYJYIZIAWUDBAIBBQCg
// SIG // fDAQBgorBgEEAYI3AgEMMQIwADAZBgkqhkiG9w0BCQMx
// SIG // DAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4wDAYK
// SIG // KwYBBAGCNwIBFTAvBgkqhkiG9w0BCQQxIgQg4afmMc8a
// SIG // yMdOyIxX1Jbpx0n284GkVTiWXPtLhFJjS2YwDQYJKoZI
// SIG // hvcNAQEBBQAEggEAYxFC0zNOcycjgaqnxTgSSC8T57pB
// SIG // iywsUhrCR+4Ajw0Sx7q6HuNBwdB6w06y8jnWwzU8MYPM
// SIG // gd1mWPJn13eQ2MSvFVQfQinXpsxOB9d8S+U4w7p6uiQM
// SIG // xJaNAx9o/c658lpNL+hqsnJb9jTfQMvfiY9Vy6KYkfV+
// SIG // F1MDmWnnLfTGLhHOABkrb/p1gT9Qmu0D6r2vZsihnfm8
// SIG // nMDJn54uFznAZCHlxu2bE62x/rEwqNek+amJ/AWYNurI
// SIG // Jw9iLbS15SYwUTYrHMWmrTUgVKJwU2l3oHzsiLgrKVPt
// SIG // LVQToEA42Qg543Fm60R9jljRVdaapv+8ZMnV/FJF5dhN
// SIG // f4VvraGCDHQwggxwBgorBgEEAYI3AwMBMYIMYDCCDFwG
// SIG // CSqGSIb3DQEHAqCCDE0wggxJAgEDMQ8wDQYJYIZIAWUD
// SIG // BAIBBQAwga8GCyqGSIb3DQEJEAEEoIGfBIGcMIGZAgEB
// SIG // BgkrBgEEAaAyAgMwMTANBglghkgBZQMEAgEFAAQgDwp/
// SIG // vOssbcqyRJy+Cg5HLm6eFSWKV2CSQfNss19U84YCFEDZ
// SIG // SYFDLFlOG8RlM2gKpULWynEeGA8yMDIwMDMyMzE0MDIy
// SIG // OFqgL6QtMCsxKTAnBgNVBAMMIEdsb2JhbFNpZ24gVFNB
// SIG // IGZvciBBZHZhbmNlZCAtIEcyoIII0zCCBLYwggOeoAMC
// SIG // AQICDAynz10HBySsieeaOjANBgkqhkiG9w0BAQsFADBb
// SIG // MQswCQYDVQQGEwJCRTEZMBcGA1UEChMQR2xvYmFsU2ln
// SIG // biBudi1zYTExMC8GA1UEAxMoR2xvYmFsU2lnbiBUaW1l
// SIG // c3RhbXBpbmcgQ0EgLSBTSEEyNTYgLSBHMjAeFw0xODAy
// SIG // MTkwMDAwMDBaFw0yOTAzMTgxMDAwMDBaMCsxKTAnBgNV
// SIG // BAMMIEdsb2JhbFNpZ24gVFNBIGZvciBBZHZhbmNlZCAt
// SIG // IEcyMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKC
// SIG // AQEAt8eSiijY85HLUA1d6ylEwYJZpcpkzr2DtVHllMxu
// SIG // gJoXbNz/YuY2Q14Bwgxkjcp3nvZdd0W5Xsgk60E3EWY3
// SIG // rMjNdJvMs+9M4n8bznO+yZadNR5891T3bOygEtaumZ1j
// SIG // xHhfWakuIvXDJ9iyW0VjJ5D/jLE9qbTzDsDxIGUGiZ0D
// SIG // HKOwUkGFNOu8y85U9hL+swGJSqb6VMUf+9McwOO/l+M/
// SIG // 0Bv5QMcb1esmfEMwx3DyeBGqhU6lDg0ASjoRd6PKIwGA
// SIG // nsiTVl1GzIrY0qoKhIWyiVvVMs5BexhOVMqr0VJeEtMk
// SIG // nlbzDI/dvZKOedVBicOjoOWR/MdnnYczznEycwIDAQAB
// SIG // o4IBqDCCAaQwDgYDVR0PAQH/BAQDAgeAMEwGA1UdIARF
// SIG // MEMwQQYJKwYBBAGgMgEeMDQwMgYIKwYBBQUHAgEWJmh0
// SIG // dHBzOi8vd3d3Lmdsb2JhbHNpZ24uY29tL3JlcG9zaXRv
// SIG // cnkvMAkGA1UdEwQCMAAwFgYDVR0lAQH/BAwwCgYIKwYB
// SIG // BQUHAwgwRgYDVR0fBD8wPTA7oDmgN4Y1aHR0cDovL2Ny
// SIG // bC5nbG9iYWxzaWduLmNvbS9ncy9nc3RpbWVzdGFtcGlu
// SIG // Z3NoYTJnMi5jcmwwgZgGCCsGAQUFBwEBBIGLMIGIMEgG
// SIG // CCsGAQUFBzAChjxodHRwOi8vc2VjdXJlLmdsb2JhbHNp
// SIG // Z24uY29tL2NhY2VydC9nc3RpbWVzdGFtcGluZ3NoYTJn
// SIG // Mi5jcnQwPAYIKwYBBQUHMAGGMGh0dHA6Ly9vY3NwMi5n
// SIG // bG9iYWxzaWduLmNvbS9nc3RpbWVzdGFtcGluZ3NoYTJn
// SIG // MjAdBgNVHQ4EFgQULW5u0Y3lA4Du52Ppp9naCzxXIj0w
// SIG // HwYDVR0jBBgwFoAUkiGnSpVdZLCbtB7mADdH5p1BK0ww
// SIG // DQYJKoZIhvcNAQELBQADggEBAI39HR+PiNNl+LVcRumn
// SIG // 07Y/SstDBcIHDcNeA4QjN6h6jJcj/yechH1h61xLVz6b
// SIG // 9ETbgFj3tmXejxIKX6eHdLfaFECHUeyfSkdV8BfoGD5x
// SIG // IDHmKCKrTvaunGvC50T7aA0gf1M/lBuhhoJOMhYQWj+J
// SIG // WMHQtNu2kPuNMumhS0ZQN7bDOukpJBKSWk4rubYKejaM
// SIG // l8DviXwz3jHhoZfk50WtYVL9WonTVH6KTVuJew6Wd9Hy
// SIG // PDgb2vmlYSBlArzFrdcMYhAoLN2246hhAKwIJqONhdBk
// SIG // yTaQHopSyYeNNaVdSJH8k6alZfHs+TrcpSyeBG1iM/7e
// SIG // +p/Fzq+V81Go8s4wggQVMIIC/aADAgECAgsEAAAAAAEx
// SIG // icZQBDANBgkqhkiG9w0BAQsFADBMMSAwHgYDVQQLExdH
// SIG // bG9iYWxTaWduIFJvb3QgQ0EgLSBSMzETMBEGA1UEChMK
// SIG // R2xvYmFsU2lnbjETMBEGA1UEAxMKR2xvYmFsU2lnbjAe
// SIG // Fw0xMTA4MDIxMDAwMDBaFw0yOTAzMjkxMDAwMDBaMFsx
// SIG // CzAJBgNVBAYTAkJFMRkwFwYDVQQKExBHbG9iYWxTaWdu
// SIG // IG52LXNhMTEwLwYDVQQDEyhHbG9iYWxTaWduIFRpbWVz
// SIG // dGFtcGluZyBDQSAtIFNIQTI1NiAtIEcyMIIBIjANBgkq
// SIG // hkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqpuOw6sRUSUB
// SIG // tpaU4k/YwQj2RiPZRcWVl1urGr/SbFfJMwYfoA/GPH5T
// SIG // SHq/nYeer+7DjEfhQuzj46FKbAwXxKbBuc1b8R5EiY7+
// SIG // C94hWBPuTcjFZwscsrPxNHaRossHbTfFoEcmAhWkkJGp
// SIG // eZ7X61edK3wi2BTX8QceeCI2a3d5r6/5f45O4bUIMf3q
// SIG // 7UtxYowj8QM5j0R5tnYDV56tLwhG3NKMvPSOdM7IaGlR
// SIG // dhGLD10kWxlUPSbMQI2CJxtZIH1Z9pOAjvgqOP1roEBl
// SIG // H1d2zFuOBE8sqNuEUBNPxtyLufjdaUyI65x7MCb8eli7
// SIG // WbwUcpKBV7d2ydiACoBuCQIDAQABo4HoMIHlMA4GA1Ud
// SIG // DwEB/wQEAwIBBjASBgNVHRMBAf8ECDAGAQH/AgEAMB0G
// SIG // A1UdDgQWBBSSIadKlV1ksJu0HuYAN0fmnUErTDBHBgNV
// SIG // HSAEQDA+MDwGBFUdIAAwNDAyBggrBgEFBQcCARYmaHR0
// SIG // cHM6Ly93d3cuZ2xvYmFsc2lnbi5jb20vcmVwb3NpdG9y
// SIG // eS8wNgYDVR0fBC8wLTAroCmgJ4YlaHR0cDovL2NybC5n
// SIG // bG9iYWxzaWduLm5ldC9yb290LXIzLmNybDAfBgNVHSME
// SIG // GDAWgBSP8Et/qC5FJK5NUPpjmove4t0bvDANBgkqhkiG
// SIG // 9w0BAQsFAAOCAQEABFaCSnzQzsm/NmbRvjWek2yX6AbO
// SIG // MRhZ+WxBX4AuwEIluBjH/NSxN8RooM8oagN0S2OXhXdh
// SIG // O9cv4/W9M6KSfREfnops7yyw9GKNNnPRFjbxvF7stICY
// SIG // ePzSdnno4SGU4B/EouGqZ9uznHPlQCLPOc7b5neVp7uy
// SIG // y/YZhp2fyNSYBbJxb051rvE9ZGo7Xk5GpipdCJLxo/Md
// SIG // dL9iDSOMXCo4ldLA1c3PiNofKLW6gWlkKrWmotVzr9xG
// SIG // 2wSukdduxZi61EfEVnSAR3hYjL7vK/3sbL/RlPe/UOB7
// SIG // 4JD9IBh4GCJdCC6MHKCX8x2ZfaOdkdMGRE4EbnocIOM2
// SIG // 8LZQuTGCAqgwggKkAgEBMGswWzELMAkGA1UEBhMCQkUx
// SIG // GTAXBgNVBAoTEEdsb2JhbFNpZ24gbnYtc2ExMTAvBgNV
// SIG // BAMTKEdsb2JhbFNpZ24gVGltZXN0YW1waW5nIENBIC0g
// SIG // U0hBMjU2IC0gRzICDAynz10HBySsieeaOjANBglghkgB
// SIG // ZQMEAgEFAKCCAQ4wGgYJKoZIhvcNAQkDMQ0GCyqGSIb3
// SIG // DQEJEAEEMBwGCSqGSIb3DQEJBTEPFw0yMDAzMjMxNDAy
// SIG // MjhaMC8GCSqGSIb3DQEJBDEiBCA9tXlujv0KTWR+6TZa
// SIG // L3nk8RcJmSDZ1oyvVlRmSC6axDCBoAYLKoZIhvcNAQkQ
// SIG // AgwxgZAwgY0wgYowgYcEFJsSBXrnKq/21jdytJ9qI28m
// SIG // Sc2pMG8wX6RdMFsxCzAJBgNVBAYTAkJFMRkwFwYDVQQK
// SIG // ExBHbG9iYWxTaWduIG52LXNhMTEwLwYDVQQDEyhHbG9i
// SIG // YWxTaWduIFRpbWVzdGFtcGluZyBDQSAtIFNIQTI1NiAt
// SIG // IEcyAgwMp89dBwckrInnmjowDQYJKoZIhvcNAQEBBQAE
// SIG // ggEASR8HGBQHnaYfLa87o4lZvA9JDxqw9E1MkqnC84XH
// SIG // Zcnz4bKh0QIkC1nKOKbsrIwEhnoDeNgOzvaSfrTae6fx
// SIG // dQ2hF4XN3UmtvZNUuV7lu4kXlcxbzUeR1o7PkgPLeAiS
// SIG // 8iBYmr+0ypijZDYQJX2mg2yu5hUQVf9sWOpIttu+pCjl
// SIG // L2vCF6q88Fjlc32vDSZsgOaLGttXfsq5Ur1pP/m1vOrM
// SIG // deWN/3eMbvqQ/7rkFfJj8HegR4B24qBBWlzhDtM3dT/n
// SIG // 6Ad3OymBrofk2IzfSh/uthZeif91DZ4cyMqOf1uT4mL7
// SIG // nejUoHwE+EHb58zqLGzpcZVo7rU8LY6CpdBooA==
// SIG // End signature block
