var topic = "<!DOCTYPE html>\r\n\n<!-- saved from url=(0024)http://docs.autodesk.com -->\r\n<html>\n   <head>\n      <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n      <meta name=\"product\" content=\"VAULT\">\n      <meta name=\"release\" content=\"2021\">\n      <meta name=\"book\" content=\"GeneralUser\">\n      <meta name=\"created\" content=\"2020-03-20\">\n      <meta name=\"topicid\" content=\"GUID-A726B569-6C54-4835-A1E0-703995828826\">\n      <meta name=\"description\" content=\"Leverage Vault numbering schemes to enforce file names when a user creates a new Data Standard file.\">\n      <meta name=\"topic-type\" content=\"concept\">\n      <meta name=\"audience\" content=\"administrator\">\n      <meta name=\"experiencelevel\" content=\"general\">\n      <title>Sample–Using Numbering Schemes in Data Standard Dialogs</title><script language=\"javascript\">var index = \'index.html\';</script><script type=\"text/javascript\" src=\"../scripts/prettify/prettify.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-yaml.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-xq.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-wiki.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-vhdl.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-vb.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-tex.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-sql.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-scala.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-proto.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-n.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-ml.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-lua.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-lisp.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-hs.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-go.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-css.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-clj.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-apollo.js\"></script></head>\n   <body height=\"100%\" onLoad=\"javascript:prettyPrint();\">\n      <div class=\"body_content\" id=\"body-content\" dir=\"ltr\"><a name=\"GUID-A726B569-6C54-4835-A1E0-703995828826\"></a><div class=\"head\">\n            <h1>Sample–Using Numbering Schemes in Data Standard Dialogs</h1>\n         </div>\n         <p class=\"blurb\">Leverage Vault numbering schemes to enforce file names when a user creates a new Data\n            Standard file. \n            \n         </p>\n         <div class=\"section\"><a name=\"SECTION_3B8353ACF49A4268B3F919DD08C03FA8\"></a> \n            <h2><a name=\"GUID-4B1B51C3-C5AD-4393-AB46-593FC149E8CA\"></a>Filtering Numbering Schemes\n            </h2> \n            <p> In the installed sample, the Number Scheme combo box shows all activated numbering\n               schemes. In the XAML file, the combo box is bound to a PowerShell function called\n               \n               		  <span class=\"code\">GetNumSchms</span>. \n               		\n            </p> \n            <p> </p> \n            <p> <a name=\"FIG_778736934541439BBCB2EC1B6E3E783C\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-42659897-7D8E-4036-AAD8-E21D84BCCC4C-low.png\"></div> \n            </p> \n            <p> </p> \n            <p>The \n               		  <span class=\"code\">GetNumSchms</span> function makes it easy to control which schemes should be shown to the user. \n               		\n            </p> <a name=\"UL_BDC5BCD07E9145CAA7AC9AF5473CDD47\"></a><p class=\"list-intro\">Filtering Numbering Schemes in Inventor Based on File Type</p>\n            <p>Without Data Standard, the user can always select between all activated Vault numbering\n               schemes. With the following implementation of \n               		  <span class=\"code\">GetNumSchms</span>, different schemes will be available for components (IPT, IAM) and drawings (IDW,\n               IPN and DWG). To make the sample work, numbering schemes that start with COMP or DRAWING\n               need to be defined in Vault: \n               		\n            </p>\n            <p><em class=\"strong\">C:\\ProgramData\\Autodesk\\&lt;Vault Version&gt;\\Extensions\\DataStandard\\CAD\\addinVault\\Default.ps1\n                  \n                  		  </em> \n            </p>\n            <p> \n               <div class=\"codeBlock\"><pre class=\"prettyprint\">...\nfunction GetNumSchms\n{\n    try\n    {\n        $numSchems = $vault.DocumentService.GetNumberingSchemesByType(\'Activated\')\n    }\n    catch [System.Exception]\n    {      \n        #[System.Windows.MessageBox]::Show($error)\n    }\n    $fileName = $Prop[\"DocNumber\"].Value\n    $fileExt = [System.IO.Path]::GetExtension($fileName)\n    $ret = @()\n    foreach ($item in $numSchems)\n    {\n        if (($fileExt -eq \".iam\" -or $fileExt -eq \".ipt\") -and $item.Name.StartsWith(\"COMP\"))\n        {\n            $ret += $item.Name\n        }\n        elseif (($fileExt -eq \".idw\" -or $fileExt -eq \".ipn\" -or $fileExt -eq \".dwg\") -and $item.Name.StartsWith(\"DRAWING\"))\n        {\n            $ret += $item.Name\n        }\n    }\n    return $ret\n}\n...</pre></div> \n            </p> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_5ACAD60FB18F46978F362A67E61EAB37\"></a> \n            <h2><a name=\"GUID-3AD98F0B-FFB9-4861-8F71-71A7A976557A\"></a>Customize the File Name\n            </h2> <a name=\"UL_36AF2D1914174DBAB816241CCF9ADC02\"></a><p class=\"list-intro\">Data Standard for Vault</p>\n            <p>Consider you have the following numbering scheme called TestScheme. \n               		\n            </p>\n            <p> </p>\n            <p> <a name=\"FIG_B778380769BC43B2BD6D839FAD786CAC\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-530C08A5-3362-4194-B75F-E7C9F725B734-low.png\"></div> \n            </p>\n            <p> </p>\n            <p>Now you want to pre-pend the filename with a fixed text based on the selected document\n               type: \n               		\n            </p>\n            <ul>\n               <li><span class=\"code\">ENG-</span> for Inventor assemblies and parts (e.g., ENG-A-00004.ipt) \n                  		\n               </li>\n               <li><span class=\"code\">ENGDOC-</span> for AutoCAD/Inventor drawings and Inventor presentations (e.g., ENGDOC-B-00001.idw).\n                  \n                  		\n               </li>\n               <li><span class=\"code\">OFF-</span> for all other files (e.g., OFF-C-00002.docx). \n                  		\n               </li>\n            </ul>\n            <p>When clicking OK in the Create File Dialog (New Standard File), the PowerShell function\n               \n               		  <span class=\"code\">GetNewFileName</span> is called before adding the file to Vault. Here you have the chance to modify the\n               filename and include information from other properties. \n               		\n            </p>\n            <p><em class=\"strong\">C:\\ProgramData\\Autodesk\\&lt;Vault Version&gt;\\Extensions\\DataStandard\\Vault\\addinVault\\Default.ps1</em> \n            </p>\n            <p> \n               <div class=\"codeBlock\"><pre class=\"prettyprint\">...\nfunction GetNewFileName\n{\n    $prefix = \"\"\n    if($dsWindow.FindName(\"NUMSCHEME\").IsEnabled -eq $false)\n    {  \n        $fileName = $dsWindow.FindName(\"FILENAME\").Text\n    }\n    else{\n        $fileName = $Prop[\"_GeneratedNumber\"].Value\n        if (($Prop[\"_FileExt\"].Value -eq \".ipt\") -or ($Prop[\"_FileExt\"].Value -eq \".iam\"))\n        {\n            $prefix = \"ENG-\"\n        }\n        elseif (($Prop[\"_FileExt\"].Value -eq \".dwg\") -or ($Prop[\"_FileExt\"].Value -eq \".idw\") -or ($Prop[\"_FileExt\"].Value -eq \".ipn\"))\n        {\n            $prefix = \"ENGDOC-\"\n        }\n        else\n        {\n            $prefix = \"OFF-\"\n        }\n    }\n    $newfileName = $prefix + $fileName + $Prop[\"_FileExt\"].Value\n    return $newfileName\n}</pre></div> \n            </p> <a name=\"UL_35F172224943404D93D21926AACC1B09\"></a><p class=\"list-intro\">Data Standard for CAD</p>\n            <p> With Data Standard for Inventor and AutoCAD, you can configure a combination of property\n               values and a generated number for the filename. \n               		\n            </p>\n            <p>For example, let\'s say that you want to automatically create unique file names in\n               the format of: \n               		  <em class=\"mild\">N-&lt;Title&gt;-####.ipt</em> where \n               		  <em class=\"mild\">N-</em> is always applied, \n               		  <em class=\"mild\">&lt;Title&gt;</em> is the user-entered Title property, \n               		  <em class=\"mild\">####</em> is a number automatically generated, and \n               		  <em class=\"mild\">.ipt</em> is the file extension. \n               		\n            </p>\n            <p>This can be done by modifying the element \n               		  <span class=\"code\">&lt;FileNameDefinition&gt; \n                  		  </span>in<span class=\"filePath\"> Inventor.cfg</span> or the \n               		  <span class=\"filePath\">AutoCAD.cfg</span> files. \n               		\n            </p>\n            <p> <em class=\"strong\">C:\\ProgramData\\Autodesk\\&lt;Vault Version&gt;\\Extensions\\DataStandard\\CAD\\Inventor.cfg</em> \n            </p>\n            <p> \n               <div class=\"codeBlock\"><pre class=\"prettyprint\">&lt;?xml version=\"1.0\" encoding=\"utf-8\"?&gt;\n&lt;Configuration&gt;\n    &lt;PathDefinition&gt;{Workspace}\\{Prop[Folder].Value}&lt;/PathDefinition&gt;\n    &lt;FileNameDefinition&gt;N-{Prop[Title].Value}-{Prop[DocNumber].Value}&lt;/FileNameDefinition&gt;\n    &lt;PropertyDefinitions&gt;\n        &lt;PropertyDefinition PropertyName=\"DocNumber\" DataType=\"Text\" InitialValue=\"{PathAndFileNameHandler.FileName}\" /&gt;\n...</pre></div> \n            </p>\n            <p> </p> The property \n            		<span class=\"code\">DocNumber</span> contains the generated number, because it is defined in attribute \n            		<span class=\"code\">GeneratedNumberProperty=\"DocNumber\"</span> in the \n            		<span class=\"code\">DSNumSchemeCtrl</span> control of the \n            		<span class=\"filePath\">Inventor.xaml</span> file. \n            	 \n         </div>\n         <div class=\"section\"><a name=\"SECTION_D9925AF45B83467884445DA2CDE735F1\"></a> \n            <h2><a name=\"GUID-3070824F-F57F-458C-AEAF-776B7539B836\"></a> Use Vault Numbering without Showing the Number Scheme Control in the Dialog\n            </h2> By removing the \n            		<span class=\"code\">DSNumSchemeCtrl</span> and the \n            		<span class=\"code\">NumSchms</span> combo box from the default \n            		<span class=\"filePath\">File.xaml</span> file, the user cannot select a numbering scheme anymore. \n            		<a name=\"OL_6045C629CACD4DEDBD923DD34EA2E9F7\"></a><p class=\"list-intro\">Data Standard for Vault</p>\n            <p>The following sample implementation of \n               		  <span class=\"code\">GetNewFileName</span> uses the numbering scheme TestScheme from above and the value entered in the Title\n               as a parameter for the numbering scheme. \n               		\n            </p>\n            <p> <em class=\"strong\">C:\\ProgramData\\Autodesk\\&lt;Vault Version&gt;\\Extensions\\DataStandard\\Vault\\addinVault\\Default.ps1</em> \n            </p>\n            <p> \n               <div class=\"codeBlock\"><pre class=\"prettyprint\">...\nfunction GetNewFileName\n{\n    $numSchemes = $vault.DocumentService.GetNumberingSchemesByType([Autodesk.Connectivity.WebServices.NumSchmType]::Activated)\n    $testNumScheme = $numSchemes | Where-Object { $_.Name.Equals(\"TestScheme\") }\n    $NumGenArgs = @()\n    $NumGenArgs += $Prop[\"Title\"].Value\n    $genNum = $vault.DocumentService.GenerateFileNumber($testNumScheme.SchmID, $NumGenArgs)\n    return $genNum + $Prop[\"_FileExt\"].Value\n}\n...</pre></div> \n            </p> <a name=\"OL_08D50C8748DD4E1C89FD83DE164524E3\"></a><p class=\"list-intro\">Data Standard for CAD</p>\n            <p>For Inventor and AutoCAD, the implementation is similar to the sample above. But instead\n               of returning a filename, the property \n               		  <span class=\"code\">DocNumber</span> has to be filled with a generated number. This property is then used to set the name\n               for the current file: \n               		\n            </p>\n            <p> <em class=\"strong\">C:\\ProgramData\\Autodesk\\&lt;Vault Version&gt;\\Extensions\\DataStandard\\CAD\\addinVault\\Default.ps1</em> \n            </p>\n            <p> \n               <div class=\"codeBlock\"><pre class=\"prettyprint\">...\nfunction OnPostCloseDialog\n{\n    if ($Prop[\"_CreateMode\"].Value)\n    {\n        $numSchemes = $vault.DocumentService.GetNumberingSchemesByType([Autodesk.Connectivity.WebServices.NumSchmType]::Activated)\n        $testNumScheme = $numSchemes | Where-Object { $_.Name.Equals(\"TestScheme\") }\n        $NumGenArgs = @()\n        $NumGenArgs += $Prop[\"Title\"].Value\n        $genNum = $vault.DocumentService.GenerateFileNumber($testNumScheme.SchmID, $NumGenArgs)\n        $Prop[\"DocNumber\"].Value = $genNum\n    }\n}\n...</pre></div> \n            </p> \n         </div>\n         <div class=\"footer-block\"><a href=\"..\" class=\"comments-anchor\" target=\"_blank\"><span class=\"comments-link\">Please send us your comment about this page</span></a></div><br><p class=\"footer-license-block\"><a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\"><img alt=\"Creative Commons License\" style=\"border-width: 0;\" src=\"../images/ccLink.png\"></a>&nbsp;<em>Except where otherwise noted, this work is licensed under a <a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\">Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License</a>. Please see the <a href=\"http://autodesk.com/creativecommons\" target=\"_blank\">Autodesk Creative Commons FAQ</a> for more information.</em></p><br></div>\n   </body>\n</html>";
// SIG // Begin signature block
// SIG // MIIbRQYJKoZIhvcNAQcCoIIbNjCCGzICAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // zEWs0bnZbo403DLGUDeW2jifccZPBrWeK9j8ZnIRGR2g
// SIG // ggoaMIIEyzCCA7OgAwIBAgIQCQja65wGHi65un4mqmKH
// SIG // ijANBgkqhkiG9w0BAQsFADCBhDELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTUw
// SIG // MwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
// SIG // b2RlIFNpZ25pbmcgQ0EgLSBHMjAeFw0xOTA1MTQwMDAw
// SIG // MDBaFw0yMDA1MTMyMzU5NTlaMHwxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIDApDYWxpZm9ybmlhMRMwEQYDVQQHDApT
// SIG // YW4gUmFmYWVsMRcwFQYDVQQKDA5BdXRvZGVzaywgSW5j
// SIG // LjERMA8GA1UECwwIU2VjdXJpdHkxFzAVBgNVBAMMDkF1
// SIG // dG9kZXNrLCBJbmMuMIIBIjANBgkqhkiG9w0BAQEFAAOC
// SIG // AQ8AMIIBCgKCAQEAkVKRoPYsoxPdlabspcuG8HYDfcWQ
// SIG // 9qyPOT2punwpVdjt2slktcpSTlydrGy8ijcbl5/k8AOJ
// SIG // afKMQvow0fNjIoNB5nsb8j2xFJPbBhHl8GT4P6DZ1OWK
// SIG // ioiUXgGHKjctUws49J4elntqvBYhKCbuPqG772QCoYFU
// SIG // P7qcFbh3PbyNB6cnKMn2vNGRqiEtV2aGg+/MiL3QPsvT
// SIG // kTWhVuTLIvwZ4kK5C5ACiQzlGOlE+C7gWuFoxtvy6gUa
// SIG // A8JAq/xLjYKwFevQwGncg3s1cuiGhx0P7Rvn6oCd2cem
// SIG // FmbK3I3rMRt+jc9wzAj3oHxvCo4f5Lfva+OpC1dETUVV
// SIG // sk0VGwIDAQABo4IBPjCCATowCQYDVR0TBAIwADAOBgNV
// SIG // HQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMw
// SIG // YQYDVR0gBFowWDBWBgZngQwBBAEwTDAjBggrBgEFBQcC
// SIG // ARYXaHR0cHM6Ly9kLnN5bWNiLmNvbS9jcHMwJQYIKwYB
// SIG // BQUHAgIwGQwXaHR0cHM6Ly9kLnN5bWNiLmNvbS9ycGEw
// SIG // HwYDVR0jBBgwFoAU1MAGIknrOUvdk+JcobhHdglyA1gw
// SIG // KwYDVR0fBCQwIjAgoB6gHIYaaHR0cDovL3JiLnN5bWNi
// SIG // LmNvbS9yYi5jcmwwVwYIKwYBBQUHAQEESzBJMB8GCCsG
// SIG // AQUFBzABhhNodHRwOi8vcmIuc3ltY2QuY29tMCYGCCsG
// SIG // AQUFBzAChhpodHRwOi8vcmIuc3ltY2IuY29tL3JiLmNy
// SIG // dDANBgkqhkiG9w0BAQsFAAOCAQEA0Q2+iVSEfT4xGq3A
// SIG // OADVb0rT5Z8E+PPb1x6hKknSzuaZKk/acDz9mdnFajaU
// SIG // WgIKiFJlsqJnuAM1w4lqKaEWsz3DoxvGIEwexj71Ud6a
// SIG // KlBJNcR9DdkXUZwMhbw9d78rjJAIX6tOwfSludZfdq8b
// SIG // YEkuIzQi9uYW9vHVPSCzhnUBKjwc9qTo9yBc7Fcn4FAT
// SIG // 90DzWM2hS9oc3p0pprYI2I/O4th90BEmwWkVqVgfaR0z
// SIG // VyIEmBbqB/IWLfjUBZJ/8sbkwWuWlYVRrfPxsj1e9qvb
// SIG // wE3Y28jWyGbqoUG39GhXk3uT8R8i3+T6M0c4rMfdifBC
// SIG // pceCaFTJzSye7LoeVzCCBUcwggQvoAMCAQICEHwbNTVK
// SIG // 59t050FfEWnKa6gwDQYJKoZIhvcNAQELBQAwgb0xCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjEfMB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29y
// SIG // azE6MDgGA1UECxMxKGMpIDIwMDggVmVyaVNpZ24sIElu
// SIG // Yy4gLSBGb3IgYXV0aG9yaXplZCB1c2Ugb25seTE4MDYG
// SIG // A1UEAxMvVmVyaVNpZ24gVW5pdmVyc2FsIFJvb3QgQ2Vy
// SIG // dGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMTQwNzIyMDAw
// SIG // MDAwWhcNMjQwNzIxMjM1OTU5WjCBhDELMAkGA1UEBhMC
// SIG // VVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9u
// SIG // MR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3Jr
// SIG // MTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1
// SIG // NiBDb2RlIFNpZ25pbmcgQ0EgLSBHMjCCASIwDQYJKoZI
// SIG // hvcNAQEBBQADggEPADCCAQoCggEBANeVQ9Tc32euOftS
// SIG // pLYmMQRw6beOWyq6N2k1lY+7wDDnhthzu9/r0XY/ilaO
// SIG // 6y1L8FcYTrGNpTPTC3Uj1Wp5J92j0/cOh2W13q0c8fU1
// SIG // tCJRryKhwV1LkH/AWU6rnXmpAtceSbE7TYf+wnirv+9S
// SIG // rpyvCNk55ZpRPmlfMBBOcWNsWOHwIDMbD3S+W8sS4duM
// SIG // xICUcrv2RZqewSUL+6McntimCXBx7MBHTI99w94Zzj7u
// SIG // BHKOF9P/8LIFMhlM07Acn/6leCBCcEGwJoxvAMg6ABFB
// SIG // ekGwp4qRBKCZePR3tPNgKuZsUAS3FGD/DVH0qIuE/iHa
// SIG // XF599Sl5T7BEdG9tcv8CAwEAAaOCAXgwggF0MC4GCCsG
// SIG // AQUFBwEBBCIwIDAeBggrBgEFBQcwAYYSaHR0cDovL3Mu
// SIG // c3ltY2QuY29tMBIGA1UdEwEB/wQIMAYBAf8CAQAwZgYD
// SIG // VR0gBF8wXTBbBgtghkgBhvhFAQcXAzBMMCMGCCsGAQUF
// SIG // BwIBFhdodHRwczovL2Quc3ltY2IuY29tL2NwczAlBggr
// SIG // BgEFBQcCAjAZGhdodHRwczovL2Quc3ltY2IuY29tL3Jw
// SIG // YTA2BgNVHR8ELzAtMCugKaAnhiVodHRwOi8vcy5zeW1j
// SIG // Yi5jb20vdW5pdmVyc2FsLXJvb3QuY3JsMBMGA1UdJQQM
// SIG // MAoGCCsGAQUFBwMDMA4GA1UdDwEB/wQEAwIBBjApBgNV
// SIG // HREEIjAgpB4wHDEaMBgGA1UEAxMRU3ltYW50ZWNQS0kt
// SIG // MS03MjQwHQYDVR0OBBYEFNTABiJJ6zlL3ZPiXKG4R3YJ
// SIG // cgNYMB8GA1UdIwQYMBaAFLZ3+mlIR59TEtXC6gcydgfR
// SIG // lwcZMA0GCSqGSIb3DQEBCwUAA4IBAQB/68qn6ot2Qus+
// SIG // jiBUMOO3udz6SD4Wxw9FlRDNJ4ajZvMC7XH4qsJVl5Fw
// SIG // g/lSflJpPMnx4JRGgBi7odSkVqbzHQCR1YbzSIfgy8Q0
// SIG // aCBetMv5Be2cr3BTJ7noPn5RoGlxi9xR7YA6JTKfRK9u
// SIG // QyjTIXW7l9iLi4z+qQRGBIX3FZxLEY3ELBf+1W5/muJW
// SIG // kvGWs60t+fTf2omZzrI4RMD3R3vKJbn6Kmgzm1By3qif
// SIG // 1M0sCzS9izB4QOCNjicbkG8avggVgV3rL+JR51EeyXgp
// SIG // 5x5lvzjvAUoBCSQOFsQUecFBNzTQPZFSlJ3haO8I8OJp
// SIG // nGdukAsak3HUJgLDwFojMYIQgzCCEH8CAQEwgZkwgYQx
// SIG // CzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRlYyBD
// SIG // b3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1
// SIG // c3QgTmV0d29yazE1MDMGA1UEAxMsU3ltYW50ZWMgQ2xh
// SIG // c3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENBIC0gRzIC
// SIG // EAkI2uucBh4uubp+Jqpih4owDQYJYIZIAWUDBAIBBQCg
// SIG // fDAQBgorBgEEAYI3AgEMMQIwADAZBgkqhkiG9w0BCQMx
// SIG // DAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4wDAYK
// SIG // KwYBBAGCNwIBFTAvBgkqhkiG9w0BCQQxIgQgySpXkX1o
// SIG // t016Ha+5yG+Cs1P1OaEsgvXpaqBDRM/ZO04wDQYJKoZI
// SIG // hvcNAQEBBQAEggEAZLOkrxpFR8OoxhlskNo/PrtF/lyk
// SIG // URTjWnLBorp9j1gFH9E/RPkHDk3MOaVZTXcBkALtl0hy
// SIG // CKqi4KV5vbpKOVsPaSmAAvf/8ErYO4YL/spph7UdC0fR
// SIG // aA1oA+dMfhP9k52XuACcAWA5Y/TR3wqcbqxtX1tErMj/
// SIG // 7IBvrRvLGFh026kCka7k4hbnT/gpbFSI1wt1VV/Y1q4z
// SIG // 1UObw2WRBPDLptrYciqRv4r/sucxh6tUDNbmMj+Ks6iX
// SIG // mgz/rFTIYw2OBpKyL1KGs85g6J/vYGDnNWOZlaZxeVDe
// SIG // Ro9z3zfmolZzCpE6ZPLrEAY9E7oxy7DN3vJ55RyRnB33
// SIG // SRY59aGCDjwwgg44BgorBgEEAYI3AwMBMYIOKDCCDiQG
// SIG // CSqGSIb3DQEHAqCCDhUwgg4RAgEDMQ0wCwYJYIZIAWUD
// SIG // BAIBMIIBDgYLKoZIhvcNAQkQAQSggf4EgfswgfgCAQEG
// SIG // C2CGSAGG+EUBBxcDMDEwDQYJYIZIAWUDBAIBBQAEILkn
// SIG // 6j4q8f3mVkxa/UCyEBUsLwXIqkAUmlAzDq1L5gbVAhRM
// SIG // aoUn1SoZwSfoSQlbXr0xsmbA6RgPMjAyMDAzMjMxNDAz
// SIG // NTZaMAMCAR6ggYakgYMwgYAxCzAJBgNVBAYTAlVTMR0w
// SIG // GwYDVQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlvbjEfMB0G
// SIG // A1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazExMC8G
// SIG // A1UEAxMoU3ltYW50ZWMgU0hBMjU2IFRpbWVTdGFtcGlu
// SIG // ZyBTaWduZXIgLSBHM6CCCoswggU4MIIEIKADAgECAhB7
// SIG // BbHUSWhRRPfJidKcGZ0SMA0GCSqGSIb3DQEBCwUAMIG9
// SIG // MQswCQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24s
// SIG // IEluYy4xHzAdBgNVBAsTFlZlcmlTaWduIFRydXN0IE5l
// SIG // dHdvcmsxOjA4BgNVBAsTMShjKSAyMDA4IFZlcmlTaWdu
// SIG // LCBJbmMuIC0gRm9yIGF1dGhvcml6ZWQgdXNlIG9ubHkx
// SIG // ODA2BgNVBAMTL1ZlcmlTaWduIFVuaXZlcnNhbCBSb290
// SIG // IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTE2MDEx
// SIG // MjAwMDAwMFoXDTMxMDExMTIzNTk1OVowdzELMAkGA1UE
// SIG // BhMCVVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0
// SIG // aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3
// SIG // b3JrMSgwJgYDVQQDEx9TeW1hbnRlYyBTSEEyNTYgVGlt
// SIG // ZVN0YW1waW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOC
// SIG // AQ8AMIIBCgKCAQEAu1mdWVVPnYxyXRqBoutV87ABrTxx
// SIG // rDKPBWuGmicAMpdqTclkFEspu8LZKbku7GOz4c8/C1aQ
// SIG // +GIbfuumB+Lef15tQDjUkQbnQXx5HMvLrRu/2JWR8/Du
// SIG // bPitljkuf8EnuHg5xYSl7e2vh47Ojcdt6tKYtTofHjmd
// SIG // w/SaqPSE4cTRfHHGBim0P+SDDSbDewg+TfkKtzNJ/8o7
// SIG // 1PWym0vhiJka9cDpMxTW38eA25Hu/rySV3J39M2ozP4J
// SIG // 9ZM3vpWIasXc9LFL1M7oCZFftYR5NYp4rBkyjyPBMkEb
// SIG // WQ6pPrHM+dYr77fY5NUdbRE6kvaTyZzjSO67Uw7UNpeG
// SIG // eMWhNwIDAQABo4IBdzCCAXMwDgYDVR0PAQH/BAQDAgEG
// SIG // MBIGA1UdEwEB/wQIMAYBAf8CAQAwZgYDVR0gBF8wXTBb
// SIG // BgtghkgBhvhFAQcXAzBMMCMGCCsGAQUFBwIBFhdodHRw
// SIG // czovL2Quc3ltY2IuY29tL2NwczAlBggrBgEFBQcCAjAZ
// SIG // GhdodHRwczovL2Quc3ltY2IuY29tL3JwYTAuBggrBgEF
// SIG // BQcBAQQiMCAwHgYIKwYBBQUHMAGGEmh0dHA6Ly9zLnN5
// SIG // bWNkLmNvbTA2BgNVHR8ELzAtMCugKaAnhiVodHRwOi8v
// SIG // cy5zeW1jYi5jb20vdW5pdmVyc2FsLXJvb3QuY3JsMBMG
// SIG // A1UdJQQMMAoGCCsGAQUFBwMIMCgGA1UdEQQhMB+kHTAb
// SIG // MRkwFwYDVQQDExBUaW1lU3RhbXAtMjA0OC0zMB0GA1Ud
// SIG // DgQWBBSvY9bKo06FcuCnvEHzKaI4f4B1YjAfBgNVHSME
// SIG // GDAWgBS2d/ppSEefUxLVwuoHMnYH0ZcHGTANBgkqhkiG
// SIG // 9w0BAQsFAAOCAQEAdeqwLdU0GVwyRf4O4dRPpnjBb9fq
// SIG // 3dxP86HIgYj3p48V5kApreZd9KLZVmSEcTAq3R5hF2Yg
// SIG // VgaYGY1dcfL4l7wJ/RyRR8ni6I0D+8yQL9YKbE4z7Na0
// SIG // k8hMkGNIOUAhxN3WbomYPLWYl+ipBrcJyY9TV0GQL+Ee
// SIG // TU7cyhB4bEJu8LbF+GFcUvVO9muN90p6vvPN/QPX2fYD
// SIG // qA/jU/cKdezGdS6qZoUEmbf4Blfhxg726K/a7JsYH6q5
// SIG // 4zoAv86KlMsB257HOLsPUqvR45QDYApNoP4nbRQy/D+X
// SIG // QOG/mYnb5DkUvdrk08PqK1qzlVhVBH3HmuwjA42FKtL/
// SIG // rqlhgTCCBUswggQzoAMCAQICEHvU5a+6zAc/oQEjBCJB
// SIG // TRIwDQYJKoZIhvcNAQELBQAwdzELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMSgw
// SIG // JgYDVQQDEx9TeW1hbnRlYyBTSEEyNTYgVGltZVN0YW1w
// SIG // aW5nIENBMB4XDTE3MTIyMzAwMDAwMFoXDTI5MDMyMjIz
// SIG // NTk1OVowgYAxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRT
// SIG // eW1hbnRlYyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3lt
// SIG // YW50ZWMgVHJ1c3QgTmV0d29yazExMC8GA1UEAxMoU3lt
// SIG // YW50ZWMgU0hBMjU2IFRpbWVTdGFtcGluZyBTaWduZXIg
// SIG // LSBHMzCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoC
// SIG // ggEBAK8Oiqr43L9pe1QXcUcJvY08gfh0FXdnkJz93k4C
// SIG // nkt29uU2PmXVJCBtMPndHYPpPydKM05tForkjUCNIqq+
// SIG // pwsb0ge2PLUaJCj4G3JRPcgJiCYIOvn6QyN1R3AMs19b
// SIG // jwgdckhXZU2vAjxA9/TdMjiTP+UspvNZI8uA3hNN+RDJ
// SIG // qgoYbFVhV9HxAizEtavybCPSnw0PGWythWJp/U6FwYpS
// SIG // Matb2Ml0UuNXbCK/VX9vygarP0q3InZl7Ow28paVgSYs
// SIG // /buYqgE4068lQJsJU/ApV4VYXuqFSEEhh+XetNMmsntA
// SIG // U1h5jlIxBk2UA0XEzjwD7LcA8joixbRv5e+wipsCAwEA
// SIG // AaOCAccwggHDMAwGA1UdEwEB/wQCMAAwZgYDVR0gBF8w
// SIG // XTBbBgtghkgBhvhFAQcXAzBMMCMGCCsGAQUFBwIBFhdo
// SIG // dHRwczovL2Quc3ltY2IuY29tL2NwczAlBggrBgEFBQcC
// SIG // AjAZGhdodHRwczovL2Quc3ltY2IuY29tL3JwYTBABgNV
// SIG // HR8EOTA3MDWgM6Axhi9odHRwOi8vdHMtY3JsLndzLnN5
// SIG // bWFudGVjLmNvbS9zaGEyNTYtdHNzLWNhLmNybDAWBgNV
// SIG // HSUBAf8EDDAKBggrBgEFBQcDCDAOBgNVHQ8BAf8EBAMC
// SIG // B4AwdwYIKwYBBQUHAQEEazBpMCoGCCsGAQUFBzABhh5o
// SIG // dHRwOi8vdHMtb2NzcC53cy5zeW1hbnRlYy5jb20wOwYI
// SIG // KwYBBQUHMAKGL2h0dHA6Ly90cy1haWEud3Muc3ltYW50
// SIG // ZWMuY29tL3NoYTI1Ni10c3MtY2EuY2VyMCgGA1UdEQQh
// SIG // MB+kHTAbMRkwFwYDVQQDExBUaW1lU3RhbXAtMjA0OC02
// SIG // MB0GA1UdDgQWBBSlEwGpn4XMG24WHl87Map5NgB7HTAf
// SIG // BgNVHSMEGDAWgBSvY9bKo06FcuCnvEHzKaI4f4B1YjAN
// SIG // BgkqhkiG9w0BAQsFAAOCAQEARp6v8LiiX6KZSM+oJ0sh
// SIG // zbK5pnJwYy/jVSl7OUZO535lBliLvFeKkg0I2BC6NiT6
// SIG // Cnv7O9Niv0qUFeaC24pUbf8o/mfPcT/mMwnZolkQ9B5K
// SIG // /mXM3tRr41IpdQBKK6XMy5voqU33tBdZkkHDtz+G5vbA
// SIG // f0Q8RlwXWuOkO9VpJtUhfeGAZ35irLdOLhWa5Zwjr1sR
// SIG // 6nGpQfkNeTipoQ3PtLHaPpp6xyLFdM3fRwmGxPyRJbIb
// SIG // lumFCOjd6nRgbmClVnoNyERY3Ob5SBSe5b/eAL13sZgU
// SIG // chQk38cRLB8AP8NLFMZnHMweBqOQX1xUiz7jM1uCD8W3
// SIG // hgJOcZ/pZkU/djGCAlowggJWAgEBMIGLMHcxCzAJBgNV
// SIG // BAYTAlVTMR0wGwYDVQQKExRTeW1hbnRlYyBDb3Jwb3Jh
// SIG // dGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0
// SIG // d29yazEoMCYGA1UEAxMfU3ltYW50ZWMgU0hBMjU2IFRp
// SIG // bWVTdGFtcGluZyBDQQIQe9Tlr7rMBz+hASMEIkFNEjAL
// SIG // BglghkgBZQMEAgGggaQwGgYJKoZIhvcNAQkDMQ0GCyqG
// SIG // SIb3DQEJEAEEMBwGCSqGSIb3DQEJBTEPFw0yMDAzMjMx
// SIG // NDAzNTZaMC8GCSqGSIb3DQEJBDEiBCCPw4g9vwAF9r5F
// SIG // eTG4RBeotw5TbKWQJKolmpkg1tcdLjA3BgsqhkiG9w0B
// SIG // CRACLzEoMCYwJDAiBCDEdM52AH0COU4NpeTefBTGgPni
// SIG // ggE8/vZT7123H99h+DALBgkqhkiG9w0BAQEEggEATbj3
// SIG // n8db6rNAC7In816+japjU94stMMODdawQ8avIEJpu1pg
// SIG // Gwgn8XEDdYea3EBK2g6f1DHMF285KPq8yr/LMKg8jw6Q
// SIG // Wsj+5jiJNm5P2FmboW31CY4Lv6x3dXPW4CT6AopyPgyF
// SIG // /Qg8a6Gb3BB9U07JJ8FVtViYCchUUY8yYaku1UTtjS5A
// SIG // G1d1jQ6OI1Cwvy4RyQJysSAsarcFqGTUx+gdDEOgYdVm
// SIG // epug91rBVagCBHl4CbA5rzFZK8KD1ZJ0gDvgKFiIKvfQ
// SIG // b9A3XWXJ+TDA69BbRR4fDPK3zWftveLdq/2GrOzTbqkV
// SIG // 1WBtHD+170ZrZ3gNlVNhc5aIhP/NYg==
// SIG // End signature block
