var topic = "<!DOCTYPE html>\r\n\n<!-- saved from url=(0024)http://docs.autodesk.com -->\r\n<html>\n   <head>\n      <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n      <meta name=\"product\" content=\"VAULT\">\n      <meta name=\"release\" content=\"2021\">\n      <meta name=\"book\" content=\"GeneralUser\">\n      <meta name=\"created\" content=\"2020-03-20\">\n      <meta name=\"topicid\" content=\"GUID-A298690E-A937-4317-89C9-B04C9950DF2D\">\n      <meta name=\"description\" content=\"Learn about how the Job Processor loads Job Handlers on start-up.\">\n      <meta name=\"topic-type\" content=\"concept\">\n      <meta name=\"audience\" content=\"administrator\">\n      <meta name=\"experiencelevel\" content=\"general\">\n      <title>How Job Handlers are Loaded</title><script language=\"javascript\">var index = \'index.html\';</script><script type=\"text/javascript\" src=\"../scripts/prettify/prettify.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-yaml.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-xq.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-wiki.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-vhdl.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-vb.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-tex.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-sql.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-scala.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-proto.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-n.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-ml.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-lua.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-lisp.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-hs.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-go.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-css.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-clj.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-apollo.js\"></script></head>\n   <body height=\"100%\" onLoad=\"javascript:prettyPrint();\">\n      <div class=\"revit-legend\">\n         <ul></ul>\n      </div>\n      <div class=\"body_content\" id=\"body-content\" dir=\"ltr\"><a name=\"GUID-A298690E-A937-4317-89C9-B04C9950DF2D\"></a><div class=\"head\">\n            <h1>How Job Handlers are Loaded</h1>\n         </div>\n         <p class=\"blurb\">Learn about how the Job Processor loads Job Handlers on start-up. \n            \n         </p>\n         <p><a name=\"GUID-F6ABD955-4E6E-429C-87E7-664C4634B262\"></a>The Job Processor loads both Autodesk and Third Party job handlers. \n            \n         </p><a name=\"GUID-4FBDAE28-D1DE-48FE-BF71-2BC8386D9983\"></a><ol type=\"1\" start=\"1\">\n            <li>Load all Third Party Job Handlers from the Extension folder \n               \n            </li>\n            <li>Read in the Job Handler configuration information. \n               \n            </li>\n            <li>Load Autodesk\'s Job Handlers. \n               \n            </li>\n            <li>Associate Job Types with Job Handlers and check if each Job Handler is enabled. \n               \n            </li>\n         </ol>\n         <p><a name=\"GUID-1BA7D9F0-0439-4413-BC6D-82311BC1E29B\"></a> <em class=\"strong\">Third Party Job Handler Extensions</em> \n         </p>\n         <p><a name=\"GUID-98C17463-C93F-49C2-8DBB-48392496BDAA\"></a>Each third party extension should exist in its own folder in the \n            <em class=\"strong\">Extension Directory</em>: \n            \n         </p>\n         <p><a name=\"GUID-2782147F-B34E-45B5-B445-ABDE37D0DE52\"></a> <span class=\"filePath\">%allusersprofile%\\Autodesk\\Vault[year]\\Extensions\\</span> \n         </p>\n         <p><a name=\"GUID-AA5D8023-9830-4436-A518-AFED6C28D15B\"></a>So, for example, if we had a job handler extension called \"JobHandlerSample\", it could\n            reside in the directory&nbsp;<span class=\"filePath\">%allusersprofile%\\Autodesk\\Vault [year]\\Extensions\\JobHandlerSample</span>. \n            \n         </p>\n         <p><a name=\"GUID-71E9E09C-D5C2-4A19-8103-93810031C3F6\"></a>For each folder within Extension Directory, the Job Processor checks for a configuration\n            file.&nbsp; The configuration file is a plain text file that can be named anything, but\n            must end with the extension .vcet.config.&nbsp; If the configuration file does not exist,\n            the extension will fail to load.&nbsp; Here are the contents of a sample config file, \n            <span class=\"filePath\">JobHandlerSample.vcet.config</span>: \n            \n         </p>\n         <div class=\"codeBlock\"><pre class=\"prettyprint\">&lt;configuration&gt;\n    &lt;connectivity.ExtensionSettings2&gt;\n         &lt;assembly&gt;JobHandlerSample&lt;/assembly&gt;\n         &lt;extensionType&gt;JobProcessor&lt;/extensionType&gt;\n    &lt;/connectivity.ExtensionSettings2&gt;\n&lt;/configuration&gt;</pre></div>\n         <p><a name=\"GUID-4E284E35-BB84-4419-9ECF-B0C98CC0B26A\"></a>The \n            <em class=\"strong\">assembly</em> element specifies the name of the extension dll.&nbsp; So, in our sample above, the extension\n            dll is named JobHandlerSample.dll.&nbsp; The extension type of JobProcessor indicates that\n            this is an extension for the job processor (other extension types can also live in\n            this directory: WebService and VaultClient). \n            \n         </p>\n         <p><a name=\"GUID-9DAD2FED-4AB3-4E30-96F8-1897459D17F5\"></a>The extension assembly (in our sample, JobHandlerSample.dll) is now loaded.&nbsp; Upon\n            loading the following checks are done: \n            \n         </p><a name=\"GUID-9282F1CC-F8DF-4247-9C2B-FCAEC258365A\"></a><ol type=\"1\" start=\"1\">\n            <li>The references of the assembly dll are checked to ensure that it doesn\'t link against\n               any of the vault dlls (those starting with \"Connectivity\" In their name.&nbsp; If an extension\n               assembly links to one of these dlls (either directly or indirectly), it will fail\n               to load. \n               \n            </li>\n            <li>The assembly is checked for a single exported type that implements the IJobHandler\n               interface.&nbsp; In our JobHandlerSample example, within our assembly\'s project we could\n               have the following C# class to implement the IJobHandler interface: \n               	 \n               <div class=\"codeBlock\"><pre class=\"prettyprint\">namespace JobHandlerSample\n{\n    public class JobHandlerSample : IJobHandler\n     {\n         public bool CanProcess(string strJobType)\n          {\n             return strJobType.Equals(\"jobhandlersample\");\n          }\n\n          public JobOutcome Execute(IJobProcessorServices context, IJob job)\n           {\n              return JobOutcome.Success;\n           }\n      }\n} &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;  </pre></div> \n               <p><a name=\"GUID-CDC824E4-383D-40E7-9F30-9BABF3BC3921\"></a>There must be exactly one public type in the assembly that implements IJobHandler.&nbsp;\n                  If this is not the case, then the extension will fail to load.&nbsp; An instance of this\n                  type is instantiated. \n                  	 \n               </p> \n            </li>\n            <li>The assembly is checked for certain required assembly attributes. Specifically, \n               	 <a name=\"GUID-FCC9BFC1-DAE0-46E0-B3FE-3FF737D5338D\"></a><ol type=\"1\" start=\"1\">\n                  <li> <em class=\"strong\">ApiVersion</em>:&nbsp;An attribute of type Autodesk.Connectivity.Extensibility.Framework.ApiVersionAttribute\n                     which specifies the version of the API that this extension was written for.&nbsp; If the\n                     version does match the current version of the Vault API, the extension will fail to\n                     load. \n                     		\n                  </li>\n                  <li> <em class=\"strong\">Company, Description, ProductName: \n                        		  </em>Attributes from the namespace System.Reflection of types AssemblyCompanyAttribute,\n                     AssemblyDescriptionAttribute, AssemblyProductAttribute are required and must not be\n                     empty strings.&nbsp; If these do not exist or are empty, the extension will fail to load.\n                     \n                     		\n                  </li>\n                  <li> <em class=\"strong\">ExtensionId:</em> An attribute of type Autodesk.Connectivity.Extensibility.Framework.ExtensionIdAttribute\n                     which specifies a unique Id as a string (in Guid form).&nbsp; If this attribute does not\n                     exist or is empty, the extension will fail to load. \n                     		\n                  </li>\n               </ol> \n            </li>\n         </ol>\n         <p><a name=\"GUID-6E830ADE-5741-44DE-B392-0CD1151ECB82\"></a> <em class=\"strong\">Job Handler Configuration</em> \n         </p>\n         <p><a name=\"GUID-EA831D62-69AA-4552-966E-DEB27762843D\"></a>The Job Handler configuration file is an xml file containing configuration information\n            for the Job Processor.&nbsp; It is located in the same directory as the \n            <span class=\"filePath\">JobProcessor.exe</span> (usually \n            <span class=\"filePath\">C:\\Program Files\\Autodesk\\Vault Professional [year]\\Explorer</span>) and is named \n            <span class=\"filePath\">JobProcessor.exe.config</span>.&nbsp; The relevant section for configuration of Job Handlers is under configuration\\connectivityExplorer\\jobHandlers.&nbsp;\n            In this xml section, each jobHandler element represents one Job Handler.&nbsp; The jobHandler\n            xml elements are of the following form: \n            \n         </p>\n         <div class=\"codeBlock\"><pre class=\"prettyprint\">&lt;jobHandler class=\"jobType\" handler=\"NameOfTypeImplementingIJobHandler\"/&gt;</pre></div>\n         <p><a name=\"GUID-A1D18AA9-ACB0-4091-8FAD-B262B40C6C75\"></a>Where: \n            \n         </p><a name=\"GUID-630DD57E-C0C7-41C4-AEEB-0BB43250FF1D\"></a><ol type=\"1\" start=\"1\">\n            <li>the \n               	 <em class=\"strong\">class</em> represents the Job Type.&nbsp; When a Job is added to the Job Server queue, the Job Type\n               is specified and this unique string is used to decide which Job Handler will process\n               that Job. \n               \n            </li>\n            <li>the \n               	 <em class=\"strong\">handler</em>represents the name of the type within the assembly that implements IJobHandler.&nbsp;\n               This can be specified in various ways.&nbsp; You need to specify a string that when passed\n               to System.Type.GetType(string) (see \n               	 <a href=\"http://msdn.microsoft.com/en-us/library/w3f99sx1.aspx\" target=\"_blank\">http://msdn.microsoft.com/en-us/library/w3f99sx1.aspx</a>) will return the type of the object in your assembly that implements IJobHandler.\n               \n               \n            </li>\n         </ol>\n         <p><a name=\"GUID-229EBF89-1B9F-4B46-937C-55D095017ABF\"></a>Thus, a valid jobHandler element for our sample extension would be: \n            \n         </p>\n         <div class=\"codeBlock\"><pre class=\"prettyprint\">&lt;jobHandler class=\"jobhandlersample\" handler=\"JobHandlerSample.JobHandlerSample, JobHandlerSample\"/&gt;</pre></div>\n         <p><a name=\"GUID-F8B4769D-6D41-4E66-BD4D-CF781A91A1DF\"></a>In the JobProcessor.exe.config file, you\'ll notice that there is already a jobHandler\n            entry for each of Autodesk\'s built-in Job Handlers.&nbsp; The built-in Job Handlers only\n            get loaded in if there is a jobHandler entry existing for them.&nbsp; The built-in Job\n            Handler dlls are located in the same directory as the JobProcessor.exe. \n            \n         </p>\n         <p><a name=\"GUID-1F4742A8-B506-4DF0-9E62-CC44BA77227F\"></a> <em class=\"strong\">Check if Job&nbsp;Handlers are enabled</em> \n         </p>\n         <p><a name=\"GUID-861DFAC8-05B4-4E56-ACA9-418372BE370E\"></a>The configuration information above is used to associate a Job Type with a specific\n            Job Handler.&nbsp; Once that is done, each Job Handler is asked if it can process it\'s\n            specific Job Type.&nbsp; The Job Handler answers this question by implementing the interface\n            method IJobHandler.CanProcess.&nbsp; At this time the Job Handler should check if it has\n            everything it needs to be able to process Jobs of its type (for example, some of the\n            dwf creation job handlers check if Inventor is installed).&nbsp; \n            \n         </p>\n         <p><a name=\"GUID-F552C856-754A-401C-86E8-A246E4C20B79\"></a>When you check which Job Types are currently processed by a Job Processor (by using\n            the menu Administation-&gt;Job Types...), each entry listed means that a Job Handler\n            for that Job Type loaded successfully.&nbsp; If the entry is checked, it indicates that\n            the Job Handler is enabled (that is, it returned \"true\" from its IJobHandler.CanProcess\n            implementation).&nbsp; In order to have the Job Processor re-ask a Job Handler if it \"can\n            process\", the user would need to exit the Job Processor and start it up again. \n            \n         </p>\n         <p><a name=\"GUID-AA8A5F65-2E38-4B48-AC10-67E1D81E5815\"></a>Once all the Job Handlers have been loaded and queried, the Job Processor is ready\n            to begin pulling jobs of the queue and processing them. \n            \n         </p>\n         <p><a name=\"GUID-A1459822-560A-47C4-ADEB-30977B841308\"></a> <em class=\"strong\">Sample Job Handler</em> \n         </p>\n         <p><a name=\"GUID-40F9970E-2C0E-4BEF-A550-9258918FCF64\"></a>Vault SDK contains a sample job handler JobProcessorApiSamples.&nbsp; For more information,\n            click \n            <span class=\"char_link\"><a href=\"GUID-F21E7DD6-39E9-473C-84BB-3446BCAFCCC0.htm\">here</a></span>. \n            \n         </p>\n         <div class=\"footer-block\"><a href=\"..\" class=\"comments-anchor\" target=\"_blank\"><span class=\"comments-link\">Please send us your comment about this page</span></a></div><br><p class=\"footer-license-block\"><a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\"><img alt=\"Creative Commons License\" style=\"border-width: 0;\" src=\"../images/ccLink.png\"></a>&nbsp;<em>Except where otherwise noted, this work is licensed under a <a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\">Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License</a>. Please see the <a href=\"http://autodesk.com/creativecommons\" target=\"_blank\">Autodesk Creative Commons FAQ</a> for more information.</em></p><br></div>\n   </body>\n</html>";
// SIG // Begin signature block
// SIG // MIIbRgYJKoZIhvcNAQcCoIIbNzCCGzMCAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // q8QuTEZur2pWn5rz3wyN+HxH5/gEUBM0RyY9wNu0qcag
// SIG // ggoaMIIEyzCCA7OgAwIBAgIQCQja65wGHi65un4mqmKH
// SIG // ijANBgkqhkiG9w0BAQsFADCBhDELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTUw
// SIG // MwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
// SIG // b2RlIFNpZ25pbmcgQ0EgLSBHMjAeFw0xOTA1MTQwMDAw
// SIG // MDBaFw0yMDA1MTMyMzU5NTlaMHwxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIDApDYWxpZm9ybmlhMRMwEQYDVQQHDApT
// SIG // YW4gUmFmYWVsMRcwFQYDVQQKDA5BdXRvZGVzaywgSW5j
// SIG // LjERMA8GA1UECwwIU2VjdXJpdHkxFzAVBgNVBAMMDkF1
// SIG // dG9kZXNrLCBJbmMuMIIBIjANBgkqhkiG9w0BAQEFAAOC
// SIG // AQ8AMIIBCgKCAQEAkVKRoPYsoxPdlabspcuG8HYDfcWQ
// SIG // 9qyPOT2punwpVdjt2slktcpSTlydrGy8ijcbl5/k8AOJ
// SIG // afKMQvow0fNjIoNB5nsb8j2xFJPbBhHl8GT4P6DZ1OWK
// SIG // ioiUXgGHKjctUws49J4elntqvBYhKCbuPqG772QCoYFU
// SIG // P7qcFbh3PbyNB6cnKMn2vNGRqiEtV2aGg+/MiL3QPsvT
// SIG // kTWhVuTLIvwZ4kK5C5ACiQzlGOlE+C7gWuFoxtvy6gUa
// SIG // A8JAq/xLjYKwFevQwGncg3s1cuiGhx0P7Rvn6oCd2cem
// SIG // FmbK3I3rMRt+jc9wzAj3oHxvCo4f5Lfva+OpC1dETUVV
// SIG // sk0VGwIDAQABo4IBPjCCATowCQYDVR0TBAIwADAOBgNV
// SIG // HQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMw
// SIG // YQYDVR0gBFowWDBWBgZngQwBBAEwTDAjBggrBgEFBQcC
// SIG // ARYXaHR0cHM6Ly9kLnN5bWNiLmNvbS9jcHMwJQYIKwYB
// SIG // BQUHAgIwGQwXaHR0cHM6Ly9kLnN5bWNiLmNvbS9ycGEw
// SIG // HwYDVR0jBBgwFoAU1MAGIknrOUvdk+JcobhHdglyA1gw
// SIG // KwYDVR0fBCQwIjAgoB6gHIYaaHR0cDovL3JiLnN5bWNi
// SIG // LmNvbS9yYi5jcmwwVwYIKwYBBQUHAQEESzBJMB8GCCsG
// SIG // AQUFBzABhhNodHRwOi8vcmIuc3ltY2QuY29tMCYGCCsG
// SIG // AQUFBzAChhpodHRwOi8vcmIuc3ltY2IuY29tL3JiLmNy
// SIG // dDANBgkqhkiG9w0BAQsFAAOCAQEA0Q2+iVSEfT4xGq3A
// SIG // OADVb0rT5Z8E+PPb1x6hKknSzuaZKk/acDz9mdnFajaU
// SIG // WgIKiFJlsqJnuAM1w4lqKaEWsz3DoxvGIEwexj71Ud6a
// SIG // KlBJNcR9DdkXUZwMhbw9d78rjJAIX6tOwfSludZfdq8b
// SIG // YEkuIzQi9uYW9vHVPSCzhnUBKjwc9qTo9yBc7Fcn4FAT
// SIG // 90DzWM2hS9oc3p0pprYI2I/O4th90BEmwWkVqVgfaR0z
// SIG // VyIEmBbqB/IWLfjUBZJ/8sbkwWuWlYVRrfPxsj1e9qvb
// SIG // wE3Y28jWyGbqoUG39GhXk3uT8R8i3+T6M0c4rMfdifBC
// SIG // pceCaFTJzSye7LoeVzCCBUcwggQvoAMCAQICEHwbNTVK
// SIG // 59t050FfEWnKa6gwDQYJKoZIhvcNAQELBQAwgb0xCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjEfMB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29y
// SIG // azE6MDgGA1UECxMxKGMpIDIwMDggVmVyaVNpZ24sIElu
// SIG // Yy4gLSBGb3IgYXV0aG9yaXplZCB1c2Ugb25seTE4MDYG
// SIG // A1UEAxMvVmVyaVNpZ24gVW5pdmVyc2FsIFJvb3QgQ2Vy
// SIG // dGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMTQwNzIyMDAw
// SIG // MDAwWhcNMjQwNzIxMjM1OTU5WjCBhDELMAkGA1UEBhMC
// SIG // VVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9u
// SIG // MR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3Jr
// SIG // MTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1
// SIG // NiBDb2RlIFNpZ25pbmcgQ0EgLSBHMjCCASIwDQYJKoZI
// SIG // hvcNAQEBBQADggEPADCCAQoCggEBANeVQ9Tc32euOftS
// SIG // pLYmMQRw6beOWyq6N2k1lY+7wDDnhthzu9/r0XY/ilaO
// SIG // 6y1L8FcYTrGNpTPTC3Uj1Wp5J92j0/cOh2W13q0c8fU1
// SIG // tCJRryKhwV1LkH/AWU6rnXmpAtceSbE7TYf+wnirv+9S
// SIG // rpyvCNk55ZpRPmlfMBBOcWNsWOHwIDMbD3S+W8sS4duM
// SIG // xICUcrv2RZqewSUL+6McntimCXBx7MBHTI99w94Zzj7u
// SIG // BHKOF9P/8LIFMhlM07Acn/6leCBCcEGwJoxvAMg6ABFB
// SIG // ekGwp4qRBKCZePR3tPNgKuZsUAS3FGD/DVH0qIuE/iHa
// SIG // XF599Sl5T7BEdG9tcv8CAwEAAaOCAXgwggF0MC4GCCsG
// SIG // AQUFBwEBBCIwIDAeBggrBgEFBQcwAYYSaHR0cDovL3Mu
// SIG // c3ltY2QuY29tMBIGA1UdEwEB/wQIMAYBAf8CAQAwZgYD
// SIG // VR0gBF8wXTBbBgtghkgBhvhFAQcXAzBMMCMGCCsGAQUF
// SIG // BwIBFhdodHRwczovL2Quc3ltY2IuY29tL2NwczAlBggr
// SIG // BgEFBQcCAjAZGhdodHRwczovL2Quc3ltY2IuY29tL3Jw
// SIG // YTA2BgNVHR8ELzAtMCugKaAnhiVodHRwOi8vcy5zeW1j
// SIG // Yi5jb20vdW5pdmVyc2FsLXJvb3QuY3JsMBMGA1UdJQQM
// SIG // MAoGCCsGAQUFBwMDMA4GA1UdDwEB/wQEAwIBBjApBgNV
// SIG // HREEIjAgpB4wHDEaMBgGA1UEAxMRU3ltYW50ZWNQS0kt
// SIG // MS03MjQwHQYDVR0OBBYEFNTABiJJ6zlL3ZPiXKG4R3YJ
// SIG // cgNYMB8GA1UdIwQYMBaAFLZ3+mlIR59TEtXC6gcydgfR
// SIG // lwcZMA0GCSqGSIb3DQEBCwUAA4IBAQB/68qn6ot2Qus+
// SIG // jiBUMOO3udz6SD4Wxw9FlRDNJ4ajZvMC7XH4qsJVl5Fw
// SIG // g/lSflJpPMnx4JRGgBi7odSkVqbzHQCR1YbzSIfgy8Q0
// SIG // aCBetMv5Be2cr3BTJ7noPn5RoGlxi9xR7YA6JTKfRK9u
// SIG // QyjTIXW7l9iLi4z+qQRGBIX3FZxLEY3ELBf+1W5/muJW
// SIG // kvGWs60t+fTf2omZzrI4RMD3R3vKJbn6Kmgzm1By3qif
// SIG // 1M0sCzS9izB4QOCNjicbkG8avggVgV3rL+JR51EeyXgp
// SIG // 5x5lvzjvAUoBCSQOFsQUecFBNzTQPZFSlJ3haO8I8OJp
// SIG // nGdukAsak3HUJgLDwFojMYIQhDCCEIACAQEwgZkwgYQx
// SIG // CzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRlYyBD
// SIG // b3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1
// SIG // c3QgTmV0d29yazE1MDMGA1UEAxMsU3ltYW50ZWMgQ2xh
// SIG // c3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENBIC0gRzIC
// SIG // EAkI2uucBh4uubp+Jqpih4owDQYJYIZIAWUDBAIBBQCg
// SIG // fDAQBgorBgEEAYI3AgEMMQIwADAZBgkqhkiG9w0BCQMx
// SIG // DAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4wDAYK
// SIG // KwYBBAGCNwIBFTAvBgkqhkiG9w0BCQQxIgQgao3GEW7y
// SIG // YyyT1bgWbCGWbSv8NaVEEpez66APpwRHeB0wDQYJKoZI
// SIG // hvcNAQEBBQAEggEAPI/Tx4D2xqc159lA7uBCcV7mMcG1
// SIG // 6c4NwdBjOYQnlkBCovG+oMtfTNxX88/UAd9S4yJXIiys
// SIG // rN4Or8IztnUsbD1RmX3VWTq8dYlAJgy9AbnM5CUNGw3K
// SIG // edNGjdGoM3OAFw/jIPisB0tFc6PDdB7bzmS1dDrL//xr
// SIG // QudgZf6AF9xjP0f7mTSYGTO68KPXxzOID5K/33La38wt
// SIG // 6j9QN9miMdpEspH+Y3ZDD7t8W1CtvdroccMe3ax/ZA8j
// SIG // LGWgTbJDBOnKd+WqVbkLUa6UJQxbRyY7AzMKYfOil8to
// SIG // YTmNUFttBo4N3SBDcphMX6oeRkG3Yw3s19TK+U2pDwLd
// SIG // mGaQQqGCDj0wgg45BgorBgEEAYI3AwMBMYIOKTCCDiUG
// SIG // CSqGSIb3DQEHAqCCDhYwgg4SAgEDMQ0wCwYJYIZIAWUD
// SIG // BAIBMIIBDwYLKoZIhvcNAQkQAQSggf8EgfwwgfkCAQEG
// SIG // C2CGSAGG+EUBBxcDMDEwDQYJYIZIAWUDBAIBBQAEIDrh
// SIG // kB6eexopMk1q3wsyqyLeQsyvY5DxHmFHrTrsGAWXAhUA
// SIG // sVf+L2f1k2vYlwLefTT5cnl6l/oYDzIwMjAwMzIzMTQw
// SIG // MjUyWjADAgEeoIGGpIGDMIGAMQswCQYDVQQGEwJVUzEd
// SIG // MBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xHzAd
// SIG // BgNVBAsTFlN5bWFudGVjIFRydXN0IE5ldHdvcmsxMTAv
// SIG // BgNVBAMTKFN5bWFudGVjIFNIQTI1NiBUaW1lU3RhbXBp
// SIG // bmcgU2lnbmVyIC0gRzOgggqLMIIFODCCBCCgAwIBAgIQ
// SIG // ewWx1EloUUT3yYnSnBmdEjANBgkqhkiG9w0BAQsFADCB
// SIG // vTELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWdu
// SIG // LCBJbmMuMR8wHQYDVQQLExZWZXJpU2lnbiBUcnVzdCBO
// SIG // ZXR3b3JrMTowOAYDVQQLEzEoYykgMjAwOCBWZXJpU2ln
// SIG // biwgSW5jLiAtIEZvciBhdXRob3JpemVkIHVzZSBvbmx5
// SIG // MTgwNgYDVQQDEy9WZXJpU2lnbiBVbml2ZXJzYWwgUm9v
// SIG // dCBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAeFw0xNjAx
// SIG // MTIwMDAwMDBaFw0zMTAxMTEyMzU5NTlaMHcxCzAJBgNV
// SIG // BAYTAlVTMR0wGwYDVQQKExRTeW1hbnRlYyBDb3Jwb3Jh
// SIG // dGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0
// SIG // d29yazEoMCYGA1UEAxMfU3ltYW50ZWMgU0hBMjU2IFRp
// SIG // bWVTdGFtcGluZyBDQTCCASIwDQYJKoZIhvcNAQEBBQAD
// SIG // ggEPADCCAQoCggEBALtZnVlVT52Mcl0agaLrVfOwAa08
// SIG // cawyjwVrhponADKXak3JZBRLKbvC2Sm5Luxjs+HPPwtW
// SIG // kPhiG37rpgfi3n9ebUA41JEG50F8eRzLy60bv9iVkfPw
// SIG // 7mz4rZY5Ln/BJ7h4OcWEpe3tr4eOzo3HberSmLU6Hx45
// SIG // ncP0mqj0hOHE0XxxxgYptD/kgw0mw3sIPk35CrczSf/K
// SIG // O9T1sptL4YiZGvXA6TMU1t/HgNuR7v68kldyd/TNqMz+
// SIG // CfWTN76ViGrF3PSxS9TO6AmRX7WEeTWKeKwZMo8jwTJB
// SIG // G1kOqT6xzPnWK++32OTVHW0ROpL2k8mc40juu1MO1DaX
// SIG // hnjFoTcCAwEAAaOCAXcwggFzMA4GA1UdDwEB/wQEAwIB
// SIG // BjASBgNVHRMBAf8ECDAGAQH/AgEAMGYGA1UdIARfMF0w
// SIG // WwYLYIZIAYb4RQEHFwMwTDAjBggrBgEFBQcCARYXaHR0
// SIG // cHM6Ly9kLnN5bWNiLmNvbS9jcHMwJQYIKwYBBQUHAgIw
// SIG // GRoXaHR0cHM6Ly9kLnN5bWNiLmNvbS9ycGEwLgYIKwYB
// SIG // BQUHAQEEIjAgMB4GCCsGAQUFBzABhhJodHRwOi8vcy5z
// SIG // eW1jZC5jb20wNgYDVR0fBC8wLTAroCmgJ4YlaHR0cDov
// SIG // L3Muc3ltY2IuY29tL3VuaXZlcnNhbC1yb290LmNybDAT
// SIG // BgNVHSUEDDAKBggrBgEFBQcDCDAoBgNVHREEITAfpB0w
// SIG // GzEZMBcGA1UEAxMQVGltZVN0YW1wLTIwNDgtMzAdBgNV
// SIG // HQ4EFgQUr2PWyqNOhXLgp7xB8ymiOH+AdWIwHwYDVR0j
// SIG // BBgwFoAUtnf6aUhHn1MS1cLqBzJ2B9GXBxkwDQYJKoZI
// SIG // hvcNAQELBQADggEBAHXqsC3VNBlcMkX+DuHUT6Z4wW/X
// SIG // 6t3cT/OhyIGI96ePFeZAKa3mXfSi2VZkhHEwKt0eYRdm
// SIG // IFYGmBmNXXHy+Je8Cf0ckUfJ4uiNA/vMkC/WCmxOM+zW
// SIG // tJPITJBjSDlAIcTd1m6JmDy1mJfoqQa3CcmPU1dBkC/h
// SIG // Hk1O3MoQeGxCbvC2xfhhXFL1TvZrjfdKer7zzf0D19n2
// SIG // A6gP41P3CnXsxnUuqmaFBJm3+AZX4cYO9uiv2uybGB+q
// SIG // ueM6AL/OipTLAduexzi7D1Kr0eOUA2AKTaD+J20UMvw/
// SIG // l0Dhv5mJ2+Q5FL3a5NPD6itas5VYVQR9x5rsIwONhSrS
// SIG // /66pYYEwggVLMIIEM6ADAgECAhB71OWvuswHP6EBIwQi
// SIG // QU0SMA0GCSqGSIb3DQEBCwUAMHcxCzAJBgNVBAYTAlVT
// SIG // MR0wGwYDVQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlvbjEf
// SIG // MB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazEo
// SIG // MCYGA1UEAxMfU3ltYW50ZWMgU0hBMjU2IFRpbWVTdGFt
// SIG // cGluZyBDQTAeFw0xNzEyMjMwMDAwMDBaFw0yOTAzMjIy
// SIG // MzU5NTlaMIGAMQswCQYDVQQGEwJVUzEdMBsGA1UEChMU
// SIG // U3ltYW50ZWMgQ29ycG9yYXRpb24xHzAdBgNVBAsTFlN5
// SIG // bWFudGVjIFRydXN0IE5ldHdvcmsxMTAvBgNVBAMTKFN5
// SIG // bWFudGVjIFNIQTI1NiBUaW1lU3RhbXBpbmcgU2lnbmVy
// SIG // IC0gRzMwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEK
// SIG // AoIBAQCvDoqq+Ny/aXtUF3FHCb2NPIH4dBV3Z5Cc/d5O
// SIG // Ap5LdvblNj5l1SQgbTD53R2D6T8nSjNObRaK5I1AjSKq
// SIG // vqcLG9IHtjy1GiQo+BtyUT3ICYgmCDr5+kMjdUdwDLNf
// SIG // W48IHXJIV2VNrwI8QPf03TI4kz/lLKbzWSPLgN4TTfkQ
// SIG // yaoKGGxVYVfR8QIsxLWr8mwj0p8NDxlsrYViaf1OhcGK
// SIG // UjGrW9jJdFLjV2wiv1V/b8oGqz9KtyJ2ZezsNvKWlYEm
// SIG // LP27mKoBONOvJUCbCVPwKVeFWF7qhUhBIYfl3rTTJrJ7
// SIG // QFNYeY5SMQZNlANFxM48A+y3API6IsW0b+XvsIqbAgMB
// SIG // AAGjggHHMIIBwzAMBgNVHRMBAf8EAjAAMGYGA1UdIARf
// SIG // MF0wWwYLYIZIAYb4RQEHFwMwTDAjBggrBgEFBQcCARYX
// SIG // aHR0cHM6Ly9kLnN5bWNiLmNvbS9jcHMwJQYIKwYBBQUH
// SIG // AgIwGRoXaHR0cHM6Ly9kLnN5bWNiLmNvbS9ycGEwQAYD
// SIG // VR0fBDkwNzA1oDOgMYYvaHR0cDovL3RzLWNybC53cy5z
// SIG // eW1hbnRlYy5jb20vc2hhMjU2LXRzcy1jYS5jcmwwFgYD
// SIG // VR0lAQH/BAwwCgYIKwYBBQUHAwgwDgYDVR0PAQH/BAQD
// SIG // AgeAMHcGCCsGAQUFBwEBBGswaTAqBggrBgEFBQcwAYYe
// SIG // aHR0cDovL3RzLW9jc3Aud3Muc3ltYW50ZWMuY29tMDsG
// SIG // CCsGAQUFBzAChi9odHRwOi8vdHMtYWlhLndzLnN5bWFu
// SIG // dGVjLmNvbS9zaGEyNTYtdHNzLWNhLmNlcjAoBgNVHREE
// SIG // ITAfpB0wGzEZMBcGA1UEAxMQVGltZVN0YW1wLTIwNDgt
// SIG // NjAdBgNVHQ4EFgQUpRMBqZ+FzBtuFh5fOzGqeTYAex0w
// SIG // HwYDVR0jBBgwFoAUr2PWyqNOhXLgp7xB8ymiOH+AdWIw
// SIG // DQYJKoZIhvcNAQELBQADggEBAEaer/C4ol+imUjPqCdL
// SIG // Ic2yuaZycGMv41UpezlGTud+ZQZYi7xXipINCNgQujYk
// SIG // +gp7+zvTYr9KlBXmgtuKVG3/KP5nz3E/5jMJ2aJZEPQe
// SIG // Sv5lzN7Ua+NSKXUASiulzMub6KlN97QXWZJBw7c/hub2
// SIG // wH9EPEZcF1rjpDvVaSbVIX3hgGd+Yqy3Ti4VmuWcI69b
// SIG // EepxqUH5DXk4qaENz7Sx2j6aescixXTN30cJhsT8kSWy
// SIG // G5bphQjo3ep0YG5gpVZ6DchEWNzm+UgUnuW/3gC9d7GY
// SIG // FHIUJN/HESwfAD/DSxTGZxzMHgajkF9cVIs+4zNbgg/F
// SIG // t4YCTnGf6WZFP3YxggJaMIICVgIBATCBizB3MQswCQYD
// SIG // VQQGEwJVUzEdMBsGA1UEChMUU3ltYW50ZWMgQ29ycG9y
// SIG // YXRpb24xHzAdBgNVBAsTFlN5bWFudGVjIFRydXN0IE5l
// SIG // dHdvcmsxKDAmBgNVBAMTH1N5bWFudGVjIFNIQTI1NiBU
// SIG // aW1lU3RhbXBpbmcgQ0ECEHvU5a+6zAc/oQEjBCJBTRIw
// SIG // CwYJYIZIAWUDBAIBoIGkMBoGCSqGSIb3DQEJAzENBgsq
// SIG // hkiG9w0BCRABBDAcBgkqhkiG9w0BCQUxDxcNMjAwMzIz
// SIG // MTQwMjUyWjAvBgkqhkiG9w0BCQQxIgQgCAQpXnIsZclP
// SIG // MCkQc8r7S/DhimGAQYe0bLRb0JrcBMYwNwYLKoZIhvcN
// SIG // AQkQAi8xKDAmMCQwIgQgxHTOdgB9AjlODaXk3nwUxoD5
// SIG // 4oIBPP72U+9dtx/fYfgwCwYJKoZIhvcNAQEBBIIBAIwO
// SIG // WvcOdfp8a9UMkQX6C9c+p2plrcMzQ5bz+dWgk3qd1TlT
// SIG // iH3wYr6iRqYd+V/Bwnju36fshRyqAn3WQgAH8LADXc64
// SIG // G0UeqwXqVo8f0oG41SXdONbQaT6j0ZiQRxBsaiiCg0NA
// SIG // H4Xin0MMo3Scnw6AXi7am4JUGEWZny2n0inz6ElXUCTH
// SIG // n0W1A+xVP17wyY/SAYFeTA5aSuFdNhmze3Tk7WKztEgo
// SIG // L70rHmroW2eEc+jJFrtYbQ6wdzgx1MmvXIEZSNMmMVZX
// SIG // aYFL8wFiMuMA2aQvDeLWLBYpOjHPRuIbYx3z+bYNu1OG
// SIG // XbATBxNfioXitoIB032KXmD9ItmCVpw=
// SIG // End signature block
