var topic = "<!DOCTYPE html>\r\n\n<!-- saved from url=(0024)http://docs.autodesk.com -->\r\n<html>\n   <head>\n      <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n      <meta name=\"product\" content=\"VAULT\">\n      <meta name=\"release\" content=\"2021\">\n      <meta name=\"book\" content=\"GeneralUser\">\n      <meta name=\"created\" content=\"2020-03-20\">\n      <meta name=\"topicid\" content=\"GUID-9851FE4D-6788-467F-B79D-EF78F385BD2C\">\n      <meta name=\"description\" content=\"The $Prop[] variable provides access to Vault properties when used in Data Standard for Vault, or CAD properties when used in Data Standard for CAD. Specifying the property name in the square brackets [] returns an IProperty object which can be used for getting and setting property values.\">\n      <meta name=\"topic-type\" content=\"concept\">\n      <meta name=\"audience\" content=\"programmer\">\n      <meta name=\"experiencelevel\" content=\"general\">\n      <title>$Prop[] Variable in Data Standard</title><script language=\"javascript\">var index = \'index.html\';</script><script type=\"text/javascript\" src=\"../scripts/prettify/prettify.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-yaml.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-xq.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-wiki.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-vhdl.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-vb.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-tex.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-sql.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-scala.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-proto.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-n.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-ml.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-lua.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-lisp.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-hs.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-go.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-css.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-clj.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-apollo.js\"></script></head>\n   <body height=\"100%\" onLoad=\"javascript:prettyPrint();\">\n      <div class=\"body_content\" id=\"body-content\" dir=\"ltr\"><a name=\"GUID-9851FE4D-6788-467F-B79D-EF78F385BD2C\"></a><div class=\"head\">\n            <h1>$Prop[] Variable in Data Standard</h1>\n         </div>\n         <p class=\"blurb\">The \n            	 <span class=\"code\">$Prop[]</span> variable provides access to Vault properties when used in Data Standard for Vault,\n            or CAD properties when used in Data Standard for CAD. Specifying the property name\n            in the square brackets [] returns an \n            	 <span class=\"code\">IProperty</span> object which can be used for getting and setting property values. \n            \n         </p>\n         <p><em class=\"strong\">Type:</em>Common.Wpf.IndexerForwarder, IProperty \n            	 \n         </p>\n         <div class=\"section\"><a name=\"SECTION_465F0BB98FB74E2A83019092C9A0CF44\"></a> \n            <h2><a name=\"GUID-D5B259B7-19DC-4810-B91C-9DD2AD2C2480\"></a>Special Properties\n            </h2> \n            <p>For regular properties, the name of the property has to be used. \n               		\n            </p> \n            <p>But there are special read-only properties that allow to access additional information\n               through the \n               		  <span class=\"code\">$Prop</span> variable. These properties have an underscore prefix (_). \n               		\n            </p> \n            <div><a name=\"GUID-DE4104F9-6414-47B3-9746-FFF450371DE4\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span>The availability column indicates in which PowerShell files the objects can be used.\n                  For example, \n                  		  <em class=\"strong\">Vault file dialog</em> means, the PowerShell code is used in the context of a create and edit file dialog.\n                  \n                  		\n               </div>\n            </div> <a name=\"TABLE_99120AB6E756402C8DDB9A6103F8524E\"></a><div class=\"table-not-ruled\">\n               <table cellpadding=\"0\" cellspacing=\"0\" class=\"not-ruled\">\n                  <colgroup>\n                     <col>\n                     <col>\n                     <col>\n                  </colgroup>\n                  <tr class=\"not-ruled-heading\">\n                     <th class=\"table-heading\"> \n                        <p class=\"table-heading\">Special Property \n                           					 \n                        </p> \n                     </th>\n                     <th class=\"table-heading\"> \n                        <p class=\"table-heading\">Availability \n                           					 \n                        </p> \n                     </th>\n                     <th class=\"table-heading\"> \n                        <p class=\"table-heading\">Description \n                           					 \n                        </p> \n                     </th>\n                  </tr>\n                  <tr class=\"not-ruled-odd-row\">\n                     <td class=\"table-body\"> \n                        <p class=\"table-body\">_Category \n                           					 \n                        </p> \n                     </td>\n                     <td class=\"table-body\"> \n                        <p class=\"table-body\">Vault: File, Folder, Custom Object \n                           					 \n                        </p> \n                        <p class=\"table-body\">AutoCAD, Inventor \n                           					 \n                        </p> \n                     </td>\n                     <td class=\"table-body\"> \n                        <p class=\"table-body\">Type of value: \n                           						<span class=\"code\">string</span> \n                        </p> \n                        <p class=\"table-body\">Is set to the assigned category for an existing Vault object. \n                           					 \n                        </p> \n                     </td>\n                  </tr>\n                  <tr class=\"not-ruled-even-row\">\n                     <td class=\"table-body\"> \n                        <p class=\"table-body\">_CreateMode \n                           					 \n                        </p> \n                     </td>\n                     <td class=\"table-body\"> \n                        <p class=\"table-body\">Vault: File, Folder, Custom Object \n                           					 \n                        </p> \n                        <p class=\"table-body\">AutoCAD, Inventor \n                           					 \n                        </p> \n                     </td>\n                     <td class=\"table-body\"> \n                        <p class=\"table-body\">Type of Value: \n                           						<span class=\"code\">bool</span> \n                        </p> \n                        <p class=\"table-body\">Can be used in PowerShell functions to determine if the Data Standard window is in\n                           create mode. This is the case when a file gets saved for the first time. \n                           					 \n                        </p> \n                     </td>\n                  </tr>\n                  <tr class=\"not-ruled-odd-row\">\n                     <td class=\"table-body\"> \n                        <p class=\"table-body\">_CopyMode \n                           					 \n                        </p> \n                     </td>\n                     <td class=\"table-body\"> \n                        <p class=\"table-body\">Inventor, AutoCAD \n                           					 \n                        </p> \n                     </td>\n                     <td class=\"table-body\"> \n                        <p class=\"table-body\">Type of value: \n                           						<span class=\"code\">bool</span> \n                        </p> \n                        <p class=\"table-body\">Can be used in PowerShell functions to determine if Data Standard window is in copy\n                           mode. Set to \n                           						<span class=\"code\">true</span> for the Data Standard functions Copy and Replace with Copy. \n                           					 \n                        </p> \n                        <p class=\"table-body\"> \n                           <div><a name=\"GUID-A5512986-53A3-4776-952F-28A3E96DB2A1\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span>When _CopyMode is \n                                 						  <span class=\"code\">true</span>, _CreateMode is also set to \n                                 						  <span class=\"code\">true</span>. \n                                 						\n                              </div>\n                           </div> \n                        </p> \n                     </td>\n                  </tr>\n                  <tr class=\"not-ruled-even-row\">\n                     <td class=\"table-body\"> \n                        <p class=\"table-body\">_EditMode \n                           					 \n                        </p> \n                     </td>\n                     <td class=\"table-body\"> \n                        <p class=\"table-body\">Vault: File, Folder, Custom Object \n                           					 \n                        </p> \n                        <p class=\"table-body\">AutoCAD, Inventor \n                           					 \n                        </p> \n                     </td>\n                     <td class=\"table-body\"> \n                        <p class=\"table-body\">Type of value: \n                           						<span class=\"code\">bool</span> \n                        </p> \n                        <p class=\"table-body\">Can be used in PowerShell functions to determine if Data Standard window is in edit\n                           mode. Set to true for the Data Standard function: Datasheet. \n                           					 \n                        </p> \n                     </td>\n                  </tr>\n                  <tr class=\"not-ruled-odd-row\">\n                     <td class=\"table-body\"> \n                        <p class=\"table-body\">_Format \n                           					 \n                        </p> \n                     </td>\n                     <td class=\"table-body\"> \n                        <p class=\"table-body\">Inventor \n                           					 \n                        </p> \n                     </td>\n                     <td class=\"table-body\"> \n                        <p class=\"table-body\">Type of value: \n                           						<span class=\"code\">string</span> \n                        </p> \n                        <p class=\"table-body\">Is set to the assigned format for an Inventor object or to the first element of \n                           						<span class=\"code\">ListValues</span>. \n                           					 \n                        </p> \n                        <p class=\"table-body\">Type of \n                           						<span class=\"code\">ListValues</span>: \n                           						<span class=\"code\">List&lt;string&gt;</span> Contains a list of formats which depend on the document type. \n                           					 <a name=\"UL_B1823ACC006E4D3E9F4541FEDB420585\"></a><ul>\n                              <li>For Drawings: PDF, DXF, DWG \n                                 						\n                              </li>\n                              <li>For Models: JT, STEP \n                                 						\n                              </li>\n                           </ul> \n                        </p> \n                     </td>\n                  </tr>\n                  <tr class=\"not-ruled-even-row\">\n                     <td class=\"table-body\"> \n                        <p class=\"table-body\">_FileExt \n                           					 \n                        </p> \n                     </td>\n                     <td class=\"table-body\"> \n                        <p class=\"table-body\">Vault: File \n                           					 \n                        </p> \n                        <p class=\"table-body\">AutoCAD, Inventor \n                           					 \n                        </p> \n                     </td>\n                     <td class=\"table-body\"> \n                        <p class=\"table-body\">Type of value: \n                           						<span class=\"code\">string</span> \n                        </p> \n                        <p class=\"table-body\">Contains the file extension. \n                           					 \n                        </p> \n                     </td>\n                  </tr>\n                  <tr class=\"not-ruled-odd-row\">\n                     <td class=\"table-body\"> \n                        <p class=\"table-body\">_FileName \n                           					 \n                        </p> \n                     </td>\n                     <td class=\"table-body\"> \n                        <p class=\"table-body\">Vault: File \n                           					 \n                        </p> \n                        <p class=\"table-body\">AutoCAD, Inventor \n                           					 \n                        </p> \n                     </td>\n                     <td class=\"table-body\"> \n                        <p class=\"table-body\">Type of value: \n                           						<span class=\"code\">string</span> \n                        </p> \n                        <p class=\"table-body\">Contains the file name without the extension. \n                           					 \n                        </p> \n                     </td>\n                  </tr>\n                  <tr class=\"not-ruled-even-row\">\n                     <td class=\"table-body\"> \n                        <p class=\"table-body\">_FilePath \n                           					 \n                        </p> \n                     </td>\n                     <td class=\"table-body\"> \n                        <p class=\"table-body\">Vault: File \n                           					 \n                        </p> \n                        <p class=\"table-body\">AutoCAd, Inventor \n                           					 \n                        </p> \n                     </td>\n                     <td class=\"table-body\"> \n                        <p class=\"table-body\">Type of value: \n                           						<span class=\"code\">string</span> \n                        </p> \n                        <p class=\"table-body\">Contains the Vault file path (starting with $) without the file name. \n                           					 \n                        </p> \n                     </td>\n                  </tr>\n                  <tr class=\"not-ruled-odd-row\">\n                     <td class=\"table-body\"> \n                        <p class=\"table-body\">_FolderName \n                           					 \n                        </p> \n                     </td>\n                     <td class=\"table-body\"> \n                        <p class=\"table-body\">Vault: Folder \n                           					 \n                        </p> \n                     </td>\n                     <td class=\"table-body\"> \n                        <p class=\"table-body\">Type of value: \n                           						<span class=\"code\">string</span> \n                        </p> \n                        <p class=\"table-body\">Contains the folder name. \n                           					 \n                        </p> \n                     </td>\n                  </tr>\n                  <tr class=\"not-ruled-even-row\">\n                     <td class=\"table-body\"> \n                        <p class=\"table-body\">_FolderPath \n                           					 \n                        </p> \n                     </td>\n                     <td class=\"table-body\"> \n                        <p class=\"table-body\">Vault: Folder \n                           					 \n                        </p> \n                     </td>\n                     <td class=\"table-body\"> \n                        <p class=\"table-body\">Type of value: \n                           						<span class=\"code\">string</span> \n                        </p> \n                        <p class=\"table-body\">Contains the Vault folder path (starting with $) without the file name. \n                           					 \n                        </p> \n                     </td>\n                  </tr>\n                  <tr class=\"not-ruled-odd-row\">\n                     <td class=\"table-body\"> \n                        <p class=\"table-body\">_GeneratedNumber \n                           					 \n                        </p> \n                     </td>\n                     <td class=\"table-body\"> \n                        <p class=\"table-body\">Vault: File \n                           					 \n                        </p> \n                     </td>\n                     <td class=\"table-body\"> \n                        <p class=\"table-body\">Type of value: \n                           						<span class=\"code\">string</span> \n                        </p> \n                        <p class=\"table-body\">Contains the generated number. The value is set by the \n                           						<span class=\"code\">DSNumSchemeCtr</span>l. See \n                           						<span class=\"char_link\"><a href=\"GUID-7EF1B4F5-BCE0-439D-B6F0-AF61BF2EFBC2.htm\">Numbering</a></span> for more information. \n                           					 \n                        </p> \n                     </td>\n                  </tr>\n                  <tr class=\"not-ruled-even-row\">\n                     <td class=\"table-body\"> \n                        <p class=\"table-body\">_OriginalFileName \n                           					 \n                        </p> \n                     </td>\n                     <td class=\"table-body\"> \n                        <p class=\"table-body\">AutoCAD, Inventor \n                           					 \n                        </p> \n                     </td>\n                     <td class=\"table-body\"> \n                        <p class=\"table-body\">Type of value: \n                           						<span class=\"code\">string</span> \n                        </p> \n                        <p class=\"table-body\">Contains the source document\'s name during a Copy or Copy Include Drawing event. \n                           					 \n                        </p> \n                     </td>\n                  </tr>\n                  <tr class=\"not-ruled-odd-row\">\n                     <td class=\"table-body\"> \n                        <p class=\"table-body\">_SaveCopyAsMode \n                           					 \n                        </p> \n                     </td>\n                     <td class=\"table-body\"> \n                        <p class=\"table-body\">Inventor \n                           					 \n                        </p> \n                     </td>\n                     <td class=\"table-body\"> \n                        <p class=\"table-body\">Type of value: \n                           						<span class=\"code\">bool</span> \n                        </p> \n                        <p class=\"table-body\">Value is set to true when an Inventor user clicks the Save Copy As button, otherwise\n                           value is false. \n                           					 \n                        </p> \n                     </td>\n                  </tr>\n                  <tr class=\"not-ruled-even-row\">\n                     <td class=\"table-body\"> \n                        <p class=\"table-body\">_SuggestedVaultPath \n                           					 \n                        </p> \n                     </td>\n                     <td class=\"table-body\"> \n                        <p class=\"table-body\">Inventor \n                           					 \n                        </p> \n                     </td>\n                     <td class=\"table-body\"> \n                        <p class=\"table-body\">Type of value: \n                           						<span class=\"code\">string</span> \n                        </p> \n                        <p class=\"table-body\">Contains the path of the directly related file, for example, the path of the parent\n                           assembly for components created in the assembly context, or the path of the main component\n                           view in the drawings. \n                           					 \n                        </p> \n                     </td>\n                  </tr>\n                  <tr class=\"not-ruled-odd-row\">\n                     <td class=\"table-body\"> \n                        <p class=\"table-body\">_VaultVirtualPath \n                           					 \n                        </p> \n                     </td>\n                     <td class=\"table-body\"> \n                        <p class=\"table-body\">Inventor \n                           					 \n                        </p> \n                     </td>\n                     <td class=\"table-body\"> \n                        <p class=\"table-body\">Type of value: \n                           						<span class=\"code\">string</span> \n                        </p> \n                        <p class=\"table-body\">Contains the mapped virtual folder for Vault as defined in the Inventor project file.\n                           \n                           					 \n                        </p> \n                     </td>\n                  </tr>\n                  <tr class=\"not-ruled-even-row\">\n                     <td class=\"table-body\"> \n                        <p class=\"table-body\">_WorkspacePath \n                           					 \n                        </p> \n                     </td>\n                     <td class=\"table-body\"> \n                        <p class=\"table-body\">Inventor \n                           					 \n                        </p> \n                     </td>\n                     <td class=\"table-body\"> \n                        <p class=\"table-body\">Type of value: \n                           						<span class=\"code\">string</span> \n                        </p> \n                        <p class=\"table-body\">Contains the workspace path as defined in the Inventor project file. \n                           					 \n                        </p> \n                     </td>\n                  </tr>\n               </table>\n            </div> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_EBE6713EBA59467C9FD41D68017F5A96\"></a> \n            <h2><a name=\"GUID-F403C638-1734-4C16-AEAC-2E3F0C838C74\"></a>Localization\n            </h2> \n            <p>When the property name in the square brackets [] starts with the prefix \n               		  <span class=\"code\">_XLTN_</span> (e.g., \n               		  <span class=\"code\">$prop[\"_XLTN_TITLE_ITEM_CO\"].Value</span>), the name is mapped to the real property name of the localized Vault server version.\n               See \n               		  <span class=\"char_link\"><a href=\"GUID-244DFF1D-7473-41D8-AA7D-43A3FB25D17F.htm\">Localization</a></span> for more information. \n               		\n            </p> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_B21D089AD37549E7B5B0BF0406E79327\"></a> \n            <h2><a name=\"GUID-60105613-5481-4BFD-A2A2-1AD3836305F7\"></a>Object \n               		  <span class=\"code\">IProperty</span></h2> \n            <p>The \n               		  <span class=\"code\">IProperty</span> object is a wrapper for the underlying Vault or CAD property. \n               		\n            </p> \n            <div><a name=\"GUID-9B3E0AFF-4DAF-45B2-A2AD-960F5309032C\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span> The expression \n                  		  <span class=\"code\">$prop[\"Title\"]</span> just returns an \n                  		  <span class=\"code\">IProperty</span> object for the property \"Title.\" It does not return the direct value of the property.\n                  \n                  		\n               </div>\n            </div> <a name=\"UL_012646FB743D4106908FEA966B341F04\"></a><p class=\"list-intro\">Properties</p>\n            <p> <a name=\"TABLE_3904405B671948F7BA28BD51865C2876\"></a><div class=\"table-not-ruled\">\n                  <table cellpadding=\"0\" cellspacing=\"0\" class=\"not-ruled\">\n                     <colgroup>\n                        <col width=\"28.52512155591572%\">\n                        <col width=\"16.207455429497568%\">\n                        <col width=\"55.26742301458671%\">\n                     </colgroup>\n                     <tr class=\"not-ruled-heading\">\n                        <th class=\"table-heading\"> \n                           <p class=\"table-heading\">Name \n                              					 \n                           </p> \n                        </th>\n                        <th class=\"table-heading\"> \n                           <p class=\"table-heading\">Type \n                              					 \n                           </p> \n                        </th>\n                        <th class=\"table-heading\"> \n                           <p class=\"table-heading\">Description \n                              					 \n                           </p> \n                        </th>\n                     </tr>\n                     <tr class=\"not-ruled-odd-row\">\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">Value \n                              					 \n                           </p> \n                        </td>\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">object \n                              					 \n                           </p> \n                        </td>\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\"> Returns the value of the property. Can be used to get or set the property value.\n                              \n                              					 \n                           </p> \n                        </td>\n                     </tr>\n                     <tr class=\"not-ruled-even-row\">\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">IsValid \n                              					 \n                           </p> \n                        </td>\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">bool \n                              					 \n                           </p> \n                        </td>\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\"> Checks if the property is valid \n                              					 \n                           </p> \n                        </td>\n                     </tr>\n                     <tr class=\"not-ruled-odd-row\">\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">IsInvalid \n                              					 \n                           </p> \n                        </td>\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">bool \n                              					 \n                           </p> \n                        </td>\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\"> Negation of IsValid. Useful because it is not easy to negate values in XAML. \n                              					 \n                           </p> \n                        </td>\n                     </tr>\n                     <tr class=\"not-ruled-even-row\">\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">ListValues \n                              					 \n                           </p> \n                        </td>\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">Object \n                              					 \n                           </p> \n                           <p class=\"table-body\">Array \n                              					 \n                           </p> \n                        </td>\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\"> Only used for the special property \"_Category.\" Returns a list of strings. \n                              					 \n                           </p> \n                        </td>\n                     </tr>\n                     <tr class=\"not-ruled-odd-row\">\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">EnforceListValues \n                              					 \n                           </p> \n                        </td>\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">bool \n                              					 \n                           </p> \n                        </td>\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">Gets the existing value if any or can be set to override it. \n                              					 \n                           </p> \n                        </td>\n                     </tr>\n                     <tr class=\"not-ruled-even-row\">\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">IsObligatory \n                              					 \n                           </p> \n                        </td>\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">bool \n                              					 \n                           </p> \n                        </td>\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">Gets the existing value if any or can be set to override it. \n                              					 \n                           </p> \n                        </td>\n                     </tr>\n                     <tr class=\"not-ruled-odd-row\">\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">Minimum Length \n                              					 \n                           </p> \n                        </td>\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">int \n                              					 \n                           </p> \n                        </td>\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">Gets the existing value if any or can be set to override it. \n                              					 \n                           </p> \n                        </td>\n                     </tr>\n                     <tr class=\"not-ruled-even-row\">\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">MaximumLength \n                              					 \n                           </p> \n                        </td>\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">int \n                              					 \n                           </p> \n                        </td>\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">Gets the existing value if any or can be set to override it. \n                              					 \n                           </p> \n                        </td>\n                     </tr>\n                     <tr class=\"not-ruled-odd-row\">\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">Case \n                              					 \n                           </p> \n                        </td>\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">string \n                              					 \n                           </p> \n                        </td>\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">Gets the existing value if any or can be set to override it. \n                              					 \n                           </p> \n                        </td>\n                     </tr>\n                     <tr class=\"not-ruled-even-row\">\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">MinimumDate \n                              					 \n                           </p> \n                        </td>\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">DateTime \n                              					 \n                           </p> \n                        </td>\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">Gets the existing value if any or can be set to override it. \n                              					 \n                           </p> \n                        </td>\n                     </tr>\n                     <tr class=\"not-ruled-odd-row\">\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">MaximumDate \n                              					 \n                           </p> \n                        </td>\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">DateTime \n                              					 \n                           </p> \n                        </td>\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">Gets the existing value if any or can be set to override it. \n                              					 \n                           </p> \n                        </td>\n                     </tr>\n                     <tr class=\"not-ruled-even-row\">\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">MinimumValue \n                              					 \n                           </p> \n                        </td>\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">int \n                              					 \n                           </p> \n                        </td>\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">Gets the existing value if any or can be set to override it. \n                              					 \n                           </p> \n                        </td>\n                     </tr>\n                     <tr class=\"not-ruled-odd-row\">\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">MaximumValue \n                              					 \n                           </p> \n                        </td>\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">int \n                              					 \n                           </p> \n                        </td>\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">Gets the existing value if any or can be set to override it. \n                              					 \n                           </p> \n                        </td>\n                     </tr>\n                     <tr class=\"not-ruled-even-row\">\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">CustomValidation \n                              					 \n                           </p> \n                        </td>\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">ScriptBlock \n                              					 \n                           </p> \n                        </td>\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">Executes scriptblock and returns the result. The script block should return a bool\n                              value. When this is set, then all the other constraints are not executed. \n                              					 \n                           </p> \n                        </td>\n                     </tr>\n                     <tr class=\"not-ruled-odd-row\">\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">CustomValidationErrorMessage \n                              					 \n                           </p> \n                        </td>\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">string \n                              					 \n                           </p> \n                        </td>\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">When the above CustomValidation returns false, any text set here will appear as tooltip\n                              on the control that this Prop object is bound to. \n                              					 \n                           </p> \n                        </td>\n                     </tr>\n                  </table>\n               </div> \n            </p> <a name=\"UL_6CF96A03A8FF41E8B199B1118D7A0C18\"></a><p class=\"list-intro\">Events</p>\n            <p> <a name=\"TABLE_ECC9446E74D4494E96D394AB3BA687E1\"></a><div class=\"table-not-ruled\">\n                  <table cellpadding=\"0\" cellspacing=\"0\" class=\"not-ruled\">\n                     <colgroup>\n                        <col>\n                        <col>\n                     </colgroup>\n                     <tr class=\"not-ruled-heading\">\n                        <th class=\"table-heading\"> \n                           <p class=\"table-heading\">Name \n                              					 \n                           </p> \n                        </th>\n                        <th class=\"table-heading\"> \n                           <p class=\"table-heading\">Description \n                              					 \n                           </p> \n                        </th>\n                     </tr>\n                     <tr class=\"not-ruled-odd-row\">\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">PropertyChanged \n                              					 \n                           </p> \n                        </td>\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\"> Occurs when a property value changes. See \n                              						<span class=\"char_link\"><a href=\"GUID-8C4F0EAD-7ADB-40BC-B1BD-A97569F0458A.htm\">Example-Using Events with the Data Standard Dialog</a></span> for an example. \n                              					 \n                           </p> \n                        </td>\n                     </tr>\n                  </table>\n               </div> \n            </p> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_9BCEBC0EF55847418156AF65EC8E98A2\"></a> \n            <h2><a name=\"GUID-0FEC2593-1DA9-443A-B412-6AF39BED8248\"></a>Examples\n            </h2> \n            <p> In PowerShell, properties can be accessed with the following syntax: \n               		\n            </p> \n            <p><em class=\"strong\">PowerShell</em> \n            </p> \n            <div class=\"codeBlock\"><pre class=\"prettyprint\">$fileName = $Prop[\"_FileName\"].Value</pre></div> \n            <p> </p> \n            <p> The same object can be accessed through a \n               		  <span class=\"char_link\"><a href=\"GUID-F37FCEBB-BE65-4591-874E-3DA7691B6023.htm\">XAML binding</a></span>. However the syntax is slightly different: \n               		\n            </p> \n            <p><em class=\"strong\">XAML</em> \n            </p> \n            <div class=\"codeBlock\"><pre class=\"prettyprint\">&lt;TextBox Text=\"{Binding Prop[_FileName].Value}\"/&gt;</pre></div> \n         </div>\n         <div class=\"footer-block\"><a href=\"..\" class=\"comments-anchor\" target=\"_blank\"><span class=\"comments-link\">Please send us your comment about this page</span></a></div><br><p class=\"footer-license-block\"><a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\"><img alt=\"Creative Commons License\" style=\"border-width: 0;\" src=\"../images/ccLink.png\"></a>&nbsp;<em>Except where otherwise noted, this work is licensed under a <a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\">Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License</a>. Please see the <a href=\"http://autodesk.com/creativecommons\" target=\"_blank\">Autodesk Creative Commons FAQ</a> for more information.</em></p><br></div>\n   </body>\n</html>";
// SIG // Begin signature block
// SIG // MIIbRgYJKoZIhvcNAQcCoIIbNzCCGzMCAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // HhSdxKBEfhdonq5lAV/RTWc50UhMiNq23sefdcZe1P+g
// SIG // ggoaMIIEyzCCA7OgAwIBAgIQCQja65wGHi65un4mqmKH
// SIG // ijANBgkqhkiG9w0BAQsFADCBhDELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTUw
// SIG // MwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
// SIG // b2RlIFNpZ25pbmcgQ0EgLSBHMjAeFw0xOTA1MTQwMDAw
// SIG // MDBaFw0yMDA1MTMyMzU5NTlaMHwxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIDApDYWxpZm9ybmlhMRMwEQYDVQQHDApT
// SIG // YW4gUmFmYWVsMRcwFQYDVQQKDA5BdXRvZGVzaywgSW5j
// SIG // LjERMA8GA1UECwwIU2VjdXJpdHkxFzAVBgNVBAMMDkF1
// SIG // dG9kZXNrLCBJbmMuMIIBIjANBgkqhkiG9w0BAQEFAAOC
// SIG // AQ8AMIIBCgKCAQEAkVKRoPYsoxPdlabspcuG8HYDfcWQ
// SIG // 9qyPOT2punwpVdjt2slktcpSTlydrGy8ijcbl5/k8AOJ
// SIG // afKMQvow0fNjIoNB5nsb8j2xFJPbBhHl8GT4P6DZ1OWK
// SIG // ioiUXgGHKjctUws49J4elntqvBYhKCbuPqG772QCoYFU
// SIG // P7qcFbh3PbyNB6cnKMn2vNGRqiEtV2aGg+/MiL3QPsvT
// SIG // kTWhVuTLIvwZ4kK5C5ACiQzlGOlE+C7gWuFoxtvy6gUa
// SIG // A8JAq/xLjYKwFevQwGncg3s1cuiGhx0P7Rvn6oCd2cem
// SIG // FmbK3I3rMRt+jc9wzAj3oHxvCo4f5Lfva+OpC1dETUVV
// SIG // sk0VGwIDAQABo4IBPjCCATowCQYDVR0TBAIwADAOBgNV
// SIG // HQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMw
// SIG // YQYDVR0gBFowWDBWBgZngQwBBAEwTDAjBggrBgEFBQcC
// SIG // ARYXaHR0cHM6Ly9kLnN5bWNiLmNvbS9jcHMwJQYIKwYB
// SIG // BQUHAgIwGQwXaHR0cHM6Ly9kLnN5bWNiLmNvbS9ycGEw
// SIG // HwYDVR0jBBgwFoAU1MAGIknrOUvdk+JcobhHdglyA1gw
// SIG // KwYDVR0fBCQwIjAgoB6gHIYaaHR0cDovL3JiLnN5bWNi
// SIG // LmNvbS9yYi5jcmwwVwYIKwYBBQUHAQEESzBJMB8GCCsG
// SIG // AQUFBzABhhNodHRwOi8vcmIuc3ltY2QuY29tMCYGCCsG
// SIG // AQUFBzAChhpodHRwOi8vcmIuc3ltY2IuY29tL3JiLmNy
// SIG // dDANBgkqhkiG9w0BAQsFAAOCAQEA0Q2+iVSEfT4xGq3A
// SIG // OADVb0rT5Z8E+PPb1x6hKknSzuaZKk/acDz9mdnFajaU
// SIG // WgIKiFJlsqJnuAM1w4lqKaEWsz3DoxvGIEwexj71Ud6a
// SIG // KlBJNcR9DdkXUZwMhbw9d78rjJAIX6tOwfSludZfdq8b
// SIG // YEkuIzQi9uYW9vHVPSCzhnUBKjwc9qTo9yBc7Fcn4FAT
// SIG // 90DzWM2hS9oc3p0pprYI2I/O4th90BEmwWkVqVgfaR0z
// SIG // VyIEmBbqB/IWLfjUBZJ/8sbkwWuWlYVRrfPxsj1e9qvb
// SIG // wE3Y28jWyGbqoUG39GhXk3uT8R8i3+T6M0c4rMfdifBC
// SIG // pceCaFTJzSye7LoeVzCCBUcwggQvoAMCAQICEHwbNTVK
// SIG // 59t050FfEWnKa6gwDQYJKoZIhvcNAQELBQAwgb0xCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjEfMB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29y
// SIG // azE6MDgGA1UECxMxKGMpIDIwMDggVmVyaVNpZ24sIElu
// SIG // Yy4gLSBGb3IgYXV0aG9yaXplZCB1c2Ugb25seTE4MDYG
// SIG // A1UEAxMvVmVyaVNpZ24gVW5pdmVyc2FsIFJvb3QgQ2Vy
// SIG // dGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMTQwNzIyMDAw
// SIG // MDAwWhcNMjQwNzIxMjM1OTU5WjCBhDELMAkGA1UEBhMC
// SIG // VVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9u
// SIG // MR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3Jr
// SIG // MTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1
// SIG // NiBDb2RlIFNpZ25pbmcgQ0EgLSBHMjCCASIwDQYJKoZI
// SIG // hvcNAQEBBQADggEPADCCAQoCggEBANeVQ9Tc32euOftS
// SIG // pLYmMQRw6beOWyq6N2k1lY+7wDDnhthzu9/r0XY/ilaO
// SIG // 6y1L8FcYTrGNpTPTC3Uj1Wp5J92j0/cOh2W13q0c8fU1
// SIG // tCJRryKhwV1LkH/AWU6rnXmpAtceSbE7TYf+wnirv+9S
// SIG // rpyvCNk55ZpRPmlfMBBOcWNsWOHwIDMbD3S+W8sS4duM
// SIG // xICUcrv2RZqewSUL+6McntimCXBx7MBHTI99w94Zzj7u
// SIG // BHKOF9P/8LIFMhlM07Acn/6leCBCcEGwJoxvAMg6ABFB
// SIG // ekGwp4qRBKCZePR3tPNgKuZsUAS3FGD/DVH0qIuE/iHa
// SIG // XF599Sl5T7BEdG9tcv8CAwEAAaOCAXgwggF0MC4GCCsG
// SIG // AQUFBwEBBCIwIDAeBggrBgEFBQcwAYYSaHR0cDovL3Mu
// SIG // c3ltY2QuY29tMBIGA1UdEwEB/wQIMAYBAf8CAQAwZgYD
// SIG // VR0gBF8wXTBbBgtghkgBhvhFAQcXAzBMMCMGCCsGAQUF
// SIG // BwIBFhdodHRwczovL2Quc3ltY2IuY29tL2NwczAlBggr
// SIG // BgEFBQcCAjAZGhdodHRwczovL2Quc3ltY2IuY29tL3Jw
// SIG // YTA2BgNVHR8ELzAtMCugKaAnhiVodHRwOi8vcy5zeW1j
// SIG // Yi5jb20vdW5pdmVyc2FsLXJvb3QuY3JsMBMGA1UdJQQM
// SIG // MAoGCCsGAQUFBwMDMA4GA1UdDwEB/wQEAwIBBjApBgNV
// SIG // HREEIjAgpB4wHDEaMBgGA1UEAxMRU3ltYW50ZWNQS0kt
// SIG // MS03MjQwHQYDVR0OBBYEFNTABiJJ6zlL3ZPiXKG4R3YJ
// SIG // cgNYMB8GA1UdIwQYMBaAFLZ3+mlIR59TEtXC6gcydgfR
// SIG // lwcZMA0GCSqGSIb3DQEBCwUAA4IBAQB/68qn6ot2Qus+
// SIG // jiBUMOO3udz6SD4Wxw9FlRDNJ4ajZvMC7XH4qsJVl5Fw
// SIG // g/lSflJpPMnx4JRGgBi7odSkVqbzHQCR1YbzSIfgy8Q0
// SIG // aCBetMv5Be2cr3BTJ7noPn5RoGlxi9xR7YA6JTKfRK9u
// SIG // QyjTIXW7l9iLi4z+qQRGBIX3FZxLEY3ELBf+1W5/muJW
// SIG // kvGWs60t+fTf2omZzrI4RMD3R3vKJbn6Kmgzm1By3qif
// SIG // 1M0sCzS9izB4QOCNjicbkG8avggVgV3rL+JR51EeyXgp
// SIG // 5x5lvzjvAUoBCSQOFsQUecFBNzTQPZFSlJ3haO8I8OJp
// SIG // nGdukAsak3HUJgLDwFojMYIQhDCCEIACAQEwgZkwgYQx
// SIG // CzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRlYyBD
// SIG // b3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1
// SIG // c3QgTmV0d29yazE1MDMGA1UEAxMsU3ltYW50ZWMgQ2xh
// SIG // c3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENBIC0gRzIC
// SIG // EAkI2uucBh4uubp+Jqpih4owDQYJYIZIAWUDBAIBBQCg
// SIG // fDAQBgorBgEEAYI3AgEMMQIwADAZBgkqhkiG9w0BCQMx
// SIG // DAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4wDAYK
// SIG // KwYBBAGCNwIBFTAvBgkqhkiG9w0BCQQxIgQgoKWb8Mdb
// SIG // XMHWFwT8GUCAZbEK/AtOP9iGDdnm2eB4LGcwDQYJKoZI
// SIG // hvcNAQEBBQAEggEATV1FqSOFn/3SFzJzbRYxy9WLZ3Sl
// SIG // 6xu4aYQ9AOBJchErwTIDpsxvqPGHG/E1W9+XmkP1n93I
// SIG // jnYaY+A8JLwhAYEQVpYz//0RnDVwT0XgbsjMSaqzvZNp
// SIG // gjEBwRX7VSdCCz0sxRmxoV7yjvUoDfqbkCCMcQm4U7EX
// SIG // eEMxJy2DOzNeX4dNCHwBJjDKPycsPd4W9DJcwqsreFzY
// SIG // GvJSpLGC/D2kNkPQA745Jo3ZySnYbtKWsOgpJbXbphsX
// SIG // yH1nilbqSVqdZtIB9HN48tCMYoru3TPVRV3/41ClLm6a
// SIG // kRYaKFyM4p70X4RWLMgwbvDR95i7NKDOOo3x/WIqHzeQ
// SIG // Gfg2dKGCDj0wgg45BgorBgEEAYI3AwMBMYIOKTCCDiUG
// SIG // CSqGSIb3DQEHAqCCDhYwgg4SAgEDMQ0wCwYJYIZIAWUD
// SIG // BAIBMIIBDwYLKoZIhvcNAQkQAQSggf8EgfwwgfkCAQEG
// SIG // C2CGSAGG+EUBBxcDMDEwDQYJYIZIAWUDBAIBBQAEILLo
// SIG // QMqG+7Ft64rhGqq4hIGJuQxWc4ycSaZREj7GGszqAhUA
// SIG // upNEePhSnQ/fsfxctLylv6KFOR8YDzIwMjAwMzIzMTQw
// SIG // MzAwWjADAgEeoIGGpIGDMIGAMQswCQYDVQQGEwJVUzEd
// SIG // MBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xHzAd
// SIG // BgNVBAsTFlN5bWFudGVjIFRydXN0IE5ldHdvcmsxMTAv
// SIG // BgNVBAMTKFN5bWFudGVjIFNIQTI1NiBUaW1lU3RhbXBp
// SIG // bmcgU2lnbmVyIC0gRzOgggqLMIIFODCCBCCgAwIBAgIQ
// SIG // ewWx1EloUUT3yYnSnBmdEjANBgkqhkiG9w0BAQsFADCB
// SIG // vTELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWdu
// SIG // LCBJbmMuMR8wHQYDVQQLExZWZXJpU2lnbiBUcnVzdCBO
// SIG // ZXR3b3JrMTowOAYDVQQLEzEoYykgMjAwOCBWZXJpU2ln
// SIG // biwgSW5jLiAtIEZvciBhdXRob3JpemVkIHVzZSBvbmx5
// SIG // MTgwNgYDVQQDEy9WZXJpU2lnbiBVbml2ZXJzYWwgUm9v
// SIG // dCBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAeFw0xNjAx
// SIG // MTIwMDAwMDBaFw0zMTAxMTEyMzU5NTlaMHcxCzAJBgNV
// SIG // BAYTAlVTMR0wGwYDVQQKExRTeW1hbnRlYyBDb3Jwb3Jh
// SIG // dGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0
// SIG // d29yazEoMCYGA1UEAxMfU3ltYW50ZWMgU0hBMjU2IFRp
// SIG // bWVTdGFtcGluZyBDQTCCASIwDQYJKoZIhvcNAQEBBQAD
// SIG // ggEPADCCAQoCggEBALtZnVlVT52Mcl0agaLrVfOwAa08
// SIG // cawyjwVrhponADKXak3JZBRLKbvC2Sm5Luxjs+HPPwtW
// SIG // kPhiG37rpgfi3n9ebUA41JEG50F8eRzLy60bv9iVkfPw
// SIG // 7mz4rZY5Ln/BJ7h4OcWEpe3tr4eOzo3HberSmLU6Hx45
// SIG // ncP0mqj0hOHE0XxxxgYptD/kgw0mw3sIPk35CrczSf/K
// SIG // O9T1sptL4YiZGvXA6TMU1t/HgNuR7v68kldyd/TNqMz+
// SIG // CfWTN76ViGrF3PSxS9TO6AmRX7WEeTWKeKwZMo8jwTJB
// SIG // G1kOqT6xzPnWK++32OTVHW0ROpL2k8mc40juu1MO1DaX
// SIG // hnjFoTcCAwEAAaOCAXcwggFzMA4GA1UdDwEB/wQEAwIB
// SIG // BjASBgNVHRMBAf8ECDAGAQH/AgEAMGYGA1UdIARfMF0w
// SIG // WwYLYIZIAYb4RQEHFwMwTDAjBggrBgEFBQcCARYXaHR0
// SIG // cHM6Ly9kLnN5bWNiLmNvbS9jcHMwJQYIKwYBBQUHAgIw
// SIG // GRoXaHR0cHM6Ly9kLnN5bWNiLmNvbS9ycGEwLgYIKwYB
// SIG // BQUHAQEEIjAgMB4GCCsGAQUFBzABhhJodHRwOi8vcy5z
// SIG // eW1jZC5jb20wNgYDVR0fBC8wLTAroCmgJ4YlaHR0cDov
// SIG // L3Muc3ltY2IuY29tL3VuaXZlcnNhbC1yb290LmNybDAT
// SIG // BgNVHSUEDDAKBggrBgEFBQcDCDAoBgNVHREEITAfpB0w
// SIG // GzEZMBcGA1UEAxMQVGltZVN0YW1wLTIwNDgtMzAdBgNV
// SIG // HQ4EFgQUr2PWyqNOhXLgp7xB8ymiOH+AdWIwHwYDVR0j
// SIG // BBgwFoAUtnf6aUhHn1MS1cLqBzJ2B9GXBxkwDQYJKoZI
// SIG // hvcNAQELBQADggEBAHXqsC3VNBlcMkX+DuHUT6Z4wW/X
// SIG // 6t3cT/OhyIGI96ePFeZAKa3mXfSi2VZkhHEwKt0eYRdm
// SIG // IFYGmBmNXXHy+Je8Cf0ckUfJ4uiNA/vMkC/WCmxOM+zW
// SIG // tJPITJBjSDlAIcTd1m6JmDy1mJfoqQa3CcmPU1dBkC/h
// SIG // Hk1O3MoQeGxCbvC2xfhhXFL1TvZrjfdKer7zzf0D19n2
// SIG // A6gP41P3CnXsxnUuqmaFBJm3+AZX4cYO9uiv2uybGB+q
// SIG // ueM6AL/OipTLAduexzi7D1Kr0eOUA2AKTaD+J20UMvw/
// SIG // l0Dhv5mJ2+Q5FL3a5NPD6itas5VYVQR9x5rsIwONhSrS
// SIG // /66pYYEwggVLMIIEM6ADAgECAhB71OWvuswHP6EBIwQi
// SIG // QU0SMA0GCSqGSIb3DQEBCwUAMHcxCzAJBgNVBAYTAlVT
// SIG // MR0wGwYDVQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlvbjEf
// SIG // MB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazEo
// SIG // MCYGA1UEAxMfU3ltYW50ZWMgU0hBMjU2IFRpbWVTdGFt
// SIG // cGluZyBDQTAeFw0xNzEyMjMwMDAwMDBaFw0yOTAzMjIy
// SIG // MzU5NTlaMIGAMQswCQYDVQQGEwJVUzEdMBsGA1UEChMU
// SIG // U3ltYW50ZWMgQ29ycG9yYXRpb24xHzAdBgNVBAsTFlN5
// SIG // bWFudGVjIFRydXN0IE5ldHdvcmsxMTAvBgNVBAMTKFN5
// SIG // bWFudGVjIFNIQTI1NiBUaW1lU3RhbXBpbmcgU2lnbmVy
// SIG // IC0gRzMwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEK
// SIG // AoIBAQCvDoqq+Ny/aXtUF3FHCb2NPIH4dBV3Z5Cc/d5O
// SIG // Ap5LdvblNj5l1SQgbTD53R2D6T8nSjNObRaK5I1AjSKq
// SIG // vqcLG9IHtjy1GiQo+BtyUT3ICYgmCDr5+kMjdUdwDLNf
// SIG // W48IHXJIV2VNrwI8QPf03TI4kz/lLKbzWSPLgN4TTfkQ
// SIG // yaoKGGxVYVfR8QIsxLWr8mwj0p8NDxlsrYViaf1OhcGK
// SIG // UjGrW9jJdFLjV2wiv1V/b8oGqz9KtyJ2ZezsNvKWlYEm
// SIG // LP27mKoBONOvJUCbCVPwKVeFWF7qhUhBIYfl3rTTJrJ7
// SIG // QFNYeY5SMQZNlANFxM48A+y3API6IsW0b+XvsIqbAgMB
// SIG // AAGjggHHMIIBwzAMBgNVHRMBAf8EAjAAMGYGA1UdIARf
// SIG // MF0wWwYLYIZIAYb4RQEHFwMwTDAjBggrBgEFBQcCARYX
// SIG // aHR0cHM6Ly9kLnN5bWNiLmNvbS9jcHMwJQYIKwYBBQUH
// SIG // AgIwGRoXaHR0cHM6Ly9kLnN5bWNiLmNvbS9ycGEwQAYD
// SIG // VR0fBDkwNzA1oDOgMYYvaHR0cDovL3RzLWNybC53cy5z
// SIG // eW1hbnRlYy5jb20vc2hhMjU2LXRzcy1jYS5jcmwwFgYD
// SIG // VR0lAQH/BAwwCgYIKwYBBQUHAwgwDgYDVR0PAQH/BAQD
// SIG // AgeAMHcGCCsGAQUFBwEBBGswaTAqBggrBgEFBQcwAYYe
// SIG // aHR0cDovL3RzLW9jc3Aud3Muc3ltYW50ZWMuY29tMDsG
// SIG // CCsGAQUFBzAChi9odHRwOi8vdHMtYWlhLndzLnN5bWFu
// SIG // dGVjLmNvbS9zaGEyNTYtdHNzLWNhLmNlcjAoBgNVHREE
// SIG // ITAfpB0wGzEZMBcGA1UEAxMQVGltZVN0YW1wLTIwNDgt
// SIG // NjAdBgNVHQ4EFgQUpRMBqZ+FzBtuFh5fOzGqeTYAex0w
// SIG // HwYDVR0jBBgwFoAUr2PWyqNOhXLgp7xB8ymiOH+AdWIw
// SIG // DQYJKoZIhvcNAQELBQADggEBAEaer/C4ol+imUjPqCdL
// SIG // Ic2yuaZycGMv41UpezlGTud+ZQZYi7xXipINCNgQujYk
// SIG // +gp7+zvTYr9KlBXmgtuKVG3/KP5nz3E/5jMJ2aJZEPQe
// SIG // Sv5lzN7Ua+NSKXUASiulzMub6KlN97QXWZJBw7c/hub2
// SIG // wH9EPEZcF1rjpDvVaSbVIX3hgGd+Yqy3Ti4VmuWcI69b
// SIG // EepxqUH5DXk4qaENz7Sx2j6aescixXTN30cJhsT8kSWy
// SIG // G5bphQjo3ep0YG5gpVZ6DchEWNzm+UgUnuW/3gC9d7GY
// SIG // FHIUJN/HESwfAD/DSxTGZxzMHgajkF9cVIs+4zNbgg/F
// SIG // t4YCTnGf6WZFP3YxggJaMIICVgIBATCBizB3MQswCQYD
// SIG // VQQGEwJVUzEdMBsGA1UEChMUU3ltYW50ZWMgQ29ycG9y
// SIG // YXRpb24xHzAdBgNVBAsTFlN5bWFudGVjIFRydXN0IE5l
// SIG // dHdvcmsxKDAmBgNVBAMTH1N5bWFudGVjIFNIQTI1NiBU
// SIG // aW1lU3RhbXBpbmcgQ0ECEHvU5a+6zAc/oQEjBCJBTRIw
// SIG // CwYJYIZIAWUDBAIBoIGkMBoGCSqGSIb3DQEJAzENBgsq
// SIG // hkiG9w0BCRABBDAcBgkqhkiG9w0BCQUxDxcNMjAwMzIz
// SIG // MTQwMzAwWjAvBgkqhkiG9w0BCQQxIgQgAylP34/Pzpgh
// SIG // YMmn6oOb91shZG7aWRjnJLQ935DL7fkwNwYLKoZIhvcN
// SIG // AQkQAi8xKDAmMCQwIgQgxHTOdgB9AjlODaXk3nwUxoD5
// SIG // 4oIBPP72U+9dtx/fYfgwCwYJKoZIhvcNAQEBBIIBAKFm
// SIG // Ud8hPut+wLI7hlFvENJCYmAPp0dcCA1quscF4lbRv8va
// SIG // lgllMoXKhBLFbNrBH8yINwhSpEf4Jx6zOXl+Cg6sBOx+
// SIG // UFbep+3EIjBHZieGG5f6uMMk8BoKgOFD0P9jPFAH52VA
// SIG // GcG+KwdqhfnInjZC6W2Bi/pCXB3BMySheBTjNxqV6dr+
// SIG // G3Hpfen97DK2ugYjrpyE2YfQ67cVFsl9ETIijmIJ9yAP
// SIG // NGSrrqTGR9oIlUzM5mArKyGa6nSdYioNZZv55j1+bbBR
// SIG // 6jzXSCJ9vJ6l110tNqHePD77nbqiQvYY5CpEUDvfTPzN
// SIG // 2ehXrLr6xElvzLCRd/Kke8328DACgJQ=
// SIG // End signature block
