var topic = "<!DOCTYPE html>\r\n\n<!-- saved from url=(0024)http://docs.autodesk.com -->\r\n<html>\n   <head>\n      <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n      <meta name=\"product\" content=\"VAULT\">\n      <meta name=\"release\" content=\"2021\">\n      <meta name=\"book\" content=\"GeneralUser\">\n      <meta name=\"created\" content=\"2020-03-20\">\n      <meta name=\"topicid\" content=\"GUID-959DDEDA-0FB5-4C93-8685-970CC0364498\">\n      <meta name=\"description\" content=\"This section is intended to aid developers who are using the Vault SDK and wish to leverage the workflows and utilities provided by the VDF in their own applications.\">\n      <meta name=\"topic-type\" content=\"concept\">\n      <meta name=\"audience\" content=\"programmer\">\n      <meta name=\"experiencelevel\" content=\"general\">\n      <title>Developing with the VDF</title><script language=\"javascript\">var index = \'index.html\';</script><script type=\"text/javascript\" src=\"../scripts/prettify/prettify.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-yaml.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-xq.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-wiki.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-vhdl.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-vb.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-tex.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-sql.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-scala.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-proto.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-n.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-ml.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-lua.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-lisp.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-hs.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-go.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-css.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-clj.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-apollo.js\"></script></head>\n   <body height=\"100%\" onLoad=\"javascript:prettyPrint();\">\n      <div class=\"body_content\" id=\"body-content\" dir=\"ltr\"><a name=\"GUID-959DDEDA-0FB5-4C93-8685-970CC0364498\"></a><div class=\"head\">\n            <h1>Developing with the VDF</h1>\n         </div>\n         <p class=\"blurb\">This section is intended to aid developers who are using the Vault SDK and wish to\n            leverage the workflows and utilities provided by the VDF in their own applications.\n            \n         </p>\n         <p><a name=\"GUID-0E804E09-A3E2-4A8A-A54F-B39D1766AC8E\"></a> Below is an overview of how the VDF is organized which will aid developers when searching\n            through the SDK documentation (included in the SDK installer) for classes and methods.\n            \n         </p>\n         <div class=\"section\"><a name=\"SECTION_008026107BB64FE1A346C8DD57D7E196\"></a> \n            <h2><a name=\"GUID-DDDA84B9-A692-4945-92E7-5B539F25DA84\"></a>How the VDF is Organized\n            </h2> \n            <p><a name=\"GUID-253579D7-16D7-4EBB-B4FA-BB33935755E6\"></a> The VDF is a new part of the SDK and it isn\'t a flat collection of web service API\n               methods like previous versions of the SDK, so it is worth understanding how the VDF\n               is organized. Currently, the VDF consists of four DLLs with the prefix Autodesk.DataManagement.Client.Framework\n               on their names and the namespaces defined within them. Here\'s the list: <a name=\"UL_DABA9CE40A8F4AA6B02A02E942CF127D\"></a><ul>\n                  <li> Autodesk.DataManagement.Client.Framework.dll </li>\n                  <li> Autodesk.DataManagement.Client.Framework.Forms.dll </li>\n                  <li> Autodesk.DataManagement.Client.Framework.Vault.dll </li>\n                  <li> Autodesk.DataManagement.Client.Framework.Vault.Forms.dll </li>\n               </ul> \n            </p> \n            <p><a name=\"GUID-D68F6EC0-1509-4705-B732-DA5C2C792E4D\"></a> As a shorthand, the Autodesk…Framework prefix is often replaced simply with the string\n               \"VDF.\" For example, the Autodesk.DataManagement.Client.Framework.Vault namespace would\n               simply be referred to as VDF.Vault to save keystrokes. As you can might notice, there\n               are some similarities between different pairs of the DLLs. Two of them contain \"Vault\"\n               in their name, while a different two contain \"Forms\" in their name. \n            </p> \n            <p><a name=\"GUID-ED8C9E04-F216-4368-BA07-B8D78E4D40FC\"></a> The DLLs (and the namespaces they contain) that have \"Vault\" in their name have components\n               that are specific to working with Vault concepts such as Vault related currency and\n               services for talking to a Vault server. The DLLs without \"Vault\" in their names have\n               more general purpose utilities such as services for managing generic persisted preferences\n               and components useful for displaying prompts to users. The \"Forms\" DLLs contain WinForms\n               components and workflows that will often display GUI to users while the DLLs without\n               \"Forms\" in their names don\'t contain any GUI components. Often times, there are two\n               versions of the a given workflow provided by the VDF, a GUI version and a non-GUI\n               version. GUI versions of a workflow will reside within a \"Forms\" namespace. Any client\n               applications that don\'t require GUI don\'t need to deploy the VDF Forms DLLs. \n            </p> \n            <p><a name=\"GUID-C3DB80C1-E7F9-4A5E-ABDD-BAC3F4DB58E6\"></a> Most of the functionality provided by the VDF is accessed via one of two entry points:\n               static Library classes in each DLL or through services off the VDF Connection class.\n               The static Library classes reside in the namespace matching the name of each DLL,\n               i.e. the VDF.Vault.dll will have a VDF.Vault.Library class with static methods and\n               services to be used by client applications. The Library classes mostly provide access\n               to GUI workflows (if within a \"Forms\" namespace) or workflows and services that don\'t\n               require a VDF connection. The other entry point, a VDF Connection object (of the VDF.Vault.Currency.Connection.Connection\n               class), requires the client application to connect to a Vault server to obtain a connection.\n               The Connection object has several services that interact with a Vault server, such\n               as the FileManager for downloading file or the WorkingFolder. For those familiar with\n               the 2013 Vault SDK, it also provides access to a WebServiceManager if clients need\n               to make any web service API calls directly. \n            </p> \n         </div><span class=\"noindex\">\n            <div class=\"topic-list\">\n               <h4 class=\"related\">Topics in this section</h4>\n               <ul class=\"jumplist\">\n                  <li class=\"topiclist-litem\"><a href=\"GUID-1F046EC1-2DB3-419A-89B0-2AAD7FF6AE43.htm\">Enable VDF Functionality</a><p>When using the VDF, there are some settings that you must provide to enable full functionality.\n                        \n                     </p>\n                  </li>\n                  <li class=\"topiclist-litem\"><a href=\"GUID-5FE06775-9EF2-4FFA-9945-AB6D853966FD.htm\">Connecting to a Vault</a><p>The VDF connection is one of the key access points to the services provided by the\n                        VDF. \n                     </p>\n                  </li>\n                  <li class=\"topiclist-litem\"><a href=\"GUID-C711E51B-B069-4A80-8611-0A6FC8B5FA13.htm\">Downloading Files with the VDF</a><p> One of the workflows provided by the VDF is downloading a file. When downloading\n                        a file from Vault, there are usually several other steps involved besides just pulling\n                        down the bits from the Vault server. \n                     </p>\n                  </li>\n                  <li class=\"topiclist-litem\"><a href=\"GUID-67E7D386-9361-4CA0-B878-E1B337A89AB6.htm\">Working with VDF Currency</a><p> The VDF DLLs use a set of currency classes that live in the VDF.Vault.Currency namespace,\n                        while the web services API still uses the currency classes in the Autodesk.Connectivity.WebServices\n                        namespace. \n                     </p>\n                  </li>\n               </ul>\n            </div></span><div class=\"footer-block\"><a href=\"..\" class=\"comments-anchor\" target=\"_blank\"><span class=\"comments-link\">Please send us your comment about this page</span></a></div><br><p class=\"footer-license-block\"><a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\"><img alt=\"Creative Commons License\" style=\"border-width: 0;\" src=\"../images/ccLink.png\"></a>&nbsp;<em>Except where otherwise noted, this work is licensed under a <a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\">Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License</a>. Please see the <a href=\"http://autodesk.com/creativecommons\" target=\"_blank\">Autodesk Creative Commons FAQ</a> for more information.</em></p><br></div>\n   </body>\n</html>";
// SIG // Begin signature block
// SIG // MIIbRQYJKoZIhvcNAQcCoIIbNjCCGzICAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // n7JV0kqblgSalGQjZd/HfBrIKNCHpVBaPrZku7CFxDmg
// SIG // ggoaMIIEyzCCA7OgAwIBAgIQCQja65wGHi65un4mqmKH
// SIG // ijANBgkqhkiG9w0BAQsFADCBhDELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTUw
// SIG // MwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
// SIG // b2RlIFNpZ25pbmcgQ0EgLSBHMjAeFw0xOTA1MTQwMDAw
// SIG // MDBaFw0yMDA1MTMyMzU5NTlaMHwxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIDApDYWxpZm9ybmlhMRMwEQYDVQQHDApT
// SIG // YW4gUmFmYWVsMRcwFQYDVQQKDA5BdXRvZGVzaywgSW5j
// SIG // LjERMA8GA1UECwwIU2VjdXJpdHkxFzAVBgNVBAMMDkF1
// SIG // dG9kZXNrLCBJbmMuMIIBIjANBgkqhkiG9w0BAQEFAAOC
// SIG // AQ8AMIIBCgKCAQEAkVKRoPYsoxPdlabspcuG8HYDfcWQ
// SIG // 9qyPOT2punwpVdjt2slktcpSTlydrGy8ijcbl5/k8AOJ
// SIG // afKMQvow0fNjIoNB5nsb8j2xFJPbBhHl8GT4P6DZ1OWK
// SIG // ioiUXgGHKjctUws49J4elntqvBYhKCbuPqG772QCoYFU
// SIG // P7qcFbh3PbyNB6cnKMn2vNGRqiEtV2aGg+/MiL3QPsvT
// SIG // kTWhVuTLIvwZ4kK5C5ACiQzlGOlE+C7gWuFoxtvy6gUa
// SIG // A8JAq/xLjYKwFevQwGncg3s1cuiGhx0P7Rvn6oCd2cem
// SIG // FmbK3I3rMRt+jc9wzAj3oHxvCo4f5Lfva+OpC1dETUVV
// SIG // sk0VGwIDAQABo4IBPjCCATowCQYDVR0TBAIwADAOBgNV
// SIG // HQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMw
// SIG // YQYDVR0gBFowWDBWBgZngQwBBAEwTDAjBggrBgEFBQcC
// SIG // ARYXaHR0cHM6Ly9kLnN5bWNiLmNvbS9jcHMwJQYIKwYB
// SIG // BQUHAgIwGQwXaHR0cHM6Ly9kLnN5bWNiLmNvbS9ycGEw
// SIG // HwYDVR0jBBgwFoAU1MAGIknrOUvdk+JcobhHdglyA1gw
// SIG // KwYDVR0fBCQwIjAgoB6gHIYaaHR0cDovL3JiLnN5bWNi
// SIG // LmNvbS9yYi5jcmwwVwYIKwYBBQUHAQEESzBJMB8GCCsG
// SIG // AQUFBzABhhNodHRwOi8vcmIuc3ltY2QuY29tMCYGCCsG
// SIG // AQUFBzAChhpodHRwOi8vcmIuc3ltY2IuY29tL3JiLmNy
// SIG // dDANBgkqhkiG9w0BAQsFAAOCAQEA0Q2+iVSEfT4xGq3A
// SIG // OADVb0rT5Z8E+PPb1x6hKknSzuaZKk/acDz9mdnFajaU
// SIG // WgIKiFJlsqJnuAM1w4lqKaEWsz3DoxvGIEwexj71Ud6a
// SIG // KlBJNcR9DdkXUZwMhbw9d78rjJAIX6tOwfSludZfdq8b
// SIG // YEkuIzQi9uYW9vHVPSCzhnUBKjwc9qTo9yBc7Fcn4FAT
// SIG // 90DzWM2hS9oc3p0pprYI2I/O4th90BEmwWkVqVgfaR0z
// SIG // VyIEmBbqB/IWLfjUBZJ/8sbkwWuWlYVRrfPxsj1e9qvb
// SIG // wE3Y28jWyGbqoUG39GhXk3uT8R8i3+T6M0c4rMfdifBC
// SIG // pceCaFTJzSye7LoeVzCCBUcwggQvoAMCAQICEHwbNTVK
// SIG // 59t050FfEWnKa6gwDQYJKoZIhvcNAQELBQAwgb0xCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjEfMB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29y
// SIG // azE6MDgGA1UECxMxKGMpIDIwMDggVmVyaVNpZ24sIElu
// SIG // Yy4gLSBGb3IgYXV0aG9yaXplZCB1c2Ugb25seTE4MDYG
// SIG // A1UEAxMvVmVyaVNpZ24gVW5pdmVyc2FsIFJvb3QgQ2Vy
// SIG // dGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMTQwNzIyMDAw
// SIG // MDAwWhcNMjQwNzIxMjM1OTU5WjCBhDELMAkGA1UEBhMC
// SIG // VVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9u
// SIG // MR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3Jr
// SIG // MTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1
// SIG // NiBDb2RlIFNpZ25pbmcgQ0EgLSBHMjCCASIwDQYJKoZI
// SIG // hvcNAQEBBQADggEPADCCAQoCggEBANeVQ9Tc32euOftS
// SIG // pLYmMQRw6beOWyq6N2k1lY+7wDDnhthzu9/r0XY/ilaO
// SIG // 6y1L8FcYTrGNpTPTC3Uj1Wp5J92j0/cOh2W13q0c8fU1
// SIG // tCJRryKhwV1LkH/AWU6rnXmpAtceSbE7TYf+wnirv+9S
// SIG // rpyvCNk55ZpRPmlfMBBOcWNsWOHwIDMbD3S+W8sS4duM
// SIG // xICUcrv2RZqewSUL+6McntimCXBx7MBHTI99w94Zzj7u
// SIG // BHKOF9P/8LIFMhlM07Acn/6leCBCcEGwJoxvAMg6ABFB
// SIG // ekGwp4qRBKCZePR3tPNgKuZsUAS3FGD/DVH0qIuE/iHa
// SIG // XF599Sl5T7BEdG9tcv8CAwEAAaOCAXgwggF0MC4GCCsG
// SIG // AQUFBwEBBCIwIDAeBggrBgEFBQcwAYYSaHR0cDovL3Mu
// SIG // c3ltY2QuY29tMBIGA1UdEwEB/wQIMAYBAf8CAQAwZgYD
// SIG // VR0gBF8wXTBbBgtghkgBhvhFAQcXAzBMMCMGCCsGAQUF
// SIG // BwIBFhdodHRwczovL2Quc3ltY2IuY29tL2NwczAlBggr
// SIG // BgEFBQcCAjAZGhdodHRwczovL2Quc3ltY2IuY29tL3Jw
// SIG // YTA2BgNVHR8ELzAtMCugKaAnhiVodHRwOi8vcy5zeW1j
// SIG // Yi5jb20vdW5pdmVyc2FsLXJvb3QuY3JsMBMGA1UdJQQM
// SIG // MAoGCCsGAQUFBwMDMA4GA1UdDwEB/wQEAwIBBjApBgNV
// SIG // HREEIjAgpB4wHDEaMBgGA1UEAxMRU3ltYW50ZWNQS0kt
// SIG // MS03MjQwHQYDVR0OBBYEFNTABiJJ6zlL3ZPiXKG4R3YJ
// SIG // cgNYMB8GA1UdIwQYMBaAFLZ3+mlIR59TEtXC6gcydgfR
// SIG // lwcZMA0GCSqGSIb3DQEBCwUAA4IBAQB/68qn6ot2Qus+
// SIG // jiBUMOO3udz6SD4Wxw9FlRDNJ4ajZvMC7XH4qsJVl5Fw
// SIG // g/lSflJpPMnx4JRGgBi7odSkVqbzHQCR1YbzSIfgy8Q0
// SIG // aCBetMv5Be2cr3BTJ7noPn5RoGlxi9xR7YA6JTKfRK9u
// SIG // QyjTIXW7l9iLi4z+qQRGBIX3FZxLEY3ELBf+1W5/muJW
// SIG // kvGWs60t+fTf2omZzrI4RMD3R3vKJbn6Kmgzm1By3qif
// SIG // 1M0sCzS9izB4QOCNjicbkG8avggVgV3rL+JR51EeyXgp
// SIG // 5x5lvzjvAUoBCSQOFsQUecFBNzTQPZFSlJ3haO8I8OJp
// SIG // nGdukAsak3HUJgLDwFojMYIQgzCCEH8CAQEwgZkwgYQx
// SIG // CzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRlYyBD
// SIG // b3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1
// SIG // c3QgTmV0d29yazE1MDMGA1UEAxMsU3ltYW50ZWMgQ2xh
// SIG // c3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENBIC0gRzIC
// SIG // EAkI2uucBh4uubp+Jqpih4owDQYJYIZIAWUDBAIBBQCg
// SIG // fDAQBgorBgEEAYI3AgEMMQIwADAZBgkqhkiG9w0BCQMx
// SIG // DAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4wDAYK
// SIG // KwYBBAGCNwIBFTAvBgkqhkiG9w0BCQQxIgQg2Hqfi9x0
// SIG // 2zgyv9lU2u4KTcZfa4hWShrM2lZnC0sxnuQwDQYJKoZI
// SIG // hvcNAQEBBQAEggEAWTLSHpiPDfJt5NJUq/lwCGpu7L6S
// SIG // 7eoM3sjsF+gaxmHPZf8Kyj75KEWr9LJa7sLmMEYfVugH
// SIG // lvNXaYMpMPf0qjOZ4oU8IFDto8gFJ+AMOXvwtp0MwapW
// SIG // UjLgB2c+DAQ2M6RQ73i4LVtTfkWNdwhem/YVN3F3vG5E
// SIG // IbRpMfk0V7BCLVZqRMS9iE+Um5Ro4T2LIUofRs1GxvfA
// SIG // IULwf/ZE14Pl/Z9xlfRrZYLns1qtibaNs7IYB4/Auyfn
// SIG // 6kItsmqqP3/h95XNpUk3ys4gNtzqOhU5p6qAdZ72gJyJ
// SIG // e/D3rh0neKFAIfyYrywMptcVzzNcY/5JlngrDemtN1CS
// SIG // 0rs6TqGCDjwwgg44BgorBgEEAYI3AwMBMYIOKDCCDiQG
// SIG // CSqGSIb3DQEHAqCCDhUwgg4RAgEDMQ0wCwYJYIZIAWUD
// SIG // BAIBMIIBDgYLKoZIhvcNAQkQAQSggf4EgfswgfgCAQEG
// SIG // C2CGSAGG+EUBBxcDMDEwDQYJYIZIAWUDBAIBBQAEIO4f
// SIG // zLNi2FJta4Wu8dFHNaaeERnTNFE8cDzUQAd7+1V8AhQ9
// SIG // LqvYeT47o6fXYqI1xub1K73XYxgPMjAyMDAzMjMxNDA1
// SIG // MzBaMAMCAR6ggYakgYMwgYAxCzAJBgNVBAYTAlVTMR0w
// SIG // GwYDVQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlvbjEfMB0G
// SIG // A1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazExMC8G
// SIG // A1UEAxMoU3ltYW50ZWMgU0hBMjU2IFRpbWVTdGFtcGlu
// SIG // ZyBTaWduZXIgLSBHM6CCCoswggU4MIIEIKADAgECAhB7
// SIG // BbHUSWhRRPfJidKcGZ0SMA0GCSqGSIb3DQEBCwUAMIG9
// SIG // MQswCQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24s
// SIG // IEluYy4xHzAdBgNVBAsTFlZlcmlTaWduIFRydXN0IE5l
// SIG // dHdvcmsxOjA4BgNVBAsTMShjKSAyMDA4IFZlcmlTaWdu
// SIG // LCBJbmMuIC0gRm9yIGF1dGhvcml6ZWQgdXNlIG9ubHkx
// SIG // ODA2BgNVBAMTL1ZlcmlTaWduIFVuaXZlcnNhbCBSb290
// SIG // IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTE2MDEx
// SIG // MjAwMDAwMFoXDTMxMDExMTIzNTk1OVowdzELMAkGA1UE
// SIG // BhMCVVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0
// SIG // aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3
// SIG // b3JrMSgwJgYDVQQDEx9TeW1hbnRlYyBTSEEyNTYgVGlt
// SIG // ZVN0YW1waW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOC
// SIG // AQ8AMIIBCgKCAQEAu1mdWVVPnYxyXRqBoutV87ABrTxx
// SIG // rDKPBWuGmicAMpdqTclkFEspu8LZKbku7GOz4c8/C1aQ
// SIG // +GIbfuumB+Lef15tQDjUkQbnQXx5HMvLrRu/2JWR8/Du
// SIG // bPitljkuf8EnuHg5xYSl7e2vh47Ojcdt6tKYtTofHjmd
// SIG // w/SaqPSE4cTRfHHGBim0P+SDDSbDewg+TfkKtzNJ/8o7
// SIG // 1PWym0vhiJka9cDpMxTW38eA25Hu/rySV3J39M2ozP4J
// SIG // 9ZM3vpWIasXc9LFL1M7oCZFftYR5NYp4rBkyjyPBMkEb
// SIG // WQ6pPrHM+dYr77fY5NUdbRE6kvaTyZzjSO67Uw7UNpeG
// SIG // eMWhNwIDAQABo4IBdzCCAXMwDgYDVR0PAQH/BAQDAgEG
// SIG // MBIGA1UdEwEB/wQIMAYBAf8CAQAwZgYDVR0gBF8wXTBb
// SIG // BgtghkgBhvhFAQcXAzBMMCMGCCsGAQUFBwIBFhdodHRw
// SIG // czovL2Quc3ltY2IuY29tL2NwczAlBggrBgEFBQcCAjAZ
// SIG // GhdodHRwczovL2Quc3ltY2IuY29tL3JwYTAuBggrBgEF
// SIG // BQcBAQQiMCAwHgYIKwYBBQUHMAGGEmh0dHA6Ly9zLnN5
// SIG // bWNkLmNvbTA2BgNVHR8ELzAtMCugKaAnhiVodHRwOi8v
// SIG // cy5zeW1jYi5jb20vdW5pdmVyc2FsLXJvb3QuY3JsMBMG
// SIG // A1UdJQQMMAoGCCsGAQUFBwMIMCgGA1UdEQQhMB+kHTAb
// SIG // MRkwFwYDVQQDExBUaW1lU3RhbXAtMjA0OC0zMB0GA1Ud
// SIG // DgQWBBSvY9bKo06FcuCnvEHzKaI4f4B1YjAfBgNVHSME
// SIG // GDAWgBS2d/ppSEefUxLVwuoHMnYH0ZcHGTANBgkqhkiG
// SIG // 9w0BAQsFAAOCAQEAdeqwLdU0GVwyRf4O4dRPpnjBb9fq
// SIG // 3dxP86HIgYj3p48V5kApreZd9KLZVmSEcTAq3R5hF2Yg
// SIG // VgaYGY1dcfL4l7wJ/RyRR8ni6I0D+8yQL9YKbE4z7Na0
// SIG // k8hMkGNIOUAhxN3WbomYPLWYl+ipBrcJyY9TV0GQL+Ee
// SIG // TU7cyhB4bEJu8LbF+GFcUvVO9muN90p6vvPN/QPX2fYD
// SIG // qA/jU/cKdezGdS6qZoUEmbf4Blfhxg726K/a7JsYH6q5
// SIG // 4zoAv86KlMsB257HOLsPUqvR45QDYApNoP4nbRQy/D+X
// SIG // QOG/mYnb5DkUvdrk08PqK1qzlVhVBH3HmuwjA42FKtL/
// SIG // rqlhgTCCBUswggQzoAMCAQICEHvU5a+6zAc/oQEjBCJB
// SIG // TRIwDQYJKoZIhvcNAQELBQAwdzELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMSgw
// SIG // JgYDVQQDEx9TeW1hbnRlYyBTSEEyNTYgVGltZVN0YW1w
// SIG // aW5nIENBMB4XDTE3MTIyMzAwMDAwMFoXDTI5MDMyMjIz
// SIG // NTk1OVowgYAxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRT
// SIG // eW1hbnRlYyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3lt
// SIG // YW50ZWMgVHJ1c3QgTmV0d29yazExMC8GA1UEAxMoU3lt
// SIG // YW50ZWMgU0hBMjU2IFRpbWVTdGFtcGluZyBTaWduZXIg
// SIG // LSBHMzCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoC
// SIG // ggEBAK8Oiqr43L9pe1QXcUcJvY08gfh0FXdnkJz93k4C
// SIG // nkt29uU2PmXVJCBtMPndHYPpPydKM05tForkjUCNIqq+
// SIG // pwsb0ge2PLUaJCj4G3JRPcgJiCYIOvn6QyN1R3AMs19b
// SIG // jwgdckhXZU2vAjxA9/TdMjiTP+UspvNZI8uA3hNN+RDJ
// SIG // qgoYbFVhV9HxAizEtavybCPSnw0PGWythWJp/U6FwYpS
// SIG // Matb2Ml0UuNXbCK/VX9vygarP0q3InZl7Ow28paVgSYs
// SIG // /buYqgE4068lQJsJU/ApV4VYXuqFSEEhh+XetNMmsntA
// SIG // U1h5jlIxBk2UA0XEzjwD7LcA8joixbRv5e+wipsCAwEA
// SIG // AaOCAccwggHDMAwGA1UdEwEB/wQCMAAwZgYDVR0gBF8w
// SIG // XTBbBgtghkgBhvhFAQcXAzBMMCMGCCsGAQUFBwIBFhdo
// SIG // dHRwczovL2Quc3ltY2IuY29tL2NwczAlBggrBgEFBQcC
// SIG // AjAZGhdodHRwczovL2Quc3ltY2IuY29tL3JwYTBABgNV
// SIG // HR8EOTA3MDWgM6Axhi9odHRwOi8vdHMtY3JsLndzLnN5
// SIG // bWFudGVjLmNvbS9zaGEyNTYtdHNzLWNhLmNybDAWBgNV
// SIG // HSUBAf8EDDAKBggrBgEFBQcDCDAOBgNVHQ8BAf8EBAMC
// SIG // B4AwdwYIKwYBBQUHAQEEazBpMCoGCCsGAQUFBzABhh5o
// SIG // dHRwOi8vdHMtb2NzcC53cy5zeW1hbnRlYy5jb20wOwYI
// SIG // KwYBBQUHMAKGL2h0dHA6Ly90cy1haWEud3Muc3ltYW50
// SIG // ZWMuY29tL3NoYTI1Ni10c3MtY2EuY2VyMCgGA1UdEQQh
// SIG // MB+kHTAbMRkwFwYDVQQDExBUaW1lU3RhbXAtMjA0OC02
// SIG // MB0GA1UdDgQWBBSlEwGpn4XMG24WHl87Map5NgB7HTAf
// SIG // BgNVHSMEGDAWgBSvY9bKo06FcuCnvEHzKaI4f4B1YjAN
// SIG // BgkqhkiG9w0BAQsFAAOCAQEARp6v8LiiX6KZSM+oJ0sh
// SIG // zbK5pnJwYy/jVSl7OUZO535lBliLvFeKkg0I2BC6NiT6
// SIG // Cnv7O9Niv0qUFeaC24pUbf8o/mfPcT/mMwnZolkQ9B5K
// SIG // /mXM3tRr41IpdQBKK6XMy5voqU33tBdZkkHDtz+G5vbA
// SIG // f0Q8RlwXWuOkO9VpJtUhfeGAZ35irLdOLhWa5Zwjr1sR
// SIG // 6nGpQfkNeTipoQ3PtLHaPpp6xyLFdM3fRwmGxPyRJbIb
// SIG // lumFCOjd6nRgbmClVnoNyERY3Ob5SBSe5b/eAL13sZgU
// SIG // chQk38cRLB8AP8NLFMZnHMweBqOQX1xUiz7jM1uCD8W3
// SIG // hgJOcZ/pZkU/djGCAlowggJWAgEBMIGLMHcxCzAJBgNV
// SIG // BAYTAlVTMR0wGwYDVQQKExRTeW1hbnRlYyBDb3Jwb3Jh
// SIG // dGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0
// SIG // d29yazEoMCYGA1UEAxMfU3ltYW50ZWMgU0hBMjU2IFRp
// SIG // bWVTdGFtcGluZyBDQQIQe9Tlr7rMBz+hASMEIkFNEjAL
// SIG // BglghkgBZQMEAgGggaQwGgYJKoZIhvcNAQkDMQ0GCyqG
// SIG // SIb3DQEJEAEEMBwGCSqGSIb3DQEJBTEPFw0yMDAzMjMx
// SIG // NDA1MzBaMC8GCSqGSIb3DQEJBDEiBCBapUxsZ1wr4Ou7
// SIG // xsPDU1mtwM+oQigo4IhNYPmGyOnRjjA3BgsqhkiG9w0B
// SIG // CRACLzEoMCYwJDAiBCDEdM52AH0COU4NpeTefBTGgPni
// SIG // ggE8/vZT7123H99h+DALBgkqhkiG9w0BAQEEggEAj/zA
// SIG // OZp1QpWsAOFMCuBnWlbZfcEZynggz8lzRvlrBx5PVU4v
// SIG // Ig5XJgjdLwTKmHfGbDnoPVOcK5cNMRX+YrQWRlrYnOoS
// SIG // WBpPtzgZWkfIBSYzVFh4Sfkk0ahT3OGox9iU6LmGBd/g
// SIG // mJKcR+iqzM/wzlMD6IqoBfTk1So/oXkTuN3zXoU65Bkg
// SIG // SEZQ6cocLEiKkywuBHZdHf0imWLXSFAd/ZLzlSYwsHHn
// SIG // nRfKm499dmqeMvXHAlMKbfC9HQLMvU2CS3YukBTdAqNy
// SIG // ytLIEqpnqOsaecSsNA6RnwUKS1/vWeygzPmjyZoeCvum
// SIG // TNg5HYUq1So3pL6Gb8Cuz0Ors5IAEA==
// SIG // End signature block
