var topic = "<!DOCTYPE html>\r\n\n<!-- saved from url=(0024)http://docs.autodesk.com -->\r\n<html>\n   <head>\n      <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n      <meta name=\"product\" content=\"VAULT\">\n      <meta name=\"release\" content=\"2021\">\n      <meta name=\"book\" content=\"GeneralUser\">\n      <meta name=\"created\" content=\"2020-03-20\">\n      <meta name=\"topicid\" content=\"GUID-92E898FB-638A-4D00-AF9B-08C74F878987\">\n      <meta name=\"description\" content=\"PowerShell functions are used to programmatically customize business logic, behavior, default values, and the user interface.\">\n      <meta name=\"topic-type\" content=\"concept\">\n      <meta name=\"audience\" content=\"programmer\">\n      <meta name=\"experiencelevel\" content=\"general\">\n      <title>PowerShell Functions for Data Standard</title><script language=\"javascript\">var index = \'index.html\';</script><script type=\"text/javascript\" src=\"../scripts/prettify/prettify.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-yaml.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-xq.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-wiki.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-vhdl.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-vb.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-tex.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-sql.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-scala.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-proto.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-n.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-ml.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-lua.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-lisp.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-hs.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-go.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-css.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-clj.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-apollo.js\"></script></head>\n   <body height=\"100%\" onLoad=\"javascript:prettyPrint();\">\n      <div class=\"body_content\" id=\"body-content\" dir=\"ltr\"><a name=\"GUID-92E898FB-638A-4D00-AF9B-08C74F878987\"></a><div class=\"head\">\n            <h1>PowerShell Functions for Data Standard</h1>\n         </div>\n         <p class=\"blurb\"> PowerShell functions are used to programmatically customize business logic, behavior,\n            default values, and the user interface. \n            \n         </p>\n         <p> Data Standard comes with several functions that are required to work with the standard\n            dialogs and tabs. Some functions are called from inside the Data Standard Add-Ins.\n            \n            	 \n         </p>\n         <p><em class=\"strong\">These functions are mandatory and should not be removed.</em> \n         </p>\n         <p>The functions can be regarded as event driven functions and can be modified to change\n            the behavior. Other functions are called directly from the XAML file. For example,\n            to retrieve information from the Vault database (e.g., available numbering schemes,\n            categories). \n            	 \n         </p>\n         <p> All *.ps1 and *.psm1(PowerShell module) files that are located in the \"addinVault\"\n            (Vault) or \"addins\" (CAD) folders are automatically imported and used. \n            	 \n         </p>\n         <div><a name=\"GUID-7A810EB3-3F8B-4DD7-8CF6-B4D990349461\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span> Autodesk recommends using a separate .ps1 file for your own functions. \n               	 \n            </div>\n         </div>\n         <p>The following chart contains a list of the functions that are directly called either\n            from an Add-In or from a XAML file. For better readability of the code, these functions\n            may call other functions. These other functions, are not explicitly listed. \n            	 \n         </p><a name=\"TABLE_6F1D974B69A748FFB26F410D05A05BB1\"></a><div class=\"table-not-ruled\">\n            <table cellpadding=\"0\" cellspacing=\"0\" class=\"not-ruled\">\n               <colgroup>\n                  <col>\n                  <col>\n                  <col>\n                  <col>\n                  <col>\n               </colgroup>\n               <tr class=\"not-ruled-heading\">\n                  <th class=\"table-heading\"> \n                     <p class=\"table-heading\">Function \n                        				  \n                     </p> \n                  </th>\n                  <th class=\"table-heading\"> \n                     <p class=\"table-heading\">File \n                        				  \n                     </p> \n                  </th>\n                  <th class=\"table-heading\"> \n                     <p class=\"table-heading\">Usage Add-in \n                        				  \n                     </p> \n                  </th>\n                  <th class=\"table-heading\"> \n                     <p class=\"table-heading\">Usage XAML \n                        				  \n                     </p> \n                  </th>\n                  <th class=\"table-heading\"> \n                     <p class=\"table-heading\">Description \n                        				  \n                     </p> \n                  </th>\n               </tr>\n               <tr class=\"not-ruled-odd-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"code\">ActivateOKButton</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">Vault: \n                        					 <span class=\"filePath\">Default.ps1</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">Vault \n                        				  \n                     </p> \n                  </td>\n                  <td class=\"table-body\">&nbsp; </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"> Used for validation and enabling the OK button in edit and create dialogs. By default\n                        it calls the function \n                        					 <span class=\"code\">Validate()</span> which then, based on the window type, calls further validation functions. \n                        				  \n                     </p> \n                     <p class=\"table-body\"> Because \n                        					 <span class=\"code\">ActivateOkButton \n                           					 </span>is called every time data is changed on the dialog, this can cause performance problems\n                        if the validation functions are too complex. \n                        				  \n                     </p> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-even-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"code\">AddinLoaded</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">CAD: \n                        					 <span class=\"filePath\">Default.ps1</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">CAD \n                        				  \n                     </p> \n                  </td>\n                  <td class=\"table-body\">&nbsp; \n                     <p class=\"table-body\"> </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"> Called when the VDS Inventor- or AutoCAD-Addin is loaded. \n                        				  \n                     </p> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-odd-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"code\">Addinunloaded</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">CAD: \n                        					 <span class=\"filePath\">Default.ps1</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">CAD \n                        				  \n                     </p> \n                  </td>\n                  <td class=\"table-body\">&nbsp; \n                     <p class=\"table-body\"> </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"> Called when the VDS Inventor- or AutoCAD-Addin is unloaded. \n                        				  \n                     </p> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-even-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"code\">GetCategories</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">Vault, \n                        				  \n                     </p> \n                     <p class=\"table-body\">CAD: \n                        					 <span class=\"filePath\">Default.ps1</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\">&nbsp; \n                     <p class=\"table-body\"> </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">Vault, CAD \n                        				  \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"> This function is used in the create dialogs for Vault and CAD to show categories\n                        in a combo box. \n                        				  \n                     </p> \n                     <p class=\"table-body\">The default implementation returns a list of all file, folder, or custom entity categories\n                        based on the window name. Used for \n                        					 <span class=\"char_link\"><a href=\"GUID-32319A9D-ADBD-429E-A41D-FEC2511F9798.htm\">Dynamic Properties</a></span>. For CAD edit dialogs, the assigned category is returned. \n                        				  \n                     </p> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-odd-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"code\">GetNewCustomObjectName</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">Vault: \n                        					 <span class=\"filePath\">Default.ps1</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">Vault \n                        				  \n                     </p> \n                  </td>\n                  <td class=\"table-body\">&nbsp; \n                     <p class=\"table-body\"> </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"> Called when clicking the OK button in a create custom object dialog. This function\n                        returns the name of the new custom object. The default implementation either gets\n                        the value from a create dialog control with the name \n                        					 <span class=\"code\">CUSTOMOBJECTNAME</span> or from a special property _GeneratedNumber if Vault numbering schemes are defined.\n                        See \n                        					 <span class=\"char_link\"><a href=\"GUID-7EF1B4F5-BCE0-439D-B6F0-AF61BF2EFBC2.htm\">Data Standard and Numbering Schemes</a></span> for more information. \n                        				  \n                     </p> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-even-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"code\">GetNewFileName</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">Vault: \n                        					 <span class=\"filePath\">Default.ps1</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">Vault \n                        				  \n                     </p> \n                  </td>\n                  <td class=\"table-body\">&nbsp; \n                     <p class=\"table-body\"> </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"> Called when clicking the OK button in a create file dialog. This function returns\n                        the filename of the new file. The default implementation either gets the value from\n                        a create dialog control with the name \n                        					 <span class=\"code\">FILENAME</span> or from a special property \n                        					 <span class=\"code\">_GeneratedNumber</span> if Vault numbering schemes are defined. See \n                        					 <span class=\"char_link\"><a href=\"GUID-7EF1B4F5-BCE0-439D-B6F0-AF61BF2EFBC2.htm\">Data Standard and Numbering Schemes</a></span> for more information. \n                        				  \n                     </p> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-odd-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"code\">GetNewFolderName</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">Vault: \n                        					 <span class=\"filePath\">Default.ps1</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">Vault \n                        				  \n                     </p> \n                  </td>\n                  <td class=\"table-body\">&nbsp; \n                     <p class=\"table-body\"> </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"> Called when clicking the OK button in a create folder dialog. This function returns\n                        the name of the new folder. The default implementation either gets the value from\n                        a create dialog control with the name \n                        					 <span class=\"code\">FOLDERNAME</span> or from a special property _GeneratedNumber if Vault numbering schemes are defined.\n                        See \n                        					 <span class=\"char_link\"><a href=\"GUID-7EF1B4F5-BCE0-439D-B6F0-AF61BF2EFBC2.htm\">Data Standard and Numbering Schemes</a></span> for more information.\n                        				  \n                     </p> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-even-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"code\">GetNumSchms</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">Vault, \n                        				  \n                     </p> \n                     <p class=\"table-body\">CAD: \n                        					 <span class=\"filePath\">Default.ps1</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\">&nbsp; \n                     <p class=\"table-body\"> </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">Vault, CAD \n                        				  \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"> This function is used in file create dialogs for Vault and CAD to show numbering\n                        schemes in a combo box. The default implementation returns all activated Vault file\n                        numbering schemes. The default numbering scheme is a scheme with the same name as\n                        the selected category. If a scheme does not exist with the same name as the selected\n                        category, the scheme is the default scheme set in the Vault settings. \n                        				  \n                     </p> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-odd-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"code\">GetParentFolderName</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">Vault: \n                        					 <span class=\"filePath\">Default.ps1</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">Vault \n                        				  \n                     </p> \n                  </td>\n                  <td class=\"table-body\">&nbsp; \n                     <p class=\"table-body\"> </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"> Called when clicking the OK button in a create folder dialog. This function can be\n                        used to force a specific folder name when using New Standard File or New Standard\n                        Folder functions. If an empty string is returned the selected folder is used. \n                        				  \n                     </p> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-even-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"code\"><span class=\"char_link\"><a href=\"GUID-1700C1D0-121D-4953-A35D-E5F10224A31F.htm\">InitializeTabWindow</a></span></span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">Vault: \n                        					 <span class=\"filePath\">Default.ps1 \n                           					 </span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">Vault \n                        				  \n                     </p> \n                  </td>\n                  <td class=\"table-body\">&nbsp; \n                     <p class=\"table-body\"> </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"> Called when initializing Data Standard tabs in Vault. \n                        				  \n                     </p> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-odd-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"code\"><span class=\"char_link\"><a href=\"GUID-C43FD315-3B77-4F23-AE46-0CB69ED9FD5D.htm\">InitializeWindow</a></span></span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">Vault: \n                        					 <span class=\"filePath\">Default.ps1 \n                           					 </span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">Vault \n                        				  \n                     </p> \n                  </td>\n                  <td class=\"table-body\">&nbsp; \n                     <p class=\"table-body\"> </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"> Called when initializing Data Standard dialogs. \n                        				  \n                     </p> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-even-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"code\">ItemTitle</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">Vault: \n                        					 <span class=\"filePath\">Default.ps1 \n                           					 </span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\">&nbsp; \n                     <p class=\"table-body\"> </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">Vault \n                        				  \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"> Used in tabs for Item and ECO objects. The default implementation returns the value\n                        of the item or ECO \"Title (item,CO)\" property. \n                        				  \n                     </p> \n                     <div><a name=\"GUID-DC4C5F35-BDCA-4E54-84E6-5F0D4AE196A7\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span> <span class=\"code\">{Binding Prop[_XLTN_TITLE_ITEM_CO]} \n                              					 </span> cannot be used directly in the XAML because of the property name. \n                           				  \n                        </div>\n                     </div> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-odd-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"code\">ItemDescription</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">Vault: \n                        					 <span class=\"filePath\">Default.ps1 \n                           					 </span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\">&nbsp; \n                     <p class=\"table-body\"> </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">Vault \n                        				  \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"> Used in tabs for Item and ECO objects. The default implementation returns the value\n                        of the item or ECO \"Description (item,CO)\" property. \n                        				  \n                     </p> \n                     <div><a name=\"GUID-2B287536-A4CB-4330-AF7D-6D74F8565863\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span> <span class=\"code\">{Binding Prop[_XLTN_DESCRIPTION_ITEM_CO]}</span> cannot be used directly in the XAML because of the property name. \n                           				  \n                        </div>\n                     </div> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-even-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"code\">OnLogOn</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">Vault: \n                        					 <span class=\"filePath\">Default.ps1 \n                           					 </span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">Vault \n                        				  \n                     </p> \n                  </td>\n                  <td class=\"table-body\">&nbsp; \n                     <p class=\"table-body\"> </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">Called when a user logs into a vault. \n                        				  \n                     </p> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-odd-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"code\">OnLogOff</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">Vault: \n                        					 <span class=\"filePath\">Default.ps1 \n                           					 </span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\">&nbsp; \n                     <p class=\"table-body\"> </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">Vault \n                        				  \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">Called when the user logs off. \n                        				  \n                     </p> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-even-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"code\"><span class=\"char_link\"><a href=\"GUID-53FA4FB8-AF7E-4A9C-88BB-7ECF62E40D45.htm\">OnPostCloseDialog</a></span></span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">CAD: \n                        					 <span class=\"filePath\">Default.ps1 \n                           					 </span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">CAD \n                        				  \n                     </p> \n                  </td>\n                  <td class=\"table-body\">&nbsp; \n                     <p class=\"table-body\"> </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"> Called when the Data Standard dialogs is closed by clicking the OK button, and before\n                        the filename is set the properties are updated. \n                        				  \n                     </p> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-odd-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"code\"><span class=\"char_link\"><a href=\"GUID-E65985D4-2F09-4BB9-B91C-3DDBAE47A39A.htm\">OnTabContextChanged</a></span></span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">Vault: \n                        					 <span class=\"filePath\">Default.ps1 \n                           					 </span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">Vault \n                        				  \n                     </p> \n                  </td>\n                  <td class=\"table-body\">&nbsp; \n                     <p class=\"table-body\"> </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"> Called when the context of a custom tab in Vault changes. Is used to update the data\n                        that is shown in the tab. \n                        				  \n                     </p> \n                  </td>\n               </tr>\n               <tr class=\"not-ruled-even-row\">\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\"><span class=\"code\">SetWindowTitle($newFile, $editFile, $name)</span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">Vault, CAD: \n                        					 <span class=\"filePath\">Default.ps1 \n                           					 </span> \n                     </p> \n                  </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">Vault, CAD\n                        				  \n                     </p> \n                  </td>\n                  <td class=\"table-body\">&nbsp; </td>\n                  <td class=\"table-body\"> \n                     <p class=\"table-body\">Called from InitializeWindow function. This function is fed with inputs depending\n                        on CreateMode or EditMode as well as whether it is for File, Folder or CustomObject.\n                        The output that is returned is set as the title of the Dialog.\n                        				  \n                     </p> \n                  </td>\n               </tr>\n            </table>\n         </div>\n         <div><a name=\"GUID-7B4F5181-BAAD-445F-B24A-164DD986D886\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span>The ps1-files for the menu items, located in \n               		<span class=\"filePath\">C:\\ProgramData\\Autodesk\\&lt;Vault version&gt;\\Extensions\\DataStandard\\Vault\\addinVault\\Menus</span>, contain code which is not in the scope of a PowerShell function. This code is executed\n               directly when the menu item is clicked. \n               	 \n            </div>\n         </div><span class=\"noindex\">\n            <div class=\"topic-list\">\n               <h4 class=\"related\">Topics in this section</h4>\n               <ul class=\"jumplist\">\n                  <li class=\"topiclist-litem\"><a href=\"GUID-1700C1D0-121D-4953-A35D-E5F10224A31F.htm\">InitializeTabWindow Function for Data Standard</a><p>The \n                        	 InitializeTabWindow function is executed whenever the context of a custom tab in\n                        Vault changes. The function is used to adjust the content of a custom tab for the\n                        different XAML files.\n                        \n                     </p>\n                  </li>\n                  <li class=\"topiclist-litem\"><a href=\"GUID-C43FD315-3B77-4F23-AE46-0CB69ED9FD5D.htm\">InitializeWindow Function for Data Standard</a><p> The \n                        	 InitializeWindow function is executed before a DataStandard window opens. In this\n                        function, variables can be predefined, events can be subscribed, or the window appearance\n                        can be customized. \n                        \n                     </p>\n                  </li>\n                  <li class=\"topiclist-litem\"><a href=\"GUID-53FA4FB8-AF7E-4A9C-88BB-7ECF62E40D45.htm\">OnPostCloseDialog Function for Data Standard</a><p> For Inventor and AutoCAD, the \n                        	 OnPostCloseDialog function is called when clicking \"OK\" in a dialog, before the\n                        file name is set and the iProperties update. \n                        \n                     </p>\n                  </li>\n                  <li class=\"topiclist-litem\"><a href=\"GUID-E65985D4-2F09-4BB9-B91C-3DDBAE47A39A.htm\">OnTabContextChanged Function for Data Standard</a><p> The \n                        	 OnTabContextChanged is executed whenever the context of a custom tab in Vault changes.\n                        The function is used to adjust the content of a custom tab for the different XAML\n                        files.\n                        \n                     </p>\n                  </li>\n               </ul>\n            </div></span><div class=\"footer-block\"><a href=\"..\" class=\"comments-anchor\" target=\"_blank\"><span class=\"comments-link\">Please send us your comment about this page</span></a></div><br><p class=\"footer-license-block\"><a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\"><img alt=\"Creative Commons License\" style=\"border-width: 0;\" src=\"../images/ccLink.png\"></a>&nbsp;<em>Except where otherwise noted, this work is licensed under a <a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\">Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License</a>. Please see the <a href=\"http://autodesk.com/creativecommons\" target=\"_blank\">Autodesk Creative Commons FAQ</a> for more information.</em></p><br></div>\n   </body>\n</html>";
// SIG // Begin signature block
// SIG // MIIZfQYJKoZIhvcNAQcCoIIZbjCCGWoCAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // PODZPANkPFhGPzoZTNrachlS+zxvXvNaZzSRH/0eX9Sg
// SIG // ggoaMIIEyzCCA7OgAwIBAgIQCQja65wGHi65un4mqmKH
// SIG // ijANBgkqhkiG9w0BAQsFADCBhDELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTUw
// SIG // MwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
// SIG // b2RlIFNpZ25pbmcgQ0EgLSBHMjAeFw0xOTA1MTQwMDAw
// SIG // MDBaFw0yMDA1MTMyMzU5NTlaMHwxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIDApDYWxpZm9ybmlhMRMwEQYDVQQHDApT
// SIG // YW4gUmFmYWVsMRcwFQYDVQQKDA5BdXRvZGVzaywgSW5j
// SIG // LjERMA8GA1UECwwIU2VjdXJpdHkxFzAVBgNVBAMMDkF1
// SIG // dG9kZXNrLCBJbmMuMIIBIjANBgkqhkiG9w0BAQEFAAOC
// SIG // AQ8AMIIBCgKCAQEAkVKRoPYsoxPdlabspcuG8HYDfcWQ
// SIG // 9qyPOT2punwpVdjt2slktcpSTlydrGy8ijcbl5/k8AOJ
// SIG // afKMQvow0fNjIoNB5nsb8j2xFJPbBhHl8GT4P6DZ1OWK
// SIG // ioiUXgGHKjctUws49J4elntqvBYhKCbuPqG772QCoYFU
// SIG // P7qcFbh3PbyNB6cnKMn2vNGRqiEtV2aGg+/MiL3QPsvT
// SIG // kTWhVuTLIvwZ4kK5C5ACiQzlGOlE+C7gWuFoxtvy6gUa
// SIG // A8JAq/xLjYKwFevQwGncg3s1cuiGhx0P7Rvn6oCd2cem
// SIG // FmbK3I3rMRt+jc9wzAj3oHxvCo4f5Lfva+OpC1dETUVV
// SIG // sk0VGwIDAQABo4IBPjCCATowCQYDVR0TBAIwADAOBgNV
// SIG // HQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMw
// SIG // YQYDVR0gBFowWDBWBgZngQwBBAEwTDAjBggrBgEFBQcC
// SIG // ARYXaHR0cHM6Ly9kLnN5bWNiLmNvbS9jcHMwJQYIKwYB
// SIG // BQUHAgIwGQwXaHR0cHM6Ly9kLnN5bWNiLmNvbS9ycGEw
// SIG // HwYDVR0jBBgwFoAU1MAGIknrOUvdk+JcobhHdglyA1gw
// SIG // KwYDVR0fBCQwIjAgoB6gHIYaaHR0cDovL3JiLnN5bWNi
// SIG // LmNvbS9yYi5jcmwwVwYIKwYBBQUHAQEESzBJMB8GCCsG
// SIG // AQUFBzABhhNodHRwOi8vcmIuc3ltY2QuY29tMCYGCCsG
// SIG // AQUFBzAChhpodHRwOi8vcmIuc3ltY2IuY29tL3JiLmNy
// SIG // dDANBgkqhkiG9w0BAQsFAAOCAQEA0Q2+iVSEfT4xGq3A
// SIG // OADVb0rT5Z8E+PPb1x6hKknSzuaZKk/acDz9mdnFajaU
// SIG // WgIKiFJlsqJnuAM1w4lqKaEWsz3DoxvGIEwexj71Ud6a
// SIG // KlBJNcR9DdkXUZwMhbw9d78rjJAIX6tOwfSludZfdq8b
// SIG // YEkuIzQi9uYW9vHVPSCzhnUBKjwc9qTo9yBc7Fcn4FAT
// SIG // 90DzWM2hS9oc3p0pprYI2I/O4th90BEmwWkVqVgfaR0z
// SIG // VyIEmBbqB/IWLfjUBZJ/8sbkwWuWlYVRrfPxsj1e9qvb
// SIG // wE3Y28jWyGbqoUG39GhXk3uT8R8i3+T6M0c4rMfdifBC
// SIG // pceCaFTJzSye7LoeVzCCBUcwggQvoAMCAQICEHwbNTVK
// SIG // 59t050FfEWnKa6gwDQYJKoZIhvcNAQELBQAwgb0xCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjEfMB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29y
// SIG // azE6MDgGA1UECxMxKGMpIDIwMDggVmVyaVNpZ24sIElu
// SIG // Yy4gLSBGb3IgYXV0aG9yaXplZCB1c2Ugb25seTE4MDYG
// SIG // A1UEAxMvVmVyaVNpZ24gVW5pdmVyc2FsIFJvb3QgQ2Vy
// SIG // dGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMTQwNzIyMDAw
// SIG // MDAwWhcNMjQwNzIxMjM1OTU5WjCBhDELMAkGA1UEBhMC
// SIG // VVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9u
// SIG // MR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3Jr
// SIG // MTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1
// SIG // NiBDb2RlIFNpZ25pbmcgQ0EgLSBHMjCCASIwDQYJKoZI
// SIG // hvcNAQEBBQADggEPADCCAQoCggEBANeVQ9Tc32euOftS
// SIG // pLYmMQRw6beOWyq6N2k1lY+7wDDnhthzu9/r0XY/ilaO
// SIG // 6y1L8FcYTrGNpTPTC3Uj1Wp5J92j0/cOh2W13q0c8fU1
// SIG // tCJRryKhwV1LkH/AWU6rnXmpAtceSbE7TYf+wnirv+9S
// SIG // rpyvCNk55ZpRPmlfMBBOcWNsWOHwIDMbD3S+W8sS4duM
// SIG // xICUcrv2RZqewSUL+6McntimCXBx7MBHTI99w94Zzj7u
// SIG // BHKOF9P/8LIFMhlM07Acn/6leCBCcEGwJoxvAMg6ABFB
// SIG // ekGwp4qRBKCZePR3tPNgKuZsUAS3FGD/DVH0qIuE/iHa
// SIG // XF599Sl5T7BEdG9tcv8CAwEAAaOCAXgwggF0MC4GCCsG
// SIG // AQUFBwEBBCIwIDAeBggrBgEFBQcwAYYSaHR0cDovL3Mu
// SIG // c3ltY2QuY29tMBIGA1UdEwEB/wQIMAYBAf8CAQAwZgYD
// SIG // VR0gBF8wXTBbBgtghkgBhvhFAQcXAzBMMCMGCCsGAQUF
// SIG // BwIBFhdodHRwczovL2Quc3ltY2IuY29tL2NwczAlBggr
// SIG // BgEFBQcCAjAZGhdodHRwczovL2Quc3ltY2IuY29tL3Jw
// SIG // YTA2BgNVHR8ELzAtMCugKaAnhiVodHRwOi8vcy5zeW1j
// SIG // Yi5jb20vdW5pdmVyc2FsLXJvb3QuY3JsMBMGA1UdJQQM
// SIG // MAoGCCsGAQUFBwMDMA4GA1UdDwEB/wQEAwIBBjApBgNV
// SIG // HREEIjAgpB4wHDEaMBgGA1UEAxMRU3ltYW50ZWNQS0kt
// SIG // MS03MjQwHQYDVR0OBBYEFNTABiJJ6zlL3ZPiXKG4R3YJ
// SIG // cgNYMB8GA1UdIwQYMBaAFLZ3+mlIR59TEtXC6gcydgfR
// SIG // lwcZMA0GCSqGSIb3DQEBCwUAA4IBAQB/68qn6ot2Qus+
// SIG // jiBUMOO3udz6SD4Wxw9FlRDNJ4ajZvMC7XH4qsJVl5Fw
// SIG // g/lSflJpPMnx4JRGgBi7odSkVqbzHQCR1YbzSIfgy8Q0
// SIG // aCBetMv5Be2cr3BTJ7noPn5RoGlxi9xR7YA6JTKfRK9u
// SIG // QyjTIXW7l9iLi4z+qQRGBIX3FZxLEY3ELBf+1W5/muJW
// SIG // kvGWs60t+fTf2omZzrI4RMD3R3vKJbn6Kmgzm1By3qif
// SIG // 1M0sCzS9izB4QOCNjicbkG8avggVgV3rL+JR51EeyXgp
// SIG // 5x5lvzjvAUoBCSQOFsQUecFBNzTQPZFSlJ3haO8I8OJp
// SIG // nGdukAsak3HUJgLDwFojMYIOuzCCDrcCAQEwgZkwgYQx
// SIG // CzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRlYyBD
// SIG // b3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1
// SIG // c3QgTmV0d29yazE1MDMGA1UEAxMsU3ltYW50ZWMgQ2xh
// SIG // c3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENBIC0gRzIC
// SIG // EAkI2uucBh4uubp+Jqpih4owDQYJYIZIAWUDBAIBBQCg
// SIG // fDAQBgorBgEEAYI3AgEMMQIwADAZBgkqhkiG9w0BCQMx
// SIG // DAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4wDAYK
// SIG // KwYBBAGCNwIBFTAvBgkqhkiG9w0BCQQxIgQgQd/skHHR
// SIG // fJGuFv3VUfktSfvVtnOJgxgFN7jUlCkwkQ0wDQYJKoZI
// SIG // hvcNAQEBBQAEggEAVaB6bMWSCKpp6evkmpIXc3lefh0r
// SIG // roKypVx6igrVT+GZus0jPkyETqDfxj8ZrhP1ax7S/SkC
// SIG // Yp7Lua81cUbRPUvmvn3XEQrl0XsVAgl9ogx+ubJO5oUB
// SIG // 6ecvM1Pfepxrk4LN/WL7kOa6McWRX62wFYdDbwQLp85L
// SIG // 7p49OTFSez7BGtezWStlXxrrzzKOk+oLopHWBEXuRdCV
// SIG // zTPwDm12MQzUQBiUT5Jh8qkv2kLoXLcOcDL2xFpjocSU
// SIG // /sk1+Ua1InI4IR/kBR1acyS74zSPNd0C2n/6W9tkZBhe
// SIG // RQOOpXPFaGmYcSzFGkLGoGJjLYm0cOTWKW5xhHLWPvQ1
// SIG // ms/WGKGCDHQwggxwBgorBgEEAYI3AwMBMYIMYDCCDFwG
// SIG // CSqGSIb3DQEHAqCCDE0wggxJAgEDMQ8wDQYJYIZIAWUD
// SIG // BAIBBQAwga8GCyqGSIb3DQEJEAEEoIGfBIGcMIGZAgEB
// SIG // BgkrBgEEAaAyAgMwMTANBglghkgBZQMEAgEFAAQggGX3
// SIG // Oapo0HfBS0lFbrUnruic52BxYnWFEaQ7sYu2g1ACFHkW
// SIG // 0Eg09pV/KQwB49sfS/U9Yu7DGA8yMDIwMDMyMzE0MDM1
// SIG // N1qgL6QtMCsxKTAnBgNVBAMMIEdsb2JhbFNpZ24gVFNB
// SIG // IGZvciBBZHZhbmNlZCAtIEcyoIII0zCCBLYwggOeoAMC
// SIG // AQICDAynz10HBySsieeaOjANBgkqhkiG9w0BAQsFADBb
// SIG // MQswCQYDVQQGEwJCRTEZMBcGA1UEChMQR2xvYmFsU2ln
// SIG // biBudi1zYTExMC8GA1UEAxMoR2xvYmFsU2lnbiBUaW1l
// SIG // c3RhbXBpbmcgQ0EgLSBTSEEyNTYgLSBHMjAeFw0xODAy
// SIG // MTkwMDAwMDBaFw0yOTAzMTgxMDAwMDBaMCsxKTAnBgNV
// SIG // BAMMIEdsb2JhbFNpZ24gVFNBIGZvciBBZHZhbmNlZCAt
// SIG // IEcyMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKC
// SIG // AQEAt8eSiijY85HLUA1d6ylEwYJZpcpkzr2DtVHllMxu
// SIG // gJoXbNz/YuY2Q14Bwgxkjcp3nvZdd0W5Xsgk60E3EWY3
// SIG // rMjNdJvMs+9M4n8bznO+yZadNR5891T3bOygEtaumZ1j
// SIG // xHhfWakuIvXDJ9iyW0VjJ5D/jLE9qbTzDsDxIGUGiZ0D
// SIG // HKOwUkGFNOu8y85U9hL+swGJSqb6VMUf+9McwOO/l+M/
// SIG // 0Bv5QMcb1esmfEMwx3DyeBGqhU6lDg0ASjoRd6PKIwGA
// SIG // nsiTVl1GzIrY0qoKhIWyiVvVMs5BexhOVMqr0VJeEtMk
// SIG // nlbzDI/dvZKOedVBicOjoOWR/MdnnYczznEycwIDAQAB
// SIG // o4IBqDCCAaQwDgYDVR0PAQH/BAQDAgeAMEwGA1UdIARF
// SIG // MEMwQQYJKwYBBAGgMgEeMDQwMgYIKwYBBQUHAgEWJmh0
// SIG // dHBzOi8vd3d3Lmdsb2JhbHNpZ24uY29tL3JlcG9zaXRv
// SIG // cnkvMAkGA1UdEwQCMAAwFgYDVR0lAQH/BAwwCgYIKwYB
// SIG // BQUHAwgwRgYDVR0fBD8wPTA7oDmgN4Y1aHR0cDovL2Ny
// SIG // bC5nbG9iYWxzaWduLmNvbS9ncy9nc3RpbWVzdGFtcGlu
// SIG // Z3NoYTJnMi5jcmwwgZgGCCsGAQUFBwEBBIGLMIGIMEgG
// SIG // CCsGAQUFBzAChjxodHRwOi8vc2VjdXJlLmdsb2JhbHNp
// SIG // Z24uY29tL2NhY2VydC9nc3RpbWVzdGFtcGluZ3NoYTJn
// SIG // Mi5jcnQwPAYIKwYBBQUHMAGGMGh0dHA6Ly9vY3NwMi5n
// SIG // bG9iYWxzaWduLmNvbS9nc3RpbWVzdGFtcGluZ3NoYTJn
// SIG // MjAdBgNVHQ4EFgQULW5u0Y3lA4Du52Ppp9naCzxXIj0w
// SIG // HwYDVR0jBBgwFoAUkiGnSpVdZLCbtB7mADdH5p1BK0ww
// SIG // DQYJKoZIhvcNAQELBQADggEBAI39HR+PiNNl+LVcRumn
// SIG // 07Y/SstDBcIHDcNeA4QjN6h6jJcj/yechH1h61xLVz6b
// SIG // 9ETbgFj3tmXejxIKX6eHdLfaFECHUeyfSkdV8BfoGD5x
// SIG // IDHmKCKrTvaunGvC50T7aA0gf1M/lBuhhoJOMhYQWj+J
// SIG // WMHQtNu2kPuNMumhS0ZQN7bDOukpJBKSWk4rubYKejaM
// SIG // l8DviXwz3jHhoZfk50WtYVL9WonTVH6KTVuJew6Wd9Hy
// SIG // PDgb2vmlYSBlArzFrdcMYhAoLN2246hhAKwIJqONhdBk
// SIG // yTaQHopSyYeNNaVdSJH8k6alZfHs+TrcpSyeBG1iM/7e
// SIG // +p/Fzq+V81Go8s4wggQVMIIC/aADAgECAgsEAAAAAAEx
// SIG // icZQBDANBgkqhkiG9w0BAQsFADBMMSAwHgYDVQQLExdH
// SIG // bG9iYWxTaWduIFJvb3QgQ0EgLSBSMzETMBEGA1UEChMK
// SIG // R2xvYmFsU2lnbjETMBEGA1UEAxMKR2xvYmFsU2lnbjAe
// SIG // Fw0xMTA4MDIxMDAwMDBaFw0yOTAzMjkxMDAwMDBaMFsx
// SIG // CzAJBgNVBAYTAkJFMRkwFwYDVQQKExBHbG9iYWxTaWdu
// SIG // IG52LXNhMTEwLwYDVQQDEyhHbG9iYWxTaWduIFRpbWVz
// SIG // dGFtcGluZyBDQSAtIFNIQTI1NiAtIEcyMIIBIjANBgkq
// SIG // hkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqpuOw6sRUSUB
// SIG // tpaU4k/YwQj2RiPZRcWVl1urGr/SbFfJMwYfoA/GPH5T
// SIG // SHq/nYeer+7DjEfhQuzj46FKbAwXxKbBuc1b8R5EiY7+
// SIG // C94hWBPuTcjFZwscsrPxNHaRossHbTfFoEcmAhWkkJGp
// SIG // eZ7X61edK3wi2BTX8QceeCI2a3d5r6/5f45O4bUIMf3q
// SIG // 7UtxYowj8QM5j0R5tnYDV56tLwhG3NKMvPSOdM7IaGlR
// SIG // dhGLD10kWxlUPSbMQI2CJxtZIH1Z9pOAjvgqOP1roEBl
// SIG // H1d2zFuOBE8sqNuEUBNPxtyLufjdaUyI65x7MCb8eli7
// SIG // WbwUcpKBV7d2ydiACoBuCQIDAQABo4HoMIHlMA4GA1Ud
// SIG // DwEB/wQEAwIBBjASBgNVHRMBAf8ECDAGAQH/AgEAMB0G
// SIG // A1UdDgQWBBSSIadKlV1ksJu0HuYAN0fmnUErTDBHBgNV
// SIG // HSAEQDA+MDwGBFUdIAAwNDAyBggrBgEFBQcCARYmaHR0
// SIG // cHM6Ly93d3cuZ2xvYmFsc2lnbi5jb20vcmVwb3NpdG9y
// SIG // eS8wNgYDVR0fBC8wLTAroCmgJ4YlaHR0cDovL2NybC5n
// SIG // bG9iYWxzaWduLm5ldC9yb290LXIzLmNybDAfBgNVHSME
// SIG // GDAWgBSP8Et/qC5FJK5NUPpjmove4t0bvDANBgkqhkiG
// SIG // 9w0BAQsFAAOCAQEABFaCSnzQzsm/NmbRvjWek2yX6AbO
// SIG // MRhZ+WxBX4AuwEIluBjH/NSxN8RooM8oagN0S2OXhXdh
// SIG // O9cv4/W9M6KSfREfnops7yyw9GKNNnPRFjbxvF7stICY
// SIG // ePzSdnno4SGU4B/EouGqZ9uznHPlQCLPOc7b5neVp7uy
// SIG // y/YZhp2fyNSYBbJxb051rvE9ZGo7Xk5GpipdCJLxo/Md
// SIG // dL9iDSOMXCo4ldLA1c3PiNofKLW6gWlkKrWmotVzr9xG
// SIG // 2wSukdduxZi61EfEVnSAR3hYjL7vK/3sbL/RlPe/UOB7
// SIG // 4JD9IBh4GCJdCC6MHKCX8x2ZfaOdkdMGRE4EbnocIOM2
// SIG // 8LZQuTGCAqgwggKkAgEBMGswWzELMAkGA1UEBhMCQkUx
// SIG // GTAXBgNVBAoTEEdsb2JhbFNpZ24gbnYtc2ExMTAvBgNV
// SIG // BAMTKEdsb2JhbFNpZ24gVGltZXN0YW1waW5nIENBIC0g
// SIG // U0hBMjU2IC0gRzICDAynz10HBySsieeaOjANBglghkgB
// SIG // ZQMEAgEFAKCCAQ4wGgYJKoZIhvcNAQkDMQ0GCyqGSIb3
// SIG // DQEJEAEEMBwGCSqGSIb3DQEJBTEPFw0yMDAzMjMxNDAz
// SIG // NTdaMC8GCSqGSIb3DQEJBDEiBCAgpdwkn1l8YKbFcKhW
// SIG // 3+2clA7GNapxPZq5Nyo9qsweyjCBoAYLKoZIhvcNAQkQ
// SIG // AgwxgZAwgY0wgYowgYcEFJsSBXrnKq/21jdytJ9qI28m
// SIG // Sc2pMG8wX6RdMFsxCzAJBgNVBAYTAkJFMRkwFwYDVQQK
// SIG // ExBHbG9iYWxTaWduIG52LXNhMTEwLwYDVQQDEyhHbG9i
// SIG // YWxTaWduIFRpbWVzdGFtcGluZyBDQSAtIFNIQTI1NiAt
// SIG // IEcyAgwMp89dBwckrInnmjowDQYJKoZIhvcNAQEBBQAE
// SIG // ggEAWXHTH9zDlDlDgTpBkmTmg6n/+t0VesdKQ9qziJgt
// SIG // J1Ly7jgXYQ7tuKaDpbkw8S/beta4H5iI5YgQY5sYdfYa
// SIG // TWmu2bM4q9tmvCwpAneZJ/s46TA9CgnGFBr9RajPtnmh
// SIG // DtDOvGcP2Gzl1SkkH03TeeIr3fBQno9BFjY0VKUFOnx1
// SIG // bSPYiY0LgsVv5biAVBNcxEutm/dPDfiZHLG5epvdKEKp
// SIG // 2EJ1dyXDuVVHrS7JITxXBJVUktrPxFeDsKFm9gKpNc2G
// SIG // aARB+yLHuqh2nCn/CTo33irLLOSrnuZbG+8s7rem2RWw
// SIG // JDa37UYajnZgYsQzYB31rPxujV9TqToRnOxspA==
// SIG // End signature block
