var topic = "<!DOCTYPE html>\r\n\n<!-- saved from url=(0024)http://docs.autodesk.com -->\r\n<html>\n   <head>\n      <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n      <meta name=\"product\" content=\"VAULT\">\n      <meta name=\"release\" content=\"2021\">\n      <meta name=\"book\" content=\"GeneralUser\">\n      <meta name=\"created\" content=\"2020-03-20\">\n      <meta name=\"topicid\" content=\"GUID-88084E18-7071-4BD3-8221-E51DBCA1195A\">\n      <meta name=\"description\" content=\"Configure connected workgroups to improve the performance of Microsoft SQL for remote sites.\">\n      <meta name=\"topic-type\" content=\"concept\">\n      <meta name=\"audience\" content=\"user\">\n      <meta name=\"experiencelevel\" content=\"general\">\n      <title>Connected Workgroups</title><script language=\"javascript\">var index = \'index.html\';</script></head>\n   <body height=\"100%\">\n      <div class=\"revit-legend\">\n         <ul></ul>\n      </div>\n      <div class=\"body_content\" id=\"body-content\" dir=\"ltr\"><a name=\"GUID-88084E18-7071-4BD3-8221-E51DBCA1195A\"></a><div class=\"head\">\n            <h1>Connected Workgroups</h1>\n         </div>\n         <p class=\"blurb\">Configure connected workgroups to improve the performance of Microsoft SQL for \n            <span class=\"char_link\"><a href=\"GUID-A4D1FDB5-5C6F-4EC3-A13B-1F710B90B31D.htm\">remote sites</a></span>. \n            \n         </p>\n         <div class=\"section\"><a name=\"SECTION_19EF9CD410E242238253171B7BE46267\"></a> \n            <h2><a name=\"GUID-19309248-4923-4E3B-B890-AD2F5BD7F37D\"></a>Learn About Connected Workgroups\n            </h2>  \n            <p><a name=\"GUID-98503FE3-D169-4D69-A5B1-D8FC2D75E862\"></a>You must understand replication before you can understand how Connected Workgroups\n               operate. \n               \n            </p> <a name=\"UL_0D9D76E1DA1B48A1980ECF54188AEBAF\"></a><p class=\"list-intro\"><a name=\"GUID-E30D2BD9-11E4-4AF2-A014-CBCD9B79411A\"></a>Replication\n            </p>\n            <p><a name=\"GUID-83872830-8768-49F8-A812-908288B9E10C\"></a>Replication is the process of copying data from one server to another server. The\n               servers are usually located in two different physical locations. This setup allows\n               a Vault environment in two locations so that it is not necessary to download large\n               CAD files across a Wide Area Network (WAN) connection. \n               \n            </p> <a name=\"UL_C28DFDBEB0224D4FA439A3E1EE594978\"></a><p class=\"list-intro\"><a name=\"GUID-18AEB7AF-BF35-420B-9C6E-A0D7E411FCFA\"></a>Workgroups\n            </p>\n            <p><a name=\"GUID-F55D9F35-2A0C-4296-BC4B-D4FE818D71AB\"></a>A workgroup is a group of users that share data via a local network. \n               \n            </p>\n            <p><a name=\"GUID-A09B4B17-4120-4117-9B3F-E97669469CD5\"></a> A connected workgroup is a workgroup that can share data with other workgroups, using\n               Microsoft SQL Publisher/Subscriber technology to support multiple database servers.\n               This technology allows the replication of the SQL database at multiple locations.\n               \n               \n            </p>\n            <p><a name=\"GUID-995A35BC-D8CA-4D51-AC06-E43559CC5CB9\"></a>When multiple Workgroups are authorized to work in the same vault, the workgroup must\n               request \n               	 <span class=\"char_link\"><a href=\"GUID-41197E16-CB1D-4A6B-9C77-B39295DA796A.htm\">ownership</a></span> of files, folders, items, and change orders before it can modify them. \n               \n            </p> <a name=\"UL_6F63776ADC3A444993FED25CC6A16769\"></a><p class=\"list-intro\"><a name=\"GUID-F8C5B51B-C821-4662-BD54-4ECAC83557C3\"></a>Requirements\n            </p>\n            <ul>\n               <li>For servers not in the same domain, add a local Windows account (not a domain account)\n                  for each agent at the appropriate nodes (use the same name and password at each node).\n                  For example, AutodeskRep. \n                  	 \n               </li>\n               <li>A shared folder on the Publisher where replication snap shots are stored and shared\n                  to remote SQL servers. \n                  	 \n               </li>\n               <li>A Windows account on the Publisher that has Read/Write permissions to the snap shot\n                  share. \n                  	 \n               </li>\n               <li>A Windows account that has Read permissions to Publisher\'s snap shot share. \n                  	 \n               </li>\n               <li>Server participating in the replication environment must be able to resolve remote\n                  servers by NetBIOS name. \n                  	 \n               </li>\n               <li>SQL and http ports need to be open in firewalls for communication between servers.\n                  \n                  	 \n               </li>\n               <li>SQL Server Replication must be enabled. If not, run the SQL installation package again\n                  to modify the installation on the SQL server and enable replication. (<span class=\"MenuCascade\">Feature Selection <img src=\"../images/ac.menuaro.gif\"> Instance Features <img src=\"../images/ac.menuaro.gif\"> Database Engine Services <img src=\"../images/ac.menuaro.gif\"> SQL Server Replication</span>.) \n                  	 \n               </li>\n            </ul> <a name=\"UL_DA1DE07389B443AE8815E98484B8D99F\"></a><p class=\"list-intro\"><a name=\"GUID-3CF926F3-DCC0-4941-A6A2-B51FD7B84788\"></a>Recommendations\n            </p>\n            <ul>\n               <li>Servers are in the same domain or two-way trusted domains. \n                  	 \n               </li>\n               <li>Servers are assigned static IP address. \n                  	 \n               </li>\n               <li>Use 1 domain user account for replication and snap shot access. \n                  	 \n               </li>\n            </ul> <a name=\"UL_478325F4ED5C453E9C5960A983487EF8\"></a><p class=\"list-intro\"><a name=\"GUID-52B7D7E0-E85F-4445-BE3A-5FB803DD9C25\"></a>Opening ports in Windows Firewall\n            </p>\n            <ul>\n               <li>The AutodeskVault instance of SQL uses a Dynamic port. \n                  		<a name=\"OL_0A7D47362E634FF197879595C2D77599\"></a><p class=\"list-intro\"><a name=\"GUID-A8E7841D-EC70-4179-806A-8D277F3E49D5\"></a>Find the port being used by your servers\n                  </p>\n                  <ol type=\"1\" start=\"1\">\n                     <li>Open the SQL Server Configuration Manager \n                        		  \n                     </li>\n                     <li>Expand the SQL Server Network Configuration \n                        		  \n                     </li>\n                     <li>Select Protocols for AUTODESKVAULT \n                        		  \n                     </li>\n                     <li>In the right pane, double-click on TCP/IP \n                        		  \n                     </li>\n                     <li>Select the IP Address tab \n                        		  \n                     </li>\n                     <li>Scroll to the bottom of the list and find the port under the IP All section -&gt; TCP\n                        Dynamic Ports \n                        		  \n                     </li>\n                     <li>Use this port number in the SQL AUTODESKVAULT line of the script below to open the\n                        dynamic port in the Windows firewall. \n                        			 \n                        <p><a name=\"GUID-00FC5DA5-71FF-4866-B036-9D5CD6081CBE\"></a>Copy the following line into a batch file to open the necessary ports. \n                           			 \n                        </p> \n                        <p><a name=\"GUID-37DCB5AD-9CC1-4A71-A298-A8D25D466109\"></a>@echo ========= SQL Server Ports =================== \n                           			 \n                        </p> \n                        <p><a name=\"GUID-C9C533A1-9455-48BD-86BA-5CE94E2CE5F3\"></a>@echo Enabling SQLServer default instance port 1433 \n                           			 \n                        </p> \n                        <p><a name=\"GUID-16BADED4-2266-40BF-A141-BB5242A53D43\"></a>netsh firewall set portopening TCP 1433 \"SQLServer\" \n                           			 \n                        </p> \n                        <p><a name=\"GUID-9B9DF7D8-9042-4B76-95C5-CCFEA2F0E3B3\"></a>@echo Enabling Dedicated Admin Connection port 1434 \n                           			 \n                        </p> \n                        <p><a name=\"GUID-D53B34B9-BD00-4BD4-B868-CD3EE55B71DC\"></a>netsh firewall set portopening TCP 1434 \"SQL Admin Connection\" \n                           			 \n                        </p> \n                        <p><a name=\"GUID-AAAFCFF8-19E1-46BA-A2DA-F4A0057FBED4\"></a>@echo Enabling port for SQL Server Browser Service\'s \'Browse\' Button \n                           			 \n                        </p> \n                        <p><a name=\"GUID-E5D1BB43-D875-4FC7-A946-040D84C454AB\"></a>netsh firewall set portopening UDP 1434 \"SQL Browser\" \n                           			 \n                        </p> \n                        <p><a name=\"GUID-9ED676B6-8583-480D-B6D2-BE67E77432AA\"></a>@echo Enabling SQL Server Dynamic port \n                           			 \n                        </p> \n                        <p><a name=\"GUID-5FE5DD52-5C55-4357-AA9D-286AF410EC93\"></a>netsh firewall set portopening TCP &lt;number&gt; \"SQL AUTODESKVAULT\" \n                           			 \n                        </p> \n                        <p><a name=\"GUID-266A6BEA-CDD7-4F69-A1B0-A24CB0561F72\"></a>@echo ========= Misc Applications ============== \n                           			 \n                        </p> \n                        <p><a name=\"GUID-D4F69BDC-BB87-4220-A464-627C18257B26\"></a>@echo Enabling HTTP port 80 \n                           			 \n                        </p> \n                        <p><a name=\"GUID-FB2834B6-DADC-490A-8607-F5CC251F36F4\"></a>netsh firewall set portopening TCP 80 \"HTTP\" \n                           			 \n                        </p> \n                     </li>\n                  </ol> <a name=\"UL_12FC183F453249AB8E504C154B38EB29\"></a><p class=\"list-intro\"><a name=\"GUID-3BCF68BD-EFA9-402C-ACA5-B5A1AE970B39\"></a>Troubleshooting Tips\n                  </p>\n                  <ul>\n                     <li>Use the SQL Management Studio to verify that you can connect to the remote SQL servers.\n                        \n                        		  \n                     </li>\n                     <li>Use a web browser to verify you have port 80 open. \n                        		  \n                     </li>\n                     <li>Use Windows Explorer and the replication user credentials to verify each server has\n                        access to the snap shot share. \n                        		  \n                     </li>\n                  </ul> \n               </li>\n            </ul> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_141264FDC2444749A1CD633F6119D789\"></a> \n            <h2><a name=\"GUID-F335A2DE-E3A5-4CF3-BE84-FDEC647589CD\"></a>Connected Workgroups Overview\n            </h2> \n            <p><a name=\"GUID-18364920-B327-4B3E-A563-2FB18E0CD88C\"></a>A connected workgroup is a configuration of file stores that have been replicated\n               from one site to another and that are managed by the Microsoft SQL database. The following\n               illustration shows a typical workgroup configuration. All sites in a single workgroup\n               share the same Microsoft SQL server. \n               \n            </p> <a name=\"FIG_B91B0926B60D4A428DC60E15589DDE9A\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-D9F77B08-4264-44C2-B939-141DDECFE7B8-low.png\"></div> \n            <p> </p> \n            <p><a name=\"GUID-CD6A7797-01B7-49AF-AADB-A2C91AE83286\"></a>To allow sites to have their own database server to increase SQL performance, Vault\n               uses connected workgroups. The following illustration shows a workgroup with two different\n               sites connected to a second workgroup with a single site. \n               \n            </p> <a name=\"FIG_3F895183873E4D919F8FB9A9640DFDB1\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-3316DD65-07F5-4CAF-BB93-9DE14081653D-low.png\"></div> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_0E7DCF26BAC4436A956D4B092D03C91C\"></a> \n            <h2><a name=\"GUID-4E5985F9-CEA2-4140-9D91-F19F7DD0C2B1\"></a>Create Connected Workgroups\n            </h2> \n            <p><a name=\"GUID-82851127-8735-4129-AF8D-F6237B1E741B\"></a>The installation of a Connected Workgroup environment requires each component to be\n               installed and configured in the correct order, as follows. \n               \n            </p> \n            <div class=\"section\"><a name=\"SECTION_BB879FB69DBA488C8474C93F81C06681\"></a> \n               <h3><a name=\"GUID-971E4DF5-5F93-443E-BF7E-44B71DA743DA\"></a>Configure the Publisher\n               </h3> <a name=\"OL_ACC2C566681D4630A3D8ECBE04F805D7\"></a><ol type=\"1\" start=\"1\">\n                  <li>Install MS SQL on the computer where all the information is to be replicated from.\n                     This computer is known as the Publisher. \n                     		  <a name=\"UL_3CF4BBAF13DE4A21A1AC54C035207431\"></a><ul>\n                        <li>Make sure you enable replication during installation. See \n                           				<span class=\"char_link\"><a href=\"GUID-6E35739D-CBCC-4211-9051-E451EBE3360C.htm#SECTION_C5D89DF1F87E4449BE34049331DCECC7\">Install SQL Server</a></span>. \n                           			 \n                        </li>\n                        <li>Make sure you set up one or more shared network folders. See \n                           				<span class=\"char_link\"><a href=\"GUID-A4D1FDB5-5C6F-4EC3-A13B-1F710B90B31D.htm#SECTION_9235E782A53049DB8BE4EE74C9989386\">Use a Remote Database</a></span>. \n                           			 \n                        </li>\n                        <li>Autodesk recommends that you set up a \"replication user\" on the domain and make note\n                           of these credentials for the following steps. See \n                           				<span class=\"char_link\"><a href=\"GUID-6E35739D-CBCC-4211-9051-E451EBE3360C.htm\">SQL Administration for Vault</a></span>. \n                           			 \n                        </li>\n                     </ul> \n                  </li>\n                  <li>After SQL is installed, log into the SQL AutodeskVault Instance through the SQL Server\n                     Management Studio. Right click the top level server name and select properties. Under\n                     the Connections tab, make sure that the option nocount is not selected. \n                     		\n                  </li>\n                  <li>Install Vault server on the Publisher. \n                     		\n                  </li>\n                  <li>After the Vault server is installed, start the Vault server console. \n                     		\n                  </li>\n                  <li>In the Vault server console, right-click Workgroups and select Enable Workgroup Replication.\n                     \n                     		  <a name=\"FIG_4EDE18FDA07D45888DB5F08F845D28BB\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-6A51926C-B54A-462E-867F-070F75DF3964-low.png\"></div> \n                  </li>\n                  <li>Fill in the UNC path for the shared folder. For example: \\\\server\\share\\. \n                     		  <a name=\"FIG_114837BF05B84DE7AACEA8E1930322FF\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-33ACAB1E-CFB0-4595-BC91-7F1FCC8068AF-low.png\"></div> \n                  </li>\n                  <li>Enter the User ID, which is the user account configured for replication, and with\n                     full access to the shared folder, and click \n                     		  <span class=\"MenuCascade\">OK</span>. \n                     		\n                  </li>\n                  <li>On the subscriber computer (the target for replicated data), install the same version\n                     of SQL that you just installed on the publisher. \n                     		  \n                     <div><a name=\"GUID-75AA331A-D3E2-4F42-B1A5-76E8D97E3848\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span>Install this with a preconfigured instance named AutodeskVault and the same password\n                           as the publisher. \n                           		  \n                        </div>\n                     </div> \n                  </li>\n                  <li>On the publisher, right-click Workgroups again in the Vault server console and select\n                     \n                     		  <span class=\"MenuCascade\">Add Workgroup</span>. \n                     		  <a name=\"FIG_9B5A17D79A5C4E77842B7217B5941226\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-C52C36B2-B551-420B-8FAB-1DDF6B391E64-low.png\"></div> \n                  </li>\n                  <li>Enter the appropriate information for the remote workgroup. \n                     		  \n                     <p>If you created a replication user account, use those credentials under Remote Replication\n                        Credentials. \n                        		  \n                     </p> <a name=\"FIG_DE86400264D34E70ADFBD67001D0933C\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-48732200-C4C3-4642-AFA2-4E78C11683EE-low.png\"></div> \n                  </li>\n               </ol> \n               <p> A background process configures the remote SQL server as a subscriber, and starts\n                  to replicate the KVM database from the publisher. Once the secondary server has completed\n                  its configuration, it is added to the Workgroups tree in the console. \n                  		\n                  <div><a name=\"GUID-83641DB7-37E9-49F9-B26F-8A76237E0268\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span>Once you have done this, you can install the Vault server console on the subscriber\n                        and enable vault replication. \n                        		\n                     </div>\n                  </div> \n               </p> \n            </div> \n            <div class=\"section\"><a name=\"SECTION_DA241BF3E01D43A08CCE5EB4E19CF803\"></a> \n               <h3><a name=\"GUID-7EE37A0C-BCD1-4428-8021-DB221701950A\"></a>Configure Firewalls\n               </h3> \n               <p><a name=\"GUID-02757C67-82A8-408F-A5AC-4DB8967D030A\"></a> Configure Firewalls \n                  	 \n               </p> \n               <p><a name=\"GUID-8CDE3571-8545-4049-ABB5-E386C9A1FFF6\"></a>Before adding a workgroup be sure that the SQL server can communicate with the Vault\n                  server through the firewall. This can be done by allowing an exception for the SQL\n                  executables sqlbrowser.exe and sqlserver.exe. \n                  	 \n               </p> \n            </div> \n            <div class=\"section\"><a name=\"SECTION_1AE186AEF8184118B3CE98FAA2329B9C\"></a> \n               <h3><a name=\"GUID-9F54A2E5-6B9E-479D-892B-491059F06967\"></a>Enable Vault Replication\n               </h3> \n               <p>Once you have configured the publisher, you can install the Vault server console on\n                  the subscriber and enable Vault replication. \n                  	 \n               </p> \n               <div><a name=\"GUID-2985BC8B-0A3D-432E-A66E-7351508907C1\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span>For subscribing locations with slower network connections it is better to configure\n                     the server at the same location as the publisher and ship the server. If shipping\n                     a subscribing server to a different location, do not disconnect it from the network\n                     for more than 14 days to allow a successful replication once reconnected to the network.\n                     \n                     	 \n                  </div>\n               </div> <a name=\"OL_FFBF87D611314D95ADB33BF5A155BE51\"></a><ol type=\"1\" start=\"1\">\n                  <li>Install Autodesk Data Management Server on the subscriber and have it point to the\n                     subscriber SQL Server that is also installed there. \n                     		\n                  </li>\n                  <li>On the publisher in the ADMS Console, right-click Workgroups and select Manage Replication.\n                     \n                     		  <a name=\"FIG_970CDEC032944E29BA858852D8B37D19\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-FDEE5CEB-1573-41A7-A0F7-EF796A97711C-low.png\"></div> \n                  </li>\n                  <li>Select the Vault that you want to replicate. \n                     		  <a name=\"FIG_F9569861767C40138BAF3C0702046D28\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-814AD04D-B1E3-48C8-B8DE-75EBCE43A85F-low.png\"></div> \n                  </li>\n                  <li>Move the workgroups you want to replicate into the Replicated column using the &gt;&gt;\n                     button. \n                     		  <a name=\"FIG_3A7251DCCF4A49A7BDC30D01E01179C7\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-B5AAD2EC-92F1-4583-81C1-6C22687D1EE9-low.png\"></div> \n                  </li>\n                  <li>On the subscriber, open the ADMS Console and expand the Vaults node. \n                     		\n                  </li>\n                  <li>Right-click the appropriate Vault and select Vault Enabled to enable the vault. \n                     		  <a name=\"FIG_5BF4A00F83E74615822F87F05D248514\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-164E2A74-1784-4114-8AEF-EDA910F73F52-low.png\"></div> \n                  </li>\n                  <li>Select the appropriate file store location when prompted. \n                     		\n                  </li>\n               </ol> \n               <p>Vault opens information dialog boxes that describe the vault synchronization frequency\n                  and tell you that the vault has been enabled. \n                  	 \n               </p> \n            </div> \n            <div class=\"section\"><a name=\"SECTION_A5370613AF0F4DB59388E7EB381D7875\"></a> \n               <h3><a name=\"GUID-DCCAB048-4122-4D35-AC91-2C40B9F7AAFB\"></a>Test Replication\n               </h3> <a name=\"OL_822EDD0D32E943A6BDF6D063784BA03B\"></a><ol type=\"1\" start=\"1\">\n                  <li>Add a file to the publisher workgroup \n                     		\n                  </li>\n                  <li>Check the file out, modify it, and check it back in. \n                     		\n                  </li>\n                  <li>Move to a subscriber workgroup and transfer ownership of the file. \n                     		\n                  </li>\n                  <li>Repeat the same steps you did on the Publisher. \n                     		\n                  </li>\n                  <li>Optional: Transfer ownership back to the publisher when finished. \n                     		\n                  </li>\n               </ol> \n            </div> \n            <div class=\"section\"><a name=\"SECTION_E5B9DD57F03049C7B7B472D337305968\"></a> \n               <h3><a name=\"GUID-9B638CF6-7222-49E1-A2C8-51657A3E5744\"></a>Back Up and Restore\n               </h3> \n               <p><a name=\"GUID-7700E6C1-08E5-424F-9FFD-1EA18431F802\"></a>Perform all backup and restore operations from the publisher site. If it becomes necessary\n                  to restore a subscriber, remove that subscriber from the connected workgroup environment,\n                  rebuild the subscriber server, and add it back to the connected workgroup environment.\n                  \n                  	 \n               </p> \n               <p><a name=\"GUID-6C5007E8-29D0-4F98-BA10-3D95FD26444E\"></a>Vault backs up the normal KVM and Vault databases, and the SQL master database, the\n                  msdb database, and the replication distribution database. The default name of the\n                  replication distribution database is AutodeskReplication. \n                  	 \n               </p> \n               <p><a name=\"GUID-51707C80-EAFA-41F5-BD87-64D7E7B389B1\"></a>Vault does not allow you to restore a connected workgroup environment. The databases\n                  necessary for restoring a connected workgroup environment are backed up, and can be\n                  restored manually if necessary. \n                  	 \n               </p> \n               <div><a name=\"GUID-503580B5-1364-483F-986B-121B7E3425F9\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span> The publisher name and name of the distribution database are stored in the backupcontents.xml\n                     file. \n                     	 \n                  </div>\n               </div> \n               <p><a name=\"GUID-FCF74578-021D-4EAC-BAE2-B63AAB2BC4EF\"></a> <em class=\"strong\"> Back up</em> \n               </p> \n               <p><a name=\"GUID-3571FF13-1E22-49CE-BBB9-1868AB3AF37F\"></a>Use the Vault server console to create a backup of the Vault server at the publisher\n                  site. \n                  	 \n               </p> \n               <p><a name=\"GUID-A3A1D622-AF09-43EE-B5B7-CC9E0F53AD68\"></a>Perform a backup when you : \n                  	 <a name=\"UL_ECFA634561724361B75CE167E46A8863\"></a><ul>\n                     <li>Change a workgroup. \n                        		\n                     </li>\n                     <li>Add a workgroup. \n                        		\n                     </li>\n                     <li>Delete a workgroup. \n                        		\n                     </li>\n                     <li>Rename a workgroup. \n                        		\n                     </li>\n                  </ul> \n               </p> \n               <p><a name=\"GUID-66572D66-786D-46DE-A303-BEDC2C771627\"></a> <em class=\"strong\">Restore</em> \n               </p> \n               <p><a name=\"GUID-0B52CB2B-99B7-420A-9525-2E8F1D867336\"></a>To restore an Autodesk Vault Professional environment using the backup and restore\n                  tools provided by the server console, the publishing server must be restored and all\n                  subscribers must be added as if they were never part of the environment. \n                  	 \n               </p> \n               <p><a name=\"GUID-63DFC1F9-E5B6-4435-B60C-BBFE4B4E0403\"></a>The following rules apply when manually restoring the Vault connected workgroup publisher\n                  while maintaining the existing subscribers: \n                  	 <a name=\"UL_5D0359941D6040EA85A9F5A4A7E4FAB9\"></a><ul>\n                     <li>The publisher can only be restored to a server with the same name. \n                        		\n                     </li>\n                     <li>Subscribers should be on the same version of Autodesk Vault Professional. No data\n                        migration should be needed. \n                        		\n                     </li>\n                     <li>The backup should not be more than 14 days old. \n                        		\n                     </li>\n                     <li>Start each database server in single-user mode. \n                        		\n                     </li>\n                     <li>Restart the database server instance after each database is restored. \n                        		\n                     </li>\n                  </ul> \n               </p> \n               <p><a name=\"GUID-6BE664FF-C008-41B5-BD0A-8D3F015D8C76\"></a>Restore the databases in the following order: \n                  	 <a name=\"OL_61FE4845DDF440BB88332022D0F17A47\"></a><ol type=\"1\" start=\"1\">\n                     <li>Master \n                        		\n                     </li>\n                     <li>MSDB \n                        		\n                     </li>\n                     <li>AutodeskReplication \n                        		\n                     </li>\n                     <li>KVM \n                        		\n                     </li>\n                     <li>Vaults \n                        		\n                     </li>\n                  </ol> \n               </p> \n            </div> \n         </div>\n         <div class=\"footer-block\"><a href=\"..\" class=\"comments-anchor\" target=\"_blank\"><span class=\"comments-link\">Please send us your comment about this page</span></a></div><br><p class=\"footer-license-block\"><a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\"><img alt=\"Creative Commons License\" style=\"border-width: 0;\" src=\"../images/ccLink.png\"></a>&nbsp;<em>Except where otherwise noted, this work is licensed under a <a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\">Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License</a>. Please see the <a href=\"http://autodesk.com/creativecommons\" target=\"_blank\">Autodesk Creative Commons FAQ</a> for more information.</em></p><br></div>\n   </body>\n</html>";
// SIG // Begin signature block
// SIG // MIIbRQYJKoZIhvcNAQcCoIIbNjCCGzICAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // gIcphtaatIX+BTUU4ubz7CbeVIP8OPagb7DjssHOpWmg
// SIG // ggoaMIIEyzCCA7OgAwIBAgIQCQja65wGHi65un4mqmKH
// SIG // ijANBgkqhkiG9w0BAQsFADCBhDELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTUw
// SIG // MwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
// SIG // b2RlIFNpZ25pbmcgQ0EgLSBHMjAeFw0xOTA1MTQwMDAw
// SIG // MDBaFw0yMDA1MTMyMzU5NTlaMHwxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIDApDYWxpZm9ybmlhMRMwEQYDVQQHDApT
// SIG // YW4gUmFmYWVsMRcwFQYDVQQKDA5BdXRvZGVzaywgSW5j
// SIG // LjERMA8GA1UECwwIU2VjdXJpdHkxFzAVBgNVBAMMDkF1
// SIG // dG9kZXNrLCBJbmMuMIIBIjANBgkqhkiG9w0BAQEFAAOC
// SIG // AQ8AMIIBCgKCAQEAkVKRoPYsoxPdlabspcuG8HYDfcWQ
// SIG // 9qyPOT2punwpVdjt2slktcpSTlydrGy8ijcbl5/k8AOJ
// SIG // afKMQvow0fNjIoNB5nsb8j2xFJPbBhHl8GT4P6DZ1OWK
// SIG // ioiUXgGHKjctUws49J4elntqvBYhKCbuPqG772QCoYFU
// SIG // P7qcFbh3PbyNB6cnKMn2vNGRqiEtV2aGg+/MiL3QPsvT
// SIG // kTWhVuTLIvwZ4kK5C5ACiQzlGOlE+C7gWuFoxtvy6gUa
// SIG // A8JAq/xLjYKwFevQwGncg3s1cuiGhx0P7Rvn6oCd2cem
// SIG // FmbK3I3rMRt+jc9wzAj3oHxvCo4f5Lfva+OpC1dETUVV
// SIG // sk0VGwIDAQABo4IBPjCCATowCQYDVR0TBAIwADAOBgNV
// SIG // HQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMw
// SIG // YQYDVR0gBFowWDBWBgZngQwBBAEwTDAjBggrBgEFBQcC
// SIG // ARYXaHR0cHM6Ly9kLnN5bWNiLmNvbS9jcHMwJQYIKwYB
// SIG // BQUHAgIwGQwXaHR0cHM6Ly9kLnN5bWNiLmNvbS9ycGEw
// SIG // HwYDVR0jBBgwFoAU1MAGIknrOUvdk+JcobhHdglyA1gw
// SIG // KwYDVR0fBCQwIjAgoB6gHIYaaHR0cDovL3JiLnN5bWNi
// SIG // LmNvbS9yYi5jcmwwVwYIKwYBBQUHAQEESzBJMB8GCCsG
// SIG // AQUFBzABhhNodHRwOi8vcmIuc3ltY2QuY29tMCYGCCsG
// SIG // AQUFBzAChhpodHRwOi8vcmIuc3ltY2IuY29tL3JiLmNy
// SIG // dDANBgkqhkiG9w0BAQsFAAOCAQEA0Q2+iVSEfT4xGq3A
// SIG // OADVb0rT5Z8E+PPb1x6hKknSzuaZKk/acDz9mdnFajaU
// SIG // WgIKiFJlsqJnuAM1w4lqKaEWsz3DoxvGIEwexj71Ud6a
// SIG // KlBJNcR9DdkXUZwMhbw9d78rjJAIX6tOwfSludZfdq8b
// SIG // YEkuIzQi9uYW9vHVPSCzhnUBKjwc9qTo9yBc7Fcn4FAT
// SIG // 90DzWM2hS9oc3p0pprYI2I/O4th90BEmwWkVqVgfaR0z
// SIG // VyIEmBbqB/IWLfjUBZJ/8sbkwWuWlYVRrfPxsj1e9qvb
// SIG // wE3Y28jWyGbqoUG39GhXk3uT8R8i3+T6M0c4rMfdifBC
// SIG // pceCaFTJzSye7LoeVzCCBUcwggQvoAMCAQICEHwbNTVK
// SIG // 59t050FfEWnKa6gwDQYJKoZIhvcNAQELBQAwgb0xCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjEfMB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29y
// SIG // azE6MDgGA1UECxMxKGMpIDIwMDggVmVyaVNpZ24sIElu
// SIG // Yy4gLSBGb3IgYXV0aG9yaXplZCB1c2Ugb25seTE4MDYG
// SIG // A1UEAxMvVmVyaVNpZ24gVW5pdmVyc2FsIFJvb3QgQ2Vy
// SIG // dGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMTQwNzIyMDAw
// SIG // MDAwWhcNMjQwNzIxMjM1OTU5WjCBhDELMAkGA1UEBhMC
// SIG // VVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9u
// SIG // MR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3Jr
// SIG // MTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1
// SIG // NiBDb2RlIFNpZ25pbmcgQ0EgLSBHMjCCASIwDQYJKoZI
// SIG // hvcNAQEBBQADggEPADCCAQoCggEBANeVQ9Tc32euOftS
// SIG // pLYmMQRw6beOWyq6N2k1lY+7wDDnhthzu9/r0XY/ilaO
// SIG // 6y1L8FcYTrGNpTPTC3Uj1Wp5J92j0/cOh2W13q0c8fU1
// SIG // tCJRryKhwV1LkH/AWU6rnXmpAtceSbE7TYf+wnirv+9S
// SIG // rpyvCNk55ZpRPmlfMBBOcWNsWOHwIDMbD3S+W8sS4duM
// SIG // xICUcrv2RZqewSUL+6McntimCXBx7MBHTI99w94Zzj7u
// SIG // BHKOF9P/8LIFMhlM07Acn/6leCBCcEGwJoxvAMg6ABFB
// SIG // ekGwp4qRBKCZePR3tPNgKuZsUAS3FGD/DVH0qIuE/iHa
// SIG // XF599Sl5T7BEdG9tcv8CAwEAAaOCAXgwggF0MC4GCCsG
// SIG // AQUFBwEBBCIwIDAeBggrBgEFBQcwAYYSaHR0cDovL3Mu
// SIG // c3ltY2QuY29tMBIGA1UdEwEB/wQIMAYBAf8CAQAwZgYD
// SIG // VR0gBF8wXTBbBgtghkgBhvhFAQcXAzBMMCMGCCsGAQUF
// SIG // BwIBFhdodHRwczovL2Quc3ltY2IuY29tL2NwczAlBggr
// SIG // BgEFBQcCAjAZGhdodHRwczovL2Quc3ltY2IuY29tL3Jw
// SIG // YTA2BgNVHR8ELzAtMCugKaAnhiVodHRwOi8vcy5zeW1j
// SIG // Yi5jb20vdW5pdmVyc2FsLXJvb3QuY3JsMBMGA1UdJQQM
// SIG // MAoGCCsGAQUFBwMDMA4GA1UdDwEB/wQEAwIBBjApBgNV
// SIG // HREEIjAgpB4wHDEaMBgGA1UEAxMRU3ltYW50ZWNQS0kt
// SIG // MS03MjQwHQYDVR0OBBYEFNTABiJJ6zlL3ZPiXKG4R3YJ
// SIG // cgNYMB8GA1UdIwQYMBaAFLZ3+mlIR59TEtXC6gcydgfR
// SIG // lwcZMA0GCSqGSIb3DQEBCwUAA4IBAQB/68qn6ot2Qus+
// SIG // jiBUMOO3udz6SD4Wxw9FlRDNJ4ajZvMC7XH4qsJVl5Fw
// SIG // g/lSflJpPMnx4JRGgBi7odSkVqbzHQCR1YbzSIfgy8Q0
// SIG // aCBetMv5Be2cr3BTJ7noPn5RoGlxi9xR7YA6JTKfRK9u
// SIG // QyjTIXW7l9iLi4z+qQRGBIX3FZxLEY3ELBf+1W5/muJW
// SIG // kvGWs60t+fTf2omZzrI4RMD3R3vKJbn6Kmgzm1By3qif
// SIG // 1M0sCzS9izB4QOCNjicbkG8avggVgV3rL+JR51EeyXgp
// SIG // 5x5lvzjvAUoBCSQOFsQUecFBNzTQPZFSlJ3haO8I8OJp
// SIG // nGdukAsak3HUJgLDwFojMYIQgzCCEH8CAQEwgZkwgYQx
// SIG // CzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRlYyBD
// SIG // b3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1
// SIG // c3QgTmV0d29yazE1MDMGA1UEAxMsU3ltYW50ZWMgQ2xh
// SIG // c3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENBIC0gRzIC
// SIG // EAkI2uucBh4uubp+Jqpih4owDQYJYIZIAWUDBAIBBQCg
// SIG // fDAQBgorBgEEAYI3AgEMMQIwADAZBgkqhkiG9w0BCQMx
// SIG // DAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4wDAYK
// SIG // KwYBBAGCNwIBFTAvBgkqhkiG9w0BCQQxIgQgi7DTyg2K
// SIG // Ggoy/jhXOEiOb5nwgZisveVXjc4OpWPoHDEwDQYJKoZI
// SIG // hvcNAQEBBQAEggEACRPJ/7bnaeckJ7zqGdzS7BNoad39
// SIG // rol3ecG9YPt4737ro5MFqc8eSsgQYOHU+ZCW/rDjV7Xf
// SIG // orcRT7bANG0i1KlFYC4ZQQKziS32T2gS8I7NCyTGDRD9
// SIG // KE+aN/Y1YjiAMbrJS6WVb9V3y+4ASnCn1rRsg7kZtU8y
// SIG // 7Zl/994pn7RxLm0xIp7eJBhyhIP7Z+VErJI7mwdZGuKI
// SIG // GNNyTP19dl9ldGgJEa+W/p9JKDVUA5UEpkVXU3sAOxMa
// SIG // i8BPQV9RQrFOURRx4cIKQGpr6oD3zhQqrkfWagIWxlGu
// SIG // b+kJXA6s5Hq8bxwFOf3LhekBWvn/ed9w3Jkee61xjio6
// SIG // a61BSaGCDjwwgg44BgorBgEEAYI3AwMBMYIOKDCCDiQG
// SIG // CSqGSIb3DQEHAqCCDhUwgg4RAgEDMQ0wCwYJYIZIAWUD
// SIG // BAIBMIIBDgYLKoZIhvcNAQkQAQSggf4EgfswgfgCAQEG
// SIG // C2CGSAGG+EUBBxcDMDEwDQYJYIZIAWUDBAIBBQAEINS3
// SIG // Jisn0fJMF53dtWubPR9Ays48w456mTIfEa/pimbYAhRP
// SIG // bDjrR/8NMc6N4ZmlwUfUPkHg2BgPMjAyMDAzMjMxNDAy
// SIG // MjlaMAMCAR6ggYakgYMwgYAxCzAJBgNVBAYTAlVTMR0w
// SIG // GwYDVQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlvbjEfMB0G
// SIG // A1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazExMC8G
// SIG // A1UEAxMoU3ltYW50ZWMgU0hBMjU2IFRpbWVTdGFtcGlu
// SIG // ZyBTaWduZXIgLSBHM6CCCoswggU4MIIEIKADAgECAhB7
// SIG // BbHUSWhRRPfJidKcGZ0SMA0GCSqGSIb3DQEBCwUAMIG9
// SIG // MQswCQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24s
// SIG // IEluYy4xHzAdBgNVBAsTFlZlcmlTaWduIFRydXN0IE5l
// SIG // dHdvcmsxOjA4BgNVBAsTMShjKSAyMDA4IFZlcmlTaWdu
// SIG // LCBJbmMuIC0gRm9yIGF1dGhvcml6ZWQgdXNlIG9ubHkx
// SIG // ODA2BgNVBAMTL1ZlcmlTaWduIFVuaXZlcnNhbCBSb290
// SIG // IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTE2MDEx
// SIG // MjAwMDAwMFoXDTMxMDExMTIzNTk1OVowdzELMAkGA1UE
// SIG // BhMCVVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0
// SIG // aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3
// SIG // b3JrMSgwJgYDVQQDEx9TeW1hbnRlYyBTSEEyNTYgVGlt
// SIG // ZVN0YW1waW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOC
// SIG // AQ8AMIIBCgKCAQEAu1mdWVVPnYxyXRqBoutV87ABrTxx
// SIG // rDKPBWuGmicAMpdqTclkFEspu8LZKbku7GOz4c8/C1aQ
// SIG // +GIbfuumB+Lef15tQDjUkQbnQXx5HMvLrRu/2JWR8/Du
// SIG // bPitljkuf8EnuHg5xYSl7e2vh47Ojcdt6tKYtTofHjmd
// SIG // w/SaqPSE4cTRfHHGBim0P+SDDSbDewg+TfkKtzNJ/8o7
// SIG // 1PWym0vhiJka9cDpMxTW38eA25Hu/rySV3J39M2ozP4J
// SIG // 9ZM3vpWIasXc9LFL1M7oCZFftYR5NYp4rBkyjyPBMkEb
// SIG // WQ6pPrHM+dYr77fY5NUdbRE6kvaTyZzjSO67Uw7UNpeG
// SIG // eMWhNwIDAQABo4IBdzCCAXMwDgYDVR0PAQH/BAQDAgEG
// SIG // MBIGA1UdEwEB/wQIMAYBAf8CAQAwZgYDVR0gBF8wXTBb
// SIG // BgtghkgBhvhFAQcXAzBMMCMGCCsGAQUFBwIBFhdodHRw
// SIG // czovL2Quc3ltY2IuY29tL2NwczAlBggrBgEFBQcCAjAZ
// SIG // GhdodHRwczovL2Quc3ltY2IuY29tL3JwYTAuBggrBgEF
// SIG // BQcBAQQiMCAwHgYIKwYBBQUHMAGGEmh0dHA6Ly9zLnN5
// SIG // bWNkLmNvbTA2BgNVHR8ELzAtMCugKaAnhiVodHRwOi8v
// SIG // cy5zeW1jYi5jb20vdW5pdmVyc2FsLXJvb3QuY3JsMBMG
// SIG // A1UdJQQMMAoGCCsGAQUFBwMIMCgGA1UdEQQhMB+kHTAb
// SIG // MRkwFwYDVQQDExBUaW1lU3RhbXAtMjA0OC0zMB0GA1Ud
// SIG // DgQWBBSvY9bKo06FcuCnvEHzKaI4f4B1YjAfBgNVHSME
// SIG // GDAWgBS2d/ppSEefUxLVwuoHMnYH0ZcHGTANBgkqhkiG
// SIG // 9w0BAQsFAAOCAQEAdeqwLdU0GVwyRf4O4dRPpnjBb9fq
// SIG // 3dxP86HIgYj3p48V5kApreZd9KLZVmSEcTAq3R5hF2Yg
// SIG // VgaYGY1dcfL4l7wJ/RyRR8ni6I0D+8yQL9YKbE4z7Na0
// SIG // k8hMkGNIOUAhxN3WbomYPLWYl+ipBrcJyY9TV0GQL+Ee
// SIG // TU7cyhB4bEJu8LbF+GFcUvVO9muN90p6vvPN/QPX2fYD
// SIG // qA/jU/cKdezGdS6qZoUEmbf4Blfhxg726K/a7JsYH6q5
// SIG // 4zoAv86KlMsB257HOLsPUqvR45QDYApNoP4nbRQy/D+X
// SIG // QOG/mYnb5DkUvdrk08PqK1qzlVhVBH3HmuwjA42FKtL/
// SIG // rqlhgTCCBUswggQzoAMCAQICEHvU5a+6zAc/oQEjBCJB
// SIG // TRIwDQYJKoZIhvcNAQELBQAwdzELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMSgw
// SIG // JgYDVQQDEx9TeW1hbnRlYyBTSEEyNTYgVGltZVN0YW1w
// SIG // aW5nIENBMB4XDTE3MTIyMzAwMDAwMFoXDTI5MDMyMjIz
// SIG // NTk1OVowgYAxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRT
// SIG // eW1hbnRlYyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3lt
// SIG // YW50ZWMgVHJ1c3QgTmV0d29yazExMC8GA1UEAxMoU3lt
// SIG // YW50ZWMgU0hBMjU2IFRpbWVTdGFtcGluZyBTaWduZXIg
// SIG // LSBHMzCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoC
// SIG // ggEBAK8Oiqr43L9pe1QXcUcJvY08gfh0FXdnkJz93k4C
// SIG // nkt29uU2PmXVJCBtMPndHYPpPydKM05tForkjUCNIqq+
// SIG // pwsb0ge2PLUaJCj4G3JRPcgJiCYIOvn6QyN1R3AMs19b
// SIG // jwgdckhXZU2vAjxA9/TdMjiTP+UspvNZI8uA3hNN+RDJ
// SIG // qgoYbFVhV9HxAizEtavybCPSnw0PGWythWJp/U6FwYpS
// SIG // Matb2Ml0UuNXbCK/VX9vygarP0q3InZl7Ow28paVgSYs
// SIG // /buYqgE4068lQJsJU/ApV4VYXuqFSEEhh+XetNMmsntA
// SIG // U1h5jlIxBk2UA0XEzjwD7LcA8joixbRv5e+wipsCAwEA
// SIG // AaOCAccwggHDMAwGA1UdEwEB/wQCMAAwZgYDVR0gBF8w
// SIG // XTBbBgtghkgBhvhFAQcXAzBMMCMGCCsGAQUFBwIBFhdo
// SIG // dHRwczovL2Quc3ltY2IuY29tL2NwczAlBggrBgEFBQcC
// SIG // AjAZGhdodHRwczovL2Quc3ltY2IuY29tL3JwYTBABgNV
// SIG // HR8EOTA3MDWgM6Axhi9odHRwOi8vdHMtY3JsLndzLnN5
// SIG // bWFudGVjLmNvbS9zaGEyNTYtdHNzLWNhLmNybDAWBgNV
// SIG // HSUBAf8EDDAKBggrBgEFBQcDCDAOBgNVHQ8BAf8EBAMC
// SIG // B4AwdwYIKwYBBQUHAQEEazBpMCoGCCsGAQUFBzABhh5o
// SIG // dHRwOi8vdHMtb2NzcC53cy5zeW1hbnRlYy5jb20wOwYI
// SIG // KwYBBQUHMAKGL2h0dHA6Ly90cy1haWEud3Muc3ltYW50
// SIG // ZWMuY29tL3NoYTI1Ni10c3MtY2EuY2VyMCgGA1UdEQQh
// SIG // MB+kHTAbMRkwFwYDVQQDExBUaW1lU3RhbXAtMjA0OC02
// SIG // MB0GA1UdDgQWBBSlEwGpn4XMG24WHl87Map5NgB7HTAf
// SIG // BgNVHSMEGDAWgBSvY9bKo06FcuCnvEHzKaI4f4B1YjAN
// SIG // BgkqhkiG9w0BAQsFAAOCAQEARp6v8LiiX6KZSM+oJ0sh
// SIG // zbK5pnJwYy/jVSl7OUZO535lBliLvFeKkg0I2BC6NiT6
// SIG // Cnv7O9Niv0qUFeaC24pUbf8o/mfPcT/mMwnZolkQ9B5K
// SIG // /mXM3tRr41IpdQBKK6XMy5voqU33tBdZkkHDtz+G5vbA
// SIG // f0Q8RlwXWuOkO9VpJtUhfeGAZ35irLdOLhWa5Zwjr1sR
// SIG // 6nGpQfkNeTipoQ3PtLHaPpp6xyLFdM3fRwmGxPyRJbIb
// SIG // lumFCOjd6nRgbmClVnoNyERY3Ob5SBSe5b/eAL13sZgU
// SIG // chQk38cRLB8AP8NLFMZnHMweBqOQX1xUiz7jM1uCD8W3
// SIG // hgJOcZ/pZkU/djGCAlowggJWAgEBMIGLMHcxCzAJBgNV
// SIG // BAYTAlVTMR0wGwYDVQQKExRTeW1hbnRlYyBDb3Jwb3Jh
// SIG // dGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0
// SIG // d29yazEoMCYGA1UEAxMfU3ltYW50ZWMgU0hBMjU2IFRp
// SIG // bWVTdGFtcGluZyBDQQIQe9Tlr7rMBz+hASMEIkFNEjAL
// SIG // BglghkgBZQMEAgGggaQwGgYJKoZIhvcNAQkDMQ0GCyqG
// SIG // SIb3DQEJEAEEMBwGCSqGSIb3DQEJBTEPFw0yMDAzMjMx
// SIG // NDAyMjlaMC8GCSqGSIb3DQEJBDEiBCCz8EedZ+uWnGTc
// SIG // 5dsAU7nKbqxOldw4GgvVtZ3ziTuFazA3BgsqhkiG9w0B
// SIG // CRACLzEoMCYwJDAiBCDEdM52AH0COU4NpeTefBTGgPni
// SIG // ggE8/vZT7123H99h+DALBgkqhkiG9w0BAQEEggEAeUj7
// SIG // ee5lUsinV50KdPsvX0cueBbiPPwmQbR9Ijsnq5RFpORP
// SIG // zpdl6HDtyD1WrBYXQZx4jUZUdo7m50ubct0VScaqmptk
// SIG // ujvjyFtS050KSoC61wEWILAZ96iTGC2x+NjeH5gQXxA5
// SIG // 6fLBxyIxZ4tnJRd7YhHJ2gwFg8Ciar5v/+k4A+c5nfEi
// SIG // 5lT5ZYioypOwRgSOM17p+HTELBSZ7jVxzydV2AVEqX8r
// SIG // iFXnV5SaxU2QPaAPJYQalCMy29E7FBTAsZfA+8GH9VP6
// SIG // k0nnGFRllOedUFLftmZZ4qRwc13O/KBcJ9fIcDLyNbK2
// SIG // 9cOwX8FlWPR+IFkqFKExYAAUp7kAvQ==
// SIG // End signature block
