var topic = "<!DOCTYPE html>\r\n\n<!-- saved from url=(0024)http://docs.autodesk.com -->\r\n<html>\n   <head>\n      <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n      <meta name=\"product\" content=\"VAULT\">\n      <meta name=\"release\" content=\"2021\">\n      <meta name=\"book\" content=\"GeneralUser\">\n      <meta name=\"created\" content=\"2020-03-20\">\n      <meta name=\"topicid\" content=\"GUID-86373139-0500-4B28-A5C3-DE80A53D1AF6\">\n      <meta name=\"description\" content=\"A Bill of Materials (BOM) is a summary of items needed to manufacture a part or product.\">\n      <meta name=\"contextid\" content=\"ID_BOM_ESSENTIALS_VE\">\n      <meta name=\"topic-type\" content=\"concept\">\n      <meta name=\"audience\" content=\"user\">\n      <meta name=\"experiencelevel\" content=\"general\">\n      <title>Bills of Materials (BOMs)</title><script language=\"javascript\">var index = \'index.html\';</script></head>\n   <body height=\"100%\">\n      <div class=\"revit-legend\">\n         <ul></ul>\n      </div>\n      <div class=\"body_content\" id=\"body-content\" dir=\"ltr\"><a name=\"GUID-86373139-0500-4B28-A5C3-DE80A53D1AF6\"></a><div class=\"head\">\n            <h1>Bills of Materials (BOMs)</h1>\n         </div>\n         <p class=\"blurb\"> A Bill of Materials (BOM) is a summary of items needed to manufacture a part or product.\n            \n            <!--CPM-ContextId = \'ID_BOM_ESSENTIALS_VE\'--><a name=\"GUID-4742EBB7-9303-42FE-80F4-C5ECEED051B8\"></a> \n         </p>\n         <div><a name=\"GUID-5CD22F6F-737D-44E6-813C-725D7A59F797\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span>The BOM feature is available only in Vault Professional. \n               \n            </div>\n         </div>\n         <p><a name=\"GUID-82019D55-C5BF-42CF-AA72-2EE2111D04E9\"></a>A BOM includes item numbers, quantities, part descriptions, lifecycle state, and other\n            properties.\n            \n         </p>\n         <p>Every time a file with a BOM is assigned an item, a BOM is generated in Vault for\n            that item. BOM details differ depending on what the item represents. \n            <a name=\"UL_69CD644D0FDC406584084C090DC8253D\"></a><ul>\n               <li>An item representing a single part typically contains BOM information related only\n                  to that part.\n                  \n               </li>\n               <li> An item representing an assembly typically contains BOM information for all parts\n                  in the assembly.\n                  \n               </li>\n               <li>An item representing an assembly comprised of subassemblies and parts typically contains\n                  BOM information for all of the subassemblies.\n                  \n               </li>\n            </ul> \n         </p>\n         <div class=\"section\"><a name=\"SECTION_B4F1F67AD9E3441692F3645027B7B006\"></a> \n            <h2><a name=\"GUID-D3EFC632-2A4E-453A-972A-B17F912F12BB\"></a>What Can I Do with BOMs?\n            </h2> <a name=\"UL_25D02008CE5D41AD8507936929BF64BD\"></a><p><a name=\"GUID-31E7A53D-4E60-4B98-BD3C-C9C25400124E\"></a>BOMs are a powerful tool for tracking a product because you can: \n               \n            </p>\n            <ul>\n               <li>Update them when items are added and removed from the design. \n                  \n               </li>\n               <li>Add custom items that are outside the design process, such as grease or adhesives.\n                  \n                  \n               </li>\n               <li>Compare one BOM revision with another to see what has changed between revisions. For\n                  example, you can pinpoint exactly which parts changed between revisions of an assembly.\n                  \n                  \n               </li>\n               <li>Manually create a BOM by creating an item from scratch, and then adding items to the\n                  new item\'s BOM. \n                  \n               </li>\n               <li>Save BOM View as a Microsoft Excel spreadsheet or a comma-separated values file (.csv)\n                  so it can be analyzed or formatted in other applications for custom reports and printouts.\n                  \n                  \n               </li>\n            </ul> <a name=\"UL_B2CD5B348D4E4169A3D641DF07231B43\"></a><p class=\"list-intro\"><a name=\"GUID-705E721F-2720-4B8D-9021-1A26C9225F54\"></a> BOM Rules\n            </p>\n            <ul>\n               <li>Items that have never been released are displayed in their current state. \n                  	 \n               </li>\n               <li>If an item has been released, then the released revision is listed, even if it has\n                  been changed back to work-in-progress (WIP). \n                  	 \n               </li>\n               <li>When a part that is used in multiple assemblies is released, the new released revision\n                  of the part immediately appears in the BOM of every assembly in which it is used.\n                  \n                  	 \n               </li>\n            </ul> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_1CAAE0CDB46D4AB4ADC09764FECB1DBA\"></a> \n            <h2><a name=\"GUID-F4183A44-2071-4979-BB50-7E240D35BB27\"></a>Important BOM Terminology\n            </h2> \n            <p><a name=\"GUID-E2E12764-16E4-409C-A4CF-B44DDDFFE9EE\"></a>Knowing these terms and phrases will make understanding the help and BOM workflows\n               easier. \n               \n            </p> <a name=\"TABLE_28D285A9C2C741A5A494BF8177502EE5\"></a><div class=\"table-ruled\">\n               <table cellpadding=\"0\" cellspacing=\"0\" class=\"ruled\">\n                  <colgroup>\n                     <col>\n                     <col>\n                  </colgroup>\n                  <tr class=\"ruled-heading\">\n                     <th class=\"table-heading\"> <a name=\"GUID-1D2769CD-AF59-4681-9E78-0F0F85C20C7E\"></a><p class=\"table-heading\">Terms \n                           				\n                        </p> \n                     </th>\n                     <th class=\"table-heading\"> <a name=\"GUID-7B41FBC6-2A78-40C1-909C-D6F97327ECFE\"></a><p class=\"table-heading\">Definitions \n                           				\n                        </p> \n                     </th>\n                  </tr>\n                  <tr class=\"ruled-odd-row\">\n                     <td class=\"table-body\"> <a name=\"GUID-1B7EF11D-E57B-4987-AD0A-4CFF233FDE3A\"></a><p class=\"table-body\">BOM row is turned off \n                           				\n                        </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-B368C62C-88D5-4ACA-9CDD-BB6EF4821E87\"></a><p class=\"table-body\">Row is excluded from the BOM and BOM processes, such as lifecycle state change restrictions.\n                           \n                           				\n                        </p> \n                        <div><a name=\"GUID-7C3C025B-8106-49AC-A908-4B4E85FF3D73\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span>A row that is turned off may or may not have an item. When a row that doesn\'t have\n                              an item is turned on, an item is automatically created. \n                              				\n                           </div>\n                        </div> \n                     </td>\n                  </tr>\n                  <tr class=\"ruled-even-row\">\n                     <td class=\"table-body\"> <a name=\"GUID-1001010C-B287-422D-AA79-972820F8639B\"></a><p class=\"table-body\">BOM row is on \n                           				\n                        </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-ECC60044-D4ED-4556-AB20-D14944D8999B\"></a><p class=\"table-body\">Row is included in the BOM and BOM processes, such as lifecycle state change restrictions.\n                           \n                           				\n                        </p> \n                     </td>\n                  </tr>\n                  <tr class=\"ruled-odd-row\">\n                     <td class=\"table-body\"> <a name=\"GUID-603461ED-F30F-4E56-B8BD-9909EBAEA16A\"></a><p class=\"table-body\">BOM Components \n                           				\n                        </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-6ADC2A27-0F9D-4EA6-9DEE-894103A75ECD\"></a><p class=\"table-body\">Rows that do not have an item assigned and that are turned off. \n                           				\n                        </p> \n                     </td>\n                  </tr>\n               </table>\n            </div> \n         </div><span class=\"noindex\">\n            <div class=\"topic-list\">\n               <h4 class=\"related\">Topics in this section</h4>\n               <ul class=\"jumplist\">\n                  <li class=\"topiclist-litem\"><a href=\"GUID-16FB9835-A515-4123-AE9A-FCF69631BD34.htm\"> Bill of Materials (BOM) Status Icons</a><p>It\'s important to understand the icons and status settings for the Bill of Materials\n                        tab to best manage your BOMs. \n                     </p>\n                  </li>\n                  <li class=\"topiclist-litem\"><a href=\"GUID-3DB27901-5882-4DBC-B3EB-00F8C5D20B9A.htm\">Access the Bill of Materials (BOM) for an Item</a><p>Manage your Bill of Materials (BOM) from the Bill of Materials tab on the item record.\n                        \n                     </p>\n                  </li>\n                  <li class=\"topiclist-litem\"><a href=\"GUID-F821AE1D-54F3-4CB6-8A29-5F4B89FC42AD.htm\">View BOM Details</a><p> Control how rows are displayed in the BOM view of an Item Record to better suit your\n                        work environment. \n                     </p>\n                  </li>\n                  <li class=\"topiclist-litem\"><a href=\"GUID-92EE6E10-3429-4472-837C-1FD01E18D18B.htm\">Add a Row to a BOM</a><p> By adding rows to an existing BOM, you can add non-CAD items such as grease or adhesives.\n                        You can also account for items that are not part of the design but are required for\n                        manufacturing and shipment, such as packaging. \n                     </p>\n                  </li>\n                  <li class=\"topiclist-litem\"><a href=\"GUID-7346FE1A-69C9-460B-896C-C79DAE341DA9.htm\">Remove a Row from a BOM</a><p>Remove rows from the BOM that are no longer needed. </p>\n                  </li>\n                  <li class=\"topiclist-litem\"><a href=\"GUID-7FEA3BEB-09DE-4225-9C59-798D4A7FD5C6.htm\">Turn BOM Rows on and Off</a><p>Turn off BOM rows that you do not want included in the BOM process but still want\n                        listed on the BOM. \n                     </p>\n                  </li>\n                  <li class=\"topiclist-litem\"><a href=\"GUID-D62EF406-D197-478B-8172-C53520273241.htm\">Grouped BOM Rows</a><p>Learn about grouped BOM rows. \n                        \n                     </p>\n                  </li>\n                  <li class=\"topiclist-litem\"><a href=\"GUID-A82CE7BB-CC5E-4DA3-ACC7-D7FFA9596BF5.htm\">Reording Rows in a BOM</a><p>The order of items in the Bill of Materials is inherited from the CAD application\n                        that generated the BOM. This order can be modified. \n                     </p>\n                  </li>\n                  <li class=\"topiclist-litem\"><a href=\"GUID-68D49B60-7F76-4FD5-8A1E-60295400C9F5.htm\">Change the Position of an Item in a BOM</a><p> Each item has a position number in the Bill of Materials. This position number is\n                        a property that can be modified by the user. \n                     </p>\n                  </li>\n                  <li class=\"topiclist-litem\"><a href=\"GUID-122D1368-EDBE-4791-BCC1-1EB7F0A17EE4.htm\">Change the Quantity of an Item in a BOM</a><p> The quantity of any item can be changed in the BOM. </p>\n                  </li>\n                  <li class=\"topiclist-litem\"><a href=\"GUID-EE838970-AAF0-474F-8D84-ACF0E7ED1065.htm\">Edit a BOM Property Value</a><p> Some Item and BOM property values can be edited by clicking directly on the field\n                        in the BOM. \n                     </p>\n                  </li>\n                  <li class=\"topiclist-litem\"><a href=\"GUID-DF955970-8E45-4836-B3BF-4A5B0019301B.htm\">Assign to Item from the BOM View</a><p> Assign items and virtual components to other items from the <span class=\"char_link\"><a href=\"GUID-F821AE1D-54F3-4CB6-8A29-5F4B89FC42AD.htm\">BOM view</a></span>. \n                     </p>\n                  </li>\n                  <li class=\"topiclist-litem\"><a href=\"GUID-F5513651-0ECD-4263-9664-7F6F4C5B1C5D.htm\">Compare BOMs </a><p>You can compare the BOM from one revision with the BOM of another revision to see\n                        what has changed between revisions. You can also compare the BOM of two different\n                        items as well as two different versions of the same item. \n                     </p>\n                  </li>\n                  <li class=\"topiclist-litem\"><a href=\"GUID-BE568EC5-0C57-4928-9A3C-BAFC34102562.htm\">Go to an Item from BOM View</a><p>Go directly to an item from the Bill of Materials or Where Used tab. </p>\n                  </li>\n                  <li class=\"topiclist-litem\"><a href=\"GUID-069D6CE2-F7CE-4C90-B1AF-51B03DD62D29.htm\">Save BOM View</a><p>BOM data can be saved to a file to be analyzed or formatted in other applications.\n                        You can create specialized reports in Microsoft Excel or in other applications that\n                        read the comma-separated vales (.csv) file format for custom reports and printouts.\n                        \n                     </p>\n                  </li>\n                  <li class=\"topiclist-litem\"><a href=\"GUID-98ED1E4C-1E52-462F-B3A7-0661ED7855E9.htm\">Bill of Materials - Autodesk Inventor and Manufacturing</a><p>You can use Autodesk Inventor to manage the BOM in Vault Professional. </p>\n                  </li>\n                  <li class=\"topiclist-litem\"><a href=\"GUID-1338617E-80C5-4B85-9B83-F66260D25BCD.htm\">Create BOM Report</a><p>Create BOM reports that show Parts-level, First-level, and Multi-level views.  \n                        \n                     </p>\n                  </li>\n                  <li class=\"topiclist-litem\"><a href=\"GUID-57A898E1-4AFD-4C62-96C9-4CA4EF331E72.htm\"> Intrinsic BOM Row Properties</a><p>Learn about the intrinsic BOM row properties available in Vault. </p>\n                  </li>\n                  <li class=\"topiclist-litem\"><a href=\"GUID-E926FCEE-9774-4329-BDCD-87BB537BFE17.htm\">Customize the Bill of Materials (BOM) View</a><p>Customize how your BOMs are displayed in the preview pane and the item record. </p>\n                  </li>\n                  <li class=\"topiclist-litem\"><a href=\"GUID-EE228336-9021-4564-BC0A-25520A111A78.htm\">Search BOM View</a><p>Use the Find Panel to search listed BOMs in the BOM view, including the multi-level\n                        view. \n                     </p>\n                  </li>\n                  <li class=\"topiclist-litem\"><a href=\"GUID-FA5D824F-7860-41C1-9ABD-C81C202D14A4.htm\">Extract Item Data</a><p>Create a job that generates a BOM object for selected CAD files that are missing BOM\n                        information with the Extract Item Data command.\n                        \n                     </p>\n                  </li>\n               </ul>\n            </div></span><div class=\"footer-block\"><a href=\"..\" class=\"comments-anchor\" target=\"_blank\"><span class=\"comments-link\">Please send us your comment about this page</span></a></div><br><p class=\"footer-license-block\"><a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\"><img alt=\"Creative Commons License\" style=\"border-width: 0;\" src=\"../images/ccLink.png\"></a>&nbsp;<em>Except where otherwise noted, this work is licensed under a <a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\">Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License</a>. Please see the <a href=\"http://autodesk.com/creativecommons\" target=\"_blank\">Autodesk Creative Commons FAQ</a> for more information.</em></p><br></div>\n   </body>\n</html>";
// SIG // Begin signature block
// SIG // MIIgdwYJKoZIhvcNAQcCoIIgaDCCIGQCAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // uJ6DJk7uioBBQC/HXx8l1N8uXEsrOfgvI8s8ri9teX2g
// SIG // ggoaMIIEyzCCA7OgAwIBAgIQCQja65wGHi65un4mqmKH
// SIG // ijANBgkqhkiG9w0BAQsFADCBhDELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTUw
// SIG // MwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
// SIG // b2RlIFNpZ25pbmcgQ0EgLSBHMjAeFw0xOTA1MTQwMDAw
// SIG // MDBaFw0yMDA1MTMyMzU5NTlaMHwxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIDApDYWxpZm9ybmlhMRMwEQYDVQQHDApT
// SIG // YW4gUmFmYWVsMRcwFQYDVQQKDA5BdXRvZGVzaywgSW5j
// SIG // LjERMA8GA1UECwwIU2VjdXJpdHkxFzAVBgNVBAMMDkF1
// SIG // dG9kZXNrLCBJbmMuMIIBIjANBgkqhkiG9w0BAQEFAAOC
// SIG // AQ8AMIIBCgKCAQEAkVKRoPYsoxPdlabspcuG8HYDfcWQ
// SIG // 9qyPOT2punwpVdjt2slktcpSTlydrGy8ijcbl5/k8AOJ
// SIG // afKMQvow0fNjIoNB5nsb8j2xFJPbBhHl8GT4P6DZ1OWK
// SIG // ioiUXgGHKjctUws49J4elntqvBYhKCbuPqG772QCoYFU
// SIG // P7qcFbh3PbyNB6cnKMn2vNGRqiEtV2aGg+/MiL3QPsvT
// SIG // kTWhVuTLIvwZ4kK5C5ACiQzlGOlE+C7gWuFoxtvy6gUa
// SIG // A8JAq/xLjYKwFevQwGncg3s1cuiGhx0P7Rvn6oCd2cem
// SIG // FmbK3I3rMRt+jc9wzAj3oHxvCo4f5Lfva+OpC1dETUVV
// SIG // sk0VGwIDAQABo4IBPjCCATowCQYDVR0TBAIwADAOBgNV
// SIG // HQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMw
// SIG // YQYDVR0gBFowWDBWBgZngQwBBAEwTDAjBggrBgEFBQcC
// SIG // ARYXaHR0cHM6Ly9kLnN5bWNiLmNvbS9jcHMwJQYIKwYB
// SIG // BQUHAgIwGQwXaHR0cHM6Ly9kLnN5bWNiLmNvbS9ycGEw
// SIG // HwYDVR0jBBgwFoAU1MAGIknrOUvdk+JcobhHdglyA1gw
// SIG // KwYDVR0fBCQwIjAgoB6gHIYaaHR0cDovL3JiLnN5bWNi
// SIG // LmNvbS9yYi5jcmwwVwYIKwYBBQUHAQEESzBJMB8GCCsG
// SIG // AQUFBzABhhNodHRwOi8vcmIuc3ltY2QuY29tMCYGCCsG
// SIG // AQUFBzAChhpodHRwOi8vcmIuc3ltY2IuY29tL3JiLmNy
// SIG // dDANBgkqhkiG9w0BAQsFAAOCAQEA0Q2+iVSEfT4xGq3A
// SIG // OADVb0rT5Z8E+PPb1x6hKknSzuaZKk/acDz9mdnFajaU
// SIG // WgIKiFJlsqJnuAM1w4lqKaEWsz3DoxvGIEwexj71Ud6a
// SIG // KlBJNcR9DdkXUZwMhbw9d78rjJAIX6tOwfSludZfdq8b
// SIG // YEkuIzQi9uYW9vHVPSCzhnUBKjwc9qTo9yBc7Fcn4FAT
// SIG // 90DzWM2hS9oc3p0pprYI2I/O4th90BEmwWkVqVgfaR0z
// SIG // VyIEmBbqB/IWLfjUBZJ/8sbkwWuWlYVRrfPxsj1e9qvb
// SIG // wE3Y28jWyGbqoUG39GhXk3uT8R8i3+T6M0c4rMfdifBC
// SIG // pceCaFTJzSye7LoeVzCCBUcwggQvoAMCAQICEHwbNTVK
// SIG // 59t050FfEWnKa6gwDQYJKoZIhvcNAQELBQAwgb0xCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjEfMB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29y
// SIG // azE6MDgGA1UECxMxKGMpIDIwMDggVmVyaVNpZ24sIElu
// SIG // Yy4gLSBGb3IgYXV0aG9yaXplZCB1c2Ugb25seTE4MDYG
// SIG // A1UEAxMvVmVyaVNpZ24gVW5pdmVyc2FsIFJvb3QgQ2Vy
// SIG // dGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMTQwNzIyMDAw
// SIG // MDAwWhcNMjQwNzIxMjM1OTU5WjCBhDELMAkGA1UEBhMC
// SIG // VVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9u
// SIG // MR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3Jr
// SIG // MTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1
// SIG // NiBDb2RlIFNpZ25pbmcgQ0EgLSBHMjCCASIwDQYJKoZI
// SIG // hvcNAQEBBQADggEPADCCAQoCggEBANeVQ9Tc32euOftS
// SIG // pLYmMQRw6beOWyq6N2k1lY+7wDDnhthzu9/r0XY/ilaO
// SIG // 6y1L8FcYTrGNpTPTC3Uj1Wp5J92j0/cOh2W13q0c8fU1
// SIG // tCJRryKhwV1LkH/AWU6rnXmpAtceSbE7TYf+wnirv+9S
// SIG // rpyvCNk55ZpRPmlfMBBOcWNsWOHwIDMbD3S+W8sS4duM
// SIG // xICUcrv2RZqewSUL+6McntimCXBx7MBHTI99w94Zzj7u
// SIG // BHKOF9P/8LIFMhlM07Acn/6leCBCcEGwJoxvAMg6ABFB
// SIG // ekGwp4qRBKCZePR3tPNgKuZsUAS3FGD/DVH0qIuE/iHa
// SIG // XF599Sl5T7BEdG9tcv8CAwEAAaOCAXgwggF0MC4GCCsG
// SIG // AQUFBwEBBCIwIDAeBggrBgEFBQcwAYYSaHR0cDovL3Mu
// SIG // c3ltY2QuY29tMBIGA1UdEwEB/wQIMAYBAf8CAQAwZgYD
// SIG // VR0gBF8wXTBbBgtghkgBhvhFAQcXAzBMMCMGCCsGAQUF
// SIG // BwIBFhdodHRwczovL2Quc3ltY2IuY29tL2NwczAlBggr
// SIG // BgEFBQcCAjAZGhdodHRwczovL2Quc3ltY2IuY29tL3Jw
// SIG // YTA2BgNVHR8ELzAtMCugKaAnhiVodHRwOi8vcy5zeW1j
// SIG // Yi5jb20vdW5pdmVyc2FsLXJvb3QuY3JsMBMGA1UdJQQM
// SIG // MAoGCCsGAQUFBwMDMA4GA1UdDwEB/wQEAwIBBjApBgNV
// SIG // HREEIjAgpB4wHDEaMBgGA1UEAxMRU3ltYW50ZWNQS0kt
// SIG // MS03MjQwHQYDVR0OBBYEFNTABiJJ6zlL3ZPiXKG4R3YJ
// SIG // cgNYMB8GA1UdIwQYMBaAFLZ3+mlIR59TEtXC6gcydgfR
// SIG // lwcZMA0GCSqGSIb3DQEBCwUAA4IBAQB/68qn6ot2Qus+
// SIG // jiBUMOO3udz6SD4Wxw9FlRDNJ4ajZvMC7XH4qsJVl5Fw
// SIG // g/lSflJpPMnx4JRGgBi7odSkVqbzHQCR1YbzSIfgy8Q0
// SIG // aCBetMv5Be2cr3BTJ7noPn5RoGlxi9xR7YA6JTKfRK9u
// SIG // QyjTIXW7l9iLi4z+qQRGBIX3FZxLEY3ELBf+1W5/muJW
// SIG // kvGWs60t+fTf2omZzrI4RMD3R3vKJbn6Kmgzm1By3qif
// SIG // 1M0sCzS9izB4QOCNjicbkG8avggVgV3rL+JR51EeyXgp
// SIG // 5x5lvzjvAUoBCSQOFsQUecFBNzTQPZFSlJ3haO8I8OJp
// SIG // nGdukAsak3HUJgLDwFojMYIVtTCCFbECAQEwgZkwgYQx
// SIG // CzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRlYyBD
// SIG // b3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1
// SIG // c3QgTmV0d29yazE1MDMGA1UEAxMsU3ltYW50ZWMgQ2xh
// SIG // c3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENBIC0gRzIC
// SIG // EAkI2uucBh4uubp+Jqpih4owDQYJYIZIAWUDBAIBBQCg
// SIG // fDAQBgorBgEEAYI3AgEMMQIwADAZBgkqhkiG9w0BCQMx
// SIG // DAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4wDAYK
// SIG // KwYBBAGCNwIBFTAvBgkqhkiG9w0BCQQxIgQgqGfzsOJJ
// SIG // wLtLL3AZnaxymsACOVySLsc7/TG/HX/YY74wDQYJKoZI
// SIG // hvcNAQEBBQAEggEAFykz821Yh+rWbWzOym+vWARHnPT4
// SIG // jUB64CTkZvNE5cDCEqrORJjLMF8wlOJ5PIVlXqKPpGzb
// SIG // 2qWdbQzFoLpSgTGKm20bR/zxIf9+pibnq17HuJ2eAAmE
// SIG // fg/TfKWT6Rrg0qlP6n1gyJaOJQv4LF2KF7135QgsE6OY
// SIG // fTs5EfEcaFogWGvjia34+E8sSck45X4HIAblwRodussO
// SIG // s1FQblBWCrf6fXMvLt97wU1UVEpzkihqyjTm86xHzB4m
// SIG // LOkFwoavEMP0HMsYKx2jUgEAd/QevyWNj2lwQhGHPIdS
// SIG // pTBChWqIMzuF2duLkOfSVlLWR5yIRougXmo3utfND6qr
// SIG // F6R6zqGCE24wghNqBgorBgEEAYI3AwMBMYITWjCCE1YG
// SIG // CSqGSIb3DQEHAqCCE0cwghNDAgEDMQ8wDQYJYIZIAWUD
// SIG // BAIBBQAwggENBgsqhkiG9w0BCRABBKCB/QSB+jCB9wIB
// SIG // AQYKKwYBBAGyMQIBATAxMA0GCWCGSAFlAwQCAQUABCAP
// SIG // pd/c4MGBUzeBhS3JKhjNkLT4FIOoMllRb6a+ozVycwIV
// SIG // APQ1NU+8umkrrJJpAmp/+maCb2MaGA8yMDIwMDMyMzE0
// SIG // MDYzNFqggYqkgYcwgYQxCzAJBgNVBAYTAkdCMRswGQYD
// SIG // VQQIDBJHcmVhdGVyIE1hbmNoZXN0ZXIxEDAOBgNVBAcM
// SIG // B1NhbGZvcmQxGDAWBgNVBAoMD1NlY3RpZ28gTGltaXRl
// SIG // ZDEsMCoGA1UEAwwjU2VjdGlnbyBSU0EgVGltZSBTdGFt
// SIG // cGluZyBTaWduZXIgIzGggg36MIIHBjCCBO6gAwIBAgIQ
// SIG // PRo1cjAVgmMw0BNxfoJBCDANBgkqhkiG9w0BAQwFADB9
// SIG // MQswCQYDVQQGEwJHQjEbMBkGA1UECBMSR3JlYXRlciBN
// SIG // YW5jaGVzdGVyMRAwDgYDVQQHEwdTYWxmb3JkMRgwFgYD
// SIG // VQQKEw9TZWN0aWdvIExpbWl0ZWQxJTAjBgNVBAMTHFNl
// SIG // Y3RpZ28gUlNBIFRpbWUgU3RhbXBpbmcgQ0EwHhcNMTkw
// SIG // NTAyMDAwMDAwWhcNMzAwODAxMjM1OTU5WjCBhDELMAkG
// SIG // A1UEBhMCR0IxGzAZBgNVBAgMEkdyZWF0ZXIgTWFuY2hl
// SIG // c3RlcjEQMA4GA1UEBwwHU2FsZm9yZDEYMBYGA1UECgwP
// SIG // U2VjdGlnbyBMaW1pdGVkMSwwKgYDVQQDDCNTZWN0aWdv
// SIG // IFJTQSBUaW1lIFN0YW1waW5nIFNpZ25lciAjMTCCAiIw
// SIG // DQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBAMtRUP9W
// SIG // /vx4Y3ABk1qeGPQ7U/YHryFs9aIPfR1wLYR0SIucipUF
// SIG // PVmE+ZGAeVEs2Yq3wQuaugqKzWZPA4sBuzDKq73bwE8S
// SIG // XvwKzOJFsAE4irtN59QcVJjtOVjPW8IvRZgxCvk1OLgx
// SIG // Lm20Hjly4bgqvp+MjBqlRq4LK0yZ/ixL/Ci5IjpmF9Cq
// SIG // VoohwPOWJLTQhSZruvBvZJh5pq29XNhTaysK1nKKhUbj
// SIG // DRgG2sZ7QVY2mxU+8WoRoPdm9RjQgFVjh2hm6w55VYJc
// SIG // o+1JuHGGnpM3sGuj6mJso66W6Ln9i6vG9llbADxXIBgt
// SIG // cAOnnO+S63mhx13sfLSPS9/rXfyjIN2SOOVqUTprhZxM
// SIG // oJgIaVsG5yoZ0JWTiztrigUJKdjW2tvjcvpcSi97FVaG
// SIG // Mr9/BQmdLSrPUOHmYSDbxwaAXE4URr6uV3Giqmwwkxx+
// SIG // d8sG6VfNkfXVM3Ic4drKbuvzD+x5W7snnuge/i/yu3/p
// SIG // 5dBn67gNfKQrWQOLle0iKM36LDvHFhGv49axUGdpxY71
// SIG // edCt/4fM+H+q+aLtYfjIjWnasfRRketnV9FkEetkywO9
// SIG // SVU6RUMYLCVs0S8MLW/1QTUkoPJjWRZf2aTpLE7buzES
// SIG // xm34W24D3MsVjxuNcuzbDxWQ1hJO7uIAMSWTNW9qW6US
// SIG // Y0ABirlpiDqIuA8ZAgMBAAGjggF4MIIBdDAfBgNVHSME
// SIG // GDAWgBQaofhhGSAPw0F3RSiO0TVfBhIEVTAdBgNVHQ4E
// SIG // FgQUb02GB9gyJ54sKdLQEwOAgd0FgykwDgYDVR0PAQH/
// SIG // BAQDAgbAMAwGA1UdEwEB/wQCMAAwFgYDVR0lAQH/BAww
// SIG // CgYIKwYBBQUHAwgwQAYDVR0gBDkwNzA1BgwrBgEEAbIx
// SIG // AQIBAwgwJTAjBggrBgEFBQcCARYXaHR0cHM6Ly9zZWN0
// SIG // aWdvLmNvbS9DUFMwRAYDVR0fBD0wOzA5oDegNYYzaHR0
// SIG // cDovL2NybC5zZWN0aWdvLmNvbS9TZWN0aWdvUlNBVGlt
// SIG // ZVN0YW1waW5nQ0EuY3JsMHQGCCsGAQUFBwEBBGgwZjA/
// SIG // BggrBgEFBQcwAoYzaHR0cDovL2NydC5zZWN0aWdvLmNv
// SIG // bS9TZWN0aWdvUlNBVGltZVN0YW1waW5nQ0EuY3J0MCMG
// SIG // CCsGAQUFBzABhhdodHRwOi8vb2NzcC5zZWN0aWdvLmNv
// SIG // bTANBgkqhkiG9w0BAQwFAAOCAgEAwGjts9jUUJvv03XL
// SIG // Dzv3JNN6N0WNLO8W+1GpLB+1JbWKn10LwhsgdI1mDzbL
// SIG // qvY2DQ9+j0tKdENlrA0q9grta23FCTjtABv45dymCkAF
// SIG // R++Eygm8Q2aDv5/t24490UFksXACLQNXWxhvHCzLHrIA
// SIG // 6LoJL1uBBDW5qWNtjgjFGNHhIaz5EgoUwBLbfiWdrB0Q
// SIG // wFqlg9IfGmZV/Jsq4uw3V47l35Yw+MCTC0MY+QJvqVGv
// SIG // uFcK8xwHaTmPN5xt15GupS5J6Ures9CMvzmQDcCBzvAq
// SIG // BzoMpi1R0nLzU8b5ve/vDGlJd58sVsTpoQg9B67FHtaE
// SIG // Ise8fUMbWDhiTtEFJYTFQvgfL/bb+quMVOxFimwSTTBa
// SIG // UuWkFwki5u9v9V+GQ9+hLb1KRpKggZYsYZd/QG/YP4w1
// SIG // WqvRxqA7hWZUgO8fGvXxm7ChJ32y5wvP9i2cWBOUqYb8
// SIG // RVKiKG1/dA9SkUl66RL4qTuwkv19kRTpW21IlPLIlu4F
// SIG // OLPF7DA/4QcgBLHYi7z9sz5v8gJTBvSg7cmacqOXXwD7
// SIG // y2PQ6M10/XXJ1DZFunsSWXLt5/J6UAB4+EOaRtjfv1TU
// SIG // XrHH0bwbg/Qr5wvoR8hTnswarPb6inVTbCCFqdW4arok
// SIG // joorCJGfNwQc9m+i3TSqkf/GFS4eQhoJKU/0xs3ikaLT
// SIG // QAyOeOMwggbsMIIE1KADAgECAhAwD2+s3WaYdHypRjan
// SIG // eC25MA0GCSqGSIb3DQEBDAUAMIGIMQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKTmV3IEplcnNleTEUMBIGA1UEBxML
// SIG // SmVyc2V5IENpdHkxHjAcBgNVBAoTFVRoZSBVU0VSVFJV
// SIG // U1QgTmV0d29yazEuMCwGA1UEAxMlVVNFUlRydXN0IFJT
// SIG // QSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAeFw0xOTA1
// SIG // MDIwMDAwMDBaFw0zODAxMTgyMzU5NTlaMH0xCzAJBgNV
// SIG // BAYTAkdCMRswGQYDVQQIExJHcmVhdGVyIE1hbmNoZXN0
// SIG // ZXIxEDAOBgNVBAcTB1NhbGZvcmQxGDAWBgNVBAoTD1Nl
// SIG // Y3RpZ28gTGltaXRlZDElMCMGA1UEAxMcU2VjdGlnbyBS
// SIG // U0EgVGltZSBTdGFtcGluZyBDQTCCAiIwDQYJKoZIhvcN
// SIG // AQEBBQADggIPADCCAgoCggIBAMgbAa/ZLH6ImX0BmD8g
// SIG // kL2cgCFUk7nPoD5T77NawHbWGgSlzkeDtevEzEk0y/NF
// SIG // Zbn5p2QWJgn71TJSeS7JY8ITm7aGPwEFkmZvIavVcRB5
// SIG // h/RGKs3EWsnb111JTXJWD9zJ41OYOioe/M5YSdO/8zm7
// SIG // uaQjQqzQFcN/nqJc1zjxFrJw06PE37PFcqwuCnf8DZRS
// SIG // t/wflXMkPQEovA8NT7ORAY5unSd1VdEXOzQhe5cBlK9/
// SIG // gM/REQpXhMl/VuC9RpyCvpSdv7QgsGB+uE31DT/b0OqF
// SIG // jIpWcdEtlEzIjDzTFKKcvSb/01Mgx2Bpm1gKVPQF5/0x
// SIG // rPnIhRfHuCkZpCkvRuPd25Ffnz82Pg4wZytGtzWvlr7a
// SIG // TGDMqLufDRTUGMQwmHSCIc9iVrUhcxIe/arKCFiHd6QV
// SIG // 6xlV/9A5VC0m7kUaOm/N14Tw1/AoxU9kgwLU++Le8bwC
// SIG // KPRt2ieKBtKWh97oaw7wW33pdmmTIBxKlyx3GSuTlZic
// SIG // l57rjsF4VsZEJd8GEpoGLZ8DXv2DolNnyrH6jaFkyYiS
// SIG // WcuoRsDJ8qb/fVfbEnb6ikEk1Bv8cqUUotStQxykSYtB
// SIG // ORQDHin6G6UirqXDTYLQjdprt9v3GEBXc/Bxo/tKfUU2
// SIG // wfeNgvq5yQ1TgH36tjlYMu9vGFCJ10+dM70atZ2h3pVB
// SIG // eqeDAgMBAAGjggFaMIIBVjAfBgNVHSMEGDAWgBRTeb9a
// SIG // qitKz1SA4dibwJ3ysgNmyzAdBgNVHQ4EFgQUGqH4YRkg
// SIG // D8NBd0UojtE1XwYSBFUwDgYDVR0PAQH/BAQDAgGGMBIG
// SIG // A1UdEwEB/wQIMAYBAf8CAQAwEwYDVR0lBAwwCgYIKwYB
// SIG // BQUHAwgwEQYDVR0gBAowCDAGBgRVHSAAMFAGA1UdHwRJ
// SIG // MEcwRaBDoEGGP2h0dHA6Ly9jcmwudXNlcnRydXN0LmNv
// SIG // bS9VU0VSVHJ1c3RSU0FDZXJ0aWZpY2F0aW9uQXV0aG9y
// SIG // aXR5LmNybDB2BggrBgEFBQcBAQRqMGgwPwYIKwYBBQUH
// SIG // MAKGM2h0dHA6Ly9jcnQudXNlcnRydXN0LmNvbS9VU0VS
// SIG // VHJ1c3RSU0FBZGRUcnVzdENBLmNydDAlBggrBgEFBQcw
// SIG // AYYZaHR0cDovL29jc3AudXNlcnRydXN0LmNvbTANBgkq
// SIG // hkiG9w0BAQwFAAOCAgEAbVSBpTNdFuG1U4GRdd8DejIL
// SIG // LSWEEbKw2yp9KgX1vDsn9FqguUlZkClsYcu1UNviffmf
// SIG // AO9Aw63T4uRW+VhBz/FC5RB9/7B0H4/GXAn5M17qoBwm
// SIG // WFzztBEP1dXD4rzVWHi/SHbhRGdtj7BDEA+N5Pk4Yr8T
// SIG // AcWFo0zFzLJTMJWk1vSWVgi4zVx/AZa+clJqO0I3fBZ4
// SIG // OZOTlJux3LJtQW1nzclvkD1/RXLBGyPWwlWEZuSzxWYG
// SIG // 9vPWS16toytCiiGS/qhvWiVwYoFzY16gu9jc10rTPa+D
// SIG // BjgSHSSHLeT8AtY+dwS8BDa153fLnC6NIxi5o8JHHfBd
// SIG // 1qFzVwVomqfJN2Udvuq82EKDQwWli6YJ/9GhlKZOqj0J
// SIG // 9QVst9JkWtgqIsJLnfE5XkzeSD2bNJaaCV+O/fexUpHO
// SIG // P4n2HKG1qXUfcb9bQ11lPVCBbqvw0NP8srMftpmWJvQ8
// SIG // eYtcZMzN7iea5aDADHKHwW5NWtMe6vBE5jJvHOsXTpTD
// SIG // eGUgOw9Bqh/poUGd/rG4oGUqNODeqPk85sEwu8CgYyz8
// SIG // XBYAqNDEf+oRnR4GxqZtMl20OAkrSQeq/eww2vGnL8+3
// SIG // /frQo4TZJ577AWZ3uVYQ4SBuxq6x+ba6yDVdM3aO8Xwg
// SIG // DCp3rrWiAoa6Ke60WgCxjKvj+QrJVF3UuWp0nr1Irpgx
// SIG // ggQcMIIEGAIBATCBkTB9MQswCQYDVQQGEwJHQjEbMBkG
// SIG // A1UECBMSR3JlYXRlciBNYW5jaGVzdGVyMRAwDgYDVQQH
// SIG // EwdTYWxmb3JkMRgwFgYDVQQKEw9TZWN0aWdvIExpbWl0
// SIG // ZWQxJTAjBgNVBAMTHFNlY3RpZ28gUlNBIFRpbWUgU3Rh
// SIG // bXBpbmcgQ0ECED0aNXIwFYJjMNATcX6CQQgwDQYJYIZI
// SIG // AWUDBAIBBQCgggFbMBoGCSqGSIb3DQEJAzENBgsqhkiG
// SIG // 9w0BCRABBDAcBgkqhkiG9w0BCQUxDxcNMjAwMzIzMTQw
// SIG // NjM0WjAvBgkqhkiG9w0BCQQxIgQgo4Sz7Y9KLDG6JxUG
// SIG // 3LRMRhDfw4aQHKynuCBVWwm8JSYwge0GCyqGSIb3DQEJ
// SIG // EAIMMYHdMIHaMIHXMBYEFCXIrHNOSFC3+NkTkagbkkk2
// SIG // ZZ9hMIG8BBQC1luV4oNwwVcAlfqI+SPdk3+tjzCBozCB
// SIG // jqSBizCBiDELMAkGA1UEBhMCVVMxEzARBgNVBAgTCk5l
// SIG // dyBKZXJzZXkxFDASBgNVBAcTC0plcnNleSBDaXR5MR4w
// SIG // HAYDVQQKExVUaGUgVVNFUlRSVVNUIE5ldHdvcmsxLjAs
// SIG // BgNVBAMTJVVTRVJUcnVzdCBSU0EgQ2VydGlmaWNhdGlv
// SIG // biBBdXRob3JpdHkCEDAPb6zdZph0fKlGNqd4LbkwDQYJ
// SIG // KoZIhvcNAQEBBQAEggIAeorWqfcc03mF0B38GhjYgVIQ
// SIG // Ppy69HAcBXvAcnhXgUie2nYfVUJ/AOuBM7iOrCvg9Mlr
// SIG // Ax7qzwv+XUQsW29y+oETikDHBP/w/1zksyroKn4Jd3vS
// SIG // mLDR7dFKvbTodfOLBap4HGHkdb+9hZPP928jonjdJUWH
// SIG // vI37uUhPutDJg5Ue+AqaYKyavGLMfSL1Ums/c0IPiv6+
// SIG // KYlCyXPXHKYIgmhsetNiSWwItpU0LvTPp0NwF4UQtbVX
// SIG // G2V+GgyQBjYSgCmdDzUspN9hNa1i0PjQjsICi7tG/GPc
// SIG // ol4/W1FZZ8ElmyM/lZbp3Nb4fkwgmnfoTzgxqSvxSkGB
// SIG // JqJyazwHNI4C5bV/C3IVaQuFukaPGD5AdeBdHiGbwMSJ
// SIG // XvjrbwmO0x2kxW7J8kia+oymSNCLvSUvmFAmt4/buZUh
// SIG // WxfLjYWbWodhoXbd/GWWZcNC0dvkqTvQ6M3bJ8a/tzME
// SIG // vC6yPE2GTdZufad9Sd6x/JysEPqnJ0uTVnd/ohUQwXQO
// SIG // W+dIQITn7IUPTEU0RVUd6ySV8xsepY4IQkZrgyCp3xOg
// SIG // o5GgSXKHxcgNMcnlotFrtjaemgS4MxeimTDF0NcFkB+v
// SIG // +MlQFFKfwxYKlrci/e5x0P4HR0oJ+Z/kslOZkV2HzVzL
// SIG // 3MrodrDTAuyauw9csmUfjDdmX/43OLFLYnM3lxTNQsc=
// SIG // End signature block
