var topic = "<!DOCTYPE html>\r\n\n<!-- saved from url=(0024)http://docs.autodesk.com -->\r\n<html>\n   <head>\n      <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n      <meta name=\"product\" content=\"VAULT\">\n      <meta name=\"release\" content=\"2021\">\n      <meta name=\"book\" content=\"GeneralUser\">\n      <meta name=\"created\" content=\"2020-03-20\">\n      <meta name=\"topicid\" content=\"GUID-6E35739D-CBCC-4211-9051-E451EBE3360C\">\n      <meta name=\"description\" content=\"Learn about SQL Administration tasks that apply to Autodesk Vault.\">\n      <meta name=\"indexterm\" content=\"Microsoft SQL: installing\">\n      <meta name=\"contextid\" content=\"ID_DBLOGIN\">\n      <meta name=\"contextid\" content=\"ID_EXISTINGDB\">\n      <meta name=\"contextid\" content=\"INST_PASSWORDS_INFO\">\n      <meta name=\"contextid\" content=\"INST_REG_INFO\">\n      <meta name=\"topic-type\" content=\"concept\">\n      <meta name=\"audience\" content=\"user\">\n      <meta name=\"experiencelevel\" content=\"general\">\n      <title>SQL Administration Tasks for Autodesk Vault</title><script language=\"javascript\">var index = \'index.html\';</script></head>\n   <body height=\"100%\">\n      <div class=\"body_content\" id=\"body-content\" dir=\"ltr\"><a name=\"GUID-6E35739D-CBCC-4211-9051-E451EBE3360C\"></a><div class=\"head\">\n            <h1>SQL Administration Tasks for Autodesk Vault</h1>\n         </div>\n         <p class=\"blurb\">Learn about SQL Administration tasks that apply to Autodesk Vault. \n            <!--CPM-ContextId = \'ID_DBLOGIN\'--><a name=\"GUID-E6A7D966-4301-4499-9D7F-9A7CB83BD305\"></a> \n            <!--CPM-ContextId = \'ID_EXISTINGDB\'--><a name=\"GUID-4101F188-2290-4A02-A366-0674653AD0AD\"></a> \n            <!--CPM-ContextId = \'INST_PASSWORDS_INFO\'--><a name=\"GUID-032DA0A0-52E5-46D7-9D06-FA23821778AC\"></a> \n            <!--CPM-ContextId = \'INST_REG_INFO\'--><a name=\"GUID-FB9A0F57-7A71-4273-B08F-094C11164DBD\"></a> \n         </p>\n         <div class=\"section\"><a name=\"SECTION_CA9A13FCB62D476B8D9162CFCFD4E9C3\"></a> \n            <h2><a name=\"GUID-C402E10D-10A6-4487-8C04-612D2629E1A7\"></a>Default SQL Server Administrator Account and Password\n            </h2> \n            <p><a name=\"GUID-A3C7B7B3-E506-44A2-98B6-03DBAB954040\"></a>Microsoft SQL Server creates a default administrator account named \n               	 <em class=\"strong\">SA</em>. This account has full administrative privileges as well as ownership of system tables.\n               When Vault installs SQL Server, it will configure the SA account with this default\n               password. As long as you do not change the sa account password, the ADMS Console will\n               not require you to enter it for commands that require a password. \n               \n            </p> \n            <p>If the sa account password is changed, you must enter the new password when you perform\n               certain administrative commands which require it, such as attaching vaults. \n               \n            </p> \n            <p><a name=\"GUID-FFA8C22E-9C79-432A-94E1-624133C6D220\"></a> <em class=\"strong\">SA Account Password Default</em> \n            </p> <a name=\"UL_86E0A7D959904DECBA1EE6E57D20B8DD\"></a><ul>\n               <li>The default password for the SA account is \n                  		<em class=\"strong\">AutodeskVault@26200</em>. \n                  	 \n               </li>\n            </ul> \n            <p><a name=\"GUID-6587816F-5B73-405F-A88D-C855EB4E3C25\"></a>A system administrator can change the default SA password for security reasons. After\n               the password has been changed, some ADMS Console commands will require the administrator\n               to type in the new password each time these commands are executed. The new password\n               needs to be stored in a secure location for this reason. \n               \n            </p> \n            <p><a name=\"GUID-5A59DF29-C27B-4581-BF88-8C349C85C7F0\"></a>Autodesk Vault also creates the Vaultsys SQL user account for SQL transactions. This\n               password can be changed using the SQL Server Management Studio. If a system administrator\n               does change the Vaultsys password, he or she must update the password stored in the\n               ADMS Console. \n               \n            </p> \n            <p>If you plan on deploying replication, create a \"replication user\" on the domain. This\n               is a designated account used to handle replication between workgroups. Autodesk recommends\n               that you use a strong password for this account, one that ideally never expires. \n               \n            </p> \n            <p><a name=\"GUID-CA56D0A8-25C8-499D-8460-F02F0BD0C8CD\"></a>Note: if you are adding Vault Server (ADMS) sites to a Subscriber/Publisher, the ADMS\n               Installation will reset the Vaultsys password in the SQL Server with the default.\n               It will have to be changed back to your custom password immediately after the installation\n               otherwise user will not be able to access Vault. \n               \n            </p> \n            <p><a name=\"GUID-F23CAFDD-E044-48A7-8EAC-36FE014E5DDC\"></a>For each ADMS Console installed, there is a SQL Login user created ADMS-[Servername]\n               in the SQL Server. \n               \n            </p> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_E2001D62686A4E4FA6F53604890D4BFF\"></a> \n            <h2><a name=\"GUID-8F9EE058-0913-4011-ACE8-7FD251F2F8D2\"></a>Microsoft SQL Requirements\n            </h2> \n            <p><a name=\"GUID-5B93B040-3E40-4CE2-97C4-2C59DF4A2AA6\"></a> <em class=\"mild\">Single Site Requirements</em> and<em class=\"mild\">Replication Requirements</em> see \n               	 <a href=\"http://www.autodesk.com/Vault-system\" target=\"_blank\">Vault System Requirements</a>. \n               \n            </p> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_99145B6290054FE7BF779B48D45256C1\"></a> \n            <h2><a name=\"GUID-12985734-2816-4594-99B8-2DAC8188D0F3\"></a>Log into SQL Server\n            </h2> \n            <p><a name=\"GUID-A1B657A5-E42E-4A65-9AC7-B1B6CDFC1ED7\"></a>If the default sa password for the SQL server has been changed, you must log into\n               the SQL server using the new sa password. If you do not know the sa password, contact\n               your SQL server administrator. \n               \n            </p> <a name=\"GUID-1CCA9778-0356-47DD-812C-B0050BC0B0D8\"></a><ol type=\"1\" start=\"1\">\n               <li>Enter the user name for the sa account. The default is sa. \n                  	 \n               </li>\n               <li>Enter the password for the SQL sa account. \n                  	 \n               </li>\n               <li>Click OK. \n                  	 \n               </li>\n            </ol> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_40ECE120807A4E3E9888CFECB5C27389\"></a> \n            <h2><a name=\"GUID-35A63307-57FA-4432-B3B2-29B60C8635C9\"></a>Install Microsoft SQL Server Prior to Installing Autodesk Vault Server\n            </h2> \n            <p><a name=\"GUID-D84CE19C-32F4-4A93-9BE5-A5BCF62E0ACD\"></a>Install Microsoft SQL Server Prior to Vault Server. \n               \n            </p> \n            <div class=\"section\"><a name=\"SECTION_C5D89DF1F87E4449BE34049331DCECC7\"></a> \n               <h3><a name=\"GUID-99C51D6A-59D9-4E28-8AD1-7AE5D7976DE3\"></a> Install SQL 2017 Server\n               </h3> <a name=\"OL_98C9DAC8B27A4F098E14D7C6CE52204A\"></a><ol type=\"1\" start=\"1\">\n                  <li>Start the installation process by selecting New SQL Server stand-alone installation\n                     or add features to an existing installation from the installation menu. \n                     		\n                  </li>\n                  <li>The installation process installs any necessary prerequisites and begins running the\n                     pre-installation checks. \n                     		  \n                     <div><a name=\"GUID-FDE6F6DD-8333-4822-90BE-4D79BAF77AFD\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span>If there are any errors, take the necessary corrective actions before continuing.\n                           \n                           		  \n                        </div>\n                     </div> \n                  </li>\n                  <li>During Setup Role, select SQL Server Feature Installation and click Next. \n                     		\n                  </li>\n                  <li> In the Feature Selection window, select Database Engine Services and any roles required\n                     by the environment. You can also specify the installation location at this point.\n                     \n                     		  \n                     <div><a name=\"GUID-8DEA2694-675B-45F1-BE06-C075B948EA60\"></a><div class=\"note-important\"><span class=\"label label-target-language\">IMPORTANT:</span>Under Database Engine Services, Autodesk recommends that you enable SQL Server Replication,\n                           even if you do not immediately plan on deploying a replication environment. Enabling\n                           this does not impact a single site installation, and makes it easier to move to a\n                           replicated deployment later on if you choose to. Autodesk also recommends enabling\n                           Management Tools and the SQL Client Connectivity SDK. \n                           		  \n                        </div>\n                     </div> \n                     <div><a name=\"GUID-A4ED98EC-95A4-4554-B55B-CDA53C496585\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span>Management Tools-Basic is available in the Express version of SQL Server. \n                           		  \n                        </div>\n                     </div> \n                  </li>\n                  <li>Click Next. \n                     		\n                  </li>\n                  <li>In the Instance Configuration window, select Named instance and enter the name. Use\n                     AutodeskVault, for example. \n                     		  \n                     <p><a name=\"GUID-F9DCD792-0769-466C-BDFA-91EE2205EDD9\"></a>  \n                     </p> <a name=\"FIG_E7AB8F95CB0F4660B3D11A2CC2637B2B\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-053BCDF6-25A0-4DDA-8D56-B121D63FEF39-low.png\"></div> \n                     <p><a name=\"GUID-8D61D561-A989-42B6-AFCB-F6AFA0A3C0BC\"></a>  \n                     </p> \n                  </li>\n                  <li>Click Next. \n                     		\n                  </li>\n                  <li>In the Server Configuration window, select the Service Accounts tab. \n                     		  <a name=\"UL_CB57CA5DFC9844BCB6CAFAB04B94A730\"></a><ul>\n                        <li>Specify the NT AUTHORITY\\NETWORK SERVICE account for the SQL Server Database Engine.\n                           The local system account is also acceptable to use. If you plan to perform backups\n                           and restores to remote locations, specify a Domain User account. Set the Startup Type\n                           to Automatic. \n                           				\n                           <p><a name=\"GUID-F2635B54-4294-4B0B-8234-949A0DA67B17\"></a>  \n                           </p> <a name=\"FIG_276ED05B6CBC4605A892197D7D7CDED9\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-D268D4DC-437B-4CB2-B4B8-68AB4CE4D96A-low.png\"></div> \n                        </li>\n                     </ul> \n                  </li>\n                  <li>Click Next. \n                     		\n                  </li>\n                  <li>In the Database Engine Configuration window, select the Server Configuration Tab and\n                     perform the following steps: \n                     		  <a name=\"OL_02C2511B2B874D50A6BF003DBDDD29E0\"></a><ol type=\"1\" start=\"1\">\n                        <li>Select Mixed Mode authentication and set the SA password. The default password used\n                           during a default installation for the SA account is AutodeskVault@26200. \n                           			 \n                        </li>\n                        <li>Add the local administrator account (or desired account) as a SQL Server administrator.\n                           Only Windows users entered in this dialog have full rights when logging into the SQL\n                           server. All other Windows logins are treated as guest accounts. \n                           			 \n                        </li>\n                     </ol> <a name=\"FIG_3C5F59CACC04439BAD50C4261292112F\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-7F6AA7E8-8DAD-4492-BB47-7EFA543A8498-low.png\"></div> \n                     <p><a name=\"GUID-5A1F9EEA-8895-4DC7-ADF0-C028559098A5\"></a>  \n                     </p> \n                  </li>\n                  <li>Click Next. \n                     		\n                  </li>\n                  <li>Verify the installation options chosen and Install. Once the installer is finished,\n                     it can be closed. \n                     		\n                  </li>\n                  <li>Download and install applicable service packs and hot fixes from Microsoft\'s web site\n                     if needed. \n                     		\n                  </li>\n               </ol> \n            </div> \n            <div class=\"section\"><a name=\"SECTION_6AC12A7893154C11AA7581FD86278932\"></a> \n               <h3><a name=\"GUID-62666E44-CE5D-48E0-804A-2FA94D8AA341\"></a>Reconfigure SQL Logins\n               </h3> \n               <p><a name=\"GUID-F52DB6B9-6FAF-4908-8D24-AD410F9AEF44\"></a>If you don\'t have a domain password policy, you can skip this section. If your domain\n                  has a password policy configured, use a password that complies with the policy. After\n                  the installation is complete, reset the sa password to AutodeskVault@26200 and uncheck\n                  the Enforce password policy check box. It is also necessary to create a SQL login\n                  account named VaultSys. \n                  	 \n               </p> <a name=\"OL_4628ADE13F1B40A1B2671C2645EBAEE4\"></a><p class=\"list-intro\"><a name=\"GUID-D69CD2F7-4826-4584-9560-FF7C40242047\"></a>Create a SQL login account\n               </p>\n               <ol type=\"1\" start=\"1\">\n                  <li>Open the Microsoft SQL Server Management Studio. \n                     		\n                  </li>\n                  <li>Expand the Security -&gt; Logins folder. \n                     		\n                  </li>\n                  <li>Right-click on the Logins folder and select New Login. \n                     		\n                  </li>\n                  <li>Type VaultSys for the login name. \n                     		\n                  </li>\n                  <li>Select SQL Server Authentication. \n                     		\n                  </li>\n                  <li>Type SuperMan769400006! as the password. \n                     		\n                  </li>\n                  <li>Uncheck the box for Enforce password policy. \n                     		  \n                     <p><a name=\"GUID-3A2318B2-3A90-4605-968A-5EC65360771C\"></a>  \n                     </p> <a name=\"FIG_D92BDD4B7B0C4E59AC54C6C70DD8F63B\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-E113C120-57E8-4321-8862-5583FA7C9C41-low.png\"></div> \n                  </li>\n               </ol>\n               <p><a name=\"GUID-478E2459-7DB0-48A5-9B3B-52085FECE8D6\"></a>  \n               </p>\n               <ol type=\"1\" start=\"8\">\n                  <li>Select the Server Roles page. \n                     	 \n                  </li>\n                  <li>Check the boxes next to the following roles: \n                     		<a name=\"UL_C09EFF33D4B3491092F7CA01B9E406B8\"></a><ul>\n                        <li>dbcreator \n                           		  \n                        </li>\n                        <li>processadmin \n                           		  \n                        </li>\n                        <li>setupadmin \n                           		  \n                        </li>\n                     </ul> \n                  </li>\n                  <li>Click OK to create the account. \n                     	 \n                  </li>\n               </ol> \n            </div> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_7AC311A186544F479048F9721F5D6A0A\"></a> \n            <h2><a name=\"GUID-36EDACF7-5F58-4089-979B-22330669D153\"></a>Enable Full Text Search\n            </h2> \n            <p>You can enable to include the full text search during the SQL Server 2017 installation:\n               \n               \n            </p> <a name=\"OL_490A809E6E7746B4ADD2F04B60518EC3\"></a><ol type=\"1\" start=\"1\">\n               <li>In the Installation Type tab, select Add features to an existing instance of SQL Server\n                  2017, and click Next. \n                  	 \n               </li>\n               <li>In the Feature Selection tab, select Full-text and Semantic Extractions for Search.\n                  Click Next. \n                  	 \n               </li>\n            </ol> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_E0E27AFD784A4270B2339013F4B3C49E\"></a> \n            <h2><a name=\"GUID-C917485C-AF63-4FE8-AAFE-66769FB15E28\"></a>Configure Microsoft SQL Server for Multi-Site Support (Vault Professional Only)\n            </h2> \n            <p><a name=\"GUID-2A5882BE-63FC-4CCF-B6EA-06E30130E442\"></a>If the installation is unable to find an installed version of Microsoft SQL, Autodesk\n               Vault Server installs Microsoft SQL 2017 Express. You can install Microsoft SQL 2017\n               Standard or Enterprise Edition before installing the Vault server so that you do not\n               have to perform the upgrade at a later time. \n               \n            </p> \n            <div><a name=\"GUID-6144B7AA-E9EA-40B9-9BBF-E0ED64EFE9DF\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span>This installation process possibly requires the server to reboot multiple times. Please\n                  be sure that you are able to perform the necessary reboots. Also, if you use a custom\n                  password for the SQL SA account, specify this password during the installation of\n                  the Vault server. \n                  \n               </div>\n            </div> \n            <div class=\"section\"><a name=\"SECTION_EC4C0D5A8418440ABA4B03D99F7EC29F\"></a> \n               <h3><a name=\"GUID-BFF032A3-DD66-490E-BB5E-4C340331E7D3\"></a>Configure Remote SQL\n               </h3> \n               <p><a name=\"GUID-EBCD1846-30C9-465A-8CEE-81C2BEC5F076\"></a>Vault Professional allows the Vault environment to be configured to use a remote SQL\n                  database. This database resides on a dedicated server which a single site can use\n                  to increase performance. Alternatively, it can be used for a multi-site replicated\n                  Vault environment. \n                  	 \n               </p> \n               <div><a name=\"GUID-FEE393D8-D677-405A-A5A6-AA502B5E9281\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span>The following steps are detailed steps for setting up remote access on SQL 2017. \n                     	 \n                  </div>\n               </div> <a name=\"OL_00E67AE1E8CD4AFC8F18061802827B47\"></a><ol type=\"1\" start=\"1\">\n                  <li>On the computer on which SQL is installed, click Start ►Programs►Microsoft® SQL Server\n                     [year]►Configuration Tools►SQL Server Configuration Manager. \n                     		\n                  </li>\n                  <li>In the SQL Server Configuration Manager dialog box, expand SQL Server Network Configuration\n                     and then select Protocols for AUTODESKVAULT. \n                     		\n                  </li>\n                  <li>Right-click TCP/IP in the protocols list and then select Enable. \n                     		\n                  </li>\n                  <li>Close SQL Server Configuration Manager. \n                     		\n                  </li>\n                  <li>From the Windows® Start menu, select Settings►Control Panel. \n                     		\n                  </li>\n                  <li>In the Control Panel, double-click Administrative Tools. \n                     		\n                  </li>\n                  <li>In the Administrative Tools window, double-click Computer Management. \n                     		\n                  </li>\n                  <li>In the Computer Management window, expand Services and Applications and then select\n                     Services. \n                     		\n                  </li>\n                  <li>Locate the SQL Server (AUTODESKVAULT) service. Right-click the service and then select\n                     Restart. \n                     		\n                  </li>\n                  <li>Locate the SQL Server Browser service. Right-click the service and then select Properties.\n                     \n                     		\n                  </li>\n                  <li>In the SQL Server Browser Properties (Local Computer) dialog box, change the startup\n                     type to be Automatic and then click OK. \n                     		\n                  </li>\n                  <li>Right-click SQL Server Browser and then select Start. \n                     		\n                  </li>\n               </ol> \n            </div> \n            <div class=\"section\"><a name=\"SECTION_1D550BB04B734657BD6804D447BBBCF3\"></a> \n               <h3><a name=\"GUID-68CBA0C6-A1B2-4DB3-849A-FDBA8CEF1A05\"></a>Create Shared Network Folders\n               </h3> \n               <p><a name=\"GUID-F580D027-2216-48AE-9F79-CC220825990B\"></a>In a multi-site environment, one site can host the AUTODESKVAULT SQL instance. The\n                  additional sites access that SQL instance remotely, or all sites can access the same\n                  SQL instance remotely. Before configuring the additional sites to access the SQL instance,\n                  a shared network folder must be created. \n                  	 \n               </p> \n               <p><a name=\"GUID-A48398F7-7CBF-4DCB-9E7E-A356D5466918\"></a>The shared network folder is required as a transition area between the SQL instance\n                  and the Autodesk Vault server. The shared network folder can be located on any computer\n                  that is accessible by both the data management server and SQL. The space requirement\n                  for the shared folder is equal to the total of all database files. \n                  	 \n               </p> \n               <p>If you are planning on using replication, create a shared folder for database replication\n                  and another for file store replication. Give them descriptive name<span class=\"code\"></span>s such as \n                  		<span class=\"filePath\">ReplicationShare</span> and \n                  		<span class=\"filePath\">MultisiteShare</span>. \n                  	 \n               </p> \n               <p>Give full access to shared folders for these user accounts: \n                  	 \n               </p> <a name=\"UL_C5776C9929984FFE8FA9D8F7C544366E\"></a><ul>\n                  <li>The account under which the Autodesk Vault server runs \n                     		\n                  </li>\n                  <li>The account under which the SQL instance operates \n                     		\n                  </li>\n                  <li>The SQL Server Agent \n                     		\n                  </li>\n               </ul> <a name=\"OL_C0E43367490D422AA28A0707CEFDD15E\"></a><ol type=\"1\" start=\"1\">\n                  <li>Choose a network location and create a folder. \n                     		\n                  </li>\n                  <li>Right-click the new folder and then select Sharing and Security. \n                     		\n                  </li>\n                  <li>In the Properties dialog box, click Share this folder. \n                     		\n                  </li>\n                  <li>Enter a name for the shared folder. \n                     		\n                  </li>\n                  <li>In the Comment field, enter Shared network folder for Autodesk Vault. \n                     		  \n                     <p><a name=\"GUID-624A78B2-802B-4D7E-8AC6-18FC46734BE6\"></a>  \n                     </p> <a name=\"FIG_2862E376CCAB4EEAA7B9A11A7573D27F\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-A58C7D94-B5EC-4D60-876C-F8B2BA143E9E-low.png\"></div> \n                  </li>\n                  <li>Click Permissions. \n                     		\n                  </li>\n                  <li>In the Permissions dialog box, click Add. Add the user account under which ADMS is\n                     running. By default, this account is a local administrator account on the ADMS server\n                     called Autodesk Vault. \n                     		\n                  </li>\n                  <li>Add the Windows account under which the SQL Server service is running. The default\n                     is Network Service. \n                     		\n                  </li>\n                  <li>Give both accounts Full Control. \n                     		\n                  </li>\n                  <li>In the Permissions dialog box, click OK. \n                     		\n                  </li>\n                  <li>In the Properties dialog box, click OK. \n                     		\n                  </li>\n               </ol> \n            </div> \n         </div>\n         <p><a name=\"GUID-3589C46A-3957-4EA5-995A-281D56788EC2\"></a>  \n         </p>\n         <div class=\"footer-block\"><a href=\"..\" class=\"comments-anchor\" target=\"_blank\"><span class=\"comments-link\">Please send us your comment about this page</span></a></div><br><p class=\"footer-license-block\"><a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\"><img alt=\"Creative Commons License\" style=\"border-width: 0;\" src=\"../images/ccLink.png\"></a>&nbsp;<em>Except where otherwise noted, this work is licensed under a <a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\">Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License</a>. Please see the <a href=\"http://autodesk.com/creativecommons\" target=\"_blank\">Autodesk Creative Commons FAQ</a> for more information.</em></p><br></div>\n   </body>\n</html>";
// SIG // Begin signature block
// SIG // MIIZfQYJKoZIhvcNAQcCoIIZbjCCGWoCAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // N4EKK6cmHMKGap+XBuEoGWVp9/8y4cCezjd93PGR0I+g
// SIG // ggoaMIIEyzCCA7OgAwIBAgIQCQja65wGHi65un4mqmKH
// SIG // ijANBgkqhkiG9w0BAQsFADCBhDELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTUw
// SIG // MwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
// SIG // b2RlIFNpZ25pbmcgQ0EgLSBHMjAeFw0xOTA1MTQwMDAw
// SIG // MDBaFw0yMDA1MTMyMzU5NTlaMHwxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIDApDYWxpZm9ybmlhMRMwEQYDVQQHDApT
// SIG // YW4gUmFmYWVsMRcwFQYDVQQKDA5BdXRvZGVzaywgSW5j
// SIG // LjERMA8GA1UECwwIU2VjdXJpdHkxFzAVBgNVBAMMDkF1
// SIG // dG9kZXNrLCBJbmMuMIIBIjANBgkqhkiG9w0BAQEFAAOC
// SIG // AQ8AMIIBCgKCAQEAkVKRoPYsoxPdlabspcuG8HYDfcWQ
// SIG // 9qyPOT2punwpVdjt2slktcpSTlydrGy8ijcbl5/k8AOJ
// SIG // afKMQvow0fNjIoNB5nsb8j2xFJPbBhHl8GT4P6DZ1OWK
// SIG // ioiUXgGHKjctUws49J4elntqvBYhKCbuPqG772QCoYFU
// SIG // P7qcFbh3PbyNB6cnKMn2vNGRqiEtV2aGg+/MiL3QPsvT
// SIG // kTWhVuTLIvwZ4kK5C5ACiQzlGOlE+C7gWuFoxtvy6gUa
// SIG // A8JAq/xLjYKwFevQwGncg3s1cuiGhx0P7Rvn6oCd2cem
// SIG // FmbK3I3rMRt+jc9wzAj3oHxvCo4f5Lfva+OpC1dETUVV
// SIG // sk0VGwIDAQABo4IBPjCCATowCQYDVR0TBAIwADAOBgNV
// SIG // HQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMw
// SIG // YQYDVR0gBFowWDBWBgZngQwBBAEwTDAjBggrBgEFBQcC
// SIG // ARYXaHR0cHM6Ly9kLnN5bWNiLmNvbS9jcHMwJQYIKwYB
// SIG // BQUHAgIwGQwXaHR0cHM6Ly9kLnN5bWNiLmNvbS9ycGEw
// SIG // HwYDVR0jBBgwFoAU1MAGIknrOUvdk+JcobhHdglyA1gw
// SIG // KwYDVR0fBCQwIjAgoB6gHIYaaHR0cDovL3JiLnN5bWNi
// SIG // LmNvbS9yYi5jcmwwVwYIKwYBBQUHAQEESzBJMB8GCCsG
// SIG // AQUFBzABhhNodHRwOi8vcmIuc3ltY2QuY29tMCYGCCsG
// SIG // AQUFBzAChhpodHRwOi8vcmIuc3ltY2IuY29tL3JiLmNy
// SIG // dDANBgkqhkiG9w0BAQsFAAOCAQEA0Q2+iVSEfT4xGq3A
// SIG // OADVb0rT5Z8E+PPb1x6hKknSzuaZKk/acDz9mdnFajaU
// SIG // WgIKiFJlsqJnuAM1w4lqKaEWsz3DoxvGIEwexj71Ud6a
// SIG // KlBJNcR9DdkXUZwMhbw9d78rjJAIX6tOwfSludZfdq8b
// SIG // YEkuIzQi9uYW9vHVPSCzhnUBKjwc9qTo9yBc7Fcn4FAT
// SIG // 90DzWM2hS9oc3p0pprYI2I/O4th90BEmwWkVqVgfaR0z
// SIG // VyIEmBbqB/IWLfjUBZJ/8sbkwWuWlYVRrfPxsj1e9qvb
// SIG // wE3Y28jWyGbqoUG39GhXk3uT8R8i3+T6M0c4rMfdifBC
// SIG // pceCaFTJzSye7LoeVzCCBUcwggQvoAMCAQICEHwbNTVK
// SIG // 59t050FfEWnKa6gwDQYJKoZIhvcNAQELBQAwgb0xCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjEfMB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29y
// SIG // azE6MDgGA1UECxMxKGMpIDIwMDggVmVyaVNpZ24sIElu
// SIG // Yy4gLSBGb3IgYXV0aG9yaXplZCB1c2Ugb25seTE4MDYG
// SIG // A1UEAxMvVmVyaVNpZ24gVW5pdmVyc2FsIFJvb3QgQ2Vy
// SIG // dGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMTQwNzIyMDAw
// SIG // MDAwWhcNMjQwNzIxMjM1OTU5WjCBhDELMAkGA1UEBhMC
// SIG // VVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9u
// SIG // MR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3Jr
// SIG // MTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1
// SIG // NiBDb2RlIFNpZ25pbmcgQ0EgLSBHMjCCASIwDQYJKoZI
// SIG // hvcNAQEBBQADggEPADCCAQoCggEBANeVQ9Tc32euOftS
// SIG // pLYmMQRw6beOWyq6N2k1lY+7wDDnhthzu9/r0XY/ilaO
// SIG // 6y1L8FcYTrGNpTPTC3Uj1Wp5J92j0/cOh2W13q0c8fU1
// SIG // tCJRryKhwV1LkH/AWU6rnXmpAtceSbE7TYf+wnirv+9S
// SIG // rpyvCNk55ZpRPmlfMBBOcWNsWOHwIDMbD3S+W8sS4duM
// SIG // xICUcrv2RZqewSUL+6McntimCXBx7MBHTI99w94Zzj7u
// SIG // BHKOF9P/8LIFMhlM07Acn/6leCBCcEGwJoxvAMg6ABFB
// SIG // ekGwp4qRBKCZePR3tPNgKuZsUAS3FGD/DVH0qIuE/iHa
// SIG // XF599Sl5T7BEdG9tcv8CAwEAAaOCAXgwggF0MC4GCCsG
// SIG // AQUFBwEBBCIwIDAeBggrBgEFBQcwAYYSaHR0cDovL3Mu
// SIG // c3ltY2QuY29tMBIGA1UdEwEB/wQIMAYBAf8CAQAwZgYD
// SIG // VR0gBF8wXTBbBgtghkgBhvhFAQcXAzBMMCMGCCsGAQUF
// SIG // BwIBFhdodHRwczovL2Quc3ltY2IuY29tL2NwczAlBggr
// SIG // BgEFBQcCAjAZGhdodHRwczovL2Quc3ltY2IuY29tL3Jw
// SIG // YTA2BgNVHR8ELzAtMCugKaAnhiVodHRwOi8vcy5zeW1j
// SIG // Yi5jb20vdW5pdmVyc2FsLXJvb3QuY3JsMBMGA1UdJQQM
// SIG // MAoGCCsGAQUFBwMDMA4GA1UdDwEB/wQEAwIBBjApBgNV
// SIG // HREEIjAgpB4wHDEaMBgGA1UEAxMRU3ltYW50ZWNQS0kt
// SIG // MS03MjQwHQYDVR0OBBYEFNTABiJJ6zlL3ZPiXKG4R3YJ
// SIG // cgNYMB8GA1UdIwQYMBaAFLZ3+mlIR59TEtXC6gcydgfR
// SIG // lwcZMA0GCSqGSIb3DQEBCwUAA4IBAQB/68qn6ot2Qus+
// SIG // jiBUMOO3udz6SD4Wxw9FlRDNJ4ajZvMC7XH4qsJVl5Fw
// SIG // g/lSflJpPMnx4JRGgBi7odSkVqbzHQCR1YbzSIfgy8Q0
// SIG // aCBetMv5Be2cr3BTJ7noPn5RoGlxi9xR7YA6JTKfRK9u
// SIG // QyjTIXW7l9iLi4z+qQRGBIX3FZxLEY3ELBf+1W5/muJW
// SIG // kvGWs60t+fTf2omZzrI4RMD3R3vKJbn6Kmgzm1By3qif
// SIG // 1M0sCzS9izB4QOCNjicbkG8avggVgV3rL+JR51EeyXgp
// SIG // 5x5lvzjvAUoBCSQOFsQUecFBNzTQPZFSlJ3haO8I8OJp
// SIG // nGdukAsak3HUJgLDwFojMYIOuzCCDrcCAQEwgZkwgYQx
// SIG // CzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRlYyBD
// SIG // b3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1
// SIG // c3QgTmV0d29yazE1MDMGA1UEAxMsU3ltYW50ZWMgQ2xh
// SIG // c3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENBIC0gRzIC
// SIG // EAkI2uucBh4uubp+Jqpih4owDQYJYIZIAWUDBAIBBQCg
// SIG // fDAQBgorBgEEAYI3AgEMMQIwADAZBgkqhkiG9w0BCQMx
// SIG // DAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4wDAYK
// SIG // KwYBBAGCNwIBFTAvBgkqhkiG9w0BCQQxIgQghYuEDxCh
// SIG // Ta1KbBTL3DZczltcopKyPaEK6CRbUpq1j6kwDQYJKoZI
// SIG // hvcNAQEBBQAEggEASQO9iG7Y2eiRkjZoaWBPN1QuiHO3
// SIG // DeR8bHia4hWVFiOnr834SOy2AtnGK/eSEiewNy8dzNKy
// SIG // 6TyALGrmx3ARbvRa+Jb4rqbnheM45CHY5UagqFmSwpca
// SIG // d8HhyDHYfFU/U/smPF68zMKz3awKv3quD2u+q7jxy476
// SIG // f8nIRF06mCR1QLtgUgp5TUchqNXy6D+l49lh9rer0TPB
// SIG // Gu6YnLjNDpfc5fT2kliI3Gc10rZyttp9H3u/KZEkRuyv
// SIG // 4Q/Ifo1Lutts7gXW/GuuwYhIE4SNETP1IeB3TTwvO7D6
// SIG // ZRxQ2zH2fiCK+4qCbk16DMA1Bxh4rgdegMBZoz7o0aiF
// SIG // YJbhGqGCDHQwggxwBgorBgEEAYI3AwMBMYIMYDCCDFwG
// SIG // CSqGSIb3DQEHAqCCDE0wggxJAgEDMQ8wDQYJYIZIAWUD
// SIG // BAIBBQAwga8GCyqGSIb3DQEJEAEEoIGfBIGcMIGZAgEB
// SIG // BgkrBgEEAaAyAgMwMTANBglghkgBZQMEAgEFAAQgChGf
// SIG // YtvbB/DDsKRfKErtuRRqo6/NG2D1ddwK8/4ASdICFA3I
// SIG // lDTM/62bMsS3GWAU/AaOTCQyGA8yMDIwMDMyMzE0MDM1
// SIG // MVqgL6QtMCsxKTAnBgNVBAMMIEdsb2JhbFNpZ24gVFNB
// SIG // IGZvciBBZHZhbmNlZCAtIEcyoIII0zCCBLYwggOeoAMC
// SIG // AQICDAynz10HBySsieeaOjANBgkqhkiG9w0BAQsFADBb
// SIG // MQswCQYDVQQGEwJCRTEZMBcGA1UEChMQR2xvYmFsU2ln
// SIG // biBudi1zYTExMC8GA1UEAxMoR2xvYmFsU2lnbiBUaW1l
// SIG // c3RhbXBpbmcgQ0EgLSBTSEEyNTYgLSBHMjAeFw0xODAy
// SIG // MTkwMDAwMDBaFw0yOTAzMTgxMDAwMDBaMCsxKTAnBgNV
// SIG // BAMMIEdsb2JhbFNpZ24gVFNBIGZvciBBZHZhbmNlZCAt
// SIG // IEcyMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKC
// SIG // AQEAt8eSiijY85HLUA1d6ylEwYJZpcpkzr2DtVHllMxu
// SIG // gJoXbNz/YuY2Q14Bwgxkjcp3nvZdd0W5Xsgk60E3EWY3
// SIG // rMjNdJvMs+9M4n8bznO+yZadNR5891T3bOygEtaumZ1j
// SIG // xHhfWakuIvXDJ9iyW0VjJ5D/jLE9qbTzDsDxIGUGiZ0D
// SIG // HKOwUkGFNOu8y85U9hL+swGJSqb6VMUf+9McwOO/l+M/
// SIG // 0Bv5QMcb1esmfEMwx3DyeBGqhU6lDg0ASjoRd6PKIwGA
// SIG // nsiTVl1GzIrY0qoKhIWyiVvVMs5BexhOVMqr0VJeEtMk
// SIG // nlbzDI/dvZKOedVBicOjoOWR/MdnnYczznEycwIDAQAB
// SIG // o4IBqDCCAaQwDgYDVR0PAQH/BAQDAgeAMEwGA1UdIARF
// SIG // MEMwQQYJKwYBBAGgMgEeMDQwMgYIKwYBBQUHAgEWJmh0
// SIG // dHBzOi8vd3d3Lmdsb2JhbHNpZ24uY29tL3JlcG9zaXRv
// SIG // cnkvMAkGA1UdEwQCMAAwFgYDVR0lAQH/BAwwCgYIKwYB
// SIG // BQUHAwgwRgYDVR0fBD8wPTA7oDmgN4Y1aHR0cDovL2Ny
// SIG // bC5nbG9iYWxzaWduLmNvbS9ncy9nc3RpbWVzdGFtcGlu
// SIG // Z3NoYTJnMi5jcmwwgZgGCCsGAQUFBwEBBIGLMIGIMEgG
// SIG // CCsGAQUFBzAChjxodHRwOi8vc2VjdXJlLmdsb2JhbHNp
// SIG // Z24uY29tL2NhY2VydC9nc3RpbWVzdGFtcGluZ3NoYTJn
// SIG // Mi5jcnQwPAYIKwYBBQUHMAGGMGh0dHA6Ly9vY3NwMi5n
// SIG // bG9iYWxzaWduLmNvbS9nc3RpbWVzdGFtcGluZ3NoYTJn
// SIG // MjAdBgNVHQ4EFgQULW5u0Y3lA4Du52Ppp9naCzxXIj0w
// SIG // HwYDVR0jBBgwFoAUkiGnSpVdZLCbtB7mADdH5p1BK0ww
// SIG // DQYJKoZIhvcNAQELBQADggEBAI39HR+PiNNl+LVcRumn
// SIG // 07Y/SstDBcIHDcNeA4QjN6h6jJcj/yechH1h61xLVz6b
// SIG // 9ETbgFj3tmXejxIKX6eHdLfaFECHUeyfSkdV8BfoGD5x
// SIG // IDHmKCKrTvaunGvC50T7aA0gf1M/lBuhhoJOMhYQWj+J
// SIG // WMHQtNu2kPuNMumhS0ZQN7bDOukpJBKSWk4rubYKejaM
// SIG // l8DviXwz3jHhoZfk50WtYVL9WonTVH6KTVuJew6Wd9Hy
// SIG // PDgb2vmlYSBlArzFrdcMYhAoLN2246hhAKwIJqONhdBk
// SIG // yTaQHopSyYeNNaVdSJH8k6alZfHs+TrcpSyeBG1iM/7e
// SIG // +p/Fzq+V81Go8s4wggQVMIIC/aADAgECAgsEAAAAAAEx
// SIG // icZQBDANBgkqhkiG9w0BAQsFADBMMSAwHgYDVQQLExdH
// SIG // bG9iYWxTaWduIFJvb3QgQ0EgLSBSMzETMBEGA1UEChMK
// SIG // R2xvYmFsU2lnbjETMBEGA1UEAxMKR2xvYmFsU2lnbjAe
// SIG // Fw0xMTA4MDIxMDAwMDBaFw0yOTAzMjkxMDAwMDBaMFsx
// SIG // CzAJBgNVBAYTAkJFMRkwFwYDVQQKExBHbG9iYWxTaWdu
// SIG // IG52LXNhMTEwLwYDVQQDEyhHbG9iYWxTaWduIFRpbWVz
// SIG // dGFtcGluZyBDQSAtIFNIQTI1NiAtIEcyMIIBIjANBgkq
// SIG // hkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqpuOw6sRUSUB
// SIG // tpaU4k/YwQj2RiPZRcWVl1urGr/SbFfJMwYfoA/GPH5T
// SIG // SHq/nYeer+7DjEfhQuzj46FKbAwXxKbBuc1b8R5EiY7+
// SIG // C94hWBPuTcjFZwscsrPxNHaRossHbTfFoEcmAhWkkJGp
// SIG // eZ7X61edK3wi2BTX8QceeCI2a3d5r6/5f45O4bUIMf3q
// SIG // 7UtxYowj8QM5j0R5tnYDV56tLwhG3NKMvPSOdM7IaGlR
// SIG // dhGLD10kWxlUPSbMQI2CJxtZIH1Z9pOAjvgqOP1roEBl
// SIG // H1d2zFuOBE8sqNuEUBNPxtyLufjdaUyI65x7MCb8eli7
// SIG // WbwUcpKBV7d2ydiACoBuCQIDAQABo4HoMIHlMA4GA1Ud
// SIG // DwEB/wQEAwIBBjASBgNVHRMBAf8ECDAGAQH/AgEAMB0G
// SIG // A1UdDgQWBBSSIadKlV1ksJu0HuYAN0fmnUErTDBHBgNV
// SIG // HSAEQDA+MDwGBFUdIAAwNDAyBggrBgEFBQcCARYmaHR0
// SIG // cHM6Ly93d3cuZ2xvYmFsc2lnbi5jb20vcmVwb3NpdG9y
// SIG // eS8wNgYDVR0fBC8wLTAroCmgJ4YlaHR0cDovL2NybC5n
// SIG // bG9iYWxzaWduLm5ldC9yb290LXIzLmNybDAfBgNVHSME
// SIG // GDAWgBSP8Et/qC5FJK5NUPpjmove4t0bvDANBgkqhkiG
// SIG // 9w0BAQsFAAOCAQEABFaCSnzQzsm/NmbRvjWek2yX6AbO
// SIG // MRhZ+WxBX4AuwEIluBjH/NSxN8RooM8oagN0S2OXhXdh
// SIG // O9cv4/W9M6KSfREfnops7yyw9GKNNnPRFjbxvF7stICY
// SIG // ePzSdnno4SGU4B/EouGqZ9uznHPlQCLPOc7b5neVp7uy
// SIG // y/YZhp2fyNSYBbJxb051rvE9ZGo7Xk5GpipdCJLxo/Md
// SIG // dL9iDSOMXCo4ldLA1c3PiNofKLW6gWlkKrWmotVzr9xG
// SIG // 2wSukdduxZi61EfEVnSAR3hYjL7vK/3sbL/RlPe/UOB7
// SIG // 4JD9IBh4GCJdCC6MHKCX8x2ZfaOdkdMGRE4EbnocIOM2
// SIG // 8LZQuTGCAqgwggKkAgEBMGswWzELMAkGA1UEBhMCQkUx
// SIG // GTAXBgNVBAoTEEdsb2JhbFNpZ24gbnYtc2ExMTAvBgNV
// SIG // BAMTKEdsb2JhbFNpZ24gVGltZXN0YW1waW5nIENBIC0g
// SIG // U0hBMjU2IC0gRzICDAynz10HBySsieeaOjANBglghkgB
// SIG // ZQMEAgEFAKCCAQ4wGgYJKoZIhvcNAQkDMQ0GCyqGSIb3
// SIG // DQEJEAEEMBwGCSqGSIb3DQEJBTEPFw0yMDAzMjMxNDAz
// SIG // NTFaMC8GCSqGSIb3DQEJBDEiBCA5ARr7SFP9P2N3Xb/l
// SIG // S9OYaYN+RivY4vu6f0oFZO4mEzCBoAYLKoZIhvcNAQkQ
// SIG // AgwxgZAwgY0wgYowgYcEFJsSBXrnKq/21jdytJ9qI28m
// SIG // Sc2pMG8wX6RdMFsxCzAJBgNVBAYTAkJFMRkwFwYDVQQK
// SIG // ExBHbG9iYWxTaWduIG52LXNhMTEwLwYDVQQDEyhHbG9i
// SIG // YWxTaWduIFRpbWVzdGFtcGluZyBDQSAtIFNIQTI1NiAt
// SIG // IEcyAgwMp89dBwckrInnmjowDQYJKoZIhvcNAQEBBQAE
// SIG // ggEAXKtHk66dtwE4nwx+JhjWAxgxhgE8sdLfYeA/9Qbi
// SIG // IK6WW9Op7m6VKN7hBo63/T1/DP6419+4X+Tqb3Sf5vV9
// SIG // /DSM1VO82rvfeOvlUEZOoXmHy0bH0lidrOs9LRHqB4fP
// SIG // b/9yY6Y154qZOuy7wB3yXkda+JcvFHqQLWdb8b8mHyuH
// SIG // 6ucufzgfG2GfgohAaFlVpj+aHtDBm1jf89nzzJA2CjJ5
// SIG // Qh8PYLsRLzjcmF/iuMhAIAD4KOVE7pasUo2qqng30tRE
// SIG // xLeGIcbarUsvrPqopBzVfPRX+339CXY01dq9BoTxOIki
// SIG // l+nSb+GfMbMjgqeXZqfcaHTCJEj+cUUY82vs+A==
// SIG // End signature block
