var topic = "<!DOCTYPE html>\r\n\n<!-- saved from url=(0024)http://docs.autodesk.com -->\r\n<html>\n   <head>\n      <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n      <meta name=\"product\" content=\"VAULT\">\n      <meta name=\"release\" content=\"2021\">\n      <meta name=\"book\" content=\"GeneralUser\">\n      <meta name=\"created\" content=\"2020-03-20\">\n      <meta name=\"topicid\" content=\"GUID-6665606F-2E5A-4AA8-8F08-28EA08A25C4B\">\n      <meta name=\"description\" content=\"This section addresses topics specifically related to the unique environments associated with replicating data to multiple work sites.\">\n      <meta name=\"topic-type\" content=\"concept\">\n      <meta name=\"audience\" content=\"user\">\n      <meta name=\"experiencelevel\" content=\"general\">\n      <title>Multi-Site Replication</title><script language=\"javascript\">var index = \'index.html\';</script></head>\n   <body height=\"100%\">\n      <div class=\"revit-legend\">\n         <ul></ul>\n      </div>\n      <div class=\"body_content\" id=\"body-content\" dir=\"ltr\"><a name=\"GUID-6665606F-2E5A-4AA8-8F08-28EA08A25C4B\"></a><div class=\"head\">\n            <h1>Multi-Site Replication</h1>\n         </div>\n         <p class=\"blurb\">This section addresses topics specifically related to the unique environments associated\n            with replicating data to multiple work sites. \n            \n         </p>\n         <div class=\"section\"><a name=\"SECTION_877126C3671E49BE99E64A2B1CA9A296\"></a> \n            <h2><a name=\"GUID-5EF97B83-62C1-475A-8911-301C4E63479D\"></a>When Should You Use Replication?\n            </h2> \n            <p>Usually a Vault deployment begins as a single-site installation. From there, your\n               organization might decide to expand its infrastructure as needed to meet higher demand.\n               \n               <a name=\"UL_773BF5BBB2554A0C9FA6139C62BF7383\"></a><ul>\n                  <li><em class=\"strong\">Phase 1</em>: Install Vault on a single site; this is usually adequate for an organization located\n                     in one physical office. \n                     	 \n                  </li>\n                  <li><em class=\"strong\">Phase 2</em>: Move to a multi-site Vault deployment, using one SQL server; this is appropriate\n                     for an organization with multiple physical offices. Replication at this point might\n                     not be needed, as long as performance is satisfactory. \n                     	 \n                  </li>\n                  <li><em class=\"strong\">Phase 3</em>: Move from a regular multi-site deployment to a replication deployment with multiple\n                     SQL servers in different locations. This would mean upgrading a remote site to a \"subscriber\"\n                     site, with the main, central Vault site being the \"publisher\" site. Use this strategy\n                     to overcome performance impediments caused by sharing data across multiple physical\n                     locations; for example, remote offices in two or more different cities. \n                     	 \n                  </li>\n               </ul> \n            </p> \n            <p>For large organizations, Autodesk recommends first trying a regular multi-site deployment.\n               If performance is not satisfactory, then you can migrate to a replication deployment.\n               \n               \n            </p> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_E1D3BC78FB1E4514846E1E2CD13B8BB5\"></a> \n            <h2><a name=\"GUID-CCA7FE0F-5420-473E-ADA7-B1FB02253791\"></a>Migrate from a Multi-Site Deployment to Replication\n            </h2> \n            <p>Once you have determined that you need to set up replication to handle Vault data\n               volume, follow these steps to enable replication. This describes the steps to take\n               on a central Vault server (the publisher) and a remote site (a subscriber). \n               \n            </p> <a name=\"OL_CDA95CF6DDFB447F96D31C074AC0566F\"></a><ol type=\"1\" start=\"1\">\n               <li>On the subscriber (remote) site, uninstall the ADMS Console. \n                  		\n                  <p>You will reinstall this later once replication has been enabled. \n                     		\n                  </p> \n               </li>\n               <li>On the subscriber site, install SQL server, either on a dedicated computer or on one\n                  that will be shared with the subscriber ADMS Console. \n                  	 \n               </li>\n               <li>On the publisher site, make sure that replication is enabled on the SQL Server. \n                  		\n                  <p>If it is not, you can enable it by running the SQL Server installation program and\n                     selecting \n                     		  <span class=\"MenuCascade\">Feature Selection <img src=\"../images/ac.menuaro.gif\"> Instance Features <img src=\"../images/ac.menuaro.gif\"> Database Engine Services <img src=\"../images/ac.menuaro.gif\"> SQL Server Replication</span>. \n                     		\n                  </p> \n               </li>\n               <li>On the publisher site, open the ADMS Console and enable workgroup replication. \n                  	 \n               </li>\n               <li>On the publisher site, in the ADMS Console, add the subscriber workgroup. \n                  	 \n               </li>\n               <li>On the publisher site, verify that SQL Server is able to replicate data to the newly\n                  installed subscriber SQL Server. \n                  		\n                  <div><a name=\"GUID-A65E3DD0-B836-4E91-9173-E423FB862EBA\"></a><div class=\"note-important\"><span class=\"label label-target-language\">IMPORTANT:</span>You must do this before reinstalling the ADMS Console in the next step, otherwise\n                        Vault replication will not work. \n                        		\n                     </div>\n                  </div> \n               </li>\n               <li>Reinstall the ADMS Console on the subscriber site and have it point to the subscriber\n                  SQL Server that is also installed there. \n                  	 \n               </li>\n            </ol> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_956BB0656852454491A77E3958825772\"></a> \n            <h2><a name=\"GUID-A8AA6FA9-158F-4216-9B3A-0B69886C922A\"></a>Scalability of File Store Replication\n            </h2> \n            <p><a name=\"GUID-6C70AC07-18FA-47DE-AAB4-43C7444B4FB9\"></a>Replication uses a single database for all sites and replicates the file store to\n               each location. This architecture has distinct advantages in ease of implementation,\n               end user experience and the instantaneous nature of the information availability.\n               This architecture is not suited to sites that are distributed over great distances\n               (such as between continents) or poor networks. \n               \n            </p> \n            <p><a name=\"GUID-A951BE44-9BB2-4DF1-BE86-A32554330053\"></a> <em class=\"strong\">Introduction to Content Center with Replicated File Store</em> \n            </p> \n            <p><a name=\"GUID-80A417E9-F203-4FC3-BE5D-7C918384A78F\"></a>Autodesk Inventor Standard Content is delivered in the form of library databases that\n               are hosted by the Autodesk Vault Server. Users access these library databases through\n               Inventor to automatically create selected library components as Inventor part files.\n               Once instanced these components are stored in a folder defined by the Inventor project\n               file. When the assembly is then checked into Vault, the instanced Content Center components\n               are also checked into Vault. \n               \n            </p> \n            <p><a name=\"GUID-61DA5585-55BA-4672-831B-6DCD698DA872\"></a>In a Replicated Autodesk Vault environment we can tune the performance of Content\n               Center by altering the configuration of the Inventor project file. \n               \n            </p> \n            <p><a name=\"GUID-1854B6EB-ADD0-4886-83F7-E62A5AE203B6\"></a> <em class=\"strong\">Assumptions</em> \n            </p> \n            <p><a name=\"GUID-F47E7965-578C-4672-8865-FDA168127DE2\"></a>The following examples assume all software including the Content has been installed.\n               These examples also assume the reader has a functional understanding of how Content\n               is instantiated and referenced. If required please reference the Content Center help.\n               \n               \n            </p> \n            <p><a name=\"GUID-AC6AD58A-CEF8-492A-810A-9C194A6DDC29\"></a>The diagrams show the SQL server as a separate computer for clarity. SQL Server may\n               be on a separate computer or on the Autodesk Vault Server, either case is supported\n               and has no impact on the workflows detailed in this document. \n               \n            </p> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_2BC731ECDBEF47CC91BCCEB30B6A87ED\"></a> \n            <h2><a name=\"GUID-808C5B98-7EDD-40CA-9230-57E109C5BBBD\"></a>Desktop Content Center Folder\n            </h2> \n            <p><a name=\"GUID-0DFD52DD-3935-4203-9DB8-0FCFE0103250\"></a>The default configuration when using Inventor is for each client to have a Desktop\n               Content Center folder. \n               \n            </p> \n            <p><a name=\"GUID-52BAE06F-2D76-4FF7-B012-A43AF7EE6177\"></a>Advantages: \n               <a name=\"UL_D73DA5AE0F194145824AFCCB0ABEF004\"></a><ul>\n                  <li>Suitable for assemblies that have a high volume of Content Center components by eliminating\n                     network traffic for existing local components. \n                     	 \n                  </li>\n                  <li>Allows each user to have only the content they use in their Desktop Content Center\n                     folder. \n                     	 \n                  </li>\n               </ul> \n            </p> \n            <p><a name=\"GUID-66FB013F-3B31-4AFB-86E2-A010F6C4F95C\"></a>Disadvantages: \n               <a name=\"UL_DBA62882CF634EDDBABFB964C04A0333\"></a><ul>\n                  <li>Consumes considerable disk space on the client \n                     	 \n                  </li>\n                  <li>Each client must instantiate each referenced component in their Desktop Content Center\n                     folder \n                     	 \n                  </li>\n               </ul> \n            </p> \n            <p><a name=\"GUID-96499448-5C2D-41A8-A766-A04114CF9034\"></a>Private content example: \n               \n            </p> <a name=\"FIG_2ED363E71AF6434DB6E8B07B43E4D013\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-FD31D042-0C60-4A78-8639-3748FCE50349-low.png\"></div> <a name=\"UL_B5BFDA5F8F114881B8AB55AC2B576B88\"></a><ul>\n               <li>Client 1 creates an instance of a component from the Content Center database. The\n                  instanced part file is written to the Desktop Content Center folder located on the\n                  client computer. \n                  	 \n               </li>\n               <li>User checks in the instanced component as part of an assembly. The Content part is\n                  copied into the Vault file store. \n                  	 \n               </li>\n            </ul> \n            <div><a name=\"GUID-343228F8-97BD-4827-BE22-B0EB46912A69\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span> Keeping the part file in the local folder removes the delays, for this user, due\n                  to instancing the part file or copying it from the file store. \n                  \n               </div>\n            </div> <a name=\"UL_86C72FCFBF124F8089B7E9E2FBACF924\"></a><ul>\n               <li>When the other Clients insert the same component that Client 1 used. Since the part\n                  does not yet exist in their Desktop Content Center Folder, it will be instanced from\n                  the local database. \n                  	 \n               </li>\n               <li>During the scheduled replication at each Autodesk Vault Server the Content Center\n                  components are replicated to the local file store at each site. \n                  	 \n               </li>\n            </ul> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_5C69BFD9918740E5B3D98774AF0D49E7\"></a> \n            <h2><a name=\"GUID-AB98090A-90FB-4758-A3F3-04F5C3EBC27C\"></a> Shared Content Center\n            </h2> \n            <p><a name=\"GUID-10520AC6-351E-4FDD-B37D-EEFA8360E5AF\"></a>The Content Center files are installed on the Autodesk Data Management Server. For\n               more information about Content Center files and installing them with Inventor, see\n               \n               	 <span class=\"char_link\"><a href=\"GUID-E425A189-3DDA-4F89-B2CD-B5236D414DAE.htm\">What is the Content Center</a></span>. \n               \n            </p> \n         </div>\n         <div class=\"footer-block\"><a href=\"..\" class=\"comments-anchor\" target=\"_blank\"><span class=\"comments-link\">Please send us your comment about this page</span></a></div><br><p class=\"footer-license-block\"><a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\"><img alt=\"Creative Commons License\" style=\"border-width: 0;\" src=\"../images/ccLink.png\"></a>&nbsp;<em>Except where otherwise noted, this work is licensed under a <a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\">Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License</a>. Please see the <a href=\"http://autodesk.com/creativecommons\" target=\"_blank\">Autodesk Creative Commons FAQ</a> for more information.</em></p><br></div>\n   </body>\n</html>";
// SIG // Begin signature block
// SIG // MIIbRgYJKoZIhvcNAQcCoIIbNzCCGzMCAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // IHoS6357qPGhJp13d2MqmZQJHLXVGu41c9AWdehAi2Kg
// SIG // ggoaMIIEyzCCA7OgAwIBAgIQCQja65wGHi65un4mqmKH
// SIG // ijANBgkqhkiG9w0BAQsFADCBhDELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTUw
// SIG // MwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
// SIG // b2RlIFNpZ25pbmcgQ0EgLSBHMjAeFw0xOTA1MTQwMDAw
// SIG // MDBaFw0yMDA1MTMyMzU5NTlaMHwxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIDApDYWxpZm9ybmlhMRMwEQYDVQQHDApT
// SIG // YW4gUmFmYWVsMRcwFQYDVQQKDA5BdXRvZGVzaywgSW5j
// SIG // LjERMA8GA1UECwwIU2VjdXJpdHkxFzAVBgNVBAMMDkF1
// SIG // dG9kZXNrLCBJbmMuMIIBIjANBgkqhkiG9w0BAQEFAAOC
// SIG // AQ8AMIIBCgKCAQEAkVKRoPYsoxPdlabspcuG8HYDfcWQ
// SIG // 9qyPOT2punwpVdjt2slktcpSTlydrGy8ijcbl5/k8AOJ
// SIG // afKMQvow0fNjIoNB5nsb8j2xFJPbBhHl8GT4P6DZ1OWK
// SIG // ioiUXgGHKjctUws49J4elntqvBYhKCbuPqG772QCoYFU
// SIG // P7qcFbh3PbyNB6cnKMn2vNGRqiEtV2aGg+/MiL3QPsvT
// SIG // kTWhVuTLIvwZ4kK5C5ACiQzlGOlE+C7gWuFoxtvy6gUa
// SIG // A8JAq/xLjYKwFevQwGncg3s1cuiGhx0P7Rvn6oCd2cem
// SIG // FmbK3I3rMRt+jc9wzAj3oHxvCo4f5Lfva+OpC1dETUVV
// SIG // sk0VGwIDAQABo4IBPjCCATowCQYDVR0TBAIwADAOBgNV
// SIG // HQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMw
// SIG // YQYDVR0gBFowWDBWBgZngQwBBAEwTDAjBggrBgEFBQcC
// SIG // ARYXaHR0cHM6Ly9kLnN5bWNiLmNvbS9jcHMwJQYIKwYB
// SIG // BQUHAgIwGQwXaHR0cHM6Ly9kLnN5bWNiLmNvbS9ycGEw
// SIG // HwYDVR0jBBgwFoAU1MAGIknrOUvdk+JcobhHdglyA1gw
// SIG // KwYDVR0fBCQwIjAgoB6gHIYaaHR0cDovL3JiLnN5bWNi
// SIG // LmNvbS9yYi5jcmwwVwYIKwYBBQUHAQEESzBJMB8GCCsG
// SIG // AQUFBzABhhNodHRwOi8vcmIuc3ltY2QuY29tMCYGCCsG
// SIG // AQUFBzAChhpodHRwOi8vcmIuc3ltY2IuY29tL3JiLmNy
// SIG // dDANBgkqhkiG9w0BAQsFAAOCAQEA0Q2+iVSEfT4xGq3A
// SIG // OADVb0rT5Z8E+PPb1x6hKknSzuaZKk/acDz9mdnFajaU
// SIG // WgIKiFJlsqJnuAM1w4lqKaEWsz3DoxvGIEwexj71Ud6a
// SIG // KlBJNcR9DdkXUZwMhbw9d78rjJAIX6tOwfSludZfdq8b
// SIG // YEkuIzQi9uYW9vHVPSCzhnUBKjwc9qTo9yBc7Fcn4FAT
// SIG // 90DzWM2hS9oc3p0pprYI2I/O4th90BEmwWkVqVgfaR0z
// SIG // VyIEmBbqB/IWLfjUBZJ/8sbkwWuWlYVRrfPxsj1e9qvb
// SIG // wE3Y28jWyGbqoUG39GhXk3uT8R8i3+T6M0c4rMfdifBC
// SIG // pceCaFTJzSye7LoeVzCCBUcwggQvoAMCAQICEHwbNTVK
// SIG // 59t050FfEWnKa6gwDQYJKoZIhvcNAQELBQAwgb0xCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjEfMB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29y
// SIG // azE6MDgGA1UECxMxKGMpIDIwMDggVmVyaVNpZ24sIElu
// SIG // Yy4gLSBGb3IgYXV0aG9yaXplZCB1c2Ugb25seTE4MDYG
// SIG // A1UEAxMvVmVyaVNpZ24gVW5pdmVyc2FsIFJvb3QgQ2Vy
// SIG // dGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMTQwNzIyMDAw
// SIG // MDAwWhcNMjQwNzIxMjM1OTU5WjCBhDELMAkGA1UEBhMC
// SIG // VVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9u
// SIG // MR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3Jr
// SIG // MTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1
// SIG // NiBDb2RlIFNpZ25pbmcgQ0EgLSBHMjCCASIwDQYJKoZI
// SIG // hvcNAQEBBQADggEPADCCAQoCggEBANeVQ9Tc32euOftS
// SIG // pLYmMQRw6beOWyq6N2k1lY+7wDDnhthzu9/r0XY/ilaO
// SIG // 6y1L8FcYTrGNpTPTC3Uj1Wp5J92j0/cOh2W13q0c8fU1
// SIG // tCJRryKhwV1LkH/AWU6rnXmpAtceSbE7TYf+wnirv+9S
// SIG // rpyvCNk55ZpRPmlfMBBOcWNsWOHwIDMbD3S+W8sS4duM
// SIG // xICUcrv2RZqewSUL+6McntimCXBx7MBHTI99w94Zzj7u
// SIG // BHKOF9P/8LIFMhlM07Acn/6leCBCcEGwJoxvAMg6ABFB
// SIG // ekGwp4qRBKCZePR3tPNgKuZsUAS3FGD/DVH0qIuE/iHa
// SIG // XF599Sl5T7BEdG9tcv8CAwEAAaOCAXgwggF0MC4GCCsG
// SIG // AQUFBwEBBCIwIDAeBggrBgEFBQcwAYYSaHR0cDovL3Mu
// SIG // c3ltY2QuY29tMBIGA1UdEwEB/wQIMAYBAf8CAQAwZgYD
// SIG // VR0gBF8wXTBbBgtghkgBhvhFAQcXAzBMMCMGCCsGAQUF
// SIG // BwIBFhdodHRwczovL2Quc3ltY2IuY29tL2NwczAlBggr
// SIG // BgEFBQcCAjAZGhdodHRwczovL2Quc3ltY2IuY29tL3Jw
// SIG // YTA2BgNVHR8ELzAtMCugKaAnhiVodHRwOi8vcy5zeW1j
// SIG // Yi5jb20vdW5pdmVyc2FsLXJvb3QuY3JsMBMGA1UdJQQM
// SIG // MAoGCCsGAQUFBwMDMA4GA1UdDwEB/wQEAwIBBjApBgNV
// SIG // HREEIjAgpB4wHDEaMBgGA1UEAxMRU3ltYW50ZWNQS0kt
// SIG // MS03MjQwHQYDVR0OBBYEFNTABiJJ6zlL3ZPiXKG4R3YJ
// SIG // cgNYMB8GA1UdIwQYMBaAFLZ3+mlIR59TEtXC6gcydgfR
// SIG // lwcZMA0GCSqGSIb3DQEBCwUAA4IBAQB/68qn6ot2Qus+
// SIG // jiBUMOO3udz6SD4Wxw9FlRDNJ4ajZvMC7XH4qsJVl5Fw
// SIG // g/lSflJpPMnx4JRGgBi7odSkVqbzHQCR1YbzSIfgy8Q0
// SIG // aCBetMv5Be2cr3BTJ7noPn5RoGlxi9xR7YA6JTKfRK9u
// SIG // QyjTIXW7l9iLi4z+qQRGBIX3FZxLEY3ELBf+1W5/muJW
// SIG // kvGWs60t+fTf2omZzrI4RMD3R3vKJbn6Kmgzm1By3qif
// SIG // 1M0sCzS9izB4QOCNjicbkG8avggVgV3rL+JR51EeyXgp
// SIG // 5x5lvzjvAUoBCSQOFsQUecFBNzTQPZFSlJ3haO8I8OJp
// SIG // nGdukAsak3HUJgLDwFojMYIQhDCCEIACAQEwgZkwgYQx
// SIG // CzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRlYyBD
// SIG // b3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1
// SIG // c3QgTmV0d29yazE1MDMGA1UEAxMsU3ltYW50ZWMgQ2xh
// SIG // c3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENBIC0gRzIC
// SIG // EAkI2uucBh4uubp+Jqpih4owDQYJYIZIAWUDBAIBBQCg
// SIG // fDAQBgorBgEEAYI3AgEMMQIwADAZBgkqhkiG9w0BCQMx
// SIG // DAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4wDAYK
// SIG // KwYBBAGCNwIBFTAvBgkqhkiG9w0BCQQxIgQguzDypJn0
// SIG // r3F4H29MWZuHvi1Zb7LT9LUtJOgYLoYy9BMwDQYJKoZI
// SIG // hvcNAQEBBQAEggEAfZxduvU5tzvfI+BTmOZ2VHHIkoDh
// SIG // mbotYPELQrpO4QHeORo3LXKI7RrMCPfIYpGYQd97fIXJ
// SIG // /CRbRT7UgY3tekssbc2ZA9HEj+Vi7C6kMNNwTNm8WKt9
// SIG // JQwvGkNQVFwoW66zviT9WrUfomzfxs+rBSyyccX4mCYg
// SIG // uAwYK8QLZIeu82JoF2ii2Yg2NhvkQpqTRWJ0kaJO0WGA
// SIG // fh8LcSiRTxGm82cGx2EhdCrQq0ff4UjSfyd6yiUSrS6j
// SIG // OxRKVaUjvwHf7RGhmeenzjJHj7XBvEi87mAuyEl1ohgr
// SIG // hQyyS6dfueIudA7Te0dc3ZIlQBiVn8vLXNaQgPUimAFq
// SIG // u5kZGaGCDj0wgg45BgorBgEEAYI3AwMBMYIOKTCCDiUG
// SIG // CSqGSIb3DQEHAqCCDhYwgg4SAgEDMQ0wCwYJYIZIAWUD
// SIG // BAIBMIIBDwYLKoZIhvcNAQkQAQSggf8EgfwwgfkCAQEG
// SIG // C2CGSAGG+EUBBxcDMDEwDQYJYIZIAWUDBAIBBQAEIAGA
// SIG // YzrlNVh216wqN+7Z+VGkRmdkR9/iW2uSffO06UrHAhUA
// SIG // 9KDNczChnt/gN0BATmR50KTD/wkYDzIwMjAwMzIzMTQw
// SIG // MzExWjADAgEeoIGGpIGDMIGAMQswCQYDVQQGEwJVUzEd
// SIG // MBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xHzAd
// SIG // BgNVBAsTFlN5bWFudGVjIFRydXN0IE5ldHdvcmsxMTAv
// SIG // BgNVBAMTKFN5bWFudGVjIFNIQTI1NiBUaW1lU3RhbXBp
// SIG // bmcgU2lnbmVyIC0gRzOgggqLMIIFODCCBCCgAwIBAgIQ
// SIG // ewWx1EloUUT3yYnSnBmdEjANBgkqhkiG9w0BAQsFADCB
// SIG // vTELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWdu
// SIG // LCBJbmMuMR8wHQYDVQQLExZWZXJpU2lnbiBUcnVzdCBO
// SIG // ZXR3b3JrMTowOAYDVQQLEzEoYykgMjAwOCBWZXJpU2ln
// SIG // biwgSW5jLiAtIEZvciBhdXRob3JpemVkIHVzZSBvbmx5
// SIG // MTgwNgYDVQQDEy9WZXJpU2lnbiBVbml2ZXJzYWwgUm9v
// SIG // dCBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAeFw0xNjAx
// SIG // MTIwMDAwMDBaFw0zMTAxMTEyMzU5NTlaMHcxCzAJBgNV
// SIG // BAYTAlVTMR0wGwYDVQQKExRTeW1hbnRlYyBDb3Jwb3Jh
// SIG // dGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0
// SIG // d29yazEoMCYGA1UEAxMfU3ltYW50ZWMgU0hBMjU2IFRp
// SIG // bWVTdGFtcGluZyBDQTCCASIwDQYJKoZIhvcNAQEBBQAD
// SIG // ggEPADCCAQoCggEBALtZnVlVT52Mcl0agaLrVfOwAa08
// SIG // cawyjwVrhponADKXak3JZBRLKbvC2Sm5Luxjs+HPPwtW
// SIG // kPhiG37rpgfi3n9ebUA41JEG50F8eRzLy60bv9iVkfPw
// SIG // 7mz4rZY5Ln/BJ7h4OcWEpe3tr4eOzo3HberSmLU6Hx45
// SIG // ncP0mqj0hOHE0XxxxgYptD/kgw0mw3sIPk35CrczSf/K
// SIG // O9T1sptL4YiZGvXA6TMU1t/HgNuR7v68kldyd/TNqMz+
// SIG // CfWTN76ViGrF3PSxS9TO6AmRX7WEeTWKeKwZMo8jwTJB
// SIG // G1kOqT6xzPnWK++32OTVHW0ROpL2k8mc40juu1MO1DaX
// SIG // hnjFoTcCAwEAAaOCAXcwggFzMA4GA1UdDwEB/wQEAwIB
// SIG // BjASBgNVHRMBAf8ECDAGAQH/AgEAMGYGA1UdIARfMF0w
// SIG // WwYLYIZIAYb4RQEHFwMwTDAjBggrBgEFBQcCARYXaHR0
// SIG // cHM6Ly9kLnN5bWNiLmNvbS9jcHMwJQYIKwYBBQUHAgIw
// SIG // GRoXaHR0cHM6Ly9kLnN5bWNiLmNvbS9ycGEwLgYIKwYB
// SIG // BQUHAQEEIjAgMB4GCCsGAQUFBzABhhJodHRwOi8vcy5z
// SIG // eW1jZC5jb20wNgYDVR0fBC8wLTAroCmgJ4YlaHR0cDov
// SIG // L3Muc3ltY2IuY29tL3VuaXZlcnNhbC1yb290LmNybDAT
// SIG // BgNVHSUEDDAKBggrBgEFBQcDCDAoBgNVHREEITAfpB0w
// SIG // GzEZMBcGA1UEAxMQVGltZVN0YW1wLTIwNDgtMzAdBgNV
// SIG // HQ4EFgQUr2PWyqNOhXLgp7xB8ymiOH+AdWIwHwYDVR0j
// SIG // BBgwFoAUtnf6aUhHn1MS1cLqBzJ2B9GXBxkwDQYJKoZI
// SIG // hvcNAQELBQADggEBAHXqsC3VNBlcMkX+DuHUT6Z4wW/X
// SIG // 6t3cT/OhyIGI96ePFeZAKa3mXfSi2VZkhHEwKt0eYRdm
// SIG // IFYGmBmNXXHy+Je8Cf0ckUfJ4uiNA/vMkC/WCmxOM+zW
// SIG // tJPITJBjSDlAIcTd1m6JmDy1mJfoqQa3CcmPU1dBkC/h
// SIG // Hk1O3MoQeGxCbvC2xfhhXFL1TvZrjfdKer7zzf0D19n2
// SIG // A6gP41P3CnXsxnUuqmaFBJm3+AZX4cYO9uiv2uybGB+q
// SIG // ueM6AL/OipTLAduexzi7D1Kr0eOUA2AKTaD+J20UMvw/
// SIG // l0Dhv5mJ2+Q5FL3a5NPD6itas5VYVQR9x5rsIwONhSrS
// SIG // /66pYYEwggVLMIIEM6ADAgECAhB71OWvuswHP6EBIwQi
// SIG // QU0SMA0GCSqGSIb3DQEBCwUAMHcxCzAJBgNVBAYTAlVT
// SIG // MR0wGwYDVQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlvbjEf
// SIG // MB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazEo
// SIG // MCYGA1UEAxMfU3ltYW50ZWMgU0hBMjU2IFRpbWVTdGFt
// SIG // cGluZyBDQTAeFw0xNzEyMjMwMDAwMDBaFw0yOTAzMjIy
// SIG // MzU5NTlaMIGAMQswCQYDVQQGEwJVUzEdMBsGA1UEChMU
// SIG // U3ltYW50ZWMgQ29ycG9yYXRpb24xHzAdBgNVBAsTFlN5
// SIG // bWFudGVjIFRydXN0IE5ldHdvcmsxMTAvBgNVBAMTKFN5
// SIG // bWFudGVjIFNIQTI1NiBUaW1lU3RhbXBpbmcgU2lnbmVy
// SIG // IC0gRzMwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEK
// SIG // AoIBAQCvDoqq+Ny/aXtUF3FHCb2NPIH4dBV3Z5Cc/d5O
// SIG // Ap5LdvblNj5l1SQgbTD53R2D6T8nSjNObRaK5I1AjSKq
// SIG // vqcLG9IHtjy1GiQo+BtyUT3ICYgmCDr5+kMjdUdwDLNf
// SIG // W48IHXJIV2VNrwI8QPf03TI4kz/lLKbzWSPLgN4TTfkQ
// SIG // yaoKGGxVYVfR8QIsxLWr8mwj0p8NDxlsrYViaf1OhcGK
// SIG // UjGrW9jJdFLjV2wiv1V/b8oGqz9KtyJ2ZezsNvKWlYEm
// SIG // LP27mKoBONOvJUCbCVPwKVeFWF7qhUhBIYfl3rTTJrJ7
// SIG // QFNYeY5SMQZNlANFxM48A+y3API6IsW0b+XvsIqbAgMB
// SIG // AAGjggHHMIIBwzAMBgNVHRMBAf8EAjAAMGYGA1UdIARf
// SIG // MF0wWwYLYIZIAYb4RQEHFwMwTDAjBggrBgEFBQcCARYX
// SIG // aHR0cHM6Ly9kLnN5bWNiLmNvbS9jcHMwJQYIKwYBBQUH
// SIG // AgIwGRoXaHR0cHM6Ly9kLnN5bWNiLmNvbS9ycGEwQAYD
// SIG // VR0fBDkwNzA1oDOgMYYvaHR0cDovL3RzLWNybC53cy5z
// SIG // eW1hbnRlYy5jb20vc2hhMjU2LXRzcy1jYS5jcmwwFgYD
// SIG // VR0lAQH/BAwwCgYIKwYBBQUHAwgwDgYDVR0PAQH/BAQD
// SIG // AgeAMHcGCCsGAQUFBwEBBGswaTAqBggrBgEFBQcwAYYe
// SIG // aHR0cDovL3RzLW9jc3Aud3Muc3ltYW50ZWMuY29tMDsG
// SIG // CCsGAQUFBzAChi9odHRwOi8vdHMtYWlhLndzLnN5bWFu
// SIG // dGVjLmNvbS9zaGEyNTYtdHNzLWNhLmNlcjAoBgNVHREE
// SIG // ITAfpB0wGzEZMBcGA1UEAxMQVGltZVN0YW1wLTIwNDgt
// SIG // NjAdBgNVHQ4EFgQUpRMBqZ+FzBtuFh5fOzGqeTYAex0w
// SIG // HwYDVR0jBBgwFoAUr2PWyqNOhXLgp7xB8ymiOH+AdWIw
// SIG // DQYJKoZIhvcNAQELBQADggEBAEaer/C4ol+imUjPqCdL
// SIG // Ic2yuaZycGMv41UpezlGTud+ZQZYi7xXipINCNgQujYk
// SIG // +gp7+zvTYr9KlBXmgtuKVG3/KP5nz3E/5jMJ2aJZEPQe
// SIG // Sv5lzN7Ua+NSKXUASiulzMub6KlN97QXWZJBw7c/hub2
// SIG // wH9EPEZcF1rjpDvVaSbVIX3hgGd+Yqy3Ti4VmuWcI69b
// SIG // EepxqUH5DXk4qaENz7Sx2j6aescixXTN30cJhsT8kSWy
// SIG // G5bphQjo3ep0YG5gpVZ6DchEWNzm+UgUnuW/3gC9d7GY
// SIG // FHIUJN/HESwfAD/DSxTGZxzMHgajkF9cVIs+4zNbgg/F
// SIG // t4YCTnGf6WZFP3YxggJaMIICVgIBATCBizB3MQswCQYD
// SIG // VQQGEwJVUzEdMBsGA1UEChMUU3ltYW50ZWMgQ29ycG9y
// SIG // YXRpb24xHzAdBgNVBAsTFlN5bWFudGVjIFRydXN0IE5l
// SIG // dHdvcmsxKDAmBgNVBAMTH1N5bWFudGVjIFNIQTI1NiBU
// SIG // aW1lU3RhbXBpbmcgQ0ECEHvU5a+6zAc/oQEjBCJBTRIw
// SIG // CwYJYIZIAWUDBAIBoIGkMBoGCSqGSIb3DQEJAzENBgsq
// SIG // hkiG9w0BCRABBDAcBgkqhkiG9w0BCQUxDxcNMjAwMzIz
// SIG // MTQwMzExWjAvBgkqhkiG9w0BCQQxIgQgnvnJEuo/BJd5
// SIG // ZN1QVM6HQxnXV57UxBgY9TFzrsCD1akwNwYLKoZIhvcN
// SIG // AQkQAi8xKDAmMCQwIgQgxHTOdgB9AjlODaXk3nwUxoD5
// SIG // 4oIBPP72U+9dtx/fYfgwCwYJKoZIhvcNAQEBBIIBAJ3O
// SIG // OvQ3uUlQokAJQGnzB90Pcjm+Cu6Dl+pckjD4+YYSSZzz
// SIG // BtlWIelvcrw6M/4U2MP3/qeAJ5/SHTn5+9inTrJvj8vn
// SIG // phVjLP3g35v9kOLo+vkWyN3C483XuO9j5Hvl6HgzpC4T
// SIG // ocX2T5BP73cedDiz8Pb3/lv1KG8xWIFlxjAf9qaiPMy9
// SIG // mlwJEmKP8dmF9JkZXFj7jk5J9ilOs31//QIkAN4hpkPJ
// SIG // 8mqXy7RZ50GmkhsmejsQ63mpONgrjSZaNB7PgSio/MoM
// SIG // xRjsXmD8fDznmkyTfi2etRZejbT5Ktuo3VgSXjXD9zOi
// SIG // dtGjOoK2NN1cKhhuH4ajNPqUwV9RLgM=
// SIG // End signature block
