var topic = "<!DOCTYPE html>\r\n\n<!-- saved from url=(0024)http://docs.autodesk.com -->\r\n<html>\n   <head>\n      <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n      <meta name=\"product\" content=\"VAULT\">\n      <meta name=\"release\" content=\"2021\">\n      <meta name=\"book\" content=\"GeneralUser\">\n      <meta name=\"created\" content=\"2020-03-20\">\n      <meta name=\"topicid\" content=\"GUID-5F0C9F22-0288-471E-8D64-D5F57FBE300A\">\n      <meta name=\"description\" content=\"Learn about properties in Vault.\">\n      <meta name=\"contextid\" content=\"ID_DOCUMENTPSADMINPAGE_VE\">\n      <meta name=\"contextid\" content=\"ID_DOCUMENTPSADMINPAGE_INV\">\n      <meta name=\"topic-type\" content=\"concept\">\n      <meta name=\"audience\" content=\"user\">\n      <meta name=\"experiencelevel\" content=\"novice\">\n      <title>Properties</title><script language=\"javascript\">var index = \'index.html\';</script></head>\n   <body height=\"100%\">\n      <div class=\"body_content\" id=\"body-content\" dir=\"ltr\"><a name=\"GUID-5F0C9F22-0288-471E-8D64-D5F57FBE300A\"></a><div class=\"head\">\n            <h1>Properties</h1>\n         </div>\n         <p class=\"blurb\"> Learn about properties in Vault. \n            <!--CPM-ContextId = \'ID_DOCUMENTPSADMINPAGE_VE\'--><a name=\"GUID-99166F86-493E-4A1A-8E52-8A251DC193FD\"></a> \n            <!--CPM-ContextId = \'ID_DOCUMENTPSADMINPAGE_INV\'--><a name=\"GUID-F1B3FE13-C0B3-4AF1-8B6E-F76F8FC0ABDA\"></a> \n         </p>\n         <p><a name=\"GUID-C0D41EF5-7660-4EA2-A687-C55714A8E284\"></a>Properties are attributes associated with a file. Vault recognizes two types of property\n            definitions: system-defined properties and user-defined properties (UDPs). System-defined\n            properties are those that are derived from the vault. The vault has a global set of\n            properties that are applied to files in the vault. User-defined properties are created\n            by using the administrative tools. \n         </p>\n         <div><a name=\"GUID-D890D3DF-0FA7-40D2-8DA7-4FD1369AA33C\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span> Property Administration includes tasks to create and manage property definitions.\n               You must have administrative access to perform these tasks. \n            </div>\n         </div>\n         <p><a name=\"GUID-3507EA85-1049-42CF-B8F9-404CA21CE895\"></a>Before working with properties, it is important to become familiar with the terms,\n            data types, and attributes associated with the Vault properties system. \n         </p>\n         <div class=\"section\"><a name=\"SECTION_5860266EF76844E4B18B25A483D37C65\"></a> \n            <h2><a name=\"GUID-F660C954-3B7A-4BDD-9ACA-0114D65B2A37\"></a>Common Terms\n            </h2> \n            <p><a name=\"GUID-2121A4F7-E16B-4B9D-A1C8-B88F61CF3625\"></a>The following table contains terms commonly used with properties. \n            </p> <a name=\"TABLE_76B36FBE7FF74377A75B86CA80F13B6D\"></a><div class=\"table-ruled\">\n               <table cellpadding=\"0\" cellspacing=\"0\" class=\"ruled\">\n                  <colgroup>\n                     <col width=\"14.577312331367509%\">\n                     <col width=\"85.42268766863249%\">\n                  </colgroup>\n                  <tr class=\"ruled-heading\">\n                     <th class=\"table-heading\"> <a name=\"GUID-9CBB892F-7619-46C5-A579-CB13641253DC\"></a><p class=\"table-heading\">Term </p> \n                     </th>\n                     <th class=\"table-heading\"> <a name=\"GUID-E8AED511-2598-4F86-BCA9-9DF10D14E042\"></a><p class=\"table-heading\">Definition </p> \n                     </th>\n                  </tr>\n                  <tr class=\"ruled-odd-row\">\n                     <td class=\"table-body\"> <a name=\"GUID-56F400E8-B16A-4CA8-84F2-3772F0A28DEC\"></a><p class=\"table-body\">Associations </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-BE5F5BD0-EB46-4DF5-91DB-E2811E456020\"></a><p class=\"table-body\">Attribute that determines whether the property is associated with a file, an item,\n                           or a change order. \n                        </p> \n                     </td>\n                  </tr>\n                  <tr class=\"ruled-even-row\">\n                     <td class=\"table-body\"> <a name=\"GUID-2B1EBDA9-F856-41CC-9AC0-513B313240A3\"></a><p class=\"table-body\">Compliant </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-64938C0B-4BF4-4190-9893-1EB9EBCFC7D5\"></a><p class=\"table-body\">The status of a property that meets all property policies and equivalence evaluations.\n                           \n                        </p> \n                     </td>\n                  </tr>\n                  <tr class=\"ruled-odd-row\">\n                     <td class=\"table-body\"> <a name=\"GUID-0DA6DCA4-2E50-4521-B0FF-59A4A424641E\"></a><p class=\"table-body\">Data Type </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-88C24008-004A-492E-A6B9-72541B704B01\"></a><p class=\"table-body\">The type of data accepted for the property value. This type can be text, number, boolean,\n                           or date. \n                        </p> \n                     </td>\n                  </tr>\n                  <tr class=\"ruled-even-row\">\n                     <td class=\"table-body\"> <a name=\"GUID-FE9461E8-75D3-4E8C-8E61-2B31B0137619\"></a><p class=\"table-body\">Database Property </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-9BD5528F-5330-49C4-A8D1-3543D81936C4\"></a><p class=\"table-body\">Any property in the database, either user defined or system. </p> \n                     </td>\n                  </tr>\n                  <tr class=\"ruled-odd-row\">\n                     <td class=\"table-body\"> <a name=\"GUID-620387E3-868D-45FF-AA8B-21F0DC0A4B5E\"></a><p class=\"table-body\">Entity </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-B9F3529B-9174-4F88-B503-6BB41C676BA9\"></a><p class=\"table-body\">An entity is the system class with which a file can be associated. Entities are files,\n                           items, or change orders. \n                        </p> \n                     </td>\n                  </tr>\n                  <tr class=\"ruled-even-row\">\n                     <td class=\"table-body\"> <a name=\"GUID-78CEF20C-70F2-4AD3-9D15-CAACCB7A0C6D\"></a><p class=\"table-body\">Equivalent </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-1D47F99B-E31A-47C1-8329-D48E5ACFDBC9\"></a><p class=\"table-body\">The status of a mapped property when its value matches the source value. </p> \n                     </td>\n                  </tr>\n                  <tr class=\"ruled-odd-row\">\n                     <td class=\"table-body\"> <a name=\"GUID-B2B16C54-ABDD-495C-9808-8566B1DC1A60\"></a><p class=\"table-body\">File Property </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-1DB7BE4C-56CA-4D78-9EA0-D820C2EA2185\"></a><p class=\"table-body\">A property associated with a file. </p> \n                     </td>\n                  </tr>\n                  <tr class=\"ruled-even-row\">\n                     <td class=\"table-body\"> <a name=\"GUID-E3F45BBC-81AE-441F-A7BE-7D6617484946\"></a><p class=\"table-body\">Mapped Property </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-21895B60-7E08-4E21-86F9-2A4694F77DE6\"></a><p class=\"table-body\">A property from which the propriety being defined gets its value. For example, a UDP\n                           can get its value from several different file properties. A file property can get\n                           its value from a system property. \n                        </p> \n                     </td>\n                  </tr>\n                  <tr class=\"ruled-odd-row\">\n                     <td class=\"table-body\"> <a name=\"GUID-737D77F2-7755-4433-8F8A-599012C2AFE1\"></a><p class=\"table-body\">Mapping </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-A602CE6F-B110-4FC7-B146-D3619611E0E0\"></a><p class=\"table-body\">A set of relationships between the property being defined and a property from which\n                           it receives its value. There can be multiple mappings for a given property definition.\n                           \n                        </p> \n                     </td>\n                  </tr>\n                  <tr class=\"ruled-even-row\">\n                     <td class=\"table-body\"> <a name=\"GUID-42876CDE-E507-4451-AD50-DB5E2A4B3D83\"></a><p class=\"table-body\">Master </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-6DC8AE49-9686-4E4C-A759-BD202DAE6C6D\"></a><p class=\"table-body\">The property from which a mapped property gets its value. The master property writes\n                           its value to the subordinate property. \n                        </p> \n                     </td>\n                  </tr>\n                  <tr class=\"ruled-odd-row\">\n                     <td class=\"table-body\"> <a name=\"GUID-A2BABBB2-596E-43EC-B9D5-F510457F0117\"></a><p class=\"table-body\">Non-compliant </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-DD1454DD-5331-4A79-B863-93EDBFA73F58\"></a><p class=\"table-body\">The status of a property when it has failed to meet one or more property policies\n                           or its equivalence evaluation. \n                        </p> \n                     </td>\n                  </tr>\n                  <tr class=\"ruled-even-row\">\n                     <td class=\"table-body\"> <a name=\"GUID-828E0921-F531-4E6A-B9A9-87901F9757E2\"></a><p class=\"table-body\">Non-equivalent </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-F3900979-170F-4DEA-A446-C4CD65949A5A\"></a><p class=\"table-body\">The status of a mapped property when its value does not match the source value. </p> \n                     </td>\n                  </tr>\n                  <tr class=\"ruled-odd-row\">\n                     <td class=\"table-body\"> <a name=\"GUID-A3EB3E94-046E-4368-B459-F689079F9284\"></a><p class=\"table-body\">Property Definition </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-917A1B11-324E-4FF3-87AA-63A46F8D59EA\"></a><p class=\"table-body\">All attributes and constraints about the property including its name, data type, initial\n                           value, mapping, minimum and maximum values, case values, in-use value, and basic search\n                           value. \n                        </p> \n                     </td>\n                  </tr>\n                  <tr class=\"ruled-even-row\">\n                     <td class=\"table-body\"> <a name=\"GUID-FAABA9A7-2FD3-43E4-A696-34862106E23D\"></a><p class=\"table-body\">Property Name </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-7C5328BA-AAE3-45A8-A1AE-FF1F30F0FF43\"></a><p class=\"table-body\">The name used in the GUI (graphical user interface) to identify the property. </p> \n                     </td>\n                  </tr>\n                  <tr class=\"ruled-odd-row\">\n                     <td class=\"table-body\"> <a name=\"GUID-147D762F-D7F3-4700-B5E8-73102A39F540\"></a><p class=\"table-body\">Property Policy </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-986AD337-270D-455B-9564-CA46BB95576F\"></a><p class=\"table-body\">Depending on the data type, the property policy specifies certain constraints that\n                           must be met. The constraints may include a value range, a value type, or a value format\n                           must be met. For example, a property policy might be described as follows: the property\n                           must have a value and that value must be in the range of 1 to 10. When a property\n                           fails to meet its property policies, it is considered non-compliant. \n                        </p> \n                     </td>\n                  </tr>\n                  <tr class=\"ruled-even-row\">\n                     <td class=\"table-body\"> <a name=\"GUID-7A16AF8E-D057-49D3-84EA-7BB7291E24EF\"></a><p class=\"table-body\">Property Value </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-9AE7355F-7B79-4B73-A9C2-8730FBAA655C\"></a><p class=\"table-body\">The literal content of a property attribute for a specific file version. </p> \n                     </td>\n                  </tr>\n                  <tr class=\"ruled-odd-row\">\n                     <td class=\"table-body\"> <a name=\"GUID-F5151B17-C71F-40A8-BC2B-10B4912D1B25\"></a><p class=\"table-body\">Override </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-06A14054-A3EE-44BB-BECC-48327801D030\"></a><p class=\"table-body\">Determines whether the property value is over-ridden by the policy defined by its\n                           category. \n                        </p> \n                     </td>\n                  </tr>\n                  <tr class=\"ruled-even-row\">\n                     <td class=\"table-body\"> <a name=\"GUID-28DD1527-D056-41FD-815F-7B3EAE98E8F7\"></a><p class=\"table-body\">Subordinate </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-DFA6F3B2-ECF0-46AD-94C2-9BA2629E6C58\"></a><p class=\"table-body\">The mapped property that receives its value from the master property. </p> \n                     </td>\n                  </tr>\n                  <tr class=\"ruled-odd-row\">\n                     <td class=\"table-body\"> <a name=\"GUID-B11E173C-88E6-4BD6-A416-7F191820328B\"></a><p class=\"table-body\">System-Defined Property </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-0F38EF94-E588-424F-959C-580CC377F7BD\"></a><p class=\"table-body\">A property in the database created by the system, which is then assigned to a file.\n                           \n                        </p> \n                     </td>\n                  </tr>\n                  <tr class=\"ruled-even-row\">\n                     <td class=\"table-body\"> <a name=\"GUID-D0174E31-89A9-481A-BDBD-FB5C29C47EE9\"></a><p class=\"table-body\">User-Defined Property (UDP) </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-7EEB0BAA-697E-4206-B4B9-050F28E0CB01\"></a><p class=\"table-body\">A property in the database created by an administrator. The property can be applied\n                           to a file when it is added to a vault. \n                        </p> \n                     </td>\n                  </tr>\n               </table>\n            </div> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_B708C79E3CDE4544AC7FFF5698E55749\"></a> \n            <h2><a name=\"GUID-90EA4FB6-AA5A-4B4D-8AE4-05D37E3F909E\"></a>Data Types\n            </h2> \n            <p><a name=\"GUID-20682480-3B4A-453F-95D3-B7D1016601D9\"></a>Every property value has a data type that determines how that value is read and processed.\n               \n            </p> <a name=\"TABLE_C60B108ED7D44694B71A5ECD63CF609C\"></a><div class=\"table-ruled\">\n               <table cellpadding=\"0\" cellspacing=\"0\" class=\"ruled\">\n                  <colgroup>\n                     <col>\n                     <col>\n                  </colgroup>\n                  <tr class=\"ruled-heading\">\n                     <th class=\"table-heading\"> <a name=\"GUID-3D695697-2C12-4690-95C0-6DB639D677AD\"></a><p class=\"table-heading\"> <em class=\"strong\">Data Type Name </em> \n                        </p> \n                     </th>\n                     <th class=\"table-heading\"> <a name=\"GUID-140614C3-020F-4557-9CA3-323AB0DAAFF4\"></a><p class=\"table-heading\"> <em class=\"strong\">Description </em> \n                        </p> \n                     </th>\n                  </tr>\n                  <tr class=\"ruled-odd-row\">\n                     <td class=\"table-body\"> <a name=\"GUID-FC9C4B1B-869C-4C41-B5CE-4E0585640F23\"></a><p class=\"table-body\">Boolean </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-F7E29C38-806E-4949-AADB-D26EBDA653BE\"></a><p class=\"table-body\">True or False. </p> \n                     </td>\n                  </tr>\n                  <tr class=\"ruled-even-row\">\n                     <td class=\"table-body\"> <a name=\"GUID-18FA7328-EAAC-4288-9F85-429B0E93DCDE\"></a><p class=\"table-body\">Date Type </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-D9752CBE-C9D4-4E7D-AF2F-5FA7851656EE\"></a><p class=\"table-body\">Can be a specific date or date range expressed by a beginning and end date. </p> \n                     </td>\n                  </tr>\n                  <tr class=\"ruled-odd-row\">\n                     <td class=\"table-body\"> <a name=\"GUID-079A5FFD-63EF-4D00-8294-1F7A1C006294\"></a><p class=\"table-body\">Number </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-FB941402-A91D-4DDC-9096-F0286ADE28A9\"></a><p class=\"table-body\">Numbers only. </p> \n                     </td>\n                  </tr>\n                  <tr class=\"ruled-even-row\">\n                     <td class=\"table-body\"> <a name=\"GUID-BA17038B-840F-402A-995C-DF6B6D27A5F0\"></a><p class=\"table-body\">Text </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-3B2791F7-1AB7-4D28-B438-24154DE132FA\"></a><p class=\"table-body\">Letters and numbers. </p> \n                     </td>\n                  </tr>\n               </table>\n            </div> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_6CA5F2366CCE49079B83062A1DA48F17\"></a> \n            <h2><a name=\"GUID-DABFEBF0-D0EC-47A8-859F-6E0CFF13FDF7\"></a>Attributes\n            </h2> \n            <p><a name=\"GUID-33F00D8B-200D-4C80-9B8F-710540A8D79C\"></a>Properties have attributes that determine how the property is described and the constraints\n               for its value. \n            </p> <a name=\"TABLE_09DE0D90E08348259E83654E0249D839\"></a><div class=\"table-ruled\">\n               <table cellpadding=\"0\" cellspacing=\"0\" class=\"ruled\">\n                  <colgroup>\n                     <col width=\"40.18175413878126%\">\n                     <col width=\"59.81824586121874%\">\n                  </colgroup>\n                  <tr class=\"ruled-heading\">\n                     <th class=\"table-heading\"> <a name=\"GUID-DC11335F-B84F-41BD-921F-25D074F1EFC6\"></a><p class=\"table-heading\"> <em class=\"strong\">Attribute Name</em> \n                        </p> \n                     </th>\n                     <th class=\"table-heading\"> <a name=\"GUID-C3677756-9210-4226-B11A-96405C57D20A\"></a><p class=\"table-heading\"> <em class=\"strong\">Description </em> \n                        </p> \n                     </th>\n                  </tr>\n                  <tr class=\"ruled-odd-row\">\n                     <td class=\"table-body\"> <a name=\"GUID-4B5A9CD1-1A96-4E67-ACC3-31C89836AF5D\"></a><p class=\"table-body\">Basic Search </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-837DE703-C94C-48C9-83E0-278B72C332A7\"></a><p class=\"table-body\">A constraint that determines whether or not the property should be included in basic\n                           searches. \n                        </p> \n                     </td>\n                  </tr>\n                  <tr class=\"ruled-even-row\">\n                     <td class=\"table-body\"> <a name=\"GUID-92F51910-BAA8-4DA8-9E98-F6C3DD6942D7\"></a><p class=\"table-body\">Case Sensitivity </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-3D8912C6-A03D-4098-870E-5545A78D6542\"></a><p class=\"table-body\">A constraint that applies to text data types. This constraint can be set to none,\n                           UPPER CASE, lower case, Name Case or Sentence case. \n                        </p> \n                     </td>\n                  </tr>\n                  <tr class=\"ruled-odd-row\">\n                     <td class=\"table-body\"> <a name=\"GUID-8DF3FE3D-AE6E-4428-A29A-7509D001BBE0\"></a><p class=\"table-body\">Enforce List of Values </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-448D0127-84ED-4B57-A3A5-2B8B287EA293\"></a><p class=\"table-body\">A constraint that determines whether the property must have a value from a list. </p> \n                     </td>\n                  </tr>\n                  <tr class=\"ruled-even-row\">\n                     <td class=\"table-body\"> <a name=\"GUID-67ED0827-0269-45AB-BAF1-BC6EDD106736\"></a><p class=\"table-body\">Initial Value </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-524D2D98-2CB6-43D0-B495-BFB07B0B5EA4\"></a><p class=\"table-body\">An attribute that specifies the initial property value when one isn\'t specified. Note:\n                           Initial values are best used with write mappings. If an initial value is set on a\n                           regular read mapping, that read mapping has higher priority and will overwrite the\n                           initial value. The only case in which an initial value won\'t be overwritten by a read\n                           mapping is if the value it maps to is blank. \n                        </p> \n                     </td>\n                  </tr>\n                  <tr class=\"ruled-odd-row\">\n                     <td class=\"table-body\"> <a name=\"GUID-1BDF1351-AB44-4BD4-8207-44B01A0664D3\"></a><p class=\"table-body\">List Values </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-0134CA17-BEDE-4562-8254-589A7A69E7AF\"></a><p class=\"table-body\">Displays the List Type dialog box from which you can enter and order values for a\n                           list. At least one item must appear in the list. \n                        </p> \n                     </td>\n                  </tr>\n                  <tr class=\"ruled-even-row\">\n                     <td class=\"table-body\"> <a name=\"GUID-CAE28E20-EABF-4E4D-87A9-548DABBF2A9C\"></a><p class=\"table-body\">Minimum Length </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-65B61B81-2D0B-47F4-B816-D102BF3DF554\"></a><p class=\"table-body\">The mininum number of characters a property value can have. </p> \n                     </td>\n                  </tr>\n                  <tr class=\"ruled-odd-row\">\n                     <td class=\"table-body\"> <a name=\"GUID-FB6875D8-8C94-4468-8B8C-BD8FA09A69AE\"></a><p class=\"table-body\">Maximum Length </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-7A15343B-3FA7-4F6D-9FD6-5EF2F9069630\"></a><p class=\"table-body\">The maximum number of characters a property value can have. </p> \n                     </td>\n                  </tr>\n                  <tr class=\"ruled-even-row\">\n                     <td class=\"table-body\"> <a name=\"GUID-F99466B0-20A0-4FB6-9341-1A97E9D2F487\"></a><p class=\"table-body\">Requires Value </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-0961506F-9DAD-4D3D-8BC3-AE3AE56D9668\"></a><p class=\"table-body\">A constraint which determines whether the property must have a value to be compliant.\n                           \n                        </p> \n                     </td>\n                  </tr>\n                  <tr class=\"ruled-odd-row\">\n                     <td class=\"table-body\"> <a name=\"GUID-5DA54E13-471C-44B3-A6A8-D47274447339\"></a><p class=\"table-body\">State </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-36C2D1BB-BC4E-44BE-BCC6-D83A5FC73E6E\"></a><p class=\"table-body\">A setting on a property that indicates whether it recognizes the state the file in\n                           a lifecycle. \n                        </p> \n                     </td>\n                  </tr>\n                  <tr class=\"ruled-even-row\">\n                     <td class=\"table-body\"> <a name=\"GUID-00D617E0-2F48-4150-A405-F7AAA864F33C\"></a><p class=\"table-body\">Usage </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-FE760314-48BC-40AD-909F-452C8D86580F\"></a><p class=\"table-body\">Indicates the number of files currently using the property. Use this information to\n                           determine which properties are used more than others, to help decide which properties\n                           can be removed from the vault. \n                        </p> \n                     </td>\n                  </tr>\n               </table>\n            </div> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_8E1BB7FC063E476FB20CE08B55F27C55\"></a> \n            <h2><a name=\"GUID-1F0ABB62-3EC9-40AF-9923-2C45CEC65F64\"></a>Property Compliance Icons\n            </h2> \n            <p><a name=\"GUID-0F24A713-EC63-4252-8115-89B9A73438F1\"></a>The main view in the vault client has a Property Compliance column that lists various\n               status icons. The Icons in this column indicate whether a property associated with\n               the file is compliant, non-compliant, pending, or has failed the equivalence evaluation.\n               \n            </p> <a name=\"TABLE_0A6F6926CAF04D4B82DD8706AC7DC927\"></a><div class=\"table-ruled\">\n               <table cellpadding=\"0\" cellspacing=\"0\" class=\"ruled\">\n                  <colgroup>\n                     <col>\n                     <col>\n                     <col>\n                  </colgroup>\n                  <tr class=\"ruled-heading\">\n                     <th class=\"table-heading\"> <a name=\"GUID-16983EEE-CE65-4B7B-83CC-94656FAF3CC2\"></a><p class=\"table-heading\"> <em class=\"strong\">Icon</em> \n                        </p> \n                     </th>\n                     <th class=\"table-heading\"> <a name=\"GUID-3655F707-23E4-4178-B353-279265E3DDEC\"></a><p class=\"table-heading\"> <em class=\"strong\">Value</em> \n                        </p> \n                     </th>\n                     <th class=\"table-heading\"> <a name=\"GUID-C6F4CFD6-2156-4FDE-9CCE-A43C86439386\"></a><p class=\"table-heading\"> <em class=\"strong\">Definition</em> \n                        </p> \n                     </th>\n                  </tr>\n                  <tr class=\"ruled-odd-row\">\n                     <td class=\"table-body\"> <a name=\"GUID-791958C0-8B8A-4929-8F7B-D199B52D8211\"></a><p class=\"table-body\">No icon </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-A6F60438-CCFA-46EC-9DAB-5EB9B9A02A44\"></a><p class=\"table-body\">Compliant </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-24EB419F-4692-4D7A-A4C4-737671CB1D97\"></a><p class=\"table-body\">All properties meet policy requirements and equivalence. </p> \n                     </td>\n                  </tr>\n                  <tr class=\"ruled-even-row\">\n                     <td class=\"table-body\">&nbsp; <img src=\"../images/GUID-0E40A727-9DBC-47AF-8DEA-5AF7970CF29B-low.gif\"> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-C38B2746-AAE8-4B85-95A6-560FB7F476D8\"></a><p class=\"table-body\">Non-compliant </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-C43B3565-DAB4-404A-8D27-FC0017492770\"></a><p class=\"table-body\">One or more properties do not meet property policy requirements or equivalence. </p> <a name=\"GUID-189D3031-B8F9-44F2-B722-7C26EE1431DD\"></a><p class=\"table-body\">Hover your mouse over the icon to learn more about why one or more properties failed\n                           compliance. \n                        </p> \n                     </td>\n                  </tr>\n                  <tr class=\"ruled-odd-row\">\n                     <td class=\"table-body\">&nbsp; <img src=\"../images/GUID-DA625114-8E1B-416B-978C-59B2AC231C93-low.png\"> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-AADB783D-E5E4-46F7-9626-2F933C54F0D9\"></a><p class=\"table-body\">Not calculated </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-2CEB033B-BAB4-4337-893C-2FB9157A2B2C\"></a><p class=\"table-body\">There has been a change to one or more properties but equivalence and policy have\n                           not been verified yet. \n                        </p> \n                     </td>\n                  </tr>\n                  <tr class=\"ruled-even-row\">\n                     <td class=\"table-body\">&nbsp; <img src=\"../images/GUID-E63A2DF4-1AF3-476C-A1F5-F01A5C86A048-low.png\"> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-D5F12320-DEA9-4025-9DD9-01769B9C2256\"></a><p class=\"table-body\">Pending </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-FE980E02-3B9F-4D9F-8C1C-400D00E0EE60\"></a><p class=\"table-body\">Properties are currently being evaluated for equivalence. </p> \n                     </td>\n                  </tr>\n                  <tr class=\"ruled-odd-row\">\n                     <td class=\"table-body\">&nbsp; <img src=\"../images/GUID-3E84E082-0D55-4741-85F5-A68C3D6988E2-low.png\"> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-35F59662-0207-4263-9E1E-C5FCD7F396D5\"></a><p class=\"table-body\">Evaluation failed. </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-BACCDCE5-3588-4A0B-889E-CF0D51E2D710\"></a><p class=\"table-body\">The equivalence evaluation failed. This is a rare situation and can result when the\n                           processor enters an evaluation loop. \n                           <div><a name=\"GUID-310A6D7B-D79E-467F-BED3-8EF91499CE4E\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span>On the Find dialog, an evaluation failed value is added. This allows you to search\n                                 for any files for which the evaluation failed. \n                              </div>\n                           </div> \n                        </p> \n                     </td>\n                  </tr>\n               </table>\n            </div> \n         </div><span class=\"noindex\">\n            <div class=\"topic-list\">\n               <h4 class=\"related\">Topics in this section</h4>\n               <ul class=\"jumplist\">\n                  <li class=\"topiclist-litem\"><a href=\"GUID-F1EB65CD-2491-422D-92B8-4EEB62BC9626.htm\">Work with Properties in the Vault Client</a><p>User-defined properties in a vault can be edited using the Edit Properties command.\n                        \n                        \n                     </p>\n                  </li>\n                  <li class=\"topiclist-litem\"><a href=\"GUID-11A427DB-701F-4C81-9EB2-F6E732EBBC11.htm\">Update Properties–Vault Add-ins</a><p>File properties can be mapped to data in \n                        	 Autodesk Vault \n                        		. If the mapped properties are edited, the data can be updated using the Update\n                        File Properties command. This action keeps the data and assigned properties synchronized.\n                        \n                        \n                     </p>\n                  </li>\n               </ul>\n            </div></span><div class=\"footer-block\"><a href=\"..\" class=\"comments-anchor\" target=\"_blank\"><span class=\"comments-link\">Please send us your comment about this page</span></a></div><br><p class=\"footer-license-block\"><a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\"><img alt=\"Creative Commons License\" style=\"border-width: 0;\" src=\"../images/ccLink.png\"></a>&nbsp;<em>Except where otherwise noted, this work is licensed under a <a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\">Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License</a>. Please see the <a href=\"http://autodesk.com/creativecommons\" target=\"_blank\">Autodesk Creative Commons FAQ</a> for more information.</em></p><br></div>\n   </body>\n</html>";
// SIG // Begin signature block
// SIG // MIIZfQYJKoZIhvcNAQcCoIIZbjCCGWoCAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // 7/i1u8nGmLeVy5OioOfeT6UAZWw+0ztr089YtRpZEfeg
// SIG // ggoaMIIEyzCCA7OgAwIBAgIQCQja65wGHi65un4mqmKH
// SIG // ijANBgkqhkiG9w0BAQsFADCBhDELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTUw
// SIG // MwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
// SIG // b2RlIFNpZ25pbmcgQ0EgLSBHMjAeFw0xOTA1MTQwMDAw
// SIG // MDBaFw0yMDA1MTMyMzU5NTlaMHwxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIDApDYWxpZm9ybmlhMRMwEQYDVQQHDApT
// SIG // YW4gUmFmYWVsMRcwFQYDVQQKDA5BdXRvZGVzaywgSW5j
// SIG // LjERMA8GA1UECwwIU2VjdXJpdHkxFzAVBgNVBAMMDkF1
// SIG // dG9kZXNrLCBJbmMuMIIBIjANBgkqhkiG9w0BAQEFAAOC
// SIG // AQ8AMIIBCgKCAQEAkVKRoPYsoxPdlabspcuG8HYDfcWQ
// SIG // 9qyPOT2punwpVdjt2slktcpSTlydrGy8ijcbl5/k8AOJ
// SIG // afKMQvow0fNjIoNB5nsb8j2xFJPbBhHl8GT4P6DZ1OWK
// SIG // ioiUXgGHKjctUws49J4elntqvBYhKCbuPqG772QCoYFU
// SIG // P7qcFbh3PbyNB6cnKMn2vNGRqiEtV2aGg+/MiL3QPsvT
// SIG // kTWhVuTLIvwZ4kK5C5ACiQzlGOlE+C7gWuFoxtvy6gUa
// SIG // A8JAq/xLjYKwFevQwGncg3s1cuiGhx0P7Rvn6oCd2cem
// SIG // FmbK3I3rMRt+jc9wzAj3oHxvCo4f5Lfva+OpC1dETUVV
// SIG // sk0VGwIDAQABo4IBPjCCATowCQYDVR0TBAIwADAOBgNV
// SIG // HQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMw
// SIG // YQYDVR0gBFowWDBWBgZngQwBBAEwTDAjBggrBgEFBQcC
// SIG // ARYXaHR0cHM6Ly9kLnN5bWNiLmNvbS9jcHMwJQYIKwYB
// SIG // BQUHAgIwGQwXaHR0cHM6Ly9kLnN5bWNiLmNvbS9ycGEw
// SIG // HwYDVR0jBBgwFoAU1MAGIknrOUvdk+JcobhHdglyA1gw
// SIG // KwYDVR0fBCQwIjAgoB6gHIYaaHR0cDovL3JiLnN5bWNi
// SIG // LmNvbS9yYi5jcmwwVwYIKwYBBQUHAQEESzBJMB8GCCsG
// SIG // AQUFBzABhhNodHRwOi8vcmIuc3ltY2QuY29tMCYGCCsG
// SIG // AQUFBzAChhpodHRwOi8vcmIuc3ltY2IuY29tL3JiLmNy
// SIG // dDANBgkqhkiG9w0BAQsFAAOCAQEA0Q2+iVSEfT4xGq3A
// SIG // OADVb0rT5Z8E+PPb1x6hKknSzuaZKk/acDz9mdnFajaU
// SIG // WgIKiFJlsqJnuAM1w4lqKaEWsz3DoxvGIEwexj71Ud6a
// SIG // KlBJNcR9DdkXUZwMhbw9d78rjJAIX6tOwfSludZfdq8b
// SIG // YEkuIzQi9uYW9vHVPSCzhnUBKjwc9qTo9yBc7Fcn4FAT
// SIG // 90DzWM2hS9oc3p0pprYI2I/O4th90BEmwWkVqVgfaR0z
// SIG // VyIEmBbqB/IWLfjUBZJ/8sbkwWuWlYVRrfPxsj1e9qvb
// SIG // wE3Y28jWyGbqoUG39GhXk3uT8R8i3+T6M0c4rMfdifBC
// SIG // pceCaFTJzSye7LoeVzCCBUcwggQvoAMCAQICEHwbNTVK
// SIG // 59t050FfEWnKa6gwDQYJKoZIhvcNAQELBQAwgb0xCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjEfMB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29y
// SIG // azE6MDgGA1UECxMxKGMpIDIwMDggVmVyaVNpZ24sIElu
// SIG // Yy4gLSBGb3IgYXV0aG9yaXplZCB1c2Ugb25seTE4MDYG
// SIG // A1UEAxMvVmVyaVNpZ24gVW5pdmVyc2FsIFJvb3QgQ2Vy
// SIG // dGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMTQwNzIyMDAw
// SIG // MDAwWhcNMjQwNzIxMjM1OTU5WjCBhDELMAkGA1UEBhMC
// SIG // VVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9u
// SIG // MR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3Jr
// SIG // MTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1
// SIG // NiBDb2RlIFNpZ25pbmcgQ0EgLSBHMjCCASIwDQYJKoZI
// SIG // hvcNAQEBBQADggEPADCCAQoCggEBANeVQ9Tc32euOftS
// SIG // pLYmMQRw6beOWyq6N2k1lY+7wDDnhthzu9/r0XY/ilaO
// SIG // 6y1L8FcYTrGNpTPTC3Uj1Wp5J92j0/cOh2W13q0c8fU1
// SIG // tCJRryKhwV1LkH/AWU6rnXmpAtceSbE7TYf+wnirv+9S
// SIG // rpyvCNk55ZpRPmlfMBBOcWNsWOHwIDMbD3S+W8sS4duM
// SIG // xICUcrv2RZqewSUL+6McntimCXBx7MBHTI99w94Zzj7u
// SIG // BHKOF9P/8LIFMhlM07Acn/6leCBCcEGwJoxvAMg6ABFB
// SIG // ekGwp4qRBKCZePR3tPNgKuZsUAS3FGD/DVH0qIuE/iHa
// SIG // XF599Sl5T7BEdG9tcv8CAwEAAaOCAXgwggF0MC4GCCsG
// SIG // AQUFBwEBBCIwIDAeBggrBgEFBQcwAYYSaHR0cDovL3Mu
// SIG // c3ltY2QuY29tMBIGA1UdEwEB/wQIMAYBAf8CAQAwZgYD
// SIG // VR0gBF8wXTBbBgtghkgBhvhFAQcXAzBMMCMGCCsGAQUF
// SIG // BwIBFhdodHRwczovL2Quc3ltY2IuY29tL2NwczAlBggr
// SIG // BgEFBQcCAjAZGhdodHRwczovL2Quc3ltY2IuY29tL3Jw
// SIG // YTA2BgNVHR8ELzAtMCugKaAnhiVodHRwOi8vcy5zeW1j
// SIG // Yi5jb20vdW5pdmVyc2FsLXJvb3QuY3JsMBMGA1UdJQQM
// SIG // MAoGCCsGAQUFBwMDMA4GA1UdDwEB/wQEAwIBBjApBgNV
// SIG // HREEIjAgpB4wHDEaMBgGA1UEAxMRU3ltYW50ZWNQS0kt
// SIG // MS03MjQwHQYDVR0OBBYEFNTABiJJ6zlL3ZPiXKG4R3YJ
// SIG // cgNYMB8GA1UdIwQYMBaAFLZ3+mlIR59TEtXC6gcydgfR
// SIG // lwcZMA0GCSqGSIb3DQEBCwUAA4IBAQB/68qn6ot2Qus+
// SIG // jiBUMOO3udz6SD4Wxw9FlRDNJ4ajZvMC7XH4qsJVl5Fw
// SIG // g/lSflJpPMnx4JRGgBi7odSkVqbzHQCR1YbzSIfgy8Q0
// SIG // aCBetMv5Be2cr3BTJ7noPn5RoGlxi9xR7YA6JTKfRK9u
// SIG // QyjTIXW7l9iLi4z+qQRGBIX3FZxLEY3ELBf+1W5/muJW
// SIG // kvGWs60t+fTf2omZzrI4RMD3R3vKJbn6Kmgzm1By3qif
// SIG // 1M0sCzS9izB4QOCNjicbkG8avggVgV3rL+JR51EeyXgp
// SIG // 5x5lvzjvAUoBCSQOFsQUecFBNzTQPZFSlJ3haO8I8OJp
// SIG // nGdukAsak3HUJgLDwFojMYIOuzCCDrcCAQEwgZkwgYQx
// SIG // CzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRlYyBD
// SIG // b3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1
// SIG // c3QgTmV0d29yazE1MDMGA1UEAxMsU3ltYW50ZWMgQ2xh
// SIG // c3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENBIC0gRzIC
// SIG // EAkI2uucBh4uubp+Jqpih4owDQYJYIZIAWUDBAIBBQCg
// SIG // fDAQBgorBgEEAYI3AgEMMQIwADAZBgkqhkiG9w0BCQMx
// SIG // DAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4wDAYK
// SIG // KwYBBAGCNwIBFTAvBgkqhkiG9w0BCQQxIgQgzHiEYCaj
// SIG // ic9wb7o0yVNbcW2Ze3q03rP6uVF9dy+ACi4wDQYJKoZI
// SIG // hvcNAQEBBQAEggEABhD18+mJMXMtxYDSamhqU1ot0RgH
// SIG // h2DUagymhyH3NKJBjscQaLGE513pzCveqoKrJAdNCMNm
// SIG // LkThRPbS/eHHgUeoQ1TVSsy6dgijTfvnH6xeb2GDgBBD
// SIG // W/UUC0umKrXu96KkQWdTdKkb3e3LGK+bJRCcdH5qziEe
// SIG // mtrgjBzuyv0l09ZElzFLsfhrq37EC1SOze5+omhhd8Bd
// SIG // ynKpJ8Mbc8aoRxfsdldcWLrwba8jCRGhqIFwKiGO5hpt
// SIG // 5oauenp4bn2rV2aSwCl0+AOHcs6UtGPpa0R+PLoeSzgD
// SIG // 547P2F+3I5koTOnGK8aCc5GQGPyYGdR44qeAA+aeaiUP
// SIG // eCcBsqGCDHQwggxwBgorBgEEAYI3AwMBMYIMYDCCDFwG
// SIG // CSqGSIb3DQEHAqCCDE0wggxJAgEDMQ8wDQYJYIZIAWUD
// SIG // BAIBBQAwga8GCyqGSIb3DQEJEAEEoIGfBIGcMIGZAgEB
// SIG // BgkrBgEEAaAyAgMwMTANBglghkgBZQMEAgEFAAQggdQL
// SIG // cIEmvKL7iOBX4vPIfgp3gAjUdnBnofl/SyleBFACFEpR
// SIG // eLvhBGF+sRkveILhHr4YIanNGA8yMDIwMDMyMzE0MDM1
// SIG // MFqgL6QtMCsxKTAnBgNVBAMMIEdsb2JhbFNpZ24gVFNB
// SIG // IGZvciBBZHZhbmNlZCAtIEcyoIII0zCCBLYwggOeoAMC
// SIG // AQICDAynz10HBySsieeaOjANBgkqhkiG9w0BAQsFADBb
// SIG // MQswCQYDVQQGEwJCRTEZMBcGA1UEChMQR2xvYmFsU2ln
// SIG // biBudi1zYTExMC8GA1UEAxMoR2xvYmFsU2lnbiBUaW1l
// SIG // c3RhbXBpbmcgQ0EgLSBTSEEyNTYgLSBHMjAeFw0xODAy
// SIG // MTkwMDAwMDBaFw0yOTAzMTgxMDAwMDBaMCsxKTAnBgNV
// SIG // BAMMIEdsb2JhbFNpZ24gVFNBIGZvciBBZHZhbmNlZCAt
// SIG // IEcyMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKC
// SIG // AQEAt8eSiijY85HLUA1d6ylEwYJZpcpkzr2DtVHllMxu
// SIG // gJoXbNz/YuY2Q14Bwgxkjcp3nvZdd0W5Xsgk60E3EWY3
// SIG // rMjNdJvMs+9M4n8bznO+yZadNR5891T3bOygEtaumZ1j
// SIG // xHhfWakuIvXDJ9iyW0VjJ5D/jLE9qbTzDsDxIGUGiZ0D
// SIG // HKOwUkGFNOu8y85U9hL+swGJSqb6VMUf+9McwOO/l+M/
// SIG // 0Bv5QMcb1esmfEMwx3DyeBGqhU6lDg0ASjoRd6PKIwGA
// SIG // nsiTVl1GzIrY0qoKhIWyiVvVMs5BexhOVMqr0VJeEtMk
// SIG // nlbzDI/dvZKOedVBicOjoOWR/MdnnYczznEycwIDAQAB
// SIG // o4IBqDCCAaQwDgYDVR0PAQH/BAQDAgeAMEwGA1UdIARF
// SIG // MEMwQQYJKwYBBAGgMgEeMDQwMgYIKwYBBQUHAgEWJmh0
// SIG // dHBzOi8vd3d3Lmdsb2JhbHNpZ24uY29tL3JlcG9zaXRv
// SIG // cnkvMAkGA1UdEwQCMAAwFgYDVR0lAQH/BAwwCgYIKwYB
// SIG // BQUHAwgwRgYDVR0fBD8wPTA7oDmgN4Y1aHR0cDovL2Ny
// SIG // bC5nbG9iYWxzaWduLmNvbS9ncy9nc3RpbWVzdGFtcGlu
// SIG // Z3NoYTJnMi5jcmwwgZgGCCsGAQUFBwEBBIGLMIGIMEgG
// SIG // CCsGAQUFBzAChjxodHRwOi8vc2VjdXJlLmdsb2JhbHNp
// SIG // Z24uY29tL2NhY2VydC9nc3RpbWVzdGFtcGluZ3NoYTJn
// SIG // Mi5jcnQwPAYIKwYBBQUHMAGGMGh0dHA6Ly9vY3NwMi5n
// SIG // bG9iYWxzaWduLmNvbS9nc3RpbWVzdGFtcGluZ3NoYTJn
// SIG // MjAdBgNVHQ4EFgQULW5u0Y3lA4Du52Ppp9naCzxXIj0w
// SIG // HwYDVR0jBBgwFoAUkiGnSpVdZLCbtB7mADdH5p1BK0ww
// SIG // DQYJKoZIhvcNAQELBQADggEBAI39HR+PiNNl+LVcRumn
// SIG // 07Y/SstDBcIHDcNeA4QjN6h6jJcj/yechH1h61xLVz6b
// SIG // 9ETbgFj3tmXejxIKX6eHdLfaFECHUeyfSkdV8BfoGD5x
// SIG // IDHmKCKrTvaunGvC50T7aA0gf1M/lBuhhoJOMhYQWj+J
// SIG // WMHQtNu2kPuNMumhS0ZQN7bDOukpJBKSWk4rubYKejaM
// SIG // l8DviXwz3jHhoZfk50WtYVL9WonTVH6KTVuJew6Wd9Hy
// SIG // PDgb2vmlYSBlArzFrdcMYhAoLN2246hhAKwIJqONhdBk
// SIG // yTaQHopSyYeNNaVdSJH8k6alZfHs+TrcpSyeBG1iM/7e
// SIG // +p/Fzq+V81Go8s4wggQVMIIC/aADAgECAgsEAAAAAAEx
// SIG // icZQBDANBgkqhkiG9w0BAQsFADBMMSAwHgYDVQQLExdH
// SIG // bG9iYWxTaWduIFJvb3QgQ0EgLSBSMzETMBEGA1UEChMK
// SIG // R2xvYmFsU2lnbjETMBEGA1UEAxMKR2xvYmFsU2lnbjAe
// SIG // Fw0xMTA4MDIxMDAwMDBaFw0yOTAzMjkxMDAwMDBaMFsx
// SIG // CzAJBgNVBAYTAkJFMRkwFwYDVQQKExBHbG9iYWxTaWdu
// SIG // IG52LXNhMTEwLwYDVQQDEyhHbG9iYWxTaWduIFRpbWVz
// SIG // dGFtcGluZyBDQSAtIFNIQTI1NiAtIEcyMIIBIjANBgkq
// SIG // hkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqpuOw6sRUSUB
// SIG // tpaU4k/YwQj2RiPZRcWVl1urGr/SbFfJMwYfoA/GPH5T
// SIG // SHq/nYeer+7DjEfhQuzj46FKbAwXxKbBuc1b8R5EiY7+
// SIG // C94hWBPuTcjFZwscsrPxNHaRossHbTfFoEcmAhWkkJGp
// SIG // eZ7X61edK3wi2BTX8QceeCI2a3d5r6/5f45O4bUIMf3q
// SIG // 7UtxYowj8QM5j0R5tnYDV56tLwhG3NKMvPSOdM7IaGlR
// SIG // dhGLD10kWxlUPSbMQI2CJxtZIH1Z9pOAjvgqOP1roEBl
// SIG // H1d2zFuOBE8sqNuEUBNPxtyLufjdaUyI65x7MCb8eli7
// SIG // WbwUcpKBV7d2ydiACoBuCQIDAQABo4HoMIHlMA4GA1Ud
// SIG // DwEB/wQEAwIBBjASBgNVHRMBAf8ECDAGAQH/AgEAMB0G
// SIG // A1UdDgQWBBSSIadKlV1ksJu0HuYAN0fmnUErTDBHBgNV
// SIG // HSAEQDA+MDwGBFUdIAAwNDAyBggrBgEFBQcCARYmaHR0
// SIG // cHM6Ly93d3cuZ2xvYmFsc2lnbi5jb20vcmVwb3NpdG9y
// SIG // eS8wNgYDVR0fBC8wLTAroCmgJ4YlaHR0cDovL2NybC5n
// SIG // bG9iYWxzaWduLm5ldC9yb290LXIzLmNybDAfBgNVHSME
// SIG // GDAWgBSP8Et/qC5FJK5NUPpjmove4t0bvDANBgkqhkiG
// SIG // 9w0BAQsFAAOCAQEABFaCSnzQzsm/NmbRvjWek2yX6AbO
// SIG // MRhZ+WxBX4AuwEIluBjH/NSxN8RooM8oagN0S2OXhXdh
// SIG // O9cv4/W9M6KSfREfnops7yyw9GKNNnPRFjbxvF7stICY
// SIG // ePzSdnno4SGU4B/EouGqZ9uznHPlQCLPOc7b5neVp7uy
// SIG // y/YZhp2fyNSYBbJxb051rvE9ZGo7Xk5GpipdCJLxo/Md
// SIG // dL9iDSOMXCo4ldLA1c3PiNofKLW6gWlkKrWmotVzr9xG
// SIG // 2wSukdduxZi61EfEVnSAR3hYjL7vK/3sbL/RlPe/UOB7
// SIG // 4JD9IBh4GCJdCC6MHKCX8x2ZfaOdkdMGRE4EbnocIOM2
// SIG // 8LZQuTGCAqgwggKkAgEBMGswWzELMAkGA1UEBhMCQkUx
// SIG // GTAXBgNVBAoTEEdsb2JhbFNpZ24gbnYtc2ExMTAvBgNV
// SIG // BAMTKEdsb2JhbFNpZ24gVGltZXN0YW1waW5nIENBIC0g
// SIG // U0hBMjU2IC0gRzICDAynz10HBySsieeaOjANBglghkgB
// SIG // ZQMEAgEFAKCCAQ4wGgYJKoZIhvcNAQkDMQ0GCyqGSIb3
// SIG // DQEJEAEEMBwGCSqGSIb3DQEJBTEPFw0yMDAzMjMxNDAz
// SIG // NTBaMC8GCSqGSIb3DQEJBDEiBCB7eH9nccN6B0IVrb2W
// SIG // gs/gNheWw2OFdrTRUSdFzjmMKTCBoAYLKoZIhvcNAQkQ
// SIG // AgwxgZAwgY0wgYowgYcEFJsSBXrnKq/21jdytJ9qI28m
// SIG // Sc2pMG8wX6RdMFsxCzAJBgNVBAYTAkJFMRkwFwYDVQQK
// SIG // ExBHbG9iYWxTaWduIG52LXNhMTEwLwYDVQQDEyhHbG9i
// SIG // YWxTaWduIFRpbWVzdGFtcGluZyBDQSAtIFNIQTI1NiAt
// SIG // IEcyAgwMp89dBwckrInnmjowDQYJKoZIhvcNAQEBBQAE
// SIG // ggEAI+TH1VbtLlSirshjJn5itGPTpZvU3XJSfCS8j7hk
// SIG // ln1tDwI7jIbQCUdrPGKP3Qm6VB00+rbR2MxIFXIC4t9E
// SIG // ev3SVcu6JpJhICMvuoF44IciJE3IayqD1cb9D9nea51O
// SIG // ZcPRsd4YvfQpStqOQRao0OLb5PjlK9OcXdIuP4mJibN4
// SIG // f57I4Faqt4RKDmvKeGKvItooaGtNOn3diBRKIfDffqzy
// SIG // hLlfG2L0N2G02hkvFUDFn/+zE+Tj3o5xm+qcf5pGLG5w
// SIG // 16ZIOFoojMo8nF0zp0AlyajjftwrduVqHui2Xh1235cW
// SIG // OsGTlJyja5EhiO7uFXXJVp5OXy2aLQ3f45Gwfg==
// SIG // End signature block
