var topic = "<!DOCTYPE html>\r\n\n<!-- saved from url=(0024)http://docs.autodesk.com -->\r\n<html>\n   <head>\n      <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n      <meta name=\"product\" content=\"VAULT\">\n      <meta name=\"release\" content=\"2021\">\n      <meta name=\"book\" content=\"GeneralUser\">\n      <meta name=\"created\" content=\"2020-03-20\">\n      <meta name=\"topicid\" content=\"GUID-5BE692C2-9CC9-453D-8FFF-E921EAFEF79E\">\n      <meta name=\"description\" content=\"Export items in a vault to an external file.\">\n      <meta name=\"contextid\" content=\"ID_EXPORTERPGENERAL_VE\">\n      <meta name=\"topic-type\" content=\"concept\">\n      <meta name=\"audience\" content=\"administrator\">\n      <meta name=\"experiencelevel\" content=\"general\">\n      <title>Export Items</title><script language=\"javascript\">var index = \'index.html\';</script></head>\n   <body height=\"100%\">\n      <div class=\"revit-legend\">\n         <ul></ul>\n      </div>\n      <div class=\"body_content\" id=\"body-content\" dir=\"ltr\"><a name=\"GUID-5BE692C2-9CC9-453D-8FFF-E921EAFEF79E\"></a><div class=\"head\">\n            <h1>Export Items</h1>\n         </div>\n         <p class=\"blurb\">Export items in a vault to an external file. \n            <!--CPM-ContextId = \'ID_EXPORTERPGENERAL_VE\'--><a name=\"GUID-038EFC84-B291-46DD-981D-6444CB50FBDC\"></a> \n         </p>\n         <div><a name=\"GUID-1648034E-47D5-40C5-844E-7B01E7C5E01B\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span>Items are available in Vault Professional. \n               <p><a name=\"GUID-354C75F4-9671-445F-A51C-673AEE8A1F30\"></a>You must be an Administrator or ERP Manager to export items. \n               </p> \n            </div>\n         </div>\n         <p><a name=\"GUID-E1193FFC-44B4-4FB1-8377-BC47D2CCB28A\"></a>Items can be exported to: \n         </p><a name=\"UL_F64BB83213894D66A7F4DF6FB2C102C5\"></a><ul>\n            <li>Comma Separated Values (.<span class=\"filePath\">csv</span>) \n            </li>\n            <li>Tab Delimited Lines (.<span class=\"filePath\">tdl</span>) \n            </li>\n            <li>Autodesk Design Web Format (.<span class=\"filePath\">dwf</span>) \n            </li>\n            <li>Extensible Markup Language (.<span class=\"filePath\">xml</span>) \n            </li>\n         </ul><a name=\"UL_82FADD93BC434EFB834ED1960995915E\"></a><p class=\"list-intro\"><a name=\"GUID-90E7FDEC-B392-425A-8D22-BB08AAC0453E\"></a>Rules for Exporting Items\n         </p>\n         <ul>\n            <li>Item properties, bill of materials (BOM), and the Autodesk Inventor global BOM data\n               are supported. \n            </li>\n            <li>When exporting a BOM, the latest BOM is exported. </li>\n            <li>When exporting to .csv or .<span class=\"filePath\">tdl</span> files, you can define which Vault Professional attributes to export and then save\n               this configuration as a mapping scheme. You can then apply the mapping scheme each\n               time you export data. \n            </li>\n            <li>Files are exported encoded in Unicode (UTF-8). When importing this data into another\n               application, it may be necessary to specify the file is encoded in Unicode (UTF-8)\n               so that all characters are accurately imported. For more information on importing\n               Unicode (UTF-8) into another application, see the documentation for that specific\n               application. \n            </li>\n            <li>Exporting items in the .<span class=\"filePath\">dwf</span> format exports the item\'s attached files, associated files, and the attached files\n               to the associated files. \n            </li>\n         </ul>\n         <div><a name=\"GUID-A421CE58-B520-47D7-8B68-F645E6FE73AD\"></a><div class=\"note-tip\"><span class=\"label label-target-language\">TIP:</span>When exporting items, a master DWF package is created with sub-DWFs of the files.\n               You can disable the creation of sub-DWFs by setting <em class=\"mild\">export includeAttachments</em> to False in the <span class=\"filePath\">web.config</span> file. \n            </div>\n         </div>\n         <div class=\"section\"><a name=\"SECTION_D627A638267540B99E250D7A81AD21EE\"></a> \n            <h2><a name=\"GUID-3288A029-3A1A-465B-8B3E-88E4A75C860F\"></a>Export a .csv file or a .tdl file\n            </h2> <a name=\"GUID-9F07E697-5F53-494F-9132-576303BD673E\"></a><ol type=\"1\" start=\"1\">\n               <li>In the Item Master, select the items to export. If you select an item that has children,\n                  the item and all children are selected. \n                  <p><a name=\"GUID-0EA8403A-5E47-411D-B815-D6DBEBDC4D2D\"></a>Go to the BOM tab in an item record and select the BOM rows that you want to export.\n                     \n                  </p> \n               </li>\n               <li>From the File menu, select Export. \n                  <p><a name=\"GUID-14F564BB-BF9D-41D9-97AE-F0B51C46C24A\"></a>The selected item and any children are listed with their respective revision IDs in\n                     the Export Wizard. \n                  </p> \n               </li>\n               <li>Select the Released and Obsolete items only check box to only show items in this state.\n                  \n               </li>\n               <li>Items that are checked are exported. If you do not want to export an item that is\n                  checked, turn off the check box next to that item. \n               </li>\n               <li>Click Next. </li>\n               <li>In the Specify File screen, select Other as the target. </li>\n               <li>Click Next. </li>\n               <li>In the Specify File screen, select either CSV (Comma Separated Values) or TDL (Tab\n                  Delimited List). \n               </li>\n               <li>Choose how the BOM levels are indicated in the exported file: <a name=\"UL_63FFA771F469473CAD4CDF3150B7D229\"></a><ul>\n                     <li>Choose Level Numbers to organize items using outline numbering: <a name=\"TABLE_608C436A66EF44F6BD13055FC48470A0\"></a><div class=\"table-not-ruled\">\n                           <table cellpadding=\"0\" cellspacing=\"0\" class=\"not-ruled\">\n                              <colgroup>\n                                 <col>\n                                 <col>\n                                 <col>\n                              </colgroup>\n                              <tr class=\"not-ruled-odd-row\">\n                                 <td class=\"table-body\"> <a name=\"GUID-82BCD873-47E4-4865-A724-65AE97EDB0AE\"></a><p class=\"table-body\"> <em class=\"strong\">Level</em> \n                                    </p> \n                                 </td>\n                                 <td class=\"table-body\"> <a name=\"GUID-07849126-9C4A-4986-A75E-663E46AB1795\"></a><p class=\"table-body\"> <em class=\"strong\">Item Number</em> \n                                    </p> \n                                 </td>\n                                 <td class=\"table-body\"> <a name=\"GUID-3E7C54A5-2D3A-47CF-8945-27CD95F1BA42\"></a><p class=\"table-body\"> <em class=\"strong\">Title</em> \n                                    </p> \n                                 </td>\n                              </tr>\n                              <tr class=\"not-ruled-even-row\">\n                                 <td class=\"table-body\"> <a name=\"GUID-33E680F3-99EF-45D4-889D-C6D160E67195\"></a><p class=\"table-body\">1 </p> \n                                 </td>\n                                 <td class=\"table-body\"> <a name=\"GUID-6555B5E6-630D-4248-A85B-5392664B572F\"></a><p class=\"table-body\">000011 </p> \n                                 </td>\n                                 <td class=\"table-body\"> <a name=\"GUID-6BD40DA5-54CF-444C-8356-2C4BA5EEBED6\"></a><p class=\"table-body\">Main Assembly </p> \n                                 </td>\n                              </tr>\n                              <tr class=\"not-ruled-odd-row\">\n                                 <td class=\"table-body\"> <a name=\"GUID-C19F5EF2-4D56-4C02-9239-3D88FEA7BBDC\"></a><p class=\"table-body\">1.1 </p> \n                                 </td>\n                                 <td class=\"table-body\"> <a name=\"GUID-60590B8E-F6ED-4618-9704-6EBBEB0B51D1\"></a><p class=\"table-body\">000012 </p> \n                                 </td>\n                                 <td class=\"table-body\"> <a name=\"GUID-CAE068AA-9A52-4885-84D4-FE7B6427DC49\"></a><p class=\"table-body\">Part </p> \n                                 </td>\n                              </tr>\n                              <tr class=\"not-ruled-even-row\">\n                                 <td class=\"table-body\"> <a name=\"GUID-62BB0B47-7124-4D08-ACE6-FA759644A2A6\"></a><p class=\"table-body\">1.2 </p> \n                                 </td>\n                                 <td class=\"table-body\"> <a name=\"GUID-8B76D37D-EDB2-4EDA-A64C-8A1422AFB247\"></a><p class=\"table-body\">000013 </p> \n                                 </td>\n                                 <td class=\"table-body\"> <a name=\"GUID-F7904813-D61B-4A9E-9790-C22CDBFA4C1C\"></a><p class=\"table-body\">Subassembly1 </p> \n                                 </td>\n                              </tr>\n                              <tr class=\"not-ruled-odd-row\">\n                                 <td class=\"table-body\"> <a name=\"GUID-7B200AA9-FE50-4D51-8D54-066823FA0EFE\"></a><p class=\"table-body\">1.2.1 </p> \n                                 </td>\n                                 <td class=\"table-body\"> <a name=\"GUID-7833AFBD-2964-416B-9C62-559E0117BDDE\"></a><p class=\"table-body\">000014 </p> \n                                 </td>\n                                 <td class=\"table-body\"> <a name=\"GUID-48902947-3F0C-4A16-BEC7-2F14E3DCD22E\"></a><p class=\"table-body\">Subassembly2 </p> \n                                 </td>\n                              </tr>\n                              <tr class=\"not-ruled-even-row\">\n                                 <td class=\"table-body\"> <a name=\"GUID-81CC27D5-6F12-4693-AA3A-A22494B9A160\"></a><p class=\"table-body\">1.2.1.1 </p> \n                                 </td>\n                                 <td class=\"table-body\"> <a name=\"GUID-DC5D7481-18CE-4229-9002-821F4462FE83\"></a><p class=\"table-body\">000015 </p> \n                                 </td>\n                                 <td class=\"table-body\"> <a name=\"GUID-E325DC80-5D33-49AC-BC62-550018B751C9\"></a><p class=\"table-body\">Part1 </p> \n                                 </td>\n                              </tr>\n                           </table>\n                        </div> \n                     </li>\n                     <li>Choose Parent Item to organize items by parents: <a name=\"TABLE_FFBC7C4D1859460D9A2D3AD57ABD70FB\"></a><div class=\"table-not-ruled\">\n                           <table cellpadding=\"0\" cellspacing=\"0\" class=\"not-ruled\">\n                              <colgroup>\n                                 <col>\n                                 <col>\n                                 <col>\n                              </colgroup>\n                              <tr class=\"not-ruled-odd-row\">\n                                 <td class=\"table-body\"> <a name=\"GUID-6B3A03ED-EFDE-47B2-A4A0-DAB3FDB26052\"></a><p class=\"table-body\"> <em class=\"strong\">Parent</em> \n                                    </p> \n                                 </td>\n                                 <td class=\"table-body\"> <a name=\"GUID-4F389ADA-D1FB-4493-BAD8-9F1EFFF2C099\"></a><p class=\"table-body\"> <em class=\"strong\">Item Number</em> \n                                    </p> \n                                 </td>\n                                 <td class=\"table-body\"> <a name=\"GUID-F9CB70EB-AB53-46BD-84BD-77F0B75EFEAB\"></a><p class=\"table-body\"> <em class=\"strong\">Title</em> \n                                    </p> \n                                 </td>\n                              </tr>\n                              <tr class=\"not-ruled-even-row\">\n                                 <td class=\"table-body\"> <a name=\"GUID-443F4F20-C620-4CB1-92BE-FEB3DB2A4E71\"></a><p class=\"table-body\">&lt;top&gt; </p> \n                                 </td>\n                                 <td class=\"table-body\"> <a name=\"GUID-AE5585D3-D9BD-4D05-A210-016610F3F850\"></a><p class=\"table-body\">000011 </p> \n                                 </td>\n                                 <td class=\"table-body\"> <a name=\"GUID-4750D10B-00FD-46BB-B574-1C3837315BFC\"></a><p class=\"table-body\">Main Assembly </p> \n                                 </td>\n                              </tr>\n                              <tr class=\"not-ruled-odd-row\">\n                                 <td class=\"table-body\"> <a name=\"GUID-09A9B315-0039-4F11-9026-DCCC74E6FE05\"></a><p class=\"table-body\">000011 </p> \n                                 </td>\n                                 <td class=\"table-body\"> <a name=\"GUID-A95C3C46-74F3-41C1-AF47-D8FC7B63FA10\"></a><p class=\"table-body\">000012 </p> \n                                 </td>\n                                 <td class=\"table-body\"> <a name=\"GUID-B15AA5D7-4048-45CE-AE52-0B17C7F652E6\"></a><p class=\"table-body\">Part </p> \n                                 </td>\n                              </tr>\n                              <tr class=\"not-ruled-even-row\">\n                                 <td class=\"table-body\"> <a name=\"GUID-851E6761-AF26-4358-934F-AE2AFAFB9A43\"></a><p class=\"table-body\">000011 </p> \n                                 </td>\n                                 <td class=\"table-body\"> <a name=\"GUID-DBBB937D-E32E-46B2-B556-41727FAA413E\"></a><p class=\"table-body\">000013 </p> \n                                 </td>\n                                 <td class=\"table-body\"> <a name=\"GUID-E99FED6F-4539-4A24-90D1-567803F82A3B\"></a><p class=\"table-body\">Subassembly1 </p> \n                                 </td>\n                              </tr>\n                              <tr class=\"not-ruled-odd-row\">\n                                 <td class=\"table-body\"> <a name=\"GUID-BF1A450A-C354-4E50-85A7-A3D7BD54B6B0\"></a><p class=\"table-body\">000013 </p> \n                                 </td>\n                                 <td class=\"table-body\"> <a name=\"GUID-E84CB5A5-763E-4DDE-8AE3-34B3401AF43E\"></a><p class=\"table-body\">000014 </p> \n                                 </td>\n                                 <td class=\"table-body\"> <a name=\"GUID-981E82D9-14EA-4BB3-8C83-EFE34C2CACCA\"></a><p class=\"table-body\">Subassembly2 </p> \n                                 </td>\n                              </tr>\n                              <tr class=\"not-ruled-even-row\">\n                                 <td class=\"table-body\"> <a name=\"GUID-AA81793B-6FCB-46CD-A6B7-B52FDD51896F\"></a><p class=\"table-body\">000014 </p> \n                                 </td>\n                                 <td class=\"table-body\"> <a name=\"GUID-32E782EE-87A7-4399-A544-EFC940E2174F\"></a><p class=\"table-body\">000015 </p> \n                                 </td>\n                                 <td class=\"table-body\"> <a name=\"GUID-05C3B7B2-B923-4F58-A086-BEB77F4EB315\"></a><p class=\"table-body\">Part1 </p> \n                                 </td>\n                              </tr>\n                           </table>\n                        </div> \n                     </li>\n                  </ul> \n               </li>\n               <li>Enter a path and file name for the exported file or click Browse and specify the location\n                  and file name. \n               </li>\n               <li>Click Next. </li>\n               <li>In the Specify Attributes screen, drag attributes from the Vault Professional Attributes\n                  list and drop them on the Export File attributes list. Click Previous and Next to\n                  scroll through the values for the Vault Professional attributes. <a name=\"UL_0F3C9485E289429BBF598E5B5C48066A\"></a><ul>\n                     <li>To remove an export file attribute from the list, drag it back to the Vault Professional\n                        Attributes list. \n                     </li>\n                     <li>To rename an attribute, double-click the attribute field in the Export file list and\n                        enter a new name. \n                     </li>\n                  </ul> \n                  <div><a name=\"GUID-93F9F835-83E4-4107-939E-9F6731B78922\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span>The Level or Parent attributes, depending on which BOM indicator you selected, and\n                        the Item Number attribute must be mapped. \n                     </div>\n                  </div> <a name=\"UL_64EB70C4839D4AF1AE0EBFF5DD0C36BB\"></a><ul>\n                     <li>Once you specify the mapping, it can be saved and used each time you export files.\n                        Click Save Map. In the Save Mapping Attributes dialog box, browse to a location and\n                        enter a file name. Maps are saved as .xml files. Click Save. \n                     </li>\n                     <li>To load a mapping file, click Load Map. In the Load Attributes Mapping dialog box,\n                        browse to the location where the mapping file (.<span class=\"filePath\">xml</span>) is saved and then click Open. The Export file attributes list is changed to match\n                        the mapping specified in this file. \n                     </li>\n                     <li>To reset the mapped fields, click Clear Mapping. </li>\n                  </ul> \n               </li>\n               <li>Click Export. </li>\n               <li>The View Results displays the result, including those items that were successfully\n                  exported and those that were not. <a name=\"UL_0EE8FC9562224A3081708A93FD6E66DC\"></a><ul>\n                     <li>Click Print to print the results. </li>\n                     <li>Click Send to send the summary information by e-mail. </li>\n                  </ul> \n               </li>\n               <li>Click Finish. </li>\n            </ol> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_D1E50512CF8345B784850B0B7565C322\"></a> \n            <h2><a name=\"GUID-E966CCAA-2414-408E-BF1E-06200811B88B\"></a>Export a .dwf or .xml file\n            </h2> <a name=\"GUID-E495C845-607E-42EE-ABC4-B2AD550B69B6\"></a><ol type=\"1\" start=\"1\">\n               <li>In the Item Master, select the items to export. If you select an item that has children,\n                  the item and all children are selected. \n                  <p><a name=\"GUID-182D2DE2-37AD-4BB2-A0AE-23DB9E4A5F88\"></a>OR \n                  </p> \n                  <p><a name=\"GUID-A52677F6-27C7-4A7B-A491-E79F87FB9878\"></a>Go to the BOM tab in an item record and select the BOM rows that you want to export.\n                     \n                  </p> \n               </li>\n               <li>From the File menu, select Export. \n                  <p><a name=\"GUID-76AB3074-97F3-437C-9B7A-EA0DDB3FEA40\"></a>The selected item and any children are listed with their respective revision IDs in\n                     the Export Wizard. \n                  </p> \n               </li>\n               <li>Select the Released and Obsolete items only check box to only show items in this state.\n                  \n               </li>\n               <li>Items that are checked are exported. If you do not want to export an item that is\n                  checked, turn off the check box next to that item. \n               </li>\n               <li>Click Next. </li>\n               <li>In the Specify File screen, select either Design Web Format (DWF) or XML. </li>\n               <li>Enter a path and file name for the exported file or click Browse and specify the location\n                  and file name. \n               </li>\n               <li>If you have defined item attributes in Vault Professional, you can map the attributes\n                  before exporting. In the Specify Attributes screen, drag attributes from the Vault\n                  Professional Attributes list and drop them on the Export File attributes list. Click\n                  Previous and Next to scroll through the values for the Vault Professional attributes.\n                  <a name=\"UL_C0C8E354A82C49CFBD9AD244D60FFEBC\"></a><ul>\n                     <li>To remove an export file attribute from the list, drag it back to the Vault Professional\n                        Attributes list. \n                     </li>\n                     <li>To rename an attribute, double-click the attribute field in the Export file list and\n                        enter a new name. \n                     </li>\n                  </ul> \n                  <div><a name=\"GUID-C6744F2F-C229-4211-BB5B-8A4DA5C51CE8\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span>The Level or Parent attributes, depending on which BOM indicator you selected, and\n                        the Item Number attribute must be mapped. \n                     </div>\n                  </div> <a name=\"UL_E8DE995910A543A5A9A4F29D4913BAEB\"></a><ul>\n                     <li>Once you specify the mapping, it can be saved and used each time you export files.\n                        Click Save Map. In the Save Mapping Attributes dialog box, browse to a location and\n                        enter a file name. Maps are saved as .<span class=\"filePath\">xml</span> files. Click Save. \n                     </li>\n                     <li>To load a mapping file, click Load Map. In the Load Attributes Mapping dialog box,\n                        browse to the location where the mapping file (.<span class=\"filePath\">xml</span>) is saved and then click Open. The Export file attributes list is changed to match\n                        the mapping specified in this file. \n                     </li>\n                     <li>To reset the mapped fields, click Clear Mapping. </li>\n                  </ul> \n               </li>\n               <li>Click Export. </li>\n               <li>The View Results displays the result, including those items that were successfully\n                  exported and those that were not. <a name=\"UL_AE158ECE04A6451BB77AD13734EC633E\"></a><ul>\n                     <li>Click Print to print the results. </li>\n                     <li>Click Send to send the summary information by e-mail. </li>\n                  </ul> \n               </li>\n               <li>Click Finish. </li>\n            </ol> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_D01C8CDD895B42CA93A27526A345B825\"></a> \n            <h2><a name=\"GUID-70A4AE31-6B93-40F5-8A43-6406015EB2AD\"></a>Disable DWF Creation when Exporting Items\n            </h2> \n            <p><a name=\"GUID-59ED6312-3E36-4DEC-8922-A59725D15770\"></a>When exporting items, a master DWF package is created with sub-DWFs of the files.\n               You can disable the creation of sub-DWFs by setting to False in the <span class=\"filePath\">web.config</span> file.export includeAttachments \n            </p> <a name=\"GUID-B7F3CF8A-8105-41B7-90B0-3F6FD4818451\"></a><ol type=\"1\" start=\"1\">\n               <li>On the computer hosting the Autodesk vault server, locate the <span class=\"filePath\">Web.config</span> file. By default, this file is installed in <span class=\"filePath\">Program Files\\Autodesk\\ADMS Professional [version]\\Server\\Web\\Services</span>. \n               </li>\n               <li>Using a text editor such as Notepad, open the <span class=\"filePath\">Web.config</span> file. \n               </li>\n               <li>Search for the string: \n                  <p><a name=\"GUID-3CE82697-EC58-4161-813B-FDF8B0B54157\"></a>export includeAttachments \n                  </p> \n               </li>\n               <li>By default, the value of the export includeAttachments setting is True. Change the\n                  value to False. \n               </li>\n               <li>Save the <span class=\"filePath\">Web.config</span> file and exit the editor. \n               </li>\n            </ol> \n         </div>\n         <div class=\"footer-block\"><a href=\"..\" class=\"comments-anchor\" target=\"_blank\"><span class=\"comments-link\">Please send us your comment about this page</span></a></div><br><p class=\"footer-license-block\"><a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\"><img alt=\"Creative Commons License\" style=\"border-width: 0;\" src=\"../images/ccLink.png\"></a>&nbsp;<em>Except where otherwise noted, this work is licensed under a <a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\">Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License</a>. Please see the <a href=\"http://autodesk.com/creativecommons\" target=\"_blank\">Autodesk Creative Commons FAQ</a> for more information.</em></p><br></div>\n   </body>\n</html>";
// SIG // Begin signature block
// SIG // MIIbRQYJKoZIhvcNAQcCoIIbNjCCGzICAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // 8qc/xYFKtG2PRRbAApcN1vp2j6EwmjQvYghOK7tKhAmg
// SIG // ggoaMIIEyzCCA7OgAwIBAgIQCQja65wGHi65un4mqmKH
// SIG // ijANBgkqhkiG9w0BAQsFADCBhDELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTUw
// SIG // MwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
// SIG // b2RlIFNpZ25pbmcgQ0EgLSBHMjAeFw0xOTA1MTQwMDAw
// SIG // MDBaFw0yMDA1MTMyMzU5NTlaMHwxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIDApDYWxpZm9ybmlhMRMwEQYDVQQHDApT
// SIG // YW4gUmFmYWVsMRcwFQYDVQQKDA5BdXRvZGVzaywgSW5j
// SIG // LjERMA8GA1UECwwIU2VjdXJpdHkxFzAVBgNVBAMMDkF1
// SIG // dG9kZXNrLCBJbmMuMIIBIjANBgkqhkiG9w0BAQEFAAOC
// SIG // AQ8AMIIBCgKCAQEAkVKRoPYsoxPdlabspcuG8HYDfcWQ
// SIG // 9qyPOT2punwpVdjt2slktcpSTlydrGy8ijcbl5/k8AOJ
// SIG // afKMQvow0fNjIoNB5nsb8j2xFJPbBhHl8GT4P6DZ1OWK
// SIG // ioiUXgGHKjctUws49J4elntqvBYhKCbuPqG772QCoYFU
// SIG // P7qcFbh3PbyNB6cnKMn2vNGRqiEtV2aGg+/MiL3QPsvT
// SIG // kTWhVuTLIvwZ4kK5C5ACiQzlGOlE+C7gWuFoxtvy6gUa
// SIG // A8JAq/xLjYKwFevQwGncg3s1cuiGhx0P7Rvn6oCd2cem
// SIG // FmbK3I3rMRt+jc9wzAj3oHxvCo4f5Lfva+OpC1dETUVV
// SIG // sk0VGwIDAQABo4IBPjCCATowCQYDVR0TBAIwADAOBgNV
// SIG // HQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMw
// SIG // YQYDVR0gBFowWDBWBgZngQwBBAEwTDAjBggrBgEFBQcC
// SIG // ARYXaHR0cHM6Ly9kLnN5bWNiLmNvbS9jcHMwJQYIKwYB
// SIG // BQUHAgIwGQwXaHR0cHM6Ly9kLnN5bWNiLmNvbS9ycGEw
// SIG // HwYDVR0jBBgwFoAU1MAGIknrOUvdk+JcobhHdglyA1gw
// SIG // KwYDVR0fBCQwIjAgoB6gHIYaaHR0cDovL3JiLnN5bWNi
// SIG // LmNvbS9yYi5jcmwwVwYIKwYBBQUHAQEESzBJMB8GCCsG
// SIG // AQUFBzABhhNodHRwOi8vcmIuc3ltY2QuY29tMCYGCCsG
// SIG // AQUFBzAChhpodHRwOi8vcmIuc3ltY2IuY29tL3JiLmNy
// SIG // dDANBgkqhkiG9w0BAQsFAAOCAQEA0Q2+iVSEfT4xGq3A
// SIG // OADVb0rT5Z8E+PPb1x6hKknSzuaZKk/acDz9mdnFajaU
// SIG // WgIKiFJlsqJnuAM1w4lqKaEWsz3DoxvGIEwexj71Ud6a
// SIG // KlBJNcR9DdkXUZwMhbw9d78rjJAIX6tOwfSludZfdq8b
// SIG // YEkuIzQi9uYW9vHVPSCzhnUBKjwc9qTo9yBc7Fcn4FAT
// SIG // 90DzWM2hS9oc3p0pprYI2I/O4th90BEmwWkVqVgfaR0z
// SIG // VyIEmBbqB/IWLfjUBZJ/8sbkwWuWlYVRrfPxsj1e9qvb
// SIG // wE3Y28jWyGbqoUG39GhXk3uT8R8i3+T6M0c4rMfdifBC
// SIG // pceCaFTJzSye7LoeVzCCBUcwggQvoAMCAQICEHwbNTVK
// SIG // 59t050FfEWnKa6gwDQYJKoZIhvcNAQELBQAwgb0xCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjEfMB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29y
// SIG // azE6MDgGA1UECxMxKGMpIDIwMDggVmVyaVNpZ24sIElu
// SIG // Yy4gLSBGb3IgYXV0aG9yaXplZCB1c2Ugb25seTE4MDYG
// SIG // A1UEAxMvVmVyaVNpZ24gVW5pdmVyc2FsIFJvb3QgQ2Vy
// SIG // dGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMTQwNzIyMDAw
// SIG // MDAwWhcNMjQwNzIxMjM1OTU5WjCBhDELMAkGA1UEBhMC
// SIG // VVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9u
// SIG // MR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3Jr
// SIG // MTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1
// SIG // NiBDb2RlIFNpZ25pbmcgQ0EgLSBHMjCCASIwDQYJKoZI
// SIG // hvcNAQEBBQADggEPADCCAQoCggEBANeVQ9Tc32euOftS
// SIG // pLYmMQRw6beOWyq6N2k1lY+7wDDnhthzu9/r0XY/ilaO
// SIG // 6y1L8FcYTrGNpTPTC3Uj1Wp5J92j0/cOh2W13q0c8fU1
// SIG // tCJRryKhwV1LkH/AWU6rnXmpAtceSbE7TYf+wnirv+9S
// SIG // rpyvCNk55ZpRPmlfMBBOcWNsWOHwIDMbD3S+W8sS4duM
// SIG // xICUcrv2RZqewSUL+6McntimCXBx7MBHTI99w94Zzj7u
// SIG // BHKOF9P/8LIFMhlM07Acn/6leCBCcEGwJoxvAMg6ABFB
// SIG // ekGwp4qRBKCZePR3tPNgKuZsUAS3FGD/DVH0qIuE/iHa
// SIG // XF599Sl5T7BEdG9tcv8CAwEAAaOCAXgwggF0MC4GCCsG
// SIG // AQUFBwEBBCIwIDAeBggrBgEFBQcwAYYSaHR0cDovL3Mu
// SIG // c3ltY2QuY29tMBIGA1UdEwEB/wQIMAYBAf8CAQAwZgYD
// SIG // VR0gBF8wXTBbBgtghkgBhvhFAQcXAzBMMCMGCCsGAQUF
// SIG // BwIBFhdodHRwczovL2Quc3ltY2IuY29tL2NwczAlBggr
// SIG // BgEFBQcCAjAZGhdodHRwczovL2Quc3ltY2IuY29tL3Jw
// SIG // YTA2BgNVHR8ELzAtMCugKaAnhiVodHRwOi8vcy5zeW1j
// SIG // Yi5jb20vdW5pdmVyc2FsLXJvb3QuY3JsMBMGA1UdJQQM
// SIG // MAoGCCsGAQUFBwMDMA4GA1UdDwEB/wQEAwIBBjApBgNV
// SIG // HREEIjAgpB4wHDEaMBgGA1UEAxMRU3ltYW50ZWNQS0kt
// SIG // MS03MjQwHQYDVR0OBBYEFNTABiJJ6zlL3ZPiXKG4R3YJ
// SIG // cgNYMB8GA1UdIwQYMBaAFLZ3+mlIR59TEtXC6gcydgfR
// SIG // lwcZMA0GCSqGSIb3DQEBCwUAA4IBAQB/68qn6ot2Qus+
// SIG // jiBUMOO3udz6SD4Wxw9FlRDNJ4ajZvMC7XH4qsJVl5Fw
// SIG // g/lSflJpPMnx4JRGgBi7odSkVqbzHQCR1YbzSIfgy8Q0
// SIG // aCBetMv5Be2cr3BTJ7noPn5RoGlxi9xR7YA6JTKfRK9u
// SIG // QyjTIXW7l9iLi4z+qQRGBIX3FZxLEY3ELBf+1W5/muJW
// SIG // kvGWs60t+fTf2omZzrI4RMD3R3vKJbn6Kmgzm1By3qif
// SIG // 1M0sCzS9izB4QOCNjicbkG8avggVgV3rL+JR51EeyXgp
// SIG // 5x5lvzjvAUoBCSQOFsQUecFBNzTQPZFSlJ3haO8I8OJp
// SIG // nGdukAsak3HUJgLDwFojMYIQgzCCEH8CAQEwgZkwgYQx
// SIG // CzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRlYyBD
// SIG // b3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1
// SIG // c3QgTmV0d29yazE1MDMGA1UEAxMsU3ltYW50ZWMgQ2xh
// SIG // c3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENBIC0gRzIC
// SIG // EAkI2uucBh4uubp+Jqpih4owDQYJYIZIAWUDBAIBBQCg
// SIG // fDAQBgorBgEEAYI3AgEMMQIwADAZBgkqhkiG9w0BCQMx
// SIG // DAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4wDAYK
// SIG // KwYBBAGCNwIBFTAvBgkqhkiG9w0BCQQxIgQgGnFYMi//
// SIG // nQhoJmXxRBkC6H45vtIrHsShNrG+Oo+Ef/8wDQYJKoZI
// SIG // hvcNAQEBBQAEggEAT1Nt0HvfNGeeyIFBnyoxdIIpn8ez
// SIG // I21FggZ0mrDWJrVo/naOAdTL2PNYPYwrdyL9siT/HFSC
// SIG // gtVyXDAgA/o6bz8rQAvduDQlQIbhdUIkXUPvnfisrhF8
// SIG // QtuheNQMro1256XjNy7Ns+vVQZ+DKwAkcik8r0BkVZE6
// SIG // t6QI+6ZKNTfDRUq9ex79nkoQ/9emDawz07JucOPrGUS3
// SIG // rTOAFzGpZkDGgaP6p6DnysYu7jy3qUzuPlB94sns/dxS
// SIG // KbdMGrCZ+HizoS4jSoj7X0YvUrc8poPKZJebC4Av6t61
// SIG // VyHQ2NM2Oz7QsJOv4iyofEWgceFpKbwAdqCW09AANl5B
// SIG // mtrLRKGCDjwwgg44BgorBgEEAYI3AwMBMYIOKDCCDiQG
// SIG // CSqGSIb3DQEHAqCCDhUwgg4RAgEDMQ0wCwYJYIZIAWUD
// SIG // BAIBMIIBDgYLKoZIhvcNAQkQAQSggf4EgfswgfgCAQEG
// SIG // C2CGSAGG+EUBBxcDMDEwDQYJYIZIAWUDBAIBBQAEIAhJ
// SIG // YDLBOiTEw+sGhK2sj2LnYakJTcSjQ6UpSZVPHoeBAhQl
// SIG // ZufolSBXESBesSMegQVRMigQGxgPMjAyMDAzMjMxNDAz
// SIG // MTdaMAMCAR6ggYakgYMwgYAxCzAJBgNVBAYTAlVTMR0w
// SIG // GwYDVQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlvbjEfMB0G
// SIG // A1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazExMC8G
// SIG // A1UEAxMoU3ltYW50ZWMgU0hBMjU2IFRpbWVTdGFtcGlu
// SIG // ZyBTaWduZXIgLSBHM6CCCoswggU4MIIEIKADAgECAhB7
// SIG // BbHUSWhRRPfJidKcGZ0SMA0GCSqGSIb3DQEBCwUAMIG9
// SIG // MQswCQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24s
// SIG // IEluYy4xHzAdBgNVBAsTFlZlcmlTaWduIFRydXN0IE5l
// SIG // dHdvcmsxOjA4BgNVBAsTMShjKSAyMDA4IFZlcmlTaWdu
// SIG // LCBJbmMuIC0gRm9yIGF1dGhvcml6ZWQgdXNlIG9ubHkx
// SIG // ODA2BgNVBAMTL1ZlcmlTaWduIFVuaXZlcnNhbCBSb290
// SIG // IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTE2MDEx
// SIG // MjAwMDAwMFoXDTMxMDExMTIzNTk1OVowdzELMAkGA1UE
// SIG // BhMCVVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0
// SIG // aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3
// SIG // b3JrMSgwJgYDVQQDEx9TeW1hbnRlYyBTSEEyNTYgVGlt
// SIG // ZVN0YW1waW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOC
// SIG // AQ8AMIIBCgKCAQEAu1mdWVVPnYxyXRqBoutV87ABrTxx
// SIG // rDKPBWuGmicAMpdqTclkFEspu8LZKbku7GOz4c8/C1aQ
// SIG // +GIbfuumB+Lef15tQDjUkQbnQXx5HMvLrRu/2JWR8/Du
// SIG // bPitljkuf8EnuHg5xYSl7e2vh47Ojcdt6tKYtTofHjmd
// SIG // w/SaqPSE4cTRfHHGBim0P+SDDSbDewg+TfkKtzNJ/8o7
// SIG // 1PWym0vhiJka9cDpMxTW38eA25Hu/rySV3J39M2ozP4J
// SIG // 9ZM3vpWIasXc9LFL1M7oCZFftYR5NYp4rBkyjyPBMkEb
// SIG // WQ6pPrHM+dYr77fY5NUdbRE6kvaTyZzjSO67Uw7UNpeG
// SIG // eMWhNwIDAQABo4IBdzCCAXMwDgYDVR0PAQH/BAQDAgEG
// SIG // MBIGA1UdEwEB/wQIMAYBAf8CAQAwZgYDVR0gBF8wXTBb
// SIG // BgtghkgBhvhFAQcXAzBMMCMGCCsGAQUFBwIBFhdodHRw
// SIG // czovL2Quc3ltY2IuY29tL2NwczAlBggrBgEFBQcCAjAZ
// SIG // GhdodHRwczovL2Quc3ltY2IuY29tL3JwYTAuBggrBgEF
// SIG // BQcBAQQiMCAwHgYIKwYBBQUHMAGGEmh0dHA6Ly9zLnN5
// SIG // bWNkLmNvbTA2BgNVHR8ELzAtMCugKaAnhiVodHRwOi8v
// SIG // cy5zeW1jYi5jb20vdW5pdmVyc2FsLXJvb3QuY3JsMBMG
// SIG // A1UdJQQMMAoGCCsGAQUFBwMIMCgGA1UdEQQhMB+kHTAb
// SIG // MRkwFwYDVQQDExBUaW1lU3RhbXAtMjA0OC0zMB0GA1Ud
// SIG // DgQWBBSvY9bKo06FcuCnvEHzKaI4f4B1YjAfBgNVHSME
// SIG // GDAWgBS2d/ppSEefUxLVwuoHMnYH0ZcHGTANBgkqhkiG
// SIG // 9w0BAQsFAAOCAQEAdeqwLdU0GVwyRf4O4dRPpnjBb9fq
// SIG // 3dxP86HIgYj3p48V5kApreZd9KLZVmSEcTAq3R5hF2Yg
// SIG // VgaYGY1dcfL4l7wJ/RyRR8ni6I0D+8yQL9YKbE4z7Na0
// SIG // k8hMkGNIOUAhxN3WbomYPLWYl+ipBrcJyY9TV0GQL+Ee
// SIG // TU7cyhB4bEJu8LbF+GFcUvVO9muN90p6vvPN/QPX2fYD
// SIG // qA/jU/cKdezGdS6qZoUEmbf4Blfhxg726K/a7JsYH6q5
// SIG // 4zoAv86KlMsB257HOLsPUqvR45QDYApNoP4nbRQy/D+X
// SIG // QOG/mYnb5DkUvdrk08PqK1qzlVhVBH3HmuwjA42FKtL/
// SIG // rqlhgTCCBUswggQzoAMCAQICEHvU5a+6zAc/oQEjBCJB
// SIG // TRIwDQYJKoZIhvcNAQELBQAwdzELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMSgw
// SIG // JgYDVQQDEx9TeW1hbnRlYyBTSEEyNTYgVGltZVN0YW1w
// SIG // aW5nIENBMB4XDTE3MTIyMzAwMDAwMFoXDTI5MDMyMjIz
// SIG // NTk1OVowgYAxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRT
// SIG // eW1hbnRlYyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3lt
// SIG // YW50ZWMgVHJ1c3QgTmV0d29yazExMC8GA1UEAxMoU3lt
// SIG // YW50ZWMgU0hBMjU2IFRpbWVTdGFtcGluZyBTaWduZXIg
// SIG // LSBHMzCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoC
// SIG // ggEBAK8Oiqr43L9pe1QXcUcJvY08gfh0FXdnkJz93k4C
// SIG // nkt29uU2PmXVJCBtMPndHYPpPydKM05tForkjUCNIqq+
// SIG // pwsb0ge2PLUaJCj4G3JRPcgJiCYIOvn6QyN1R3AMs19b
// SIG // jwgdckhXZU2vAjxA9/TdMjiTP+UspvNZI8uA3hNN+RDJ
// SIG // qgoYbFVhV9HxAizEtavybCPSnw0PGWythWJp/U6FwYpS
// SIG // Matb2Ml0UuNXbCK/VX9vygarP0q3InZl7Ow28paVgSYs
// SIG // /buYqgE4068lQJsJU/ApV4VYXuqFSEEhh+XetNMmsntA
// SIG // U1h5jlIxBk2UA0XEzjwD7LcA8joixbRv5e+wipsCAwEA
// SIG // AaOCAccwggHDMAwGA1UdEwEB/wQCMAAwZgYDVR0gBF8w
// SIG // XTBbBgtghkgBhvhFAQcXAzBMMCMGCCsGAQUFBwIBFhdo
// SIG // dHRwczovL2Quc3ltY2IuY29tL2NwczAlBggrBgEFBQcC
// SIG // AjAZGhdodHRwczovL2Quc3ltY2IuY29tL3JwYTBABgNV
// SIG // HR8EOTA3MDWgM6Axhi9odHRwOi8vdHMtY3JsLndzLnN5
// SIG // bWFudGVjLmNvbS9zaGEyNTYtdHNzLWNhLmNybDAWBgNV
// SIG // HSUBAf8EDDAKBggrBgEFBQcDCDAOBgNVHQ8BAf8EBAMC
// SIG // B4AwdwYIKwYBBQUHAQEEazBpMCoGCCsGAQUFBzABhh5o
// SIG // dHRwOi8vdHMtb2NzcC53cy5zeW1hbnRlYy5jb20wOwYI
// SIG // KwYBBQUHMAKGL2h0dHA6Ly90cy1haWEud3Muc3ltYW50
// SIG // ZWMuY29tL3NoYTI1Ni10c3MtY2EuY2VyMCgGA1UdEQQh
// SIG // MB+kHTAbMRkwFwYDVQQDExBUaW1lU3RhbXAtMjA0OC02
// SIG // MB0GA1UdDgQWBBSlEwGpn4XMG24WHl87Map5NgB7HTAf
// SIG // BgNVHSMEGDAWgBSvY9bKo06FcuCnvEHzKaI4f4B1YjAN
// SIG // BgkqhkiG9w0BAQsFAAOCAQEARp6v8LiiX6KZSM+oJ0sh
// SIG // zbK5pnJwYy/jVSl7OUZO535lBliLvFeKkg0I2BC6NiT6
// SIG // Cnv7O9Niv0qUFeaC24pUbf8o/mfPcT/mMwnZolkQ9B5K
// SIG // /mXM3tRr41IpdQBKK6XMy5voqU33tBdZkkHDtz+G5vbA
// SIG // f0Q8RlwXWuOkO9VpJtUhfeGAZ35irLdOLhWa5Zwjr1sR
// SIG // 6nGpQfkNeTipoQ3PtLHaPpp6xyLFdM3fRwmGxPyRJbIb
// SIG // lumFCOjd6nRgbmClVnoNyERY3Ob5SBSe5b/eAL13sZgU
// SIG // chQk38cRLB8AP8NLFMZnHMweBqOQX1xUiz7jM1uCD8W3
// SIG // hgJOcZ/pZkU/djGCAlowggJWAgEBMIGLMHcxCzAJBgNV
// SIG // BAYTAlVTMR0wGwYDVQQKExRTeW1hbnRlYyBDb3Jwb3Jh
// SIG // dGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0
// SIG // d29yazEoMCYGA1UEAxMfU3ltYW50ZWMgU0hBMjU2IFRp
// SIG // bWVTdGFtcGluZyBDQQIQe9Tlr7rMBz+hASMEIkFNEjAL
// SIG // BglghkgBZQMEAgGggaQwGgYJKoZIhvcNAQkDMQ0GCyqG
// SIG // SIb3DQEJEAEEMBwGCSqGSIb3DQEJBTEPFw0yMDAzMjMx
// SIG // NDAzMTdaMC8GCSqGSIb3DQEJBDEiBCBLvBYjP9pBofxf
// SIG // 5FMvPy6dZ3qhgCVkny8AA04+z/o+wzA3BgsqhkiG9w0B
// SIG // CRACLzEoMCYwJDAiBCDEdM52AH0COU4NpeTefBTGgPni
// SIG // ggE8/vZT7123H99h+DALBgkqhkiG9w0BAQEEggEACn6T
// SIG // a19Eiur54nIZlPLmfCzvmgJ+N7Rp4jQiJOY6+ty/qsOG
// SIG // HHfISUmpYtq4uXLVDaaceGwA0SChKz2T+GLTPoUbwEXW
// SIG // 69l+fFhlISm1H/ERpmuiINmchsvXuFm47pHAb5caqkzL
// SIG // u7HGKo2qlp2Sau9bEc9n6BCIaWy7uwIVEmingPOHnrxa
// SIG // CpaAxePvioBCWOWFZEpgDZ9gfsNInzR4OkeHXvDTKshP
// SIG // WG+92dKdguFZlCGnc8AKpU4nznY0CKkuMm3490I3JOwd
// SIG // h0biNJmaGoFVukgRO4aY7KLIHrorsMA6XffcpZJrmzSl
// SIG // ZJq4v3PK3+0SIVxNgP8TqLcA4pdHcw==
// SIG // End signature block
