var topic = "<!DOCTYPE html>\r\n\n<!-- saved from url=(0024)http://docs.autodesk.com -->\r\n<html>\n   <head>\n      <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n      <meta name=\"product\" content=\"VAULT\">\n      <meta name=\"release\" content=\"2021\">\n      <meta name=\"book\" content=\"GeneralUser\">\n      <meta name=\"created\" content=\"2020-03-20\">\n      <meta name=\"topicid\" content=\"GUID-590CC16D-0CA4-47A2-AA4E-713B8116DEAC\">\n      <meta name=\"description\" content=\"Before you begin your Vault installation, you should prepare for the deployment by examining your environment and gathering data to ensure an optimal installation experience.\">\n      <meta name=\"indexterm\" content=\"vault: installation requirements\">\n      <meta name=\"indexterm\" content=\"system requirements\">\n      <meta name=\"indexterm\" content=\"hardware requirements\">\n      <meta name=\"indexterm\" content=\"server requirements\">\n      <meta name=\"indexterm\" content=\"installation requirements\">\n      <meta name=\"indexterm\" content=\"requirements for installation\">\n      <meta name=\"indexterm\" content=\"Implementation Guide\">\n      <meta name=\"indexterm\" content=\"vault: implementation\">\n      <meta name=\"indexterm\" content=\"plan implementation\">\n      <meta name=\"indexterm\" content=\"vault: environment, planning\">\n      <meta name=\"topic-type\" content=\"concept\">\n      <meta name=\"audience\" content=\"user\">\n      <meta name=\"experiencelevel\" content=\"general\">\n      <title>Plan Your Deployment</title><script language=\"javascript\">var index = \'index.html\';</script></head>\n   <body height=\"100%\">\n      <div class=\"body_content\" id=\"body-content\" dir=\"ltr\"><a name=\"GUID-590CC16D-0CA4-47A2-AA4E-713B8116DEAC\"></a><div class=\"head\">\n            <h1>Plan Your Deployment</h1>\n         </div>\n         <p class=\"blurb\"> Before you begin your Vault installation, you should prepare for the deployment by\n            examining your environment and gathering data to ensure an optimal installation experience.\n            \n            	           \n         </p>\n         <p><a name=\"GUID-DB908939-78C1-4817-A45A-E62193948DD5\"></a>A Vault implementation can be as simple as installing all components on a single computer,\n            or as complex as installing components on several computers in different locations.\n            The more complex the implementation, the more information there is to consider. The\n            following sections detail information to consider to make the best decisions for your\n            Vault implementation. \n            	 \n         </p>\n         <div class=\"section\"><a name=\"SECTION_BBBCD1860D114A50927B59B3F4E3B3F8\"></a> \n            <h2><a name=\"GUID-EC981D39-995A-4116-B661-FE9A7D4CFB8B\"></a>Number of Users\n            </h2> \n            <p><a name=\"GUID-50E5D135-B998-484A-8772-F7B9A42FC43D\"></a>Knowing the number of users helps prevent access problems and slow response times.\n               For example, if you have more than ten concurrent users, use Windows® Server 2012.\n               For more than 25 users, consider upgrading to the full standard edition or enterprise\n               edition of SQL. Microsoft SQL Express allows only 25 concurrent connections. When\n               implementing Vault for a single user, you can load all the components on a single\n               computer. \n               		\n            </p> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_B1435849915E48A1B27B209EB5175962\"></a> \n            <h2><a name=\"GUID-48BBF4E9-FC90-4923-9C17-BB56167C95AE\"></a>Number of Servers\n            </h2> \n            <p><a name=\"GUID-60BB9F9E-7E37-43BF-B33F-66AB6AFE2F50\"></a>When determining the number of servers, keep in mind how information flows from the\n               client computer to the Vault server to the SQL server and back. (See \n               		  <span class=\"char_link\"><a href=\"\">How Vault Works</a></span> for more information.) \n               		\n            </p> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_74B078E7553B490DA81D7F50CCF23999\"></a> \n            <h2><a name=\"GUID-5DAF008D-0280-4326-B48E-2D809D937B1A\"></a>Server Hardware Specifications\n            </h2> \n            <p><a name=\"GUID-15FC43A3-ED76-43FE-9A32-910DFC80BCEC\"></a> Vault uses Microsoft SQL so it is more processor intensive than memory intensive\n               like some other applications. Avoid loading Vault components on servers that already\n               have a high CPU usage. \n               		\n            </p> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_E9E7A311F2CB4C6EBD9F983CB1B9D983\"></a> \n            <h2><a name=\"GUID-C0423DE9-CB85-45B6-B9C8-09B181A14ADB\"></a>Server Operating Systems\n            </h2> \n            <p><a name=\"GUID-04921BE6-59C7-4CF9-A814-ADF032BD153B\"></a>Vault Server can be loaded on several different operating systems. When deciding to\n               use a non-server operating system, consider the limitations. \n               		\n            </p> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_E431E40C3A694755BCE7C9CEA0D87721\"></a> \n            <h2><a name=\"GUID-AA85FA11-7CD7-4D93-B90F-1BCB2C11F780\"></a>Firewalls\n            </h2> \n            <p><a name=\"GUID-62542958-B251-4DA2-9C3A-ECB4BBFB48AC\"></a>Firewalls can block incoming requests. During the Vault Server installation, the server\n               is checked for known firewalls. Firewalls can require that you configure them to allow\n               the Vault Server to communicate correctly. Some system protection software can include\n               firewalls. Check these tools for the existence of firewalls. \n               		\n            </p> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_766911328EB14E0B9100CEC2346CE084\"></a> \n            <h2><a name=\"GUID-61095C7B-884A-4B66-81D1-399B8352C823\"></a>Applications on Servers\n            </h2> \n            <p><a name=\"GUID-08704FF6-FA81-41C7-B9F0-249F3E9E1EF6\"></a>Vault can be processor intensive. Loading the Vault Server on a server with other\n               processor intensive applications can cause Vault to run slower than expected. \n               		\n            </p> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_7CE66A98513144A5B64D0B79F0C585FC\"></a> \n            <h2><a name=\"GUID-F708F516-FC2F-432A-B7D2-E1248FDBBD57\"></a>Microsoft SQL Express\n            </h2> \n            <p><a name=\"GUID-EFDD6EAF-620F-4B9C-8EC0-E347C2142A16\"></a>Autodesk Vault requires a minimum of Microsoft SQL Express. See \n               		  <span class=\"char_link\"><a href=\"\">Installation Requirements</a></span>. \n               		\n            </p> \n            <p><a name=\"GUID-83656ACC-C475-40C5-9A53-C2EF54C47872\"></a> If your Vault implementation requires more capacity than SQL Express, set up the\n               Vault server using the Standard or Enterprise versions of SQL. \n               		\n            </p> \n            <p> If your computer/domain is set up to require strong/complex passwords, you will not\n               be able to use the default SQL SA password used by the Autodesk installer. Visit \n               		  <span class=\"char_link\"><a href=\"GUID-6E35739D-CBCC-4211-9051-E451EBE3360C.htm\">SQL Administration Tasks for Autodesk Vault</a></span> for information about setting an appropriate SA password. Check with your IT administrator\n               to learn the requirements for a strong/complex password. \n               		\n            </p> \n            <p> Autodesk Vault 2021 installs SQL Express Adv 2017 using the Network Service account\n               for SQL services. SQL Express Adv 2017 cannot be installed on a domain controller\n               under a local service account or a network service account. \n               		\n            </p> \n            <p> For security reasons, Microsoft recommends that you do not install SQL Server on\n               a domain controller. Visit \n               		  <a href=\"https://msdn.microsoft.com/en-us/library/ms143506.aspx\">Hardware and Software Requirements for Installing SQL Server</a> to learn more. \n               		\n            </p> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_4A4FAE96C7AA4A569B42BDA94A966A24\"></a> \n            <h2><a name=\"GUID-B59503A1-5D82-4C97-91EC-2B13E5B28A86\"></a>SQL Failover Clustering\n            </h2> \n            <p>Autodesk Vault functions in a SQL failover cluster configuration in which it is unaware\n               of the cluster and does not require reconfiguration of Vault if and when a failover\n               occurs. This is known as the AlwaysOn Failover Cluster Instances (FCI). More information\n               about this configuration can be found at \n               		  <a href=\"https://msdn.microsoft.com/en-us/library/ms189134.aspx\">Always On Failover Cluster Instances</a>. Before configuring this feature, Windows Server must be configured for \n               		  <a href=\"https://msdn.microsoft.com/en-us/library/hh270278(v=sql.130).aspx\" target=\"_blank\">Windows Server Failover Clustering (WSFC) with SQL Server</a>. When Vault is used within a SQL failover cluster environment, workflows occurring\n               during a failover may be interrupted and require repeating the workflow.​ \n               		\n            </p> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_CA092C9BBAAE4AE194F13CFA65A152DB\"></a> \n            <h2><a name=\"GUID-32EC7F32-97C5-43E0-811E-E6AF5D98900A\"></a>Access Frequency\n            </h2> \n            <p><a name=\"GUID-16061C61-5098-4180-9DB9-E0E4FCC74DC3\"></a>How often the Vault Server is accessed affects the server performance. For example,\n               a Vault implementation with 50 users and one or two users checking out one or two\n               files a day does not tax the server much. Using the same configuration with 35 of\n               the users accessing the vault every 10 minutes will have a greater impact on Vault\n               Server performance since it exceeds the recommended number of concurrent users. \n               		\n            </p> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_6C37E3EB0F1F4AECA5056C5EE356F28B\"></a> \n            <h2><a name=\"GUID-C67F19A0-DC7F-483C-BE0D-576D38FBCE80\"></a>Network Speed\n            </h2> \n            <p><a name=\"GUID-9ABD1AB2-2AAB-4F7A-8736-12D15DD7DD61\"></a>Although network speed is commonly equated to latency, you should also consider bandwidth\n               and throughput. Network speed is an important factor to consider when trying to get\n               the best performance for your Vault implementation. By running tests to measure your\n               latency, bandwidth, and throughput among all of the servers, you can gain an idea\n               of how fast the connections are. Copy a few large files from one server to another.\n               When performing this test, copy from Server A to Server B and then copy from server\n               B to Server A. Data traveling from one server to another does not always take the\n               same route when traveling back. \n               		\n            </p> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_FA11CBDB04F140E6B0FD3A45CBA36130\"></a> \n            <h2><a name=\"GUID-C208BD78-B4F6-4A82-BC0D-4743C74FDD80\"></a>Additional Considerations for Distributed Teams\n            </h2> \n            <p><a name=\"GUID-9FEECB4D-3A3C-475D-8E7D-6DD3EF32712F\"></a>If you are installing the server components for Vault Professional, you have several\n               options to better support teams distributed across multiple locations. Vault Professional\n               supports Multi-Site replication with a central remote database. Vault Professional\n               also allows a single site to implement Vault with a dedicated database server. \n               		\n            </p> \n            <div class=\"section\"><a name=\"SECTION_3AAD32DCBA4B40E0A70C83626DA16EAC\"></a> \n               <h3><a name=\"GUID-14129906-89C7-42B9-93B2-F86E0D084B43\"></a>Multi-Site \n               </h3> \n               <p><a name=\"GUID-22BC43A8-3AB1-4C77-A09C-769DB8E22CF2\"></a> Multiple remote sites can be configured to access the same vault data. A site comprises\n                  a dedicated Autodesk data management server and a file store. Each site accesses a\n                  shared AUTODESKVAULT SQL instance. \n                  		  \n               </p> \n            </div> \n            <div class=\"section\"><a name=\"SECTION_BE415CCDC25E4275B1CC62B80E824D90\"></a> \n               <h3><a name=\"GUID-ED94B929-3420-494E-B7BC-10CA2974168E\"></a>Expanded Architecture\n               </h3> \n               <p><a name=\"GUID-8651529F-3C07-4AAD-8CC3-A66BCAB2652F\"></a> In addition to a traditional multi-site environment configuration, the multi-site\n                  architecture can be expanded by using the Autodesk Vault File Server. In this layout,\n                  a remote site hosts its filestore locally, similar to a traditional multi-site environment,\n                  while directing meta-data traffic to the Autodesk Data Management Server to which\n                  it is connected. This configuration can provide considerable performance improvements\n                  if the remote site has a poor or slow connection to the SQL server. \n                  		  \n               </p> \n            </div> \n            <div class=\"section\"><a name=\"SECTION_8EE6F37393F241D295607FFA7B846355\"></a> \n               <h3><a name=\"GUID-6FE1B344-79FF-4433-BB4D-E66D8E866144\"></a>Replication\n               </h3> \n               <p><a name=\"GUID-D34AA7AE-C0D5-479F-A375-94F430A4B8C4\"></a> Replication is the process of copying data from one server to another server usually\n                  located in two different physical locations. This process allows the setup of a Vault\n                  environment that has two different locations. Users will not have to spend time downloading\n                  large CAD files across their Wide Area Network (WAN) connection. \n                  		  \n               </p> \n               <p><a name=\"GUID-0EE3E151-129D-46BE-8BD2-324760D646BF\"></a> The connected workgroup feature in Autodesk Vault Professional supports the use of\n                  multiple database servers using Microsoft SQL merge replication technology. This technology\n                  allows the replication of the SQL database at multiple locations. \n                  		  \n               </p> \n            </div> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_38BBDD06874444DBA85D16CF10DCBD38\"></a> \n            <h2><a name=\"GUID-44E3C48D-3215-4A36-B214-E4C15EF5F53A\"></a>Virtual Environment\n            </h2> \n            <p> It is recommended that you allocate the recommended (or higher) system requirements\n               when running Autodesk Vault in virtual environments. As virtual environments can cause\n               unexpected consequences, Autodesk reserves the right to ask that any customer-reported\n               problems be reproduced on a physical machine outside of the VMware environment. ​\n               \n               		\n            </p> \n            <p> For information on certified virtualization vendors and their respective solutions,\n               see Microsoft\'s products list at \n               		  <a href=\"https://www.windowsservercatalog.com/SVVP.ASPX?SVVPPAGE=SVVP.HTM\">Windows Server Virtualization Validation Program</a>. \n               		\n            </p> \n            <p> Microsoft\'s support policy for Microsoft software running in non-Microsoft hardware\n               virtualization software can be found at \n               		  <a href=\"https://support.microsoft.com/en-us/help/897615/support-policy-for-microsoft-software-that-runs-on-non-microsoft-hardware-virtualization-software\" target=\"_blank\">Support policy for Microsoft software that runs on non-Microsoft hardware virtualization\n                  software</a>. \n               		\n            </p> \n            <p> Microsoft\'s support policy for Microsoft SQL Server products running in a hardware\n               virtualization environment can be found at \n               		  <a href=\"https://support.microsoft.com/en-us/help/956893/support-policy-for-microsoft-sql-server-products-that-are-running-in-a-hardware-virtualization-environment\" target=\"_blank\">Support policy for Microsoft SQL Server products that are running in a hardware virtualization\n                  environment</a>. \n               		\n            </p> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_DAFA15BB92ED471CBE5BC7CC27B62BF3\"></a> \n            <h2><a name=\"GUID-426603C3-D909-4A80-B5BC-6A83784D59C8\"></a>Supported Language Configurations\n            </h2> \n            <div class=\"section\"><a name=\"SECTION_0888628449F1431587D57014074B25FE\"></a> \n               <h3><a name=\"GUID-A5DAA234-878B-4D0B-BB92-6A0F55930EAF\"></a>Supported Client Language Configurations\n               </h3> \n               <p>Any client meeting the following criteria can work with any server of any language\n                  meeting the server criteria below. Client language and server language do not need\n                  to match. \n                  		  \n               </p> \n               <p>The Autodesk Vault client is supported on operating systems of the following languages:\n                  Brazilian Portuguese, Czech, English, French, German, Hungarian, Italian, Japanese,\n                  Korean, Polish, Russian, Simplified Chinese, Spanish, and Traditional Chinese. \n                  		  \n               </p> \n               <p>An English language Vault client is supported on all supported non-English language\n                  operating systems. \n                  		  \n               </p> \n               <p>Vault Basic, Workgroup and Vault Professional are localized into Brazilian Portuguese,\n                  Czech, English, French, German, Hungarian, Italian, Japanese, Korean, Polish, Russian,\n                  Simplified Chinese, Spanish, and Traditional Chinese. \n                  		  \n               </p> \n               <p>The language of the Autodesk Vault CAD add-in must be the same language as the CAD\n                  application. \n                  		  \n               </p> \n            </div> \n            <div class=\"section\"><a name=\"SECTION_D27AA8DEFB4241C3BCD185A79FF4CB62\"></a> \n               <h3><a name=\"GUID-708A1AD8-F354-49E3-8B15-D57BA49A8BC9\"></a>Other Client Language Notes\n               </h3> \n               <p>The Vault client does not support runtime language switching. \n                  		  \n               </p> \n               <p>Vault add-ins do not support the switch of a CAD application\'s language to a configuration\n                  which does not meet the criteria outlined in the section above. \n                  		  \n               </p> \n               <p>An English version of Autodesk DWG TrueView is included in all Vault client products\n                  for all languages except Japanese and French. \n                  		  \n               </p> \n            </div> \n            <div class=\"section\"><a name=\"SECTION_1A2D9A73A4414CDF9BC11CDC7CD70326\"></a> \n               <h3><a name=\"GUID-C476C157-44D0-48A9-BE9C-D16EE7AECB35\"></a>Supported Vault Server Language Configurations\n               </h3> \n               <p>Any server meeting the following criteria can work with any client of any language\n                  meeting the client criteria above. \n                  		  \n               </p> \n               <p>The Vault Server is supported on operating systems of the following languages: Brazilian\n                  Portuguese, Czech, English, French, German, Hungarian, Italian, Japanese, Korean,\n                  Polish, Russian, Simplified Chinese, Spanish, and Traditional Chinese. \n                  		  \n               </p> \n               <p>An English language Vault Server is supported on all supported non-English language\n                  operating system. \n                  		  \n               </p> \n               <p>A non-English Vault Server must match the language of the operating system. \n                  		  \n               </p> \n               <p>Any case-insensitive collation and/or language of SQL may be used with any language\n                  Vault Server. \n                  		  \n               </p> \n               <p>Migrating from one Language of Vault Server to a different language of Vault Server\n                  is only supported if it is to or from an English Language Vault Server. \n                  		  \n               </p> \n            </div> \n            <div class=\"section\"><a name=\"SECTION_87756DE038784CE2B6603B1A98A707BB\"></a> \n               <h3><a name=\"GUID-3F8A529E-97B8-4222-8720-CB028F0D4367\"></a>Other Vault Server Language Notes\n               </h3> \n               <p>Restoring a backup from a different SQL collation other than the collation currently\n                  being used will result in the backup\'s collation being used. \n                  		  \n               </p> \n            </div> \n            <div class=\"section\"><a name=\"SECTION_EEF32D5E4E6E482DA2BE1931CADD2AA8\"></a> \n               <h3><a name=\"GUID-50220EAE-4C33-45EA-A20B-80DD933778EF\"></a>Supported Connected Workgroup Server Language Configurations\n               </h3> \n               <p>Any server meeting the above criteria can work with any other server of any language\n                  meeting the above criteria. \n                  		  \n               </p> \n            </div> \n            <div class=\"section\"><a name=\"SECTION_EA94890D6D674A7A8DF56AC8C7F28DEB\"></a> \n               <h3><a name=\"GUID-5CD3915F-2E2D-4DBB-BFA4-8BF443D543A9\"></a>Other Replication-Related Language Notes\n               </h3> \n               <p>The publisher\'s SQL collation/language determines collation/language in a replicated\n                  environment regardless of the installed SQL language of subscribers. \n                  		  \n               </p> \n               <p>Autodesk recommends all SQL installations in a replicated environment be the same\n                  language. \n                  		  \n               </p> \n            </div> \n         </div>\n         <div class=\"footer-block\"><a href=\"..\" class=\"comments-anchor\" target=\"_blank\"><span class=\"comments-link\">Please send us your comment about this page</span></a></div><br><p class=\"footer-license-block\"><a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\"><img alt=\"Creative Commons License\" style=\"border-width: 0;\" src=\"../images/ccLink.png\"></a>&nbsp;<em>Except where otherwise noted, this work is licensed under a <a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\">Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License</a>. Please see the <a href=\"http://autodesk.com/creativecommons\" target=\"_blank\">Autodesk Creative Commons FAQ</a> for more information.</em></p><br></div>\n   </body>\n</html>";
// SIG // Begin signature block
// SIG // MIIbRQYJKoZIhvcNAQcCoIIbNjCCGzICAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // sUc9iJlffbEinkwUsjLEGfDO3+mmCBnmP4Yow7blpzGg
// SIG // ggoaMIIEyzCCA7OgAwIBAgIQCQja65wGHi65un4mqmKH
// SIG // ijANBgkqhkiG9w0BAQsFADCBhDELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTUw
// SIG // MwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
// SIG // b2RlIFNpZ25pbmcgQ0EgLSBHMjAeFw0xOTA1MTQwMDAw
// SIG // MDBaFw0yMDA1MTMyMzU5NTlaMHwxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIDApDYWxpZm9ybmlhMRMwEQYDVQQHDApT
// SIG // YW4gUmFmYWVsMRcwFQYDVQQKDA5BdXRvZGVzaywgSW5j
// SIG // LjERMA8GA1UECwwIU2VjdXJpdHkxFzAVBgNVBAMMDkF1
// SIG // dG9kZXNrLCBJbmMuMIIBIjANBgkqhkiG9w0BAQEFAAOC
// SIG // AQ8AMIIBCgKCAQEAkVKRoPYsoxPdlabspcuG8HYDfcWQ
// SIG // 9qyPOT2punwpVdjt2slktcpSTlydrGy8ijcbl5/k8AOJ
// SIG // afKMQvow0fNjIoNB5nsb8j2xFJPbBhHl8GT4P6DZ1OWK
// SIG // ioiUXgGHKjctUws49J4elntqvBYhKCbuPqG772QCoYFU
// SIG // P7qcFbh3PbyNB6cnKMn2vNGRqiEtV2aGg+/MiL3QPsvT
// SIG // kTWhVuTLIvwZ4kK5C5ACiQzlGOlE+C7gWuFoxtvy6gUa
// SIG // A8JAq/xLjYKwFevQwGncg3s1cuiGhx0P7Rvn6oCd2cem
// SIG // FmbK3I3rMRt+jc9wzAj3oHxvCo4f5Lfva+OpC1dETUVV
// SIG // sk0VGwIDAQABo4IBPjCCATowCQYDVR0TBAIwADAOBgNV
// SIG // HQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMw
// SIG // YQYDVR0gBFowWDBWBgZngQwBBAEwTDAjBggrBgEFBQcC
// SIG // ARYXaHR0cHM6Ly9kLnN5bWNiLmNvbS9jcHMwJQYIKwYB
// SIG // BQUHAgIwGQwXaHR0cHM6Ly9kLnN5bWNiLmNvbS9ycGEw
// SIG // HwYDVR0jBBgwFoAU1MAGIknrOUvdk+JcobhHdglyA1gw
// SIG // KwYDVR0fBCQwIjAgoB6gHIYaaHR0cDovL3JiLnN5bWNi
// SIG // LmNvbS9yYi5jcmwwVwYIKwYBBQUHAQEESzBJMB8GCCsG
// SIG // AQUFBzABhhNodHRwOi8vcmIuc3ltY2QuY29tMCYGCCsG
// SIG // AQUFBzAChhpodHRwOi8vcmIuc3ltY2IuY29tL3JiLmNy
// SIG // dDANBgkqhkiG9w0BAQsFAAOCAQEA0Q2+iVSEfT4xGq3A
// SIG // OADVb0rT5Z8E+PPb1x6hKknSzuaZKk/acDz9mdnFajaU
// SIG // WgIKiFJlsqJnuAM1w4lqKaEWsz3DoxvGIEwexj71Ud6a
// SIG // KlBJNcR9DdkXUZwMhbw9d78rjJAIX6tOwfSludZfdq8b
// SIG // YEkuIzQi9uYW9vHVPSCzhnUBKjwc9qTo9yBc7Fcn4FAT
// SIG // 90DzWM2hS9oc3p0pprYI2I/O4th90BEmwWkVqVgfaR0z
// SIG // VyIEmBbqB/IWLfjUBZJ/8sbkwWuWlYVRrfPxsj1e9qvb
// SIG // wE3Y28jWyGbqoUG39GhXk3uT8R8i3+T6M0c4rMfdifBC
// SIG // pceCaFTJzSye7LoeVzCCBUcwggQvoAMCAQICEHwbNTVK
// SIG // 59t050FfEWnKa6gwDQYJKoZIhvcNAQELBQAwgb0xCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjEfMB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29y
// SIG // azE6MDgGA1UECxMxKGMpIDIwMDggVmVyaVNpZ24sIElu
// SIG // Yy4gLSBGb3IgYXV0aG9yaXplZCB1c2Ugb25seTE4MDYG
// SIG // A1UEAxMvVmVyaVNpZ24gVW5pdmVyc2FsIFJvb3QgQ2Vy
// SIG // dGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMTQwNzIyMDAw
// SIG // MDAwWhcNMjQwNzIxMjM1OTU5WjCBhDELMAkGA1UEBhMC
// SIG // VVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9u
// SIG // MR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3Jr
// SIG // MTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1
// SIG // NiBDb2RlIFNpZ25pbmcgQ0EgLSBHMjCCASIwDQYJKoZI
// SIG // hvcNAQEBBQADggEPADCCAQoCggEBANeVQ9Tc32euOftS
// SIG // pLYmMQRw6beOWyq6N2k1lY+7wDDnhthzu9/r0XY/ilaO
// SIG // 6y1L8FcYTrGNpTPTC3Uj1Wp5J92j0/cOh2W13q0c8fU1
// SIG // tCJRryKhwV1LkH/AWU6rnXmpAtceSbE7TYf+wnirv+9S
// SIG // rpyvCNk55ZpRPmlfMBBOcWNsWOHwIDMbD3S+W8sS4duM
// SIG // xICUcrv2RZqewSUL+6McntimCXBx7MBHTI99w94Zzj7u
// SIG // BHKOF9P/8LIFMhlM07Acn/6leCBCcEGwJoxvAMg6ABFB
// SIG // ekGwp4qRBKCZePR3tPNgKuZsUAS3FGD/DVH0qIuE/iHa
// SIG // XF599Sl5T7BEdG9tcv8CAwEAAaOCAXgwggF0MC4GCCsG
// SIG // AQUFBwEBBCIwIDAeBggrBgEFBQcwAYYSaHR0cDovL3Mu
// SIG // c3ltY2QuY29tMBIGA1UdEwEB/wQIMAYBAf8CAQAwZgYD
// SIG // VR0gBF8wXTBbBgtghkgBhvhFAQcXAzBMMCMGCCsGAQUF
// SIG // BwIBFhdodHRwczovL2Quc3ltY2IuY29tL2NwczAlBggr
// SIG // BgEFBQcCAjAZGhdodHRwczovL2Quc3ltY2IuY29tL3Jw
// SIG // YTA2BgNVHR8ELzAtMCugKaAnhiVodHRwOi8vcy5zeW1j
// SIG // Yi5jb20vdW5pdmVyc2FsLXJvb3QuY3JsMBMGA1UdJQQM
// SIG // MAoGCCsGAQUFBwMDMA4GA1UdDwEB/wQEAwIBBjApBgNV
// SIG // HREEIjAgpB4wHDEaMBgGA1UEAxMRU3ltYW50ZWNQS0kt
// SIG // MS03MjQwHQYDVR0OBBYEFNTABiJJ6zlL3ZPiXKG4R3YJ
// SIG // cgNYMB8GA1UdIwQYMBaAFLZ3+mlIR59TEtXC6gcydgfR
// SIG // lwcZMA0GCSqGSIb3DQEBCwUAA4IBAQB/68qn6ot2Qus+
// SIG // jiBUMOO3udz6SD4Wxw9FlRDNJ4ajZvMC7XH4qsJVl5Fw
// SIG // g/lSflJpPMnx4JRGgBi7odSkVqbzHQCR1YbzSIfgy8Q0
// SIG // aCBetMv5Be2cr3BTJ7noPn5RoGlxi9xR7YA6JTKfRK9u
// SIG // QyjTIXW7l9iLi4z+qQRGBIX3FZxLEY3ELBf+1W5/muJW
// SIG // kvGWs60t+fTf2omZzrI4RMD3R3vKJbn6Kmgzm1By3qif
// SIG // 1M0sCzS9izB4QOCNjicbkG8avggVgV3rL+JR51EeyXgp
// SIG // 5x5lvzjvAUoBCSQOFsQUecFBNzTQPZFSlJ3haO8I8OJp
// SIG // nGdukAsak3HUJgLDwFojMYIQgzCCEH8CAQEwgZkwgYQx
// SIG // CzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRlYyBD
// SIG // b3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1
// SIG // c3QgTmV0d29yazE1MDMGA1UEAxMsU3ltYW50ZWMgQ2xh
// SIG // c3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENBIC0gRzIC
// SIG // EAkI2uucBh4uubp+Jqpih4owDQYJYIZIAWUDBAIBBQCg
// SIG // fDAQBgorBgEEAYI3AgEMMQIwADAZBgkqhkiG9w0BCQMx
// SIG // DAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4wDAYK
// SIG // KwYBBAGCNwIBFTAvBgkqhkiG9w0BCQQxIgQg6xiNKnaM
// SIG // HlBGECn8MyraXE4xUKpw0xDDjBQRAxUqG34wDQYJKoZI
// SIG // hvcNAQEBBQAEggEASO2yp//ZrmdQH/DB4FtbkpEWkN94
// SIG // Lgvob3Qf/46zVRHSfZ6zZ98hhGQRhGUuLoW0ulL9onm2
// SIG // 8r+tB7jXcERz2teYK9olq24sB2HoqqEKsGo5iYXir9N4
// SIG // bbw6oNIsagfGegFrRKHKZYb2GFCK3rHVBrhVo498zAec
// SIG // yTSClWK0Ql3CEdEIOpfwtZF+cVuIQ6vuWxnU0MQHazLm
// SIG // VelVmIZqWLnAHuLpNFM6FOufI8nN62wUNhmPCj2KcaIF
// SIG // gsH5t5BfZsRWWfc5tebhD7qBpp3gfmxhafE8IFHEgBGx
// SIG // 735BLRj+ngtRHc1mPO02owRMFYNIUAxPbukynl1KK+7+
// SIG // 276ZrKGCDjwwgg44BgorBgEEAYI3AwMBMYIOKDCCDiQG
// SIG // CSqGSIb3DQEHAqCCDhUwgg4RAgEDMQ0wCwYJYIZIAWUD
// SIG // BAIBMIIBDgYLKoZIhvcNAQkQAQSggf4EgfswgfgCAQEG
// SIG // C2CGSAGG+EUBBxcDMDEwDQYJYIZIAWUDBAIBBQAEIIdk
// SIG // kC2BUTtqfZ0OAWI8CeqvLVrpz88b9OnX6H4W7b4fAhRI
// SIG // oouKOnvdzKNkIW17uGedpE2aIBgPMjAyMDAzMjMxNDA1
// SIG // MzFaMAMCAR6ggYakgYMwgYAxCzAJBgNVBAYTAlVTMR0w
// SIG // GwYDVQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlvbjEfMB0G
// SIG // A1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazExMC8G
// SIG // A1UEAxMoU3ltYW50ZWMgU0hBMjU2IFRpbWVTdGFtcGlu
// SIG // ZyBTaWduZXIgLSBHM6CCCoswggU4MIIEIKADAgECAhB7
// SIG // BbHUSWhRRPfJidKcGZ0SMA0GCSqGSIb3DQEBCwUAMIG9
// SIG // MQswCQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24s
// SIG // IEluYy4xHzAdBgNVBAsTFlZlcmlTaWduIFRydXN0IE5l
// SIG // dHdvcmsxOjA4BgNVBAsTMShjKSAyMDA4IFZlcmlTaWdu
// SIG // LCBJbmMuIC0gRm9yIGF1dGhvcml6ZWQgdXNlIG9ubHkx
// SIG // ODA2BgNVBAMTL1ZlcmlTaWduIFVuaXZlcnNhbCBSb290
// SIG // IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTE2MDEx
// SIG // MjAwMDAwMFoXDTMxMDExMTIzNTk1OVowdzELMAkGA1UE
// SIG // BhMCVVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0
// SIG // aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3
// SIG // b3JrMSgwJgYDVQQDEx9TeW1hbnRlYyBTSEEyNTYgVGlt
// SIG // ZVN0YW1waW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOC
// SIG // AQ8AMIIBCgKCAQEAu1mdWVVPnYxyXRqBoutV87ABrTxx
// SIG // rDKPBWuGmicAMpdqTclkFEspu8LZKbku7GOz4c8/C1aQ
// SIG // +GIbfuumB+Lef15tQDjUkQbnQXx5HMvLrRu/2JWR8/Du
// SIG // bPitljkuf8EnuHg5xYSl7e2vh47Ojcdt6tKYtTofHjmd
// SIG // w/SaqPSE4cTRfHHGBim0P+SDDSbDewg+TfkKtzNJ/8o7
// SIG // 1PWym0vhiJka9cDpMxTW38eA25Hu/rySV3J39M2ozP4J
// SIG // 9ZM3vpWIasXc9LFL1M7oCZFftYR5NYp4rBkyjyPBMkEb
// SIG // WQ6pPrHM+dYr77fY5NUdbRE6kvaTyZzjSO67Uw7UNpeG
// SIG // eMWhNwIDAQABo4IBdzCCAXMwDgYDVR0PAQH/BAQDAgEG
// SIG // MBIGA1UdEwEB/wQIMAYBAf8CAQAwZgYDVR0gBF8wXTBb
// SIG // BgtghkgBhvhFAQcXAzBMMCMGCCsGAQUFBwIBFhdodHRw
// SIG // czovL2Quc3ltY2IuY29tL2NwczAlBggrBgEFBQcCAjAZ
// SIG // GhdodHRwczovL2Quc3ltY2IuY29tL3JwYTAuBggrBgEF
// SIG // BQcBAQQiMCAwHgYIKwYBBQUHMAGGEmh0dHA6Ly9zLnN5
// SIG // bWNkLmNvbTA2BgNVHR8ELzAtMCugKaAnhiVodHRwOi8v
// SIG // cy5zeW1jYi5jb20vdW5pdmVyc2FsLXJvb3QuY3JsMBMG
// SIG // A1UdJQQMMAoGCCsGAQUFBwMIMCgGA1UdEQQhMB+kHTAb
// SIG // MRkwFwYDVQQDExBUaW1lU3RhbXAtMjA0OC0zMB0GA1Ud
// SIG // DgQWBBSvY9bKo06FcuCnvEHzKaI4f4B1YjAfBgNVHSME
// SIG // GDAWgBS2d/ppSEefUxLVwuoHMnYH0ZcHGTANBgkqhkiG
// SIG // 9w0BAQsFAAOCAQEAdeqwLdU0GVwyRf4O4dRPpnjBb9fq
// SIG // 3dxP86HIgYj3p48V5kApreZd9KLZVmSEcTAq3R5hF2Yg
// SIG // VgaYGY1dcfL4l7wJ/RyRR8ni6I0D+8yQL9YKbE4z7Na0
// SIG // k8hMkGNIOUAhxN3WbomYPLWYl+ipBrcJyY9TV0GQL+Ee
// SIG // TU7cyhB4bEJu8LbF+GFcUvVO9muN90p6vvPN/QPX2fYD
// SIG // qA/jU/cKdezGdS6qZoUEmbf4Blfhxg726K/a7JsYH6q5
// SIG // 4zoAv86KlMsB257HOLsPUqvR45QDYApNoP4nbRQy/D+X
// SIG // QOG/mYnb5DkUvdrk08PqK1qzlVhVBH3HmuwjA42FKtL/
// SIG // rqlhgTCCBUswggQzoAMCAQICEHvU5a+6zAc/oQEjBCJB
// SIG // TRIwDQYJKoZIhvcNAQELBQAwdzELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMSgw
// SIG // JgYDVQQDEx9TeW1hbnRlYyBTSEEyNTYgVGltZVN0YW1w
// SIG // aW5nIENBMB4XDTE3MTIyMzAwMDAwMFoXDTI5MDMyMjIz
// SIG // NTk1OVowgYAxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRT
// SIG // eW1hbnRlYyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3lt
// SIG // YW50ZWMgVHJ1c3QgTmV0d29yazExMC8GA1UEAxMoU3lt
// SIG // YW50ZWMgU0hBMjU2IFRpbWVTdGFtcGluZyBTaWduZXIg
// SIG // LSBHMzCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoC
// SIG // ggEBAK8Oiqr43L9pe1QXcUcJvY08gfh0FXdnkJz93k4C
// SIG // nkt29uU2PmXVJCBtMPndHYPpPydKM05tForkjUCNIqq+
// SIG // pwsb0ge2PLUaJCj4G3JRPcgJiCYIOvn6QyN1R3AMs19b
// SIG // jwgdckhXZU2vAjxA9/TdMjiTP+UspvNZI8uA3hNN+RDJ
// SIG // qgoYbFVhV9HxAizEtavybCPSnw0PGWythWJp/U6FwYpS
// SIG // Matb2Ml0UuNXbCK/VX9vygarP0q3InZl7Ow28paVgSYs
// SIG // /buYqgE4068lQJsJU/ApV4VYXuqFSEEhh+XetNMmsntA
// SIG // U1h5jlIxBk2UA0XEzjwD7LcA8joixbRv5e+wipsCAwEA
// SIG // AaOCAccwggHDMAwGA1UdEwEB/wQCMAAwZgYDVR0gBF8w
// SIG // XTBbBgtghkgBhvhFAQcXAzBMMCMGCCsGAQUFBwIBFhdo
// SIG // dHRwczovL2Quc3ltY2IuY29tL2NwczAlBggrBgEFBQcC
// SIG // AjAZGhdodHRwczovL2Quc3ltY2IuY29tL3JwYTBABgNV
// SIG // HR8EOTA3MDWgM6Axhi9odHRwOi8vdHMtY3JsLndzLnN5
// SIG // bWFudGVjLmNvbS9zaGEyNTYtdHNzLWNhLmNybDAWBgNV
// SIG // HSUBAf8EDDAKBggrBgEFBQcDCDAOBgNVHQ8BAf8EBAMC
// SIG // B4AwdwYIKwYBBQUHAQEEazBpMCoGCCsGAQUFBzABhh5o
// SIG // dHRwOi8vdHMtb2NzcC53cy5zeW1hbnRlYy5jb20wOwYI
// SIG // KwYBBQUHMAKGL2h0dHA6Ly90cy1haWEud3Muc3ltYW50
// SIG // ZWMuY29tL3NoYTI1Ni10c3MtY2EuY2VyMCgGA1UdEQQh
// SIG // MB+kHTAbMRkwFwYDVQQDExBUaW1lU3RhbXAtMjA0OC02
// SIG // MB0GA1UdDgQWBBSlEwGpn4XMG24WHl87Map5NgB7HTAf
// SIG // BgNVHSMEGDAWgBSvY9bKo06FcuCnvEHzKaI4f4B1YjAN
// SIG // BgkqhkiG9w0BAQsFAAOCAQEARp6v8LiiX6KZSM+oJ0sh
// SIG // zbK5pnJwYy/jVSl7OUZO535lBliLvFeKkg0I2BC6NiT6
// SIG // Cnv7O9Niv0qUFeaC24pUbf8o/mfPcT/mMwnZolkQ9B5K
// SIG // /mXM3tRr41IpdQBKK6XMy5voqU33tBdZkkHDtz+G5vbA
// SIG // f0Q8RlwXWuOkO9VpJtUhfeGAZ35irLdOLhWa5Zwjr1sR
// SIG // 6nGpQfkNeTipoQ3PtLHaPpp6xyLFdM3fRwmGxPyRJbIb
// SIG // lumFCOjd6nRgbmClVnoNyERY3Ob5SBSe5b/eAL13sZgU
// SIG // chQk38cRLB8AP8NLFMZnHMweBqOQX1xUiz7jM1uCD8W3
// SIG // hgJOcZ/pZkU/djGCAlowggJWAgEBMIGLMHcxCzAJBgNV
// SIG // BAYTAlVTMR0wGwYDVQQKExRTeW1hbnRlYyBDb3Jwb3Jh
// SIG // dGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0
// SIG // d29yazEoMCYGA1UEAxMfU3ltYW50ZWMgU0hBMjU2IFRp
// SIG // bWVTdGFtcGluZyBDQQIQe9Tlr7rMBz+hASMEIkFNEjAL
// SIG // BglghkgBZQMEAgGggaQwGgYJKoZIhvcNAQkDMQ0GCyqG
// SIG // SIb3DQEJEAEEMBwGCSqGSIb3DQEJBTEPFw0yMDAzMjMx
// SIG // NDA1MzFaMC8GCSqGSIb3DQEJBDEiBCBOwexhbe1oOfq5
// SIG // rgWCCVvoRLaXTi5QMqx12SDfi3NL/DA3BgsqhkiG9w0B
// SIG // CRACLzEoMCYwJDAiBCDEdM52AH0COU4NpeTefBTGgPni
// SIG // ggE8/vZT7123H99h+DALBgkqhkiG9w0BAQEEggEADCTN
// SIG // N+0HcAsiVfVIIq+MWBa39/zS5+bWc2NB9S3bbbTuqWSQ
// SIG // /YqrRlYNBAQZ8NnCrUzvfuECS+Vfw7SU4zfgIekaIGvV
// SIG // zmjADiK198aeYxdLvyJ6ae43yjrWHUBdLcCOE4+/uPtj
// SIG // sKY7Y8OrZwevIq4WIF7L6F/lWzDdrav8R50PrYbz+Gji
// SIG // Sv/81Gxz8/Q51G722YJsdaHvdUCjw5yrvn1MPIoOviJO
// SIG // 2vLRC7bVTwP7yGJ7RV3z/cakcrJuIyElR3TUUqyip+xI
// SIG // qms5K9qZBqzavRQ638tn1UA6k6yG03z/sEzjHbFtyqZH
// SIG // 0V87g7kLDqU0TfEYP6PpTy5d2Tpy6w==
// SIG // End signature block
