var topic = "<!DOCTYPE html>\r\n\n<!-- saved from url=(0024)http://docs.autodesk.com -->\r\n<html>\n   <head>\n      <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n      <meta name=\"product\" content=\"VAULT\">\n      <meta name=\"release\" content=\"2021\">\n      <meta name=\"book\" content=\"GeneralUser\">\n      <meta name=\"created\" content=\"2020-03-20\">\n      <meta name=\"topicid\" content=\"GUID-35BE7DEF-C918-4298-9606-F999F4CC4D02\">\n      <meta name=\"description\" content=\"The Data Standard Add-in for AutoCAD and Inventor provides two unique configuration files that determine Data Standard sheet behavior. Modify these behaviors to suit your design workflow.\">\n      <meta name=\"topic-type\" content=\"concept\">\n      <meta name=\"audience\" content=\"administrator\">\n      <meta name=\"experiencelevel\" content=\"general\">\n      <title>Data Standard Configuration Files for AutoCAD and Inventor</title><script language=\"javascript\">var index = \'index.html\';</script><script type=\"text/javascript\" src=\"../scripts/prettify/prettify.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-yaml.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-xq.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-wiki.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-vhdl.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-vb.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-tex.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-sql.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-scala.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-proto.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-n.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-ml.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-lua.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-lisp.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-hs.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-go.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-css.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-clj.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-apollo.js\"></script></head>\n   <body height=\"100%\" onLoad=\"javascript:prettyPrint();\">\n      <div class=\"body_content\" id=\"body-content\" dir=\"ltr\"><a name=\"GUID-35BE7DEF-C918-4298-9606-F999F4CC4D02\"></a><div class=\"head\">\n            <h1>Data Standard Configuration Files for AutoCAD and Inventor</h1>\n         </div>\n         <p class=\"blurb\"> The Data Standard Add-in for AutoCAD and Inventor provides two unique configuration\n            files that determine Data Standard sheet behavior. Modify these behaviors to suit\n            your design workflow. \n            \n         </p>\n         <p>You can dynamically set property configuration while a dialog is loaded (use the InitializeWindow\n            function). \n            	 \n         </p>\n         <div><a name=\"GUID-E045B443-74C8-4BBA-91E8-84128A277D14\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span>This topic applies only to the Data Standard add-in for Inventor and AutoCAD. \n               	 \n            </div>\n         </div>\n         <p> The following behaviors are defined in the Data Standard configuration files. \n            	 <a name=\"UL_A964373F7C5446DBA4FCB37AB40CD6A4\"></a><ul>\n               <li>Which fields and properties are available in Data Standard. \n                  		\n               </li>\n               <li>Where the file is saved. \n                  		\n               </li>\n               <li>The file name. \n                  		\n               </li>\n               <li><em class=\"strong\">Inventor only–</em>If Data Standard dialog is displayed automatically when saving. \n                  		\n               </li>\n               <li><em class=\"strong\">Inventor only–</em>If the Vault Check-in dialog is displayed. \n                  		\n               </li>\n               <li><em class=\"strong\">AutoCAD only–</em>Which AutoCAD Mechanical title blocks are supported. \n                  		\n               </li>\n            </ul> \n         </p>\n         <div class=\"section\"><a name=\"SECTION_95ECFB0F116A423193D134167C0DD923\"></a> \n            <h2><a name=\"GUID-1BB48EBE-4FEF-4E5B-84B8-8CA9F5302C0A\"></a>Configuration File Details\n            </h2> \n            <p>There are two unique configuration files for the Data Standard Add-in for AutoCAD\n               and Inventor. \n               		<a name=\"UL_B5503C2398174DB19D40D866E9B4942B\"></a><ul>\n                  <li><span class=\"filePath\">Inventor.cfg</span> \n                  </li>\n                  <li><span class=\"filePath\">AutoCAD.cfg</span> \n                  </li>\n               </ul> \n            </p> \n            <p>You can find both of these files in \n               		  <span class=\"filePath\">C:\\ProgramData\\Autodesk\\&lt;Vault edition&gt;\\Extensions\\DataStandard\\CAD</span>. \n               		\n            </p> \n            <p>The CFG file is loaded only once when starting the CAD application. \n               		\n            </p> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_27225BECE21E4408BAF2192F33167147\"></a> \n            <h2><a name=\"GUID-7A3408BE-FCBC-4462-B527-8ABC995F8C1F\"></a>File Elements\n            </h2> \n            <p> The configuration files are in XML format. Use a text editor or an XML editor to\n               modify element values in the file. \n               		\n            </p> \n            <div><a name=\"GUID-4B838908-E681-4B06-86BA-8BCDA68DE5B6\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span> Most of the elements in the files are the same for Inventor and AutoCAD. However,\n                  some elements are only valid for either Inventor or AutoCAD. There are also small\n                  differences between some elements, depending on the file. \n                  		\n               </div>\n            </div> <a name=\"UL_F8BF26F8AB9D495A9E8E8E06D67C23E2\"></a><p class=\"list-intro\">PathDefinition</p>\n            <p> Defines where the file is saved. The definition can be a mix of plain text or variables.\n               The expression entered is evaluated every time the user enters or changes data. The\n               closing back-slash is not required. The supported variables are: \n               		\n            </p>\n            <ul>\n               <li><span class=\"code\">{Workspace}</span> \n                  <p>This will contain the path to your workspace as defined in the project file. \n                     		  \n                  </p> \n               </li>\n               <li><span class=\"code\">{Prop[&lt;property name&gt;].Value}</span> \n                  <p>This is the value of the file property and changes as soon as the user enters data\n                     into a Data Standard dialog field mapped to the property &lt;property name&gt;. \n                     		  \n                  </p> \n                  <p>Sample: \n                     		  \n                  </p> \n                  <p> \n                     <div class=\"codeBlock\"><pre class=\"prettyprint\">&lt;PathDefinition&gt;{Workspace}\\{Prop[PROJECT].Value}&lt;/PathDefinition&gt;</pre></div> \n                  </p> \n                  <p> In this sample, the path generated by Data Standard is the workspace folder set in\n                     the application plus the project name selected or entered into the Data Standard dialog.\n                     As the workspace will not change, this part is fixed, while the project path changes\n                     depending on the user data. \n                     		  \n                  </p> \n               </li>\n            </ul> <a name=\"UL_49FECA388BEC4435AEF780DDC4CD04B5\"></a><p class=\"list-intro\">FileNameDefinition</p>\n            <p> Defines how the file is named. The definition can be a mix of plain text or variables.\n               The expression is evaluated every time the user enters or changes data. The file extension\n               is omitted but is automatically attached by Data Standard. The supported variables\n               are: \n               		\n            </p>\n            <ul>\n               <li><span class=\"code\">{Prop[&lt;property name&gt;].Value}</span> \n                  <p> This is the value of the file property. The value changes as soon as the user enters\n                     data in a Data Standard dialog field mapped to the property \n                     			 <em class=\"mild\">&lt;property name&gt;</em>. \n                     		  \n                  </p> \n                  <p>Samples: \n                     		  \n                  </p> \n                  <p> \n                     <div class=\"codeBlock\"><pre class=\"prettyprint\">&lt;FileNameDefinition&gt;{Prop[TITLE].Value}&lt;/FileNameDefinition&gt;</pre></div> \n                  </p> \n                  <p>The file name is generated out of the value of the Title property. \n                     		  \n                  </p> \n                  <p> \n                     <div class=\"codeBlock\"><pre class=\"prettyprint\">&lt;FileNameDefinition&gt;{Prop[YEAR].Value}_{Prop[NUMBER].Value}&lt;/FileNameDefinition&gt;</pre></div> \n                  </p> \n                  <p> The file name is generated out of the combination of the Year and Number properties\n                     with an underscore in between. \n                     		  \n                  </p> \n               </li>\n            </ul> <a name=\"UL_B19444E9B8B047C8BFA1935DEA13499E\"></a><p class=\"list-intro\">PropertyDefinitions</p>\n            <p>Contains one or more \n               		  <span class=\"code\">&lt;PropertyDefinition&gt;</span> elements. The \n               		  <span class=\"code\">&lt;PropertyDefinition&gt;</span> is the core of this configuration file and lets you define one or more properties.\n               \n               		\n            </p>\n            <p><em class=\"strong\">IMPORTANT:</em> The PropertyDefinition is only required, if the (default) DynamicPropertyGrid control\n               in the dialog is not used, or to apply overrides to the constraints, for example to\n               set a property Required=True. Even Vault configuration (DynamicGrid) does not require\n               a value for this property. \n               		\n            </p>\n            <p>All the fields that will be accessible in the Data Standard dialog as a property must\n               be defined here. The name of the property is also the name of the file or title-block\n               attribute. If the property name matches an existing file property, such as \"Title\",\n               it is used directly. Otherwise a custom property is created. \n               		\n            </p>\n            <p>Sample: \n               		\n            </p>\n            <p> \n               <div class=\"codeBlock\"><pre class=\"prettyprint\">...\n&lt;PropertyDefinitions&gt;\n    &lt;PropertyDefinition PropertyName=\"DocNumber\" DataType=\"Text\" InitialValue=\"{PathAndFileNameHandler.FileName}\" InitialCopyValue=\"{UIString[CFG2]} {PathAndFileNameHandler.OriginalFileName}\" /&gt;\n    &lt;PropertyDefinition PropertyName=\"Title\" DataType=\"Text\" InitialCopyValue=\"{UIString[CFG1]} {Prop[Title].Value}\" RequiresValue=\"true\" /&gt;\n    &lt;PropertyDefinition PropertyName=\"Description\" DataType=\"Text\" /&gt;\n    &lt;PropertyDefinition PropertyName=\"Comments\" DataType=\"Text\" /&gt;   \n    &lt;PropertyDefinition PropertyName=\"Folder\" DataType=\"Text\" InitialValue=\".\" RequiresValue=\"true\"/&gt;\n    &lt;PropertyDefinition PropertyName=\"Original\" DataType=\"Text\" InitialCopyValue=\"{PathAndFileNameHandler.OriginalFullFileName}\" /&gt;\n&lt;/PropertyDefinitions&gt;\n...</pre></div> \n            </p>\n            <p>The available attributes for \n               		  <span class=\"code\">&lt;PropertyDefinition&gt;</span> are: \n               		\n            </p>\n            <p> <a name=\"TABLE_DA50E8E7A0424F1B9B3BF4C1690E6380\"></a><div class=\"table-not-ruled\">\n                  <table cellpadding=\"0\" cellspacing=\"0\" class=\"not-ruled\">\n                     <colgroup>\n                        <col>\n                        <col>\n                        <col>\n                        <col>\n                     </colgroup>\n                     <tr class=\"not-ruled-heading\">\n                        <th class=\"table-heading\"> \n                           <p class=\"table-heading\">Attribute \n                              					 \n                           </p> \n                        </th>\n                        <th class=\"table-heading\"> \n                           <p class=\"table-heading\">Required \n                              					 \n                           </p> \n                        </th>\n                        <th class=\"table-heading\"> \n                           <p class=\"table-heading\">Valid Values \n                              					 \n                           </p> \n                        </th>\n                        <th class=\"table-heading\"> \n                           <p class=\"table-heading\">Description \n                              					 \n                           </p> \n                        </th>\n                     </tr>\n                     <tr class=\"not-ruled-odd-row\">\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\"><span class=\"code\">PropertyName</span> \n                           </p> \n                        </td>\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">Yes \n                              					 \n                           </p> \n                        </td>\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">Characters and numbers \n                              					 \n                           </p> \n                        </td>\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">The name of the property. \n                              					 \n                           </p> \n                        </td>\n                     </tr>\n                     <tr class=\"not-ruled-even-row\">\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\"><span class=\"code\">DataType</span> \n                           </p> \n                        </td>\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">Yes \n                              					 \n                           </p> \n                        </td>\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">Text, Date, Boolean, Integer, Double \n                              					 \n                           </p> \n                        </td>\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">Defines the data type and is required to create custom properties. \n                              					 \n                           </p> \n                        </td>\n                     </tr>\n                     <tr class=\"not-ruled-odd-row\">\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\"><span class=\"code\">InitialValue</span> \n                           </p> \n                        </td>\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">No \n                              					 \n                           </p> \n                        </td>\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">Depending on DataType: \n                              					 \n                           </p> \n                           <p class=\"table-body\"><em class=\"strong\">Text</em>– A combination of text and variables (see below). \n                              					 \n                           </p> \n                           <p class=\"table-body\"><em class=\"strong\">Date</em>– Valid date or \"now\" for the current date. \n                              					 \n                           </p> \n                           <p class=\"table-body\"><em class=\"strong\">Boolean</em>–– \"true\" or \"false\" \n                              					 \n                           </p> \n                           <p class=\"table-body\"><em class=\"strong\">Integer, Double</em>– Valid numbers. \n                              					 \n                           </p> \n                        </td>\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">Defines the initial value when saving a document for the first time. \n                              					 \n                           </p> \n                        </td>\n                     </tr>\n                     <tr class=\"not-ruled-even-row\">\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\"><span class=\"code\">InitialCopyValue</span> \n                           </p> \n                           <div><a name=\"GUID-2E0455A7-9A14-4C81-BECD-ED111F6F3808\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span>Inventor Only \n                                 					 \n                              </div>\n                           </div> \n                        </td>\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">No \n                              					 \n                           </p> \n                        </td>\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">Depending on DataType: \n                              					 \n                           </p> \n                           <p class=\"table-body\"><em class=\"strong\">Text</em>– A combination of text and variables (see below). \n                              					 \n                           </p> \n                           <p class=\"table-body\"><em class=\"strong\">Date</em>– Valid date or \"now\" for the current date. \n                              					 \n                           </p> \n                           <p class=\"table-body\"><em class=\"strong\">Boolean</em>–– \"true\" or \"false\" \n                              					 \n                           </p> \n                           <p class=\"table-body\"><em class=\"strong\">Integer, Double</em>– Valid numbers. \n                              					 \n                           </p> \n                        </td>\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">Defines the initial value when copying a document. This attribute is for Inventor\n                              only. \n                              					 \n                           </p> \n                        </td>\n                     </tr>\n                     <tr class=\"not-ruled-odd-row\">\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\"><span class=\"code\">RequiresValue</span> \n                           </p> \n                        </td>\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">No \n                              					 \n                           </p> \n                        </td>\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">true, false, or the name of a PowerShell function \n                              					 \n                           </p> \n                        </td>\n                        <td class=\"table-body\"> \n                           <p class=\"table-body\">Used for validation. With a PowerShell function more complex validation rules can\n                              be implemented. \n                              					 \n                           </p> \n                        </td>\n                     </tr>\n                  </table>\n               </div> \n            </p>\n            <p>The attributes \n               		  <span class=\"code\">InitialValue</span> and \n               		  <span class=\"code\">InitialCopyValue</span> allow the combination of plain text and variables for text properties. The supported\n               variables are: \n               		<a name=\"UL_E8C5CE7D3EB243CDBC55F714AC3CC103\"></a><ul>\n                  <li><span class=\"code\">{PathAndFileNameHandler.&lt;field&gt;}</span> \n                     <p>Can be used to retrieve information about the internal filenames and locations of\n                        the document. Available fields are: \n                        			 <a name=\"UL_91DA22926C2541F495A153EBF76C63E0\"></a><ul>\n                           <li><span class=\"code\">FileName</span>: The filename of the document without the filepath. \n                              				\n                           </li>\n                           <li><span class=\"code\">FullFileName</span>: The full path of the document. \n                              				\n                           </li>\n                           <li><span class=\"code\">OriginalFileName</span>: \n                              				  <em class=\"strong\">Inventor only. \n                                 				  </em> Is available when copying documents and returns the filename of the original document\n                              without the filepath. \n                              				  \n                              <p>For example: \n                                 					 <span class=\"code\">{UIString[CFG2]} {PathAndFileNameHandler.OriginalFileName}</span> returns \"Copy_of_Part1.ipt.\" \n                                 				  \n                              </p> \n                           </li>\n                        </ul> \n                     </p> \n                  </li>\n                  <li><span class=\"code\">{Prop[&lt;property name&gt;].Value}</span> \n                     <p><em class=\"strong\">Inventor only.</em> Returns the value of the file property &lt;property name&gt;. \n                        			 \n                     </p> \n                  </li>\n                  <li><span class=\"code\">{UIString[&lt;ID&gt;]}</span> \n                     <p><em class=\"strong\">Inventor only. \n                           				</em> Returns the value of the localized text string from \n                        				<span class=\"filePath\">UIStrings.xml</span> specified by &lt;ID&gt;. See \n                        				<span class=\"char_link\"><a href=\"GUID-244DFF1D-7473-41D8-AA7D-43A3FB25D17F.htm\">Localization</a></span> for more details. \n                        			 \n                     </p> \n                  </li>\n               </ul> \n            </p> <a name=\"UL_04D6E2585B0A424D908AFE91C34A59B3\"></a><p class=\"list-intro\">ShowCheckinDialog</p>\n            <p>Set to True or False to indicate whether the Vault check-in dialog is displayed when\n               clicking OK on the Data Standard dialog for a document that is being saved for the\n               first time. \n               		\n            </p> <a name=\"UL_5D335BC09B4C4279A698879FDFC1FB9E\"></a><p class=\"list-intro\">SkipForProperties</p>\n            <p><em class=\"strong\">Inventor only. \n                  		  </em> This element is a comma-separated list of property names. The automatic Data Standard\n               dialog is not shown for documents that have a file property which is in this list.\n               One usage scenario is to skip the Data Standard dialog for third-party content center\n               parts (e.g., Content center-generated parts). \n               		\n            </p>\n            <p>Sample: \n               		\n            </p>\n            <p> \n               <div class=\"codeBlock\"><pre class=\"prettyprint\">&lt;SkipForProperties&gt;CDN_B&lt;/SkipForProperties&gt;</pre></div> \n            </p> <a name=\"UL_E0E321A7BCE44DF89DE1C197067ABB27\"></a><p class=\"list-intro\">SupportedFileTypes</p>\n            <p><em class=\"strong\">Inventor only.</em> Defines which document types are supported. For example if you do not want the Data\n               Standard dialog to display for Inventor DWG files, the element looks like this: \n               		\n            </p>\n            <p> \n               <div class=\"codeBlock\"><pre class=\"prettyprint\">&lt;SupportedFileTypes&gt;IDW,IAM,IPT,IPN&lt;/SupportedFileTypes&gt;</pre></div> \n            </p> <a name=\"UL_C67EAA9617C546239D80D815E953A7E5\"></a><p class=\"list-intro\">TitleBlock</p>\n            <p><em class=\"strong\">AutoCAD only. \n                  		  </em> This element is a comma-separated list of AutoCAD block names that are synchronized\n               with Data Standard. Three settings are required and one additional is recommended\n               to support legacy files.\n               		\n            </p>\n            <p>Sample: \n               		\n            </p>\n            <p> \n               <div class=\"codeBlock\"><pre class=\"prettyprint\">&lt;TitleBlock&gt;ISO_TITLEA,ISO_TITLEB,DIN_TITLE&lt;/TitleBlock&gt;</pre></div> \n            </p> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_A7FC2FC31E1F44B5B7FB7A841F3A00ED\"></a> \n            <h2><a name=\"GUID-7135CEA2-A2F5-4EC4-B509-CE6767C00A85\"></a>Property Mapping for AutoCAD\n            </h2> \n            <p>Data Standard uses AutoCAD file properties, so the primary mapping of UDPs has to\n               be configured to file properties.\n               		\n            </p> \n            <p>Data Standard allows to synchronize the property values to block attributes. To achieve\n               this, 3 settings are required and 1 additional recommended to support legacy files,\n               not having file properties, but only block attributes\n               		\n            </p> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_D1029F268884496A83C8AAFC49BE5ED3\"></a> \n            <h2><a name=\"GUID-EDF76B59-00A0-4883-93DF-F6C592038C3B\"></a>Property Mapping for Inventor\n            </h2> \n            <p> </p> \n         </div>\n         <div class=\"footer-block\"><a href=\"..\" class=\"comments-anchor\" target=\"_blank\"><span class=\"comments-link\">Please send us your comment about this page</span></a></div><br><p class=\"footer-license-block\"><a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\"><img alt=\"Creative Commons License\" style=\"border-width: 0;\" src=\"../images/ccLink.png\"></a>&nbsp;<em>Except where otherwise noted, this work is licensed under a <a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\">Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License</a>. Please see the <a href=\"http://autodesk.com/creativecommons\" target=\"_blank\">Autodesk Creative Commons FAQ</a> for more information.</em></p><br></div>\n   </body>\n</html>";
// SIG // Begin signature block
// SIG // MIIZfQYJKoZIhvcNAQcCoIIZbjCCGWoCAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // qHdJFjmtOHmst1TDMxyJ4unwJQxLEVG564MB4uVEvj2g
// SIG // ggoaMIIEyzCCA7OgAwIBAgIQCQja65wGHi65un4mqmKH
// SIG // ijANBgkqhkiG9w0BAQsFADCBhDELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTUw
// SIG // MwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
// SIG // b2RlIFNpZ25pbmcgQ0EgLSBHMjAeFw0xOTA1MTQwMDAw
// SIG // MDBaFw0yMDA1MTMyMzU5NTlaMHwxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIDApDYWxpZm9ybmlhMRMwEQYDVQQHDApT
// SIG // YW4gUmFmYWVsMRcwFQYDVQQKDA5BdXRvZGVzaywgSW5j
// SIG // LjERMA8GA1UECwwIU2VjdXJpdHkxFzAVBgNVBAMMDkF1
// SIG // dG9kZXNrLCBJbmMuMIIBIjANBgkqhkiG9w0BAQEFAAOC
// SIG // AQ8AMIIBCgKCAQEAkVKRoPYsoxPdlabspcuG8HYDfcWQ
// SIG // 9qyPOT2punwpVdjt2slktcpSTlydrGy8ijcbl5/k8AOJ
// SIG // afKMQvow0fNjIoNB5nsb8j2xFJPbBhHl8GT4P6DZ1OWK
// SIG // ioiUXgGHKjctUws49J4elntqvBYhKCbuPqG772QCoYFU
// SIG // P7qcFbh3PbyNB6cnKMn2vNGRqiEtV2aGg+/MiL3QPsvT
// SIG // kTWhVuTLIvwZ4kK5C5ACiQzlGOlE+C7gWuFoxtvy6gUa
// SIG // A8JAq/xLjYKwFevQwGncg3s1cuiGhx0P7Rvn6oCd2cem
// SIG // FmbK3I3rMRt+jc9wzAj3oHxvCo4f5Lfva+OpC1dETUVV
// SIG // sk0VGwIDAQABo4IBPjCCATowCQYDVR0TBAIwADAOBgNV
// SIG // HQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMw
// SIG // YQYDVR0gBFowWDBWBgZngQwBBAEwTDAjBggrBgEFBQcC
// SIG // ARYXaHR0cHM6Ly9kLnN5bWNiLmNvbS9jcHMwJQYIKwYB
// SIG // BQUHAgIwGQwXaHR0cHM6Ly9kLnN5bWNiLmNvbS9ycGEw
// SIG // HwYDVR0jBBgwFoAU1MAGIknrOUvdk+JcobhHdglyA1gw
// SIG // KwYDVR0fBCQwIjAgoB6gHIYaaHR0cDovL3JiLnN5bWNi
// SIG // LmNvbS9yYi5jcmwwVwYIKwYBBQUHAQEESzBJMB8GCCsG
// SIG // AQUFBzABhhNodHRwOi8vcmIuc3ltY2QuY29tMCYGCCsG
// SIG // AQUFBzAChhpodHRwOi8vcmIuc3ltY2IuY29tL3JiLmNy
// SIG // dDANBgkqhkiG9w0BAQsFAAOCAQEA0Q2+iVSEfT4xGq3A
// SIG // OADVb0rT5Z8E+PPb1x6hKknSzuaZKk/acDz9mdnFajaU
// SIG // WgIKiFJlsqJnuAM1w4lqKaEWsz3DoxvGIEwexj71Ud6a
// SIG // KlBJNcR9DdkXUZwMhbw9d78rjJAIX6tOwfSludZfdq8b
// SIG // YEkuIzQi9uYW9vHVPSCzhnUBKjwc9qTo9yBc7Fcn4FAT
// SIG // 90DzWM2hS9oc3p0pprYI2I/O4th90BEmwWkVqVgfaR0z
// SIG // VyIEmBbqB/IWLfjUBZJ/8sbkwWuWlYVRrfPxsj1e9qvb
// SIG // wE3Y28jWyGbqoUG39GhXk3uT8R8i3+T6M0c4rMfdifBC
// SIG // pceCaFTJzSye7LoeVzCCBUcwggQvoAMCAQICEHwbNTVK
// SIG // 59t050FfEWnKa6gwDQYJKoZIhvcNAQELBQAwgb0xCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjEfMB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29y
// SIG // azE6MDgGA1UECxMxKGMpIDIwMDggVmVyaVNpZ24sIElu
// SIG // Yy4gLSBGb3IgYXV0aG9yaXplZCB1c2Ugb25seTE4MDYG
// SIG // A1UEAxMvVmVyaVNpZ24gVW5pdmVyc2FsIFJvb3QgQ2Vy
// SIG // dGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMTQwNzIyMDAw
// SIG // MDAwWhcNMjQwNzIxMjM1OTU5WjCBhDELMAkGA1UEBhMC
// SIG // VVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9u
// SIG // MR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3Jr
// SIG // MTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1
// SIG // NiBDb2RlIFNpZ25pbmcgQ0EgLSBHMjCCASIwDQYJKoZI
// SIG // hvcNAQEBBQADggEPADCCAQoCggEBANeVQ9Tc32euOftS
// SIG // pLYmMQRw6beOWyq6N2k1lY+7wDDnhthzu9/r0XY/ilaO
// SIG // 6y1L8FcYTrGNpTPTC3Uj1Wp5J92j0/cOh2W13q0c8fU1
// SIG // tCJRryKhwV1LkH/AWU6rnXmpAtceSbE7TYf+wnirv+9S
// SIG // rpyvCNk55ZpRPmlfMBBOcWNsWOHwIDMbD3S+W8sS4duM
// SIG // xICUcrv2RZqewSUL+6McntimCXBx7MBHTI99w94Zzj7u
// SIG // BHKOF9P/8LIFMhlM07Acn/6leCBCcEGwJoxvAMg6ABFB
// SIG // ekGwp4qRBKCZePR3tPNgKuZsUAS3FGD/DVH0qIuE/iHa
// SIG // XF599Sl5T7BEdG9tcv8CAwEAAaOCAXgwggF0MC4GCCsG
// SIG // AQUFBwEBBCIwIDAeBggrBgEFBQcwAYYSaHR0cDovL3Mu
// SIG // c3ltY2QuY29tMBIGA1UdEwEB/wQIMAYBAf8CAQAwZgYD
// SIG // VR0gBF8wXTBbBgtghkgBhvhFAQcXAzBMMCMGCCsGAQUF
// SIG // BwIBFhdodHRwczovL2Quc3ltY2IuY29tL2NwczAlBggr
// SIG // BgEFBQcCAjAZGhdodHRwczovL2Quc3ltY2IuY29tL3Jw
// SIG // YTA2BgNVHR8ELzAtMCugKaAnhiVodHRwOi8vcy5zeW1j
// SIG // Yi5jb20vdW5pdmVyc2FsLXJvb3QuY3JsMBMGA1UdJQQM
// SIG // MAoGCCsGAQUFBwMDMA4GA1UdDwEB/wQEAwIBBjApBgNV
// SIG // HREEIjAgpB4wHDEaMBgGA1UEAxMRU3ltYW50ZWNQS0kt
// SIG // MS03MjQwHQYDVR0OBBYEFNTABiJJ6zlL3ZPiXKG4R3YJ
// SIG // cgNYMB8GA1UdIwQYMBaAFLZ3+mlIR59TEtXC6gcydgfR
// SIG // lwcZMA0GCSqGSIb3DQEBCwUAA4IBAQB/68qn6ot2Qus+
// SIG // jiBUMOO3udz6SD4Wxw9FlRDNJ4ajZvMC7XH4qsJVl5Fw
// SIG // g/lSflJpPMnx4JRGgBi7odSkVqbzHQCR1YbzSIfgy8Q0
// SIG // aCBetMv5Be2cr3BTJ7noPn5RoGlxi9xR7YA6JTKfRK9u
// SIG // QyjTIXW7l9iLi4z+qQRGBIX3FZxLEY3ELBf+1W5/muJW
// SIG // kvGWs60t+fTf2omZzrI4RMD3R3vKJbn6Kmgzm1By3qif
// SIG // 1M0sCzS9izB4QOCNjicbkG8avggVgV3rL+JR51EeyXgp
// SIG // 5x5lvzjvAUoBCSQOFsQUecFBNzTQPZFSlJ3haO8I8OJp
// SIG // nGdukAsak3HUJgLDwFojMYIOuzCCDrcCAQEwgZkwgYQx
// SIG // CzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRlYyBD
// SIG // b3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1
// SIG // c3QgTmV0d29yazE1MDMGA1UEAxMsU3ltYW50ZWMgQ2xh
// SIG // c3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENBIC0gRzIC
// SIG // EAkI2uucBh4uubp+Jqpih4owDQYJYIZIAWUDBAIBBQCg
// SIG // fDAQBgorBgEEAYI3AgEMMQIwADAZBgkqhkiG9w0BCQMx
// SIG // DAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4wDAYK
// SIG // KwYBBAGCNwIBFTAvBgkqhkiG9w0BCQQxIgQgrguEtgQe
// SIG // vWiVzqBQu7rXLACtBY+gbhVpMkfefM3z+CwwDQYJKoZI
// SIG // hvcNAQEBBQAEggEAdyssNxF+1gv9Emhq/7BL/+i+CYfp
// SIG // mGk4b4VfsUSsDGHJOrngBAuDlg5A5GU9d9/ZkaftUaDd
// SIG // 61HzV8b+hP2wwnbATt5dJHewANwcQY/r9xr25nLFmnpX
// SIG // cTKt3xcmsGqRjwbMLc/K36S9tujP+n58DMfVI74WvNrs
// SIG // 0yAtfJI1I0L39v9bk3M7Lip7/D8A7WDCOzduspWIOrUj
// SIG // uAplWaMSuUgo/AfPRLlAwTo0iJ0wP/iOYwZSvpqsSk8A
// SIG // 1q3G07tvENwjwhnaTuatB8FYi2OJec3uc5XYux4wDCKy
// SIG // Ne7QxhG/bvO8OfnJNEtJ0CEBF7J8QUVGeNsw7fwjuUTg
// SIG // WZoSDKGCDHQwggxwBgorBgEEAYI3AwMBMYIMYDCCDFwG
// SIG // CSqGSIb3DQEHAqCCDE0wggxJAgEDMQ8wDQYJYIZIAWUD
// SIG // BAIBBQAwga8GCyqGSIb3DQEJEAEEoIGfBIGcMIGZAgEB
// SIG // BgkrBgEEAaAyAgMwMTANBglghkgBZQMEAgEFAAQgIH2o
// SIG // Rodz1YR9dmpBe2XqXItvYTnV7514rp04P0U/DAsCFCwp
// SIG // 8wncaRzQaskveUb+ZZDhMy8/GA8yMDIwMDMyMzE0MDIz
// SIG // OFqgL6QtMCsxKTAnBgNVBAMMIEdsb2JhbFNpZ24gVFNB
// SIG // IGZvciBBZHZhbmNlZCAtIEcyoIII0zCCBLYwggOeoAMC
// SIG // AQICDAynz10HBySsieeaOjANBgkqhkiG9w0BAQsFADBb
// SIG // MQswCQYDVQQGEwJCRTEZMBcGA1UEChMQR2xvYmFsU2ln
// SIG // biBudi1zYTExMC8GA1UEAxMoR2xvYmFsU2lnbiBUaW1l
// SIG // c3RhbXBpbmcgQ0EgLSBTSEEyNTYgLSBHMjAeFw0xODAy
// SIG // MTkwMDAwMDBaFw0yOTAzMTgxMDAwMDBaMCsxKTAnBgNV
// SIG // BAMMIEdsb2JhbFNpZ24gVFNBIGZvciBBZHZhbmNlZCAt
// SIG // IEcyMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKC
// SIG // AQEAt8eSiijY85HLUA1d6ylEwYJZpcpkzr2DtVHllMxu
// SIG // gJoXbNz/YuY2Q14Bwgxkjcp3nvZdd0W5Xsgk60E3EWY3
// SIG // rMjNdJvMs+9M4n8bznO+yZadNR5891T3bOygEtaumZ1j
// SIG // xHhfWakuIvXDJ9iyW0VjJ5D/jLE9qbTzDsDxIGUGiZ0D
// SIG // HKOwUkGFNOu8y85U9hL+swGJSqb6VMUf+9McwOO/l+M/
// SIG // 0Bv5QMcb1esmfEMwx3DyeBGqhU6lDg0ASjoRd6PKIwGA
// SIG // nsiTVl1GzIrY0qoKhIWyiVvVMs5BexhOVMqr0VJeEtMk
// SIG // nlbzDI/dvZKOedVBicOjoOWR/MdnnYczznEycwIDAQAB
// SIG // o4IBqDCCAaQwDgYDVR0PAQH/BAQDAgeAMEwGA1UdIARF
// SIG // MEMwQQYJKwYBBAGgMgEeMDQwMgYIKwYBBQUHAgEWJmh0
// SIG // dHBzOi8vd3d3Lmdsb2JhbHNpZ24uY29tL3JlcG9zaXRv
// SIG // cnkvMAkGA1UdEwQCMAAwFgYDVR0lAQH/BAwwCgYIKwYB
// SIG // BQUHAwgwRgYDVR0fBD8wPTA7oDmgN4Y1aHR0cDovL2Ny
// SIG // bC5nbG9iYWxzaWduLmNvbS9ncy9nc3RpbWVzdGFtcGlu
// SIG // Z3NoYTJnMi5jcmwwgZgGCCsGAQUFBwEBBIGLMIGIMEgG
// SIG // CCsGAQUFBzAChjxodHRwOi8vc2VjdXJlLmdsb2JhbHNp
// SIG // Z24uY29tL2NhY2VydC9nc3RpbWVzdGFtcGluZ3NoYTJn
// SIG // Mi5jcnQwPAYIKwYBBQUHMAGGMGh0dHA6Ly9vY3NwMi5n
// SIG // bG9iYWxzaWduLmNvbS9nc3RpbWVzdGFtcGluZ3NoYTJn
// SIG // MjAdBgNVHQ4EFgQULW5u0Y3lA4Du52Ppp9naCzxXIj0w
// SIG // HwYDVR0jBBgwFoAUkiGnSpVdZLCbtB7mADdH5p1BK0ww
// SIG // DQYJKoZIhvcNAQELBQADggEBAI39HR+PiNNl+LVcRumn
// SIG // 07Y/SstDBcIHDcNeA4QjN6h6jJcj/yechH1h61xLVz6b
// SIG // 9ETbgFj3tmXejxIKX6eHdLfaFECHUeyfSkdV8BfoGD5x
// SIG // IDHmKCKrTvaunGvC50T7aA0gf1M/lBuhhoJOMhYQWj+J
// SIG // WMHQtNu2kPuNMumhS0ZQN7bDOukpJBKSWk4rubYKejaM
// SIG // l8DviXwz3jHhoZfk50WtYVL9WonTVH6KTVuJew6Wd9Hy
// SIG // PDgb2vmlYSBlArzFrdcMYhAoLN2246hhAKwIJqONhdBk
// SIG // yTaQHopSyYeNNaVdSJH8k6alZfHs+TrcpSyeBG1iM/7e
// SIG // +p/Fzq+V81Go8s4wggQVMIIC/aADAgECAgsEAAAAAAEx
// SIG // icZQBDANBgkqhkiG9w0BAQsFADBMMSAwHgYDVQQLExdH
// SIG // bG9iYWxTaWduIFJvb3QgQ0EgLSBSMzETMBEGA1UEChMK
// SIG // R2xvYmFsU2lnbjETMBEGA1UEAxMKR2xvYmFsU2lnbjAe
// SIG // Fw0xMTA4MDIxMDAwMDBaFw0yOTAzMjkxMDAwMDBaMFsx
// SIG // CzAJBgNVBAYTAkJFMRkwFwYDVQQKExBHbG9iYWxTaWdu
// SIG // IG52LXNhMTEwLwYDVQQDEyhHbG9iYWxTaWduIFRpbWVz
// SIG // dGFtcGluZyBDQSAtIFNIQTI1NiAtIEcyMIIBIjANBgkq
// SIG // hkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqpuOw6sRUSUB
// SIG // tpaU4k/YwQj2RiPZRcWVl1urGr/SbFfJMwYfoA/GPH5T
// SIG // SHq/nYeer+7DjEfhQuzj46FKbAwXxKbBuc1b8R5EiY7+
// SIG // C94hWBPuTcjFZwscsrPxNHaRossHbTfFoEcmAhWkkJGp
// SIG // eZ7X61edK3wi2BTX8QceeCI2a3d5r6/5f45O4bUIMf3q
// SIG // 7UtxYowj8QM5j0R5tnYDV56tLwhG3NKMvPSOdM7IaGlR
// SIG // dhGLD10kWxlUPSbMQI2CJxtZIH1Z9pOAjvgqOP1roEBl
// SIG // H1d2zFuOBE8sqNuEUBNPxtyLufjdaUyI65x7MCb8eli7
// SIG // WbwUcpKBV7d2ydiACoBuCQIDAQABo4HoMIHlMA4GA1Ud
// SIG // DwEB/wQEAwIBBjASBgNVHRMBAf8ECDAGAQH/AgEAMB0G
// SIG // A1UdDgQWBBSSIadKlV1ksJu0HuYAN0fmnUErTDBHBgNV
// SIG // HSAEQDA+MDwGBFUdIAAwNDAyBggrBgEFBQcCARYmaHR0
// SIG // cHM6Ly93d3cuZ2xvYmFsc2lnbi5jb20vcmVwb3NpdG9y
// SIG // eS8wNgYDVR0fBC8wLTAroCmgJ4YlaHR0cDovL2NybC5n
// SIG // bG9iYWxzaWduLm5ldC9yb290LXIzLmNybDAfBgNVHSME
// SIG // GDAWgBSP8Et/qC5FJK5NUPpjmove4t0bvDANBgkqhkiG
// SIG // 9w0BAQsFAAOCAQEABFaCSnzQzsm/NmbRvjWek2yX6AbO
// SIG // MRhZ+WxBX4AuwEIluBjH/NSxN8RooM8oagN0S2OXhXdh
// SIG // O9cv4/W9M6KSfREfnops7yyw9GKNNnPRFjbxvF7stICY
// SIG // ePzSdnno4SGU4B/EouGqZ9uznHPlQCLPOc7b5neVp7uy
// SIG // y/YZhp2fyNSYBbJxb051rvE9ZGo7Xk5GpipdCJLxo/Md
// SIG // dL9iDSOMXCo4ldLA1c3PiNofKLW6gWlkKrWmotVzr9xG
// SIG // 2wSukdduxZi61EfEVnSAR3hYjL7vK/3sbL/RlPe/UOB7
// SIG // 4JD9IBh4GCJdCC6MHKCX8x2ZfaOdkdMGRE4EbnocIOM2
// SIG // 8LZQuTGCAqgwggKkAgEBMGswWzELMAkGA1UEBhMCQkUx
// SIG // GTAXBgNVBAoTEEdsb2JhbFNpZ24gbnYtc2ExMTAvBgNV
// SIG // BAMTKEdsb2JhbFNpZ24gVGltZXN0YW1waW5nIENBIC0g
// SIG // U0hBMjU2IC0gRzICDAynz10HBySsieeaOjANBglghkgB
// SIG // ZQMEAgEFAKCCAQ4wGgYJKoZIhvcNAQkDMQ0GCyqGSIb3
// SIG // DQEJEAEEMBwGCSqGSIb3DQEJBTEPFw0yMDAzMjMxNDAy
// SIG // MzhaMC8GCSqGSIb3DQEJBDEiBCApPwyAWiN0WudZlohu
// SIG // XR29Ar9p4Ryc3Ys/4gIAiFgaGTCBoAYLKoZIhvcNAQkQ
// SIG // AgwxgZAwgY0wgYowgYcEFJsSBXrnKq/21jdytJ9qI28m
// SIG // Sc2pMG8wX6RdMFsxCzAJBgNVBAYTAkJFMRkwFwYDVQQK
// SIG // ExBHbG9iYWxTaWduIG52LXNhMTEwLwYDVQQDEyhHbG9i
// SIG // YWxTaWduIFRpbWVzdGFtcGluZyBDQSAtIFNIQTI1NiAt
// SIG // IEcyAgwMp89dBwckrInnmjowDQYJKoZIhvcNAQEBBQAE
// SIG // ggEAdUoQD3UZJ1kCHFMmZhvg1aNiiRzNgMjJKACm83AG
// SIG // ThDNwEhy+GnIbx0Q9NDJI50Zq59HyCr8qoOOVj72L94Q
// SIG // msA7GnNhiCeDtme6C4ZNhzHHH5DF3t5D0wiUkSsN4c2T
// SIG // sc1DL1Y41OsLuakMSEKeyS/M3/iFDSNNjznlPepDu3Dm
// SIG // IaOkt4JURSSVjqn3Cz16lGwm9LKwP5vzlfIuLITnOnCk
// SIG // lrABJ94UIEpVhxRbYzg9o/oiTmPi4NvxzCAdqxIh+XPv
// SIG // pC6wgBOCFTDRZQzM1VsmhYJxeNwhpOOjR0spU8l4qqcP
// SIG // I9ehfzB2VXdXU5HRInDmuRGEP33JGlx8to5ZOw==
// SIG // End signature block
