var topic = "<!DOCTYPE html>\r\n\n<!-- saved from url=(0024)http://docs.autodesk.com -->\r\n<html>\n   <head>\n      <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n      <meta name=\"product\" content=\"VAULT\">\n      <meta name=\"release\" content=\"2021\">\n      <meta name=\"book\" content=\"GeneralUser\">\n      <meta name=\"created\" content=\"2020-03-20\">\n      <meta name=\"topicid\" content=\"GUID-32319A9D-ADBD-429E-A41D-FEC2511F9798\">\n      <meta name=\"description\" content=\"Dynamic Properties allow you to show and edit properties that are assigned to a Vault category without the need to modify the XAML file.\">\n      <meta name=\"topic-type\" content=\"concept\">\n      <meta name=\"audience\" content=\"administrator\">\n      <meta name=\"experiencelevel\" content=\"general\">\n      <title>Dynamic Properties</title><script language=\"javascript\">var index = \'index.html\';</script><script type=\"text/javascript\" src=\"../scripts/prettify/prettify.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-yaml.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-xq.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-wiki.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-vhdl.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-vb.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-tex.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-sql.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-scala.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-proto.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-n.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-ml.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-lua.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-lisp.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-hs.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-go.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-css.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-clj.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-apollo.js\"></script></head>\n   <body height=\"100%\" onLoad=\"javascript:prettyPrint();\">\n      <div class=\"body_content\" id=\"body-content\" dir=\"ltr\"><a name=\"GUID-32319A9D-ADBD-429E-A41D-FEC2511F9798\"></a><div class=\"head\">\n            <h1>Dynamic Properties</h1>\n         </div>\n         <p class=\"blurb\"> Dynamic Properties allow you to show and edit properties that are assigned to a Vault\n            category without the need to modify the XAML file. \n            \n         </p>\n         <p> When adding new properties to a Vault category, these properties appear automatically\n            the next time the Data Standard dialog or tab is shown. \n            	 \n         </p>\n         <div class=\"section\"><a name=\"SECTION_12A796B99F9A4019A648DEFD3B498888\"></a> \n            <h2><a name=\"GUID-BE4F2299-EE39-403C-A009-53DF9575AD71\"></a>Use Dynamic Properties in Data Standard Dialogs and Tabs\n            </h2> \n            <p>The dynamic properties are represented by a XAML \n               		  <span class=\"code\">DataGrid</span> control that has two columns. The first column is read-only and shows the property\n               name. The second column is more complex because it has to display different controls\n               for different types (e.g., \n               		  <span class=\"code\">ComboBox</span> for properties with a predefined list of values, \n               		  <span class=\"code\">DataPicker</span> for properties of type date). \n               		\n            </p> <a name=\"UL_974688DAF1AF4F65A69E82C4F02EF510\"></a><p class=\"list-intro\">DataGrid Control</p>\n            <p> To add the Dynamic Properties control to dialog, the following lines are needed:\n               \n               		\n            </p>\n            <p> \n               <div class=\"codeBlock\"><pre class=\"prettyprint\">...\n                &lt;DataGrid x:Name=\"DSDynamicCategoryProperties\"\n                      AutoGenerateColumns=\"False\"\n                      HeadersVisibility=\"Column\"\n                      ItemsSource=\"{Binding DynamicProperties}\"\n                      ScrollViewer.CanContentScroll=\"False\"\n                      HorizontalGridLinesBrush=\"WhiteSmoke\"\n                      VerticalGridLinesBrush=\"WhiteSmoke\"&gt;\n                    &lt;DataGrid.Columns&gt;\n                        &lt;DataGridTextColumn Binding=\"{Binding Name}\"\n                                        SortDirection=\"Ascending\"\n                                        Width=\"140\"\n                                        IsReadOnly=\"True\" &gt;\n                            &lt;DataGridTextColumn.HeaderTemplate&gt;\n                                &lt;DataTemplate&gt;\n                                    &lt;TextBlock Text=\"{Binding DataContext.UIString[LBL64], RelativeSource={RelativeSource AncestorType=DataGrid}}\"/&gt;\n                                &lt;/DataTemplate&gt;\n                            &lt;/DataGridTextColumn.HeaderTemplate&gt;\n                        &lt;/DataGridTextColumn&gt;\n                        &lt;DataGridTemplateColumn CellStyle=\"{StaticResource DynamicDataGridCellStyle}\"\n                                            Width=\"*\" &gt;\n                            &lt;DataGridTemplateColumn.HeaderTemplate&gt;\n                                &lt;DataTemplate&gt;\n                                    &lt;TextBlock Text=\"{Binding DataContext.UIString[LBL65], RelativeSource={RelativeSource AncestorType=DataGrid}}\"/&gt;\n                                &lt;/DataTemplate&gt;\n                            &lt;/DataGridTemplateColumn.HeaderTemplate&gt;\n                        &lt;/DataGridTemplateColumn&gt;\n                    &lt;/DataGrid.Columns&gt;\n                &lt;/DataGrid&gt;\n...</pre></div> \n            </p>\n            <p>The second column uses a style \n               		  <span class=\"code\">(CellStyle=\"{StaticResourceDynamicDataGridCellStyle})</span> that also has to be added to the XAML file in the Resources section. This takes care\n               of all the different controls: \n               		\n            </p>\n            <p> \n               <div class=\"codeBlock\"><pre class=\"prettyprint\">...\n  &lt;Window.Resources&gt;\n        &lt;Style x:Key=\"DynamicDataGridCellStyle\" TargetType=\"{x:Type DataGridCell}\"&gt;\n            &lt;Setter Property=\"Template\"&gt;\n                &lt;Setter.Value&gt;\n                    &lt;ControlTemplate&gt;\n                        &lt;ComboBox ItemsSource=\"{Binding ListValues}\" Text=\"{WPF:ValidatedBinding Value}\" IsEditable=\"True\"&gt;&lt;/ComboBox&gt;\n                    &lt;/ControlTemplate&gt;\n                &lt;/Setter.Value&gt;\n            &lt;/Setter&gt;\n            &lt;Style.Triggers&gt;\n                &lt;Trigger Property=\"IsSelected\" Value=\"True\"&gt;\n                    &lt;Setter Property=\"Background\" Value=\"{DynamicResource {x:Static SystemColors.HighlightBrushKey}}\"/&gt;\n                    &lt;Setter Property=\"Foreground\" Value=\"{DynamicResource {x:Static SystemColors.HighlightTextBrushKey}}\"/&gt;\n                    &lt;Setter Property=\"BorderBrush\" Value=\"{DynamicResource {x:Static SystemColors.HighlightBrushKey}}\"/&gt;\n                &lt;/Trigger&gt;\n                &lt;Trigger Property=\"IsKeyboardFocusWithin\" Value=\"True\"&gt;\n                    &lt;Setter Property=\"BorderBrush\" Value=\"{DynamicResource {x:Static DataGrid.FocusBorderBrushKey}}\"/&gt;\n                &lt;/Trigger&gt;\n                &lt;DataTrigger Binding=\"{Binding ListValues.Count}\" Value=\"0\"&gt;\n                    &lt;Setter Property=\"Template\"&gt;\n                        &lt;Setter.Value&gt;\n                            &lt;ControlTemplate&gt;\n                                &lt;TextBox Text=\"{WPF:ValidatedBinding Value}\"&gt;&lt;/TextBox&gt;\n                            &lt;/ControlTemplate&gt;\n                        &lt;/Setter.Value&gt;\n                    &lt;/Setter&gt;\n                &lt;/DataTrigger&gt;\n                &lt;DataTrigger Binding=\"{Binding Typ}\" Value=\"DateTime\"&gt;\n                    &lt;Setter Property=\"Template\"&gt;\n                        &lt;Setter.Value&gt;\n                            &lt;ControlTemplate&gt;\n                                &lt;DatePicker SelectedDate=\"{WPF:ValidatedBinding Value, StringFormat=\'dd/MM/yyyy\'}\"/&gt;\n                            &lt;/ControlTemplate&gt;\n                        &lt;/Setter.Value&gt;\n                    &lt;/Setter&gt;\n                &lt;/DataTrigger&gt;\n                &lt;DataTrigger Binding=\"{Binding Typ}\" Value=\"Bool\"&gt;\n                    &lt;Setter Property=\"Template\"&gt;\n                        &lt;Setter.Value&gt;\n                            &lt;ControlTemplate&gt;\n                                &lt;ComboBox Text=\"{WPF:ValidatedBinding Value}\"&gt;\n                                    &lt;system:Boolean&gt;True&lt;/system:Boolean&gt;\n                                    &lt;system:Boolean&gt;False&lt;/system:Boolean&gt;\n                                &lt;/ComboBox&gt;\n                            &lt;/ControlTemplate&gt;\n                        &lt;/Setter.Value&gt;\n                    &lt;/Setter&gt;\n                &lt;/DataTrigger&gt;\n            &lt;/Style.Triggers&gt;\n        &lt;/Style&gt;\n...</pre></div> \n            </p> <a name=\"UL_E5CBBF17B5694BBEA70915C5CD56BF44\"></a><p class=\"list-intro\">XAML Binding \n               		  <span class=\"code\">DynamicProperties</span></p>\n            <p>Look at this line of code in the previous example: \n               		\n            </p>\n            <p><span class=\"code\"> ItemsSource=\"{Binding DynamicProperties}\"</span> \n            </p>\n            <p>This code gets a list of \n               		  <span class=\"code\">IProperty</span> elements that are assigned to the category. The \n               		  <span class=\"code\">IProperty</span> object has, among others, these members which can be used in bindings: \n               		\n            </p>\n            <ul>\n               <li><span class=\"code\">ListValues</span>–used for properties with a pre-defined list of values. \n                  		\n               </li>\n               <li><span class=\"code\">Name</span>–name of the property. The value is used for the first column. \n                  		\n               </li>\n               <li><span class=\"code\">Value</span>–to get and set the property value. \n                  		\n               </li>\n            </ul>\n            <div><a name=\"GUID-66613F6B-3162-4D05-B6A2-05B02B821CF2\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span>In Data Standard for Vault, \n                  		  <span class=\"code\">DynamicProperties</span> returns all properties assigned to a category. Whereas for CAD, only the mapped properties\n                  are returned. This is because Data Standard for CAD does not directly change Vault\n                  Properties. Changes are done through Vault mapping. \n                  		\n               </div>\n            </div> <a name=\"UL_4F905993CCF444559B7FFECC72103E37\"></a><p class=\"list-intro\">XAML Binding \n               		  <span class=\"code\">DynamicPropertiesCategory</span></p>\n            <p> In order that the \n               		  <span class=\"code\">DynamicProperties</span> binding returns something, a Vault category has to be specified first. In the default\n               implementation that comes with Data Standard, the \n               		  <span class=\"code\">DynamicPropertiesCategory</span> gets specified through a combo box: \n               		\n            </p>\n            <p> \n               <div class=\"codeBlock\"><pre class=\"prettyprint\">...\n&lt;ComboBox\n    Name=\"Categories\"\n    ItemsSource=\"{Binding PsList[GetCategories]}\"\n    SelectedIndex=\"0\"\n    DisplayMemberPath=\"Name\"\n    SelectedItem=\"{Binding DynamicPropertiesCategory}\"\n    Text=\"{Binding Prop[_Category].Value}\" Grid.Row=\"0\" Grid.Column=\"1\"\n    IsEnabled=\"{Binding IsNewEntryDialog}\"&gt;\n&lt;/ComboBox&gt;\n...</pre></div> \n            </p>\n            <p> The list of available Vault categories \n               		  <span class=\"code\">(ItemsSource=\"{Binding PsList[GetCategories]}\")</span> is returned by a PowerShell function \n               		  <span class=\"code\">GetCategories</span>. In the default implementation, this just returns all categories. If only certain\n               categories should be available (e.g., based on document type), this function has to\n               be adjusted. \n               		\n            </p>\n            <p> The selected category from the combo box sets the DynamicPropertiesCategory: \n               		\n            </p>\n            <p><span class=\"code\">(SelectedItem=\"{Binding DynamicPropertiesCategory}\")</span> \n            </p> \n            <p>Click \n               		  <span class=\"char_link\"><a href=\"GUID-244DFF1D-7473-41D8-AA7D-43A3FB25D17F.htm\">here</a></span> to learn more about Dynamic Property labels. \n               		\n            </p> \n         </div>\n         <div class=\"footer-block\"><a href=\"..\" class=\"comments-anchor\" target=\"_blank\"><span class=\"comments-link\">Please send us your comment about this page</span></a></div><br><p class=\"footer-license-block\"><a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\"><img alt=\"Creative Commons License\" style=\"border-width: 0;\" src=\"../images/ccLink.png\"></a>&nbsp;<em>Except where otherwise noted, this work is licensed under a <a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\">Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License</a>. Please see the <a href=\"http://autodesk.com/creativecommons\" target=\"_blank\">Autodesk Creative Commons FAQ</a> for more information.</em></p><br></div>\n   </body>\n</html>";
// SIG // Begin signature block
// SIG // MIIgdgYJKoZIhvcNAQcCoIIgZzCCIGMCAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // gc60/lMvA1z9zGVxXzFSrokH4cYiL1pqCUBnAi9B+uGg
// SIG // ggoaMIIEyzCCA7OgAwIBAgIQCQja65wGHi65un4mqmKH
// SIG // ijANBgkqhkiG9w0BAQsFADCBhDELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTUw
// SIG // MwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
// SIG // b2RlIFNpZ25pbmcgQ0EgLSBHMjAeFw0xOTA1MTQwMDAw
// SIG // MDBaFw0yMDA1MTMyMzU5NTlaMHwxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIDApDYWxpZm9ybmlhMRMwEQYDVQQHDApT
// SIG // YW4gUmFmYWVsMRcwFQYDVQQKDA5BdXRvZGVzaywgSW5j
// SIG // LjERMA8GA1UECwwIU2VjdXJpdHkxFzAVBgNVBAMMDkF1
// SIG // dG9kZXNrLCBJbmMuMIIBIjANBgkqhkiG9w0BAQEFAAOC
// SIG // AQ8AMIIBCgKCAQEAkVKRoPYsoxPdlabspcuG8HYDfcWQ
// SIG // 9qyPOT2punwpVdjt2slktcpSTlydrGy8ijcbl5/k8AOJ
// SIG // afKMQvow0fNjIoNB5nsb8j2xFJPbBhHl8GT4P6DZ1OWK
// SIG // ioiUXgGHKjctUws49J4elntqvBYhKCbuPqG772QCoYFU
// SIG // P7qcFbh3PbyNB6cnKMn2vNGRqiEtV2aGg+/MiL3QPsvT
// SIG // kTWhVuTLIvwZ4kK5C5ACiQzlGOlE+C7gWuFoxtvy6gUa
// SIG // A8JAq/xLjYKwFevQwGncg3s1cuiGhx0P7Rvn6oCd2cem
// SIG // FmbK3I3rMRt+jc9wzAj3oHxvCo4f5Lfva+OpC1dETUVV
// SIG // sk0VGwIDAQABo4IBPjCCATowCQYDVR0TBAIwADAOBgNV
// SIG // HQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMw
// SIG // YQYDVR0gBFowWDBWBgZngQwBBAEwTDAjBggrBgEFBQcC
// SIG // ARYXaHR0cHM6Ly9kLnN5bWNiLmNvbS9jcHMwJQYIKwYB
// SIG // BQUHAgIwGQwXaHR0cHM6Ly9kLnN5bWNiLmNvbS9ycGEw
// SIG // HwYDVR0jBBgwFoAU1MAGIknrOUvdk+JcobhHdglyA1gw
// SIG // KwYDVR0fBCQwIjAgoB6gHIYaaHR0cDovL3JiLnN5bWNi
// SIG // LmNvbS9yYi5jcmwwVwYIKwYBBQUHAQEESzBJMB8GCCsG
// SIG // AQUFBzABhhNodHRwOi8vcmIuc3ltY2QuY29tMCYGCCsG
// SIG // AQUFBzAChhpodHRwOi8vcmIuc3ltY2IuY29tL3JiLmNy
// SIG // dDANBgkqhkiG9w0BAQsFAAOCAQEA0Q2+iVSEfT4xGq3A
// SIG // OADVb0rT5Z8E+PPb1x6hKknSzuaZKk/acDz9mdnFajaU
// SIG // WgIKiFJlsqJnuAM1w4lqKaEWsz3DoxvGIEwexj71Ud6a
// SIG // KlBJNcR9DdkXUZwMhbw9d78rjJAIX6tOwfSludZfdq8b
// SIG // YEkuIzQi9uYW9vHVPSCzhnUBKjwc9qTo9yBc7Fcn4FAT
// SIG // 90DzWM2hS9oc3p0pprYI2I/O4th90BEmwWkVqVgfaR0z
// SIG // VyIEmBbqB/IWLfjUBZJ/8sbkwWuWlYVRrfPxsj1e9qvb
// SIG // wE3Y28jWyGbqoUG39GhXk3uT8R8i3+T6M0c4rMfdifBC
// SIG // pceCaFTJzSye7LoeVzCCBUcwggQvoAMCAQICEHwbNTVK
// SIG // 59t050FfEWnKa6gwDQYJKoZIhvcNAQELBQAwgb0xCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjEfMB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29y
// SIG // azE6MDgGA1UECxMxKGMpIDIwMDggVmVyaVNpZ24sIElu
// SIG // Yy4gLSBGb3IgYXV0aG9yaXplZCB1c2Ugb25seTE4MDYG
// SIG // A1UEAxMvVmVyaVNpZ24gVW5pdmVyc2FsIFJvb3QgQ2Vy
// SIG // dGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMTQwNzIyMDAw
// SIG // MDAwWhcNMjQwNzIxMjM1OTU5WjCBhDELMAkGA1UEBhMC
// SIG // VVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9u
// SIG // MR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3Jr
// SIG // MTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1
// SIG // NiBDb2RlIFNpZ25pbmcgQ0EgLSBHMjCCASIwDQYJKoZI
// SIG // hvcNAQEBBQADggEPADCCAQoCggEBANeVQ9Tc32euOftS
// SIG // pLYmMQRw6beOWyq6N2k1lY+7wDDnhthzu9/r0XY/ilaO
// SIG // 6y1L8FcYTrGNpTPTC3Uj1Wp5J92j0/cOh2W13q0c8fU1
// SIG // tCJRryKhwV1LkH/AWU6rnXmpAtceSbE7TYf+wnirv+9S
// SIG // rpyvCNk55ZpRPmlfMBBOcWNsWOHwIDMbD3S+W8sS4duM
// SIG // xICUcrv2RZqewSUL+6McntimCXBx7MBHTI99w94Zzj7u
// SIG // BHKOF9P/8LIFMhlM07Acn/6leCBCcEGwJoxvAMg6ABFB
// SIG // ekGwp4qRBKCZePR3tPNgKuZsUAS3FGD/DVH0qIuE/iHa
// SIG // XF599Sl5T7BEdG9tcv8CAwEAAaOCAXgwggF0MC4GCCsG
// SIG // AQUFBwEBBCIwIDAeBggrBgEFBQcwAYYSaHR0cDovL3Mu
// SIG // c3ltY2QuY29tMBIGA1UdEwEB/wQIMAYBAf8CAQAwZgYD
// SIG // VR0gBF8wXTBbBgtghkgBhvhFAQcXAzBMMCMGCCsGAQUF
// SIG // BwIBFhdodHRwczovL2Quc3ltY2IuY29tL2NwczAlBggr
// SIG // BgEFBQcCAjAZGhdodHRwczovL2Quc3ltY2IuY29tL3Jw
// SIG // YTA2BgNVHR8ELzAtMCugKaAnhiVodHRwOi8vcy5zeW1j
// SIG // Yi5jb20vdW5pdmVyc2FsLXJvb3QuY3JsMBMGA1UdJQQM
// SIG // MAoGCCsGAQUFBwMDMA4GA1UdDwEB/wQEAwIBBjApBgNV
// SIG // HREEIjAgpB4wHDEaMBgGA1UEAxMRU3ltYW50ZWNQS0kt
// SIG // MS03MjQwHQYDVR0OBBYEFNTABiJJ6zlL3ZPiXKG4R3YJ
// SIG // cgNYMB8GA1UdIwQYMBaAFLZ3+mlIR59TEtXC6gcydgfR
// SIG // lwcZMA0GCSqGSIb3DQEBCwUAA4IBAQB/68qn6ot2Qus+
// SIG // jiBUMOO3udz6SD4Wxw9FlRDNJ4ajZvMC7XH4qsJVl5Fw
// SIG // g/lSflJpPMnx4JRGgBi7odSkVqbzHQCR1YbzSIfgy8Q0
// SIG // aCBetMv5Be2cr3BTJ7noPn5RoGlxi9xR7YA6JTKfRK9u
// SIG // QyjTIXW7l9iLi4z+qQRGBIX3FZxLEY3ELBf+1W5/muJW
// SIG // kvGWs60t+fTf2omZzrI4RMD3R3vKJbn6Kmgzm1By3qif
// SIG // 1M0sCzS9izB4QOCNjicbkG8avggVgV3rL+JR51EeyXgp
// SIG // 5x5lvzjvAUoBCSQOFsQUecFBNzTQPZFSlJ3haO8I8OJp
// SIG // nGdukAsak3HUJgLDwFojMYIVtDCCFbACAQEwgZkwgYQx
// SIG // CzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRlYyBD
// SIG // b3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1
// SIG // c3QgTmV0d29yazE1MDMGA1UEAxMsU3ltYW50ZWMgQ2xh
// SIG // c3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENBIC0gRzIC
// SIG // EAkI2uucBh4uubp+Jqpih4owDQYJYIZIAWUDBAIBBQCg
// SIG // fDAQBgorBgEEAYI3AgEMMQIwADAZBgkqhkiG9w0BCQMx
// SIG // DAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4wDAYK
// SIG // KwYBBAGCNwIBFTAvBgkqhkiG9w0BCQQxIgQg1Cxr0NNq
// SIG // dQshzg5qwc9hubrVWvkLvp6bmnD3/5cR8AEwDQYJKoZI
// SIG // hvcNAQEBBQAEggEAEkK43BYOTaxx8iPPhCCS6YhwlYUX
// SIG // pjgWLC2H8nSletMTcT3fFUyfFRMvPlOIYrawFdLNsNat
// SIG // SE+paBvuHYkgCY/ZVRiE/Wm2AWq0TMHOjo+iDFzbrtfW
// SIG // k0WPDMtg7lxn/wcwHNrE5TP+b/ieCGm/yl8pyCvTrhsl
// SIG // DMz4GtPCjjZgTV83heawhBuNOjOh+Cbno1WJzEkSPxXA
// SIG // a5kskqmRCNKupeGIwSvtJGNXa2Iuh+MqiVDrq0g1qVXk
// SIG // 2lLUEK3T4pS60xelu8VrlcwWdPwzE7dSb+TY8vreOHYH
// SIG // uKNup8rrpB8UIoImYv+N1xoWlkkTotIxZWzu5CK27Tfp
// SIG // 72/0FaGCE20wghNpBgorBgEEAYI3AwMBMYITWTCCE1UG
// SIG // CSqGSIb3DQEHAqCCE0YwghNCAgEDMQ8wDQYJYIZIAWUD
// SIG // BAIBBQAwggEMBgsqhkiG9w0BCRABBKCB/ASB+TCB9gIB
// SIG // AQYKKwYBBAGyMQIBATAxMA0GCWCGSAFlAwQCAQUABCCJ
// SIG // c5GEhSmBmVDmQf6YvEvvqY52e0TeLfXjGWFwE0+o2gIU
// SIG // fEnee6F5VSglGDaSF359AuRxlSYYDzIwMjAwMzIzMTQw
// SIG // NTU4WqCBiqSBhzCBhDELMAkGA1UEBhMCR0IxGzAZBgNV
// SIG // BAgMEkdyZWF0ZXIgTWFuY2hlc3RlcjEQMA4GA1UEBwwH
// SIG // U2FsZm9yZDEYMBYGA1UECgwPU2VjdGlnbyBMaW1pdGVk
// SIG // MSwwKgYDVQQDDCNTZWN0aWdvIFJTQSBUaW1lIFN0YW1w
// SIG // aW5nIFNpZ25lciAjMaCCDfowggcGMIIE7qADAgECAhA9
// SIG // GjVyMBWCYzDQE3F+gkEIMA0GCSqGSIb3DQEBDAUAMH0x
// SIG // CzAJBgNVBAYTAkdCMRswGQYDVQQIExJHcmVhdGVyIE1h
// SIG // bmNoZXN0ZXIxEDAOBgNVBAcTB1NhbGZvcmQxGDAWBgNV
// SIG // BAoTD1NlY3RpZ28gTGltaXRlZDElMCMGA1UEAxMcU2Vj
// SIG // dGlnbyBSU0EgVGltZSBTdGFtcGluZyBDQTAeFw0xOTA1
// SIG // MDIwMDAwMDBaFw0zMDA4MDEyMzU5NTlaMIGEMQswCQYD
// SIG // VQQGEwJHQjEbMBkGA1UECAwSR3JlYXRlciBNYW5jaGVz
// SIG // dGVyMRAwDgYDVQQHDAdTYWxmb3JkMRgwFgYDVQQKDA9T
// SIG // ZWN0aWdvIExpbWl0ZWQxLDAqBgNVBAMMI1NlY3RpZ28g
// SIG // UlNBIFRpbWUgU3RhbXBpbmcgU2lnbmVyICMxMIICIjAN
// SIG // BgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAy1FQ/1b+
// SIG // /HhjcAGTWp4Y9DtT9gevIWz1og99HXAthHRIi5yKlQU9
// SIG // WYT5kYB5USzZirfBC5q6CorNZk8DiwG7MMqrvdvATxJe
// SIG // /ArM4kWwATiKu03n1BxUmO05WM9bwi9FmDEK+TU4uDEu
// SIG // bbQeOXLhuCq+n4yMGqVGrgsrTJn+LEv8KLkiOmYX0KpW
// SIG // iiHA85YktNCFJmu68G9kmHmmrb1c2FNrKwrWcoqFRuMN
// SIG // GAbaxntBVjabFT7xahGg92b1GNCAVWOHaGbrDnlVglyj
// SIG // 7Um4cYaekzewa6PqYmyjrpbouf2Lq8b2WVsAPFcgGC1w
// SIG // A6ec75LreaHHXex8tI9L3+td/KMg3ZI45WpROmuFnEyg
// SIG // mAhpWwbnKhnQlZOLO2uKBQkp2Nba2+Ny+lxKL3sVVoYy
// SIG // v38FCZ0tKs9Q4eZhINvHBoBcThRGvq5XcaKqbDCTHH53
// SIG // ywbpV82R9dUzchzh2spu6/MP7Hlbuyee6B7+L/K7f+nl
// SIG // 0GfruA18pCtZA4uV7SIozfosO8cWEa/j1rFQZ2nFjvV5
// SIG // 0K3/h8z4f6r5ou1h+MiNadqx9FGR62dX0WQR62TLA71J
// SIG // VTpFQxgsJWzRLwwtb/VBNSSg8mNZFl/ZpOksTtu7MRLG
// SIG // bfhbbgPcyxWPG41y7NsPFZDWEk7u4gAxJZM1b2pbpRJj
// SIG // QAGKuWmIOoi4DxkCAwEAAaOCAXgwggF0MB8GA1UdIwQY
// SIG // MBaAFBqh+GEZIA/DQXdFKI7RNV8GEgRVMB0GA1UdDgQW
// SIG // BBRvTYYH2DInniwp0tATA4CB3QWDKTAOBgNVHQ8BAf8E
// SIG // BAMCBsAwDAYDVR0TAQH/BAIwADAWBgNVHSUBAf8EDDAK
// SIG // BggrBgEFBQcDCDBABgNVHSAEOTA3MDUGDCsGAQQBsjEB
// SIG // AgEDCDAlMCMGCCsGAQUFBwIBFhdodHRwczovL3NlY3Rp
// SIG // Z28uY29tL0NQUzBEBgNVHR8EPTA7MDmgN6A1hjNodHRw
// SIG // Oi8vY3JsLnNlY3RpZ28uY29tL1NlY3RpZ29SU0FUaW1l
// SIG // U3RhbXBpbmdDQS5jcmwwdAYIKwYBBQUHAQEEaDBmMD8G
// SIG // CCsGAQUFBzAChjNodHRwOi8vY3J0LnNlY3RpZ28uY29t
// SIG // L1NlY3RpZ29SU0FUaW1lU3RhbXBpbmdDQS5jcnQwIwYI
// SIG // KwYBBQUHMAGGF2h0dHA6Ly9vY3NwLnNlY3RpZ28uY29t
// SIG // MA0GCSqGSIb3DQEBDAUAA4ICAQDAaO2z2NRQm+/TdcsP
// SIG // O/ck03o3RY0s7xb7UaksH7UltYqfXQvCGyB0jWYPNsuq
// SIG // 9jYND36PS0p0Q2WsDSr2Cu1rbcUJOO0AG/jl3KYKQAVH
// SIG // 74TKCbxDZoO/n+3bjj3RQWSxcAItA1dbGG8cLMsesgDo
// SIG // ugkvW4EENbmpY22OCMUY0eEhrPkSChTAEtt+JZ2sHRDA
// SIG // WqWD0h8aZlX8myri7DdXjuXfljD4wJMLQxj5Am+pUa+4
// SIG // VwrzHAdpOY83nG3Xka6lLknpSt6z0Iy/OZANwIHO8CoH
// SIG // OgymLVHScvNTxvm97+8MaUl3nyxWxOmhCD0HrsUe1oQi
// SIG // x7x9QxtYOGJO0QUlhMVC+B8v9tv6q4xU7EWKbBJNMFpS
// SIG // 5aQXCSLm72/1X4ZD36EtvUpGkqCBlixhl39Ab9g/jDVa
// SIG // q9HGoDuFZlSA7x8a9fGbsKEnfbLnC8/2LZxYE5SphvxF
// SIG // UqIobX90D1KRSXrpEvipO7CS/X2RFOlbbUiU8siW7gU4
// SIG // s8XsMD/hByAEsdiLvP2zPm/yAlMG9KDtyZpyo5dfAPvL
// SIG // Y9DozXT9dcnUNkW6exJZcu3n8npQAHj4Q5pG2N+/VNRe
// SIG // scfRvBuD9CvnC+hHyFOezBqs9vqKdVNsIIWp1bhquiSO
// SIG // iisIkZ83BBz2b6LdNKqR/8YVLh5CGgkpT/TGzeKRotNA
// SIG // DI544zCCBuwwggTUoAMCAQICEDAPb6zdZph0fKlGNqd4
// SIG // LbkwDQYJKoZIhvcNAQEMBQAwgYgxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIEwpOZXcgSmVyc2V5MRQwEgYDVQQHEwtK
// SIG // ZXJzZXkgQ2l0eTEeMBwGA1UEChMVVGhlIFVTRVJUUlVT
// SIG // VCBOZXR3b3JrMS4wLAYDVQQDEyVVU0VSVHJ1c3QgUlNB
// SIG // IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTE5MDUw
// SIG // MjAwMDAwMFoXDTM4MDExODIzNTk1OVowfTELMAkGA1UE
// SIG // BhMCR0IxGzAZBgNVBAgTEkdyZWF0ZXIgTWFuY2hlc3Rl
// SIG // cjEQMA4GA1UEBxMHU2FsZm9yZDEYMBYGA1UEChMPU2Vj
// SIG // dGlnbyBMaW1pdGVkMSUwIwYDVQQDExxTZWN0aWdvIFJT
// SIG // QSBUaW1lIFN0YW1waW5nIENBMIICIjANBgkqhkiG9w0B
// SIG // AQEFAAOCAg8AMIICCgKCAgEAyBsBr9ksfoiZfQGYPyCQ
// SIG // vZyAIVSTuc+gPlPvs1rAdtYaBKXOR4O168TMSTTL80Vl
// SIG // ufmnZBYmCfvVMlJ5LsljwhObtoY/AQWSZm8hq9VxEHmH
// SIG // 9EYqzcRaydvXXUlNclYP3MnjU5g6Kh78zlhJ07/zObu5
// SIG // pCNCrNAVw3+eolzXOPEWsnDTo8Tfs8VyrC4Kd/wNlFK3
// SIG // /B+VcyQ9ASi8Dw1Ps5EBjm6dJ3VV0Rc7NCF7lwGUr3+A
// SIG // z9ERCleEyX9W4L1GnIK+lJ2/tCCwYH64TfUNP9vQ6oWM
// SIG // ilZx0S2UTMiMPNMUopy9Jv/TUyDHYGmbWApU9AXn/TGs
// SIG // +ciFF8e4KRmkKS9G493bkV+fPzY+DjBnK0a3Na+WvtpM
// SIG // YMyou58NFNQYxDCYdIIhz2JWtSFzEh79qsoIWId3pBXr
// SIG // GVX/0DlULSbuRRo6b83XhPDX8CjFT2SDAtT74t7xvAIo
// SIG // 9G3aJ4oG0paH3uhrDvBbfel2aZMgHEqXLHcZK5OVmJyX
// SIG // nuuOwXhWxkQl3wYSmgYtnwNe/YOiU2fKsfqNoWTJiJJZ
// SIG // y6hGwMnypv99V9sSdvqKQSTUG/xypRSi1K1DHKRJi0E5
// SIG // FAMeKfobpSKupcNNgtCN2mu32/cYQFdz8HGj+0p9RTbB
// SIG // 942C+rnJDVOAffq2OVgy728YUInXT50zvRq1naHelUF6
// SIG // p4MCAwEAAaOCAVowggFWMB8GA1UdIwQYMBaAFFN5v1qq
// SIG // K0rPVIDh2JvAnfKyA2bLMB0GA1UdDgQWBBQaofhhGSAP
// SIG // w0F3RSiO0TVfBhIEVTAOBgNVHQ8BAf8EBAMCAYYwEgYD
// SIG // VR0TAQH/BAgwBgEB/wIBADATBgNVHSUEDDAKBggrBgEF
// SIG // BQcDCDARBgNVHSAECjAIMAYGBFUdIAAwUAYDVR0fBEkw
// SIG // RzBFoEOgQYY/aHR0cDovL2NybC51c2VydHJ1c3QuY29t
// SIG // L1VTRVJUcnVzdFJTQUNlcnRpZmljYXRpb25BdXRob3Jp
// SIG // dHkuY3JsMHYGCCsGAQUFBwEBBGowaDA/BggrBgEFBQcw
// SIG // AoYzaHR0cDovL2NydC51c2VydHJ1c3QuY29tL1VTRVJU
// SIG // cnVzdFJTQUFkZFRydXN0Q0EuY3J0MCUGCCsGAQUFBzAB
// SIG // hhlodHRwOi8vb2NzcC51c2VydHJ1c3QuY29tMA0GCSqG
// SIG // SIb3DQEBDAUAA4ICAQBtVIGlM10W4bVTgZF13wN6Mgst
// SIG // JYQRsrDbKn0qBfW8Oyf0WqC5SVmQKWxhy7VQ2+J9+Z8A
// SIG // 70DDrdPi5Fb5WEHP8ULlEH3/sHQfj8ZcCfkzXuqgHCZY
// SIG // XPO0EQ/V1cPivNVYeL9IduFEZ22PsEMQD43k+ThivxMB
// SIG // xYWjTMXMslMwlaTW9JZWCLjNXH8Blr5yUmo7Qjd8Fng5
// SIG // k5OUm7Hcsm1BbWfNyW+QPX9FcsEbI9bCVYRm5LPFZgb2
// SIG // 89ZLXq2jK0KKIZL+qG9aJXBigXNjXqC72NzXStM9r4MG
// SIG // OBIdJIct5PwC1j53BLwENrXnd8ucLo0jGLmjwkcd8F3W
// SIG // oXNXBWiap8k3ZR2+6rzYQoNDBaWLpgn/0aGUpk6qPQn1
// SIG // BWy30mRa2Coiwkud8TleTN5IPZs0lpoJX47997FSkc4/
// SIG // ifYcobWpdR9xv1tDXWU9UIFuq/DQ0/yysx+2mZYm9Dx5
// SIG // i1xkzM3uJ5rloMAMcofBbk1a0x7q8ETmMm8c6xdOlMN4
// SIG // ZSA7D0GqH+mhQZ3+sbigZSo04N6o+TzmwTC7wKBjLPxc
// SIG // FgCo0MR/6hGdHgbGpm0yXbQ4CStJB6r97DDa8acvz7f9
// SIG // +tCjhNknnvsBZne5VhDhIG7GrrH5trrINV0zdo7xfCAM
// SIG // KneutaIChrop7rRaALGMq+P5CslUXdS5anSevUiumDGC
// SIG // BBwwggQYAgEBMIGRMH0xCzAJBgNVBAYTAkdCMRswGQYD
// SIG // VQQIExJHcmVhdGVyIE1hbmNoZXN0ZXIxEDAOBgNVBAcT
// SIG // B1NhbGZvcmQxGDAWBgNVBAoTD1NlY3RpZ28gTGltaXRl
// SIG // ZDElMCMGA1UEAxMcU2VjdGlnbyBSU0EgVGltZSBTdGFt
// SIG // cGluZyBDQQIQPRo1cjAVgmMw0BNxfoJBCDANBglghkgB
// SIG // ZQMEAgEFAKCCAVswGgYJKoZIhvcNAQkDMQ0GCyqGSIb3
// SIG // DQEJEAEEMBwGCSqGSIb3DQEJBTEPFw0yMDAzMjMxNDA1
// SIG // NThaMC8GCSqGSIb3DQEJBDEiBCAVjBzjVG9fmHOtwMhf
// SIG // PMKhnCqbtQMcBNv2j83FuBIUEzCB7QYLKoZIhvcNAQkQ
// SIG // Agwxgd0wgdowgdcwFgQUJcisc05IULf42RORqBuSSTZl
// SIG // n2EwgbwEFALWW5Xig3DBVwCV+oj5I92Tf62PMIGjMIGO
// SIG // pIGLMIGIMQswCQYDVQQGEwJVUzETMBEGA1UECBMKTmV3
// SIG // IEplcnNleTEUMBIGA1UEBxMLSmVyc2V5IENpdHkxHjAc
// SIG // BgNVBAoTFVRoZSBVU0VSVFJVU1QgTmV0d29yazEuMCwG
// SIG // A1UEAxMlVVNFUlRydXN0IFJTQSBDZXJ0aWZpY2F0aW9u
// SIG // IEF1dGhvcml0eQIQMA9vrN1mmHR8qUY2p3gtuTANBgkq
// SIG // hkiG9w0BAQEFAASCAgAx2N5tlXTc0A+VLT6iJgMmLMwH
// SIG // 1j8s+1QyExcfr/tClhD6aoegKmruzmvuWjmhMHM8PEYa
// SIG // 1Zc2Ss5Y0kG1qzYWqKTuVDp1Xlc7mawBqXVxiqAATnuS
// SIG // m3F7X7y+AN65vuz+i/mNXk7NLRSjmzPtM3/all3gjGPB
// SIG // vepBnlW3xQokrdorjm9vE2EJyRaXun+SCBhRIVDhZ/qn
// SIG // g9YUPAP2PJbNTOR1xaYdfBy4ADKHWeXrEee6Y2DWxh/l
// SIG // NDA6RL6a5X5X/2jgycIOampHsc0FYy/nwDURUaJzSBpk
// SIG // 4BRMjUq+t5LgBEVLn4taniduetSwdtsU7xi6MyVT4kuJ
// SIG // hXS2cdGLlwxsZgQp6ohT65DUYy1Dgqi0zBNjDTKHJKGp
// SIG // MFwxDMt1BcQKk83MTO0Sb4O7w/4uLxor8ePbGtirINNu
// SIG // WBWm203SsO/aZ9agJY3+Nk+Lnk+dgM06WvS0ILTiYAIX
// SIG // 3NAve8B7EH/D0J+HJ2aCJ0KDRcP+fIQbHvAGO4v6HeuO
// SIG // rw3ctEPDufINSH0g+yfd1x5DI8M8SoEa/JcZu/CodhM4
// SIG // ok1IMRSfOJxmihPl6TiwcsDyPnIYKCG7jbUW8Cm3JARQ
// SIG // j1JH4QQfz3AhRXR1KynPEH5sKAPtgTdRKSCGHsz46Eb6
// SIG // eZnPm2odGroPuje0hfwkfuLBvRJumyHcsprh4v6B/A==
// SIG // End signature block
