var topic = "<!DOCTYPE html>\r\n\n<!-- saved from url=(0024)http://docs.autodesk.com -->\r\n<html>\n   <head>\n      <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n      <meta name=\"product\" content=\"VAULT\">\n      <meta name=\"release\" content=\"2021\">\n      <meta name=\"book\" content=\"GeneralUser\">\n      <meta name=\"created\" content=\"2020-03-20\">\n      <meta name=\"topicid\" content=\"GUID-26645DD0-AC27-4CFB-BC15-41719B5DE609\">\n      <meta name=\"description\" content=\"Property Administration includes tasks to create and manage property definitions. You must have administrative access to perform these tasks.\">\n      <meta name=\"contextid\" content=\"ID_PROPERTIES_ADMINISTRATION_VE\">\n      <meta name=\"topic-type\" content=\"concept\">\n      <meta name=\"audience\" content=\"administrator\">\n      <meta name=\"experiencelevel\" content=\"general\">\n      <title>Properties Administration</title><script language=\"javascript\">var index = \'index.html\';</script></head>\n   <body height=\"100%\">\n      <div class=\"body_content\" id=\"body-content\" dir=\"ltr\"><a name=\"GUID-26645DD0-AC27-4CFB-BC15-41719B5DE609\"></a><div class=\"head\">\n            <h1>Properties Administration</h1>\n         </div>\n         <p class=\"blurb\">Property Administration includes tasks to create and manage property definitions.\n            You must have administrative access to perform these tasks. \n            <!--CPM-ContextId = \'ID_PROPERTIES_ADMINISTRATION_VE\'--><a name=\"GUID-3A524428-B8B8-4377-B5E0-048B89C6B7CA\"></a> \n         </p>\n         <p><a name=\"GUID-0C07A0DE-E7B7-4F2B-87B1-625F7A9E5B44\"></a>Properties are attributes associated with a file. Vault recognizes two types of property\n            definitions: system-defined properties and user-defined properties (UDPs). System-defined\n            properties are those that are derived from the vault. The vault has a global set of\n            properties that are applied to files in the vault. User-defined properties are created\n            by using the administrative tools. \n            \n         </p>\n         <p><a name=\"GUID-1E5737CE-2372-4B2F-9000-5FD579E157FC\"></a>Before working with properties, it is important to become familiar with the terms,\n            data types, and attributes associated with the Vault properties system. \n            \n         </p>\n         <div class=\"section\"><a name=\"SECTION_AA192CD8FA5A405DB120A4EACA7132A0\"></a> \n            <h2><a name=\"GUID-D00DC4A1-F7CD-4BA2-827C-259B54D46997\"></a>Common Terms\n            </h2> \n            <p><a name=\"GUID-E5469366-1BAE-4C37-ADB7-AD4BA0E2F3EA\"></a>The following table contains terms commonly used with properties. \n               \n            </p> <a name=\"TABLE_1B57F0C80E01437B8CF799F3B37FBEBD\"></a><div class=\"table-not-ruled\">\n               <table cellpadding=\"0\" cellspacing=\"0\" class=\"not-ruled\">\n                  <colgroup>\n                     <col>\n                     <col>\n                  </colgroup>\n                  <tr class=\"not-ruled-heading\">\n                     <th class=\"table-heading\">Term \n                        			 \n                     </th>\n                     <th class=\"table-heading\">Definition \n                        			 \n                     </th>\n                  </tr>\n                  <tr class=\"not-ruled-odd-row\">\n                     <td class=\"table-body\">Associations \n                        			 \n                     </td>\n                     <td class=\"table-body\">Attribute that determines for which entities classes the property is available. \n                        			 \n                     </td>\n                  </tr>\n                  <tr class=\"not-ruled-even-row\">\n                     <td class=\"table-body\">Compliant \n                        			 \n                     </td>\n                     <td class=\"table-body\">The status of a property that meets all property policies and equivalence evaluations.\n                        \n                        			 \n                     </td>\n                  </tr>\n                  <tr class=\"not-ruled-odd-row\">\n                     <td class=\"table-body\">Data Type \n                        			 \n                     </td>\n                     <td class=\"table-body\">The type of data accepted for the property value. This type can be text, number, boolean,\n                        or date. \n                        			 \n                     </td>\n                  </tr>\n                  <tr class=\"not-ruled-even-row\">\n                     <td class=\"table-body\">Database Property \n                        			 \n                     </td>\n                     <td class=\"table-body\">Any property in the database, either user defined or system. \n                        			 \n                     </td>\n                  </tr>\n                  <tr class=\"not-ruled-odd-row\">\n                     <td class=\"table-body\">Entity \n                        			 \n                     </td>\n                     <td class=\"table-body\">An entity is the system class with which a file can be associated. Entities are files,\n                        folders, items, or change orders. \n                        			 \n                     </td>\n                  </tr>\n                  <tr class=\"not-ruled-even-row\">\n                     <td class=\"table-body\">Equivalent \n                        			 \n                     </td>\n                     <td class=\"table-body\">The status of a mapped property when its value matches the source value. \n                        			 \n                     </td>\n                  </tr>\n                  <tr class=\"not-ruled-odd-row\">\n                     <td class=\"table-body\">File Property \n                        			 \n                     </td>\n                     <td class=\"table-body\">A property associated with a file. \n                        			 \n                     </td>\n                  </tr>\n                  <tr class=\"not-ruled-even-row\">\n                     <td class=\"table-body\">Mapped Property \n                        			 \n                     </td>\n                     <td class=\"table-body\">A property from which the propriety being defined gets its value. For example, a UDP\n                        can get its value from several different file properties. A file property can get\n                        its value from a system property. \n                        			 \n                     </td>\n                  </tr>\n                  <tr class=\"not-ruled-odd-row\">\n                     <td class=\"table-body\">Mapping \n                        			 \n                     </td>\n                     <td class=\"table-body\">A set of relationships between the property being defined and a property from which\n                        it receives its value. There can be multiple mappings for a given property definition.\n                        \n                        			 \n                     </td>\n                  </tr>\n                  <tr class=\"not-ruled-even-row\">\n                     <td class=\"table-body\">Master \n                        			 \n                     </td>\n                     <td class=\"table-body\">The property from which a mapped property gets its value. The master property writes\n                        its value to the subordinate property. \n                        			 \n                     </td>\n                  </tr>\n                  <tr class=\"not-ruled-odd-row\">\n                     <td class=\"table-body\">Non-compliant \n                        			 \n                     </td>\n                     <td class=\"table-body\">The status of a property when it has failed to meet one or more property policies\n                        or its equivalence evaluation. \n                        			 \n                     </td>\n                  </tr>\n                  <tr class=\"not-ruled-even-row\">\n                     <td class=\"table-body\">Non-equivalent \n                        			 \n                     </td>\n                     <td class=\"table-body\">The status of a mapped property when its value does not match the source value. \n                        			 \n                     </td>\n                  </tr>\n                  <tr class=\"not-ruled-odd-row\">\n                     <td class=\"table-body\">Property Definition \n                        			 \n                     </td>\n                     <td class=\"table-body\">All attributes and constraints about the property including its name, data type, initial\n                        value, mapping, minimum and maximum values, case values, in-use value, and basic search\n                        value. \n                        			 \n                     </td>\n                  </tr>\n                  <tr class=\"not-ruled-even-row\">\n                     <td class=\"table-body\">Property Name \n                        			 \n                     </td>\n                     <td class=\"table-body\">The name used in the GUI (graphical user interface) to identify the property. \n                        			 \n                     </td>\n                  </tr>\n                  <tr class=\"not-ruled-odd-row\">\n                     <td class=\"table-body\">Property Policy \n                        			 \n                     </td>\n                     <td class=\"table-body\">Depending on the data type, the property policy specifies certain constraints that\n                        must be met. The constraints may include a value range, a value type, or a value format\n                        must be met. For example, a property policy might be described as follows: the property\n                        must have a value and that value must be in the range of 1 to 10. \n                        				<a name=\"GUID-C0088635-9E1D-4C29-80C3-4F566AE0681D\"></a><p class=\"table-body\">When a property fails to meet its property policies, it is considered non-compliant.\n                           \n                           				\n                        </p> \n                     </td>\n                  </tr>\n                  <tr class=\"not-ruled-even-row\">\n                     <td class=\"table-body\">Property Value \n                        			 \n                     </td>\n                     <td class=\"table-body\">The literal content of a property attribute for a specific file version. \n                        			 \n                     </td>\n                  </tr>\n                  <tr class=\"not-ruled-odd-row\">\n                     <td class=\"table-body\">Override \n                        			 \n                     </td>\n                     <td class=\"table-body\">Determines whether the property value is overidden by the policy defined by its category.\n                        \n                        			 \n                     </td>\n                  </tr>\n                  <tr class=\"not-ruled-even-row\">\n                     <td class=\"table-body\">Subordinate \n                        			 \n                     </td>\n                     <td class=\"table-body\">The mapped property that receives its value from the master property. \n                        			 \n                     </td>\n                  </tr>\n                  <tr class=\"not-ruled-odd-row\">\n                     <td class=\"table-body\">System-Defined Property \n                        			 \n                     </td>\n                     <td class=\"table-body\">A property in the database created by the system, which is then assigned to a file.\n                        \n                        			 \n                     </td>\n                  </tr>\n                  <tr class=\"not-ruled-even-row\">\n                     <td class=\"table-body\">User-Defined Property (UDP) \n                        			 \n                     </td>\n                     <td class=\"table-body\">A property in the database created by an administrator. The property can be applied\n                        to a file when it is added to a vault. \n                        			 \n                     </td>\n                  </tr>\n               </table>\n            </div> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_F40B4C20F6E1456E998AAED3C2280F31\"></a> \n            <h2><a name=\"GUID-D739CDBE-83C2-4DE5-8778-3ED280FFE4C1\"></a>Data Types\n            </h2> \n            <p><a name=\"GUID-F734206B-EC28-4997-BBD7-260E6D6B6CF2\"></a>Every property value has a data type that determines how that value is read and processed.\n               \n               \n            </p> <a name=\"TABLE_7ED81AB45C8B41C1B2FFC7190EA7E609\"></a><div class=\"table-not-ruled\">\n               <table cellpadding=\"0\" cellspacing=\"0\" class=\"not-ruled\">\n                  <colgroup>\n                     <col>\n                     <col>\n                  </colgroup>\n                  <tr class=\"not-ruled-heading\">\n                     <th class=\"table-heading\">Data Type Name \n                        			 \n                     </th>\n                     <th class=\"table-heading\">Description \n                        			 \n                     </th>\n                  </tr>\n                  <tr class=\"not-ruled-odd-row\">\n                     <td class=\"table-body\">Boolean \n                        			 \n                     </td>\n                     <td class=\"table-body\">True or False. \n                        			 \n                     </td>\n                  </tr>\n                  <tr class=\"not-ruled-even-row\">\n                     <td class=\"table-body\">Date Type \n                        			 \n                     </td>\n                     <td class=\"table-body\">Can be a specific date or date range expressed by a beginning and end date. \n                        			 \n                     </td>\n                  </tr>\n                  <tr class=\"not-ruled-odd-row\">\n                     <td class=\"table-body\">Number \n                        			 \n                     </td>\n                     <td class=\"table-body\">Numbers only. \n                        			 \n                     </td>\n                  </tr>\n                  <tr class=\"not-ruled-even-row\">\n                     <td class=\"table-body\">Text \n                        			 \n                     </td>\n                     <td class=\"table-body\">Letters and numbers. \n                        			 \n                     </td>\n                  </tr>\n               </table>\n            </div> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_3DC617C92A4F4EB4B3EE587B682C565A\"></a> \n            <h2><a name=\"GUID-5CFDCF21-C4EB-4C90-937E-1209FE2B0F86\"></a>Attributes\n            </h2> \n            <p><a name=\"GUID-306E9C72-DC33-4754-BD7F-5E33A6815E62\"></a>Properties have attributes that determine how the property is described and the constraints\n               for its value. \n               \n            </p> <a name=\"TABLE_7D2AE5E945E24C4B97975FC9202A863B\"></a><div class=\"table-not-ruled\">\n               <table cellpadding=\"0\" cellspacing=\"0\" class=\"not-ruled\">\n                  <colgroup>\n                     <col>\n                     <col>\n                  </colgroup>\n                  <tr class=\"not-ruled-heading\">\n                     <th class=\"table-heading\">Attribute Name \n                        			 \n                     </th>\n                     <th class=\"table-heading\">Description \n                        			 \n                     </th>\n                  </tr>\n                  <tr class=\"not-ruled-odd-row\">\n                     <td class=\"table-body\">Basic Search \n                        			 \n                     </td>\n                     <td class=\"table-body\">A constraint that determines whether or not the property should be included in basic\n                        searches. \n                        			 \n                     </td>\n                  </tr>\n                  <tr class=\"not-ruled-even-row\">\n                     <td class=\"table-body\">Case Sensitivity \n                        			 \n                     </td>\n                     <td class=\"table-body\">A constraint that applies to text data types. This constraint can be set to none,\n                        UPPER CASE, lower case, Name Case or Sentence case. \n                        			 \n                     </td>\n                  </tr>\n                  <tr class=\"not-ruled-odd-row\">\n                     <td class=\"table-body\">Enforce List of Values \n                        			 \n                     </td>\n                     <td class=\"table-body\">A constraint that determines whether the property must have a value from a list. \n                        			 \n                     </td>\n                  </tr>\n                  <tr class=\"not-ruled-even-row\">\n                     <td class=\"table-body\">Initial Value \n                        			 \n                     </td>\n                     <td class=\"table-body\">An attribute that specifies the initial property value when one isn\'t specified. \n                        				\n                        <div><a name=\"GUID-63B7079E-9192-4AD7-B2E1-93E6F3B9AF2A\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span>Initial values are best used with write mappings. If an initial value is set on a\n                              regular read mapping, that read mapping has higher priority and will overwrite the\n                              initial value. The only case in which an initial value won\'t be overwritten by a read\n                              mapping is if the value it maps to is blank. \n                              				\n                           </div>\n                        </div> \n                     </td>\n                  </tr>\n                  <tr class=\"not-ruled-odd-row\">\n                     <td class=\"table-body\">List Values \n                        			 \n                     </td>\n                     <td class=\"table-body\">Displays the List Type dialog box from which you can enter and order values for a\n                        list. At least one item must appear in the list. \n                        			 \n                     </td>\n                  </tr>\n                  <tr class=\"not-ruled-even-row\">\n                     <td class=\"table-body\">Minimum Length \n                        			 \n                     </td>\n                     <td class=\"table-body\">The minimum number of characters a property value can have. \n                        			 \n                     </td>\n                  </tr>\n                  <tr class=\"not-ruled-odd-row\">\n                     <td class=\"table-body\">Maximum Length \n                        			 \n                     </td>\n                     <td class=\"table-body\">The maximum number of characters a property value can have. \n                        			 \n                     </td>\n                  </tr>\n                  <tr class=\"not-ruled-even-row\">\n                     <td class=\"table-body\">Requires Value \n                        			 \n                     </td>\n                     <td class=\"table-body\">A constraint which determines whether the property must have a value to be compliant.\n                        \n                        			 \n                     </td>\n                  </tr>\n                  <tr class=\"not-ruled-odd-row\">\n                     <td class=\"table-body\">State \n                        			 \n                     </td>\n                     <td class=\"table-body\">A setting on a property that indicates whether it recognizes the state the file in\n                        a lifecycle. \n                        			 \n                     </td>\n                  </tr>\n                  <tr class=\"not-ruled-even-row\">\n                     <td class=\"table-body\">Usage \n                        			 \n                     </td>\n                     <td class=\"table-body\"> Indicates the number of files currently using the property. Use this information\n                        to determine which properties are used more than others, to help decide which properties\n                        can be removed from the vault. \n                        			 \n                     </td>\n                  </tr>\n               </table>\n            </div> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_4327A5D11DCF4F338038463BBF2C8B71\"></a> \n            <h2><a name=\"GUID-5BB29B60-077D-49E1-BF8A-105769EE5F47\"></a>Property Compliance Icons\n            </h2> \n            <p><a name=\"GUID-E79ED951-9B87-4BAF-AA45-7EBB7172842A\"></a>The main view in the vault client has a Property Compliance column that lists various\n               status icons. The Icons in this column indicate whether a property associated with\n               the file is compliant, non-compliant, pending, or has failed the equivalence evaluation.\n               \n               \n            </p> <a name=\"TABLE_A7D64096990F4DD4B265E97A7881710A\"></a><div class=\"table-not-ruled\">\n               <table cellpadding=\"0\" cellspacing=\"0\" class=\"not-ruled\">\n                  <colgroup>\n                     <col>\n                     <col>\n                     <col>\n                  </colgroup>\n                  <tr class=\"not-ruled-heading\">\n                     <th class=\"table-heading\">Icon \n                        			 \n                     </th>\n                     <th class=\"table-heading\">Value \n                        			 \n                     </th>\n                     <th class=\"table-heading\">Definition \n                        			 \n                     </th>\n                  </tr>\n                  <tr class=\"not-ruled-odd-row\">\n                     <td class=\"table-body\"> <a name=\"GUID-A2D9DD9A-A92E-4640-92CC-D54707969EA8\"></a><p class=\"table-body\">No icon \n                           				\n                        </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-8C307799-6853-4A86-BB59-35D6A66FEEF1\"></a><p class=\"table-body\">Compliant \n                           				\n                        </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-03A63336-0119-4BD3-9416-A0DC7FFBD0C6\"></a><p class=\"table-body\">All properties meet policy requirements and equivalence. \n                           				\n                        </p> \n                     </td>\n                  </tr>\n                  <tr class=\"not-ruled-even-row\">\n                     <td class=\"table-body\">&nbsp; <a name=\"GUID-F7B4978F-48D8-420C-86DB-34CA47CD52AA\"></a><p class=\"table-body\"> <img src=\"../images/GUID-0E40A727-9DBC-47AF-8DEA-5AF7970CF29B-low.gif\"> \n                        </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-58EFFD72-A260-4422-B14E-89998B1B49AD\"></a><p class=\"table-body\">Non-compliant \n                           				\n                        </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-D62A17A7-4CFF-4F9A-8D74-CCDC9814A482\"></a><p class=\"table-body\">One or more properties do not meet property policy requirements or equivalence. \n                           				\n                        </p> <a name=\"GUID-053E5A9D-F209-4453-A60D-46EFC2B5ACB5\"></a><p class=\"table-body\">Hover your mouse over the icon to learn more about why one or more properties failed\n                           compliance. \n                           				\n                        </p> \n                     </td>\n                  </tr>\n                  <tr class=\"not-ruled-odd-row\">\n                     <td class=\"table-body\">&nbsp; <a name=\"GUID-1704D433-DC7D-4B88-AAAA-1625A4CA3090\"></a><p class=\"table-body\"> <img src=\"../images/GUID-DA625114-8E1B-416B-978C-59B2AC231C93-low.png\"> \n                        </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-E4555EC3-B2BA-407C-8BB3-69F8043A21B5\"></a><p class=\"table-body\">Not calculated \n                           				\n                        </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-5B537425-A723-4B27-ADCA-D2F2839DCD58\"></a><p class=\"table-body\">There has been a change to one or more properties but equivalence and policy have\n                           not been verified yet. \n                           				\n                        </p> \n                     </td>\n                  </tr>\n                  <tr class=\"not-ruled-even-row\">\n                     <td class=\"table-body\">&nbsp; <a name=\"GUID-64632168-8A77-4738-A390-676880387C62\"></a><p class=\"table-body\"> <img src=\"../images/GUID-E63A2DF4-1AF3-476C-A1F5-F01A5C86A048-low.png\"> \n                        </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-D28C7211-1EFB-448D-A3FA-9D35E6EE6652\"></a><p class=\"table-body\">Pending \n                           				\n                        </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-27328CD9-E098-452A-A594-89911C379C6D\"></a><p class=\"table-body\">Properties are currently being evaluated for equivalence. \n                           				\n                        </p> \n                     </td>\n                  </tr>\n                  <tr class=\"not-ruled-odd-row\">\n                     <td class=\"table-body\">&nbsp; <a name=\"GUID-76D2413D-9C13-4756-9D0C-FD62FEEEAAD2\"></a><p class=\"table-body\"> <img src=\"../images/GUID-3E84E082-0D55-4741-85F5-A68C3D6988E2-low.png\"> \n                        </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-BAA657AD-17C9-4E17-956C-CF056A923E91\"></a><p class=\"table-body\">Evaluation failed. \n                           				\n                        </p> \n                     </td>\n                     <td class=\"table-body\"> <a name=\"GUID-13ABD5E5-B680-44AC-B918-E88193CA6EB5\"></a><p class=\"table-body\">The equivalence evaluation failed. This is a rare situation and can result when the\n                           processor enters an evaluation loop. \n                           				\n                        </p> <a name=\"GUID-C82ADA28-621F-4918-8ADC-F60D11BCB441\"></a><p class=\"table-body\"> <em class=\"strong\">Note: \n                              				  </em>On the Find dialog, an evaluation failed value is added. This allows you to search\n                           for any files for which the evaluation failed. \n                           				\n                        </p> \n                     </td>\n                  </tr>\n               </table>\n            </div> \n            <div><a name=\"GUID-09EAF67E-F7E4-4DA2-B804-13D5EEF16245\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span>See also \n                  	 <span class=\"char_link\"><a href=\"GUID-D0B27FC3-FC8B-41DF-8DCB-CE0C1C710C1B.htm\">Re-index File Properties</a></span>. \n                  \n               </div>\n            </div> \n         </div><span class=\"noindex\">\n            <div class=\"topic-list\">\n               <h4 class=\"related\">Topics in this section</h4>\n               <ul class=\"jumplist\">\n                  <li class=\"topiclist-litem\"><a href=\"GUID-1EC10936-9D84-4179-AEE3-59DD1B3E003C.htm\">User-Defined Properties</a><p> Learn about how user-defined properties work in Vault.       \n                        \n                     </p>\n                  </li>\n                  <li class=\"topiclist-litem\"><a href=\"GUID-61DFF267-9166-48D8-926E-3A8EDEC755FA.htm\">User-Defined Property Associations</a><p>Associations define the entity classes that can use the user-defined property (UDP).\n                        \n                        \n                     </p>\n                  </li>\n                  <li class=\"topiclist-litem\"><a href=\"GUID-8D5F5998-43A5-4813-B3E3-6CD4D12A4F67.htm\">Access Property Definitions</a><p>Create, edit, and delete user-defined properties (UDPs) on the Properties Definition\n                        dialog. \n                     </p>\n                  </li>\n                  <li class=\"topiclist-litem\"><a href=\"GUID-D80155DE-3558-4403-BBC0-CEF88B6DE178.htm\">Create a User-Defined Property</a><p>Create new user-defined properties (UDP) to help customize property mapping and write\n                        back preferences. \n                        \n                     </p>\n                  </li>\n                  <li class=\"topiclist-litem\"><a href=\"GUID-5E9F13AF-4EE1-40AF-AC2C-ED65AE173514.htm\">Edit Property Values</a><p>Properties are listed in a table that appears in the Properties grid when a file is\n                        selected from the file list. It displays the property type and value of each property\n                        listed.    \n                     </p>\n                  </li>\n                  <li class=\"topiclist-litem\"><a href=\"GUID-4C0E9BAA-232F-4B2D-875D-017ECB265D6B.htm\">Delete a User-Defined Property</a><p>A user-defined property (UDP) can be deleted only if it is not associated with a category\n                        and is not being used by any Vault objects. \n                     </p>\n                  </li>\n                  <li class=\"topiclist-litem\"><a href=\"GUID-5D94CB2E-2854-4502-9EB0-165D6F74A780.htm\">Content Source Providers</a><p>Learn about Content Source Providers and how they work with Vault. </p>\n                  </li>\n                  <li class=\"topiclist-litem\"><a href=\"GUID-915561C8-1143-4E68-BE41-37376FA39A58.htm\">Map Properties</a><p>You can map properties to a user-defined property (UDP) so that values from the master\n                        file, such as a file property, are written to the subordinate UDP.  \n                        \n                     </p>\n                  </li>\n                  <li class=\"topiclist-litem\"><a href=\"GUID-F6B487B7-1FF7-4539-9508-0566F96DDF7B.htm\">Customize Change Order Properties</a><p>User-defined properties for change orders can be created in the Property Definitions\n                        dialog.  \n                     </p>\n                  </li>\n                  <li class=\"topiclist-litem\"><a href=\"GUID-E8EFF24A-E893-48E3-B6A3-88231D4ACA42.htm\">Create a Bill of Materials (BOM) Row Property Definition</a><p>Customize Bill of Materials (BOM) row properties and create new BOM row properties\n                        that map to file properties to stream line your design management process. \n                     </p>\n                  </li>\n                  <li class=\"topiclist-litem\"><a href=\"GUID-5DACC153-289B-401F-A103-9DD08E0995D0.htm\">Configure Data Cards for the Inventor Vault Add-in</a><p> The \n                        <span class=\"char_link\"><a href=\"GUID-3F5949F1-41BB-4981-B122-3D88C56F5D6F.htm\">Data Cards</a></span> feature provides convenient summaries of the metadata assigned to a file or group\n                        of files through a single point of access.  \n                        \n                     </p>\n                  </li>\n               </ul>\n            </div></span><div class=\"footer-block\"><a href=\"..\" class=\"comments-anchor\" target=\"_blank\"><span class=\"comments-link\">Please send us your comment about this page</span></a></div><br><p class=\"footer-license-block\"><a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\"><img alt=\"Creative Commons License\" style=\"border-width: 0;\" src=\"../images/ccLink.png\"></a>&nbsp;<em>Except where otherwise noted, this work is licensed under a <a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\">Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License</a>. Please see the <a href=\"http://autodesk.com/creativecommons\" target=\"_blank\">Autodesk Creative Commons FAQ</a> for more information.</em></p><br></div>\n   </body>\n</html>";
// SIG // Begin signature block
// SIG // MIIgdgYJKoZIhvcNAQcCoIIgZzCCIGMCAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // FioUKdTEkm5qq0DPB5UTi5mcGzN+wridNhCg3zt9BV2g
// SIG // ggoaMIIEyzCCA7OgAwIBAgIQCQja65wGHi65un4mqmKH
// SIG // ijANBgkqhkiG9w0BAQsFADCBhDELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTUw
// SIG // MwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
// SIG // b2RlIFNpZ25pbmcgQ0EgLSBHMjAeFw0xOTA1MTQwMDAw
// SIG // MDBaFw0yMDA1MTMyMzU5NTlaMHwxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIDApDYWxpZm9ybmlhMRMwEQYDVQQHDApT
// SIG // YW4gUmFmYWVsMRcwFQYDVQQKDA5BdXRvZGVzaywgSW5j
// SIG // LjERMA8GA1UECwwIU2VjdXJpdHkxFzAVBgNVBAMMDkF1
// SIG // dG9kZXNrLCBJbmMuMIIBIjANBgkqhkiG9w0BAQEFAAOC
// SIG // AQ8AMIIBCgKCAQEAkVKRoPYsoxPdlabspcuG8HYDfcWQ
// SIG // 9qyPOT2punwpVdjt2slktcpSTlydrGy8ijcbl5/k8AOJ
// SIG // afKMQvow0fNjIoNB5nsb8j2xFJPbBhHl8GT4P6DZ1OWK
// SIG // ioiUXgGHKjctUws49J4elntqvBYhKCbuPqG772QCoYFU
// SIG // P7qcFbh3PbyNB6cnKMn2vNGRqiEtV2aGg+/MiL3QPsvT
// SIG // kTWhVuTLIvwZ4kK5C5ACiQzlGOlE+C7gWuFoxtvy6gUa
// SIG // A8JAq/xLjYKwFevQwGncg3s1cuiGhx0P7Rvn6oCd2cem
// SIG // FmbK3I3rMRt+jc9wzAj3oHxvCo4f5Lfva+OpC1dETUVV
// SIG // sk0VGwIDAQABo4IBPjCCATowCQYDVR0TBAIwADAOBgNV
// SIG // HQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMw
// SIG // YQYDVR0gBFowWDBWBgZngQwBBAEwTDAjBggrBgEFBQcC
// SIG // ARYXaHR0cHM6Ly9kLnN5bWNiLmNvbS9jcHMwJQYIKwYB
// SIG // BQUHAgIwGQwXaHR0cHM6Ly9kLnN5bWNiLmNvbS9ycGEw
// SIG // HwYDVR0jBBgwFoAU1MAGIknrOUvdk+JcobhHdglyA1gw
// SIG // KwYDVR0fBCQwIjAgoB6gHIYaaHR0cDovL3JiLnN5bWNi
// SIG // LmNvbS9yYi5jcmwwVwYIKwYBBQUHAQEESzBJMB8GCCsG
// SIG // AQUFBzABhhNodHRwOi8vcmIuc3ltY2QuY29tMCYGCCsG
// SIG // AQUFBzAChhpodHRwOi8vcmIuc3ltY2IuY29tL3JiLmNy
// SIG // dDANBgkqhkiG9w0BAQsFAAOCAQEA0Q2+iVSEfT4xGq3A
// SIG // OADVb0rT5Z8E+PPb1x6hKknSzuaZKk/acDz9mdnFajaU
// SIG // WgIKiFJlsqJnuAM1w4lqKaEWsz3DoxvGIEwexj71Ud6a
// SIG // KlBJNcR9DdkXUZwMhbw9d78rjJAIX6tOwfSludZfdq8b
// SIG // YEkuIzQi9uYW9vHVPSCzhnUBKjwc9qTo9yBc7Fcn4FAT
// SIG // 90DzWM2hS9oc3p0pprYI2I/O4th90BEmwWkVqVgfaR0z
// SIG // VyIEmBbqB/IWLfjUBZJ/8sbkwWuWlYVRrfPxsj1e9qvb
// SIG // wE3Y28jWyGbqoUG39GhXk3uT8R8i3+T6M0c4rMfdifBC
// SIG // pceCaFTJzSye7LoeVzCCBUcwggQvoAMCAQICEHwbNTVK
// SIG // 59t050FfEWnKa6gwDQYJKoZIhvcNAQELBQAwgb0xCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjEfMB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29y
// SIG // azE6MDgGA1UECxMxKGMpIDIwMDggVmVyaVNpZ24sIElu
// SIG // Yy4gLSBGb3IgYXV0aG9yaXplZCB1c2Ugb25seTE4MDYG
// SIG // A1UEAxMvVmVyaVNpZ24gVW5pdmVyc2FsIFJvb3QgQ2Vy
// SIG // dGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMTQwNzIyMDAw
// SIG // MDAwWhcNMjQwNzIxMjM1OTU5WjCBhDELMAkGA1UEBhMC
// SIG // VVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9u
// SIG // MR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3Jr
// SIG // MTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1
// SIG // NiBDb2RlIFNpZ25pbmcgQ0EgLSBHMjCCASIwDQYJKoZI
// SIG // hvcNAQEBBQADggEPADCCAQoCggEBANeVQ9Tc32euOftS
// SIG // pLYmMQRw6beOWyq6N2k1lY+7wDDnhthzu9/r0XY/ilaO
// SIG // 6y1L8FcYTrGNpTPTC3Uj1Wp5J92j0/cOh2W13q0c8fU1
// SIG // tCJRryKhwV1LkH/AWU6rnXmpAtceSbE7TYf+wnirv+9S
// SIG // rpyvCNk55ZpRPmlfMBBOcWNsWOHwIDMbD3S+W8sS4duM
// SIG // xICUcrv2RZqewSUL+6McntimCXBx7MBHTI99w94Zzj7u
// SIG // BHKOF9P/8LIFMhlM07Acn/6leCBCcEGwJoxvAMg6ABFB
// SIG // ekGwp4qRBKCZePR3tPNgKuZsUAS3FGD/DVH0qIuE/iHa
// SIG // XF599Sl5T7BEdG9tcv8CAwEAAaOCAXgwggF0MC4GCCsG
// SIG // AQUFBwEBBCIwIDAeBggrBgEFBQcwAYYSaHR0cDovL3Mu
// SIG // c3ltY2QuY29tMBIGA1UdEwEB/wQIMAYBAf8CAQAwZgYD
// SIG // VR0gBF8wXTBbBgtghkgBhvhFAQcXAzBMMCMGCCsGAQUF
// SIG // BwIBFhdodHRwczovL2Quc3ltY2IuY29tL2NwczAlBggr
// SIG // BgEFBQcCAjAZGhdodHRwczovL2Quc3ltY2IuY29tL3Jw
// SIG // YTA2BgNVHR8ELzAtMCugKaAnhiVodHRwOi8vcy5zeW1j
// SIG // Yi5jb20vdW5pdmVyc2FsLXJvb3QuY3JsMBMGA1UdJQQM
// SIG // MAoGCCsGAQUFBwMDMA4GA1UdDwEB/wQEAwIBBjApBgNV
// SIG // HREEIjAgpB4wHDEaMBgGA1UEAxMRU3ltYW50ZWNQS0kt
// SIG // MS03MjQwHQYDVR0OBBYEFNTABiJJ6zlL3ZPiXKG4R3YJ
// SIG // cgNYMB8GA1UdIwQYMBaAFLZ3+mlIR59TEtXC6gcydgfR
// SIG // lwcZMA0GCSqGSIb3DQEBCwUAA4IBAQB/68qn6ot2Qus+
// SIG // jiBUMOO3udz6SD4Wxw9FlRDNJ4ajZvMC7XH4qsJVl5Fw
// SIG // g/lSflJpPMnx4JRGgBi7odSkVqbzHQCR1YbzSIfgy8Q0
// SIG // aCBetMv5Be2cr3BTJ7noPn5RoGlxi9xR7YA6JTKfRK9u
// SIG // QyjTIXW7l9iLi4z+qQRGBIX3FZxLEY3ELBf+1W5/muJW
// SIG // kvGWs60t+fTf2omZzrI4RMD3R3vKJbn6Kmgzm1By3qif
// SIG // 1M0sCzS9izB4QOCNjicbkG8avggVgV3rL+JR51EeyXgp
// SIG // 5x5lvzjvAUoBCSQOFsQUecFBNzTQPZFSlJ3haO8I8OJp
// SIG // nGdukAsak3HUJgLDwFojMYIVtDCCFbACAQEwgZkwgYQx
// SIG // CzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRlYyBD
// SIG // b3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1
// SIG // c3QgTmV0d29yazE1MDMGA1UEAxMsU3ltYW50ZWMgQ2xh
// SIG // c3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENBIC0gRzIC
// SIG // EAkI2uucBh4uubp+Jqpih4owDQYJYIZIAWUDBAIBBQCg
// SIG // fDAQBgorBgEEAYI3AgEMMQIwADAZBgkqhkiG9w0BCQMx
// SIG // DAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4wDAYK
// SIG // KwYBBAGCNwIBFTAvBgkqhkiG9w0BCQQxIgQgsdL+kVB9
// SIG // zVWc4oXSboCKYYR72+VQzaDeoWRjJi9zjxswDQYJKoZI
// SIG // hvcNAQEBBQAEggEAbAhX814APKQj7l9c6ZK7EqP2vh+7
// SIG // rJ/s+o/mO9DFoHlea+dS3ElubglZi0cIn3Xw1nvqStyT
// SIG // +eueVlaBl1wMSyvhcXZaHxqjuTLAXpF47sxguFGHNoEE
// SIG // v2ZWIH+DSd0yOhpDX0ufsiKss6SZ2B4/xsjIG1bbGRzq
// SIG // PTbv82CcDnce4vOOCnVjhxcBGGQc9mSmVo8GOSWNgV6e
// SIG // mMJtrXwROuJBNPqQk/EaF3FSbfdH39s5Wo94hr0eJoc8
// SIG // hnABHL5RP8C3uOofcbQvWpIBAcO8tgBjoX8ZdnZx0acV
// SIG // cKWUaGAQLhwRWnS1V+caVDGJtG4/mT23kM60zyfZg6b3
// SIG // +EBoo6GCE20wghNpBgorBgEEAYI3AwMBMYITWTCCE1UG
// SIG // CSqGSIb3DQEHAqCCE0YwghNCAgEDMQ8wDQYJYIZIAWUD
// SIG // BAIBBQAwggEMBgsqhkiG9w0BCRABBKCB/ASB+TCB9gIB
// SIG // AQYKKwYBBAGyMQIBATAxMA0GCWCGSAFlAwQCAQUABCDw
// SIG // BHmoZq8rgCx00xVdscj3uK5yN1u7hIjh5mE9K9BchwIU
// SIG // Wy25mKxYFtNaTbUoUiYKmJg9FOgYDzIwMjAwMzIzMTQw
// SIG // MzU1WqCBiqSBhzCBhDELMAkGA1UEBhMCR0IxGzAZBgNV
// SIG // BAgMEkdyZWF0ZXIgTWFuY2hlc3RlcjEQMA4GA1UEBwwH
// SIG // U2FsZm9yZDEYMBYGA1UECgwPU2VjdGlnbyBMaW1pdGVk
// SIG // MSwwKgYDVQQDDCNTZWN0aWdvIFJTQSBUaW1lIFN0YW1w
// SIG // aW5nIFNpZ25lciAjMaCCDfowggcGMIIE7qADAgECAhA9
// SIG // GjVyMBWCYzDQE3F+gkEIMA0GCSqGSIb3DQEBDAUAMH0x
// SIG // CzAJBgNVBAYTAkdCMRswGQYDVQQIExJHcmVhdGVyIE1h
// SIG // bmNoZXN0ZXIxEDAOBgNVBAcTB1NhbGZvcmQxGDAWBgNV
// SIG // BAoTD1NlY3RpZ28gTGltaXRlZDElMCMGA1UEAxMcU2Vj
// SIG // dGlnbyBSU0EgVGltZSBTdGFtcGluZyBDQTAeFw0xOTA1
// SIG // MDIwMDAwMDBaFw0zMDA4MDEyMzU5NTlaMIGEMQswCQYD
// SIG // VQQGEwJHQjEbMBkGA1UECAwSR3JlYXRlciBNYW5jaGVz
// SIG // dGVyMRAwDgYDVQQHDAdTYWxmb3JkMRgwFgYDVQQKDA9T
// SIG // ZWN0aWdvIExpbWl0ZWQxLDAqBgNVBAMMI1NlY3RpZ28g
// SIG // UlNBIFRpbWUgU3RhbXBpbmcgU2lnbmVyICMxMIICIjAN
// SIG // BgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAy1FQ/1b+
// SIG // /HhjcAGTWp4Y9DtT9gevIWz1og99HXAthHRIi5yKlQU9
// SIG // WYT5kYB5USzZirfBC5q6CorNZk8DiwG7MMqrvdvATxJe
// SIG // /ArM4kWwATiKu03n1BxUmO05WM9bwi9FmDEK+TU4uDEu
// SIG // bbQeOXLhuCq+n4yMGqVGrgsrTJn+LEv8KLkiOmYX0KpW
// SIG // iiHA85YktNCFJmu68G9kmHmmrb1c2FNrKwrWcoqFRuMN
// SIG // GAbaxntBVjabFT7xahGg92b1GNCAVWOHaGbrDnlVglyj
// SIG // 7Um4cYaekzewa6PqYmyjrpbouf2Lq8b2WVsAPFcgGC1w
// SIG // A6ec75LreaHHXex8tI9L3+td/KMg3ZI45WpROmuFnEyg
// SIG // mAhpWwbnKhnQlZOLO2uKBQkp2Nba2+Ny+lxKL3sVVoYy
// SIG // v38FCZ0tKs9Q4eZhINvHBoBcThRGvq5XcaKqbDCTHH53
// SIG // ywbpV82R9dUzchzh2spu6/MP7Hlbuyee6B7+L/K7f+nl
// SIG // 0GfruA18pCtZA4uV7SIozfosO8cWEa/j1rFQZ2nFjvV5
// SIG // 0K3/h8z4f6r5ou1h+MiNadqx9FGR62dX0WQR62TLA71J
// SIG // VTpFQxgsJWzRLwwtb/VBNSSg8mNZFl/ZpOksTtu7MRLG
// SIG // bfhbbgPcyxWPG41y7NsPFZDWEk7u4gAxJZM1b2pbpRJj
// SIG // QAGKuWmIOoi4DxkCAwEAAaOCAXgwggF0MB8GA1UdIwQY
// SIG // MBaAFBqh+GEZIA/DQXdFKI7RNV8GEgRVMB0GA1UdDgQW
// SIG // BBRvTYYH2DInniwp0tATA4CB3QWDKTAOBgNVHQ8BAf8E
// SIG // BAMCBsAwDAYDVR0TAQH/BAIwADAWBgNVHSUBAf8EDDAK
// SIG // BggrBgEFBQcDCDBABgNVHSAEOTA3MDUGDCsGAQQBsjEB
// SIG // AgEDCDAlMCMGCCsGAQUFBwIBFhdodHRwczovL3NlY3Rp
// SIG // Z28uY29tL0NQUzBEBgNVHR8EPTA7MDmgN6A1hjNodHRw
// SIG // Oi8vY3JsLnNlY3RpZ28uY29tL1NlY3RpZ29SU0FUaW1l
// SIG // U3RhbXBpbmdDQS5jcmwwdAYIKwYBBQUHAQEEaDBmMD8G
// SIG // CCsGAQUFBzAChjNodHRwOi8vY3J0LnNlY3RpZ28uY29t
// SIG // L1NlY3RpZ29SU0FUaW1lU3RhbXBpbmdDQS5jcnQwIwYI
// SIG // KwYBBQUHMAGGF2h0dHA6Ly9vY3NwLnNlY3RpZ28uY29t
// SIG // MA0GCSqGSIb3DQEBDAUAA4ICAQDAaO2z2NRQm+/TdcsP
// SIG // O/ck03o3RY0s7xb7UaksH7UltYqfXQvCGyB0jWYPNsuq
// SIG // 9jYND36PS0p0Q2WsDSr2Cu1rbcUJOO0AG/jl3KYKQAVH
// SIG // 74TKCbxDZoO/n+3bjj3RQWSxcAItA1dbGG8cLMsesgDo
// SIG // ugkvW4EENbmpY22OCMUY0eEhrPkSChTAEtt+JZ2sHRDA
// SIG // WqWD0h8aZlX8myri7DdXjuXfljD4wJMLQxj5Am+pUa+4
// SIG // VwrzHAdpOY83nG3Xka6lLknpSt6z0Iy/OZANwIHO8CoH
// SIG // OgymLVHScvNTxvm97+8MaUl3nyxWxOmhCD0HrsUe1oQi
// SIG // x7x9QxtYOGJO0QUlhMVC+B8v9tv6q4xU7EWKbBJNMFpS
// SIG // 5aQXCSLm72/1X4ZD36EtvUpGkqCBlixhl39Ab9g/jDVa
// SIG // q9HGoDuFZlSA7x8a9fGbsKEnfbLnC8/2LZxYE5SphvxF
// SIG // UqIobX90D1KRSXrpEvipO7CS/X2RFOlbbUiU8siW7gU4
// SIG // s8XsMD/hByAEsdiLvP2zPm/yAlMG9KDtyZpyo5dfAPvL
// SIG // Y9DozXT9dcnUNkW6exJZcu3n8npQAHj4Q5pG2N+/VNRe
// SIG // scfRvBuD9CvnC+hHyFOezBqs9vqKdVNsIIWp1bhquiSO
// SIG // iisIkZ83BBz2b6LdNKqR/8YVLh5CGgkpT/TGzeKRotNA
// SIG // DI544zCCBuwwggTUoAMCAQICEDAPb6zdZph0fKlGNqd4
// SIG // LbkwDQYJKoZIhvcNAQEMBQAwgYgxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIEwpOZXcgSmVyc2V5MRQwEgYDVQQHEwtK
// SIG // ZXJzZXkgQ2l0eTEeMBwGA1UEChMVVGhlIFVTRVJUUlVT
// SIG // VCBOZXR3b3JrMS4wLAYDVQQDEyVVU0VSVHJ1c3QgUlNB
// SIG // IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTE5MDUw
// SIG // MjAwMDAwMFoXDTM4MDExODIzNTk1OVowfTELMAkGA1UE
// SIG // BhMCR0IxGzAZBgNVBAgTEkdyZWF0ZXIgTWFuY2hlc3Rl
// SIG // cjEQMA4GA1UEBxMHU2FsZm9yZDEYMBYGA1UEChMPU2Vj
// SIG // dGlnbyBMaW1pdGVkMSUwIwYDVQQDExxTZWN0aWdvIFJT
// SIG // QSBUaW1lIFN0YW1waW5nIENBMIICIjANBgkqhkiG9w0B
// SIG // AQEFAAOCAg8AMIICCgKCAgEAyBsBr9ksfoiZfQGYPyCQ
// SIG // vZyAIVSTuc+gPlPvs1rAdtYaBKXOR4O168TMSTTL80Vl
// SIG // ufmnZBYmCfvVMlJ5LsljwhObtoY/AQWSZm8hq9VxEHmH
// SIG // 9EYqzcRaydvXXUlNclYP3MnjU5g6Kh78zlhJ07/zObu5
// SIG // pCNCrNAVw3+eolzXOPEWsnDTo8Tfs8VyrC4Kd/wNlFK3
// SIG // /B+VcyQ9ASi8Dw1Ps5EBjm6dJ3VV0Rc7NCF7lwGUr3+A
// SIG // z9ERCleEyX9W4L1GnIK+lJ2/tCCwYH64TfUNP9vQ6oWM
// SIG // ilZx0S2UTMiMPNMUopy9Jv/TUyDHYGmbWApU9AXn/TGs
// SIG // +ciFF8e4KRmkKS9G493bkV+fPzY+DjBnK0a3Na+WvtpM
// SIG // YMyou58NFNQYxDCYdIIhz2JWtSFzEh79qsoIWId3pBXr
// SIG // GVX/0DlULSbuRRo6b83XhPDX8CjFT2SDAtT74t7xvAIo
// SIG // 9G3aJ4oG0paH3uhrDvBbfel2aZMgHEqXLHcZK5OVmJyX
// SIG // nuuOwXhWxkQl3wYSmgYtnwNe/YOiU2fKsfqNoWTJiJJZ
// SIG // y6hGwMnypv99V9sSdvqKQSTUG/xypRSi1K1DHKRJi0E5
// SIG // FAMeKfobpSKupcNNgtCN2mu32/cYQFdz8HGj+0p9RTbB
// SIG // 942C+rnJDVOAffq2OVgy728YUInXT50zvRq1naHelUF6
// SIG // p4MCAwEAAaOCAVowggFWMB8GA1UdIwQYMBaAFFN5v1qq
// SIG // K0rPVIDh2JvAnfKyA2bLMB0GA1UdDgQWBBQaofhhGSAP
// SIG // w0F3RSiO0TVfBhIEVTAOBgNVHQ8BAf8EBAMCAYYwEgYD
// SIG // VR0TAQH/BAgwBgEB/wIBADATBgNVHSUEDDAKBggrBgEF
// SIG // BQcDCDARBgNVHSAECjAIMAYGBFUdIAAwUAYDVR0fBEkw
// SIG // RzBFoEOgQYY/aHR0cDovL2NybC51c2VydHJ1c3QuY29t
// SIG // L1VTRVJUcnVzdFJTQUNlcnRpZmljYXRpb25BdXRob3Jp
// SIG // dHkuY3JsMHYGCCsGAQUFBwEBBGowaDA/BggrBgEFBQcw
// SIG // AoYzaHR0cDovL2NydC51c2VydHJ1c3QuY29tL1VTRVJU
// SIG // cnVzdFJTQUFkZFRydXN0Q0EuY3J0MCUGCCsGAQUFBzAB
// SIG // hhlodHRwOi8vb2NzcC51c2VydHJ1c3QuY29tMA0GCSqG
// SIG // SIb3DQEBDAUAA4ICAQBtVIGlM10W4bVTgZF13wN6Mgst
// SIG // JYQRsrDbKn0qBfW8Oyf0WqC5SVmQKWxhy7VQ2+J9+Z8A
// SIG // 70DDrdPi5Fb5WEHP8ULlEH3/sHQfj8ZcCfkzXuqgHCZY
// SIG // XPO0EQ/V1cPivNVYeL9IduFEZ22PsEMQD43k+ThivxMB
// SIG // xYWjTMXMslMwlaTW9JZWCLjNXH8Blr5yUmo7Qjd8Fng5
// SIG // k5OUm7Hcsm1BbWfNyW+QPX9FcsEbI9bCVYRm5LPFZgb2
// SIG // 89ZLXq2jK0KKIZL+qG9aJXBigXNjXqC72NzXStM9r4MG
// SIG // OBIdJIct5PwC1j53BLwENrXnd8ucLo0jGLmjwkcd8F3W
// SIG // oXNXBWiap8k3ZR2+6rzYQoNDBaWLpgn/0aGUpk6qPQn1
// SIG // BWy30mRa2Coiwkud8TleTN5IPZs0lpoJX47997FSkc4/
// SIG // ifYcobWpdR9xv1tDXWU9UIFuq/DQ0/yysx+2mZYm9Dx5
// SIG // i1xkzM3uJ5rloMAMcofBbk1a0x7q8ETmMm8c6xdOlMN4
// SIG // ZSA7D0GqH+mhQZ3+sbigZSo04N6o+TzmwTC7wKBjLPxc
// SIG // FgCo0MR/6hGdHgbGpm0yXbQ4CStJB6r97DDa8acvz7f9
// SIG // +tCjhNknnvsBZne5VhDhIG7GrrH5trrINV0zdo7xfCAM
// SIG // KneutaIChrop7rRaALGMq+P5CslUXdS5anSevUiumDGC
// SIG // BBwwggQYAgEBMIGRMH0xCzAJBgNVBAYTAkdCMRswGQYD
// SIG // VQQIExJHcmVhdGVyIE1hbmNoZXN0ZXIxEDAOBgNVBAcT
// SIG // B1NhbGZvcmQxGDAWBgNVBAoTD1NlY3RpZ28gTGltaXRl
// SIG // ZDElMCMGA1UEAxMcU2VjdGlnbyBSU0EgVGltZSBTdGFt
// SIG // cGluZyBDQQIQPRo1cjAVgmMw0BNxfoJBCDANBglghkgB
// SIG // ZQMEAgEFAKCCAVswGgYJKoZIhvcNAQkDMQ0GCyqGSIb3
// SIG // DQEJEAEEMBwGCSqGSIb3DQEJBTEPFw0yMDAzMjMxNDAz
// SIG // NTVaMC8GCSqGSIb3DQEJBDEiBCCMctGdh0Ui0GUMRWgE
// SIG // DoZnLFQbvZbqE6vUIbiqfCpMVzCB7QYLKoZIhvcNAQkQ
// SIG // Agwxgd0wgdowgdcwFgQUJcisc05IULf42RORqBuSSTZl
// SIG // n2EwgbwEFALWW5Xig3DBVwCV+oj5I92Tf62PMIGjMIGO
// SIG // pIGLMIGIMQswCQYDVQQGEwJVUzETMBEGA1UECBMKTmV3
// SIG // IEplcnNleTEUMBIGA1UEBxMLSmVyc2V5IENpdHkxHjAc
// SIG // BgNVBAoTFVRoZSBVU0VSVFJVU1QgTmV0d29yazEuMCwG
// SIG // A1UEAxMlVVNFUlRydXN0IFJTQSBDZXJ0aWZpY2F0aW9u
// SIG // IEF1dGhvcml0eQIQMA9vrN1mmHR8qUY2p3gtuTANBgkq
// SIG // hkiG9w0BAQEFAASCAgC7wH6cl/nSkLRfKvx1cGuHCOS/
// SIG // lTQe+d8juJke6g1ZlGVCDJ7SY3nd+DMkK33wiI3w/STc
// SIG // jf/VMwQGkOuV2rj148Qytio0raORWXtYQ5q8Ryy/348v
// SIG // CuKvDX78GA7RlXOdMfeYeq0AuhQZGtasQy4krvjeTk+Q
// SIG // bOa0gsFfEY5fEyKF8+BFJI5RArBsnDj/dM+9GSHcnq7Z
// SIG // X6gcvu+zqfVPR90iaibQ9PIe33fh2c0nPGsxQNgGPFN+
// SIG // I+plZkJFgR0giLQ1qO2eaSfNPc+veGk2uouHcW2BEfLx
// SIG // t0ZodI8s5Ic3QNu3NQMm16cMyagCFnZAwYg0fQWB8274
// SIG // yJ3dikgJQjlhkiE2ZVyDCySuaw666FFov7TxczhQ+zBY
// SIG // Qo2RcWxR4Un2I5XcfMa2L0FGu8NPKf6FctLmLF4PET+1
// SIG // J1U6UuEbPuUT5SLfR5Uf82JPRNQbpUjUXQzttS2CH2ps
// SIG // 1HsWG/ieQy/jKg/ZQPiXDdAybeo8eDck9iiLFyQJV++H
// SIG // OrHTV12fh96B01nwTwBGw/rUeiA1b9fbLqRnTos9pbGz
// SIG // g95/LTMspfBHvNKus5oFljYYXBNWeqBMqwCy14zK+0QF
// SIG // GvWmKqXtm04xDAQDVMpQI7FitT5jo+Pc+uEZ36jIBTYr
// SIG // LDd/I1XdbBCAJwA9O8fYTcEaCm0a3nBDMzlJx7F7PQ==
// SIG // End signature block
