var topic = "<!DOCTYPE html>\r\n\n<!-- saved from url=(0024)http://docs.autodesk.com -->\r\n<html>\n   <head>\n      <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n      <meta name=\"product\" content=\"VAULT\">\n      <meta name=\"release\" content=\"2021\">\n      <meta name=\"book\" content=\"GeneralUser\">\n      <meta name=\"created\" content=\"2020-03-20\">\n      <meta name=\"topicid\" content=\"GUID-25422729-3007-4E0C-8118-35DBDB159AD6\">\n      <meta name=\"description\" content=\"In addition to understanding and leveraging the basics of search tokens and search properties to return more accurate Vault searches (see Searching a Vault), administrators can also manipulate the &#34;range&#34; of Vault search results users receive by modifying the Lucene &#34;search slop factor&#34; in the web.config file.\">\n      <meta name=\"contextid\" content=\"ID_FINETUNE_SEARCHSLOP\">\n      <meta name=\"topic-type\" content=\"concept\">\n      <meta name=\"audience\" content=\"administrator\">\n      <meta name=\"experiencelevel\" content=\"expert\">\n      <title>Fine-Tune Searches with the Search Slop Factor</title><script language=\"javascript\">var index = \'index.html\';</script><script type=\"text/javascript\" src=\"../scripts/prettify/prettify.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-yaml.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-xq.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-wiki.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-vhdl.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-vb.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-tex.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-sql.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-scala.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-proto.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-n.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-ml.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-lua.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-lisp.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-hs.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-go.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-css.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-clj.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-apollo.js\"></script></head>\n   <body height=\"100%\" onLoad=\"javascript:prettyPrint();\">\n      <div class=\"body_content\" id=\"body-content\" dir=\"ltr\"><a name=\"GUID-25422729-3007-4E0C-8118-35DBDB159AD6\"></a><div class=\"head\">\n            <h1>Fine-Tune Searches with the Search Slop Factor</h1>\n         </div>\n         <p class=\"blurb\">In addition to understanding and leveraging the basics of search tokens and search\n            properties to return more accurate Vault searches (see <span class=\"char_link\"><a href=\"GUID-893F17B8-10C8-4314-BCD9-68C47E688B98.htm\">Searching a Vault</a></span>), administrators can also manipulate the \"range\" of Vault search results users receive\n            by modifying the Lucene \"search slop factor\" in the web.config file. \n            <!--CPM-ContextId = \'ID_FINETUNE_SEARCHSLOP\'--><a name=\"GUID-5AA7390F-425E-48AE-888E-FD7313152279\"></a> \n         </p>\n         <p><a name=\"GUID-7AED9719-4795-4D89-A54F-C7FDA1C2EBFB\"></a>The \"search slop factor\" determines how many positions can occur between any two terms\n            in your search phrase and still be considered a match. These positions range from\n            an exact match of your search string to a number of combinations of this string. \n         </p>\n         <p><a name=\"GUID-F70AC441-F0E5-40D3-9E03-394B99767F2E\"></a>The \"slop\" is an edit-distance, where the distance units are the number of moves the\n            tokens in the query phrase can shift out of position and still be captured in the\n            search. For example, to switch the order of two words in your search requires two\n            moves. The first move places the words atop one another, and the second move re-orders\n            them. So, to permit re-orderings of search strings with two words or tokens, the slop\n            must be set to at least 2. \n         </p>\n         <p><a name=\"GUID-AAFD685A-2828-44E0-97A4-4AA26DAF9BF8\"></a>In simple terms, the slop factor decides how out of order search tokens are permitted\n            to be before they are excluded from search results. By default more exact matches\n            are given precedence, but the total number of search results can be directly affected\n            by this value. \n         </p>\n         <div class=\"section\"><a name=\"SECTION_4BC4AA352FC647119569DC6D1811F106\"></a> \n            <h2><a name=\"GUID-FC3BF2AB-EED1-4D15-95E5-533860632803\"></a>Configure the Slop Factor\n            </h2> <a name=\"OL_E3C290C06FA946D88A6DB4F64D13A1A5\"></a><ol type=\"1\" start=\"1\">\n               <li> \n                  <p><a name=\"GUID-88BF8DA9-3F93-429F-BB1A-58B6D1252B0C\"></a> From the Web.config file (<span class=\"filePath\">C:\\Program Files\\Autodesk\\ADMS Professional 20xx\\Server\\Web\\Services</span>), locate the following two lines: \n                  </p> \n                  <div class=\"codeBlock\"><pre class=\"prettyprint\">!-- slop factor provided to lucene search --&gt;\n\n&lt;add key=\"SearchSlopFactor\" value=\"10\" /&gt;</pre></div> \n               </li>\n               <li>Modify the \"SearchSlopFactor\" value on the ADMS server to change the results returned\n                  by a given search. Depending on the changes you make, you will have a more refined\n                  or open set of search results. \n                  <p><a name=\"GUID-8701009F-2807-4F87-B0E6-1065009FC4A8\"></a>By default the slop value is set to 10. You can set this value as low as 0 for exact\n                     matches only or increase this range to whichever value you desire. \n                  </p> \n                  <div><a name=\"GUID-145C8988-168B-4ABD-8E9F-1907A8F0FF3D\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span> Keep in mind how these changes affect the user search experience. If the value is\n                        too low, users may become frustrated at not finding the correct data. If the value\n                        is too high, users may have too many search results to sort through. \n                     </div>\n                  </div> \n               </li>\n            </ol> \n         </div><a name=\"UL_CCBFC24F28CA453A8E6F283761965ABA\"></a><p class=\"list-intro\"><a name=\"GUID-F63E0FBF-F58D-473C-A4CE-33CA715AE58D\"></a>Example 1: Searching with Multiple Tokens\n         </p>\n         <p><a name=\"GUID-FFAA1FF6-3FF1-4DA6-82AA-BA512FEC06FC\"></a> Let\'s say I want to search for file A-055401-321.ipt. This search is represented\n            by six (6) search tokens: <a name=\"FIG_B35DCF064D484F78A95A5558B31848DA\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-4274C2EF-A490-4726-B568-617A31A8C136-low.png\"></div> \n         </p>\n         <p><a name=\"GUID-EFB92C18-D61E-42ED-8508-4E51014394A6\"></a> If I enter <em class=\"strong\">A-055*</em> as my search criteria and the slop factor is set to 10, I receive any number of additional\n            results similar to the following which meet the slop factor settings: \n         </p>\n         <p><a name=\"GUID-5EC8224F-A507-4724-9B2F-216868ADB7E8\"></a> <a name=\"FIG_335FE3E75C0E4DD6AE367FDD3549AAFE\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-221AE2E9-E49D-46B2-86CD-1D1BA5F5AD50-low.png\"></div> \n         </p>\n         <p><a name=\"GUID-1D9B881E-D971-4E23-97EF-61F1B541623F\"></a> If I enter A-055* as my search criteria but the <em class=\"strong\">Slop Factor = 6</em>, the exact same results are returned because the tokens are still within the \"edit\n            distance\" set by the slop factor. \n         </p>\n         <p><a name=\"GUID-01463B97-20B1-4B34-AB30-5780D08C401A\"></a> <a name=\"FIG_7CAE4CFD184A4965BF23EA6BA2CEC3BE\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-E53DC340-A82F-402B-8C08-3934B3563ABA-low.png\"></div> \n         </p>\n         <p><a name=\"LI_2DF7C0DAA2894DDBA0C32684A0B89B4E\"></a> However, if I enter <em class=\"strong\">A-055*</em> as my search criteria but the <em class=\"strong\">Slop Factor = 4</em>, the results are reduced to 5. The reason I no longer get B-055401-321.ipt in my\n            results is because the tokens in B-055401-321-A.ipt are spread too far apart to meet\n            the slop restriction or edit distance. Starting from the first dash we would have\n            to move \"A\" 5 positions to match A-055*. \n         </p>\n         <p><a name=\"GUID-7583B079-E807-447E-8B84-0876EE537637\"></a> <a name=\"FIG_21FFD2CC096C4356916DC6CFFDB3AABF\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-66C4EF15-BF6E-4EF3-AFE5-6F45609EDFEA-low.png\"></div> \n         </p>\n         <p><a name=\"GUID-0F4D7A9E-CB32-4DF7-9256-15F0493EA761\"></a> If I enter<em class=\"strong\"> A-055*</em> as my search criteria but the <em class=\"strong\">Slop Factor = 2</em>, there are only 4 results. \n         </p>\n         <div><a name=\"GUID-B9D7E2AD-7108-4DCD-91F8-45764D05F860\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span>A setting of 2 is the minimum value for the system to return search tokens out of\n               order. \n            </div>\n         </div>\n         <p><a name=\"GUID-8E4BC168-D3DD-4580-BAAC-6732FD8F1D3A\"></a>B-321-<span class=\"charspan-emphasis\">055</span>401-<span class=\"charspan-emphasis\">A</span>.ipt is omitted as the \"A\" would need to move 3 positions to match the search phrase\n            A-055*. \n         </p>\n         <p><a name=\"GUID-74343AC3-0696-436E-880B-6A02FBC71CFD\"></a> <a name=\"FIG_988BFA4A2ABB4BA2ADBFF00275C661C3\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-03944021-1E88-423D-8DDB-3061F5A81F40-low.png\"></div> \n         </p>\n         <p><a name=\"GUID-688154AD-9DE1-454C-ACEC-C2DB7D14BF6A\"></a> Finally, if I enter <em class=\"strong\">A-055*</em> as my search criteria but the <em class=\"strong\">Slop Factor = 0</em>, only exact token matches are returned. \n         </p>\n         <p><a name=\"GUID-B4506156-CE56-47D0-8775-ADE9AEDF8DDA\"></a> <a name=\"FIG_47850C8BE5B344F1B2B72481E7993E01\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-7A08B850-AE00-461D-9D62-B669C3CB1F47-low.png\"></div> \n         </p><a name=\"UL_510FCFCF0D314A1B994C6FCCDE1AF5E0\"></a><p class=\"list-intro\"><a name=\"GUID-EEDF77BB-42E8-4EE5-BE41-E9D3D307CC9C\"></a>Example 2: Searching with Fewer Tokens \n         </p>\n         <p><a name=\"GUID-B74A5C0B-F63A-406C-9493-1B8622C7D71A\"></a>What happens if I repeat the search with fewer tokens? This time I will search for\n            <em class=\"strong\">A055*</em>. \n         </p>\n         <div><a name=\"GUID-FF871867-6620-453D-A574-42AEB58A608F\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span>The dash is removed and, therefore, the number of tokens is reduced. \n            </div>\n         </div>\n         <p><a name=\"GUID-0FA5C703-7311-4CDC-ACBF-A0827DDD26F2\"></a> If I enter <em class=\"strong\">A055*</em> as my search criteria with <em class=\"strong\">Slop Factor = 5</em>, I receive 6 results because I have effectively reduced the number of positions required\n            to move the tokens for a match. The slop factor does not need to be as high to return\n            6 results: \n         </p>\n         <p><a name=\"GUID-019FCC30-E9A7-4751-85E3-E9C101A400C6\"></a> <a name=\"FIG_E318CED2D33746299DDC6FDB6AAAF70A\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-90872A4C-DFD5-4629-B0BA-2E2FB9318AB9-low.png\"></div> \n         </p>\n         <p><a name=\"SECTION_DD8383CEE9E240ACB20AB0A1DC50EF95\"></a> If I enter <em class=\"strong\">A055*</em> as my search criteria with Slop Factor = 3, I receive 5 results. Once again, the\n            edit distance is shorter than it was in the previous example, but the results are\n            the same with B-055401-321-A.ipt being excluded: \n         </p>\n         <p><a name=\"GUID-A44D3C40-AEEB-481D-9976-40278C7DB73A\"></a> <a name=\"FIG_D4B699A62EF84B888C9261733AF75F14\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-A17FEF6D-08A9-4E2E-9662-1813EBC7B3F3-low.png\"></div> \n         </p>\n         <p><a name=\"GUID-96731E99-9A59-4ED2-8F63-BBE57D509866\"></a> If I enter <em class=\"strong\">A055*</em> as my search criteria with <em class=\"strong\">Slop Factor = 1</em>, there are only 2 results. \n         </p>\n         <p><a name=\"GUID-BEC45ECB-ACF5-4D92-81FF-0B702CCC9BCF\"></a> <a name=\"FIG_FE5B665B965E4E0ABAC1C59DECAEA8F7\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-7124F769-4C79-4DB0-90C9-E8543396E827-low.png\"></div> \n         </p>\n         <p><a name=\"SECTION_85DD42A65222436BAC5729F7A742F485\"></a> However now with the \"-\" character removed, my search for file names containing <em class=\"strong\">A055*</em> with <em class=\"strong\">Slop Factor = 0</em> yields <span class=\"charspan-emphasis\">NO</span> results–there are no exact matches in this case. \n         </p>\n         <div class=\"footer-block\"><a href=\"..\" class=\"comments-anchor\" target=\"_blank\"><span class=\"comments-link\">Please send us your comment about this page</span></a></div><br><p class=\"footer-license-block\"><a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\"><img alt=\"Creative Commons License\" style=\"border-width: 0;\" src=\"../images/ccLink.png\"></a>&nbsp;<em>Except where otherwise noted, this work is licensed under a <a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\">Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License</a>. Please see the <a href=\"http://autodesk.com/creativecommons\" target=\"_blank\">Autodesk Creative Commons FAQ</a> for more information.</em></p><br></div>\n   </body>\n</html>";
// SIG // Begin signature block
// SIG // MIIZfQYJKoZIhvcNAQcCoIIZbjCCGWoCAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // BNS7bNjz0XUFA6UjkV8DSFMLaHgxuXIqMJMfIgq7Xiqg
// SIG // ggoaMIIEyzCCA7OgAwIBAgIQCQja65wGHi65un4mqmKH
// SIG // ijANBgkqhkiG9w0BAQsFADCBhDELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTUw
// SIG // MwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
// SIG // b2RlIFNpZ25pbmcgQ0EgLSBHMjAeFw0xOTA1MTQwMDAw
// SIG // MDBaFw0yMDA1MTMyMzU5NTlaMHwxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIDApDYWxpZm9ybmlhMRMwEQYDVQQHDApT
// SIG // YW4gUmFmYWVsMRcwFQYDVQQKDA5BdXRvZGVzaywgSW5j
// SIG // LjERMA8GA1UECwwIU2VjdXJpdHkxFzAVBgNVBAMMDkF1
// SIG // dG9kZXNrLCBJbmMuMIIBIjANBgkqhkiG9w0BAQEFAAOC
// SIG // AQ8AMIIBCgKCAQEAkVKRoPYsoxPdlabspcuG8HYDfcWQ
// SIG // 9qyPOT2punwpVdjt2slktcpSTlydrGy8ijcbl5/k8AOJ
// SIG // afKMQvow0fNjIoNB5nsb8j2xFJPbBhHl8GT4P6DZ1OWK
// SIG // ioiUXgGHKjctUws49J4elntqvBYhKCbuPqG772QCoYFU
// SIG // P7qcFbh3PbyNB6cnKMn2vNGRqiEtV2aGg+/MiL3QPsvT
// SIG // kTWhVuTLIvwZ4kK5C5ACiQzlGOlE+C7gWuFoxtvy6gUa
// SIG // A8JAq/xLjYKwFevQwGncg3s1cuiGhx0P7Rvn6oCd2cem
// SIG // FmbK3I3rMRt+jc9wzAj3oHxvCo4f5Lfva+OpC1dETUVV
// SIG // sk0VGwIDAQABo4IBPjCCATowCQYDVR0TBAIwADAOBgNV
// SIG // HQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMw
// SIG // YQYDVR0gBFowWDBWBgZngQwBBAEwTDAjBggrBgEFBQcC
// SIG // ARYXaHR0cHM6Ly9kLnN5bWNiLmNvbS9jcHMwJQYIKwYB
// SIG // BQUHAgIwGQwXaHR0cHM6Ly9kLnN5bWNiLmNvbS9ycGEw
// SIG // HwYDVR0jBBgwFoAU1MAGIknrOUvdk+JcobhHdglyA1gw
// SIG // KwYDVR0fBCQwIjAgoB6gHIYaaHR0cDovL3JiLnN5bWNi
// SIG // LmNvbS9yYi5jcmwwVwYIKwYBBQUHAQEESzBJMB8GCCsG
// SIG // AQUFBzABhhNodHRwOi8vcmIuc3ltY2QuY29tMCYGCCsG
// SIG // AQUFBzAChhpodHRwOi8vcmIuc3ltY2IuY29tL3JiLmNy
// SIG // dDANBgkqhkiG9w0BAQsFAAOCAQEA0Q2+iVSEfT4xGq3A
// SIG // OADVb0rT5Z8E+PPb1x6hKknSzuaZKk/acDz9mdnFajaU
// SIG // WgIKiFJlsqJnuAM1w4lqKaEWsz3DoxvGIEwexj71Ud6a
// SIG // KlBJNcR9DdkXUZwMhbw9d78rjJAIX6tOwfSludZfdq8b
// SIG // YEkuIzQi9uYW9vHVPSCzhnUBKjwc9qTo9yBc7Fcn4FAT
// SIG // 90DzWM2hS9oc3p0pprYI2I/O4th90BEmwWkVqVgfaR0z
// SIG // VyIEmBbqB/IWLfjUBZJ/8sbkwWuWlYVRrfPxsj1e9qvb
// SIG // wE3Y28jWyGbqoUG39GhXk3uT8R8i3+T6M0c4rMfdifBC
// SIG // pceCaFTJzSye7LoeVzCCBUcwggQvoAMCAQICEHwbNTVK
// SIG // 59t050FfEWnKa6gwDQYJKoZIhvcNAQELBQAwgb0xCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjEfMB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29y
// SIG // azE6MDgGA1UECxMxKGMpIDIwMDggVmVyaVNpZ24sIElu
// SIG // Yy4gLSBGb3IgYXV0aG9yaXplZCB1c2Ugb25seTE4MDYG
// SIG // A1UEAxMvVmVyaVNpZ24gVW5pdmVyc2FsIFJvb3QgQ2Vy
// SIG // dGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMTQwNzIyMDAw
// SIG // MDAwWhcNMjQwNzIxMjM1OTU5WjCBhDELMAkGA1UEBhMC
// SIG // VVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9u
// SIG // MR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3Jr
// SIG // MTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1
// SIG // NiBDb2RlIFNpZ25pbmcgQ0EgLSBHMjCCASIwDQYJKoZI
// SIG // hvcNAQEBBQADggEPADCCAQoCggEBANeVQ9Tc32euOftS
// SIG // pLYmMQRw6beOWyq6N2k1lY+7wDDnhthzu9/r0XY/ilaO
// SIG // 6y1L8FcYTrGNpTPTC3Uj1Wp5J92j0/cOh2W13q0c8fU1
// SIG // tCJRryKhwV1LkH/AWU6rnXmpAtceSbE7TYf+wnirv+9S
// SIG // rpyvCNk55ZpRPmlfMBBOcWNsWOHwIDMbD3S+W8sS4duM
// SIG // xICUcrv2RZqewSUL+6McntimCXBx7MBHTI99w94Zzj7u
// SIG // BHKOF9P/8LIFMhlM07Acn/6leCBCcEGwJoxvAMg6ABFB
// SIG // ekGwp4qRBKCZePR3tPNgKuZsUAS3FGD/DVH0qIuE/iHa
// SIG // XF599Sl5T7BEdG9tcv8CAwEAAaOCAXgwggF0MC4GCCsG
// SIG // AQUFBwEBBCIwIDAeBggrBgEFBQcwAYYSaHR0cDovL3Mu
// SIG // c3ltY2QuY29tMBIGA1UdEwEB/wQIMAYBAf8CAQAwZgYD
// SIG // VR0gBF8wXTBbBgtghkgBhvhFAQcXAzBMMCMGCCsGAQUF
// SIG // BwIBFhdodHRwczovL2Quc3ltY2IuY29tL2NwczAlBggr
// SIG // BgEFBQcCAjAZGhdodHRwczovL2Quc3ltY2IuY29tL3Jw
// SIG // YTA2BgNVHR8ELzAtMCugKaAnhiVodHRwOi8vcy5zeW1j
// SIG // Yi5jb20vdW5pdmVyc2FsLXJvb3QuY3JsMBMGA1UdJQQM
// SIG // MAoGCCsGAQUFBwMDMA4GA1UdDwEB/wQEAwIBBjApBgNV
// SIG // HREEIjAgpB4wHDEaMBgGA1UEAxMRU3ltYW50ZWNQS0kt
// SIG // MS03MjQwHQYDVR0OBBYEFNTABiJJ6zlL3ZPiXKG4R3YJ
// SIG // cgNYMB8GA1UdIwQYMBaAFLZ3+mlIR59TEtXC6gcydgfR
// SIG // lwcZMA0GCSqGSIb3DQEBCwUAA4IBAQB/68qn6ot2Qus+
// SIG // jiBUMOO3udz6SD4Wxw9FlRDNJ4ajZvMC7XH4qsJVl5Fw
// SIG // g/lSflJpPMnx4JRGgBi7odSkVqbzHQCR1YbzSIfgy8Q0
// SIG // aCBetMv5Be2cr3BTJ7noPn5RoGlxi9xR7YA6JTKfRK9u
// SIG // QyjTIXW7l9iLi4z+qQRGBIX3FZxLEY3ELBf+1W5/muJW
// SIG // kvGWs60t+fTf2omZzrI4RMD3R3vKJbn6Kmgzm1By3qif
// SIG // 1M0sCzS9izB4QOCNjicbkG8avggVgV3rL+JR51EeyXgp
// SIG // 5x5lvzjvAUoBCSQOFsQUecFBNzTQPZFSlJ3haO8I8OJp
// SIG // nGdukAsak3HUJgLDwFojMYIOuzCCDrcCAQEwgZkwgYQx
// SIG // CzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRlYyBD
// SIG // b3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1
// SIG // c3QgTmV0d29yazE1MDMGA1UEAxMsU3ltYW50ZWMgQ2xh
// SIG // c3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENBIC0gRzIC
// SIG // EAkI2uucBh4uubp+Jqpih4owDQYJYIZIAWUDBAIBBQCg
// SIG // fDAQBgorBgEEAYI3AgEMMQIwADAZBgkqhkiG9w0BCQMx
// SIG // DAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4wDAYK
// SIG // KwYBBAGCNwIBFTAvBgkqhkiG9w0BCQQxIgQgaLzoTo8A
// SIG // sg5bihzG6wVeePRQgbYKeJTLrZpY7s2OdREwDQYJKoZI
// SIG // hvcNAQEBBQAEggEAihTbP9LV/4MJFvRZWOEySSFPI/Ek
// SIG // GzHIfGVFJ1e/uD6ppcrYnBemcJnHoFvO2bf06j4bSrE7
// SIG // Hu1AjQNcgg+IfmSThU7bZeodd/+eXxrmcdZ347N6RI5d
// SIG // AeO8QMdlDSmtDAn1vqCg8k44r5gLcYs4r3ZmInzoUi4C
// SIG // w62P13PmGmtTdI+58eGroJXf1wvIavVGizgHhca2JRpR
// SIG // xwHHiXnhpw2Ub+DIJhDly7ALA1uCWt4ti21mwOUbmbx/
// SIG // KLZr60Hwk77Jf5di6iGyGADQlaxOYczzeCfODHiRfVNC
// SIG // 0MSnlc8rPsv5Cw0N5S62Um5xIwgdsjEft3KArNHw2yQz
// SIG // XjjKY6GCDHQwggxwBgorBgEEAYI3AwMBMYIMYDCCDFwG
// SIG // CSqGSIb3DQEHAqCCDE0wggxJAgEDMQ8wDQYJYIZIAWUD
// SIG // BAIBBQAwga8GCyqGSIb3DQEJEAEEoIGfBIGcMIGZAgEB
// SIG // BgkrBgEEAaAyAgMwMTANBglghkgBZQMEAgEFAAQgFWQq
// SIG // Bky7rlBdA4KMq7O08Pj/k2GbfelQMpWsvwr1pJcCFBye
// SIG // nLjV+2EcZlQNOy+dE1xNlQmoGA8yMDIwMDMyMzE0MDMx
// SIG // MFqgL6QtMCsxKTAnBgNVBAMMIEdsb2JhbFNpZ24gVFNB
// SIG // IGZvciBBZHZhbmNlZCAtIEcyoIII0zCCBLYwggOeoAMC
// SIG // AQICDAynz10HBySsieeaOjANBgkqhkiG9w0BAQsFADBb
// SIG // MQswCQYDVQQGEwJCRTEZMBcGA1UEChMQR2xvYmFsU2ln
// SIG // biBudi1zYTExMC8GA1UEAxMoR2xvYmFsU2lnbiBUaW1l
// SIG // c3RhbXBpbmcgQ0EgLSBTSEEyNTYgLSBHMjAeFw0xODAy
// SIG // MTkwMDAwMDBaFw0yOTAzMTgxMDAwMDBaMCsxKTAnBgNV
// SIG // BAMMIEdsb2JhbFNpZ24gVFNBIGZvciBBZHZhbmNlZCAt
// SIG // IEcyMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKC
// SIG // AQEAt8eSiijY85HLUA1d6ylEwYJZpcpkzr2DtVHllMxu
// SIG // gJoXbNz/YuY2Q14Bwgxkjcp3nvZdd0W5Xsgk60E3EWY3
// SIG // rMjNdJvMs+9M4n8bznO+yZadNR5891T3bOygEtaumZ1j
// SIG // xHhfWakuIvXDJ9iyW0VjJ5D/jLE9qbTzDsDxIGUGiZ0D
// SIG // HKOwUkGFNOu8y85U9hL+swGJSqb6VMUf+9McwOO/l+M/
// SIG // 0Bv5QMcb1esmfEMwx3DyeBGqhU6lDg0ASjoRd6PKIwGA
// SIG // nsiTVl1GzIrY0qoKhIWyiVvVMs5BexhOVMqr0VJeEtMk
// SIG // nlbzDI/dvZKOedVBicOjoOWR/MdnnYczznEycwIDAQAB
// SIG // o4IBqDCCAaQwDgYDVR0PAQH/BAQDAgeAMEwGA1UdIARF
// SIG // MEMwQQYJKwYBBAGgMgEeMDQwMgYIKwYBBQUHAgEWJmh0
// SIG // dHBzOi8vd3d3Lmdsb2JhbHNpZ24uY29tL3JlcG9zaXRv
// SIG // cnkvMAkGA1UdEwQCMAAwFgYDVR0lAQH/BAwwCgYIKwYB
// SIG // BQUHAwgwRgYDVR0fBD8wPTA7oDmgN4Y1aHR0cDovL2Ny
// SIG // bC5nbG9iYWxzaWduLmNvbS9ncy9nc3RpbWVzdGFtcGlu
// SIG // Z3NoYTJnMi5jcmwwgZgGCCsGAQUFBwEBBIGLMIGIMEgG
// SIG // CCsGAQUFBzAChjxodHRwOi8vc2VjdXJlLmdsb2JhbHNp
// SIG // Z24uY29tL2NhY2VydC9nc3RpbWVzdGFtcGluZ3NoYTJn
// SIG // Mi5jcnQwPAYIKwYBBQUHMAGGMGh0dHA6Ly9vY3NwMi5n
// SIG // bG9iYWxzaWduLmNvbS9nc3RpbWVzdGFtcGluZ3NoYTJn
// SIG // MjAdBgNVHQ4EFgQULW5u0Y3lA4Du52Ppp9naCzxXIj0w
// SIG // HwYDVR0jBBgwFoAUkiGnSpVdZLCbtB7mADdH5p1BK0ww
// SIG // DQYJKoZIhvcNAQELBQADggEBAI39HR+PiNNl+LVcRumn
// SIG // 07Y/SstDBcIHDcNeA4QjN6h6jJcj/yechH1h61xLVz6b
// SIG // 9ETbgFj3tmXejxIKX6eHdLfaFECHUeyfSkdV8BfoGD5x
// SIG // IDHmKCKrTvaunGvC50T7aA0gf1M/lBuhhoJOMhYQWj+J
// SIG // WMHQtNu2kPuNMumhS0ZQN7bDOukpJBKSWk4rubYKejaM
// SIG // l8DviXwz3jHhoZfk50WtYVL9WonTVH6KTVuJew6Wd9Hy
// SIG // PDgb2vmlYSBlArzFrdcMYhAoLN2246hhAKwIJqONhdBk
// SIG // yTaQHopSyYeNNaVdSJH8k6alZfHs+TrcpSyeBG1iM/7e
// SIG // +p/Fzq+V81Go8s4wggQVMIIC/aADAgECAgsEAAAAAAEx
// SIG // icZQBDANBgkqhkiG9w0BAQsFADBMMSAwHgYDVQQLExdH
// SIG // bG9iYWxTaWduIFJvb3QgQ0EgLSBSMzETMBEGA1UEChMK
// SIG // R2xvYmFsU2lnbjETMBEGA1UEAxMKR2xvYmFsU2lnbjAe
// SIG // Fw0xMTA4MDIxMDAwMDBaFw0yOTAzMjkxMDAwMDBaMFsx
// SIG // CzAJBgNVBAYTAkJFMRkwFwYDVQQKExBHbG9iYWxTaWdu
// SIG // IG52LXNhMTEwLwYDVQQDEyhHbG9iYWxTaWduIFRpbWVz
// SIG // dGFtcGluZyBDQSAtIFNIQTI1NiAtIEcyMIIBIjANBgkq
// SIG // hkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqpuOw6sRUSUB
// SIG // tpaU4k/YwQj2RiPZRcWVl1urGr/SbFfJMwYfoA/GPH5T
// SIG // SHq/nYeer+7DjEfhQuzj46FKbAwXxKbBuc1b8R5EiY7+
// SIG // C94hWBPuTcjFZwscsrPxNHaRossHbTfFoEcmAhWkkJGp
// SIG // eZ7X61edK3wi2BTX8QceeCI2a3d5r6/5f45O4bUIMf3q
// SIG // 7UtxYowj8QM5j0R5tnYDV56tLwhG3NKMvPSOdM7IaGlR
// SIG // dhGLD10kWxlUPSbMQI2CJxtZIH1Z9pOAjvgqOP1roEBl
// SIG // H1d2zFuOBE8sqNuEUBNPxtyLufjdaUyI65x7MCb8eli7
// SIG // WbwUcpKBV7d2ydiACoBuCQIDAQABo4HoMIHlMA4GA1Ud
// SIG // DwEB/wQEAwIBBjASBgNVHRMBAf8ECDAGAQH/AgEAMB0G
// SIG // A1UdDgQWBBSSIadKlV1ksJu0HuYAN0fmnUErTDBHBgNV
// SIG // HSAEQDA+MDwGBFUdIAAwNDAyBggrBgEFBQcCARYmaHR0
// SIG // cHM6Ly93d3cuZ2xvYmFsc2lnbi5jb20vcmVwb3NpdG9y
// SIG // eS8wNgYDVR0fBC8wLTAroCmgJ4YlaHR0cDovL2NybC5n
// SIG // bG9iYWxzaWduLm5ldC9yb290LXIzLmNybDAfBgNVHSME
// SIG // GDAWgBSP8Et/qC5FJK5NUPpjmove4t0bvDANBgkqhkiG
// SIG // 9w0BAQsFAAOCAQEABFaCSnzQzsm/NmbRvjWek2yX6AbO
// SIG // MRhZ+WxBX4AuwEIluBjH/NSxN8RooM8oagN0S2OXhXdh
// SIG // O9cv4/W9M6KSfREfnops7yyw9GKNNnPRFjbxvF7stICY
// SIG // ePzSdnno4SGU4B/EouGqZ9uznHPlQCLPOc7b5neVp7uy
// SIG // y/YZhp2fyNSYBbJxb051rvE9ZGo7Xk5GpipdCJLxo/Md
// SIG // dL9iDSOMXCo4ldLA1c3PiNofKLW6gWlkKrWmotVzr9xG
// SIG // 2wSukdduxZi61EfEVnSAR3hYjL7vK/3sbL/RlPe/UOB7
// SIG // 4JD9IBh4GCJdCC6MHKCX8x2ZfaOdkdMGRE4EbnocIOM2
// SIG // 8LZQuTGCAqgwggKkAgEBMGswWzELMAkGA1UEBhMCQkUx
// SIG // GTAXBgNVBAoTEEdsb2JhbFNpZ24gbnYtc2ExMTAvBgNV
// SIG // BAMTKEdsb2JhbFNpZ24gVGltZXN0YW1waW5nIENBIC0g
// SIG // U0hBMjU2IC0gRzICDAynz10HBySsieeaOjANBglghkgB
// SIG // ZQMEAgEFAKCCAQ4wGgYJKoZIhvcNAQkDMQ0GCyqGSIb3
// SIG // DQEJEAEEMBwGCSqGSIb3DQEJBTEPFw0yMDAzMjMxNDAz
// SIG // MTBaMC8GCSqGSIb3DQEJBDEiBCCUny8CsgfdFtIvC7yF
// SIG // 4sMkyEWg5n4+0XxaCAhAeenVCDCBoAYLKoZIhvcNAQkQ
// SIG // AgwxgZAwgY0wgYowgYcEFJsSBXrnKq/21jdytJ9qI28m
// SIG // Sc2pMG8wX6RdMFsxCzAJBgNVBAYTAkJFMRkwFwYDVQQK
// SIG // ExBHbG9iYWxTaWduIG52LXNhMTEwLwYDVQQDEyhHbG9i
// SIG // YWxTaWduIFRpbWVzdGFtcGluZyBDQSAtIFNIQTI1NiAt
// SIG // IEcyAgwMp89dBwckrInnmjowDQYJKoZIhvcNAQEBBQAE
// SIG // ggEARPyctNiDrx1Ef3U7qmLxcPNZ7Eu/P+PXKfn2GYIY
// SIG // BUGRWwRyXnTWDmRGns5Qc6hAkJeREN+1oWQuZFcRDD1N
// SIG // siQXIutsA5i0mMs49a5yFLz/NOupR7AQVhQlENN0CPHi
// SIG // wP53oA7gzFPVe8SL9/yOGtKPRLbWYP36LsM5LcQ+kfta
// SIG // 61DgcUipqbmw4BYvpfLjyhR4gFdL2ksslgZUC+dEmCT0
// SIG // YK88Nq0ATqnFA26OfMHXYcXaF1MwrMWMQv/wrWvrI+Rb
// SIG // J1ikA+SK8bEChHfRh994umU+uclVDak+nmgjt6iL6jHP
// SIG // h6XVBu/gluAW4kZjnb7ClSeWIHmtBDk7fb4VBw==
// SIG // End signature block
