var topic = "<!DOCTYPE html>\r\n\n<!-- saved from url=(0024)http://docs.autodesk.com -->\r\n<html>\n   <head>\n      <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n      <meta name=\"product\" content=\"VAULT\">\n      <meta name=\"release\" content=\"2021\">\n      <meta name=\"book\" content=\"GeneralUser\">\n      <meta name=\"created\" content=\"2020-03-20\">\n      <meta name=\"topicid\" content=\"GUID-244DFF1D-7473-41D8-AA7D-43A3FB25D17F\">\n      <meta name=\"description\" content=\"The dialogs and tabs that come with Data Standard automatically support twelve different languages.\">\n      <meta name=\"topic-type\" content=\"concept\">\n      <meta name=\"audience\" content=\"administrator\">\n      <meta name=\"experiencelevel\" content=\"general\">\n      <title>Data Standard and Localization</title><script language=\"javascript\">var index = \'index.html\';</script><script type=\"text/javascript\" src=\"../scripts/prettify/prettify.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-yaml.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-xq.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-wiki.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-vhdl.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-vb.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-tex.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-sql.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-scala.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-proto.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-n.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-ml.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-lua.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-lisp.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-hs.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-go.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-css.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-clj.js\"></script><script type=\"text/javascript\" src=\"../scripts/prettify/lang-apollo.js\"></script></head>\n   <body height=\"100%\" onLoad=\"javascript:prettyPrint();\">\n      <div class=\"body_content\" id=\"body-content\" dir=\"ltr\"><a name=\"GUID-244DFF1D-7473-41D8-AA7D-43A3FB25D17F\"></a><div class=\"head\">\n            <h1>Data Standard and Localization</h1>\n         </div>\n         <p class=\"blurb\"> The dialogs and tabs that come with Data Standard automatically support twelve different\n            languages. \n            \n         </p>\n         <p> Text strings for these languages are defined in XML files. The files are located\n            here: \n            	 \n         </p>\n         <p><span class=\"filePath\">C:\\ProgramData\\Autodesk\\&lt;Vault version&gt;\\Extensions\\DataStandard\\&lt;localization folder&gt;</span> \n         </p>\n         <p>where \n            		<em class=\"mild\">&lt;language code&gt;</em> is the folder name for a language (e.g., en-US, de-DE, it-IT). \n            	 \n         </p>\n         <p>Each language folder contains two files: \n            	 <a name=\"UL_6E4529900666487F89EDC7AA170CCE95\"></a><ul>\n               <li><span class=\"filePath\"> UIStrings.xml</span>–Contains strings that are visible in dialogs, tabs, and menus. \n                  		\n               </li>\n               <li><span class=\"filePath\">PropertyTranslations.xml</span>–Contains mapping for Vault properties, from a language independent property name\n                  to the real property name in the Vault database. \n                  		\n               </li>\n            </ul> \n         </p>\n         <p>These files can be extended to support different languages in customized Data Standard\n            dialogs. \n            	 \n         </p>\n         <div class=\"section\"><a name=\"SECTION_F008132208344E6BB51A46770C65C466\"></a> \n            <h2><a name=\"GUID-EB9F4FAD-1B04-407D-8FA1-3147A9C4C17E\"></a>How Is the Language Determined?\n            </h2> <a name=\"UL_F168529E0A3C4114859239E3C47D494F\"></a><p class=\"list-intro\">Vault Client</p>\n            <p> By default, the language used for the Data Standard UI strings and the property translations\n               is the same as the Vault client that is installed. However, this can be overridden\n               by modifying the \n               		  <span class=\"filePath\">DSLanguages.xml \n                  		  </span>file located at: \n               		\n            </p>\n            <p><span class=\"filePath\">C:\\ProgramData\\Autodesk\\&lt;Vault version&gt;\\Extensions\\DataStandard\\Vault</span>. \n               		\n            </p>\n            <p>Set the \n               		  <span class=\"filePath\">DSLanguages.xml \n                  		  </span>correctly: Change the DB Language manually to the language of the server, for example\n               en-US. Leave the Language Code ID=UI blank: It enables Vault Client to read property\n               labels, messages and headers from the source based on the active language pack (for\n               example, to read values from de-DE\\UIString.xml). \n               		\n            </p>\n            <p> \n               <div class=\"codeBlock\"><pre class=\"prettyprint\">\n  \n&lt;Language_Code ID=\"DB\"&gt;en-US&lt;/Language_Code&gt;\n    &lt;Language_Code ID=\"UI\"&gt;&lt;/Language_Code&gt;\n    </pre></div> \n            </p>\n            <p>Change Category values – \n               		  <span class=\"filePath\"> UIStrings.xml</span>: Category names in the Category Combobox VDS dialogs aren\'t displayed when the language\n               of Client is different from the language of the server. Therefore, we recommend changing\n               the Category names in the UIStrings.xml to the Category names that correspond with\n               the language of vault server. See picture below: \n               		\n            </p>\n            <p> <a name=\"FIG_03A8FA29B3E54E9FA3B18F69054374F1\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-22D412CC-9CF6-4276-9A32-0B0CD15C27AC-low.png\"></div> \n            </p> <a name=\"UL_9FE72D21222A4D0A9AA44623985C5F6D\"></a><p class=\"list-intro\">CAD</p>\n            <p> For Inventor and AutoCAD, the language is determined automatically and cannot be\n               set. Data Standard tries to use the same language that the CAD application uses. If\n               the CAD application uses a language that is not supported by Data Standard, English\n               is used as fallback. \n               		\n            </p>\n            <p> The Vault database language is not relevant for the CAD applications because Data\n               Standard uses mapped properties (Inventor iProperties, AutoCAD DWG properties, and\n               block attributes). \n               		\n            </p> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_1B6A9ABEAB4C4B1ABF2E4586FDB9AD2A\"></a> \n            <h2><a name=\"GUID-317AC476-89A5-4EBE-9152-02C9E6FCABF4\"></a>UI Strings\n            </h2> \n            <p>Sample: \n               		  <span class=\"filePath\">UIStrings.xml</span> \n            </p> \n            <p> \n               <div class=\"codeBlock\"><pre class=\"prettyprint\">&lt;?xml version=\"1.0\" encoding=\"utf-8\"?&gt;\n  \n&lt;UIStrings LanguageCode=\"en-US\"&gt;\n    &lt;!--Labels used in XAMLs--&gt;\n    &lt;UIString ID=\"LBL1\"&gt;Folder&lt;/UIString&gt;\n    &lt;UIString ID=\"LBL2\"&gt;Title&lt;/UIString&gt;\n    &lt;UIString ID=\"LBL3\"&gt;Description&lt;/UIString&gt;\n...\n&lt;/UIStrings&gt;</pre></div> \n            </p> \n            <p>The XML file contains a \n               		  <span class=\"code\">&lt;UIStrings&gt;</span> element with an attribute \n               		  <span class=\"code\">LanguageCode</span> to specify the language. The \n               		  <span class=\"code\">&lt;UIStrings&gt;</span> element is a collection of \n               		  <span class=\"code\">&lt;UIString&gt;</span> elements. The attribute ID has to be unique. For your own strings, Autodesk recommends\n               that you use a prefix (e.g., \n               		  <span class=\"code\">ID=\"MYPREFIX_LBL1\"</span>). The value of the element is the text string. \n               		\n            </p> <a name=\"UL_B018BD19DEC04490BB0A14AB2CF90CBC\"></a><p class=\"list-intro\">How to Use UI Strings</p>\n            <p> The UI strings can be used in different Data Standard components by using the following\n               expressions: \n               		\n            </p>\n            <ul>\n               <li>XAML Files: \n                  		  <span class=\"code\">UIString[&lt;ID&gt;]</span> \n                  <p>For example, \n                     			 <span class=\"code\">&lt;Label Content=\"{Binding UISTring[LBL2]}\"/&gt;</span> \n                  </p> \n                  <p>The above sample looks in the \n                     			 <span class=\"filePath\">UIStrings.xml</span> (based on the used language) for a \n                     			 <span class=\"code\">&lt;UIString&gt;</span> element with the ID LBL2 and returns the Title string and displays this as a label\n                     in the dialog. \n                     		  \n                  </p> \n               </li>\n               <li>PowerShell files: \n                  		  <span class=\"code\">$UIString[\"&lt;ID&gt;\"]</span> \n               </li>\n               <li> \n                  <p>MenuDefinitions.xml File: \n                     			 <span class=\"code\">$UIString[&lt;ID&gt;]</span>. The MNU file was replaced the with the MenuDefinitions.xml file in VDS 2017. \n                     		  \n                  </p> \n                  <p>This can be used in variables \n                     			 <span class=\"code\">Description</span>, \n                     			 <span class=\"code\">Hint</span>, \n                     			 <span class=\"code\">Label</span>, and \n                     			 <span class=\"code\">NavigationTypes</span> of a menu item definition. See \n                     			 <span class=\"char_link\"><a href=\"GUID-02BAAA7C-330F-4B21-8D9D-8D4BB27AC428.htm\">MenuDefinitions.xml-File</a></span> for more information. \n                     		  \n                  </p> \n               </li>\n               <li>Labeling in Dynamic Category Properties Grid. By default, the first column in Dynamic\n                  Category Grid lists the property name (System Name). \n                  		  <a name=\"UL_A11668413A8145FBB237746DB6080CD2\"></a><ul>\n                     <li> \n                        <p>Note that for Vault Client Data Standard the label is pulled from the \n                           				  <span class=\"code\">$UIString[&lt;ID&gt;]</span> which has a mapping to the ‘System Name’. To review the system name of a user-defined\n                           property, add the “System Name” column “System to the grid in: Vault Administration\n                           &gt; Behaviors &gt; Properties &gt; Create/Edit Property. \n                           				\n                        </p> \n                     </li>\n                     <li> \n                        <p> For Data Standard for Inventor and AutoCAD the label is pulled from the \n                           				  <span class=\"code\">$UIString[&lt;ID&gt;]</span> which has a mapping to a custom \'iProperty (Inventor) or a custom File Property\'\n                           (AutoCAD) or a block attribute name (AutoCAD) . A localized designation enables a\n                           dynamic override of the label. \n                           				\n                        </p> \n                     </li>\n                  </ul> \n               </li>\n            </ul>\n            <p>UIString Example: \n               		\n            </p>\n            <p> \n               <div class=\"codeBlock\"><pre class=\"prettyprint\">&lt;!--In case of Vault, use system name of the property which is usually a GUID. --&gt;\n  &lt;UIString ID =\"7b6a617f-bf95-426f-a2fl-b4d0e9eec0a3\"&gt;Zeichnungs-Titel&lt;/UIString&gt;\n  </pre></div> \n            </p>\n            <p>Result in the Dynamic Category Grid for en-US, for client started in de-DE: \n               		\n            </p>\n            <p> <a name=\"FIG_104C16650F3549679727122C02FD2456\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-BA7D7412-6938-4E0E-B690-034CA7D01CDA-low.png\"></div> \n            </p> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_834C220C6B0D434097D563D653C1AD39\"></a> \n            <h2><a name=\"GUID-DA3F1C7E-17CB-491A-8466-FD2E025BE1C5\"></a>Property Translations\n            </h2> \n            <p>Sample: \n               		  <span class=\"filePath\">PropertyTranslations.xml</span> \n            </p> \n            <p> \n               <div class=\"codeBlock\"><pre class=\"prettyprint\">&lt;?xml version=\"1.0\" encoding=\"utf-8\"?&gt;\n&lt;PropertyTranslations LanguageCode=\"en-US\"&gt;\n  &lt;PropertyTranslation Name=\"NAME\"&gt;Name&lt;/PropertyTranslation&gt;\n  &lt;PropertyTranslation Name=\"TITLE\"&gt;Title&lt;/PropertyTranslation&gt;\n  &lt;PropertyTranslation Name=\"DESCRIPTION\"&gt;Description&lt;/PropertyTranslation&gt;\n...\n&lt;/PropertyTranslations&gt;</pre></div> \n            </p> \n            <p>The XML file contains a \n               		  <span class=\"code\">&lt;PropertyTranslations&gt;</span> element with an attribute \n               		  <span class=\"code\">LanguageCode</span> to specify the language. The \n               		  <span class=\"code\">&lt;PropertyTranslations&gt;</span> element is a collection of \n               		  <span class=\"code\">&lt;PropertyTranslation&gt;</span> elements. The attribute \n               		  <span class=\"code\">Name</span> has to be unique. The value of the element is the display name of the Vault property.\n               \n               		\n            </p> <a name=\"UL_217BE89E18EA41F693E0FD3061392C7F\"></a><p class=\"list-intro\">How to Use Property Translations</p>\n            <p>In XAML and in PowerShell files, Vault properties can be accessed by \n               		  <span class=\"code\">Prop[&lt;property name&gt;]</span> expressions. Instead of using a fixed property name, the following syntax can be\n               used: \n               		\n            </p>\n            <ul>\n               <li>XAML Files: \n                  		  <span class=\"code\">&lt;TextBox Text=\"{Binding Prop[_XLTN_&lt;Name&gt;].Value}\"</span> \n                  <p>For example: \n                     			 <span class=\"code\">&lt;TextBox Text=\"{Binding Prop[_XLTN_DESCRIPTION].Value}\"/&gt;</span> \n                  </p> \n                  <p>The \n                     			 <span class=\"code\">prefix_XLTN_</span> in the above sample looks in the \n                     			 <span class=\"filePath\">PropertyTranslations.xml</span> for a \n                     			 <span class=\"code\">&lt;PropertyTranslation&gt;</span> element with the name DESCRIPTION and replaces the complete expression \n                     			 <span class=\"code\">_XLTN_DESCRIPTION</span> with the value Description. The content of the text box is then bound to the Vault\n                     property Description. \n                     		  \n                  </p> \n               </li>\n               <li>PowerShell file: \n                  		  <span class=\"code\">$Prop[\"_XLTN_&lt;Name&gt;\"].Value</span> \n               </li>\n            </ul> \n            <div><a name=\"GUID-54667F66-369D-4D72-836C-D8AC5385058B\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span>For CAD, this property translation is not used because the iProperties, DWG properties,\n                  and title block attributes are not language dependent. \n                  		\n               </div>\n            </div> \n         </div>\n         <div class=\"footer-block\"><a href=\"..\" class=\"comments-anchor\" target=\"_blank\"><span class=\"comments-link\">Please send us your comment about this page</span></a></div><br><p class=\"footer-license-block\"><a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\"><img alt=\"Creative Commons License\" style=\"border-width: 0;\" src=\"../images/ccLink.png\"></a>&nbsp;<em>Except where otherwise noted, this work is licensed under a <a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\">Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License</a>. Please see the <a href=\"http://autodesk.com/creativecommons\" target=\"_blank\">Autodesk Creative Commons FAQ</a> for more information.</em></p><br></div>\n   </body>\n</html>";
// SIG // Begin signature block
// SIG // MIIZfQYJKoZIhvcNAQcCoIIZbjCCGWoCAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // BaIIgYla08cmpSTGECpWAoHWOSgWlYY0XUf/NCiI4Xeg
// SIG // ggoaMIIEyzCCA7OgAwIBAgIQCQja65wGHi65un4mqmKH
// SIG // ijANBgkqhkiG9w0BAQsFADCBhDELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTUw
// SIG // MwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
// SIG // b2RlIFNpZ25pbmcgQ0EgLSBHMjAeFw0xOTA1MTQwMDAw
// SIG // MDBaFw0yMDA1MTMyMzU5NTlaMHwxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIDApDYWxpZm9ybmlhMRMwEQYDVQQHDApT
// SIG // YW4gUmFmYWVsMRcwFQYDVQQKDA5BdXRvZGVzaywgSW5j
// SIG // LjERMA8GA1UECwwIU2VjdXJpdHkxFzAVBgNVBAMMDkF1
// SIG // dG9kZXNrLCBJbmMuMIIBIjANBgkqhkiG9w0BAQEFAAOC
// SIG // AQ8AMIIBCgKCAQEAkVKRoPYsoxPdlabspcuG8HYDfcWQ
// SIG // 9qyPOT2punwpVdjt2slktcpSTlydrGy8ijcbl5/k8AOJ
// SIG // afKMQvow0fNjIoNB5nsb8j2xFJPbBhHl8GT4P6DZ1OWK
// SIG // ioiUXgGHKjctUws49J4elntqvBYhKCbuPqG772QCoYFU
// SIG // P7qcFbh3PbyNB6cnKMn2vNGRqiEtV2aGg+/MiL3QPsvT
// SIG // kTWhVuTLIvwZ4kK5C5ACiQzlGOlE+C7gWuFoxtvy6gUa
// SIG // A8JAq/xLjYKwFevQwGncg3s1cuiGhx0P7Rvn6oCd2cem
// SIG // FmbK3I3rMRt+jc9wzAj3oHxvCo4f5Lfva+OpC1dETUVV
// SIG // sk0VGwIDAQABo4IBPjCCATowCQYDVR0TBAIwADAOBgNV
// SIG // HQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMw
// SIG // YQYDVR0gBFowWDBWBgZngQwBBAEwTDAjBggrBgEFBQcC
// SIG // ARYXaHR0cHM6Ly9kLnN5bWNiLmNvbS9jcHMwJQYIKwYB
// SIG // BQUHAgIwGQwXaHR0cHM6Ly9kLnN5bWNiLmNvbS9ycGEw
// SIG // HwYDVR0jBBgwFoAU1MAGIknrOUvdk+JcobhHdglyA1gw
// SIG // KwYDVR0fBCQwIjAgoB6gHIYaaHR0cDovL3JiLnN5bWNi
// SIG // LmNvbS9yYi5jcmwwVwYIKwYBBQUHAQEESzBJMB8GCCsG
// SIG // AQUFBzABhhNodHRwOi8vcmIuc3ltY2QuY29tMCYGCCsG
// SIG // AQUFBzAChhpodHRwOi8vcmIuc3ltY2IuY29tL3JiLmNy
// SIG // dDANBgkqhkiG9w0BAQsFAAOCAQEA0Q2+iVSEfT4xGq3A
// SIG // OADVb0rT5Z8E+PPb1x6hKknSzuaZKk/acDz9mdnFajaU
// SIG // WgIKiFJlsqJnuAM1w4lqKaEWsz3DoxvGIEwexj71Ud6a
// SIG // KlBJNcR9DdkXUZwMhbw9d78rjJAIX6tOwfSludZfdq8b
// SIG // YEkuIzQi9uYW9vHVPSCzhnUBKjwc9qTo9yBc7Fcn4FAT
// SIG // 90DzWM2hS9oc3p0pprYI2I/O4th90BEmwWkVqVgfaR0z
// SIG // VyIEmBbqB/IWLfjUBZJ/8sbkwWuWlYVRrfPxsj1e9qvb
// SIG // wE3Y28jWyGbqoUG39GhXk3uT8R8i3+T6M0c4rMfdifBC
// SIG // pceCaFTJzSye7LoeVzCCBUcwggQvoAMCAQICEHwbNTVK
// SIG // 59t050FfEWnKa6gwDQYJKoZIhvcNAQELBQAwgb0xCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjEfMB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29y
// SIG // azE6MDgGA1UECxMxKGMpIDIwMDggVmVyaVNpZ24sIElu
// SIG // Yy4gLSBGb3IgYXV0aG9yaXplZCB1c2Ugb25seTE4MDYG
// SIG // A1UEAxMvVmVyaVNpZ24gVW5pdmVyc2FsIFJvb3QgQ2Vy
// SIG // dGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMTQwNzIyMDAw
// SIG // MDAwWhcNMjQwNzIxMjM1OTU5WjCBhDELMAkGA1UEBhMC
// SIG // VVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9u
// SIG // MR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3Jr
// SIG // MTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1
// SIG // NiBDb2RlIFNpZ25pbmcgQ0EgLSBHMjCCASIwDQYJKoZI
// SIG // hvcNAQEBBQADggEPADCCAQoCggEBANeVQ9Tc32euOftS
// SIG // pLYmMQRw6beOWyq6N2k1lY+7wDDnhthzu9/r0XY/ilaO
// SIG // 6y1L8FcYTrGNpTPTC3Uj1Wp5J92j0/cOh2W13q0c8fU1
// SIG // tCJRryKhwV1LkH/AWU6rnXmpAtceSbE7TYf+wnirv+9S
// SIG // rpyvCNk55ZpRPmlfMBBOcWNsWOHwIDMbD3S+W8sS4duM
// SIG // xICUcrv2RZqewSUL+6McntimCXBx7MBHTI99w94Zzj7u
// SIG // BHKOF9P/8LIFMhlM07Acn/6leCBCcEGwJoxvAMg6ABFB
// SIG // ekGwp4qRBKCZePR3tPNgKuZsUAS3FGD/DVH0qIuE/iHa
// SIG // XF599Sl5T7BEdG9tcv8CAwEAAaOCAXgwggF0MC4GCCsG
// SIG // AQUFBwEBBCIwIDAeBggrBgEFBQcwAYYSaHR0cDovL3Mu
// SIG // c3ltY2QuY29tMBIGA1UdEwEB/wQIMAYBAf8CAQAwZgYD
// SIG // VR0gBF8wXTBbBgtghkgBhvhFAQcXAzBMMCMGCCsGAQUF
// SIG // BwIBFhdodHRwczovL2Quc3ltY2IuY29tL2NwczAlBggr
// SIG // BgEFBQcCAjAZGhdodHRwczovL2Quc3ltY2IuY29tL3Jw
// SIG // YTA2BgNVHR8ELzAtMCugKaAnhiVodHRwOi8vcy5zeW1j
// SIG // Yi5jb20vdW5pdmVyc2FsLXJvb3QuY3JsMBMGA1UdJQQM
// SIG // MAoGCCsGAQUFBwMDMA4GA1UdDwEB/wQEAwIBBjApBgNV
// SIG // HREEIjAgpB4wHDEaMBgGA1UEAxMRU3ltYW50ZWNQS0kt
// SIG // MS03MjQwHQYDVR0OBBYEFNTABiJJ6zlL3ZPiXKG4R3YJ
// SIG // cgNYMB8GA1UdIwQYMBaAFLZ3+mlIR59TEtXC6gcydgfR
// SIG // lwcZMA0GCSqGSIb3DQEBCwUAA4IBAQB/68qn6ot2Qus+
// SIG // jiBUMOO3udz6SD4Wxw9FlRDNJ4ajZvMC7XH4qsJVl5Fw
// SIG // g/lSflJpPMnx4JRGgBi7odSkVqbzHQCR1YbzSIfgy8Q0
// SIG // aCBetMv5Be2cr3BTJ7noPn5RoGlxi9xR7YA6JTKfRK9u
// SIG // QyjTIXW7l9iLi4z+qQRGBIX3FZxLEY3ELBf+1W5/muJW
// SIG // kvGWs60t+fTf2omZzrI4RMD3R3vKJbn6Kmgzm1By3qif
// SIG // 1M0sCzS9izB4QOCNjicbkG8avggVgV3rL+JR51EeyXgp
// SIG // 5x5lvzjvAUoBCSQOFsQUecFBNzTQPZFSlJ3haO8I8OJp
// SIG // nGdukAsak3HUJgLDwFojMYIOuzCCDrcCAQEwgZkwgYQx
// SIG // CzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRlYyBD
// SIG // b3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1
// SIG // c3QgTmV0d29yazE1MDMGA1UEAxMsU3ltYW50ZWMgQ2xh
// SIG // c3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENBIC0gRzIC
// SIG // EAkI2uucBh4uubp+Jqpih4owDQYJYIZIAWUDBAIBBQCg
// SIG // fDAQBgorBgEEAYI3AgEMMQIwADAZBgkqhkiG9w0BCQMx
// SIG // DAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4wDAYK
// SIG // KwYBBAGCNwIBFTAvBgkqhkiG9w0BCQQxIgQgIkFByr5F
// SIG // CXXzc++b+fZyclWfF9EVLJXN1a109Aw3Wz0wDQYJKoZI
// SIG // hvcNAQEBBQAEggEAaEtAE0KjzTkuV3jFe7EZSUZQIPns
// SIG // UgRnTG79yff1QoBGvKnl/UcjexIBaKxDVL7TaC/YS2Yg
// SIG // WOjLJJY/oHyq6AnPkQffKo748bcNGuM9KZ9VrbGXDfZx
// SIG // 5mt1BUF9lxXYIsCls+TKhOAgi8YkDkGzy3MCG4WROXYs
// SIG // pkbovNRFz/Xs2j7GDr3bvODqRMCbH7lOG98zUfeySV87
// SIG // oNT60BZZolhIaU6CeAZLO/kGRiAY4/b219/twvL19+yO
// SIG // HgqbLOL4qHaMKCEG55yUDWuR/6fQ0k0t5+S3tzuhVT4/
// SIG // 9cF4Ikn2X4QJub9YtXPvdNGil3WgV/2tRUlLegVm4MjW
// SIG // CUgff6GCDHQwggxwBgorBgEEAYI3AwMBMYIMYDCCDFwG
// SIG // CSqGSIb3DQEHAqCCDE0wggxJAgEDMQ8wDQYJYIZIAWUD
// SIG // BAIBBQAwga8GCyqGSIb3DQEJEAEEoIGfBIGcMIGZAgEB
// SIG // BgkrBgEEAaAyAgMwMTANBglghkgBZQMEAgEFAAQgENco
// SIG // o4KDDacQt9uRQxAdCjVKhJOtdlR/TrLQ6fPJhbUCFAZR
// SIG // 0vrrHcGWyy7BPMlX2C32zxJbGA8yMDIwMDMyMzE0MDI1
// SIG // MVqgL6QtMCsxKTAnBgNVBAMMIEdsb2JhbFNpZ24gVFNB
// SIG // IGZvciBBZHZhbmNlZCAtIEcyoIII0zCCBLYwggOeoAMC
// SIG // AQICDAynz10HBySsieeaOjANBgkqhkiG9w0BAQsFADBb
// SIG // MQswCQYDVQQGEwJCRTEZMBcGA1UEChMQR2xvYmFsU2ln
// SIG // biBudi1zYTExMC8GA1UEAxMoR2xvYmFsU2lnbiBUaW1l
// SIG // c3RhbXBpbmcgQ0EgLSBTSEEyNTYgLSBHMjAeFw0xODAy
// SIG // MTkwMDAwMDBaFw0yOTAzMTgxMDAwMDBaMCsxKTAnBgNV
// SIG // BAMMIEdsb2JhbFNpZ24gVFNBIGZvciBBZHZhbmNlZCAt
// SIG // IEcyMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKC
// SIG // AQEAt8eSiijY85HLUA1d6ylEwYJZpcpkzr2DtVHllMxu
// SIG // gJoXbNz/YuY2Q14Bwgxkjcp3nvZdd0W5Xsgk60E3EWY3
// SIG // rMjNdJvMs+9M4n8bznO+yZadNR5891T3bOygEtaumZ1j
// SIG // xHhfWakuIvXDJ9iyW0VjJ5D/jLE9qbTzDsDxIGUGiZ0D
// SIG // HKOwUkGFNOu8y85U9hL+swGJSqb6VMUf+9McwOO/l+M/
// SIG // 0Bv5QMcb1esmfEMwx3DyeBGqhU6lDg0ASjoRd6PKIwGA
// SIG // nsiTVl1GzIrY0qoKhIWyiVvVMs5BexhOVMqr0VJeEtMk
// SIG // nlbzDI/dvZKOedVBicOjoOWR/MdnnYczznEycwIDAQAB
// SIG // o4IBqDCCAaQwDgYDVR0PAQH/BAQDAgeAMEwGA1UdIARF
// SIG // MEMwQQYJKwYBBAGgMgEeMDQwMgYIKwYBBQUHAgEWJmh0
// SIG // dHBzOi8vd3d3Lmdsb2JhbHNpZ24uY29tL3JlcG9zaXRv
// SIG // cnkvMAkGA1UdEwQCMAAwFgYDVR0lAQH/BAwwCgYIKwYB
// SIG // BQUHAwgwRgYDVR0fBD8wPTA7oDmgN4Y1aHR0cDovL2Ny
// SIG // bC5nbG9iYWxzaWduLmNvbS9ncy9nc3RpbWVzdGFtcGlu
// SIG // Z3NoYTJnMi5jcmwwgZgGCCsGAQUFBwEBBIGLMIGIMEgG
// SIG // CCsGAQUFBzAChjxodHRwOi8vc2VjdXJlLmdsb2JhbHNp
// SIG // Z24uY29tL2NhY2VydC9nc3RpbWVzdGFtcGluZ3NoYTJn
// SIG // Mi5jcnQwPAYIKwYBBQUHMAGGMGh0dHA6Ly9vY3NwMi5n
// SIG // bG9iYWxzaWduLmNvbS9nc3RpbWVzdGFtcGluZ3NoYTJn
// SIG // MjAdBgNVHQ4EFgQULW5u0Y3lA4Du52Ppp9naCzxXIj0w
// SIG // HwYDVR0jBBgwFoAUkiGnSpVdZLCbtB7mADdH5p1BK0ww
// SIG // DQYJKoZIhvcNAQELBQADggEBAI39HR+PiNNl+LVcRumn
// SIG // 07Y/SstDBcIHDcNeA4QjN6h6jJcj/yechH1h61xLVz6b
// SIG // 9ETbgFj3tmXejxIKX6eHdLfaFECHUeyfSkdV8BfoGD5x
// SIG // IDHmKCKrTvaunGvC50T7aA0gf1M/lBuhhoJOMhYQWj+J
// SIG // WMHQtNu2kPuNMumhS0ZQN7bDOukpJBKSWk4rubYKejaM
// SIG // l8DviXwz3jHhoZfk50WtYVL9WonTVH6KTVuJew6Wd9Hy
// SIG // PDgb2vmlYSBlArzFrdcMYhAoLN2246hhAKwIJqONhdBk
// SIG // yTaQHopSyYeNNaVdSJH8k6alZfHs+TrcpSyeBG1iM/7e
// SIG // +p/Fzq+V81Go8s4wggQVMIIC/aADAgECAgsEAAAAAAEx
// SIG // icZQBDANBgkqhkiG9w0BAQsFADBMMSAwHgYDVQQLExdH
// SIG // bG9iYWxTaWduIFJvb3QgQ0EgLSBSMzETMBEGA1UEChMK
// SIG // R2xvYmFsU2lnbjETMBEGA1UEAxMKR2xvYmFsU2lnbjAe
// SIG // Fw0xMTA4MDIxMDAwMDBaFw0yOTAzMjkxMDAwMDBaMFsx
// SIG // CzAJBgNVBAYTAkJFMRkwFwYDVQQKExBHbG9iYWxTaWdu
// SIG // IG52LXNhMTEwLwYDVQQDEyhHbG9iYWxTaWduIFRpbWVz
// SIG // dGFtcGluZyBDQSAtIFNIQTI1NiAtIEcyMIIBIjANBgkq
// SIG // hkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqpuOw6sRUSUB
// SIG // tpaU4k/YwQj2RiPZRcWVl1urGr/SbFfJMwYfoA/GPH5T
// SIG // SHq/nYeer+7DjEfhQuzj46FKbAwXxKbBuc1b8R5EiY7+
// SIG // C94hWBPuTcjFZwscsrPxNHaRossHbTfFoEcmAhWkkJGp
// SIG // eZ7X61edK3wi2BTX8QceeCI2a3d5r6/5f45O4bUIMf3q
// SIG // 7UtxYowj8QM5j0R5tnYDV56tLwhG3NKMvPSOdM7IaGlR
// SIG // dhGLD10kWxlUPSbMQI2CJxtZIH1Z9pOAjvgqOP1roEBl
// SIG // H1d2zFuOBE8sqNuEUBNPxtyLufjdaUyI65x7MCb8eli7
// SIG // WbwUcpKBV7d2ydiACoBuCQIDAQABo4HoMIHlMA4GA1Ud
// SIG // DwEB/wQEAwIBBjASBgNVHRMBAf8ECDAGAQH/AgEAMB0G
// SIG // A1UdDgQWBBSSIadKlV1ksJu0HuYAN0fmnUErTDBHBgNV
// SIG // HSAEQDA+MDwGBFUdIAAwNDAyBggrBgEFBQcCARYmaHR0
// SIG // cHM6Ly93d3cuZ2xvYmFsc2lnbi5jb20vcmVwb3NpdG9y
// SIG // eS8wNgYDVR0fBC8wLTAroCmgJ4YlaHR0cDovL2NybC5n
// SIG // bG9iYWxzaWduLm5ldC9yb290LXIzLmNybDAfBgNVHSME
// SIG // GDAWgBSP8Et/qC5FJK5NUPpjmove4t0bvDANBgkqhkiG
// SIG // 9w0BAQsFAAOCAQEABFaCSnzQzsm/NmbRvjWek2yX6AbO
// SIG // MRhZ+WxBX4AuwEIluBjH/NSxN8RooM8oagN0S2OXhXdh
// SIG // O9cv4/W9M6KSfREfnops7yyw9GKNNnPRFjbxvF7stICY
// SIG // ePzSdnno4SGU4B/EouGqZ9uznHPlQCLPOc7b5neVp7uy
// SIG // y/YZhp2fyNSYBbJxb051rvE9ZGo7Xk5GpipdCJLxo/Md
// SIG // dL9iDSOMXCo4ldLA1c3PiNofKLW6gWlkKrWmotVzr9xG
// SIG // 2wSukdduxZi61EfEVnSAR3hYjL7vK/3sbL/RlPe/UOB7
// SIG // 4JD9IBh4GCJdCC6MHKCX8x2ZfaOdkdMGRE4EbnocIOM2
// SIG // 8LZQuTGCAqgwggKkAgEBMGswWzELMAkGA1UEBhMCQkUx
// SIG // GTAXBgNVBAoTEEdsb2JhbFNpZ24gbnYtc2ExMTAvBgNV
// SIG // BAMTKEdsb2JhbFNpZ24gVGltZXN0YW1waW5nIENBIC0g
// SIG // U0hBMjU2IC0gRzICDAynz10HBySsieeaOjANBglghkgB
// SIG // ZQMEAgEFAKCCAQ4wGgYJKoZIhvcNAQkDMQ0GCyqGSIb3
// SIG // DQEJEAEEMBwGCSqGSIb3DQEJBTEPFw0yMDAzMjMxNDAy
// SIG // NTFaMC8GCSqGSIb3DQEJBDEiBCBM3T8uILQsh3kIu5Wn
// SIG // Q8XZYAanVD5Mm97+gfaFIHA26jCBoAYLKoZIhvcNAQkQ
// SIG // AgwxgZAwgY0wgYowgYcEFJsSBXrnKq/21jdytJ9qI28m
// SIG // Sc2pMG8wX6RdMFsxCzAJBgNVBAYTAkJFMRkwFwYDVQQK
// SIG // ExBHbG9iYWxTaWduIG52LXNhMTEwLwYDVQQDEyhHbG9i
// SIG // YWxTaWduIFRpbWVzdGFtcGluZyBDQSAtIFNIQTI1NiAt
// SIG // IEcyAgwMp89dBwckrInnmjowDQYJKoZIhvcNAQEBBQAE
// SIG // ggEAZL1PprWfuiy7W9mfjjHOr8zXp49F7LT0QIkQk5oM
// SIG // Ku12HfO4ZsAXQjpkA7hU/EJQ/wWPoTvnqUegMthTGbqM
// SIG // GdSQiNecWQah/SYUzJ+dK4lFlvv7K5O7WGycxItZ8jtS
// SIG // U6dTLVGhPiYm8r40zD69SQ9q1lUO/v65ChMojPSkIHcw
// SIG // 1xDhDHZPYCp5vJfVTxkVUp/mUCh2tOPfxGz4WZUs26Jm
// SIG // INI66cEwOCn8kFgFFuELlKc77RvYI0aY2aE5zUh6zXSF
// SIG // cZ66lwaIj62/PN6+3GM2/HfvPbpd/ZNGiEjjCgAREIqm
// SIG // phQJUL/jZo/SF55QmbWYivMKtpTWRkKm+D1afw==
// SIG // End signature block
