var topic = "<!DOCTYPE html>\r\n\n<!-- saved from url=(0024)http://docs.autodesk.com -->\r\n<html>\n   <head>\n      <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n      <meta name=\"product\" content=\"VAULT\">\n      <meta name=\"release\" content=\"2021\">\n      <meta name=\"book\" content=\"GeneralUser\">\n      <meta name=\"created\" content=\"2020-03-20\">\n      <meta name=\"topicid\" content=\"GUID-09904A25-72E8-4E46-AF3A-CC796AD0E93C\">\n      <meta name=\"description\" content=\"Backing up vault data is essential. Autodesk recommends that you back up your Vault using the following methods.\">\n      <meta name=\"topic-type\" content=\"concept\">\n      <meta name=\"audience\" content=\"administrator\">\n      <meta name=\"experiencelevel\" content=\"general\">\n      <title>Server Maintenance Part 1: Back Up Your Vault</title><script language=\"javascript\">var index = \'index.html\';</script></head>\n   <body height=\"100%\">\n      <div class=\"body_content\" id=\"body-content\" dir=\"ltr\"><a name=\"GUID-09904A25-72E8-4E46-AF3A-CC796AD0E93C\"></a><div class=\"head\">\n            <h1>Server Maintenance Part 1: Back Up Your Vault</h1>\n         </div>\n         <p class=\"blurb\">Backing up vault data is essential. Autodesk recommends that you back up your Vault\n            using the following methods. \n         </p>\n         <div class=\"section\"><a name=\"SECTION_C6B18ED655654933BF7CA9B958A2718C\"></a> \n            <h2><a name=\"GUID-44AA8E27-65D9-450E-BA14-CFE241CBCCB1\"></a>Back Up Your Vault\n            </h2> <a name=\"UL_FF72FB54C1BD4A10B96936F4CA8EF4C3\"></a><p><a name=\"GUID-DBA3C45B-5924-44B0-9EA0-E70C0BE86496\"></a>Use the supplied backup-restore utility to back up your Vault data. \n            </p>\n            <p><a name=\"GUID-ACD6A82E-8A02-498B-8CDE-0B62F192E90A\"></a>Use the server console to back up all data necessary to restore a server if a failure\n               occurs. When you back up the server, all users are blocked from accessing the system.\n               In addition, server console backs up or restores all vaults on the server. There is\n               no way to select individual vaults to back up or restore. \n            </p> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_6C9457C592B347DBBFB70AC8DFA051F9\"></a> \n            <h2><a name=\"GUID-C1FBB8B7-6E7A-4E45-B8C2-333B58158A4D\"></a>Develop a Backup Schedule\n            </h2> <a name=\"UL_1231A605102E4375952AAC3066AC9F0A\"></a><p><a name=\"GUID-6630FCDE-2A6B-4DE0-A4D9-999029D8B7BB\"></a>The next step is to automate the process. Two common methods are: \n            </p>\n            <ul>\n               <li>Use the Windows Task Scheduler. This process uses the backup tools included with the\n                  server console as part of a standard Windows batch file. \n               </li>\n               <li>Include the backup as part of a tape backup set. This process uses a tape back up\n                  system to back up the vault directly or to use a method like the Windows Task Scheduler.\n                  \n               </li>\n            </ul>\n            <p><a name=\"GUID-2C6CBED8-5D90-4AE5-9FA1-368CB239AAD7\"></a>With the server console command line options, you can create a script to automate\n               the backup process. The following script is intended for a default Autodesk Vault\n               server installation. Edit the backup paths and installation paths as needed. \n            </p>\n            <p><a name=\"GUID-41A1DCBF-D010-4553-BDE5-7A8469CD1AC0\"></a>The preferred and most reliable method for backing up a vault is to integrate the\n               server console backup tools into your tape backup plan. \n            </p>\n            <div><a name=\"GUID-6E3F9926-638B-4085-A8C3-66FB168D381E\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span> The following script is for performing full backups ONLY. For more command line options\n                  or to create a script for performing incremental backups, see the data management\n                  server console Help. \n               </div>\n            </div> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_86394AE7A8D74EF8844C06B8ACAEB770\"></a> \n            <h2><a name=\"GUID-8D817E60-783F-42B0-9DA2-9C6DDD53587E\"></a>Automate Backup Using Microsoft Windows Task Scheduler\n            </h2> <a name=\"OL_303BE18362C945908352CA9C81E1CEC9\"></a><ol type=\"1\" start=\"1\">\n               <li>Create a text file called Backup.txt. </li>\n               <li>Insert the following text: \n                  <p><a name=\"GUID-8D3D8E2D-10B0-42A7-9DB6-DFC1C544BB2B\"></a>@ECHO OFFREM DELETE B AND CASCADE A BACKUP SUBDIRECTORIESRMDIR /Q /S \"C:\\Backup\\Vault\\B\"REN\n                     \"C:\\Backup\\Vault\\A\" \"B\"REM CREATE A NEW DIRECTORY FOR THE BACKUPMKDIR \"C:\\Backup\\Vault\\A\\\"REM\n                     START THE BACKUP PROCESS (THIS IS ONE LINE OF TEXT)\"C:\\Program Files\\Autodesk\\Data\n                     Management Server 2009\\ADMS Console\\Connectivity.ADMSConsole.exe\" -Obackup -B\"C:\\Backup\\Vault\\A\"\n                     -VUadministrator -VP[YourPassword] -S \n                  </p> \n               </li>\n               <li>Change the name of the text file to <span class=\"filePath\">Backup.bat</span> to convert it to a batch file. \n               </li>\n            </ol>\n            <div><a name=\"GUID-B6A32EC6-9510-4FA0-9008-D34E525E1008\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span>When backing up a multi-site environment, back up locally on the primary server. \n               </div>\n            </div> \n         </div>\n         <div class=\"section\"><a name=\"SECTION_1BBB8EC8FB054B8699228B37C9B0B9DD\"></a> \n            <h2><a name=\"GUID-7D6912C3-78A1-4AB0-9B10-207CDE09AF7E\"></a>Create Tape Backups\n            </h2> <a name=\"OL_BF96553FDA5248C2AAF258C6AFA0776A\"></a><p><a name=\"GUID-A8D30D93-2F17-4762-BDBC-F7DBCC93C152\"></a>There are different ways to use a tape backup system to back up a vault. We recommend\n               integrating the Server Console backup tools into your tape backup plan. Many systems\n               allow you to run a script before and after the tape job executes. To back up a vault\n               using a tape backup system, use the following scripts before and after the job runs.\n               \n            </p>\n            <div><a name=\"GUID-110E0F95-BA62-4BFC-8BD1-C7BE5A6AB116\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span> We do not recommend using backup software to back up the SQL database and file store\n                  directly. This method increases the difficulty of migrating to a new release of Autodesk\n                  Vault server or restoring a vault on a new machine. In addition, never back up the\n                  SQL Server using the \"live\" backup plug-ins that are available for major tape backup\n                  systems. Ensure the file store and SQL data are perfectly in sync with each other.\n                  Failure to do so can render your data unusable. \n               </div>\n            </div>\n            <ol type=\"1\" start=\"1\">\n               <li>Run the following script before your tape backup job starts: @ECHO OFF \n                  <p><a name=\"GUID-4BEAAF2B-B389-4E11-9098-7E2F6215F99D\"></a>  \n                  </p> \n               </li>\n               <li>REM THIS WILL STOP THE WEB SERVER AND \"CYCLE\" THE SQL SERVER REM PROVIDING THE BEST\n                  RESULTS FOR BACKING UP THE VAULTIISRESET /STOPNET STOP MSSQL$AUTODESKVAULTNET START\n                  MSSQL$AUTODESKVAULTREM START THE BACKUP PROCESS (THIS IS ONE LINE OF TEXT)\"C:\\Program\n                  Files\\Autodesk\\Data Management Server 2009\\ADMS Console\\Connectivity.ADMSConsole.exe\"\n                  -o backup -B\"C:\\Backup\\Vault\\A\" -VUadministrator -VP -S \n               </li>\n               <li>Run the following script after your tape backup job completes: @ECHO OFFREM DELETE\n                  THE BACKUP SET AFTER THE TAPE SET COMPLETESRMDIR /Q/S C:\\Backup\\Vault\\A\"REM START\n                  THE WEB SERVERIISRESET /START \n               </li>\n               <li>Validate the Tape Backup To ensure that your backup set restores properly, test both\n                  the backup and the backup procedures. We recommend that you install the Autodesk Vault\n                  server on a separate computer. Test a full restore of the data using the Restore command\n                  in Autodesk Vault server console. \n               </li>\n            </ol> \n         </div>\n         <div class=\"footer-block\"><a href=\"..\" class=\"comments-anchor\" target=\"_blank\"><span class=\"comments-link\">Please send us your comment about this page</span></a></div><br><p class=\"footer-license-block\"><a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\"><img alt=\"Creative Commons License\" style=\"border-width: 0;\" src=\"../images/ccLink.png\"></a>&nbsp;<em>Except where otherwise noted, this work is licensed under a <a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\">Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License</a>. Please see the <a href=\"http://autodesk.com/creativecommons\" target=\"_blank\">Autodesk Creative Commons FAQ</a> for more information.</em></p><br></div>\n   </body>\n</html>";
// SIG // Begin signature block
// SIG // MIIbRQYJKoZIhvcNAQcCoIIbNjCCGzICAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // eF++AAIeaD9S5fPFFD310DDvHfX1JLe8Pil/ctgm7r2g
// SIG // ggoaMIIEyzCCA7OgAwIBAgIQCQja65wGHi65un4mqmKH
// SIG // ijANBgkqhkiG9w0BAQsFADCBhDELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTUw
// SIG // MwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
// SIG // b2RlIFNpZ25pbmcgQ0EgLSBHMjAeFw0xOTA1MTQwMDAw
// SIG // MDBaFw0yMDA1MTMyMzU5NTlaMHwxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIDApDYWxpZm9ybmlhMRMwEQYDVQQHDApT
// SIG // YW4gUmFmYWVsMRcwFQYDVQQKDA5BdXRvZGVzaywgSW5j
// SIG // LjERMA8GA1UECwwIU2VjdXJpdHkxFzAVBgNVBAMMDkF1
// SIG // dG9kZXNrLCBJbmMuMIIBIjANBgkqhkiG9w0BAQEFAAOC
// SIG // AQ8AMIIBCgKCAQEAkVKRoPYsoxPdlabspcuG8HYDfcWQ
// SIG // 9qyPOT2punwpVdjt2slktcpSTlydrGy8ijcbl5/k8AOJ
// SIG // afKMQvow0fNjIoNB5nsb8j2xFJPbBhHl8GT4P6DZ1OWK
// SIG // ioiUXgGHKjctUws49J4elntqvBYhKCbuPqG772QCoYFU
// SIG // P7qcFbh3PbyNB6cnKMn2vNGRqiEtV2aGg+/MiL3QPsvT
// SIG // kTWhVuTLIvwZ4kK5C5ACiQzlGOlE+C7gWuFoxtvy6gUa
// SIG // A8JAq/xLjYKwFevQwGncg3s1cuiGhx0P7Rvn6oCd2cem
// SIG // FmbK3I3rMRt+jc9wzAj3oHxvCo4f5Lfva+OpC1dETUVV
// SIG // sk0VGwIDAQABo4IBPjCCATowCQYDVR0TBAIwADAOBgNV
// SIG // HQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMw
// SIG // YQYDVR0gBFowWDBWBgZngQwBBAEwTDAjBggrBgEFBQcC
// SIG // ARYXaHR0cHM6Ly9kLnN5bWNiLmNvbS9jcHMwJQYIKwYB
// SIG // BQUHAgIwGQwXaHR0cHM6Ly9kLnN5bWNiLmNvbS9ycGEw
// SIG // HwYDVR0jBBgwFoAU1MAGIknrOUvdk+JcobhHdglyA1gw
// SIG // KwYDVR0fBCQwIjAgoB6gHIYaaHR0cDovL3JiLnN5bWNi
// SIG // LmNvbS9yYi5jcmwwVwYIKwYBBQUHAQEESzBJMB8GCCsG
// SIG // AQUFBzABhhNodHRwOi8vcmIuc3ltY2QuY29tMCYGCCsG
// SIG // AQUFBzAChhpodHRwOi8vcmIuc3ltY2IuY29tL3JiLmNy
// SIG // dDANBgkqhkiG9w0BAQsFAAOCAQEA0Q2+iVSEfT4xGq3A
// SIG // OADVb0rT5Z8E+PPb1x6hKknSzuaZKk/acDz9mdnFajaU
// SIG // WgIKiFJlsqJnuAM1w4lqKaEWsz3DoxvGIEwexj71Ud6a
// SIG // KlBJNcR9DdkXUZwMhbw9d78rjJAIX6tOwfSludZfdq8b
// SIG // YEkuIzQi9uYW9vHVPSCzhnUBKjwc9qTo9yBc7Fcn4FAT
// SIG // 90DzWM2hS9oc3p0pprYI2I/O4th90BEmwWkVqVgfaR0z
// SIG // VyIEmBbqB/IWLfjUBZJ/8sbkwWuWlYVRrfPxsj1e9qvb
// SIG // wE3Y28jWyGbqoUG39GhXk3uT8R8i3+T6M0c4rMfdifBC
// SIG // pceCaFTJzSye7LoeVzCCBUcwggQvoAMCAQICEHwbNTVK
// SIG // 59t050FfEWnKa6gwDQYJKoZIhvcNAQELBQAwgb0xCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjEfMB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29y
// SIG // azE6MDgGA1UECxMxKGMpIDIwMDggVmVyaVNpZ24sIElu
// SIG // Yy4gLSBGb3IgYXV0aG9yaXplZCB1c2Ugb25seTE4MDYG
// SIG // A1UEAxMvVmVyaVNpZ24gVW5pdmVyc2FsIFJvb3QgQ2Vy
// SIG // dGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMTQwNzIyMDAw
// SIG // MDAwWhcNMjQwNzIxMjM1OTU5WjCBhDELMAkGA1UEBhMC
// SIG // VVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9u
// SIG // MR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3Jr
// SIG // MTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1
// SIG // NiBDb2RlIFNpZ25pbmcgQ0EgLSBHMjCCASIwDQYJKoZI
// SIG // hvcNAQEBBQADggEPADCCAQoCggEBANeVQ9Tc32euOftS
// SIG // pLYmMQRw6beOWyq6N2k1lY+7wDDnhthzu9/r0XY/ilaO
// SIG // 6y1L8FcYTrGNpTPTC3Uj1Wp5J92j0/cOh2W13q0c8fU1
// SIG // tCJRryKhwV1LkH/AWU6rnXmpAtceSbE7TYf+wnirv+9S
// SIG // rpyvCNk55ZpRPmlfMBBOcWNsWOHwIDMbD3S+W8sS4duM
// SIG // xICUcrv2RZqewSUL+6McntimCXBx7MBHTI99w94Zzj7u
// SIG // BHKOF9P/8LIFMhlM07Acn/6leCBCcEGwJoxvAMg6ABFB
// SIG // ekGwp4qRBKCZePR3tPNgKuZsUAS3FGD/DVH0qIuE/iHa
// SIG // XF599Sl5T7BEdG9tcv8CAwEAAaOCAXgwggF0MC4GCCsG
// SIG // AQUFBwEBBCIwIDAeBggrBgEFBQcwAYYSaHR0cDovL3Mu
// SIG // c3ltY2QuY29tMBIGA1UdEwEB/wQIMAYBAf8CAQAwZgYD
// SIG // VR0gBF8wXTBbBgtghkgBhvhFAQcXAzBMMCMGCCsGAQUF
// SIG // BwIBFhdodHRwczovL2Quc3ltY2IuY29tL2NwczAlBggr
// SIG // BgEFBQcCAjAZGhdodHRwczovL2Quc3ltY2IuY29tL3Jw
// SIG // YTA2BgNVHR8ELzAtMCugKaAnhiVodHRwOi8vcy5zeW1j
// SIG // Yi5jb20vdW5pdmVyc2FsLXJvb3QuY3JsMBMGA1UdJQQM
// SIG // MAoGCCsGAQUFBwMDMA4GA1UdDwEB/wQEAwIBBjApBgNV
// SIG // HREEIjAgpB4wHDEaMBgGA1UEAxMRU3ltYW50ZWNQS0kt
// SIG // MS03MjQwHQYDVR0OBBYEFNTABiJJ6zlL3ZPiXKG4R3YJ
// SIG // cgNYMB8GA1UdIwQYMBaAFLZ3+mlIR59TEtXC6gcydgfR
// SIG // lwcZMA0GCSqGSIb3DQEBCwUAA4IBAQB/68qn6ot2Qus+
// SIG // jiBUMOO3udz6SD4Wxw9FlRDNJ4ajZvMC7XH4qsJVl5Fw
// SIG // g/lSflJpPMnx4JRGgBi7odSkVqbzHQCR1YbzSIfgy8Q0
// SIG // aCBetMv5Be2cr3BTJ7noPn5RoGlxi9xR7YA6JTKfRK9u
// SIG // QyjTIXW7l9iLi4z+qQRGBIX3FZxLEY3ELBf+1W5/muJW
// SIG // kvGWs60t+fTf2omZzrI4RMD3R3vKJbn6Kmgzm1By3qif
// SIG // 1M0sCzS9izB4QOCNjicbkG8avggVgV3rL+JR51EeyXgp
// SIG // 5x5lvzjvAUoBCSQOFsQUecFBNzTQPZFSlJ3haO8I8OJp
// SIG // nGdukAsak3HUJgLDwFojMYIQgzCCEH8CAQEwgZkwgYQx
// SIG // CzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRlYyBD
// SIG // b3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1
// SIG // c3QgTmV0d29yazE1MDMGA1UEAxMsU3ltYW50ZWMgQ2xh
// SIG // c3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENBIC0gRzIC
// SIG // EAkI2uucBh4uubp+Jqpih4owDQYJYIZIAWUDBAIBBQCg
// SIG // fDAQBgorBgEEAYI3AgEMMQIwADAZBgkqhkiG9w0BCQMx
// SIG // DAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4wDAYK
// SIG // KwYBBAGCNwIBFTAvBgkqhkiG9w0BCQQxIgQgIggmI2/R
// SIG // nJlbwx7mWj02WFFdhQHh+nTgUjUvaL0Mm9kwDQYJKoZI
// SIG // hvcNAQEBBQAEggEAcD3OaUxgWnMfU6+UEySeNy/n7/GJ
// SIG // XonL/QbUa0uePPJT2WW3Zmyw8etk/ndnwoACKhiLJPQZ
// SIG // 9HKBOcGEzBZmGntlPZNBqLkURXrABg+/9lRFYXcaoWh2
// SIG // ilTo2CRop2kSgv4DQgjIN5XwqTA2QNvwdCBieLFU+JtC
// SIG // hd0lfoYGIBxkCNCiP/mdpMHaRJVlG+SJdDN2VR3R+q49
// SIG // xqK21X2bWaE0E83w/d/1JN5DZTnZ63M4vvxNpO6DbGF3
// SIG // 7A6PJ9wtgudTxWPWXHwv0mxuZbZJoUlmlpMjiElgt61o
// SIG // gpCqVY18ZtFmOADZscnhiunN37Vq78LaNa4f4Eq1nV7l
// SIG // nHIIC6GCDjwwgg44BgorBgEEAYI3AwMBMYIOKDCCDiQG
// SIG // CSqGSIb3DQEHAqCCDhUwgg4RAgEDMQ0wCwYJYIZIAWUD
// SIG // BAIBMIIBDgYLKoZIhvcNAQkQAQSggf4EgfswgfgCAQEG
// SIG // C2CGSAGG+EUBBxcDMDEwDQYJYIZIAWUDBAIBBQAEIDnb
// SIG // XXK5nU2QfmRrPlR/NUZvjcW1vIujiRPVDwzTQRjDAhQJ
// SIG // Xxnl4ezw7CJFhT1AUm4CbbR5tRgPMjAyMDAzMjMxNDAy
// SIG // NDlaMAMCAR6ggYakgYMwgYAxCzAJBgNVBAYTAlVTMR0w
// SIG // GwYDVQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlvbjEfMB0G
// SIG // A1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazExMC8G
// SIG // A1UEAxMoU3ltYW50ZWMgU0hBMjU2IFRpbWVTdGFtcGlu
// SIG // ZyBTaWduZXIgLSBHM6CCCoswggU4MIIEIKADAgECAhB7
// SIG // BbHUSWhRRPfJidKcGZ0SMA0GCSqGSIb3DQEBCwUAMIG9
// SIG // MQswCQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24s
// SIG // IEluYy4xHzAdBgNVBAsTFlZlcmlTaWduIFRydXN0IE5l
// SIG // dHdvcmsxOjA4BgNVBAsTMShjKSAyMDA4IFZlcmlTaWdu
// SIG // LCBJbmMuIC0gRm9yIGF1dGhvcml6ZWQgdXNlIG9ubHkx
// SIG // ODA2BgNVBAMTL1ZlcmlTaWduIFVuaXZlcnNhbCBSb290
// SIG // IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTE2MDEx
// SIG // MjAwMDAwMFoXDTMxMDExMTIzNTk1OVowdzELMAkGA1UE
// SIG // BhMCVVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0
// SIG // aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3
// SIG // b3JrMSgwJgYDVQQDEx9TeW1hbnRlYyBTSEEyNTYgVGlt
// SIG // ZVN0YW1waW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOC
// SIG // AQ8AMIIBCgKCAQEAu1mdWVVPnYxyXRqBoutV87ABrTxx
// SIG // rDKPBWuGmicAMpdqTclkFEspu8LZKbku7GOz4c8/C1aQ
// SIG // +GIbfuumB+Lef15tQDjUkQbnQXx5HMvLrRu/2JWR8/Du
// SIG // bPitljkuf8EnuHg5xYSl7e2vh47Ojcdt6tKYtTofHjmd
// SIG // w/SaqPSE4cTRfHHGBim0P+SDDSbDewg+TfkKtzNJ/8o7
// SIG // 1PWym0vhiJka9cDpMxTW38eA25Hu/rySV3J39M2ozP4J
// SIG // 9ZM3vpWIasXc9LFL1M7oCZFftYR5NYp4rBkyjyPBMkEb
// SIG // WQ6pPrHM+dYr77fY5NUdbRE6kvaTyZzjSO67Uw7UNpeG
// SIG // eMWhNwIDAQABo4IBdzCCAXMwDgYDVR0PAQH/BAQDAgEG
// SIG // MBIGA1UdEwEB/wQIMAYBAf8CAQAwZgYDVR0gBF8wXTBb
// SIG // BgtghkgBhvhFAQcXAzBMMCMGCCsGAQUFBwIBFhdodHRw
// SIG // czovL2Quc3ltY2IuY29tL2NwczAlBggrBgEFBQcCAjAZ
// SIG // GhdodHRwczovL2Quc3ltY2IuY29tL3JwYTAuBggrBgEF
// SIG // BQcBAQQiMCAwHgYIKwYBBQUHMAGGEmh0dHA6Ly9zLnN5
// SIG // bWNkLmNvbTA2BgNVHR8ELzAtMCugKaAnhiVodHRwOi8v
// SIG // cy5zeW1jYi5jb20vdW5pdmVyc2FsLXJvb3QuY3JsMBMG
// SIG // A1UdJQQMMAoGCCsGAQUFBwMIMCgGA1UdEQQhMB+kHTAb
// SIG // MRkwFwYDVQQDExBUaW1lU3RhbXAtMjA0OC0zMB0GA1Ud
// SIG // DgQWBBSvY9bKo06FcuCnvEHzKaI4f4B1YjAfBgNVHSME
// SIG // GDAWgBS2d/ppSEefUxLVwuoHMnYH0ZcHGTANBgkqhkiG
// SIG // 9w0BAQsFAAOCAQEAdeqwLdU0GVwyRf4O4dRPpnjBb9fq
// SIG // 3dxP86HIgYj3p48V5kApreZd9KLZVmSEcTAq3R5hF2Yg
// SIG // VgaYGY1dcfL4l7wJ/RyRR8ni6I0D+8yQL9YKbE4z7Na0
// SIG // k8hMkGNIOUAhxN3WbomYPLWYl+ipBrcJyY9TV0GQL+Ee
// SIG // TU7cyhB4bEJu8LbF+GFcUvVO9muN90p6vvPN/QPX2fYD
// SIG // qA/jU/cKdezGdS6qZoUEmbf4Blfhxg726K/a7JsYH6q5
// SIG // 4zoAv86KlMsB257HOLsPUqvR45QDYApNoP4nbRQy/D+X
// SIG // QOG/mYnb5DkUvdrk08PqK1qzlVhVBH3HmuwjA42FKtL/
// SIG // rqlhgTCCBUswggQzoAMCAQICEHvU5a+6zAc/oQEjBCJB
// SIG // TRIwDQYJKoZIhvcNAQELBQAwdzELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMSgw
// SIG // JgYDVQQDEx9TeW1hbnRlYyBTSEEyNTYgVGltZVN0YW1w
// SIG // aW5nIENBMB4XDTE3MTIyMzAwMDAwMFoXDTI5MDMyMjIz
// SIG // NTk1OVowgYAxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRT
// SIG // eW1hbnRlYyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3lt
// SIG // YW50ZWMgVHJ1c3QgTmV0d29yazExMC8GA1UEAxMoU3lt
// SIG // YW50ZWMgU0hBMjU2IFRpbWVTdGFtcGluZyBTaWduZXIg
// SIG // LSBHMzCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoC
// SIG // ggEBAK8Oiqr43L9pe1QXcUcJvY08gfh0FXdnkJz93k4C
// SIG // nkt29uU2PmXVJCBtMPndHYPpPydKM05tForkjUCNIqq+
// SIG // pwsb0ge2PLUaJCj4G3JRPcgJiCYIOvn6QyN1R3AMs19b
// SIG // jwgdckhXZU2vAjxA9/TdMjiTP+UspvNZI8uA3hNN+RDJ
// SIG // qgoYbFVhV9HxAizEtavybCPSnw0PGWythWJp/U6FwYpS
// SIG // Matb2Ml0UuNXbCK/VX9vygarP0q3InZl7Ow28paVgSYs
// SIG // /buYqgE4068lQJsJU/ApV4VYXuqFSEEhh+XetNMmsntA
// SIG // U1h5jlIxBk2UA0XEzjwD7LcA8joixbRv5e+wipsCAwEA
// SIG // AaOCAccwggHDMAwGA1UdEwEB/wQCMAAwZgYDVR0gBF8w
// SIG // XTBbBgtghkgBhvhFAQcXAzBMMCMGCCsGAQUFBwIBFhdo
// SIG // dHRwczovL2Quc3ltY2IuY29tL2NwczAlBggrBgEFBQcC
// SIG // AjAZGhdodHRwczovL2Quc3ltY2IuY29tL3JwYTBABgNV
// SIG // HR8EOTA3MDWgM6Axhi9odHRwOi8vdHMtY3JsLndzLnN5
// SIG // bWFudGVjLmNvbS9zaGEyNTYtdHNzLWNhLmNybDAWBgNV
// SIG // HSUBAf8EDDAKBggrBgEFBQcDCDAOBgNVHQ8BAf8EBAMC
// SIG // B4AwdwYIKwYBBQUHAQEEazBpMCoGCCsGAQUFBzABhh5o
// SIG // dHRwOi8vdHMtb2NzcC53cy5zeW1hbnRlYy5jb20wOwYI
// SIG // KwYBBQUHMAKGL2h0dHA6Ly90cy1haWEud3Muc3ltYW50
// SIG // ZWMuY29tL3NoYTI1Ni10c3MtY2EuY2VyMCgGA1UdEQQh
// SIG // MB+kHTAbMRkwFwYDVQQDExBUaW1lU3RhbXAtMjA0OC02
// SIG // MB0GA1UdDgQWBBSlEwGpn4XMG24WHl87Map5NgB7HTAf
// SIG // BgNVHSMEGDAWgBSvY9bKo06FcuCnvEHzKaI4f4B1YjAN
// SIG // BgkqhkiG9w0BAQsFAAOCAQEARp6v8LiiX6KZSM+oJ0sh
// SIG // zbK5pnJwYy/jVSl7OUZO535lBliLvFeKkg0I2BC6NiT6
// SIG // Cnv7O9Niv0qUFeaC24pUbf8o/mfPcT/mMwnZolkQ9B5K
// SIG // /mXM3tRr41IpdQBKK6XMy5voqU33tBdZkkHDtz+G5vbA
// SIG // f0Q8RlwXWuOkO9VpJtUhfeGAZ35irLdOLhWa5Zwjr1sR
// SIG // 6nGpQfkNeTipoQ3PtLHaPpp6xyLFdM3fRwmGxPyRJbIb
// SIG // lumFCOjd6nRgbmClVnoNyERY3Ob5SBSe5b/eAL13sZgU
// SIG // chQk38cRLB8AP8NLFMZnHMweBqOQX1xUiz7jM1uCD8W3
// SIG // hgJOcZ/pZkU/djGCAlowggJWAgEBMIGLMHcxCzAJBgNV
// SIG // BAYTAlVTMR0wGwYDVQQKExRTeW1hbnRlYyBDb3Jwb3Jh
// SIG // dGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0
// SIG // d29yazEoMCYGA1UEAxMfU3ltYW50ZWMgU0hBMjU2IFRp
// SIG // bWVTdGFtcGluZyBDQQIQe9Tlr7rMBz+hASMEIkFNEjAL
// SIG // BglghkgBZQMEAgGggaQwGgYJKoZIhvcNAQkDMQ0GCyqG
// SIG // SIb3DQEJEAEEMBwGCSqGSIb3DQEJBTEPFw0yMDAzMjMx
// SIG // NDAyNDlaMC8GCSqGSIb3DQEJBDEiBCCt4h/CxtbeI8ek
// SIG // HnzYnmKxDB+fUzMvEOsQ18KgHWanhTA3BgsqhkiG9w0B
// SIG // CRACLzEoMCYwJDAiBCDEdM52AH0COU4NpeTefBTGgPni
// SIG // ggE8/vZT7123H99h+DALBgkqhkiG9w0BAQEEggEACnvP
// SIG // 6Y4iUWzQggdTSuc25yC/nA0a9QpTXb93F4uBF9NOFLQ+
// SIG // pqsuqjy+lDy9stgdJ4oNz5ly+6BgMU8zekAgJqlQWTxD
// SIG // N43gN1vUjQUUqR1ZtPP9F6UR8QEHHzkNyo/YuxpSNaw/
// SIG // wdAwOmJ8LN92euh4L/CU9ldgVA859myyaS/BC1X28cw6
// SIG // Ww3NDn52KQZwj3vIkXel5ijPpb8zf6p7KDxtVNXZrh5X
// SIG // hoG0BVKR57qDs4gzqCmz9RRsyOV5VSvQGlD382NZ3/o8
// SIG // fJ4/0pfG/qxy6d6fXOph1iYS9wCdN+MknkJ+JU3QBOyn
// SIG // hXD4TQYSpEC763P8LqvKPyDUZndkMA==
// SIG // End signature block
