// TOC data processor (indexing, beadcrumbs etc).
(function($) {
	$.widget('adsk.tocdataprocessor', {
		options: {
            tocData: {},
            tocDataIndexedByHref: {},
            tocDataIndexedByTopicNumber: {},
            tocDataIndexedById: {}
		},

		/* Private members. */

		_create: function() {
            console.log('tocdataprocessor: _create');
		},

		_indexTocData: function(bookName, bookData) {
            console.log('tocdataprocessor: _indexTocData');

            if (bookData.attr !== undefined &&
                bookData.attr.tn !== undefined &&
                bookData.attr.href !== undefined &&
                bookData.attr.id !== undefined) {

                var topicNumber = bookData.attr.tn;
                this.options.tocDataIndexedByTopicNumber[bookName][topicNumber] = bookData;

                var topicHref = bookData.attr.href;
                this.options.tocDataIndexedByHref[bookName][topicHref] = bookData;

                var topicId = bookData.attr.id;
                this.options.tocDataIndexedById[bookName][topicId] = bookData;

                if (bookData.children) {
                    $.each(bookData.children, $.proxy(function(index, book) {
                        this._indexTocData(bookName, book);
                    }, this))
                }
            }
        },

        _getVisibleParentTopic: function(bookName, topic) {
            console.log('tocdataprocessor: _getParentTopic');

            if (topic && topic.attr.toc == "false") {
                return this._getVisibleParentTopic(bookName, this._getTopicByTopicNumber(bookName, topic.attr.pn));
            } else {
                return topic;
            }
        },

        // Used for breadcrumbs creation.
        _composeParentTopicArray: function() {
            console.log('tocdataprocessor: _composeParentTopicArray');

        },

        _getTopicByTopicNumber: function(bookName, topicNumber) {
            console.log('tocdataprocessor: _getTopicByTopicNumber');

            var toc = this.options.tocDataIndexedByTopicNumber;

            return toc[bookName] ? toc[bookName][topicNumber] : undefined;
        },

        _getTopicByHref: function(bookName, topicHref) {
            console.log('tocdataprocessor: _getTopicByHref');

            var toc = this.options.tocDataIndexedByHref;

            return toc[bookName] ? toc[bookName][topicHref] : undefined;
        },

        _getSiblingPage: function(bookName, topicNumber, attribute) {
            console.log('tocdataprocessor: _getSiblingPage');

            var currentTopic = this._getTopicByTopicNumber(bookName, topicNumber);

            if (currentTopic) {
                return this._getTopicByTopicNumber(bookName, currentTopic.attr[attribute]);
            } else {
                return undefined;
            }
        },

		/* Public members. */

		/*
		    data members:
		        bookName,
		        bookData,
		        loaded - position of current loaded book,
		        total - count of all books to load.
		*/
		setBookTocData: function(data) {
		    console.log('tocdataprocessor: setBookTocData, data = ', data);

		    var bookName    = data.bookName,
		        bookData    = data.bookData,
		        loaded      = data.loaded,
		        total       = data.total;

            if (bookData) {
                this.options.tocData[bookName] = bookData;
                this.options.tocDataIndexedByTopicNumber[bookName] = {};
                this.options.tocDataIndexedByHref[bookName] = {};
                this.options.tocDataIndexedById[bookName] = {};

                $.each(bookData, $.proxy(function(index, entry) {
                    this._indexTocData(bookName, entry);
                }, this))
            }

            if (total > 0) {
                this._trigger('progress', {}, {
                    percent: Math.round(loaded / total * 100)
                });
            }

            if (total === loaded) {
                this._trigger('indexed', {}, {
                    tocData: this.options.tocData,
                    tocDataIndexedByHref: this.options.tocDataIndexedByHref,
                    tocDataIndexedByTopicNumber: this.options.tocDataIndexedByTopicNumber,
                    tocIndexedById: this.options.tocDataIndexedById
                });
            }
		},

		getTopicDataByTopicNumber: function(bookName, topicNumber) {
		    console.log('tocdataprocessor: getTopicDataByTopicNumber');

            return this._getTopicByTopicNumber(bookName, topicNumber);
		},

		getTopicDataByHref: function(bookName, topicHref) {
            console.log('tocdataprocessor: getTopicDataByHref');

            return this._getTopicByHref(bookName, topicHref);
        },

        getNextTopicByTopicNumber: function(bookName, topicNumber) {
            console.log('tocdataprocessor: getNextTopicByTopicNumber');

            return this._getSiblingPage(bookName, topicNumber, "nxn");
        },

        getPreviousTopicByTopicNumber: function(bookName, topicNumber) {
            console.log('tocdataprocessor: getPreviousTopicByTopicNumber');

            return this._getSiblingPage(bookName, topicNumber, "prn");
        },

        getParentTopicByTopicNumber: function(bookName, topicNumber) {
            console.log('tocdataprocessor: getParentTopicByTopicNumber');

            return this._getSiblingPage(bookName, topicNumber, "pn");
        }
	});
})(jQuery);
// SIG // Begin signature block
// SIG // MIIgdwYJKoZIhvcNAQcCoIIgaDCCIGQCAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // tWCHJEAhQIrOgcMuUr9nQeipaNiaStdP35FvWch3peGg
// SIG // ggoaMIIEyzCCA7OgAwIBAgIQCQja65wGHi65un4mqmKH
// SIG // ijANBgkqhkiG9w0BAQsFADCBhDELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTUw
// SIG // MwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
// SIG // b2RlIFNpZ25pbmcgQ0EgLSBHMjAeFw0xOTA1MTQwMDAw
// SIG // MDBaFw0yMDA1MTMyMzU5NTlaMHwxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIDApDYWxpZm9ybmlhMRMwEQYDVQQHDApT
// SIG // YW4gUmFmYWVsMRcwFQYDVQQKDA5BdXRvZGVzaywgSW5j
// SIG // LjERMA8GA1UECwwIU2VjdXJpdHkxFzAVBgNVBAMMDkF1
// SIG // dG9kZXNrLCBJbmMuMIIBIjANBgkqhkiG9w0BAQEFAAOC
// SIG // AQ8AMIIBCgKCAQEAkVKRoPYsoxPdlabspcuG8HYDfcWQ
// SIG // 9qyPOT2punwpVdjt2slktcpSTlydrGy8ijcbl5/k8AOJ
// SIG // afKMQvow0fNjIoNB5nsb8j2xFJPbBhHl8GT4P6DZ1OWK
// SIG // ioiUXgGHKjctUws49J4elntqvBYhKCbuPqG772QCoYFU
// SIG // P7qcFbh3PbyNB6cnKMn2vNGRqiEtV2aGg+/MiL3QPsvT
// SIG // kTWhVuTLIvwZ4kK5C5ACiQzlGOlE+C7gWuFoxtvy6gUa
// SIG // A8JAq/xLjYKwFevQwGncg3s1cuiGhx0P7Rvn6oCd2cem
// SIG // FmbK3I3rMRt+jc9wzAj3oHxvCo4f5Lfva+OpC1dETUVV
// SIG // sk0VGwIDAQABo4IBPjCCATowCQYDVR0TBAIwADAOBgNV
// SIG // HQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMw
// SIG // YQYDVR0gBFowWDBWBgZngQwBBAEwTDAjBggrBgEFBQcC
// SIG // ARYXaHR0cHM6Ly9kLnN5bWNiLmNvbS9jcHMwJQYIKwYB
// SIG // BQUHAgIwGQwXaHR0cHM6Ly9kLnN5bWNiLmNvbS9ycGEw
// SIG // HwYDVR0jBBgwFoAU1MAGIknrOUvdk+JcobhHdglyA1gw
// SIG // KwYDVR0fBCQwIjAgoB6gHIYaaHR0cDovL3JiLnN5bWNi
// SIG // LmNvbS9yYi5jcmwwVwYIKwYBBQUHAQEESzBJMB8GCCsG
// SIG // AQUFBzABhhNodHRwOi8vcmIuc3ltY2QuY29tMCYGCCsG
// SIG // AQUFBzAChhpodHRwOi8vcmIuc3ltY2IuY29tL3JiLmNy
// SIG // dDANBgkqhkiG9w0BAQsFAAOCAQEA0Q2+iVSEfT4xGq3A
// SIG // OADVb0rT5Z8E+PPb1x6hKknSzuaZKk/acDz9mdnFajaU
// SIG // WgIKiFJlsqJnuAM1w4lqKaEWsz3DoxvGIEwexj71Ud6a
// SIG // KlBJNcR9DdkXUZwMhbw9d78rjJAIX6tOwfSludZfdq8b
// SIG // YEkuIzQi9uYW9vHVPSCzhnUBKjwc9qTo9yBc7Fcn4FAT
// SIG // 90DzWM2hS9oc3p0pprYI2I/O4th90BEmwWkVqVgfaR0z
// SIG // VyIEmBbqB/IWLfjUBZJ/8sbkwWuWlYVRrfPxsj1e9qvb
// SIG // wE3Y28jWyGbqoUG39GhXk3uT8R8i3+T6M0c4rMfdifBC
// SIG // pceCaFTJzSye7LoeVzCCBUcwggQvoAMCAQICEHwbNTVK
// SIG // 59t050FfEWnKa6gwDQYJKoZIhvcNAQELBQAwgb0xCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjEfMB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29y
// SIG // azE6MDgGA1UECxMxKGMpIDIwMDggVmVyaVNpZ24sIElu
// SIG // Yy4gLSBGb3IgYXV0aG9yaXplZCB1c2Ugb25seTE4MDYG
// SIG // A1UEAxMvVmVyaVNpZ24gVW5pdmVyc2FsIFJvb3QgQ2Vy
// SIG // dGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMTQwNzIyMDAw
// SIG // MDAwWhcNMjQwNzIxMjM1OTU5WjCBhDELMAkGA1UEBhMC
// SIG // VVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9u
// SIG // MR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3Jr
// SIG // MTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1
// SIG // NiBDb2RlIFNpZ25pbmcgQ0EgLSBHMjCCASIwDQYJKoZI
// SIG // hvcNAQEBBQADggEPADCCAQoCggEBANeVQ9Tc32euOftS
// SIG // pLYmMQRw6beOWyq6N2k1lY+7wDDnhthzu9/r0XY/ilaO
// SIG // 6y1L8FcYTrGNpTPTC3Uj1Wp5J92j0/cOh2W13q0c8fU1
// SIG // tCJRryKhwV1LkH/AWU6rnXmpAtceSbE7TYf+wnirv+9S
// SIG // rpyvCNk55ZpRPmlfMBBOcWNsWOHwIDMbD3S+W8sS4duM
// SIG // xICUcrv2RZqewSUL+6McntimCXBx7MBHTI99w94Zzj7u
// SIG // BHKOF9P/8LIFMhlM07Acn/6leCBCcEGwJoxvAMg6ABFB
// SIG // ekGwp4qRBKCZePR3tPNgKuZsUAS3FGD/DVH0qIuE/iHa
// SIG // XF599Sl5T7BEdG9tcv8CAwEAAaOCAXgwggF0MC4GCCsG
// SIG // AQUFBwEBBCIwIDAeBggrBgEFBQcwAYYSaHR0cDovL3Mu
// SIG // c3ltY2QuY29tMBIGA1UdEwEB/wQIMAYBAf8CAQAwZgYD
// SIG // VR0gBF8wXTBbBgtghkgBhvhFAQcXAzBMMCMGCCsGAQUF
// SIG // BwIBFhdodHRwczovL2Quc3ltY2IuY29tL2NwczAlBggr
// SIG // BgEFBQcCAjAZGhdodHRwczovL2Quc3ltY2IuY29tL3Jw
// SIG // YTA2BgNVHR8ELzAtMCugKaAnhiVodHRwOi8vcy5zeW1j
// SIG // Yi5jb20vdW5pdmVyc2FsLXJvb3QuY3JsMBMGA1UdJQQM
// SIG // MAoGCCsGAQUFBwMDMA4GA1UdDwEB/wQEAwIBBjApBgNV
// SIG // HREEIjAgpB4wHDEaMBgGA1UEAxMRU3ltYW50ZWNQS0kt
// SIG // MS03MjQwHQYDVR0OBBYEFNTABiJJ6zlL3ZPiXKG4R3YJ
// SIG // cgNYMB8GA1UdIwQYMBaAFLZ3+mlIR59TEtXC6gcydgfR
// SIG // lwcZMA0GCSqGSIb3DQEBCwUAA4IBAQB/68qn6ot2Qus+
// SIG // jiBUMOO3udz6SD4Wxw9FlRDNJ4ajZvMC7XH4qsJVl5Fw
// SIG // g/lSflJpPMnx4JRGgBi7odSkVqbzHQCR1YbzSIfgy8Q0
// SIG // aCBetMv5Be2cr3BTJ7noPn5RoGlxi9xR7YA6JTKfRK9u
// SIG // QyjTIXW7l9iLi4z+qQRGBIX3FZxLEY3ELBf+1W5/muJW
// SIG // kvGWs60t+fTf2omZzrI4RMD3R3vKJbn6Kmgzm1By3qif
// SIG // 1M0sCzS9izB4QOCNjicbkG8avggVgV3rL+JR51EeyXgp
// SIG // 5x5lvzjvAUoBCSQOFsQUecFBNzTQPZFSlJ3haO8I8OJp
// SIG // nGdukAsak3HUJgLDwFojMYIVtTCCFbECAQEwgZkwgYQx
// SIG // CzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRlYyBD
// SIG // b3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1
// SIG // c3QgTmV0d29yazE1MDMGA1UEAxMsU3ltYW50ZWMgQ2xh
// SIG // c3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENBIC0gRzIC
// SIG // EAkI2uucBh4uubp+Jqpih4owDQYJYIZIAWUDBAIBBQCg
// SIG // fDAQBgorBgEEAYI3AgEMMQIwADAZBgkqhkiG9w0BCQMx
// SIG // DAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4wDAYK
// SIG // KwYBBAGCNwIBFTAvBgkqhkiG9w0BCQQxIgQgLjQXRYmo
// SIG // Uylhuv3iQRKwa7IgBbYCz4OTf1Gs7f+Ahv4wDQYJKoZI
// SIG // hvcNAQEBBQAEggEAD9it7UHEld6E2Ec6HWLx3NpLPU4m
// SIG // 3syQHhylPlidA7qhREr6Q2I0a8YzcSikNfQCHci1OUAu
// SIG // pd+t3E+buX1rBOPXObW/Rzyo0CWWMhr2+NF0TGyhXLnN
// SIG // mAkzPuKx6alOTWg5A/sR/fdUZV+bcj+TRZRyvanWj/2L
// SIG // XtGGJ/JMBrXpIK3Ke9VvzlIuxJjOGxhkHZUJRY48j+HU
// SIG // VD9E5+4qN9hpf49sJGrWj9WYnnPcfPfioWzLMGDBjxJ0
// SIG // cbd1zEjAwi52Igl+XNOj4WXUacACM6s3dHeljDEbeutm
// SIG // 2XGM6lcA25lkiTRR+OfeCGn7ABlJf414tMuXYJdID0ZQ
// SIG // m2YT06GCE24wghNqBgorBgEEAYI3AwMBMYITWjCCE1YG
// SIG // CSqGSIb3DQEHAqCCE0cwghNDAgEDMQ8wDQYJYIZIAWUD
// SIG // BAIBBQAwggENBgsqhkiG9w0BCRABBKCB/QSB+jCB9wIB
// SIG // AQYKKwYBBAGyMQIBATAxMA0GCWCGSAFlAwQCAQUABCCu
// SIG // /10NBVAWGM2DFx/+HTtwkC3Eahd6eiYBLy1NTYH2TwIV
// SIG // AKIVktAoZ+e/VOAo1s4V0SL78pKzGA8yMDIwMDMyMzE0
// SIG // MDAxNFqggYqkgYcwgYQxCzAJBgNVBAYTAkdCMRswGQYD
// SIG // VQQIDBJHcmVhdGVyIE1hbmNoZXN0ZXIxEDAOBgNVBAcM
// SIG // B1NhbGZvcmQxGDAWBgNVBAoMD1NlY3RpZ28gTGltaXRl
// SIG // ZDEsMCoGA1UEAwwjU2VjdGlnbyBSU0EgVGltZSBTdGFt
// SIG // cGluZyBTaWduZXIgIzGggg36MIIHBjCCBO6gAwIBAgIQ
// SIG // PRo1cjAVgmMw0BNxfoJBCDANBgkqhkiG9w0BAQwFADB9
// SIG // MQswCQYDVQQGEwJHQjEbMBkGA1UECBMSR3JlYXRlciBN
// SIG // YW5jaGVzdGVyMRAwDgYDVQQHEwdTYWxmb3JkMRgwFgYD
// SIG // VQQKEw9TZWN0aWdvIExpbWl0ZWQxJTAjBgNVBAMTHFNl
// SIG // Y3RpZ28gUlNBIFRpbWUgU3RhbXBpbmcgQ0EwHhcNMTkw
// SIG // NTAyMDAwMDAwWhcNMzAwODAxMjM1OTU5WjCBhDELMAkG
// SIG // A1UEBhMCR0IxGzAZBgNVBAgMEkdyZWF0ZXIgTWFuY2hl
// SIG // c3RlcjEQMA4GA1UEBwwHU2FsZm9yZDEYMBYGA1UECgwP
// SIG // U2VjdGlnbyBMaW1pdGVkMSwwKgYDVQQDDCNTZWN0aWdv
// SIG // IFJTQSBUaW1lIFN0YW1waW5nIFNpZ25lciAjMTCCAiIw
// SIG // DQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBAMtRUP9W
// SIG // /vx4Y3ABk1qeGPQ7U/YHryFs9aIPfR1wLYR0SIucipUF
// SIG // PVmE+ZGAeVEs2Yq3wQuaugqKzWZPA4sBuzDKq73bwE8S
// SIG // XvwKzOJFsAE4irtN59QcVJjtOVjPW8IvRZgxCvk1OLgx
// SIG // Lm20Hjly4bgqvp+MjBqlRq4LK0yZ/ixL/Ci5IjpmF9Cq
// SIG // VoohwPOWJLTQhSZruvBvZJh5pq29XNhTaysK1nKKhUbj
// SIG // DRgG2sZ7QVY2mxU+8WoRoPdm9RjQgFVjh2hm6w55VYJc
// SIG // o+1JuHGGnpM3sGuj6mJso66W6Ln9i6vG9llbADxXIBgt
// SIG // cAOnnO+S63mhx13sfLSPS9/rXfyjIN2SOOVqUTprhZxM
// SIG // oJgIaVsG5yoZ0JWTiztrigUJKdjW2tvjcvpcSi97FVaG
// SIG // Mr9/BQmdLSrPUOHmYSDbxwaAXE4URr6uV3Giqmwwkxx+
// SIG // d8sG6VfNkfXVM3Ic4drKbuvzD+x5W7snnuge/i/yu3/p
// SIG // 5dBn67gNfKQrWQOLle0iKM36LDvHFhGv49axUGdpxY71
// SIG // edCt/4fM+H+q+aLtYfjIjWnasfRRketnV9FkEetkywO9
// SIG // SVU6RUMYLCVs0S8MLW/1QTUkoPJjWRZf2aTpLE7buzES
// SIG // xm34W24D3MsVjxuNcuzbDxWQ1hJO7uIAMSWTNW9qW6US
// SIG // Y0ABirlpiDqIuA8ZAgMBAAGjggF4MIIBdDAfBgNVHSME
// SIG // GDAWgBQaofhhGSAPw0F3RSiO0TVfBhIEVTAdBgNVHQ4E
// SIG // FgQUb02GB9gyJ54sKdLQEwOAgd0FgykwDgYDVR0PAQH/
// SIG // BAQDAgbAMAwGA1UdEwEB/wQCMAAwFgYDVR0lAQH/BAww
// SIG // CgYIKwYBBQUHAwgwQAYDVR0gBDkwNzA1BgwrBgEEAbIx
// SIG // AQIBAwgwJTAjBggrBgEFBQcCARYXaHR0cHM6Ly9zZWN0
// SIG // aWdvLmNvbS9DUFMwRAYDVR0fBD0wOzA5oDegNYYzaHR0
// SIG // cDovL2NybC5zZWN0aWdvLmNvbS9TZWN0aWdvUlNBVGlt
// SIG // ZVN0YW1waW5nQ0EuY3JsMHQGCCsGAQUFBwEBBGgwZjA/
// SIG // BggrBgEFBQcwAoYzaHR0cDovL2NydC5zZWN0aWdvLmNv
// SIG // bS9TZWN0aWdvUlNBVGltZVN0YW1waW5nQ0EuY3J0MCMG
// SIG // CCsGAQUFBzABhhdodHRwOi8vb2NzcC5zZWN0aWdvLmNv
// SIG // bTANBgkqhkiG9w0BAQwFAAOCAgEAwGjts9jUUJvv03XL
// SIG // Dzv3JNN6N0WNLO8W+1GpLB+1JbWKn10LwhsgdI1mDzbL
// SIG // qvY2DQ9+j0tKdENlrA0q9grta23FCTjtABv45dymCkAF
// SIG // R++Eygm8Q2aDv5/t24490UFksXACLQNXWxhvHCzLHrIA
// SIG // 6LoJL1uBBDW5qWNtjgjFGNHhIaz5EgoUwBLbfiWdrB0Q
// SIG // wFqlg9IfGmZV/Jsq4uw3V47l35Yw+MCTC0MY+QJvqVGv
// SIG // uFcK8xwHaTmPN5xt15GupS5J6Ures9CMvzmQDcCBzvAq
// SIG // BzoMpi1R0nLzU8b5ve/vDGlJd58sVsTpoQg9B67FHtaE
// SIG // Ise8fUMbWDhiTtEFJYTFQvgfL/bb+quMVOxFimwSTTBa
// SIG // UuWkFwki5u9v9V+GQ9+hLb1KRpKggZYsYZd/QG/YP4w1
// SIG // WqvRxqA7hWZUgO8fGvXxm7ChJ32y5wvP9i2cWBOUqYb8
// SIG // RVKiKG1/dA9SkUl66RL4qTuwkv19kRTpW21IlPLIlu4F
// SIG // OLPF7DA/4QcgBLHYi7z9sz5v8gJTBvSg7cmacqOXXwD7
// SIG // y2PQ6M10/XXJ1DZFunsSWXLt5/J6UAB4+EOaRtjfv1TU
// SIG // XrHH0bwbg/Qr5wvoR8hTnswarPb6inVTbCCFqdW4arok
// SIG // joorCJGfNwQc9m+i3TSqkf/GFS4eQhoJKU/0xs3ikaLT
// SIG // QAyOeOMwggbsMIIE1KADAgECAhAwD2+s3WaYdHypRjan
// SIG // eC25MA0GCSqGSIb3DQEBDAUAMIGIMQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKTmV3IEplcnNleTEUMBIGA1UEBxML
// SIG // SmVyc2V5IENpdHkxHjAcBgNVBAoTFVRoZSBVU0VSVFJV
// SIG // U1QgTmV0d29yazEuMCwGA1UEAxMlVVNFUlRydXN0IFJT
// SIG // QSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAeFw0xOTA1
// SIG // MDIwMDAwMDBaFw0zODAxMTgyMzU5NTlaMH0xCzAJBgNV
// SIG // BAYTAkdCMRswGQYDVQQIExJHcmVhdGVyIE1hbmNoZXN0
// SIG // ZXIxEDAOBgNVBAcTB1NhbGZvcmQxGDAWBgNVBAoTD1Nl
// SIG // Y3RpZ28gTGltaXRlZDElMCMGA1UEAxMcU2VjdGlnbyBS
// SIG // U0EgVGltZSBTdGFtcGluZyBDQTCCAiIwDQYJKoZIhvcN
// SIG // AQEBBQADggIPADCCAgoCggIBAMgbAa/ZLH6ImX0BmD8g
// SIG // kL2cgCFUk7nPoD5T77NawHbWGgSlzkeDtevEzEk0y/NF
// SIG // Zbn5p2QWJgn71TJSeS7JY8ITm7aGPwEFkmZvIavVcRB5
// SIG // h/RGKs3EWsnb111JTXJWD9zJ41OYOioe/M5YSdO/8zm7
// SIG // uaQjQqzQFcN/nqJc1zjxFrJw06PE37PFcqwuCnf8DZRS
// SIG // t/wflXMkPQEovA8NT7ORAY5unSd1VdEXOzQhe5cBlK9/
// SIG // gM/REQpXhMl/VuC9RpyCvpSdv7QgsGB+uE31DT/b0OqF
// SIG // jIpWcdEtlEzIjDzTFKKcvSb/01Mgx2Bpm1gKVPQF5/0x
// SIG // rPnIhRfHuCkZpCkvRuPd25Ffnz82Pg4wZytGtzWvlr7a
// SIG // TGDMqLufDRTUGMQwmHSCIc9iVrUhcxIe/arKCFiHd6QV
// SIG // 6xlV/9A5VC0m7kUaOm/N14Tw1/AoxU9kgwLU++Le8bwC
// SIG // KPRt2ieKBtKWh97oaw7wW33pdmmTIBxKlyx3GSuTlZic
// SIG // l57rjsF4VsZEJd8GEpoGLZ8DXv2DolNnyrH6jaFkyYiS
// SIG // WcuoRsDJ8qb/fVfbEnb6ikEk1Bv8cqUUotStQxykSYtB
// SIG // ORQDHin6G6UirqXDTYLQjdprt9v3GEBXc/Bxo/tKfUU2
// SIG // wfeNgvq5yQ1TgH36tjlYMu9vGFCJ10+dM70atZ2h3pVB
// SIG // eqeDAgMBAAGjggFaMIIBVjAfBgNVHSMEGDAWgBRTeb9a
// SIG // qitKz1SA4dibwJ3ysgNmyzAdBgNVHQ4EFgQUGqH4YRkg
// SIG // D8NBd0UojtE1XwYSBFUwDgYDVR0PAQH/BAQDAgGGMBIG
// SIG // A1UdEwEB/wQIMAYBAf8CAQAwEwYDVR0lBAwwCgYIKwYB
// SIG // BQUHAwgwEQYDVR0gBAowCDAGBgRVHSAAMFAGA1UdHwRJ
// SIG // MEcwRaBDoEGGP2h0dHA6Ly9jcmwudXNlcnRydXN0LmNv
// SIG // bS9VU0VSVHJ1c3RSU0FDZXJ0aWZpY2F0aW9uQXV0aG9y
// SIG // aXR5LmNybDB2BggrBgEFBQcBAQRqMGgwPwYIKwYBBQUH
// SIG // MAKGM2h0dHA6Ly9jcnQudXNlcnRydXN0LmNvbS9VU0VS
// SIG // VHJ1c3RSU0FBZGRUcnVzdENBLmNydDAlBggrBgEFBQcw
// SIG // AYYZaHR0cDovL29jc3AudXNlcnRydXN0LmNvbTANBgkq
// SIG // hkiG9w0BAQwFAAOCAgEAbVSBpTNdFuG1U4GRdd8DejIL
// SIG // LSWEEbKw2yp9KgX1vDsn9FqguUlZkClsYcu1UNviffmf
// SIG // AO9Aw63T4uRW+VhBz/FC5RB9/7B0H4/GXAn5M17qoBwm
// SIG // WFzztBEP1dXD4rzVWHi/SHbhRGdtj7BDEA+N5Pk4Yr8T
// SIG // AcWFo0zFzLJTMJWk1vSWVgi4zVx/AZa+clJqO0I3fBZ4
// SIG // OZOTlJux3LJtQW1nzclvkD1/RXLBGyPWwlWEZuSzxWYG
// SIG // 9vPWS16toytCiiGS/qhvWiVwYoFzY16gu9jc10rTPa+D
// SIG // BjgSHSSHLeT8AtY+dwS8BDa153fLnC6NIxi5o8JHHfBd
// SIG // 1qFzVwVomqfJN2Udvuq82EKDQwWli6YJ/9GhlKZOqj0J
// SIG // 9QVst9JkWtgqIsJLnfE5XkzeSD2bNJaaCV+O/fexUpHO
// SIG // P4n2HKG1qXUfcb9bQ11lPVCBbqvw0NP8srMftpmWJvQ8
// SIG // eYtcZMzN7iea5aDADHKHwW5NWtMe6vBE5jJvHOsXTpTD
// SIG // eGUgOw9Bqh/poUGd/rG4oGUqNODeqPk85sEwu8CgYyz8
// SIG // XBYAqNDEf+oRnR4GxqZtMl20OAkrSQeq/eww2vGnL8+3
// SIG // /frQo4TZJ577AWZ3uVYQ4SBuxq6x+ba6yDVdM3aO8Xwg
// SIG // DCp3rrWiAoa6Ke60WgCxjKvj+QrJVF3UuWp0nr1Irpgx
// SIG // ggQcMIIEGAIBATCBkTB9MQswCQYDVQQGEwJHQjEbMBkG
// SIG // A1UECBMSR3JlYXRlciBNYW5jaGVzdGVyMRAwDgYDVQQH
// SIG // EwdTYWxmb3JkMRgwFgYDVQQKEw9TZWN0aWdvIExpbWl0
// SIG // ZWQxJTAjBgNVBAMTHFNlY3RpZ28gUlNBIFRpbWUgU3Rh
// SIG // bXBpbmcgQ0ECED0aNXIwFYJjMNATcX6CQQgwDQYJYIZI
// SIG // AWUDBAIBBQCgggFbMBoGCSqGSIb3DQEJAzENBgsqhkiG
// SIG // 9w0BCRABBDAcBgkqhkiG9w0BCQUxDxcNMjAwMzIzMTQw
// SIG // MDE0WjAvBgkqhkiG9w0BCQQxIgQgLu3nfAe7Tt8rdVHW
// SIG // cP6ulikvWKQWddXCcj4sRMgJmNAwge0GCyqGSIb3DQEJ
// SIG // EAIMMYHdMIHaMIHXMBYEFCXIrHNOSFC3+NkTkagbkkk2
// SIG // ZZ9hMIG8BBQC1luV4oNwwVcAlfqI+SPdk3+tjzCBozCB
// SIG // jqSBizCBiDELMAkGA1UEBhMCVVMxEzARBgNVBAgTCk5l
// SIG // dyBKZXJzZXkxFDASBgNVBAcTC0plcnNleSBDaXR5MR4w
// SIG // HAYDVQQKExVUaGUgVVNFUlRSVVNUIE5ldHdvcmsxLjAs
// SIG // BgNVBAMTJVVTRVJUcnVzdCBSU0EgQ2VydGlmaWNhdGlv
// SIG // biBBdXRob3JpdHkCEDAPb6zdZph0fKlGNqd4LbkwDQYJ
// SIG // KoZIhvcNAQEBBQAEggIAW507nHZLmNe5HMCPchOHRVlq
// SIG // hlw1Vh/lCdNxyh/8DRh7IYGvc81cpEnUOXae34NYnsfo
// SIG // HXG9v8LHApRnU4E7zGWMkWqm8ZSfxt4c2daS1QQaA4Nn
// SIG // XtyVJBHezl+kiQXX031dnBArWVgCJzpdwDZSbOuCrBre
// SIG // yO8TqHp+R4UKP2Mpn6yr2A6fwHsqcI8smJT8Imo6rVEy
// SIG // 4qSvuIhqKrldTgL3ICkvQa5pMf5XraKI9a3wXwDSNcLd
// SIG // o+bElGa3kwtPcsm/1H7K+btr0WMZ9ENQRU23/DYBZ5iZ
// SIG // eYxITVLFmXssg1ckdbmOoFOsDOrJVD047+JXa7e3hMI+
// SIG // lnhz3reTpQomDtSD6jkpd8q/Xprb4xBLK3piBt0/wJR8
// SIG // lNHO+UhRKrc2xTAlAuaTdgMMO/UToOPVK8P9QD4KO0GR
// SIG // 7gV7odQWdvw6OrRbNqTUA/URiXEWhfQ9/g+hbhUQCjOZ
// SIG // JtqjHxk8Fbh1g/TvwiDY7bdkm7cLgBMeM4M9MtQwd5Cq
// SIG // 5U60oYXbkBL/+AfOfCN7/1fWhqQWtvy6R/oRB+dK/Iqg
// SIG // hc5e85KzCuzsqh4Zj/6hlhC6rQvGdfZ1es8lsYFpM5f8
// SIG // l6u876nJPTO/Hiwu5GoomXKNo4veZdW2ep3DCznU9oA2
// SIG // dsaosOXP9qCWCVGrKi6zBOAQOlJkT5OBAwIguDvODw8=
// SIG // End signature block
