// Topic view (jQuery UI widget).
(function ($) {
    $.widget('adsk.topicview', {
        options: {
            caption: "Topic"
        },

        $content: undefined,
        $header: undefined,
        $favorites: undefined,

        goToParentButtonEnabled: false,
        favoritesButtonEnabled: false,
        goBackButtonEnabled: false,

        _create: function() {
            console.log('topicview: _create');

            // Render view.
            this._render();

            // Handle UI events.
            this._addEventHandlers();
        },

        _render: function() {
            console.log('topicview: _render');

            // Create topic view markup.
            this.element.html(
              '<header class="toolbar drop-shadow">' +
                '<div class="column left">' +
                    '<a href="#" id="topic-navigation" class="navigation button icon"/>' +
                    '<a href="#" id="topic-back" class="back button icon disabled"/>' +
                    '<a href="#" id="topic-parent" class="parent button icon disabled"/>' +
                    '<a href="#" id="topic-home" class="home button icon"/>' +
                '</div>' +
                '<div class="column center"></div>' +
                '<div class="column right">' +
                    '<a href="#" id="topic-share" class="share button icon"/>' +
                    '<a href="#" id="topic-favorites" class="favorites button icon disabled"/>' +
                    '<a href="#" id="topic-search" class="search button icon"/>' +
                '</div>' +
              '</header>' +
              '<div class="content"></div>' +
              '<footer class="toolbar">' +
                '<a href="#" class="preceding-topic">' +
                  '<div class="label">Previous topic</div>' +
                  '<div class="name"></div>' +
                  '<div class="path"></div>' +
                '</a>' +
                '<a href="#" class="following-topic">' +
                  '<div class="label">Next topic</div>' +
                  '<div class="name"></div>' +
                  '<div class="path"></div>' +
                '</a>' +
              '</footer>'
            );

            // Store jQuery objects for later use.
            this.$header = this.element.find('header');
            this.$footer = this.element.find('footer');
            this.$content = this.element.find('.content');
            this.$favorites = this.element.find('#topic-favorites');
        },

        _addEventHandlers: function() {
            console.log('topicview: _addEventHandlers');

            // Add look to all tapped buttons.
            this.$header.find('.button')
            .on('touchstart', $.proxy(this._handleToolbarButtonTouchstart, this))
            .on('touchend', $.proxy(this._handleToolbarButtonTouchend, this));

            this.element
            .on('touchmove', function(event) {
                event.preventDefault();
            });

            this.$content
            .on('touchmove', function(event) {
                // Prevent bubbling to enable native scrolling.
                event.stopPropagation();
            });
        },

        _handleToolbarButtonTouchstart: function(event) {
            console.log('topicview: _handleToolbarButtonTouchstart');

            event.preventDefault();
            event.stopPropagation();

            var $target = $(event.target);

            if (!$target.hasClass('disabled')) {
                $target.addClass("tapped");
            }
        },

        _handleToolbarButtonTouchend: function(event) {
            event.preventDefault();
            event.stopPropagation();

            var $target = $(event.target);

            if (!$target.hasClass('disabled')) {
                // Style tapped button.
                $target.removeClass('tapped');

                // Trigger 'buttontap' custom event.
                this._trigger('buttontap', event, $target.attr('id'));
            }
        },

        _setContentHeight: function() {
            console.log('topicview: _setContentHeight');

            var height = $(document).height() - this.$header.height() - this.$footer.height();

            this.$content.css('height', height + 'px');
        },

        _isAbsolutePath: function(url) {
             if ((url.indexOf('http:') == 0) || (url.indexOf('https:') == 0)) {
                 return true;
             }
             return false;
        },

        _changeImageSrc: function(src, base) {
            var changedSrc = src;

            if (src && !this._isAbsolutePath(src)) {
                if (!base) {
                    base = './files/';
                }

                if (src.indexOf('../') == 0) {
                    // ../images/image.png.

                    // Strip "move up to one folder" command.
                    changedSrc = src.substr(1);
                } else {
                    // ./image.png or images.png

                    // Remove './'.
                    if (src.indexOf('./') == 0) {
                        src = src.substr(2);
                    }

                    changedSrc = base.concat(src);
                }

                return changedSrc;
            }
        },

        _changeHyperlinkHref: function(hyperlink, base) {
            var url = hyperlink.getAttribute('href'),
                changedUrl = url,
                target = hyperlink.getAttribute('target');

            if (url && !this._isAbsolutePath(url)) {
                // Not an anchor and not an absolute url.

                if (url.indexOf('../') == 0) {
                    // "Move up one folder" relative path (cases 3, 4 and 5).

                    // Strip "move up to one folder" command.
                    changedUrl = url.substr(1);

                    if (target !== '_blank') {
                         // Add hashbang (case 5).
                         changedUrl = '#!/url='.concat(changedUrl);
                    }
                } else if ((url.charAt(0) != '#') &&
                           (url.indexOf('mailto:') != 0) &&
                           (url.indexOf('javascript') != 0)) {
                    // "Current folder" relative path (topic.htm or ./topic.htm).

                    // Remove './'.
                    if (url.indexOf('./') == 0) {
                        url = url.substr(2);
                    }

                    // Add hashbang and base path (e.g. #!url=./files/topic.htm)
                    changedUrl = '#!/url='.concat(base, url);
                } else if (url == '#') {
                    changedUrl = location.hash;
                }

                hyperlink.setAttribute('href', changedUrl);
            }
        },

        /* Public members. */

        getShareButtonOffset: function() {
            console.log('topicview: getShareButtonOffset');

            var $page = this.element,
                offset = $page.find('#topic-share').offset();

            return offset;
        },

        loadPage: function(href, title, base) {
            console.log('topicview: loadPage, href = ' + href);

            var self = this;

            $container = this.element.find('.content');

            // TODO: find robust way.
            $container.html('');

            var xhr = $
            .get(href)
            .done(function(response) {
                // Replace src attribute with data-src to prevent jQuery html()
                // from triggering the browser request images.
                response = response.replace(/ src=/g, ' data-src=');

                var $bodyContent = $(response).filter('#body-content');

                if (!$bodyContent.length) {
                    $bodyContent = $(response.substring(response.indexOf("<body>"), response.indexOf("</body>") + 7));
                }

                if ($bodyContent.length) {
                    // Replace <a> elements href attribute value.
                    $bodyContent.find('a, area').each(function() {
                        self._changeHyperlinkHref(this, base);
                    });

                    // Add src attributes to <img> elements with slightly changed value of data-src attribute.
                    var images = $bodyContent.find('img');
                    images.each(function() {
                        this.setAttribute('src', self._changeImageSrc(this.getAttribute('data-src')));
                    });

                    // Add collapsible section click listener.
                    images.filter('.collapsible').click(function(event) {
                        var img = $(this);

                        img.toggleClass('opened');

                        // Show/hide collapsible section.
                        img.parents('.collapsible').find('.collapsible-section').toggleClass('hidden');
                    });

                    // Place topic content into container.
                    $container.html($bodyContent);

                    // Scroll to anchor.
                    var fragment = '';
                    if (href.lastIndexOf('#') != -1) {
                        fragment = href.substring(href.lastIndexOf('#') + 1);

                        if (fragment !== undefined && fragment !== '') {
                            var $anchor = $('a[name=' + fragment + ']');

                            console.log('scroll to fragment: ', fragment);
                            $container.scrollTo($anchor, 800);
                        }
                    }

                } else {
                    $container.html(response);
                }

                // Get topic base url.
                var splittedHref = href.split('/'),
                    baseUrl = splittedHref.slice(0, splittedHref.length - 1).join('/');

                    // Override content links and add swipe handlers.
                    self.addBodyContentHandlers(baseUrl);
                })
            .fail(function(response) {
                $container.html(response);
            })
            .always(function() {

            });
        },

        initGoToParentButton: function(enabled) {
            this.goToParentButtonEnabled = enabled;

            if (enabled) {
                this.$header.find('#topic-parent').removeClass('disabled');
            } else {
                this.$header.find('#topic-parent').addClass('disabled');
            }
        },

        initFavoritesButton: function(enabled) {
            this.favoritesButtonEnabled = enabled;

            if (enabled) {
                this.$header.find('#topic-favorites').removeClass('disabled');
            } else {
                this.$header.find('#topic-favorites').addClass('disabled');
            }
        },

        initGoBackButton: function(enabled) {
            this.goBackButtonEnabled = enabled;

            if (enabled) {
                this.$header.find('#topic-back').removeClass('disabled');
            } else {
                this.$header.find('#topic-back').addClass('disabled');
            }
        },

        resize: function() {
            console.log('topicview: resize');

            // Set content container height.
            this._setContentHeight();
        },

        // Flag if topic is in Favorites or not.
        flag: function(addedToFavorites) {
            console.log('topicview: flag');

            if (addedToFavorites) {
                this.$favorites.addClass('flagged');
            } else {
                this.$favorites.removeClass('flagged');
            }
        },

        addBodyContentHandlers: function(baseUrl) {
            console.log('topicview: addBodyContentHandlers');

            // Listen for ALL links at the top level of topic content.
            /*
            $bodyContent
            .on("click", "a", $.proxy(function(event) {
                var $target = $(event.target),
                    targetAttr = $target.attr('target');

                // For some browsers, target is undefined; for others,
                // target is false. Check for both.
                if (typeof targetAttr !== 'undefined' && targetAttr !== false) {
                    // Use default browser action.
                } else {
                    var parser = document.createElement('a');
                    parser.href = $target.attr('href');

                    var href = $target.attr('href');

                    if (location.host == parser.host) {
                        // Stop the default behavior of the browser, which
                        // is to change the URL of the page.
                        event.preventDefault();

                        // Fire event to change location hash.
                        this._trigger('opentopic', {}, {
                            href: baseUrl + '/' + href // resolve
                        });
                    } else {
                        // Use default browser action.
                    }
                }
            }, this));
            */

            this._runRetinaJS();
        },

        _runRetinaJS: function() {
            $('#body-content').find('img').retina('--2x');
        }
    });
})(jQuery);

// SIG // Begin signature block
// SIG // MIIZfQYJKoZIhvcNAQcCoIIZbjCCGWoCAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // V8IYNt/8yREf0o2EzHKm2QFjZGG3Ptp6R7oYAsYjIKqg
// SIG // ggoaMIIEyzCCA7OgAwIBAgIQCQja65wGHi65un4mqmKH
// SIG // ijANBgkqhkiG9w0BAQsFADCBhDELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTUw
// SIG // MwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
// SIG // b2RlIFNpZ25pbmcgQ0EgLSBHMjAeFw0xOTA1MTQwMDAw
// SIG // MDBaFw0yMDA1MTMyMzU5NTlaMHwxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIDApDYWxpZm9ybmlhMRMwEQYDVQQHDApT
// SIG // YW4gUmFmYWVsMRcwFQYDVQQKDA5BdXRvZGVzaywgSW5j
// SIG // LjERMA8GA1UECwwIU2VjdXJpdHkxFzAVBgNVBAMMDkF1
// SIG // dG9kZXNrLCBJbmMuMIIBIjANBgkqhkiG9w0BAQEFAAOC
// SIG // AQ8AMIIBCgKCAQEAkVKRoPYsoxPdlabspcuG8HYDfcWQ
// SIG // 9qyPOT2punwpVdjt2slktcpSTlydrGy8ijcbl5/k8AOJ
// SIG // afKMQvow0fNjIoNB5nsb8j2xFJPbBhHl8GT4P6DZ1OWK
// SIG // ioiUXgGHKjctUws49J4elntqvBYhKCbuPqG772QCoYFU
// SIG // P7qcFbh3PbyNB6cnKMn2vNGRqiEtV2aGg+/MiL3QPsvT
// SIG // kTWhVuTLIvwZ4kK5C5ACiQzlGOlE+C7gWuFoxtvy6gUa
// SIG // A8JAq/xLjYKwFevQwGncg3s1cuiGhx0P7Rvn6oCd2cem
// SIG // FmbK3I3rMRt+jc9wzAj3oHxvCo4f5Lfva+OpC1dETUVV
// SIG // sk0VGwIDAQABo4IBPjCCATowCQYDVR0TBAIwADAOBgNV
// SIG // HQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMw
// SIG // YQYDVR0gBFowWDBWBgZngQwBBAEwTDAjBggrBgEFBQcC
// SIG // ARYXaHR0cHM6Ly9kLnN5bWNiLmNvbS9jcHMwJQYIKwYB
// SIG // BQUHAgIwGQwXaHR0cHM6Ly9kLnN5bWNiLmNvbS9ycGEw
// SIG // HwYDVR0jBBgwFoAU1MAGIknrOUvdk+JcobhHdglyA1gw
// SIG // KwYDVR0fBCQwIjAgoB6gHIYaaHR0cDovL3JiLnN5bWNi
// SIG // LmNvbS9yYi5jcmwwVwYIKwYBBQUHAQEESzBJMB8GCCsG
// SIG // AQUFBzABhhNodHRwOi8vcmIuc3ltY2QuY29tMCYGCCsG
// SIG // AQUFBzAChhpodHRwOi8vcmIuc3ltY2IuY29tL3JiLmNy
// SIG // dDANBgkqhkiG9w0BAQsFAAOCAQEA0Q2+iVSEfT4xGq3A
// SIG // OADVb0rT5Z8E+PPb1x6hKknSzuaZKk/acDz9mdnFajaU
// SIG // WgIKiFJlsqJnuAM1w4lqKaEWsz3DoxvGIEwexj71Ud6a
// SIG // KlBJNcR9DdkXUZwMhbw9d78rjJAIX6tOwfSludZfdq8b
// SIG // YEkuIzQi9uYW9vHVPSCzhnUBKjwc9qTo9yBc7Fcn4FAT
// SIG // 90DzWM2hS9oc3p0pprYI2I/O4th90BEmwWkVqVgfaR0z
// SIG // VyIEmBbqB/IWLfjUBZJ/8sbkwWuWlYVRrfPxsj1e9qvb
// SIG // wE3Y28jWyGbqoUG39GhXk3uT8R8i3+T6M0c4rMfdifBC
// SIG // pceCaFTJzSye7LoeVzCCBUcwggQvoAMCAQICEHwbNTVK
// SIG // 59t050FfEWnKa6gwDQYJKoZIhvcNAQELBQAwgb0xCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjEfMB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29y
// SIG // azE6MDgGA1UECxMxKGMpIDIwMDggVmVyaVNpZ24sIElu
// SIG // Yy4gLSBGb3IgYXV0aG9yaXplZCB1c2Ugb25seTE4MDYG
// SIG // A1UEAxMvVmVyaVNpZ24gVW5pdmVyc2FsIFJvb3QgQ2Vy
// SIG // dGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMTQwNzIyMDAw
// SIG // MDAwWhcNMjQwNzIxMjM1OTU5WjCBhDELMAkGA1UEBhMC
// SIG // VVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9u
// SIG // MR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3Jr
// SIG // MTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1
// SIG // NiBDb2RlIFNpZ25pbmcgQ0EgLSBHMjCCASIwDQYJKoZI
// SIG // hvcNAQEBBQADggEPADCCAQoCggEBANeVQ9Tc32euOftS
// SIG // pLYmMQRw6beOWyq6N2k1lY+7wDDnhthzu9/r0XY/ilaO
// SIG // 6y1L8FcYTrGNpTPTC3Uj1Wp5J92j0/cOh2W13q0c8fU1
// SIG // tCJRryKhwV1LkH/AWU6rnXmpAtceSbE7TYf+wnirv+9S
// SIG // rpyvCNk55ZpRPmlfMBBOcWNsWOHwIDMbD3S+W8sS4duM
// SIG // xICUcrv2RZqewSUL+6McntimCXBx7MBHTI99w94Zzj7u
// SIG // BHKOF9P/8LIFMhlM07Acn/6leCBCcEGwJoxvAMg6ABFB
// SIG // ekGwp4qRBKCZePR3tPNgKuZsUAS3FGD/DVH0qIuE/iHa
// SIG // XF599Sl5T7BEdG9tcv8CAwEAAaOCAXgwggF0MC4GCCsG
// SIG // AQUFBwEBBCIwIDAeBggrBgEFBQcwAYYSaHR0cDovL3Mu
// SIG // c3ltY2QuY29tMBIGA1UdEwEB/wQIMAYBAf8CAQAwZgYD
// SIG // VR0gBF8wXTBbBgtghkgBhvhFAQcXAzBMMCMGCCsGAQUF
// SIG // BwIBFhdodHRwczovL2Quc3ltY2IuY29tL2NwczAlBggr
// SIG // BgEFBQcCAjAZGhdodHRwczovL2Quc3ltY2IuY29tL3Jw
// SIG // YTA2BgNVHR8ELzAtMCugKaAnhiVodHRwOi8vcy5zeW1j
// SIG // Yi5jb20vdW5pdmVyc2FsLXJvb3QuY3JsMBMGA1UdJQQM
// SIG // MAoGCCsGAQUFBwMDMA4GA1UdDwEB/wQEAwIBBjApBgNV
// SIG // HREEIjAgpB4wHDEaMBgGA1UEAxMRU3ltYW50ZWNQS0kt
// SIG // MS03MjQwHQYDVR0OBBYEFNTABiJJ6zlL3ZPiXKG4R3YJ
// SIG // cgNYMB8GA1UdIwQYMBaAFLZ3+mlIR59TEtXC6gcydgfR
// SIG // lwcZMA0GCSqGSIb3DQEBCwUAA4IBAQB/68qn6ot2Qus+
// SIG // jiBUMOO3udz6SD4Wxw9FlRDNJ4ajZvMC7XH4qsJVl5Fw
// SIG // g/lSflJpPMnx4JRGgBi7odSkVqbzHQCR1YbzSIfgy8Q0
// SIG // aCBetMv5Be2cr3BTJ7noPn5RoGlxi9xR7YA6JTKfRK9u
// SIG // QyjTIXW7l9iLi4z+qQRGBIX3FZxLEY3ELBf+1W5/muJW
// SIG // kvGWs60t+fTf2omZzrI4RMD3R3vKJbn6Kmgzm1By3qif
// SIG // 1M0sCzS9izB4QOCNjicbkG8avggVgV3rL+JR51EeyXgp
// SIG // 5x5lvzjvAUoBCSQOFsQUecFBNzTQPZFSlJ3haO8I8OJp
// SIG // nGdukAsak3HUJgLDwFojMYIOuzCCDrcCAQEwgZkwgYQx
// SIG // CzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRlYyBD
// SIG // b3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1
// SIG // c3QgTmV0d29yazE1MDMGA1UEAxMsU3ltYW50ZWMgQ2xh
// SIG // c3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENBIC0gRzIC
// SIG // EAkI2uucBh4uubp+Jqpih4owDQYJYIZIAWUDBAIBBQCg
// SIG // fDAQBgorBgEEAYI3AgEMMQIwADAZBgkqhkiG9w0BCQMx
// SIG // DAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4wDAYK
// SIG // KwYBBAGCNwIBFTAvBgkqhkiG9w0BCQQxIgQg+NT1VOej
// SIG // onAdemw8wap9eoIHJK/NMExYNXclomaC5bIwDQYJKoZI
// SIG // hvcNAQEBBQAEggEAWMW4QZRb0JIIOz5SLsra0hj1iWNv
// SIG // VZpP7GQtTnhv6QiJF2FronZEYnRnlJFP/uuo3Obj+ZPS
// SIG // dayIP4zBrkxJricgHc9vpRIQ4ouLMaY+bxIA3PvEwriE
// SIG // w0GvDdePy7RZxMrCbzjtyejaRzffvif4thtZ+YL2K+sc
// SIG // dHrivzlf6jYrvEDzssmLV8RrR5MpW1f28WyVyaMaYi2L
// SIG // EM6x9tAOpJZV4jnQTIwldL8lWZUdbd1wKUudTWjXdqHD
// SIG // Jkn4vOKt9ZnqXH/BArNB8wQZfL0fQ4xT1JXuSspwwSS2
// SIG // l9BqELK7falaZvtSycLu0YE7HvjzCRPrLIo25zyY+oQ7
// SIG // hGDX9aGCDHQwggxwBgorBgEEAYI3AwMBMYIMYDCCDFwG
// SIG // CSqGSIb3DQEHAqCCDE0wggxJAgEDMQ8wDQYJYIZIAWUD
// SIG // BAIBBQAwga8GCyqGSIb3DQEJEAEEoIGfBIGcMIGZAgEB
// SIG // BgkrBgEEAaAyAgMwMTANBglghkgBZQMEAgEFAAQgoFg+
// SIG // /9Bru9Jx2j9v+CBJW0lRMyfg50GiC8TrYG2JGz8CFGSr
// SIG // Uo4eLcjUhtmmeRxvza7HCt6SGA8yMDIwMDMyMzEzNTk0
// SIG // NVqgL6QtMCsxKTAnBgNVBAMMIEdsb2JhbFNpZ24gVFNB
// SIG // IGZvciBBZHZhbmNlZCAtIEcyoIII0zCCBLYwggOeoAMC
// SIG // AQICDAynz10HBySsieeaOjANBgkqhkiG9w0BAQsFADBb
// SIG // MQswCQYDVQQGEwJCRTEZMBcGA1UEChMQR2xvYmFsU2ln
// SIG // biBudi1zYTExMC8GA1UEAxMoR2xvYmFsU2lnbiBUaW1l
// SIG // c3RhbXBpbmcgQ0EgLSBTSEEyNTYgLSBHMjAeFw0xODAy
// SIG // MTkwMDAwMDBaFw0yOTAzMTgxMDAwMDBaMCsxKTAnBgNV
// SIG // BAMMIEdsb2JhbFNpZ24gVFNBIGZvciBBZHZhbmNlZCAt
// SIG // IEcyMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKC
// SIG // AQEAt8eSiijY85HLUA1d6ylEwYJZpcpkzr2DtVHllMxu
// SIG // gJoXbNz/YuY2Q14Bwgxkjcp3nvZdd0W5Xsgk60E3EWY3
// SIG // rMjNdJvMs+9M4n8bznO+yZadNR5891T3bOygEtaumZ1j
// SIG // xHhfWakuIvXDJ9iyW0VjJ5D/jLE9qbTzDsDxIGUGiZ0D
// SIG // HKOwUkGFNOu8y85U9hL+swGJSqb6VMUf+9McwOO/l+M/
// SIG // 0Bv5QMcb1esmfEMwx3DyeBGqhU6lDg0ASjoRd6PKIwGA
// SIG // nsiTVl1GzIrY0qoKhIWyiVvVMs5BexhOVMqr0VJeEtMk
// SIG // nlbzDI/dvZKOedVBicOjoOWR/MdnnYczznEycwIDAQAB
// SIG // o4IBqDCCAaQwDgYDVR0PAQH/BAQDAgeAMEwGA1UdIARF
// SIG // MEMwQQYJKwYBBAGgMgEeMDQwMgYIKwYBBQUHAgEWJmh0
// SIG // dHBzOi8vd3d3Lmdsb2JhbHNpZ24uY29tL3JlcG9zaXRv
// SIG // cnkvMAkGA1UdEwQCMAAwFgYDVR0lAQH/BAwwCgYIKwYB
// SIG // BQUHAwgwRgYDVR0fBD8wPTA7oDmgN4Y1aHR0cDovL2Ny
// SIG // bC5nbG9iYWxzaWduLmNvbS9ncy9nc3RpbWVzdGFtcGlu
// SIG // Z3NoYTJnMi5jcmwwgZgGCCsGAQUFBwEBBIGLMIGIMEgG
// SIG // CCsGAQUFBzAChjxodHRwOi8vc2VjdXJlLmdsb2JhbHNp
// SIG // Z24uY29tL2NhY2VydC9nc3RpbWVzdGFtcGluZ3NoYTJn
// SIG // Mi5jcnQwPAYIKwYBBQUHMAGGMGh0dHA6Ly9vY3NwMi5n
// SIG // bG9iYWxzaWduLmNvbS9nc3RpbWVzdGFtcGluZ3NoYTJn
// SIG // MjAdBgNVHQ4EFgQULW5u0Y3lA4Du52Ppp9naCzxXIj0w
// SIG // HwYDVR0jBBgwFoAUkiGnSpVdZLCbtB7mADdH5p1BK0ww
// SIG // DQYJKoZIhvcNAQELBQADggEBAI39HR+PiNNl+LVcRumn
// SIG // 07Y/SstDBcIHDcNeA4QjN6h6jJcj/yechH1h61xLVz6b
// SIG // 9ETbgFj3tmXejxIKX6eHdLfaFECHUeyfSkdV8BfoGD5x
// SIG // IDHmKCKrTvaunGvC50T7aA0gf1M/lBuhhoJOMhYQWj+J
// SIG // WMHQtNu2kPuNMumhS0ZQN7bDOukpJBKSWk4rubYKejaM
// SIG // l8DviXwz3jHhoZfk50WtYVL9WonTVH6KTVuJew6Wd9Hy
// SIG // PDgb2vmlYSBlArzFrdcMYhAoLN2246hhAKwIJqONhdBk
// SIG // yTaQHopSyYeNNaVdSJH8k6alZfHs+TrcpSyeBG1iM/7e
// SIG // +p/Fzq+V81Go8s4wggQVMIIC/aADAgECAgsEAAAAAAEx
// SIG // icZQBDANBgkqhkiG9w0BAQsFADBMMSAwHgYDVQQLExdH
// SIG // bG9iYWxTaWduIFJvb3QgQ0EgLSBSMzETMBEGA1UEChMK
// SIG // R2xvYmFsU2lnbjETMBEGA1UEAxMKR2xvYmFsU2lnbjAe
// SIG // Fw0xMTA4MDIxMDAwMDBaFw0yOTAzMjkxMDAwMDBaMFsx
// SIG // CzAJBgNVBAYTAkJFMRkwFwYDVQQKExBHbG9iYWxTaWdu
// SIG // IG52LXNhMTEwLwYDVQQDEyhHbG9iYWxTaWduIFRpbWVz
// SIG // dGFtcGluZyBDQSAtIFNIQTI1NiAtIEcyMIIBIjANBgkq
// SIG // hkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqpuOw6sRUSUB
// SIG // tpaU4k/YwQj2RiPZRcWVl1urGr/SbFfJMwYfoA/GPH5T
// SIG // SHq/nYeer+7DjEfhQuzj46FKbAwXxKbBuc1b8R5EiY7+
// SIG // C94hWBPuTcjFZwscsrPxNHaRossHbTfFoEcmAhWkkJGp
// SIG // eZ7X61edK3wi2BTX8QceeCI2a3d5r6/5f45O4bUIMf3q
// SIG // 7UtxYowj8QM5j0R5tnYDV56tLwhG3NKMvPSOdM7IaGlR
// SIG // dhGLD10kWxlUPSbMQI2CJxtZIH1Z9pOAjvgqOP1roEBl
// SIG // H1d2zFuOBE8sqNuEUBNPxtyLufjdaUyI65x7MCb8eli7
// SIG // WbwUcpKBV7d2ydiACoBuCQIDAQABo4HoMIHlMA4GA1Ud
// SIG // DwEB/wQEAwIBBjASBgNVHRMBAf8ECDAGAQH/AgEAMB0G
// SIG // A1UdDgQWBBSSIadKlV1ksJu0HuYAN0fmnUErTDBHBgNV
// SIG // HSAEQDA+MDwGBFUdIAAwNDAyBggrBgEFBQcCARYmaHR0
// SIG // cHM6Ly93d3cuZ2xvYmFsc2lnbi5jb20vcmVwb3NpdG9y
// SIG // eS8wNgYDVR0fBC8wLTAroCmgJ4YlaHR0cDovL2NybC5n
// SIG // bG9iYWxzaWduLm5ldC9yb290LXIzLmNybDAfBgNVHSME
// SIG // GDAWgBSP8Et/qC5FJK5NUPpjmove4t0bvDANBgkqhkiG
// SIG // 9w0BAQsFAAOCAQEABFaCSnzQzsm/NmbRvjWek2yX6AbO
// SIG // MRhZ+WxBX4AuwEIluBjH/NSxN8RooM8oagN0S2OXhXdh
// SIG // O9cv4/W9M6KSfREfnops7yyw9GKNNnPRFjbxvF7stICY
// SIG // ePzSdnno4SGU4B/EouGqZ9uznHPlQCLPOc7b5neVp7uy
// SIG // y/YZhp2fyNSYBbJxb051rvE9ZGo7Xk5GpipdCJLxo/Md
// SIG // dL9iDSOMXCo4ldLA1c3PiNofKLW6gWlkKrWmotVzr9xG
// SIG // 2wSukdduxZi61EfEVnSAR3hYjL7vK/3sbL/RlPe/UOB7
// SIG // 4JD9IBh4GCJdCC6MHKCX8x2ZfaOdkdMGRE4EbnocIOM2
// SIG // 8LZQuTGCAqgwggKkAgEBMGswWzELMAkGA1UEBhMCQkUx
// SIG // GTAXBgNVBAoTEEdsb2JhbFNpZ24gbnYtc2ExMTAvBgNV
// SIG // BAMTKEdsb2JhbFNpZ24gVGltZXN0YW1waW5nIENBIC0g
// SIG // U0hBMjU2IC0gRzICDAynz10HBySsieeaOjANBglghkgB
// SIG // ZQMEAgEFAKCCAQ4wGgYJKoZIhvcNAQkDMQ0GCyqGSIb3
// SIG // DQEJEAEEMBwGCSqGSIb3DQEJBTEPFw0yMDAzMjMxMzU5
// SIG // NDVaMC8GCSqGSIb3DQEJBDEiBCAbNbBImrO31rpppa1F
// SIG // V1qYfxtOMQkKOhyeDJ99XVS3XzCBoAYLKoZIhvcNAQkQ
// SIG // AgwxgZAwgY0wgYowgYcEFJsSBXrnKq/21jdytJ9qI28m
// SIG // Sc2pMG8wX6RdMFsxCzAJBgNVBAYTAkJFMRkwFwYDVQQK
// SIG // ExBHbG9iYWxTaWduIG52LXNhMTEwLwYDVQQDEyhHbG9i
// SIG // YWxTaWduIFRpbWVzdGFtcGluZyBDQSAtIFNIQTI1NiAt
// SIG // IEcyAgwMp89dBwckrInnmjowDQYJKoZIhvcNAQEBBQAE
// SIG // ggEAK48jhwb8TCWbldvicNn/LPT8fEPdfMguueWidAY5
// SIG // cw3p0P4JqMcgNc2KkCN1yAKxMGx8MDjLLGn/Ilgi+vat
// SIG // 7onndgelpLWHIIEvY4nmF0N943wQODEbFU+2isK2w+PB
// SIG // 02Sx05Swm6VTYUCAcarkZ8c0oKd4VhQcEP0m4zArZRVx
// SIG // Xq8x+BtkHakbAzq4p7/DzR+9fspQq3I99+MsUrh4bIpQ
// SIG // IjgMFaiLymbvLQ5AFG6U8MyP+qNXh18NL9zfxMgfYHLB
// SIG // pjMf+N064s7aIoYxJGJH0z7DjqhiSEnCMkGHznipAwoN
// SIG // amCnAV+P3vmSDPtgum+rVhgRndwezm+N7dvRQw==
// SIG // End signature block
