// Search result controller.
(function($) {
	$.widget('adsk.searchresultcontroller', {
		options: {
            orientationData: undefined
        },
        _searchHighlighter: undefined,
        _rootData: undefined,
        _searchData: {
            className: 'highlight',
            root: undefined,
            term: undefined
        },

        _view: undefined,

		_create: function() {
            console.log('searchresultcontroller: _create');

            //  Create view and attach event handlers.
            this._view = $('#search-result').searchresultview({
                searchbuttontap:      $.proxy(this._viewButtontapHandler, this)
            }).searchresultview('instance');

            this._searchHighlighter = $.adsk.searchresulthighlighter({});

        },

		_viewButtontapHandler: function(event, id) {
		    console.log('searchresultcontroller: _viewButtontapHandler');
            event.preventDefault();
            event.stopPropagation();

            var rootData = this._rootData;
            var currentSearchResult;
            switch (id){
                case 'search-result-cancel':
                    this.closeSearchResultPage();
                    break;

                case 'prev':
                    this._searchHighlighter.jumpToSearchResult(id, rootData);
                    currentSearchResult = this._searchHighlighter.getCurrentSearchResultNumber();
                    this._view.setCurrentSearchResult(currentSearchResult);
                    break;

                case 'next':
                    this._searchHighlighter.jumpToSearchResult(id, rootData);
                    currentSearchResult = this._searchHighlighter.getCurrentSearchResultNumber();
                    this._view.setCurrentSearchResult(currentSearchResult);
                    break;
            }
		},

        _removeHighlight: function () {
            this._searchHighlighter.removeHighlight(this._searchData);
        },

        _getRootElement: function (data) {
            console.log('searchresultcontroller: _getRootElement');
            var elem;
            switch (data) {
                case 'toc':
                    elem = document.getElementById('tab-toc');
                    break;

                case 'tree':
                    elem = document.getElementById('tab-tree');
                    break;

                case 'index':
                    elem = $('#tab-index .index-content')[0];
                    break;

                case 'favorites':
                    elem = document.getElementById('tab-favorites');
                    break;

                case 'topic':
                    elem = document.getElementById('body-content');
                    break;

                default:
                    break;
            }

            return elem;
        },

        /* Public members. */

        processingSearchResults: function (rootData, term) {
            console.log('searchresultcontroller: processingSearchResults');

            this._rootData = rootData;
            this._searchData.root = this._getRootElement(rootData);
            this._searchData.term = term;
            this._searchHighlighter.innerHighlight(this._searchData);
            this._searchHighlighter.jumpToSearchResult('start', rootData);

            var searchResultsNumber = this._searchHighlighter.getSearchResultsNumber();
            this._view.setSearchResultsNumber(searchResultsNumber);
            var currentSearchResult = this._searchHighlighter.getCurrentSearchResultNumber();
            this._view.setCurrentSearchResult(currentSearchResult);
        },

        closeSearchResultPage: function ()  {
            console.log('searchresultcontroller: closeSearchResultPage');
            this._removeHighlight();
            this._trigger('back');
        },

		resize: function(data) {
		    console.log('searchcontroller: resize');

		    var view = this._view;
		    if (view) {
		        view.resize();
		    }
		}
    });
})(jQuery);
// SIG // Begin signature block
// SIG // MIIbRgYJKoZIhvcNAQcCoIIbNzCCGzMCAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // YgOIkYsU+rEuZB7FHs4U0jbTEHSq2JiqqsxcGX+rBnag
// SIG // ggoaMIIEyzCCA7OgAwIBAgIQCQja65wGHi65un4mqmKH
// SIG // ijANBgkqhkiG9w0BAQsFADCBhDELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTUw
// SIG // MwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
// SIG // b2RlIFNpZ25pbmcgQ0EgLSBHMjAeFw0xOTA1MTQwMDAw
// SIG // MDBaFw0yMDA1MTMyMzU5NTlaMHwxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIDApDYWxpZm9ybmlhMRMwEQYDVQQHDApT
// SIG // YW4gUmFmYWVsMRcwFQYDVQQKDA5BdXRvZGVzaywgSW5j
// SIG // LjERMA8GA1UECwwIU2VjdXJpdHkxFzAVBgNVBAMMDkF1
// SIG // dG9kZXNrLCBJbmMuMIIBIjANBgkqhkiG9w0BAQEFAAOC
// SIG // AQ8AMIIBCgKCAQEAkVKRoPYsoxPdlabspcuG8HYDfcWQ
// SIG // 9qyPOT2punwpVdjt2slktcpSTlydrGy8ijcbl5/k8AOJ
// SIG // afKMQvow0fNjIoNB5nsb8j2xFJPbBhHl8GT4P6DZ1OWK
// SIG // ioiUXgGHKjctUws49J4elntqvBYhKCbuPqG772QCoYFU
// SIG // P7qcFbh3PbyNB6cnKMn2vNGRqiEtV2aGg+/MiL3QPsvT
// SIG // kTWhVuTLIvwZ4kK5C5ACiQzlGOlE+C7gWuFoxtvy6gUa
// SIG // A8JAq/xLjYKwFevQwGncg3s1cuiGhx0P7Rvn6oCd2cem
// SIG // FmbK3I3rMRt+jc9wzAj3oHxvCo4f5Lfva+OpC1dETUVV
// SIG // sk0VGwIDAQABo4IBPjCCATowCQYDVR0TBAIwADAOBgNV
// SIG // HQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMw
// SIG // YQYDVR0gBFowWDBWBgZngQwBBAEwTDAjBggrBgEFBQcC
// SIG // ARYXaHR0cHM6Ly9kLnN5bWNiLmNvbS9jcHMwJQYIKwYB
// SIG // BQUHAgIwGQwXaHR0cHM6Ly9kLnN5bWNiLmNvbS9ycGEw
// SIG // HwYDVR0jBBgwFoAU1MAGIknrOUvdk+JcobhHdglyA1gw
// SIG // KwYDVR0fBCQwIjAgoB6gHIYaaHR0cDovL3JiLnN5bWNi
// SIG // LmNvbS9yYi5jcmwwVwYIKwYBBQUHAQEESzBJMB8GCCsG
// SIG // AQUFBzABhhNodHRwOi8vcmIuc3ltY2QuY29tMCYGCCsG
// SIG // AQUFBzAChhpodHRwOi8vcmIuc3ltY2IuY29tL3JiLmNy
// SIG // dDANBgkqhkiG9w0BAQsFAAOCAQEA0Q2+iVSEfT4xGq3A
// SIG // OADVb0rT5Z8E+PPb1x6hKknSzuaZKk/acDz9mdnFajaU
// SIG // WgIKiFJlsqJnuAM1w4lqKaEWsz3DoxvGIEwexj71Ud6a
// SIG // KlBJNcR9DdkXUZwMhbw9d78rjJAIX6tOwfSludZfdq8b
// SIG // YEkuIzQi9uYW9vHVPSCzhnUBKjwc9qTo9yBc7Fcn4FAT
// SIG // 90DzWM2hS9oc3p0pprYI2I/O4th90BEmwWkVqVgfaR0z
// SIG // VyIEmBbqB/IWLfjUBZJ/8sbkwWuWlYVRrfPxsj1e9qvb
// SIG // wE3Y28jWyGbqoUG39GhXk3uT8R8i3+T6M0c4rMfdifBC
// SIG // pceCaFTJzSye7LoeVzCCBUcwggQvoAMCAQICEHwbNTVK
// SIG // 59t050FfEWnKa6gwDQYJKoZIhvcNAQELBQAwgb0xCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjEfMB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29y
// SIG // azE6MDgGA1UECxMxKGMpIDIwMDggVmVyaVNpZ24sIElu
// SIG // Yy4gLSBGb3IgYXV0aG9yaXplZCB1c2Ugb25seTE4MDYG
// SIG // A1UEAxMvVmVyaVNpZ24gVW5pdmVyc2FsIFJvb3QgQ2Vy
// SIG // dGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMTQwNzIyMDAw
// SIG // MDAwWhcNMjQwNzIxMjM1OTU5WjCBhDELMAkGA1UEBhMC
// SIG // VVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9u
// SIG // MR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3Jr
// SIG // MTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1
// SIG // NiBDb2RlIFNpZ25pbmcgQ0EgLSBHMjCCASIwDQYJKoZI
// SIG // hvcNAQEBBQADggEPADCCAQoCggEBANeVQ9Tc32euOftS
// SIG // pLYmMQRw6beOWyq6N2k1lY+7wDDnhthzu9/r0XY/ilaO
// SIG // 6y1L8FcYTrGNpTPTC3Uj1Wp5J92j0/cOh2W13q0c8fU1
// SIG // tCJRryKhwV1LkH/AWU6rnXmpAtceSbE7TYf+wnirv+9S
// SIG // rpyvCNk55ZpRPmlfMBBOcWNsWOHwIDMbD3S+W8sS4duM
// SIG // xICUcrv2RZqewSUL+6McntimCXBx7MBHTI99w94Zzj7u
// SIG // BHKOF9P/8LIFMhlM07Acn/6leCBCcEGwJoxvAMg6ABFB
// SIG // ekGwp4qRBKCZePR3tPNgKuZsUAS3FGD/DVH0qIuE/iHa
// SIG // XF599Sl5T7BEdG9tcv8CAwEAAaOCAXgwggF0MC4GCCsG
// SIG // AQUFBwEBBCIwIDAeBggrBgEFBQcwAYYSaHR0cDovL3Mu
// SIG // c3ltY2QuY29tMBIGA1UdEwEB/wQIMAYBAf8CAQAwZgYD
// SIG // VR0gBF8wXTBbBgtghkgBhvhFAQcXAzBMMCMGCCsGAQUF
// SIG // BwIBFhdodHRwczovL2Quc3ltY2IuY29tL2NwczAlBggr
// SIG // BgEFBQcCAjAZGhdodHRwczovL2Quc3ltY2IuY29tL3Jw
// SIG // YTA2BgNVHR8ELzAtMCugKaAnhiVodHRwOi8vcy5zeW1j
// SIG // Yi5jb20vdW5pdmVyc2FsLXJvb3QuY3JsMBMGA1UdJQQM
// SIG // MAoGCCsGAQUFBwMDMA4GA1UdDwEB/wQEAwIBBjApBgNV
// SIG // HREEIjAgpB4wHDEaMBgGA1UEAxMRU3ltYW50ZWNQS0kt
// SIG // MS03MjQwHQYDVR0OBBYEFNTABiJJ6zlL3ZPiXKG4R3YJ
// SIG // cgNYMB8GA1UdIwQYMBaAFLZ3+mlIR59TEtXC6gcydgfR
// SIG // lwcZMA0GCSqGSIb3DQEBCwUAA4IBAQB/68qn6ot2Qus+
// SIG // jiBUMOO3udz6SD4Wxw9FlRDNJ4ajZvMC7XH4qsJVl5Fw
// SIG // g/lSflJpPMnx4JRGgBi7odSkVqbzHQCR1YbzSIfgy8Q0
// SIG // aCBetMv5Be2cr3BTJ7noPn5RoGlxi9xR7YA6JTKfRK9u
// SIG // QyjTIXW7l9iLi4z+qQRGBIX3FZxLEY3ELBf+1W5/muJW
// SIG // kvGWs60t+fTf2omZzrI4RMD3R3vKJbn6Kmgzm1By3qif
// SIG // 1M0sCzS9izB4QOCNjicbkG8avggVgV3rL+JR51EeyXgp
// SIG // 5x5lvzjvAUoBCSQOFsQUecFBNzTQPZFSlJ3haO8I8OJp
// SIG // nGdukAsak3HUJgLDwFojMYIQhDCCEIACAQEwgZkwgYQx
// SIG // CzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRlYyBD
// SIG // b3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1
// SIG // c3QgTmV0d29yazE1MDMGA1UEAxMsU3ltYW50ZWMgQ2xh
// SIG // c3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENBIC0gRzIC
// SIG // EAkI2uucBh4uubp+Jqpih4owDQYJYIZIAWUDBAIBBQCg
// SIG // fDAQBgorBgEEAYI3AgEMMQIwADAZBgkqhkiG9w0BCQMx
// SIG // DAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4wDAYK
// SIG // KwYBBAGCNwIBFTAvBgkqhkiG9w0BCQQxIgQgLpNN8/sv
// SIG // WCQhHt3Ll5b/uq4YbCab+8JW/3HB0PNZbAAwDQYJKoZI
// SIG // hvcNAQEBBQAEggEASpHYPofGVFfooReCSuMtpWhlqEJl
// SIG // k5Wj5u3OFIb5Of7N9ZH1FyrQVAx/1f+J0MTRKTxUb5+X
// SIG // aiE6Nj0TTcLMExfvrzFsRlsQ0SSQ1yAh9uxQfcQjQXqe
// SIG // yhbecQIhf7jzmwi6iIUD6BQ9ou1w8wN32iWmcTf/6oAS
// SIG // P1BNMd6uHPNl0hrRtCNMze/3BNcFlYBXvyMdJIRkH49m
// SIG // O3SvTvROLmzgdghMbCULxK+dCb1Xg2jc07/cVmoHvSwz
// SIG // ZgVgNmIRmyXmVBlgIg6+JFwnTAgsHoKA9zY8TVGzS0EE
// SIG // KAwapxKm0t5rcEWqa2dLLue6rKPr9AzwbKqv1HSvz9u4
// SIG // VRJLjKGCDj0wgg45BgorBgEEAYI3AwMBMYIOKTCCDiUG
// SIG // CSqGSIb3DQEHAqCCDhYwgg4SAgEDMQ0wCwYJYIZIAWUD
// SIG // BAIBMIIBDwYLKoZIhvcNAQkQAQSggf8EgfwwgfkCAQEG
// SIG // C2CGSAGG+EUBBxcDMDEwDQYJYIZIAWUDBAIBBQAEIPHy
// SIG // 9+vRT4/XdUDYqPcojOhOAhIJV6yxwzdpAbfc5i1eAhUA
// SIG // obZTaLIRcbFX9YCJhppyX6A47LUYDzIwMjAwMjA3MTYx
// SIG // NzAzWjADAgEeoIGGpIGDMIGAMQswCQYDVQQGEwJVUzEd
// SIG // MBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xHzAd
// SIG // BgNVBAsTFlN5bWFudGVjIFRydXN0IE5ldHdvcmsxMTAv
// SIG // BgNVBAMTKFN5bWFudGVjIFNIQTI1NiBUaW1lU3RhbXBp
// SIG // bmcgU2lnbmVyIC0gRzOgggqLMIIFODCCBCCgAwIBAgIQ
// SIG // ewWx1EloUUT3yYnSnBmdEjANBgkqhkiG9w0BAQsFADCB
// SIG // vTELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWdu
// SIG // LCBJbmMuMR8wHQYDVQQLExZWZXJpU2lnbiBUcnVzdCBO
// SIG // ZXR3b3JrMTowOAYDVQQLEzEoYykgMjAwOCBWZXJpU2ln
// SIG // biwgSW5jLiAtIEZvciBhdXRob3JpemVkIHVzZSBvbmx5
// SIG // MTgwNgYDVQQDEy9WZXJpU2lnbiBVbml2ZXJzYWwgUm9v
// SIG // dCBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAeFw0xNjAx
// SIG // MTIwMDAwMDBaFw0zMTAxMTEyMzU5NTlaMHcxCzAJBgNV
// SIG // BAYTAlVTMR0wGwYDVQQKExRTeW1hbnRlYyBDb3Jwb3Jh
// SIG // dGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0
// SIG // d29yazEoMCYGA1UEAxMfU3ltYW50ZWMgU0hBMjU2IFRp
// SIG // bWVTdGFtcGluZyBDQTCCASIwDQYJKoZIhvcNAQEBBQAD
// SIG // ggEPADCCAQoCggEBALtZnVlVT52Mcl0agaLrVfOwAa08
// SIG // cawyjwVrhponADKXak3JZBRLKbvC2Sm5Luxjs+HPPwtW
// SIG // kPhiG37rpgfi3n9ebUA41JEG50F8eRzLy60bv9iVkfPw
// SIG // 7mz4rZY5Ln/BJ7h4OcWEpe3tr4eOzo3HberSmLU6Hx45
// SIG // ncP0mqj0hOHE0XxxxgYptD/kgw0mw3sIPk35CrczSf/K
// SIG // O9T1sptL4YiZGvXA6TMU1t/HgNuR7v68kldyd/TNqMz+
// SIG // CfWTN76ViGrF3PSxS9TO6AmRX7WEeTWKeKwZMo8jwTJB
// SIG // G1kOqT6xzPnWK++32OTVHW0ROpL2k8mc40juu1MO1DaX
// SIG // hnjFoTcCAwEAAaOCAXcwggFzMA4GA1UdDwEB/wQEAwIB
// SIG // BjASBgNVHRMBAf8ECDAGAQH/AgEAMGYGA1UdIARfMF0w
// SIG // WwYLYIZIAYb4RQEHFwMwTDAjBggrBgEFBQcCARYXaHR0
// SIG // cHM6Ly9kLnN5bWNiLmNvbS9jcHMwJQYIKwYBBQUHAgIw
// SIG // GRoXaHR0cHM6Ly9kLnN5bWNiLmNvbS9ycGEwLgYIKwYB
// SIG // BQUHAQEEIjAgMB4GCCsGAQUFBzABhhJodHRwOi8vcy5z
// SIG // eW1jZC5jb20wNgYDVR0fBC8wLTAroCmgJ4YlaHR0cDov
// SIG // L3Muc3ltY2IuY29tL3VuaXZlcnNhbC1yb290LmNybDAT
// SIG // BgNVHSUEDDAKBggrBgEFBQcDCDAoBgNVHREEITAfpB0w
// SIG // GzEZMBcGA1UEAxMQVGltZVN0YW1wLTIwNDgtMzAdBgNV
// SIG // HQ4EFgQUr2PWyqNOhXLgp7xB8ymiOH+AdWIwHwYDVR0j
// SIG // BBgwFoAUtnf6aUhHn1MS1cLqBzJ2B9GXBxkwDQYJKoZI
// SIG // hvcNAQELBQADggEBAHXqsC3VNBlcMkX+DuHUT6Z4wW/X
// SIG // 6t3cT/OhyIGI96ePFeZAKa3mXfSi2VZkhHEwKt0eYRdm
// SIG // IFYGmBmNXXHy+Je8Cf0ckUfJ4uiNA/vMkC/WCmxOM+zW
// SIG // tJPITJBjSDlAIcTd1m6JmDy1mJfoqQa3CcmPU1dBkC/h
// SIG // Hk1O3MoQeGxCbvC2xfhhXFL1TvZrjfdKer7zzf0D19n2
// SIG // A6gP41P3CnXsxnUuqmaFBJm3+AZX4cYO9uiv2uybGB+q
// SIG // ueM6AL/OipTLAduexzi7D1Kr0eOUA2AKTaD+J20UMvw/
// SIG // l0Dhv5mJ2+Q5FL3a5NPD6itas5VYVQR9x5rsIwONhSrS
// SIG // /66pYYEwggVLMIIEM6ADAgECAhB71OWvuswHP6EBIwQi
// SIG // QU0SMA0GCSqGSIb3DQEBCwUAMHcxCzAJBgNVBAYTAlVT
// SIG // MR0wGwYDVQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlvbjEf
// SIG // MB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazEo
// SIG // MCYGA1UEAxMfU3ltYW50ZWMgU0hBMjU2IFRpbWVTdGFt
// SIG // cGluZyBDQTAeFw0xNzEyMjMwMDAwMDBaFw0yOTAzMjIy
// SIG // MzU5NTlaMIGAMQswCQYDVQQGEwJVUzEdMBsGA1UEChMU
// SIG // U3ltYW50ZWMgQ29ycG9yYXRpb24xHzAdBgNVBAsTFlN5
// SIG // bWFudGVjIFRydXN0IE5ldHdvcmsxMTAvBgNVBAMTKFN5
// SIG // bWFudGVjIFNIQTI1NiBUaW1lU3RhbXBpbmcgU2lnbmVy
// SIG // IC0gRzMwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEK
// SIG // AoIBAQCvDoqq+Ny/aXtUF3FHCb2NPIH4dBV3Z5Cc/d5O
// SIG // Ap5LdvblNj5l1SQgbTD53R2D6T8nSjNObRaK5I1AjSKq
// SIG // vqcLG9IHtjy1GiQo+BtyUT3ICYgmCDr5+kMjdUdwDLNf
// SIG // W48IHXJIV2VNrwI8QPf03TI4kz/lLKbzWSPLgN4TTfkQ
// SIG // yaoKGGxVYVfR8QIsxLWr8mwj0p8NDxlsrYViaf1OhcGK
// SIG // UjGrW9jJdFLjV2wiv1V/b8oGqz9KtyJ2ZezsNvKWlYEm
// SIG // LP27mKoBONOvJUCbCVPwKVeFWF7qhUhBIYfl3rTTJrJ7
// SIG // QFNYeY5SMQZNlANFxM48A+y3API6IsW0b+XvsIqbAgMB
// SIG // AAGjggHHMIIBwzAMBgNVHRMBAf8EAjAAMGYGA1UdIARf
// SIG // MF0wWwYLYIZIAYb4RQEHFwMwTDAjBggrBgEFBQcCARYX
// SIG // aHR0cHM6Ly9kLnN5bWNiLmNvbS9jcHMwJQYIKwYBBQUH
// SIG // AgIwGRoXaHR0cHM6Ly9kLnN5bWNiLmNvbS9ycGEwQAYD
// SIG // VR0fBDkwNzA1oDOgMYYvaHR0cDovL3RzLWNybC53cy5z
// SIG // eW1hbnRlYy5jb20vc2hhMjU2LXRzcy1jYS5jcmwwFgYD
// SIG // VR0lAQH/BAwwCgYIKwYBBQUHAwgwDgYDVR0PAQH/BAQD
// SIG // AgeAMHcGCCsGAQUFBwEBBGswaTAqBggrBgEFBQcwAYYe
// SIG // aHR0cDovL3RzLW9jc3Aud3Muc3ltYW50ZWMuY29tMDsG
// SIG // CCsGAQUFBzAChi9odHRwOi8vdHMtYWlhLndzLnN5bWFu
// SIG // dGVjLmNvbS9zaGEyNTYtdHNzLWNhLmNlcjAoBgNVHREE
// SIG // ITAfpB0wGzEZMBcGA1UEAxMQVGltZVN0YW1wLTIwNDgt
// SIG // NjAdBgNVHQ4EFgQUpRMBqZ+FzBtuFh5fOzGqeTYAex0w
// SIG // HwYDVR0jBBgwFoAUr2PWyqNOhXLgp7xB8ymiOH+AdWIw
// SIG // DQYJKoZIhvcNAQELBQADggEBAEaer/C4ol+imUjPqCdL
// SIG // Ic2yuaZycGMv41UpezlGTud+ZQZYi7xXipINCNgQujYk
// SIG // +gp7+zvTYr9KlBXmgtuKVG3/KP5nz3E/5jMJ2aJZEPQe
// SIG // Sv5lzN7Ua+NSKXUASiulzMub6KlN97QXWZJBw7c/hub2
// SIG // wH9EPEZcF1rjpDvVaSbVIX3hgGd+Yqy3Ti4VmuWcI69b
// SIG // EepxqUH5DXk4qaENz7Sx2j6aescixXTN30cJhsT8kSWy
// SIG // G5bphQjo3ep0YG5gpVZ6DchEWNzm+UgUnuW/3gC9d7GY
// SIG // FHIUJN/HESwfAD/DSxTGZxzMHgajkF9cVIs+4zNbgg/F
// SIG // t4YCTnGf6WZFP3YxggJaMIICVgIBATCBizB3MQswCQYD
// SIG // VQQGEwJVUzEdMBsGA1UEChMUU3ltYW50ZWMgQ29ycG9y
// SIG // YXRpb24xHzAdBgNVBAsTFlN5bWFudGVjIFRydXN0IE5l
// SIG // dHdvcmsxKDAmBgNVBAMTH1N5bWFudGVjIFNIQTI1NiBU
// SIG // aW1lU3RhbXBpbmcgQ0ECEHvU5a+6zAc/oQEjBCJBTRIw
// SIG // CwYJYIZIAWUDBAIBoIGkMBoGCSqGSIb3DQEJAzENBgsq
// SIG // hkiG9w0BCRABBDAcBgkqhkiG9w0BCQUxDxcNMjAwMjA3
// SIG // MTYxNzAzWjAvBgkqhkiG9w0BCQQxIgQgDslZG0La3uP1
// SIG // Cc7ez5rNrpq5wHEdkfWWE5HNgliDeCAwNwYLKoZIhvcN
// SIG // AQkQAi8xKDAmMCQwIgQgxHTOdgB9AjlODaXk3nwUxoD5
// SIG // 4oIBPP72U+9dtx/fYfgwCwYJKoZIhvcNAQEBBIIBAD+j
// SIG // jd1Ux73TLYdSFNVIxvut7suxtnyItP7xX2X+aztagrQh
// SIG // k96R+RNz4hN5DHT50oEiNIIPMfEYciolfDfAkiscs9co
// SIG // DpgxHHcl10jQYcolJ9oXCYNeCxmWlXi2fz1hsQhEDB1E
// SIG // 5byi6J3R1oQ28u38ZwLKBqjh/TiDzGd7J9acwnXttJbE
// SIG // /n0HGIlLrAWhJ7lJJ+WLLPP5XMSBQvT0DK3miBjDLIWH
// SIG // RwqAbYmB4hZEnQut2TlMB1bW2kosVaPhXst4Uof6IC7a
// SIG // tcjfV3yiVBvzpsAaiRftxCwTRaTu0CRYJfBJuGiLQhVG
// SIG // XK45mpnUhg0XAL42mn4haeHVkycKF1Y=
// SIG // End signature block
