// App controller.
(function($, UTILS) {
	$.widget('adsk.appcontroller', {
		options: {
		    config: {},
            defaultPageId: 'topic',
            targetId: 'browser',
            controllers: undefined,
            viewControllers: undefined,
            tocDataConsumers: undefined,
            orientationData: undefined,
            searchRootData: undefined
		},

        /* Private members. */

		_view: undefined,

		_create: function() {
		    console.log('appcontroller: _create');

            // Initialize rooting with hashbang.
            this._addHashchangeHandler();

		    this._createView();

		    // Hide main preloader after all initialization complete.
            this._togglePreloader();
		},

		_processHashAtStartup: function() {
		    console.log('appcontroller: _processHashAtStartup');

            var hash = '',
                search = location.search;

            if (location.hash == '' && search.indexOf('?') == 0) {
                hash = search.replace(/\?/, '#!/');
            } else {
                hash = location.hash;
            }

            this._processHash(hash);
        },

		_createView: function() {
            console.log('appcontroller: createView');

            // Create app view.
            var selector = '#'.concat(this.options.targetId);

            $(selector).appview({
                create:             $.proxy(this._viewCreateHandler, this),
                orientationchange:  $.proxy(this._handleDeviceOrientation, this),
                resize:             $.proxy(this._resize, this)
            });
		},

		_viewCreateHandler: function(event, orientationData) {
		    console.log('appcontroller: _viewCreateHandler, ');

		    this._view = $(event.target).appview("instance");

		    this.options.orientationData = orientationData;

            // Create controllers.
            this._createControllers();

            // TEST
            this._processHashAtStartup();

            // Resize.
            this._resize(event, orientationData);

            // Open default page (topic, navigation, search etc.).
            this._makePageCurrentById(this.options.defaultPageId);
		},

		_createControllers: function() {
		    console.log('appcontroller: _createControllers');

            // Init controllers.
            var viewControllers = this.options.viewControllers = {},
                tocConsumers    = this.options.tocDataConsumers = {},
                controllers     = this.options.controllers = {};

            tocConsumers.favoritesController = viewControllers.favoritesController = $.adsk.favoritescontroller();

            tocConsumers.topicController = viewControllers.topicController = $.adsk.topiccontroller({
                showpage:               $.proxy(this._handleShowPage, this),
                back:                   $.proxy(this._backToPreviousPage, this),
                defaultTopicHref:       this.options.config.defaultPage,
                opentopic:              $.proxy(this._handleOpentopic, this),
                favoritesController:    viewControllers.favoritesController,
                setsuggestiondata:      $.proxy(this._handleSetSuggestionData, this),
                orientationData:        this.options.orientationData
            });

            // TODO: use config to specify default tab.
            tocConsumers.navigationController = viewControllers.navigationController = $.adsk.navigationcontroller({
                defaultTab: 'toc',
                showpage:   $.proxy(this._handleShowPage, this),
                back:       $.proxy(this._backToPreviousPage, this),
                opentopic:  $.proxy(this._handleOpentopic, this),
                closepage:  $.proxy(this._handleCloseSearchResultPage, this),
                setsuggestiondata: $.proxy(this._handleSetSuggestionData, this),
                controllers: {
                    favoritesController: viewControllers.favoritesController
                }
            });

            // Create search controller and observe its events.
            tocConsumers.searchController = viewControllers.searchController = $.adsk.searchcontroller({
                back:                   $.proxy(this._backToPreviousPage, this),
                showsearchresult:       $.proxy(this._showSearchResultPage, this),
                orientationData:        this.options.orientationData
            });

            tocConsumers.searchResultController = viewControllers.searchResultController = $.adsk.searchresultcontroller({
                back:               $.proxy(this._backToPreviousPage, this),
                orientationData:    this.options.orientationData
            });

            controllers.tocController = $.adsk.tocdatacontroller({
                indexed: $.proxy(this._setTocData, this)
            });
		},

		_handleShowPage: function(event, data) {
		    console.log('appcontroller: _handleShowPage');

            this._makePageCurrentById(data.id);
        },

        _makePageCurrentById: function(id) {
             console.log('appcontroller: _makePageCurrentById, ', id);

             this._view.makePageCurrentById(id);

             // Refresh navigation.
             if (id === 'navigation') {
                 this.options.viewControllers.navigationController.refresh();
             }
        },

		_insertHeadMetadata: function() {
		    console.log('appcontroller: _insertHeadMetadata');

            // Get rid of browser URL and button bars.
            UTILS.insertMeta('apple-mobile-web-app-capable', 'yes');

            // Set iOS status bar color to black.
            UTILS.insertMeta('apple-mobile-web-app-status-bar-style', 'black');
		},

		_setTocData: function(event, data) {
		    console.log('appcontroller: _setTocData');

            $.each(this.options.tocDataConsumers, function(index, controller) {
                if (controller.setTocData) {
                    controller.setTocData(data);
                }
            });

            // Let's try to show default topic content.
            this._processHashAtStartup();
        },

        _resize: function(event, orientationData) {
            console.log('appcontroller: _resize');

            // Invoke view controllers resize.
            $.each(this.options.viewControllers, function(index, controller) {
                if (controller.resize) {
                    controller.resize(orientationData);
                }
            });
        },

        _handleDeviceOrientation: function(event, data) {
            console.log('appcontroller: _handleDeviceOrientation');

            // Change layout only if orientation actually changed.
            var orientationData = this.options.orientationData;

            if (data.orientation !== orientationData.orientation) {
                orientationData = data;
            }

            this._resize({}, orientationData);
        },

        _handleOpentopic: function(event, data) {
            console.log('appcontroller: _handleOpentopic, data = ', data);

            // Change location hash to open provided topic.
            if (data === undefined || data.href === undefined || data.href == '') {
                return;
            }

            var hash = (data.href);
            this._setHash('#!/url=' + data.href);

            // Show topic view.
            this._makePageCurrentById('topic');
        },

        _handleSetSuggestionData: function(event, data) {
            console.log('appcontroller: _handleSetSuggestionData');

            this.options.searchRootData = data.type;
            this.options.viewControllers.searchController.setSearchData(data);
        },

        _handleCloseSearchResultPage: function(event, id) {
            console.log('appcontroller: _handleCloseSearchResultPage');
            this.options.viewControllers.searchResultController.closeSearchResultPage();
        },

        _showSearchResultPage: function(event, data) {
            console.log('appcontroller: _handleOpenSearchResult');

            var searchRootData = this.options.searchRootData;
            this.options.viewControllers.searchResultController.processingSearchResults(searchRootData, data.term);
            this._makePageCurrentById(data.id);
        },

        _backToPreviousPage: function() {
            console.log('appcontroller: _backToPreviousPage');

            this._view.backToPreviousPage();
        },

		// Show/hide main preloader.
		_togglePreloader: function() {
		    console.log('appcontroller: _togglePreloader');

            $(document.body).toggleClass('loading');
        },

        _addHashchangeHandler: function() {
            console.log('appcontroller: _addHashchangeHandler');

            // Listen to hash change.
            if ('onhashchange' in window) {
                $(window).on('hashchange', $.proxy(this._handleHashchange, this));
            } else {
                setInterval(this._checkHash, 400);
            }
        },

        _handleHashchange: function(event, data) {
            console.log('appcontroller: _handleHashchange');
            var newHash = location.hash;
            this._processHash(newHash);
        },

        _checkHash: function() {
            console.log('appcontroller: _checkHash');

        },

        _processHash: function(hash) {
            console.log('appcontroller: _processHash, ', hash);

            if (!hash || hash == '') {
                // Load default topic.
                this._handleOpentopic({}, {
                    href: this.options.config.defaultPage
                });
            }

            // If hash starts with hashbang, crop it off.
            var url = this._fetchUrlFromHash(hash);

            if (!url || url == '') {
                // Do nothing.
                return;
            }

            this._processUrl(url);
        },

        _fetchUrlFromHash: function(hash) {
            console.log('appcontroller: _fetchUrlFromHash');

            var url = '';

            if (hash.indexOf('#!') == 0) {
                url = hash.substring(2);
            } else if (hash[0] == '#') {
                url = hash.substring(1);
            } else {
                url = hash;
            }

            return url;
        },

        _processUrl: function(url) {
            console.log('appcontroller: _processUrl: ', url);

            if (url.indexOf('/url=') == 0) {
                // Resolve internal path.
                this._resolveUrl(url);
            }
        },

        _resolveUrl: function(url) {
            console.log('appcontroller: _resolveUrl: ', url);

            var href = url.substring('/url='.length);

            if (!href || href == '') {
                return;
            }

            // Load topic content.
            this.options.viewControllers.topicController.openTopic({
                href: href
            });
        },

        _setHash: function(hash) {
            console.log('appcontroller: _setHash: ', hash);

            if (!hash || hash == '') {
                return;
            }

            if (hash[0] != '#') {
                return;
            }

            location.hash = hash;
        }

        /* Public members. */

    });
})(jQuery, ADSK.UTILS);
// SIG // Begin signature block
// SIG // MIIZfQYJKoZIhvcNAQcCoIIZbjCCGWoCAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // Iz1aignHDnQA974JiYxcq+jF0KqI4UxpXcfE9kK3aKug
// SIG // ggoaMIIEyzCCA7OgAwIBAgIQCQja65wGHi65un4mqmKH
// SIG // ijANBgkqhkiG9w0BAQsFADCBhDELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTUw
// SIG // MwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
// SIG // b2RlIFNpZ25pbmcgQ0EgLSBHMjAeFw0xOTA1MTQwMDAw
// SIG // MDBaFw0yMDA1MTMyMzU5NTlaMHwxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIDApDYWxpZm9ybmlhMRMwEQYDVQQHDApT
// SIG // YW4gUmFmYWVsMRcwFQYDVQQKDA5BdXRvZGVzaywgSW5j
// SIG // LjERMA8GA1UECwwIU2VjdXJpdHkxFzAVBgNVBAMMDkF1
// SIG // dG9kZXNrLCBJbmMuMIIBIjANBgkqhkiG9w0BAQEFAAOC
// SIG // AQ8AMIIBCgKCAQEAkVKRoPYsoxPdlabspcuG8HYDfcWQ
// SIG // 9qyPOT2punwpVdjt2slktcpSTlydrGy8ijcbl5/k8AOJ
// SIG // afKMQvow0fNjIoNB5nsb8j2xFJPbBhHl8GT4P6DZ1OWK
// SIG // ioiUXgGHKjctUws49J4elntqvBYhKCbuPqG772QCoYFU
// SIG // P7qcFbh3PbyNB6cnKMn2vNGRqiEtV2aGg+/MiL3QPsvT
// SIG // kTWhVuTLIvwZ4kK5C5ACiQzlGOlE+C7gWuFoxtvy6gUa
// SIG // A8JAq/xLjYKwFevQwGncg3s1cuiGhx0P7Rvn6oCd2cem
// SIG // FmbK3I3rMRt+jc9wzAj3oHxvCo4f5Lfva+OpC1dETUVV
// SIG // sk0VGwIDAQABo4IBPjCCATowCQYDVR0TBAIwADAOBgNV
// SIG // HQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMw
// SIG // YQYDVR0gBFowWDBWBgZngQwBBAEwTDAjBggrBgEFBQcC
// SIG // ARYXaHR0cHM6Ly9kLnN5bWNiLmNvbS9jcHMwJQYIKwYB
// SIG // BQUHAgIwGQwXaHR0cHM6Ly9kLnN5bWNiLmNvbS9ycGEw
// SIG // HwYDVR0jBBgwFoAU1MAGIknrOUvdk+JcobhHdglyA1gw
// SIG // KwYDVR0fBCQwIjAgoB6gHIYaaHR0cDovL3JiLnN5bWNi
// SIG // LmNvbS9yYi5jcmwwVwYIKwYBBQUHAQEESzBJMB8GCCsG
// SIG // AQUFBzABhhNodHRwOi8vcmIuc3ltY2QuY29tMCYGCCsG
// SIG // AQUFBzAChhpodHRwOi8vcmIuc3ltY2IuY29tL3JiLmNy
// SIG // dDANBgkqhkiG9w0BAQsFAAOCAQEA0Q2+iVSEfT4xGq3A
// SIG // OADVb0rT5Z8E+PPb1x6hKknSzuaZKk/acDz9mdnFajaU
// SIG // WgIKiFJlsqJnuAM1w4lqKaEWsz3DoxvGIEwexj71Ud6a
// SIG // KlBJNcR9DdkXUZwMhbw9d78rjJAIX6tOwfSludZfdq8b
// SIG // YEkuIzQi9uYW9vHVPSCzhnUBKjwc9qTo9yBc7Fcn4FAT
// SIG // 90DzWM2hS9oc3p0pprYI2I/O4th90BEmwWkVqVgfaR0z
// SIG // VyIEmBbqB/IWLfjUBZJ/8sbkwWuWlYVRrfPxsj1e9qvb
// SIG // wE3Y28jWyGbqoUG39GhXk3uT8R8i3+T6M0c4rMfdifBC
// SIG // pceCaFTJzSye7LoeVzCCBUcwggQvoAMCAQICEHwbNTVK
// SIG // 59t050FfEWnKa6gwDQYJKoZIhvcNAQELBQAwgb0xCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjEfMB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29y
// SIG // azE6MDgGA1UECxMxKGMpIDIwMDggVmVyaVNpZ24sIElu
// SIG // Yy4gLSBGb3IgYXV0aG9yaXplZCB1c2Ugb25seTE4MDYG
// SIG // A1UEAxMvVmVyaVNpZ24gVW5pdmVyc2FsIFJvb3QgQ2Vy
// SIG // dGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMTQwNzIyMDAw
// SIG // MDAwWhcNMjQwNzIxMjM1OTU5WjCBhDELMAkGA1UEBhMC
// SIG // VVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9u
// SIG // MR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3Jr
// SIG // MTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1
// SIG // NiBDb2RlIFNpZ25pbmcgQ0EgLSBHMjCCASIwDQYJKoZI
// SIG // hvcNAQEBBQADggEPADCCAQoCggEBANeVQ9Tc32euOftS
// SIG // pLYmMQRw6beOWyq6N2k1lY+7wDDnhthzu9/r0XY/ilaO
// SIG // 6y1L8FcYTrGNpTPTC3Uj1Wp5J92j0/cOh2W13q0c8fU1
// SIG // tCJRryKhwV1LkH/AWU6rnXmpAtceSbE7TYf+wnirv+9S
// SIG // rpyvCNk55ZpRPmlfMBBOcWNsWOHwIDMbD3S+W8sS4duM
// SIG // xICUcrv2RZqewSUL+6McntimCXBx7MBHTI99w94Zzj7u
// SIG // BHKOF9P/8LIFMhlM07Acn/6leCBCcEGwJoxvAMg6ABFB
// SIG // ekGwp4qRBKCZePR3tPNgKuZsUAS3FGD/DVH0qIuE/iHa
// SIG // XF599Sl5T7BEdG9tcv8CAwEAAaOCAXgwggF0MC4GCCsG
// SIG // AQUFBwEBBCIwIDAeBggrBgEFBQcwAYYSaHR0cDovL3Mu
// SIG // c3ltY2QuY29tMBIGA1UdEwEB/wQIMAYBAf8CAQAwZgYD
// SIG // VR0gBF8wXTBbBgtghkgBhvhFAQcXAzBMMCMGCCsGAQUF
// SIG // BwIBFhdodHRwczovL2Quc3ltY2IuY29tL2NwczAlBggr
// SIG // BgEFBQcCAjAZGhdodHRwczovL2Quc3ltY2IuY29tL3Jw
// SIG // YTA2BgNVHR8ELzAtMCugKaAnhiVodHRwOi8vcy5zeW1j
// SIG // Yi5jb20vdW5pdmVyc2FsLXJvb3QuY3JsMBMGA1UdJQQM
// SIG // MAoGCCsGAQUFBwMDMA4GA1UdDwEB/wQEAwIBBjApBgNV
// SIG // HREEIjAgpB4wHDEaMBgGA1UEAxMRU3ltYW50ZWNQS0kt
// SIG // MS03MjQwHQYDVR0OBBYEFNTABiJJ6zlL3ZPiXKG4R3YJ
// SIG // cgNYMB8GA1UdIwQYMBaAFLZ3+mlIR59TEtXC6gcydgfR
// SIG // lwcZMA0GCSqGSIb3DQEBCwUAA4IBAQB/68qn6ot2Qus+
// SIG // jiBUMOO3udz6SD4Wxw9FlRDNJ4ajZvMC7XH4qsJVl5Fw
// SIG // g/lSflJpPMnx4JRGgBi7odSkVqbzHQCR1YbzSIfgy8Q0
// SIG // aCBetMv5Be2cr3BTJ7noPn5RoGlxi9xR7YA6JTKfRK9u
// SIG // QyjTIXW7l9iLi4z+qQRGBIX3FZxLEY3ELBf+1W5/muJW
// SIG // kvGWs60t+fTf2omZzrI4RMD3R3vKJbn6Kmgzm1By3qif
// SIG // 1M0sCzS9izB4QOCNjicbkG8avggVgV3rL+JR51EeyXgp
// SIG // 5x5lvzjvAUoBCSQOFsQUecFBNzTQPZFSlJ3haO8I8OJp
// SIG // nGdukAsak3HUJgLDwFojMYIOuzCCDrcCAQEwgZkwgYQx
// SIG // CzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRlYyBD
// SIG // b3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1
// SIG // c3QgTmV0d29yazE1MDMGA1UEAxMsU3ltYW50ZWMgQ2xh
// SIG // c3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENBIC0gRzIC
// SIG // EAkI2uucBh4uubp+Jqpih4owDQYJYIZIAWUDBAIBBQCg
// SIG // fDAQBgorBgEEAYI3AgEMMQIwADAZBgkqhkiG9w0BCQMx
// SIG // DAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4wDAYK
// SIG // KwYBBAGCNwIBFTAvBgkqhkiG9w0BCQQxIgQgJ8cszcCx
// SIG // CA6ZgFLP1U7j1wgpOU37ZUM5oIg+VVT8dXswDQYJKoZI
// SIG // hvcNAQEBBQAEggEAZ44g1xMvetTBuyS3v9OPe0ZHsKnh
// SIG // vurphtVAUFUhThhksRgJ4oTntiXX8FxE0wDlybrlaMEK
// SIG // zB2ZMFZtorKCJ4iiQRmoQsOyFUtAN5V/5XPU2D5W2jED
// SIG // kiJbUxE+7Avabi5cfo/rAnkjtLp/QatXeSJvaaxjZGSX
// SIG // pPBi54PKpjsUzVt3mMaxg8I5LCgrHR6Ds5+gAGS+yq4r
// SIG // pbtryWYd487fSxw4t9jqm9fkV3lxoCcuVnTcxQv3T7Rc
// SIG // HvfX93uvK21Yj4sLrEV08OL6hHlMUeJ9Q9ZLtLQrMtZ7
// SIG // mmeQv9lDERJsv1bHTL/kbRh4CKSEoVSIry2K5aDeiLS5
// SIG // Rv5aRqGCDHQwggxwBgorBgEEAYI3AwMBMYIMYDCCDFwG
// SIG // CSqGSIb3DQEHAqCCDE0wggxJAgEDMQ8wDQYJYIZIAWUD
// SIG // BAIBBQAwga8GCyqGSIb3DQEJEAEEoIGfBIGcMIGZAgEB
// SIG // BgkrBgEEAaAyAgMwMTANBglghkgBZQMEAgEFAAQgDswM
// SIG // WNjvFWqQArZoDdggXCE2JYwwiP2N7dxsHv1lUVICFDXf
// SIG // MSYd33bY9iHPvMDQpau/7q5EGA8yMDIwMDIwNzE2MTcy
// SIG // MVqgL6QtMCsxKTAnBgNVBAMMIEdsb2JhbFNpZ24gVFNB
// SIG // IGZvciBBZHZhbmNlZCAtIEcyoIII0zCCBLYwggOeoAMC
// SIG // AQICDAynz10HBySsieeaOjANBgkqhkiG9w0BAQsFADBb
// SIG // MQswCQYDVQQGEwJCRTEZMBcGA1UEChMQR2xvYmFsU2ln
// SIG // biBudi1zYTExMC8GA1UEAxMoR2xvYmFsU2lnbiBUaW1l
// SIG // c3RhbXBpbmcgQ0EgLSBTSEEyNTYgLSBHMjAeFw0xODAy
// SIG // MTkwMDAwMDBaFw0yOTAzMTgxMDAwMDBaMCsxKTAnBgNV
// SIG // BAMMIEdsb2JhbFNpZ24gVFNBIGZvciBBZHZhbmNlZCAt
// SIG // IEcyMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKC
// SIG // AQEAt8eSiijY85HLUA1d6ylEwYJZpcpkzr2DtVHllMxu
// SIG // gJoXbNz/YuY2Q14Bwgxkjcp3nvZdd0W5Xsgk60E3EWY3
// SIG // rMjNdJvMs+9M4n8bznO+yZadNR5891T3bOygEtaumZ1j
// SIG // xHhfWakuIvXDJ9iyW0VjJ5D/jLE9qbTzDsDxIGUGiZ0D
// SIG // HKOwUkGFNOu8y85U9hL+swGJSqb6VMUf+9McwOO/l+M/
// SIG // 0Bv5QMcb1esmfEMwx3DyeBGqhU6lDg0ASjoRd6PKIwGA
// SIG // nsiTVl1GzIrY0qoKhIWyiVvVMs5BexhOVMqr0VJeEtMk
// SIG // nlbzDI/dvZKOedVBicOjoOWR/MdnnYczznEycwIDAQAB
// SIG // o4IBqDCCAaQwDgYDVR0PAQH/BAQDAgeAMEwGA1UdIARF
// SIG // MEMwQQYJKwYBBAGgMgEeMDQwMgYIKwYBBQUHAgEWJmh0
// SIG // dHBzOi8vd3d3Lmdsb2JhbHNpZ24uY29tL3JlcG9zaXRv
// SIG // cnkvMAkGA1UdEwQCMAAwFgYDVR0lAQH/BAwwCgYIKwYB
// SIG // BQUHAwgwRgYDVR0fBD8wPTA7oDmgN4Y1aHR0cDovL2Ny
// SIG // bC5nbG9iYWxzaWduLmNvbS9ncy9nc3RpbWVzdGFtcGlu
// SIG // Z3NoYTJnMi5jcmwwgZgGCCsGAQUFBwEBBIGLMIGIMEgG
// SIG // CCsGAQUFBzAChjxodHRwOi8vc2VjdXJlLmdsb2JhbHNp
// SIG // Z24uY29tL2NhY2VydC9nc3RpbWVzdGFtcGluZ3NoYTJn
// SIG // Mi5jcnQwPAYIKwYBBQUHMAGGMGh0dHA6Ly9vY3NwMi5n
// SIG // bG9iYWxzaWduLmNvbS9nc3RpbWVzdGFtcGluZ3NoYTJn
// SIG // MjAdBgNVHQ4EFgQULW5u0Y3lA4Du52Ppp9naCzxXIj0w
// SIG // HwYDVR0jBBgwFoAUkiGnSpVdZLCbtB7mADdH5p1BK0ww
// SIG // DQYJKoZIhvcNAQELBQADggEBAI39HR+PiNNl+LVcRumn
// SIG // 07Y/SstDBcIHDcNeA4QjN6h6jJcj/yechH1h61xLVz6b
// SIG // 9ETbgFj3tmXejxIKX6eHdLfaFECHUeyfSkdV8BfoGD5x
// SIG // IDHmKCKrTvaunGvC50T7aA0gf1M/lBuhhoJOMhYQWj+J
// SIG // WMHQtNu2kPuNMumhS0ZQN7bDOukpJBKSWk4rubYKejaM
// SIG // l8DviXwz3jHhoZfk50WtYVL9WonTVH6KTVuJew6Wd9Hy
// SIG // PDgb2vmlYSBlArzFrdcMYhAoLN2246hhAKwIJqONhdBk
// SIG // yTaQHopSyYeNNaVdSJH8k6alZfHs+TrcpSyeBG1iM/7e
// SIG // +p/Fzq+V81Go8s4wggQVMIIC/aADAgECAgsEAAAAAAEx
// SIG // icZQBDANBgkqhkiG9w0BAQsFADBMMSAwHgYDVQQLExdH
// SIG // bG9iYWxTaWduIFJvb3QgQ0EgLSBSMzETMBEGA1UEChMK
// SIG // R2xvYmFsU2lnbjETMBEGA1UEAxMKR2xvYmFsU2lnbjAe
// SIG // Fw0xMTA4MDIxMDAwMDBaFw0yOTAzMjkxMDAwMDBaMFsx
// SIG // CzAJBgNVBAYTAkJFMRkwFwYDVQQKExBHbG9iYWxTaWdu
// SIG // IG52LXNhMTEwLwYDVQQDEyhHbG9iYWxTaWduIFRpbWVz
// SIG // dGFtcGluZyBDQSAtIFNIQTI1NiAtIEcyMIIBIjANBgkq
// SIG // hkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqpuOw6sRUSUB
// SIG // tpaU4k/YwQj2RiPZRcWVl1urGr/SbFfJMwYfoA/GPH5T
// SIG // SHq/nYeer+7DjEfhQuzj46FKbAwXxKbBuc1b8R5EiY7+
// SIG // C94hWBPuTcjFZwscsrPxNHaRossHbTfFoEcmAhWkkJGp
// SIG // eZ7X61edK3wi2BTX8QceeCI2a3d5r6/5f45O4bUIMf3q
// SIG // 7UtxYowj8QM5j0R5tnYDV56tLwhG3NKMvPSOdM7IaGlR
// SIG // dhGLD10kWxlUPSbMQI2CJxtZIH1Z9pOAjvgqOP1roEBl
// SIG // H1d2zFuOBE8sqNuEUBNPxtyLufjdaUyI65x7MCb8eli7
// SIG // WbwUcpKBV7d2ydiACoBuCQIDAQABo4HoMIHlMA4GA1Ud
// SIG // DwEB/wQEAwIBBjASBgNVHRMBAf8ECDAGAQH/AgEAMB0G
// SIG // A1UdDgQWBBSSIadKlV1ksJu0HuYAN0fmnUErTDBHBgNV
// SIG // HSAEQDA+MDwGBFUdIAAwNDAyBggrBgEFBQcCARYmaHR0
// SIG // cHM6Ly93d3cuZ2xvYmFsc2lnbi5jb20vcmVwb3NpdG9y
// SIG // eS8wNgYDVR0fBC8wLTAroCmgJ4YlaHR0cDovL2NybC5n
// SIG // bG9iYWxzaWduLm5ldC9yb290LXIzLmNybDAfBgNVHSME
// SIG // GDAWgBSP8Et/qC5FJK5NUPpjmove4t0bvDANBgkqhkiG
// SIG // 9w0BAQsFAAOCAQEABFaCSnzQzsm/NmbRvjWek2yX6AbO
// SIG // MRhZ+WxBX4AuwEIluBjH/NSxN8RooM8oagN0S2OXhXdh
// SIG // O9cv4/W9M6KSfREfnops7yyw9GKNNnPRFjbxvF7stICY
// SIG // ePzSdnno4SGU4B/EouGqZ9uznHPlQCLPOc7b5neVp7uy
// SIG // y/YZhp2fyNSYBbJxb051rvE9ZGo7Xk5GpipdCJLxo/Md
// SIG // dL9iDSOMXCo4ldLA1c3PiNofKLW6gWlkKrWmotVzr9xG
// SIG // 2wSukdduxZi61EfEVnSAR3hYjL7vK/3sbL/RlPe/UOB7
// SIG // 4JD9IBh4GCJdCC6MHKCX8x2ZfaOdkdMGRE4EbnocIOM2
// SIG // 8LZQuTGCAqgwggKkAgEBMGswWzELMAkGA1UEBhMCQkUx
// SIG // GTAXBgNVBAoTEEdsb2JhbFNpZ24gbnYtc2ExMTAvBgNV
// SIG // BAMTKEdsb2JhbFNpZ24gVGltZXN0YW1waW5nIENBIC0g
// SIG // U0hBMjU2IC0gRzICDAynz10HBySsieeaOjANBglghkgB
// SIG // ZQMEAgEFAKCCAQ4wGgYJKoZIhvcNAQkDMQ0GCyqGSIb3
// SIG // DQEJEAEEMBwGCSqGSIb3DQEJBTEPFw0yMDAyMDcxNjE3
// SIG // MjFaMC8GCSqGSIb3DQEJBDEiBCA5R5iQGMOW1uWBOeN1
// SIG // P/HYD0u5TD9WtwDkkQXo4kQkMzCBoAYLKoZIhvcNAQkQ
// SIG // AgwxgZAwgY0wgYowgYcEFJsSBXrnKq/21jdytJ9qI28m
// SIG // Sc2pMG8wX6RdMFsxCzAJBgNVBAYTAkJFMRkwFwYDVQQK
// SIG // ExBHbG9iYWxTaWduIG52LXNhMTEwLwYDVQQDEyhHbG9i
// SIG // YWxTaWduIFRpbWVzdGFtcGluZyBDQSAtIFNIQTI1NiAt
// SIG // IEcyAgwMp89dBwckrInnmjowDQYJKoZIhvcNAQEBBQAE
// SIG // ggEANwX5O9rAqyyyunOttys8ZQqwe/s9v13KDM01do/j
// SIG // rUJsXj8nBEGYupraFlBew+8Du6c0uatk+FsWLIWKx6fp
// SIG // 280Zw3vbeWK+mwNDeOncMGepl+/MBNXjJBTM68vUMegD
// SIG // vU6TBKw/KapCmuyimjfIo/oIW8rbi72yQg+IQn/lLPDh
// SIG // y9ELS9/X1JnMGJh2WomA155rcJ5+22ddt0Z/iLyoavCM
// SIG // WbDqJd8OYiA7JJmzgfmb4ddDerlUdDH3s02f+L2DxbH1
// SIG // KnTNf2QW/p2Pu0EgqkY16/2eh08IZ2q52FANC0CwCckS
// SIG // WmqINK9lbMbuTFKqwxU6sOgf0cLdxe6aaYOHuQ==
// SIG // End signature block
